(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1205739,      24691]*)
(*NotebookOutlinePosition[   1206388,      24714]*)
(*  CellTagsIndexPosition[   1206344,      24710]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Utilities`MemoryConserve`\n$MemoryIncrement; 
    \n<< \ LinearAlgebra`MatrixManipulation`; \n
    Off[General::spell1, MemoryConserve::start, MemoryConserve::end]; \)], 
  "Input"],

Cell[BoxData[
    \(\(sample = {
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}}; \)\)], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\)], "Input"],

Cell[BoxData[
    \(\(shiftedsample = {
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}}; \)\)], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\)], "Input"],

Cell[BoxData[
    \(\(badsample = {
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}}; \)\)], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\[FilledSquare]\
\[FilledSquare]\)], "Input"],

Cell[BoxData[
    \(\(sample2 = {{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 
          0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 
          0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 
          0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          0, \ 0, \ 0, \ 0, \ 0, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 
          0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 
          0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 
          0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 0, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 0, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ 0, \ \n0, \ 0, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 0, \ 0, \ 0, \ \n0, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}, 
        \n{1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, 
          \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 
          1, \ \n1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1, \ 1}}; \)\)], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ 128\[Times]128\ simple\)], "Input"],

Cell["\<\
SamplePhoto=ListDensityPlot[sample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Sample Photo\",
\tDisplayFunction->Identity];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\[FilledSquare]\ 0, 1\  - \ Normalization\)], "Input"],

Cell["\<\
imageNormalize=Compile[{{data2D,_Real,2}},
\t\tModule[{minimum=Min[data2D]},
\t\t\t(data2D-minimum)/Max[data2D-minimum]]];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\[FilledSquare]\ Shifted\ \ Sample\ Photo\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[shiftedsample]\)], "Input"],

Cell[BoxData[
    \({128, 128}\)], "Output"]
}, Open  ]],

Cell["\<\
ShiftedSamplePhoto=ListDensityPlot[shiftedsample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Shifted Sample Photo\",
\tDisplayFunction->Identity];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\[FilledSquare]\ Defect\ Sample\ Photo\)], "Input"],

Cell["\<\
DefectSamplePhoto=ListDensityPlot[badsample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Defect Sample Photo\",
\tDisplayFunction->Identity];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\[FilledSquare]\ Second\ Sample\ Photo\)], "Input"],

Cell["\<\
SecondSamplePhoto=ListDensityPlot[sample2,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Second Sample Photo\",
\tDisplayFunction->Identity];
\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
      GraphicsArray[{SamplePhoto, ShiftedSamplePhoto, \n\t\t
          DefectSamplePhoto, SecondSamplePhoto}]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .23256 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0055371 0.238095 [
[ 0 0 0 0 ]
[ 1 .23256 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .23256 L
0 .23256 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0055371 0.245293 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFF0000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFF00000000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FFFF
FF0000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFF000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000000000000000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
00000000000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.0055371 0.488926 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -62 0 ]
[.5 1.0125 62 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -123 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Shifted) show
111.000000 13.000000 moveto
(Sample) show
153.000000 13.000000 moveto
(Photo) show
183.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
00000000000000000000000000000000000000000000FFFF
FFFFFFFF0000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.0055371 0.732558 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -59 0 ]
[.5 1.0125 59 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -120 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Defect) show
105.000000 13.000000 moveto
(Sample) show
147.000000 13.000000 moveto
(Photo) show
177.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFF0000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFF00000000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
000000000000000000000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FFFF
FF0000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFF000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000000000000000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
00000000000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.0055371 0.97619 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -59 0 ]
[.5 1.0125 59 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -120 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Second) show
105.000000 13.000000 moveto
(Sample) show
147.000000 13.000000 moveto
(Photo) show
177.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFF0000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFF00000000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FFFF
FF0000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFF000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000000000000000000000000000000000
000000000000000000000000000000000000FFFF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000000000000000000000
0000000000000000000000000000000000FFFFFFFF000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
0000000000000000000000000000000000FFFFFFFFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
00000000000000000000000000000000FFFFFFFFFFFFFF00
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000000000000000000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{613, 142.375},
  ImageMargins->{{45, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40009U0000SQP00`40o`000?l0003ooooooooooomW
oooo003oooooooooofOoool00?ooooooooooIoooo`00oooooooooomWoooo000Woooo00<0003ooooo
ool02_ooo`<00003oooo00<0003oooooool02Oooo`<00002oooo00<0003oooooool02?ooo`800004
oooo00<0003oooooool02?ooo`030000oooooooo00;oool00`000?ooooooo`04oooo1@0000;oool0
0`000?ooooooo`02oooo00<0003oooooool00_ooo`D000001?ooo`000000000000?oool00`000?oo
ooooo`2koooo00<0003oooooool02_ooo`<00003oooo00<0003oooooool02?ooo`<00002oooo00<0
003oooooool02?ooo`800004oooo00<0003oooooool02?ooo`030000oooooooo00;oool00`000?oo
ooooo`04oooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`D000001?ooo`00
0000000000?oool00`000?ooooooo`0Yoooo00<0003oooooool02_ooo`<00003oooo00<0003ooooo
ool02?ooo`<00002oooo00<0003oooooool02?ooo`800004oooo00<0003oooooool02Oooo`030000
oooooooo00;oool00`000?ooooooo`04oooo1@0000;oool00`000?ooooooo`02oooo00@0003ooooo
ooooool5000000Coool0000000000003oooo00<0003oooooool06?ooo`009_ooo`030000oooo0000
00_oool00`000?ooooooo`02oooo00<0003oool000002oooo`060000oooooooo0000oooo00002Ooo
o`030000oooo000000;oool00`000?ooo`000008oooo00<0003oool000000_ooo`030000oooo0000
00Ooool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001Oooo`050000oooooooo
oooo000000Coool00`000?ooo`00002koooo00<0003oool000002oooo`030000oooooooo00;oool0
0`000?ooo`00000:oooo00H0003oooooool0003oool00009oooo00<0003oool000000_ooo`030000
oooo000000Soool00`000?ooo`000002oooo00<0003oool000001oooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000005oooo00D0003oooooooooool000001?ooo`030000oooo0000
02Woool00`000?ooo`00000;oooo00<0003oooooool00_ooo`030000oooo000000[oool01P000?oo
ooooo`000?ooo`0000Woool00`000?ooo`000002oooo00<0003oool000002Oooo`030000oooo0000
00;oool00`000?ooo`000007oooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00Coool01@000?ooooooooooo`000004oooo00<0003oool000006Oooo`009_ooo`030000oooo0000
00coool01`000?ooooooooooo`000?ooo`000009oooo10000004oooo0000oooo00002Oooo`030000
oooo000000;oool00`000?ooo`000008oooo00<0003oool000000_ooo`030000oooo000000Ooool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001Oooo`030000oooooooo00;oool0
1`000?ooooooooooo`000?ooo`00000Woooo00<0003oooooool02_ooo`<00003oooo00<0003ooooo
ool02?ooo`<00002oooo00<0003oooooool01oooo`800004oooo00<0003oooooool02?ooo`030000
oooooooo00;oool00`000?ooooooo`03oooo1@0000;oool00`000?ooooooo`02oooo00@0003ooooo
ooooool5000000Coool0000000000003oooo00<0003oooooool0;?ooo`030000oooo000000coool0
1`000?ooooooooooo`000?ooo`000008oooo10000004oooo0000oooo00002Oooo`030000oooo0000
00;oool00`000?ooo`000008oooo00<0003oool000000_ooo`030000oooo000000Ooool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001Oooo`030000oooooooo00;oool01`000?oo
ooooooooo`000?ooo`00000Yoooo00<0003oool000003?ooo`070000oooooooooooo0000oooo0000
00Soool4000000Coool0003oool00009oooo00<0003oool000000_ooo`030000oooo000000Woool0
0`000?ooo`000002oooo00<0003oool000001oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000004oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000001Woool0
02Koool00`000?ooo`00000<oooo00L0003oooooooooool0003oool000002Oooo`030000oooo0000
00;oool00`000?ooo`000009oooo0P0000?oool00`000?ooo`000009oooo00L0003oooooooooool0
003oool000001oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000005oooo00<0
003oooooool00_ooo`070000oooooooooooo0000oooo000002Koool00`000?ooo`00000;oooo00<0
003oooooool00_ooo`030000oooo000000[oool01P000?ooooooo`000?ooo`0000Soool00`000?oo
o`000002oooo00<0003oool000002?ooo`030000oooo000000;oool00`000?ooo`000006oooo00L0
003oooooooooool0003oool000000_ooo`030000oooo000000Coool01@000?ooooooooooo`000004
oooo00<0003oool00000;Oooo`030000oooo000000coool01`000?ooooooooooo`000?ooo`000008
oooo00<0003oool000000_ooo`030000oooo000000Woool200000oooo`030000oooo000000Woool0
1`000?ooooooooooo`000?ooo`000007oooo00L0003oooooooooool0003oool000000_ooo`030000
oooo000000Goool00`000?ooooooo`02oooo00L0003oooooooooool0003oool00000:Oooo`030000
oooo000000coool01`000?ooooooooooo`000?ooo`000008oooo00<0003oool000000_ooo`030000
oooo000000Woool200000oooo`030000oooo000000[oool01`000?ooooooooooo`000?ooo`000007
oooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`02
oooo00L0003oooooooooool0003oool000006Oooo`009_ooo`030000oooo000000_oool00`000?oo
o`000002oooo00<0003oool000002_ooo`800002oooo00<0003oool000002Oooo`030000oooooooo
00;oool00`000?ooo`000008oooo00<0003oool000000_ooo`030000oooo000000Ooool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001Oooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`00000Voooo00<0003oool000003?ooo`070000oooooooooooo0000oooo0000
00Soool4000000Coool0003oool00008oooo00<0003oool000000_ooo`030000oooo000000Soool0
0`000?ooo`000002oooo00<0003oool000001_ooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000004oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000002goool0
0`000?ooo`00000;oooo00<0003oool000000_ooo`030000oooo000000Woool200000_ooo`030000
oooo000000Woool00`000?ooooooo`02oooo00<0003oool000002?ooo`030000oooo000000;oool0
0`000?ooo`000007oooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000Goool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool00000:Oooo`030000oooo000000_oool0
0`000?ooo`000002oooo00<0003oool000002Oooo`800002oooo00<0003oool000002Oooo`030000
oooooooo00;oool00`000?ooo`000009oooo00<0003oool000000_ooo`030000oooo000000Ooool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`00000Ioooo000Woooo00<0003oooooool02oooo`030000oooooooo
00;oool00`000?ooooooo`0:oooo00D0003oooooooooool000002oooo`800003oooo00<0003ooooo
ool02?ooo`030000oooooooo00;oool00`000?ooooooo`05oooo0P0000Coool00`000?ooooooo`02
oooo00<0003oooooool00oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo02Goool0
0`000?ooo`00000<oooo00L0003oooooooooool0003oool000002?ooo`030000oooo000000;oool0
0`000?ooo`000008oooo0P0000?oool00`000?ooo`000009oooo00L0003oooooooooool0003oool0
00001_ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003ooooo
ool00_ooo`070000oooooooooooo0000oooo000002koool00`000?ooooooo`0;oooo00<0003ooooo
ool00_ooo`030000oooooooo00Woool01@000?ooooooooooo`00000;oooo0P0000?oool00`000?oo
ooooo`08oooo00<0003oooooool00_ooo`030000oooooooo00Goool200001?ooo`030000oooooooo
00;oool00`000?ooooooo`03oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool0:Ooo
o`030000oooooooo00_oool00`000?ooooooo`02oooo00<0003oooooool02Oooo`050000oooooooo
oooo000000_oool200000oooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003ooooo
ool01Oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00;oool00`000?ooooooo`0Hoooo002hoooo00<0003oool000002oooo`030000oooo0000
00;oool00`000?ooo`000009oooo0P0000;oool00`000?ooo`000008oooo00<0003oooooool00_oo
o`030000oooo000000Soool00`000?ooo`000002oooo00<0003oool000001_ooo`070000oooooooo
oooo0000oooo000000;oool00`000?ooo`000004oooo00L0003oooooooooool0003oool000000_oo
o`030000oooo00000?oooom6oooo002ioooo00<0003oooooool02oooo`030000oooooooo00;oool0
0`000?ooooooo`09oooo00D0003oooooooooool000002_ooo`800003oooo00<0003oooooool02?oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo0P0000Coool00`000?ooooooo`02oooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool00_ooo`030000oooooooo0?oooom5oooo003o
ooooooooofOoool00?ooooooooooIoooo`008Oooo`030000oooooooo00;ooom_0000/oooo`040000
ooooooooooooK`00027oool010000?ooooooooooofl0000Foooo000Poooo00<0003oool000000ooo
o`030000oooo000000ooool00`000?ooooooo`0>oooo00<0003oooooool03_ooo`030000oooooooo
00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00Koool00`000?oo
ooooo`2`oooo00<0003oool000000_ooo`030000oooo0000013oool00`000?ooooooo`0=oooo00<0
003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03_oo
o`030000oooooooo00Goool00`000?ooooooo`0Noooo00<0003oool000000_ooo`030000oooo0000
013oool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00koool00`000?oo
ooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00Goool00`000?ooooooo`0Doooo000P
oooo00<0003oool000000oooo`80001[oooo0P0001koool010000?ooooooooooof`0000Toooo00<0
003oool000000_ooo`80001/oooo00<0003oooooool07_ooo`030000oooo000000;oool20000K?oo
o`030000oooooooo01Coool0023oool00`000?ooo`000003oooo00<0003oooooool0Joooo`030000
oooooooo01_oool00`000?ooo`000002oooo00<0003oooooool0J?ooo`030000oooooooo02;oool0
0`000?ooo`000002oooo00<0003oooooool0Joooo`030000oooooooo01koool00`000?ooo`000002
oooo00<0003oooooool0Joooo`030000oooooooo01Coool0023oool00`000?ooo`000003oooo00<0
003oooooool0Joooo`030000oooooooo01_oool00`000?ooo`000002oooo0P0006Soool200009?oo
o`030000oooo000000;oool00`000?ooooooo`1[oooo00<0003oooooool07_ooo`030000oooo0000
00;oool00`000?ooooooo`1[oooo00<0003oooooool05?ooo`008Oooo`030000oooooooo00;oool0
0`000?ooooooo`1[oooo00<0003oooooool06oooo`030000oooo000000;oool00`000?ooooooo`1X
oooo00<0003oooooool08oooo`050000oooooooooooo000006goool00`000?ooooooo`0Ooooo00D0
003oooooooooool00000KOooo`030000oooooooo01Coool002Koool00`000?ooooooo`1Zoooo0P00
01goool00`000?ooo`000002oooo00<0003oooooool0J?ooo`030000oooooooo02Ooool20000K?oo
o`030000oooooooo02?oool20000K?ooo`030000oooooooo01Coool002Koool00`000?ooooooo`1[
oooo00<0003oooooool07?ooo`050000oooooooooooo000006[oool00`000?ooooooo`0Woooo00<0
003oooooool0Joooo`030000oooooooo02?oool00`000?ooooooo`1[oooo00<0003oooooool05?oo
o`009_ooo`030000oooooooo06_oool00`000?ooooooo`0Poooo0P0006Woool00`000?ooooooo`0W
oooo00<0003oooooool0Joooo`030000oooooooo02?oool00`000?ooooooo`1[oooo00<0003ooooo
ool05?ooo`009_ooo`030000oooooooo06_oool00`000?ooooooo`0Poooo00<0003oooooool0J?oo
o`030000oooooooo02Ooool00`000?ooooooo`1[oooo00<0003oooooool08oooo`030000oooooooo
06_oool00`000?ooooooo`0Doooo000Voooo00<0003oooooool0J_ooo`80000Roooo00<0003ooooo
ool0J?ooo`030000oooooooo02Ooool20000K?ooo`030000oooooooo02?oool20000K?ooo`030000
oooooooo01Coool002Koool00`000?ooooooo`1[oooo00<0003oooooool08?ooo`030000oooooooo
06Soool00`000?ooooooo`0Woooo00<0003oooooool0Joooo`030000oooooooo02?oool00`000?oo
ooooo`1[oooo00<0003oooooool05?ooo`009_ooo`030000oooooooo06_oool00`000?ooooooo`0P
oooo0P0006Woool00`000?ooooooo`0Woooo00<0003oooooool0Joooo`030000oooooooo02?oool0
0`000?ooooooo`1[oooo00<0003oooooool05?ooo`009_ooo`030000oooooooo06_oool00`000?oo
ooooo`0Poooo00<0003oooooool0J?ooo`030000oooooooo02Ooool00`000?ooooooo`1[oooo00<0
003oooooool08oooo`030000oooooooo06_oool00`000?ooooooo`0Doooo000Voooo00<0003ooooo
ool0J_ooo`80000Roooo00<0003oooooool0J?ooo`030000oooooooo02Ooool20000K?ooo`030000
oooooooo02?oool20000K?ooo`030000oooooooo01Coool002Koool00`000?ooooooo`1[oooo00<0
003oooooool08?ooo`030000oooooooo06Soool00`000?ooooooo`0Woooo00<0003oooooool0Jooo
o`030000oooooooo02?oool00`000?ooooooo`1[oooo00<0003oooooool05?ooo`009_ooo`030000
oooooooo06_oool00`000?ooooooo`0Poooo0P0006Woool00`000?ooooooo`0Woooo00<0003ooooo
ool0Joooo`030000oooooooo02?oool00`000?ooooooo`1[oooo00<0003oooooool05?ooo`006ooo
o`<00003oooo00<0003oooooool00_ooo`030000oooooooo06_oool00`000?ooooooo`0Poooo00<0
003oooooool0J?ooo`030000oooooooo01goool300000oooo`050000oooooooooooo000006goool0
0`000?ooooooo`0Ioooo0`0000?oool01@000?ooooooooooo`00001]oooo00<0003oooooool05?oo
o`006oooo`030000oooooooo00;oool00`000?ooo`000003oooo00<0003oooooool0Joooo`030000
oooooooo01Koool300000oooo`050000oooooooooooo000006[oool00`000?ooooooo`0Moooo00<0
003oooooool00_ooo`030000oooo000000;oool00`000?ooooooo`1[oooo00<0003oooooool06Ooo
o`030000oooooooo00;oool00`000?ooo`000002oooo00<0003oooooool0Joooo`030000oooooooo
01Coool001coool01`000?ooooooooooo`000?ooo`000003oooo0P0006_oool200006?ooo`030000
oooooooo00;oool00`000?ooo`000002oooo00<0003oooooool0J?ooo`030000oooooooo01koool0
1`000?ooooooooooo`000?ooo`000002oooo0P0006coool00`000?ooooooo`0Joooo00L0003ooooo
ooooool0003oool000000_ooo`800009oooo100005ooool00`000?ooooooo`0Doooo000Loooo00L0
003oooooooooool0003oool000000oooo`030000oooooooo06_oool00`000?ooooooo`0Goooo00L0
003oooooooooool0003oool000000_ooo`80001Xoooo0P00023oool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oooooool0Joooo`030000oooooooo01[oool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oooooool02Oooo`<0001Ooooo00<0003oooooool05?ooo`006oooo`030000
oooo000000;oool00`000?ooo`000003oooo00<0003oooooool0Joooo`030000oooooooo01Ooool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oooooool0J?ooo`030000oooooooo01goool0
0`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo06_oool00`000?ooooooo`0I
oooo00<0003oool000000_ooo`030000oooo000000;oool00`000?ooooooo`0:oooo0`0005koool0
0`000?ooooooo`0Doooo000Loooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?oo
ooooo`1[oooo00<0003oooooool05_ooo`030000oooo000000;oool00`000?ooo`000002oooo00<0
003oooooool0J?ooo`030000oooooooo01koool00`000?ooooooo`02oooo00D0003oooooooooool0
0000KOooo`030000oooooooo01[oool00`000?ooooooo`02oooo00D0003oooooooooool000003Ooo
o`<0001Moooo00<0003oooooool05?ooo`009_ooo`030000oooooooo06[oool200006Oooo`030000
oooooooo00;oool01@000?ooooooooooo`00001Zoooo00<0003oooooool09oooo`80001/oooo00<0
003oooooool08oooo`80000<oooo100005coool00`000?ooooooo`0Doooo000Voooo00<0003ooooo
ool0:?ooo`800011oooo00<0003oooooool08?ooo`80001Yoooo00<0003oooooool09oooo`030000
oooooooo02Soool20000@Oooo`030000oooooooo02?oool00`000?ooooooo`0<oooo100001Soool2
0000@Oooo`030000oooooooo01Coool002Koool00`000?ooooooo`0Xoooo100003ooool00`000?oo
ooooo`0Poooo00<0003oooooool0J?ooo`030000oooooooo02Ooool00`000?ooooooo`0Xoooo1000
03ooool00`000?ooooooo`0Soooo00<0003oooooool03_ooo`<0000Goooo100003ooool00`000?oo
ooooo`0Doooo000Voooo00<0003oooooool0:?ooo`H0000Uoooo00<0003oooooool05Oooo`030000
oooooooo023oool00`000?ooooooo`1Xoooo00<0003oooooool09oooo`030000oooooooo02Soool6
00009Oooo`030000oooooooo01Goool00`000?ooooooo`0Soooo00<0003oooooool03oooo`<0000F
oooo1P0002Goool00`000?ooooooo`0Eoooo00<0003oooooool05?ooo`009_ooo`030000oooooooo
02Soool800008Oooo`<0000Foooo0P0002;oool00`000?ooooooo`1Xoooo00<0003oooooool09ooo
o`80000Yoooo2000027oool300005oooo`030000oooooooo02?oool200004?ooo`@0000Eoooo2000
027oool300005oooo`030000oooooooo01Coool002Koool00`000?ooooooo`0Woooo2`0001goool6
00005_ooo`030000oooooooo023oool200008oooo`800014oooo00<0003oooooool09oooo`030000
oooooooo02Ooool;00007Oooo`H0000Foooo00<0003oooooool08oooo`030000oooooooo013oool4
00004oooo`/0000Moooo1P0001Koool00`000?ooooooo`0Doooo000Voooo00<0003oooooool09ooo
oa00000Doooo2`0001Goool00`000?ooooooo`0Poooo00<0003oooooool08_ooo`@00012oooo00<0
003oooooool09oooo`030000oooooooo02Ooool@00005?ooo`/0000Eoooo00<0003oooooool08ooo
o`030000oooooooo017oool400004_oooa00000Doooo2`0001Goool00`000?ooooooo`0Doooo000V
oooo00<0003oooooool09ooooa80000@oooo3@0001Goool00`000?ooooooo`0Poooo00<0003ooooo
ool08_ooo`P0000Ooooo100001_oool00`000?ooooooo`0Woooo00<0003oooooool09ooooa80000@
oooo3@0001Goool00`000?ooooooo`0Soooo00<0003oooooool04oooo`<0000Aoooo4P00013oool=
00005Oooo`030000oooooooo01Coool002Koool00`000?ooooooo`0Woooo500000coool?00005?oo
o`80000Roooo00<0003oooooool08Oooo`/0000Loooo1@0001_oool00`000?ooooooo`0Woooo0P00
02SooolD00003?ooo`l0000Eoooo00<0003oooooool08oooo`80000Eoooo0`00013ooolD00003?oo
o`l0000Eoooo00<0003oooooool05?ooo`009_ooo`030000oooooooo02OooolF00002?oooa80000D
oooo00<0003oooooool08?ooo`80000Roooo3@0001Ooool800006oooo`030000oooooooo02Ooool0
0`000?ooooooo`0Woooo5P0000SooolB00005?ooo`030000oooooooo02?oool00`000?ooooooo`0D
oooo100000oooolF00002?oooa80000Doooo00<0003oooooool05?ooo`007?ooo`<00002oooo00<0
003oooooool00_ooo`030000oooooooo02OooolH00001Ooooa<0000Doooo00<0003oooooool08?oo
o`030000oooooooo027oool?00005?ooo`X0000Joooo00<0003oooooool07_ooo`<00002oooo00D0
003oooooooooool00000:OoooaP00005oooo4`0001Coool00`000?ooooooo`0Joooo0`0000;oool0
1@000?ooooooooooo`00000Goooo100000kooolH00001Ooooa<0000Doooo00<0003oooooool05?oo
o`007Oooo`060000oooooooo0000oooo00000oooo`030000oooooooo02Oooola00004oooo`030000
oooooooo01Ooool300000_ooo`050000oooooooooooo000002?ooolC00003?ooo`h0000Joooo00<0
003oooooool07oooo`060000oooooooo0000oooo00000_ooo`030000oooooooo02Oooola00004ooo
o`030000oooooooo01_oool01P000?ooooooo`000?ooo`0000;oool00`000?ooooooo`0Foooo1000
00gooola00004oooo`030000oooooooo01Coool001_oool4000000Coool0003oool00003oooo0P00
02Sooola00004_ooo`80000Joooo00H0003oooooool0003oool00002oooo00<0003oooooool08Ooo
oaD00008oooo4@0001Woool00`000?ooooooo`0Moooo10000004oooo0000oooo00000_ooo`80000X
oooo<@0001?oool00`000?ooooooo`0Ioooo10000004oooo0000oooo00000_ooo`80000Ioooo0`00
00cooola00004oooo`030000oooooooo01Coool001_oool00`000?ooo`000002oooo00<0003oool0
00000oooo`030000oooooooo02Oooolb00004_ooo`030000oooooooo01Koool4000000Coool0003o
ool00002oooo0P0002;ooolG00001?oooa<0000Hoooo0P0001ooool00`000?ooo`000002oooo00<0
003oool000000_ooo`030000oooooooo02Oooolb00004_ooo`030000oooooooo01Woool00`000?oo
o`000002oooo00<0003oool000000_ooo`030000oooooooo01Woool300002ooooc80000Boooo00<0
003oooooool05?ooo`007?ooo`800002oooo00<0003oool000000oooo`030000oooooooo02Oooolb
00004_ooo`030000oooooooo01Koool00`000?ooo`000002oooo00<0003oool000000_ooo`030000
oooooooo027oool_00006?ooo`030000oooooooo01koool200000_ooo`030000oooo000000;oool0
0`000?ooooooo`0Woooo<P0001;oool00`000?ooooooo`0Joooo0P0000;oool00`000?ooo`000002
oooo00<0003oooooool06Oooo`@0000:oooo<P0001;oool00`000?ooooooo`0Doooo000Moooo00D0
003oooooooooool000001?ooo`030000oooooooo02Oooolb00004_ooo`030000oooooooo01Ooool2
00000_ooo`030000oooo000000;oool00`000?ooooooo`0Qoooo;`0001Soool00`000?ooooooo`0O
oooo00D0003oooooooooool000000oooo`030000oooooooo02Oooolb00004_ooo`030000oooooooo
01_oool01@000?ooooooooooo`000003oooo00<0003oooooool06_ooo`@00009oooo<P0001;oool0
0`000?ooooooo`0Doooo000Voooo00<0003oooooool09_oooc<0000Aoooo0P0001[oool01@000?oo
ooooooooo`000003oooo00<0003oooooool08Ooooc00000Goooo00<0003oooooool09oooo`80000W
oooo<`0001;oool00`000?ooooooo`0Soooo0P0001coool400001ooooc<0000Boooo00<0003ooooo
ool05?ooo`009_ooo`030000oooooooo02Kooold00004Oooo`030000oooooooo023oool200008_oo
oc00000Goooo00<0003oooooool09oooo`030000oooooooo02Kooold00004Oooo`030000oooooooo
02?oool00`000?ooooooo`0Moooo0`0000Kooold00004Oooo`030000oooooooo01Coool002Koool0
0`000?ooooooo`0Voooo=000017oool00`000?ooooooo`0Poooo00<0003oooooool08Ooooc00000G
oooo00<0003oooooool09oooo`030000oooooooo02Kooold00004Oooo`030000oooooooo02?oool0
0`000?ooooooo`0Noooo0`0000Gooold00004Oooo`030000oooooooo01Coool002Koool00`000?oo
ooooo`0Voooo=@00013oool00`000?ooooooo`0Poooo00<0003oooooool08?oooc40000Goooo00<0
003oooooool09oooo`030000oooooooo02Kooole00004?ooo`030000oooooooo02?oool00`000?oo
ooooo`0Noooo100000Cooole00004?ooo`030000oooooooo01Coool002Koool00`000?ooooooo`0V
oooo=@0000ooool200008_ooo`030000oooooooo023ooolb00005_ooo`030000oooooooo02Ooool2
00009oooocD0000@oooo00<0003oooooool08oooo`80000Poooo1@0000;ooole00004?ooo`030000
oooooooo01Coool002Koool00`000?ooooooo`0Uoooo=P00013oool00`000?ooooooo`0Poooo0P00
027ooolb00005_ooo`030000oooooooo02Ooool00`000?ooooooo`0Uoooo700000goool=00004?oo
o`030000oooooooo02?oool00`000?ooooooo`0Qoooo0`000003oooo0000000003@0000@oooo00<0
003oooooool05?ooo`009_ooo`030000oooooooo02Cooolg00004?ooo`030000oooooooo023oool0
0`000?ooooooo`0Poooo<`0001Goool00`000?ooooooo`0Woooo00<0003oooooool09Ooooa`0000=
oooo3@00013oool00`000?ooooooo`0Soooo00<0003oooooool08_ooocT0000@oooo00<0003ooooo
ool05?ooo`009_ooo`030000oooooooo02Cooolg00004?ooo`030000oooooooo023oool00`000?oo
ooooo`0Poooo<`0001Goool00`000?ooooooo`0Woooo00<0003oooooool09?oooad0000=oooo3@00
013oool00`000?ooooooo`0Soooo00<0003oooooool08oooocP0000@oooo00<0003oooooool05?oo
o`009_ooo`030000oooooooo02?ooolh00003oooo`80000Roooo00<0003oooooool07ooooc@0000E
oooo00<0003oooooool09oooo`80000Toooo7P0000goool=00004?ooo`030000oooooooo02?oool2
00009?ooocP0000@oooo00<0003oooooool05?ooo`009_ooo`030000oooooooo01kooolm00004?oo
o`030000oooooooo023oool200008?oooc@0000Eoooo00<0003oooooool09oooo`030000oooooooo
01kooolS00003Oooo`d0000@oooo00<0003oooooool08oooo`030000oooooooo01kooolm00004?oo
o`030000oooooooo01Coool002Koool00`000?ooooooo`0Moooo?P00013oool00`000?ooooooo`0P
oooo00<0003oooooool07_ooocD0000Eoooo00<0003oooooool09oooo`030000oooooooo01goooln
00004?ooo`030000oooooooo02?oool00`000?ooooooo`0Moooo?P00013oool00`000?ooooooo`0D
oooo000Koooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool06_oood40000@oooo00<0
003oooooool05_ooo`800004oooo00D0003oooooooooool000007?ooocT0000Eoooo00<0003ooooo
ool07Oooo`800004oooo00D0003oooooooooool000007?oood40000@oooo00<0003oooooool06Ooo
o`800004oooo00D0003oooooooooool000007?oood40000@oooo00<0003oooooool05?ooo`006ooo
o`030000oooo000000;oool00`000?ooo`000003oooo00<0003oooooool06Ooood80000@oooo00<0
003oooooool05_ooo`030000oooo000000;oool00`000?ooo`000002oooo00<0003oooooool06Ooo
ocX0000Eoooo00<0003oooooool07Oooo`030000oooo000000;oool00`000?ooo`000002oooo00<0
003oooooool06Ooood80000@oooo00<0003oooooool06Oooo`030000oooo000000;oool00`000?oo
o`000002oooo00<0003oooooool06Ooood80000@oooo00<0003oooooool05?ooo`006oooo`030000
oooo000000;oool00`000?ooo`000003oooo0P0001Sooom400003oooo`80000Hoooo00<0003oool0
00000_ooo`030000oooo000000;oool200006?oooc`0000Doooo0P0001ooool00`000?ooo`000002
oooo00<0003oool000000_ooo`80000HooooA000013oool00`000?ooooooo`0Ioooo00<0003oool0
00000_ooo`030000oooo000000;oool200006?oood@0000@oooo00<0003oooooool05?ooo`006ooo
o`800003oooo00<0003oool000000oooo`030000oooooooo01?ooom800004?ooo`030000oooooooo
01Koool200000oooo`030000oooo000000;oool00`000?ooooooo`0Eoooo?P0001Goool00`000?oo
ooooo`0Moooo0P0000?oool00`000?ooo`000002oooo00<0003oooooool04oooodP0000@oooo00<0
003oooooool06Oooo`800003oooo00<0003oool000000_ooo`030000oooooooo01?ooom800004?oo
o`030000oooooooo01Coool001_oool00`000?ooooooo`02oooo00<0003oool000000oooo`030000
oooooooo017ooom:00004?ooo`030000oooooooo01Koool00`000?ooooooo`02oooo00<0003oool0
00000_ooo`030000oooooooo017ooom200005Oooo`030000oooooooo01goool00`000?ooooooo`02
oooo00<0003oool000000_ooo`030000oooooooo017ooom:00004?ooo`030000oooooooo01Woool0
0`000?ooooooo`02oooo00<0003oool000000_ooo`030000oooooooo017ooom:00004?ooo`030000
oooooooo01Coool001coool200000oooo`030000oooooooo00;oool00`000?ooooooo`0?ooooC000
013oool00`000?ooooooo`0Goooo0P0000?oool01@000?ooooooooooo`00000AooooA00001Goool0
0`000?ooooooo`0Noooo0P0000?oool01@000?ooooooooooo`00000AooooC000013oool00`000?oo
ooooo`0Joooo0P0000?oool01@000?ooooooooooo`00000AooooC000013oool00`000?ooooooo`0D
oooo000Voooo00<0003oooooool04?oood/0000?oooo0P0002;oool200003_ooodH0000Eoooo00<0
003oooooool09oooo`80000AooooB`00013oool00`000?ooooooo`0Soooo0P00017ooom;00004?oo
o`030000oooooooo01Coool002Koool00`000?ooooooo`0@ooooB`00013oool00`000?ooooooo`0P
oooo00<0003oooooool02_ooodT0000Eoooo00<0003oooooool09oooo`030000oooooooo013ooom;
00004?ooo`030000oooooooo02?oool00`000?ooooooo`0@ooooB`00013oool00`000?ooooooo`0D
oooo000Voooo00<0003oooooool04OooodX0000@oooo00<0003oooooool08?ooo`030000oooooooo
00_ooom800005Oooo`030000oooooooo02Ooool00`000?ooooooo`0AooooBP00013oool00`000?oo
ooooo`0Soooo00<0003oooooool04OooodX0000@oooo00<0003oooooool05?ooo`009_ooo`030000
oooooooo01;ooom900004?ooo`030000oooooooo023oool00`000?ooooooo`0;ooooB00001Goool0
0`000?ooooooo`0Woooo00<0003oooooool04_ooodT0000@oooo00<0003oooooool08oooo`030000
oooooooo01;ooom900004?ooo`030000oooooooo01Coool002Koool00`000?ooooooo`0Coooo9P00
00;ooolP00003oooo`80000Roooo0P0000gooom700005Oooo`030000oooooooo02Ooool200005?oo
obH00002oooo8000013oool00`000?ooooooo`0Soooo0P0001CooolV00000_ooob00000@oooo00<0
003oooooool05?ooo`009_ooo`030000oooooooo01?ooolV00001ooooa/0000@oooo00<0003ooooo
ool08?ooo`030000oooooooo00gooom600005Oooo`030000oooooooo02Ooool00`000?ooooooo`0C
oooo9P0000OooolK00004?ooo`030000oooooooo02?oool00`000?ooooooo`0Coooo9P0000OooolK
00004?ooo`030000oooooooo01Coool002Koool00`000?ooooooo`0Doooo900000cooolG00004?oo
o`030000oooooooo023oool00`000?ooooooo`0=oooo9@0000;ooolO00005Oooo`030000oooooooo
02Ooool00`000?ooooooo`0Doooo900000cooolG00004?ooo`030000oooooooo02?oool00`000?oo
ooooo`0Doooo900000cooolG00004?ooo`030000oooooooo01Coool002Koool00`000?ooooooo`0D
oooo9000017ooolB00004?ooo`030000oooooooo023oool00`000?ooooooo`0=oooo9@0000KooolK
00005Oooo`030000oooooooo02Ooool00`000?ooooooo`0Doooo8`0001;ooolB00004?ooo`030000
oooooooo02?oool00`000?ooooooo`0Doooo9000017ooolB00004?ooo`030000oooooooo01Coool0
02Koool00`000?ooooooo`0Eoooo8P0001[oool:00003oooo`80000Roooo0P0000oooolT00002_oo
oaL0000Eoooo00<0003oooooool09oooo`80000Foooo8P0001[oool:00004?ooo`030000oooooooo
02?oool200005_ooob@0000Hoooo2P00013oool00`000?ooooooo`0Doooo000Voooo00<0003ooooo
ool05_ooob40000Noooo1P00013oool00`000?ooooooo`0Poooo00<0003oooooool03oooob80000@
oooo4P0001Goool00`000?ooooooo`0Woooo00<0003oooooool05_ooob40000Noooo1P00013oool0
0`000?ooooooo`0Soooo00<0003oooooool05_ooob@0000Koooo1P00013oool00`000?ooooooo`0D
oooo000Loooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`0Foooo8000
02?oool200004?ooo`030000oooooooo01Ooool00`000?ooooooo`02oooo00D0003oooooooooool0
00004_ooob00000Ioooo2P0001Goool00`000?ooooooo`0Noooo00<0003oooooool00_ooo`050000
oooooooooooo000001SooolP00008oooo`80000@oooo00<0003oooooool06_ooo`030000oooooooo
00;oool01@000?ooooooooooo`00000Hoooo80000003oooo000000000080000Noooo0P00013oool0
0`000?ooooooo`0Doooo000Koooo00<0003oool000000_ooo`030000oooo000000?oool00`000?oo
ooooo`0Goooo7P0003Koool00`000?ooooooo`0Foooo00<0003oool000000_ooo`030000oooo0000
00;oool00`000?ooooooo`0Aoooo7`0001goool600005Oooo`030000oooooooo01goool00`000?oo
o`000002oooo00<0003oool000000_ooo`030000oooooooo01OooolN0000=_ooo`030000oooooooo
01Woool00`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo01OooolN00000ooo
o`@0000_oooo00<0003oooooool05?ooo`006oooo`030000oooo000000;oool00`000?ooo`000003
oooo0P0001WooolM0000=Oooo`80000Hoooo00<0003oool000000_ooo`030000oooo000000;oool2
00004_oooah0000Roooo0P0001Coool200007oooo`030000oooo000000;oool00`000?ooo`000002
oooo0P0001WooolM0000=_ooo`030000oooooooo01Woool00`000?ooo`000002oooo00<0003oool0
00000_ooo`80000Ioooo7@0000Coool40000;_ooo`030000oooooooo01Coool001coool01`000?oo
ooooooooo`000?ooo`000003oooo00<0003oooooool06OoooaX0000hoooo00<0003oooooool05ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooooooo`0Aoooo7@0003[oool00`000?oo
ooooo`0Noooo00L0003oooooooooool0003oool000000_ooo`030000oooooooo01WooolJ0000>?oo
o`030000oooooooo01[oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oooooool06Ooo
oaX00008oooo0`0002goool00`000?ooooooo`0Doooo000Koooo00<0003oool000000_ooo`030000
oooo000000?oool00`000?ooooooo`0Ioooo6P0003Soool00`000?ooooooo`0Foooo00<0003oool0
00000_ooo`030000oooo000000;oool00`000?ooooooo`0Boooo700003[oool00`000?ooooooo`0M
oooo00<0003oool000000_ooo`030000oooo000000;oool00`000?ooooooo`0Ioooo6P0003Soool0
0`000?ooooooo`0Ioooo00<0003oool000000_ooo`030000oooo000000;oool00`000?ooooooo`0I
oooo6P0000Soool40000;?ooo`030000oooooooo01Coool001coool00`000?ooooooo`02oooo00<0
003oooooool00_ooo`030000oooooooo01WooolI0000>Oooo`030000oooooooo01Ooool00`000?oo
ooooo`02oooo00D0003oooooooooool000005OoooaX0000koooo00<0003oooooool07_ooo`030000
oooooooo00;oool01@000?ooooooooooo`00000Koooo6@0003Woool00`000?ooooooo`0Joooo00<0
003oooooool00_ooo`050000oooooooooooo000001_ooolI00002_ooo`@0000[oooo00<0003ooooo
ool05?ooo`009_ooo`030000oooooooo01[ooolH0000>?ooo`80000Roooo0P0001GooolI0000>ooo
o`030000oooooooo02Ooool200006ooooaP0000ioooo00<0003oooooool08oooo`80000Koooo6000
00_oool40000:_ooo`030000oooooooo01Coool002Koool00`000?ooooooo`0Koooo5P0003[oool0
0`000?ooooooo`0Poooo00<0003oooooool05?oooaP0000loooo00<0003oooooool09oooo`030000
oooooooo01_ooolF0000>_ooo`030000oooooooo02?oool00`000?ooooooo`0Koooo5P0000koool3
0000:Oooo`030000oooooooo01Coool002Koool00`000?ooooooo`0Loooo500003_oool00`000?oo
ooooo`0Poooo00<0003oooooool05OoooaH0000moooo00<0003oooooool09oooo`030000oooooooo
01cooolD0000>oooo`030000oooooooo02?oool00`000?ooooooo`0Loooo5000013oool30000:?oo
o`030000oooooooo01Coool002Koool00`000?ooooooo`0Loooo500003_oool00`000?ooooooo`0P
oooo00<0003oooooool05OoooaD0000noooo00<0003oooooool09oooo`030000oooooooo01cooolD
0000>oooo`030000oooooooo02?oool00`000?ooooooo`0Loooo5000013oool400009oooo`030000
oooooooo01Coool002Koool00`000?ooooooo`0Moooo4P0003_oool200008_ooo`80000Goooo5000
03koool00`000?ooooooo`0Woooo0P0001kooolB0000??ooo`030000oooooooo02?oool200007_oo
oa80000Boooo100002Koool00`000?ooooooo`0Doooo000Voooo00<0003oooooool07_oooa40000l
oooo00<0003oooooool08?ooo`030000oooooooo01KooolD0000?_ooo`030000oooooooo02Ooool0
0`000?ooooooo`0Noooo4@0003coool00`000?ooooooo`0Soooo00<0003oooooool07_oooa40000C
oooo100002Goool00`000?ooooooo`0Doooo000Voooo00<0003oooooool07_ooo`l0000noooo00<0
003oooooool08?ooo`030000oooooooo01SooolA0000?oooo`030000oooooooo02Ooool00`000?oo
ooooo`0Noooo3`0003koool00`000?ooooooo`0Soooo00<0003oooooool07_ooo`l0000Goooo0`00
02Coool00`000?ooooooo`0Doooo000Voooo00<0003oooooool07oooo`h0000noooo00<0003ooooo
ool08?ooo`030000oooooooo01Soool@0000@?ooo`030000oooooooo02Ooool00`000?ooooooo`0O
oooo3P0003koool00`000?ooooooo`0Soooo00<0003oooooool07oooo`h0000Goooo100002?oool0
0`000?ooooooo`0Doooo000Voooo00<0003oooooool07oooo`h0000noooo00<0003oooooool08?oo
o`80000Joooo3P00047oool00`000?ooooooo`0Woooo00<0003oooooool07oooo`h0000noooo00<0
003oooooool08oooo`030000oooooooo01ooool>00006?ooo`@0000Roooo00<0003oooooool05?oo
o`009_ooo`030000oooooooo023oool<0000?_ooo`80000Roooo00<0003oooooool06Oooo`h00011
oooo00<0003oooooool09oooo`80000Qoooo300003ooool00`000?ooooooo`0Soooo0P00027oool<
00006_ooo`@0000Qoooo00<0003oooooool05?ooo`009_ooo`030000oooooooo027oool;0000?ooo
o`030000oooooooo013oool500000_ooo`030000oooooooo00;oool01@000?ooooooooooo`00000L
oooo300004;oool00`000?ooooooo`0Woooo00<0003oooooool08Oooo`/0000ooooo00<0003ooooo
ool08oooo`030000oooooooo027oool;00006oooo`@0000Poooo00<0003oooooool05?ooo`005Ooo
o`D00002oooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`0Roooo2000
047oool00`000?ooooooo`0Boooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00;oool00`000?ooooooo`0Koooo2`0004;oool00`000?ooooooo`0Goooo1@0000;oool00`000?oo
ooooo`02oooo00D0003oooooooooool000009?ooo`P00011oooo00<0003oooooool04oooo`D00002
oooo00<0003oooooool00_ooo`050000oooooooooooo000002Coool800007oooo`<0000Ooooo00<0
003oooooool05?ooo`005oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000003
oooo00<0003oooooool08_ooo`P00011oooo00<0003oooooool04_ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000002oooo0P0001coool:0000@_ooo`80000Koooo00L0003ooooo
ooooool0003oool000000_ooo`030000oooo000000;oool00`000?ooooooo`0Roooo2000047oool0
0`000?ooooooo`0Eoooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000;oool0
0`000?ooooooo`0Roooo200001ooool300007oooo`030000oooooooo01Coool001Ooool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000000oooo`80000Toooo1P00047oool200005?oo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`000002oooo00<0003oooooool07?oo
o`P00014oooo00<0003oooooool06Oooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`000002oooo0P0002Coool60000@_ooo`030000oooooooo01Goool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oool000000_ooo`80000Toooo1P00027oool00`000?ooooooo`0Noooo00<0
003oooooool05?ooo`005oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000003
oooo00<0003oooooool08oooo`H00012oooo00<0003oooooool04_ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000002oooo00<0003oooooool07Oooo`H00015oooo00<0003ooooo
ool06Oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000002oooo00<0003ooooo
ool08oooo`H00012oooo00<0003oooooool05Oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000002oooo00<0003oooooool08oooo`H00012oooo00<0003oooooool05?ooo`005ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`000003oooo00<0003oooooool08ooo
o`D00013oooo00<0003oooooool04Oooo`800004oooo00<0003oooooool00_ooo`050000oooooooo
oooo000001ooool60000AOooo`030000oooooooo01Woool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oool000000_ooo`030000oooooooo02?oool50000@oooo`030000oooooooo01Goool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo02?oool5
0000@oooo`030000oooooooo01Coool001Koool200001?ooo`030000oooooooo00;oool00`000?oo
ooooo`02oooo00<0003oooooool0Joooo`030000oooooooo023oool200007_ooo`D00016oooo00<0
003oooooool06?ooo`800004oooo00<0003oooooool00_ooo`050000oooooooooooo000006goool0
0`000?ooooooo`0Doooo0P0000Coool00`000?ooooooo`02oooo00D0003oooooooooool00000KOoo
o`030000oooooooo01Coool002Koool00`000?ooooooo`1Zoooo0P0002;oool00`000?ooooooo`0N
oooo100004Koool00`000?ooooooo`0Woooo0P0006coool00`000?ooooooo`0Soooo0P0006coool0
0`000?ooooooo`0Doooo000Voooo00<0003oooooool0Joooo`030000oooooooo023oool00`000?oo
ooooo`1Xoooo00<0003oooooool09oooo`030000oooooooo06_oool00`000?ooooooo`0Soooo00<0
003oooooool0Joooo`030000oooooooo01Coool002Koool00`000?ooooooo`1[oooo00<0003ooooo
ool08?ooo`030000oooooooo06Soool00`000?ooooooo`0Woooo00<0003oooooool0Joooo`030000
oooooooo02?oool00`000?ooooooo`1[oooo00<0003oooooool05?ooo`009_ooo`030000oooooooo
06_oool00`000?ooooooo`0Poooo0P0006Woool00`000?ooooooo`0Woooo00<0003oooooool0Jooo
o`030000oooooooo02?oool00`000?ooooooo`1[oooo00<0003oooooool05?ooo`009_ooo`030000
oooooooo06[oool200008_ooo`030000oooooooo06Soool00`000?ooooooo`0Woooo0P0006coool0
0`000?ooooooo`0Soooo0P0006coool00`000?ooooooo`0Doooo000Voooo00<0003oooooool0Jooo
o`030000oooooooo023oool00`000?ooooooo`1Xoooo00<0003oooooool09oooo`030000oooooooo
06_oool00`000?ooooooo`0Soooo00<0003oooooool0Joooo`030000oooooooo01Coool002Koool0
0`000?ooooooo`1[oooo00<0003oooooool08?ooo`030000oooooooo06Soool00`000?ooooooo`0W
oooo00<0003oooooool0Joooo`030000oooooooo02?oool00`000?ooooooo`1[oooo00<0003ooooo
ool05?ooo`009_ooo`030000oooooooo06_oool00`000?ooooooo`0Poooo0P0006Woool00`000?oo
ooooo`0Woooo00<0003oooooool0Joooo`030000oooooooo02?oool00`000?ooooooo`1[oooo00<0
003oooooool05?ooo`009_ooo`030000oooooooo06[oool200008_ooo`030000oooooooo06Soool0
0`000?ooooooo`0Woooo0P0006coool00`000?ooooooo`0Soooo0P0006coool00`000?ooooooo`0D
oooo000Voooo00<0003oooooool0Joooo`030000oooooooo013oool5000000Coool0000000000003
oooo00D0003oooooooooool00000J_ooo`030000oooooooo02Ooool00`000?ooooooo`1[oooo00<0
003oooooool08oooo`030000oooooooo06_oool00`000?ooooooo`0Doooo000Eoooo1@000004oooo
0000000000000oooo`030000oooooooo00;oool00`000?ooooooo`1[oooo00<0003oooooool04_oo
o`050000oooooooooooo000000Coool00`000?ooo`000002oooo00<0003oooooool0J?ooo`030000
oooooooo01Ooool5000000Coool0000000000003oooo00D0003oooooooooool00000KOooo`030000
oooooooo01?oool5000000Coool0000000000003oooo00D0003oooooooooool00000KOooo`030000
oooooooo01Coool001Ooool01@000?ooooooooooo`000004oooo00<0003oool000000oooo`030000
oooooooo06_oool00`000?ooooooo`0Boooo00<0003oooooool00_ooo`070000oooooooooooo0000
oooo000000;oool20000J?ooo`80000Koooo00D0003oooooooooool000001?ooo`030000oooo0000
00;oool00`000?ooooooo`1[oooo00<0003oooooool05Oooo`050000oooooooooooo000000Coool0
0`000?ooo`000002oooo00<0003oooooool0Joooo`030000oooooooo01Coool001Ooool00`000?oo
ooooo`02oooo00L0003oooooooooool0003oool000000oooo`80001[oooo0P0001Coool00`000?oo
ooooo`02oooo00L0003oooooooooool0003oool000000_ooo`030000oooooooo06Soool00`000?oo
ooooo`0Ioooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000;oool20000K?oo
o`030000oooooooo01Goool00`000?ooooooo`02oooo00L0003oooooooooool0003oool000000_oo
o`80001/oooo00<0003oooooool05?ooo`005oooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`000003oooo00<0003oooooool0Joooo`030000oooooooo01;oool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo06Soool00`000?ooooooo`0I
oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000;oool00`000?ooooooo`1[
oooo00<0003oooooool05Oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oooooool0Joooo`030000oooooooo01Coool001Ooool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oool000000oooo`030000oooooooo06_oool00`000?ooooooo`0Aoooo0P00
00Coool00`000?ooooooo`02oooo00D0003oooooooooool00000J_ooo`030000oooooooo01Woool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo06_oool0
0`000?ooooooo`0Eoooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000;oool0
0`000?ooooooo`1[oooo00<0003oooooool05?ooo`005_ooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo00;oool00`000?ooooooo`1[oooo00<0003oooooool08?ooo`80001Yoooo00<0
003oooooool06?ooo`800004oooo00<0003oooooool00_ooo`050000oooooooooooo000006goool0
0`000?ooooooo`0Doooo0P0000Coool00`000?ooooooo`02oooo00D0003oooooooooool00000KOoo
o`030000oooooooo01Coool002Koool00`000?ooooooo`1Zoooo0P0002;oool00`000?ooooooo`1X
oooo00<0003oooooool09oooo`80001/oooo00<0003oooooool08oooo`80001/oooo00<0003ooooo
ool05?ooo`009_ooo`030000oooooooo06_oool00`000?ooooooo`0Poooo00<0003oooooool0J?oo
o`030000oooooooo02Ooool00`000?ooooooo`1[oooo00<0003oooooool08oooo`030000oooooooo
06_oool00`000?ooooooo`0Doooo000Voooo00<0003oooooool0Joooo`030000oooooooo023oool0
0`000?ooooooo`1Xoooo00<0003oooooool09oooo`030000oooooooo06_oool00`000?ooooooo`0S
oooo00<0003oooooool0Joooo`030000oooooooo01Coool002Koool00`000?ooooooo`1[oooo00<0
003oooooool08?ooof`0000Yoooo00<0003oooooool0Joooo`030000oooooooo02?oool00`000?oo
ooooo`1[oooo00<0003oooooool05?ooo`009_ooo`030000oooo000000ooool00`000?ooooooo`0>
oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00Goool20000]oooo`<0000@oooo00<0003oooooool03Oooo`030000
oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00koool0
0`000?ooooooo`05oooo00<0003oooooool08oooo`<0000@oooo00<0003oooooool03Oooo`030000
oooooooo00koool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`05oooo00<0003oooooool05?ooo`009_ooofl0002gooooK`0002Gooom_00005_oo
o`00oooooooooomWoooo003`oooo0`000?oooomcoooo003aoooo00<0003oooooool0ooooog;oool0
04Soool30000Ioooo`<000001oooo`00000000000?ooo`000?ooo`0300000_ooo`<00003oooo0P00
00?oool200000oooo`<0000>oooo0`0000;oool5000000Goool0003oool0003oool00`0000;oool3
00000oooo`80000=oooo0`0000;oool3000000Coool0003oooooool200000oooo`800003oooo0P00
063oool30000TOooo`<0001;oooo0019oooo00<0003oooooool0I_ooo`030000oooo000000;oool0
10000?ooooooo`0000;oool00`000?ooooooo`02oooo00D0003oooooooooool000000_ooo`030000
oooo000000Coool010000?ooooooo`0000koool00`000?ooo`000002oooo0`000008oooo0000oooo
0000oooo0000oooo00000_ooo`040000oooooooo00000oooo`030000oooooooo00koool00`000?oo
ooooo`02oooo00H0003oooooool0003oool00002oooo00<0003oool000000_ooo`030000oooo0000
00;oool00`000?ooooooo`1Noooo00<0003oooooool0TOooo`030000oooooooo04[oool003[oool3
00000_ooo`D000001Oooo`000?ooo`000?ooo`0300000_ooo`<00003oooo0P0000goool300000_oo
o`<000001?ooo`000?ooooooo`800003oooo0P0000?oool20000>Oooo`040000oooooooo00000_oo
o`040000oooooooo00001?ooo`050000oooooooooooo000000Coool300000_ooo`040000oooooooo
00004?ooo`030000oooooooo00;oool02@000?ooo`000?ooo`000?ooo`000?ooo`000002oooo00@0
003oooooool00003oooo0`0000koool300000_ooo`060000oooooooo0000oooo00000_ooo`030000
oooo000000Coool010000?ooooooo`0002Koool400000oooo`800002oooo0`0000?oool200000_oo
o`<00003oooo0P0000koool300000_ooo`D000001Oooo`000?ooo`000?ooo`0300000_ooo`<00003
oooo0P0000goool300000_ooo`<000001?ooo`000?ooooooo`800003oooo0P0000?oool20000:Ooo
o`<00003oooo0P0000;oool300000oooo`8000000oooo`0000000002oooo00<0003oooooool00`00
00goool300000_ooo`D000001Oooo`000?ooo`000?ooo`0300000_ooo`<00003oooo0P0000goool3
00000_ooo`<000001?ooo`000?ooooooo`800003oooo0P0000?oool200006oooo`00>_ooo`030000
oooo000000;oool3000000Soool0003oool0003oool0003oool00002oooo00@0003oooooool00003
oooo00<0003oooooool03_ooo`030000oooooooo00;oool01P000?ooooooo`000?ooo`0000;oool0
0`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo03Goool010000?oooooooooo
o`<00002oooo0P0000?oool3000000?oool0000000000P0000;oool300000oooo`<0000?oooo00<0
003oooooool00_ooo`8000001_ooo`0000000?ooo`000?ooo`@00003oooo00@0003oooooooooool3
00003_ooo`050000oooooooo0000oooo00<00003oooo0P000003oooo0000000000800003oooo0P00
02Soool01P000?ooooooo`000?ooo`0000Goool01@000?ooooooooooo`000004oooo00<0003ooooo
ool00_ooo`040000oooooooo00003Oooo`030000oooo000000;oool3000000Soool0003oool0003o
ool0003oool00002oooo00@0003oooooool00003oooo00<0003oooooool03_ooo`030000oooooooo
00;oool01P000?ooooooo`000?ooo`0000;oool00`000?ooo`000002oooo00<0003oool000000_oo
o`030000oooooooo02Koool00`000?ooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00;oool01P000?ooooooo`000?ooo`0000;oool00`000?ooo`000002oooo00<0003oooooool02ooo
o`030000oooo000000;oool3000000Soool0003oool0003oool0003oool00002oooo00@0003ooooo
ool00003oooo00<0003oooooool03_ooo`030000oooooooo00;oool01P000?ooooooo`000?ooo`00
00;oool00`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo01Soool003coool0
0`000?ooooooo`02oooo00T0003oool0003oool0003oool0003oool000000_ooo`040000oooooooo
00000oooo`<0000>oooo0`0000;oool01P000?ooooooo`000?ooo`0000;oool00`000?ooo`000004
oooo00@0003oooooool0000foooo00<0003oool000000_ooo`030000oooooooo00Soool01@000?oo
ooooooooo`00000<oooo00<0003oooooool03?ooo`030000oooo000001;oool00`000?ooooooo`0B
oooo00H0003oooooool0003oool00009oooo00<0003oooooool0;Oooo`050000oooooooo0000oooo
00<00003oooo00@0003oooooooooool300000_ooo`030000oooooooo00;oool00`000?ooooooo`0@
oooo00<0003oooooool00_ooo`090000oooo0000oooo0000oooo0000oooo000000;oool010000?oo
ooooo`0000?oool300003_ooo`<00002oooo00H0003oooooool0003oool00002oooo00<0003oool0
00001?ooo`040000oooooooo0000:_ooo`030000oooooooo00<00002oooo00<0003oooooool00_oo
o`060000oooooooo0000oooo00000_ooo`030000oooo000000;oool00`000?ooooooo`0=oooo00<0
003oooooool00_ooo`090000oooo0000oooo0000oooo0000oooo000000;oool010000?ooooooo`00
00?oool300003_ooo`<00002oooo00H0003oooooool0003oool00002oooo00<0003oool000001?oo
o`040000oooooooo00006_ooo`00>oooo`030000oooooooo00;oool2000000Koool00000003oool0
003oool400000oooo`040000oooooooooooo0`0000koool01@000?ooooooo`000?ooo`0300000ooo
o`8000000oooo`000000000200000oooo`80000goooo0`000003oooo0000000000Goool00`000?oo
ooooo`03oooo00<0003oooooool03?ooo`80000>oooo0`00017oool200004oooo`@000000oooo`00
0000000ioooo00D0003oooooool0003oool00`0000;oool300000_ooo`<00002oooo0`000003oooo
000000000080000?oooo00<0003oooooool00_ooo`8000001_ooo`0000000?ooo`000?ooo`@00003
oooo00@0003oooooooooool300003_ooo`050000oooooooo0000oooo00<00003oooo0P000003oooo
0000000000800003oooo0P0002[oool010000?ooooooooooo`<00002oooo0`0000?oool2000000?o
ool0000000000P0000?oool300003_ooo`030000oooooooo00;oool2000000Koool00000003oool0
003oool400000oooo`040000oooooooooooo0`0000koool01@000?ooooooo`000?ooo`0300000ooo
o`8000000oooo`000000000200000oooo`80000Koooo000joooo00<0003oool000004_ooo`030000
oooooooo01;oool01P000?ooooooo`000?ooo`0000Woool00`000?ooooooo`3Eoooo00@0003ooooo
ool00007oooo00<0003oooooool02oooo`030000oooooooo00koool00`000?ooo`00000Boooo00<0
003oooooool04_ooo`060000oooooooo0000oooo00002Oooo`030000oooooooo02koool00`000?oo
o`00000Ioooo00<0003oooooool02oooo`030000oooo000001;oool00`000?ooooooo`0Boooo00H0
003oooooool0003oool00009oooo00<0003oooooool08?ooo`00>_ooo`<0000Aoooo0P0001?oool4
000000?oool000000000h?ooo`@00009oooo00<0003oooooool06oooo`<0000Aoooo0P0001?oool4
000000?oool000000000>_ooo`<0000Hoooo0P0000goool300004Oooo`80000Coooo10000003oooo
0000000002coool00?ooooooooooIoooo`00oooooooooomWoooo003oooooooooofOoool00?oooooo
ooooIoooo`00oooooooooomWoooo003oooooooooofOoool00001\
\>"],
  ImageRangeCache->{{{0, 612}, {141.375, 0}} -> {-0.114158, -0.0232607, 
  0.00690902, 0.00690902}, {{16.5, 151.125}, {138, 
  3.3125}} -> {-48.9282, -19.1925, 1.20952, 1.20952}, {{164.625, 299.25}, {
  138, 3.3125}} -> {-232.316, -21.9053, 1.24896, 1.24896}, {{312.688, 
  447.313}, {138, 3.3125}} -> {-404.936, -19.1925, 1.20952, 1.20952}, {{
  460.813, 595.438}, {138, 3.3125}} -> {-584.096, -19.1925, 1.20952, 
  1.20952}}]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Correlation\)], "Input"],

Cell["\<\
corRelation=
\tCompile[{{vectorA,_Real,1},{vectorB,_Real,1}},
\t\tModule[{meanA=0.,meanB=0.,normA=0.,normB=0.,
\t\t\t\tvectorAprime={0.},vectorBprime={0.}},
\t\t\tmeanA=Apply[Plus,vectorA]/Length[vectorA];
\t\t\tmeanB=Apply[Plus,vectorB]/Length[vectorB];
\t\t\tvectorAprime=vectorA-meanA;
\t\t\tnormA=Sqrt[vectorAprime.vectorAprime];
\t\t\tvectorBprime=vectorB-meanB;
\t\t\tnormB=Sqrt[vectorBprime.vectorBprime];
\t\t\tvectorAprime.vectorBprime/(normA normB)]];\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["\:57fa\:5e95\:95a2\:6570",
        FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
        FontWeight->"Bold"]}]], "Input"],

Cell[TextData[{
  StyleBox["     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Coifman:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
coif6={{-.051429728471, .238929728471, .602859456942, 
 \t\t .272140543058,-.051429972847,-.011070271529},
 \t   {-.011070271529, .051429972847, .272140543058,
\t\t-.602859456942, .238929728471, .051429728471}}*
\t\tSqrt[2.];
coif12={{ .011587596739,-.029320137980,-.047639590310, 
 \t\t  .273021046535, .574682393857, .294867193696,
\t\t -.054085607092,-.042026480461, .016744410163, 
 \t\t  .003967883613,-.001289203356,-.000509505399},
 \t\t{-.000509505399, .001289203356, .003967883613,
 \t\t -.016744410163,-.042026480461, .054085607092,
 \t\t  .294867193696,-.574682393857, .273021046535,
\t\t  .047639590310,-.029320137980,-.011587596739}}*
\t\t Sqrt[2.];
coif18={{-.002682418671, .005503126709, .016583560479, 
\t\t -.046507764479,-.043220763560, .286503335274,
 \t\t  .561285256870, .302983571773,-.050770140755, 
\t\t -.058196250762, .024434094321, .011229240962, 
\t\t -.006369601011,-.001820458916, .000790205101,
 \t\t  .000329665174,-.000050192775,-.000024465734},
 \t\t{-.000024465734, .000050192775, .000329665174,
 \t\t -.000790205101,-.001820458916, .006369601011,
 \t\t  .011229240962,-.024434094321,-.058196250762,
 \t\t  .050770140755, .302983571773,-.561285256870,
 \t\t  .286503335274, .043220763560,-.046507764479,
 \t\t -.016583560479, .005503126709, .002682418671}}*
 \t\tSqrt[2.];
coif24={{ .000630961046,-.001152224852,-.005194524026, 
 \t\t  .011362459244, .018867235378,-.057464234429, 
\t\t -.039652648517, .293667390895, .553126452562, 
 \t\t  .307157326198,-.047112738865,-.068038127051,
 \t\t  .027813640153, .017735837438,-.010756318517,
\t\t -.004001012886, .002652665946, .000895594529,
\t\t -.000416500571,-.000183829769, .000044080354, 
 \t\t  .000022082857,-.000002304942,-.000001262175},
 \t\t{-.000001262175, .000002304942, .000022082857,
 \t\t -.000044080354,-.000183829769, .000416500571,
 \t\t  .000895594529,-.002652665946,-.004001012886,
 \t\t  .010756318517, .017735837438,-.027813640153,
 \t\t -.068038127051, .047112738865, .307157326198,
 \t\t -.553126452562, .293667390895, .039652648517,
 \t\t -.057464234429,-.018867235378, .011362459244,
 \t\t  .005194524026,-.001152224852,-.000630961046}}*
 \t\tSqrt[2.];
coif30={{-.000149963800, .000253561200, .001540245700, 
\t\t -.002941110800,-.007163781900, .016552066400, 
 \t\t  .019917804300,-.064997262800,-.036800073600,
 \t\t  .298092323500, .547505429400, .309706849000, 
\t\t -.043866050800,-.074652238900, .029195879500, 
 \t\t  .023110777000,-.013973687900,-.006480090000, 
 \t\t  .004783001400, .001720654700,-.001175822200,
\t\t -.000451227000, .000213729800, .000099377600,
\t\t -.000029232100,-.000015072000, .000002640800, 
 \t\t  .000001459300,-.000000118400,-.000000067300},
 \t\t{-.000000067300, .000000118400, .000001459300,
 \t\t -.000002640800,-.000015072000, .000029232100,
 \t\t  .000099377600,-.000213729800,-.000451227000,
 \t\t  .001175822200, .001720654700,-.004783001400,
 \t\t -.006480090000, .013973687900, .023110777000,
 \t\t -.029195879500,-.074652238900, .043866050800,
 \t\t  .309706849000,-.547505429400, .298092323500,
 \t\t  .036800073600,-.064997262800,-.019917804300,
 \t\t  .016552066400, .007163781900,-.002941110800,
 \t\t -.001540245700, .000253561200, .000149963800}}*
 \t\tSqrt[2.]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    \(\[FilledSquare]\ Wavelet\ Matrix\)], "Input"],

Cell[BoxData[
    \(n = 128; \nnPrime = 32; \)], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    \(\[FilledSquare]\ \ Wavelet\ Transform\)], "Input"],

Cell[BoxData[
    \(\(n = 128; \)\)], "Input"],

Cell[BoxData[
    \(\(w = waveletMatrix[128, coif6]; \)\)], "Input"],

Cell[BoxData[
    \(\(SampleWavelet = waveletMatrix[128, coif6] . sample . Transpose[w]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(ShiftedSampleWavelet = 
      waveletMatrix[128, coif6] . shiftedsample . Transpose[w]; \)\)], "Input"],

Cell[BoxData[
    \(\(DefectSampleWavelet = 
      waveletMatrix[128, coif6] . badsample . Transpose[w]; \)\)], "Input"],

Cell[BoxData[
    \(\(SecondSampleWavelet = 
      waveletMatrix[128, coif6] . sample2 . Transpose[w]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[DefectSampleWavelet]\)], "Input"],

Cell[BoxData[
    \({2}\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(SampleWaveletSpect = 
      ListDensityPlot[SampleWavelet, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<Sample Photo\>", \n\tDisplayFunction -> Identity]\), 
    \(ShiftedSampleWaveletSpect = 
      ListDensityPlot[ShiftedSampleWavelet, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<Shifted Sample Photo\>", \n\t
        DisplayFunction -> Identity]; \n
    DefectSampleWaveletSpect = 
      ListDensityPlot[DefectSampleWavelet, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<Defect Sample Photo\>", \n\t
        DisplayFunction -> Identity]; \n
    SecondSampleWaveletSpect = 
      ListDensityPlot[SecondSampleWavelet, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<Second Sample Photo\>", \n\t
        DisplayFunction -> Identity]; \)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
      GraphicsArray[{SampleWaveletSpect, ShiftedSampleWaveletSpect, \n\t\t
          DefectSampleWaveletSpect, SecondSampleWaveletSpect}]]; \)\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .23256 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0055371 0.238095 [
[ 0 0 0 0 ]
[ 1 .23256 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .23256 L
0 .23256 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0055371 0.245293 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFF00FF00FFFFFF00FFFF00FF0000FFFF00FFFFFF00
00FF00FF00FFB2FFA0A00000FF00FFFFFF00FF00FFFFFFFF
000000FF0000FFFFFFFF00FFA0A0A0A09393939393939393
0000000000FFFFFF00000000FFFFFF000000FFFFFF000000
000000FF0000FF00FFFF00FFFF00FF00FF0000FFFFFF00FF
9393939393939393
FFFFFFFF00FF00FFFFFF0000FF00FF00FF0000FFFF000000
000000FF00FFB200A0A0FFFF0000000000FFFFFF00000000
000000FF000000FFFFFF00FFA0A0A0A09393939393939393
FFFF0000000000FFFFFFFFFF00FFFFFFFFFFFFFF00000000
000000FF0000FF00FF0000FF0000FF00FF0000FF00FF00FF
9393939393939393
FFFFFFFFFFFFFF00FF00FFFF00FF00FF0000FF0000FFFFFF
FFFF00FFFF00B2FFA0A000000000FFFF00FFFF00FF00FF00
FFFFFFFFFFFFFF00FFFFFF00A0A0A0A09393939393939393
0000FF000000FF00FF00000000FFFF00000000FFFF000000
FF000000FFFF00FF000000FFFFFFFF00000000FFFFFFFF00
9393939393939393
FFFFFFFF0000FFFF00FF0000FF00FFFFFF000000FF000000
0000FF0000FFB200A0A0FFFF00000000FF0000FFFFFF0000
00000000000000FFFF0000FFA0A0A0A09393939393939393
FFFFFFFF0000FFFF00000000FF0000FFFFFFFF0000FFFFFF
00FFFF000000FF00FFFFFF00000000FFFFFFFF00000000FF
9393939393939393
000000FFFF00FF000000FFFFFF0000FF00FF00FFFF00FFFF
FFFFFFFF00FF74FF74740000FFFF000000FFFFFF0000FFFF
FFFFFF00FFFFFF0000FF00FF747474747474747474747474
000000FFFFFFFF00000000FF00FFFFFFFFFF000000FFFFFF
FFFFFF0000FF00FF00FFFF00FFFF00FF0000FF00FF0000FF
7474747474747474
00FFFF0000FF00FFFFFF00FF0000FF00FF0000FFFF000000
FFFF00FF00FF74297474FFFF00000000FFFF00FF00000000
000000FF0000FFFFFFFF00FF747474747474747474747474
FFFF0000000000FFFFFFFFFFFF00FFFFFFFFFFFF000000FF
000000FFFF00FF00FF0000FFFF00FF00FF0000FF00FF00FF
7474747474747474
00000000000000FF00FF0000FF00FF00FF00FF00FFFF0000
0000FF0000FF74007474FFFF0000FFFF000000FFFFFF0000
00000000000000FF000000FF747474747474747474747474
FFFF000000FFFFFF0000000000FF00FFFFFFFF0000FFFF00
00FFFFFF0000FF00FFFFFF00000000FFFFFFFF00000000FF
7474747474747474
FFFFFF0000FF00FFFF00000000FF000000FFFFFF00FFFF00
0000FF00FF0074FF74740000FFFFFFFF00FF00FFFFFF00FF
000000FF000000FF0000FF00747474747474747474747474
0000000000FFFFFFFFFFFFFF00FF00FFFFFFFF0000FFFFFF
00FFFFFF0000FF00FFFFFF00000000FFFFFFFF0000FFFF00
7474747474747474
FFFF000000FF00FFFFFF00000000FF00FF00FF0000FF0000
FF00FF0000FF74007474FFFF0000FF00000000FFFFFF0000
00FFFF00000000FF00FF00FF747474747474747474747474
FFFF000000FFFFFF00000000FF00FF00FFFFFF0000FFFF00
00FF0000FFFF00FF000000FF000000FFFFFFFF00FFFF00FF
7474747474747474
FFFFFF000000000000FF00FFFFFF00FF00FFFF00FF00FF00
00FF00FFFF0074FF74740000FFFFFFFF0000FF000000FFFF
000000FF0000FF00FFFFFF00747474747474747474747474
00000000FF000000FFFFFF000000FFFF000000FFFF0000FF
00FFFFFF0000FF00FFFFFFFFFF00FF00FF0000FFFF00FF00
7474747474747474
FFFFFFFFFF00FFFFFFFFFF0000FF00FFFF00FF0000FF00FF
00000000FF007400747400FF0000FFFFFF000000FFFF0000
FFFF0000FFFF00000000FF00747474747474747474747474
0000FF000000FFFF0000FF00FFFF00FF0000FFFFFF000000
0000FF00FFFF00FF00FFFF00FFFF00FF00FFFF000000FF00
7474747474747474
0000000000FF000000000000FF00FF000000FFFFFF000000
000000FF00FF74FF7474FF000000FF0000FFFFFF00FFFF00
000000FF000000FFFFFF00FF747474747474747474747474
FFFFFF000000FFFF000000FFFFFFFFFFFFFF0000FFFFFF00
000000FF0000FF00FF0000FF0000FF00FF0000FF00FF00FF
7474747474747474
00FFFF00000000FFFFFF00FF00FF000000FF00FFFF00FF00
FFFFFF00FF00749474747600FFFF0000FF0000FF000000FF
0000FFFFFFFFFF000000FF00747474747474747474747474
8DDB00FFFFFF00FF0000FFFFFF0000FFFFFF00FF000000FF
FFFF00FF0000FF2FFF65FF00FFFF00FF00FFFF00FF00FF00
7474747474747474
FF0000FFFF00FF000000FFFF7474A3FF7300FF0000FF004D
74747474747474747474747474C900FF00FFFF00FF00FF60
747474747474747474747474747474747474747474747474
74747474746DFF00FFFF000000FFFFFF0000FFFF0000FF6F
747474747474747474747474747474747474747474747474
7474747474747474
FFFFFF00FFFF00FF0000FFFF00FFFFFF74740000FF00FFFF
FFFF00FF00717474747474747474746700FF00FFFF00FFFF
FFFFFFC0FFFFFF0000FF9A74747474747474747474747474
747474747474747474746DFF00FFFF00FFFF0000FF0000FF
FF00000EFFFF32FF000000FFFFFFFF0000FF00FF007B7474
7474747474747474
0000FF00000000FF00FF0000FF0000FF747BFF00FFFF0000
0000FF00FF0074747474747474794600FF0000FFFFFF0000
00000000000000FF0000FF00747474747474747474747474
747474747473659B370000FF4A0000FF0000FF0000FFFF00
00FFFFFF0000FF00FFFFFF00000000FFFFFFFF000000FF00
7474747474747474
00FF0000FFFF00FF00FFFFFFFFFF00FF74740000FF00FF00
00FF0000FF737474747474747474747474FF00FFFF00FFFF
FF007700FFFF00FF00FF8574747474747474747474747474
7474747474747474747474747474FF00FFFFFF00000000FF
FF00FF3E007874746091FFFFFFFFFF00FFFF00FF00747474
7474747474747474
000000FF0000000000FF0000FF0000FF7474FF0000FF0000
0000FF00FFFF747474747474747474747400FF00FFFF0000
00000000000000FF00000072747474747474747474747474
747474747474747474747474746000FF0000FFFF00FFFF00
00FFFFFF0000FF00FFFFFF00000000FFFF00FF00FF008D74
7474747474747474
FFFF0000FFFF00FF00FF0000FF00FFFF7474FF00FFFF00FF
FF00FFFF000074747474747474747474FF00FFFFFFFF0000
FFFFFFFF000000FF0000FF00747474747474747474747474
74747474747474747474747460000000FFFFFF0000FFFF00
FF0000FFFFFF00FF000000FFFF0000FFFFFF00FF0000FF00
7474747474747474
FFFFFF0000FFFFFF0000FFFF0000FFFF7800FF000000FFFF
00FFFF0000FF7474747474747100FFFF000000000000FFFF
FF0000FF00FFFF00FF0000FF747474747474747474747474
747474746091FF00FFFFFF00FF00FFFF000000FFFF00FFFF
00FFFFFF0000FF00FFFFFF0000FFFF000000FFFF00FF00FF
7474747474747474
00FFFF00000000FFFF00FF00FFFF0000FF0000FF0000FF00
FFFF00FFFF0074007474FFFF00000000FFFFFF00797500FF
0000FF00FFBB60FF00FFFF00747474747474747474747474
FFFF000000FFFFFF000000FFFFFFFF002874747474747415
FFFFFF00FFFF00FF0000FF00FF2974747474FF00FFFFFF00
7474747474747474
FF0000FFFF00FF0000FFFF00000000FF00FF00FFFF0000FF
00007B0000FF74FF74740000FFFF0000FFFFFFFF74720000
00FF0000FFFF00FFFF0000FF747474747474747474747474
0000FFFFFF000000FF0000FFFFFF00FF74747474747474E7
00FF00FF00FF00FF00FFFF00FFFF0015FF600184000000FF
7474747474747474
FFFFFFFF00FF00FFFFFF00FFFFFFFF00FFFFFF00FF00FF00
FFFFFFFFFFFF7400747400FF00FFFFFF0000FF008100FFFF
0000FFFF0000FFFFFF0000FF747474747474747474747474
000000FFFFFFFFFF00FFFF000000FF2974747474880000FF
FFFF00FF0000FF00FF0000FF0000FF00FF0000FF00FF00FF
7474747474747474
0000FFFFFF00FFFFFFFFFFFF00FF00FF00FFFF0000FF0000
FFFFFF00FF0074FF74740000FF00FF00FF6E74FF00FF00FF
0000FFFFFFFFFF000000FF00747474747474747474747474
00FF00FF0000FFFF0000C774747474747474FF00FFFFFF00
FFFF00FF0000FF00FF00FF00FFFF00FF00FFFF00FF00FF00
7474747474747474
FF00000000FF000000000000FF00FF00FF0000FFFF00FF00
000000FF00FF740074745EFF000000FFFF00FF00FF00FF00
FFFF0000000000FFFFFF00FF747474747474747474747474
0000FF000000FF00FFFFFF00FF7074880000FFFF0000FF00
0000FF00FFFF00FF00FF00FF0000FF00FF0000FF00FF00FF
7474747474747474
FFFFFFFF00FF0000000000FFFFFFFF000000FFFFFFFF00FF
FF00FFFFFF007473747474AB00FF00FF00FFFFFF000000FF
A66D7489FF0000FF00FFFF00747474747474747474747474
74747400FFFF0000FF0000FF000000FFFFFF00FF000000FF
0000D374747474747474D3008800FF00FF00FF00FF00FF00
7474747474747474
FFFFFFFF00FF0000FFFF00007474000086FF00FF0000FFFF
7474747474747474747474747200FF00FF0000FF00FF00FF
747474747474747474747474747474747474747474747474
7474747474D300FF000000FF00FFFF0000FF0000FFFF00BE
747474747474747474747474747474747474747474747474
7474747474747474
0000FF00000000FF0000FFFF747484FF7400000000FF0074
747474747474747474747474747400FF00FFFF00FF006F74
747474747474747474747474747474747474747474747474
747474747474747400FFFF0000FFFF000000FF00B3747474
747474747474747474747474747474747474747474747474
7474747474747474
FFFF00FFFFFFFF00FFFF006B747474007471FFFFFF00F174
747474747474747474747474747474FFFFFF00FF00757474
747474747474747474747474747474747474747474747474
74747474747474747474D300FF0000FFFF00607474747474
747474747474747474747474747474747474747474747474
7474747474747474
B2B2B2B27474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
B2B2B2B27474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
00C1B900007750FF00FF47747474747574747432FF007774
74747474747474747474747474747474747E000A3E757474
747474747474747474747474747474747474747474747474
74747474747474747474747474747400FF9D647474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
FF0000FFFF00FF00FF00FF837474743374747EFF00FF0074
747474747474747474747474747474747400FFFFFF297474
747474747474747474747474747474747474747474747474
747474747474747474747474747474FF0000FF7474747474
747474747474747474747474747474747474747474747474
7474747474747474
0000FF0000FF00FF00FF0000FF0000FF74740000FF00FF00
00FF0000FF747474747474747474747474FF00FF0000FF00
7474747401FF00FF00FF7474747474747474747474747474
7474747474747474747474747474FF00FFFF0000000000FF
74747474747474747474747474FFFF00FFFF00FF74747474
7474747474747474
0000FFFF0000FF00FF0000000000FFFF7474FF00FFFF00FF
FF00FFFF00C1747474747474747474747400FF0000FF0000
00FF00FF00000000FF000074747474747474747474747474
747474747474747474747474747400FFFF0000FFFFFFFF00
00FF00FFFF007474FF000000000000FF0000FF00FF747474
7474747474747474
FFFF0000FFFF00FFFFFFFFFFFFFF0000747400FF00FF0000
00FFFFFFFF007474747474747474747474FF00FFFFFF00FF
00000000FF0000FF0000FF74747474747474747474747474
74747474747474747474747474740000FFFFFF0000FF0000
FF00FF000000FF00FFFFFFFFFFFF00FFFFFF00FF00FF7474
7474747474747474
FFFF00FF00FFFFFFFFFF000000FF0000747400FF0000FF00
FFFFFFFFFF007474747474747474747460FF00FF0000FFFF
0000FF00FFFFFFFF0000FFE7747474747474747474747474
74747474747474747474747474FFFFFF0074FF00FF00FFFF
00FFFF00FFFF00FF0000FF000000FF0000FFFF0000FF0074
7474747474747474
0000000000FF00FF0000FFFF0000FFFF7474FF0000FF00FF
0000000000FF74747474747474747474FF00FF002860FF00
FFFF00FF0000FF00FFFF0000747474747474747474747474
7474747474747474747474747400FF00FF747474747474FF
000000FF0000FF00FFFF00FF00FF7474747400FF0000FF00
7474747474747474
FF0000FFFFFFFF00FFFF00FF0000FF00747400FFFF0038FF
00FFFF0000FF7474747474747474747400FF00FF74747474
FFFF00FF00747461FF0000FF747474747474747474747474
747474747474747474747474FFFF00FF7474747474747474
74747474FF00FF00FF00747474747474747474FFFFFF00FF
7474747474747474
00FFFF00000000FF0000FF00FFFF00FF7400FF0000FF7474
747400FFFF00747474747474747401FF000000FF74747474
747474747474747400FFFF00747474747474747474747474
747474747474747474FFFF00000000FF7474747474747474
7474747474747474747474747474747474747474FFFFFF00
7474747474747474
0000FF0000FF00FFFF0000FF0000FF0000FF00FFFF007474
7474FF0000FF747474747474FFFF0000FF00FF0074747474
7474747474747474FF0000FF747474747474747474747474
74747474FF0000FF000000FF0000FF007474747474747474
7474747474747474747474747474747474747474FF0000FF
7474747474747474
FF00FF00FFFF000000FFFF747972FF000000FFFF00FF7474
747474776E7474007474FFFF0000FF00FFFF00FF74747474
747474747474747474767074747474747474747474747474
FFFF000000FFFF00FFFF00FFFFFF00FF7474747474747474
747474747474747474747474747474747474747474747174
7474747474747474
00FF00FF0000FFFFFF000074790000FF0000FF00FF007474
747474776E7474FF74740000FF00FFFF0000FF8874747474
747474747474747474767074747474747474747474747474
0000FFFF0000FFFF0000FF0000FF00747474747474747474
747474747474747474747474747474747474747474747174
7474747474747474
0000FFFFFFFF00FFFFFF0000FF00FF00FFFF00FF8000FFFF
00FF56776E7474FF7474FF00FF0000FF00747474747400FF
00FF0000FF74747474767074747474747474747474747474
FF00FF00FFFF000000FF7474747474747474747474747474
00FF00FF00FF00FF00FF7474747474747474747474747174
7474747474747474
FFFF000000FFFFFFFFFF00FFFF0000FF0000FF2D7200FF00
FFFFFF00FF7474FF7474000000FFFF747474747474E7FFFF
FF00FFFF0000FF0000C27074747474747474747474747474
00FF00FF00FF747474747474747474747474747474747400
FF00FF00FF00FF00FF0000FF0000FFFF00FFFF0074747174
7474747474747474
00FF0000FFFFFF00FFFF00FFFFFF00FF0000FFFFFFFF0000
FF0000FFFF0074FF7474FF00FFFF00FF747474747400FFFF
0000FF00FFFF00FFFF00FF00747474747474747474747474
FFFF00FFFFFF00747474747474747474747474747474FFFF
00FF00FF0000FFFF00FFFF00FFFF0000FF0000FF00FFFF00
7474747474747474
FF0000FF00FFFFFFFFFFFF00FF0000FF00FFFF0000FFFF00
000000FFFF007400747488FF0000FF006074747400FF00FF
FFFF00FF000000FF00FFFF00747474747474747474747474
7400FF00FF00FF00FF747474747474747474747400FFFF00
0000FF00FFFF0000FF0000FF0000FF00FF00FF00FF00FF00
7474747474747474
00FFFF00FFFF000000FFFFFF0000FF00FF0000FF00FFFF00
00FF00FF00FF748074747400FF0000FFFF7474E7FFFFFF00
00D3740000FFFF00FF0000FF747474747474747474747474
747474FF00FF00FF00FF74747474747474747400FF00FF00
FFFF007474747474747400FF00FF00FF00FF00FF00FF00FF
7474747474747474
FFFF00FF00FFFF00000000FF0000FFFFFF0000FFFF0000FF
4F746F0000FF747474747474FF00FFFF00FF7400FF0000FF
FF74747474747474000000FF747474747474747474747474
7474747400000000FFFF007474747474747400FF00FF00FF
007474747474747474747474747474747474747400FF00FF
7474747474747474
FF00FF00FFFF0000000000FF7474FF000000FFFFFFFF0000
74747474747474747474747488FF0000FF00FFFF0000FF00
747474747474747474747474747474747474747474747474
747474747400FF00FF00FF00FF7474747400FF00FF00FF00
747474747474747474747474747474747474747474747474
7474747474747474
FFFFFF0000FF0000FF0000FF7474FF0081000000FFFF0000
747474747474747474747474740000FF00FF00FFFF00FF60
747474747474747474747474747474747474747474747474
74747474747400FF00FF00FF00FF7400FFFF00000000FF74
747474747474747474747474747474747474747474747474
7474747474747474
00FFFF0000FF0000FFFFFF007474000074FF00000000FF6F
7474747474747474747474747474FF00FFFFFF0000FFB374
747474747474747474747474747474747474747474747474
7474747474747474FF000000FF0000FF00FF00FF00747474
747474747474747474747474747474747474747474747474
7474747474747474
FFFFFFFFFFFF0000FFFF000074748500740000FF0000FF74
747474747474747474747474747429FF000000FF00007474
747474747474747474747474747474747474747474747474
747474747474747474FFFF00FFFFFF00FF00FF0074747474
747474747474747474747474747474747474747474747474
7474747474747474
0000FF00000000FF0000FFE0747473FF7499000000FF0074
747474747474747474747474747474000000FF00FF607474
747474747474747474747474747474747474747474747474
7474747474747474747400FF00FFFF0000FFFF7474747474
747474747474747474747474747474747474747474747474
7474747474747474
FFFF00FFFFFFFF00FFFF007674747400747463FFFF005774
74747474747474747474747474747474FFFF00FFFF747474
747474747474747474747474747474747474747474747474
747474747474747474747474FF0000FF00FF747474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
A0A0A0A07474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
00FFFF0000FF00FF00FF0000747474FF74740000FF00FF74
7474747474747474747474747474747474FF000000FF7474
747474747474747474747474747474747474747474747474
74747474747474747474747474747400FFFF007474747474
747474747474747474747474747474747474747474747474
7474747474747474
000000FF00FF0000FFFF0000FF0000007474CEFF00FF0000
60000000FF74747474747474747474747400FF00FF00FF74
7474747474FF00FF00FF7474747474747474747474747474
747474747474747474747474747474FFFF00FF0000FF7474
74747474747474747474747474747400FFFF00FF74747474
7474747474747474
0000FFFF0000FF00000000000000FFFF7474FF00FF0000FF
FF00FFFF0074747474747474747474747400FF0000FF00FF
74747474FF00FF00FF007474747474747474747474747474
747474747474747474747474747400FF00FFFF00FFFFFF00
747474747474747474747474740000FF00FFFF0074747474
7474747474747474
00FF00FFFFFF0000FFFFFFFFFF00FF00747400FF00FFFF00
00FF00FF00FF7474747474747474747474FF00FFFFFFFF00
00FF74FF00FF00FFFF000074747474747474747474747474
7474747474747474747474747474FF00FF7400FF00FF00FF
00FF0074747474747474740000FF00FFFF000000FF747474
7474747474747474
FF000000FFFF00FF00FFFFFFFF00FF7474747473FFFF00FF
0000FFFF00007474747474747474747474747274FF00FF00
FF00FF00FF00FF000000FF74747474747474747474747474
74747474747474747474747474747476747474747400FFFF
0000FF0000FF747400FFFFFF0000FF00FF74FFFF00747474
7474747474747474
FFFFFF00FF0000FF0000000000FF00FF7474FF00FF00FF00
FFFFFF00FFFF747474747474747474747400FF0000FF00FF
00FF00FFFF0000FF00FF0074747474747474747474747474
74747474747474747474747474740000FF74747474747400
FFFFFF00FF00FF00FF00FF00FF0074747474FF00FFFF7474
7474747474747474
FFFFFF000000FFFFFF00FFFF00FF0000747400FF00FF00FF
00FFFF00FFFF7474747474747474747474FF00FFFF747400
FFFF00FF00FF7400FFFF0074747474747474747474747474
7474747474747474747474747474FFFF0074747474747474
747400FF0000FF00FFFF00FF74747474747400FFFF007474
7474747474747474
00000000FFFF000071FF0000FF00FF74747474737874FF00
FF0000FF00FF747474747474747474747474767474747474
0000FF00FF7474FF00FF0074747474747474747474747474
747474747474747474747474747472747474747474747474
7474747400FF00FF00FF74747474747474747400FF007474
7474747474747474
0000000000FF00FF0000FF000000FFFF7474FF0000FF7474
748400FF00FF74747474747474747474FF00FF0074747474
747474747474740000FF0000747474747474747474747474
7474747474747474747474747400FF007474747474747474
74747474747474747474747474747474747474FF0000FF74
7474747474747474
FF0000FFFFFFFF00FFFF00FF0000FF00747400FFFF007474
7474FF0000FF7474747474747474747400FF00FF74747474
7474747474747474FF0000FF747474747474747474747474
74747474747474747474747474FF00FF7474747474747474
7474747474747474747474747474747474747474FFFF0074
7474747474747474
00FFFF00FF00FFFF0000FFFFFFFF00FF7474FF0000FF7474
7474FF00FF0074747474747474747474FF00FF0074747474
7474747474747474FF00FF00747474747474747474747474
7474747474747474747474747400FF007474747474747474
7474747474747474747474747474747474747474FF00FFFF
7474747474747474
00FFFFFFFF00FFFF70797400FFFF00747474747278747474
747400FFFF00747474747474747474747473777474747474
747474747474747400FFFF00747474747474747474747474
747474747474747474747474747476747474747474747474
747474747474747474747474747474747474747400FFFF00
7474747474747474
0000000000FF00FF0000FFFF0000FFFF7474FF0000FF7474
7474FF0000FF74747474747474747474FF0000FF74747474
7474747474747474FF0000FF747474747474747474747474
747474747474747474747474000000FF7474747474747474
7474747474747474747474747474747474747474740000FF
7474747474747474
FFFF00FFFFFFFF00FFFF0074786F7400746000FFFF007474
747474767074747474747474747474FF0000FF0074747474
747474747474747474757174747474747474747474747474
747474747474747474747400FF00FF007474747474747474
747474747474747474747474747474747474747474747274
7474747474747474
00FFFF0000FF0000FFFF0074786F000074FF00FFFF007474
7474747670747474747474747474FF00FF00FFFF74747474
747474747474747474757174747474747474747474747474
7474747474747474740000FF00FF00747474747474747474
747474747474747474747474747474747474747474747274
7474747474747474
FF00FF00FFFF000000FFFF74786FFF00FF00FFFF00FF7474
747474767074747474747474740000FF00FF000074747474
747474747474747474757174747474747474747474747474
74747474747400FF00FF00FFFF00FF747474747474747474
747474747474747474747474747474747474747474747274
7474747474747474
FF00FFFFFFFF000000FFFF74786FFF00FF0000FF00747474
7474747670747474747474740000FFFFFF00747474747474
747474747474747474757174747474747474747474747474
7474747400FFFF000000FF00747474747474747474747474
747474747474747474747474747474747474747474747274
7474747474747474
00FF00000000FFFFFF008074786800FF00FFFF0000747474
74747476707474FF7474740000FFFF00FF74747474747474
747474747474747474757174747474747474747474747474
74740000FF00FFFFFF007474747474747474747474747474
747474747474747474747474747474747474747474747274
7474747474747474
00FF00FF0000FFFFFF007474780000FF0000FFFF74747474
74747476707474FF7474000000FF00FF7474747474747474
747474747474747474757174747474747474747474747474
0000FF00FFFF00FF74747474747474747474747474747474
747474747474747474747474747474747474747474747274
7474747474747474
0000FFFF00FF00FFFFFF74747800FF0000FF002974747474
74747476707474FF7474FF00FF00FF747474747474747474
747474747474747474757174747474747474747474747474
FF0000FF0074747474747474747474747474747474747474
747474747474747474747474747474747474747474747274
7474747474747474
0000FFFF00FF00FFFFFF74747800FF00FFFF007474747474
74747476707474FF7474FF00FF0074747474747474747474
747474747474747474757174747474747474747474747474
FF00FF007474747474747474747474747474747474747474
747474747474747474747474747474747474747474747274
7474747474747474
FFFF00000000FF0000FF00FFFF0000FF0000FF747400FFFF
00157476707474FF7474FF0000FF747474747474747400FF
00FFFF747474747474757174747474747474747474747474
000000FF7474747474747474747474747474747474747474
74FF00FF0074747474747474747474747474747474747274
7474747474747474
FFFF000000FFFF0000FFFFFF000000FF0000FF1574FF0000
FF00FF76707474FF7474FF00FF00FF74747474747474FF00
FF00FFFF0074747474757174747474747474747474747474
7400FF000074747474747474747474747474747474747474
FF00FF00FF00FF00FF007474747474747474747474747274
7474747474747474
00FF00FFFFFFFF00FFFF0000FF0000FF0000FFFF74FF0000
FFFFFF00707474FF74740000FFFF0074747474747474FF00
0000FF000000FF0074757174747474747474747474747474
74FF0000FF74747474747474747474747474747474747474
FFFF00FF0000FFFF00FF00FF0000FF747474747474747274
7474747474747474
FFFFFFFFFF00FFFFFFFF00FF00FFFF00FF00FFFFE7FF00FF
00FF00FF007474FF74747400FFFF0074747474747400FF00
FFFF00FF00FF00FFFF007174747474747474747474747474
7474FFFFFF007474747474747474747474747474747474FF
00FF007474FF0000FF0000FF00FF0000FF0000FF74747274
7474747474747474
FF00FF000000000000FFFF00FFFF00FF00FF00FFE4FF0000
FF00FF00FF007400747474FF000000FF747474747400FFFF
000074FFFF0000FF0000FF00747474747474747474747474
74747400FF0000747474747474747474747474747474FFFF
FF00FF74747474747474FF00FF00FF00FF00FF0000FFFF00
7474747474747474
000000FF00FFFF00FF00FF000000FFFF00FFFF00FF00FF00
00FF000000FF74787474740000FFFF00747474747400FF00
FF7474747400FF00FF0000FF747474747474747474747474
747474FF0000FF74747474747474747474747474747400FF
00FF74747474747474747474747474FF00FF00FF00FF00FF
7474747474747474
000000FFFF00FFFFFFFFFF00FFFF00FF00FFFF0000FFFF00
FF74BAFFFF0074747474747400FFFF007474747400FFFF00
0074747474747474FFFFFF00747474747474747474747474
74747474FFFFFF0074747474747474747474747474FF0000
FF74747474747474747474747474747474747474FF00FF00
7474747474747474
FF00FF00FF0000FF00FFFF007574FF00FF0000FF00FFFF00
607474747474747474747474FF000000FF74747400FFFF00
FF7474747474747474747474747474747474747474747474
747474747400FF00007474747474747474747474FFFFFF00
007474747474747474747474747474747474747474747474
7474747474747474
00FFFF0000FF0000000000FF7474FF00FF00FF00000000FF
7474747474747474747474740000FF000074747400FF00FF
747474747474747474747474747474747474747474747474
7474747474FF0000FF747474747474747474747400FF00FF
747474747474747474747474747474747474747474747474
7474747474747474
00FFFF0000FF0000000000FF7474FF00FF000000FF0000FF
7474747474747474747474747400FFFF00747400FFFF0000
747474747474747474747474747474747474747474747474
74747474747400FFFF00747474747474747474FF0000FF74
747474747474747474747474747474747474747474747474
7474747474747474
FF0000FFFF00FFFF0000FF00747400FF45FF00FFFF00FFFF
74747474747474747474747474FFFF00FFFF7400FFFF00FF
747474747474747474747474747474747474747474747474
747474747474FF0000FF007474747474747474FFFF000074
747474747474747474747474747474747474747474747474
7474747474747474
FF00FF00FF000000FF00FF007474FF006400FF00FF00FFFF
74747474747474747474747474FF00FF000074FF00FF0074
747474747474747474747474747474747474747474747474
74747474747474000000FF74747474747474FF00FFFF7474
747474747474747474747474747474747474747474747474
7474747474747474
00FFFF0000FF00FF00FF00FF7474FF007400FFFF00FF00FF
747474747474747474747474747400FFFF000000FF000074
747474747474747474747474747474747474747474747474
747474747474747400FFFF007474747474FF0000FF747474
747474747474747474747474747474747474747474747474
7474747474747474
FFFF00FF00FFFF00000000FF7474FFFF7400FFFFFFFF0060
7474747474747474747474747474FFFF00FF00FFFF00FF74
747474747474747474747474747474747474747474747474
7474747474747474FF0000FF0074747474FFFF0000747474
747474747474747474747474747474747474747474747474
7474747474747474
FF00FF00FF000000FF00FFFF7474130074FF00FF00FF0074
7474747474747474747474747474FF00FF00FF00FF007474
747474747474747474747474747474747474747474747474
747474747474747474000000FF747474FF0000FF74747474
747474747474747474747474747474747474747474747474
7474747474747474
00FFFF0000FF00FFFFFF000074744E0074FF00FFFF00FF74
74747474747474747474747474747400FF0000FF00007474
747474747474747474747474747474747474747474747474
7474747474747474747400FF000074FF0000FF7474747474
747474747474747474747474747474747474747474747474
7474747474747474
00FFFF0000FF00FFFFFF000074747D007400FFFFFF00FF74
747474747474747474747474747474FF000000FF00FF7474
747474747474747474747474747474747474747474747474
74747474747474747474FF0000FF7400FF00007474747474
747474747474747474747474747474747474747474747474
7474747474747474
FFFF00FFFFFFFF00FFFF00FF747474FF7478FFFFFF000074
74747474747474747474747474747400FF000000FF747474
747474747474747474747474747474747474747474747474
7474747474747474747474FFFFFFFF0000FF747474747474
747474747474747474747474747474747474747474747474
7474747474747474
0000FF00000000FF0000FF4B747474FF7474FF0000FFFF74
747474747474747474747474747474740000FF0000747474
747474747474747474747474747474747474747474747474
74747474747474747474747400FFFF00FF00747474747474
747474747474747474747474747474747474747474747474
7474747474747474
FFFF00FFFFFFFF00FFFF007574747400747400FFFF006074
74747474747474747474747474747474FFFF00FFFF747474
747474747474747474747474747474747474747474747474
747474747474747474747474FF0000FF0074747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
939393937474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
747474747474747474747474747474747474747474747474
7474747474747474
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.0055371 0.488926 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -62 0 ]
[.5 1.0125 62 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -123 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Shifted) show
111.000000 13.000000 moveto
(Sample) show
153.000000 13.000000 moveto
(Photo) show
183.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFF0000FF00FF00FFFF0000FFFFFF00FFFFFF0000
FFFFFF00FFD6FF000000FFFFFFFFFF00FF00FFFFFFFF00FF
FFFF00FFFFFFFFFF00FFB6B6B6B6B6B69F9F9F9F0000FFFF
FF000000FFFFFFFF000000FF00FFFFFFFFFFFFFFFF000000
FFFFFF0000000000FF00FFFF00FF00FFFFFFFF009F9F9F9F
9F9F9F9F9F9F9F9F
FFFFFFFF000000FFFF000000FF0000000000FFFF000000FF
0000FF00FFD6FF00FF0000000000FFFFFFFFFF0000000000
FFFF0000FFFF000000FFB6B6B6B6B6B6A0A0A0A0FF0000FF
FFFFFF0000000000FFFF00FFFF00000000FFFFFFFF000000
FF00FF0000FFFF00FF00FF0000FF00FF0000FF00A0A0A0A0
A0A0A0A0A0A09F9F
FFFFFFFFFFFFFF00FFFFFF00FF0000FF00FF0000FFFFFFFF
FF00FFFF00D6FF006A0000FFFFFF0000FF0000FFFFFFFF00
FFFF00FFFFFF00FFFF00B6B6B6B6B6B69F9F9F9F0000FFFF
FFFFFFFFFFFF000000FFFFFF0000FFFF0000FFFF0000FFFF
0000FF00FFFFFF00000000FFFFFF00FFFFFFFF009F9F9F9F
9F9F9F9F9F9F9F9F
FFFFFFFF000000FF00FF00FF00FFFF00000000FF00000000
00FF0000FFD600FFFFFF00000000000000FF0000000000FF
0000FF0000FFFF0000FFB6B6B6B6B6B6A0A0A0A0FFFF0000
00FFFFFF0000FFFF00000000FF0000FFFFFF0000FFFF0000
FFFF00FF00000000FFFFFF000000FFFFFFFF00FFA0A0A0A0
A0A0A0A0A0A0A0A0
0000FFFFFF00FF00FF00FFFF00FFFF00FF00FFFF0000FF00
FFFF00FF0069FF000000FFFF0000FFFFFFFFFF0000FFFFFF
0000FFFF0000FFFFFFFF6969696969696969696900FFFFFF
FF0000000000FFFFFF0000FFFF0000000000000000FFFFFF
00FF00FFFF0000FF00FF00FFFF00FF00FFFF00FF69696969
6969696969696969
0000FF0000FF00FFFF0000FFFF0000000000FF00000000FF
FFFFFF00FF69FF00FF0000000000FFFF00FFFF0000000000
FFFF0000FFFF000000FF69696969696969696969FF0000FF
FF00FF00000000FFFF00000000FFFF0000FFFFFF00000000
FF00FF0000FFFF00FF00FFFF00FF00FFFF00FF0069696969
6969696969696969
0000FF00000000FF00FF00FF00FFFFFF00FF00FF00000000
00FF0000FF6900FFFFFF00FFFFFF000000FF0000000000FF
0000FF0000FFFF0000FF69696969696969696969FFFF0000
00FFFFFFFFFFFF0000000000FF0000FFFFFF0000FFFF0000
FFFF008B00000000FFFFFF000000FF000000FF0069696969
6969696969696969
FFFF000000FF0000FF00FF00FF0000FFFFFFFF00FF0000FF
000000FF0069FF000000FFFFFFFFFFFF00FF000000FF0000
FFFF000000000000FF00696969696969696969690000FFFF
FF000000FFFFFF00FFFFFF00FF0000FFFFFF0000FF000000
0000FF00FFFFFF00FFFFFF000000FF000000FF0069696969
6969696969696969
FFFF00FFFFFFFF00FF00FF00FF00FF00FF000000000000FF
0000FF00FF6900FF56FFFFFF0000FF00FFFF000000FF00FF
FFFF0000000000FF00FF69696969696969696969FFFF0000
00FF000000FFFFFF000000FFFF0000FFFF0000FF0000FFFF
0000FF62FFFFFF00000000FF0000FF00FFFF000069696969
6969696969696969
FFFF0000FF00000000FF00FF00FF00FFFFFFFF00FFFF0000
FFFFFFFF0069FF000000FF00FFFFFFFF00FFFFFF00FF00FF
00FF00FFFFFFFFFFFF00696969696969696969690000FFFF
FF000000FF000000FFFF00FF00FFFF00FFFF0000FFFF0000
FFFFFF0000000000FFFFFF00FFFF00FFFFFF00FF69696969
6969696969696969
FFFFFFFF00FF00FFFFFFFF00FFFFFF0000FFFFFFFF00FF00
000000FF006900FF00FF0000FF00FF00FF00FFFFFF00FF00
0000FF00FFFF0000FF0069696969696969696969FFFFFF00
00FF000000FFFFFF0000FF00FF0000FFFFFFFFFFFF00FFFF
00FF00FFFF0000FF0000FF0000FF00FF000000FF69696969
6969696969696969
000000FF0000FF00FFFF0000FF0000FF0000FFFF00FF0000
0000FF00FF69FF00FF0000FFFF00FFFFFFFFFF00FF000000
FFFF0000FFFF000000FF69696969696969696969000000FF
00FFFFFF00000000FFFFFFFFFFFFFF000000FFFFFF000000
FF00FF0000FF6700FF00FF0000FF00FF0000FF0069696969
6969696969696969
00FFFF00FFFF00FF0000FFFF00FFFF00FF00FF00FF00FFFF
FFFF00FF0069FFFFE400FF000000FF0000FFFF0000FFFFFF
0000FFFF0000FFFFFF0069696969696969696969FF0000FF
FF00FF000000FFFF0000000000FFFF000000FF0000FFFFFF
00FF00FFFF0069FF00FF00FFFF00FF00FFFF00FF69696969
6969696969696969
00FFFF00000000FFFF00FF00696900FF00FF00FF0000FF69
6969696969696963696966FF00FF0000FF0000FF00FF6A69
696969696969696969696969696969696969696969696969
69FF0000FFFF0000FFFFFFFF000000FFFFFF00FF61696969
696969696969696969696969696969696969696969696969
6969696969696969
FFFF00FFFFFFFF00FFFFFFFFFF0084006900FFFFFFFFFF00
FFFFFF006569696969696969698700FFFF00FFFFFFFFFF00
0000FFE7FFFFFFFFA3696969696969696969696969696969
6969696969695D0000FF00FF0000FF0000FFFFFF002EFFFF
FFFF24690000FFFF000000FFFFFF00FF0094696969696969
6969696969696969
0000FF00000000FF000000FF00FFFF00690000FF00000000
00FF00FF0069696969696969697118FF00FF0000000000FF
0000FF000000FF00FF006969696969696969696969696969
696969696A684EAE0000FF00FF0000FFFFFF0000FFBA0000
FFFF006900000000FFFFFF000000FF00FF00FF1B69696969
6969696969696969
FFFF00FFFFFFFF00FFFF00FFFF006900696BFFFFFFFF0074
00FFFF00686969696969696969696900FF00FFFFFF006969
69696400FFFFFFAA74696969696969696969696969696969
6969696969696969696969FF0000FF0000FFFF00FF4D6969
6969696969696969459DFFFFFFFF00FF0069696969696969
6969696969696969
0000FF00000000FF0000000000FF6100690000FF000000FF
000000FFFF69696969696969696969FF00FF0000000000FF
FFFF00000000000000696969696969696969696969696969
69696969696969696969FF00FF0000FFFF000000FFFF0000
0000FF69FFFF0000FFFFFF000000FF00FF00716969696969
6969696969696969
00FF00FFFFFFFF00FF000000FF00FF0069FF00FF00FFFF00
FF00FF00006969696969696969696900FFFF000000FFFF00
0000FFFF00000000FF006969696969696969696969696969
6969696969696969696900FFFF0000FF0000FFFF00FFFF00
FFFF0067000000FF000000FFFF0000FF0000FF0069696969
6969696969696969
FFFF000000FF00FFFFFF00FFFF00000071FF0000FFFFFF00
FFFF0000FF696969696969696400FF00FFFFFF000000FF00
0000FFFF00FFFFFF00FF6969696969696969696969696969
69696969459DFF00FFFF0000FFFFFF00FFFF0000FFFF0000
FFFF0071000000FFFFFFFF0000FFFFFF00FF00FF69696969
6969696969696969
00FFFF00FF000000FF00FF0000FFFF00FF000000FF0000FF
0000FFFF00694FFF3BFFFFFF0000000000FFFFFFFF0000FF
FFFF0000FFFF00FFFF006969696969696969696900FF0000
00FF000000FFFFFF0000FFFF008D696900FF00000000FFFF
00FFFF69FFFFFF000000FF00FF00FF00FFFF00FF69696969
6969696969696969
FFFF0000FF00FF0000FFFF00FFFF00FF00FF00FF0000FF00
FFFF0000FF69FF00FF000000FFFF0000FF0000698000FF00
00FF00C76769FF0000FF696969696969696969690000FFFF
FF0000FFFF000000FF00FF00FF696969696969698D00FFFF
00FF00FF00ED69008569696969696969FF0000FF69696969
6969696969696969
FF00FFFF00FF00FFFFFF00FF0000FF0000FFFF0000FF00FF
00FF0000FF6900FFFFFF0000FF00FFFF00FF69FF00FF00FF
FFFF0000FFFFFFFF00FF69696969696969696969FF0000FF
FF000000FFFFFFFF00FF00FF696969696969FF00FFFF0000
FF00FF0000FF6900FF00FF0000FFFF00FFFF000069696969
6969696969696969
00FF00FF00FFFF00FF00FF00FFFF000000FF0000FF00FFFF
0000FFFF0069FF00FF00FF00FF00FF007F69FF00FF00FFFF
0000FF0000FF0000FF0069696969696969696969000000FF
00FFFFFF0000FFFFFF0069696969698D0000FFFFFF00FFFF
00FF00FFFF006BFF00FF00FF00FF00FF000000FF69696969
6969696969696969
FF0000FF0000FF00FF000000FF0000FFFF00FF00FFFF00FF
0000FF00FF69000000FF00FF00FF00FF5800FFFF00000000
FFFF0000FFFF000000FF6969696969696969696900FFFF00
00FF0000FFFF0000FF696969690000FFFFFF00FFFF000000
FF00FF0000FF6900FF00FF0000FF00FF0000FF0069696969
6969696969696969
00FF00FF0000FF00FFFF00FF00FF00FF00FFFFFF0000FF00
FFFF00FF00696AFF6941FF000000FFFF00FF00FF00FF0000
FFFFFFFF0000FF00FF006969696969696969696969690000
FF000000FF0000FFFF00FF0000FFFF0000FF000000FF00FF
0000FF0000FF69FF00FF00FFFF00FF00FFFF00FF69696969
6969696969696969
FFFFFF0000FF000000FF00FF6968FF00FF000000FF00006A
69696969696969BA69699100FF00FF00FF00FF00FF006169
696969696969696969696969696969696969696969696969
6900FFFF0000FFFF00FF00FFFF00FF000000FF00D8696969
696969696969696969696969696969696969696969696969
6969696969696969
0000FF0000FF00FFFF00FF596969FF00000000FF00FFFF69
69696969696969696969696600FF00FF00FF00FF006C6969
696969696969696969696969696969696969696969696969
696969FF00FF0000FFFF0000FF0000FFFF00456969696969
696969696969696969696969696969696969696969696969
6969696969696969
FFFF00FFFF00FF0000FF0069696900FF70FF0000FF006969
6969696969696969696969696900FF00FF0000FF69696969
696969696969696969696969696969696969696969696969
696969696969FFFFFF00FFFF00FF00FF6969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
00D2FF00006D00FFFF0071696969680069CA0000006A6969
6969696969696969696969696969D300FF00616969696969
696969696969696969696969696969696969696969696969
6969696969696969FF00FFFFFF4569696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
D6D6D6D66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
D6D6D6D66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
00FFFF00FFFF00FFFF0070FFFF006900696100FFFF007369
00FFFF006969696969696969696969FF00FFFFFF00696969
6969696900FFFF6669696969696969696969696969696969
696969696969696969696900FF00FF00FF69696969696969
69696969696969696969696969FF00FF6969696969696969
6969696969696969
0000FF00000000FF0000FF0000FF6900690000000000FF00
FF0000FF9B69696969696969696969FF00FF000000FF8A69
6969FFFF0000000000696969696969696969696969696969
696969696969696969696900FFFF00FFFF0000FF00FF6969
6969696969696969FF0000000000FF00FF69696969696969
6969696969696969
000000FFFFFF0000FFFF00FFFF00D600690000FF00FF00FF
00FFFF000069696969696969696969FF000000FFFF0000FF
FFFF0000FF00FF00FF696969696969696969696969696969
69696969696969696969FF000000000000FFFF00FF000000
0000FF69FFFF0000FFFFFFFFFFFF00FF0000696969696969
6969696969696969
00FF00FFFFFF0000FF00FF00FF00FF0069FF00FFFF00FF00
FFFFFF00006969696969696969696900FF00FFFFFF00FF00
0000FF00FFFF0000FF8D6969696969696969696969696969
6969696969696969696900FF00FFFFFFFFFF00000000FFFF
FFFF00690000FFFF0000FF000000FF0000FF006969696969
6969696969696969
FFFF00FF00FFFFFF00FF00FF00FF00FF6900FF00FFFF0000
FF0000FFFF69696969696969696969FF00FF000000FFFF00
FF00FFFF0000FFFF00006969696969696969696969696969
69696969696969696969FF00FF006969FF00FFFFFFFF0000
FF00FF6DFF0000FFFFFF00FF00FF00FF0000FF6969696969
6969696969696969
00FFFF00FFFF00FFFF00FFFFFFFF000069FF00FF0000FF00
00FF0000FF6969696969696969696900FF00006945FF00FF
00FF00FF00FFFF0000FF6969696969696969696969696969
696969696969696969690000FF6969696969696969FF00FF
00FF006900FFFF00FF00696969696900FFFF00FF69696969
6969696969696969
FF0000FF00FFFF0000FF00000000FFFF6900FF00FF006969
6900FFFF00696969696969696969FFFF00FFFF6969696969
69696969696900FFFF006969696969696969696969696969
69696969696969696900FFFF006969696969696969696969
6969696969696969696969696969696900FFFF0069696969
6969696969696969
00FFFF00FF0000FFFF0000FF00FF000000FF0000FF736969
6900FFFF0069696969696969FFFF00000000006969696969
69696969696900FF00FF6969696969696969696969696969
69696969FF0000FF0000FF00FF6969696969696969696969
69696969696969696969696969696969FFFF00FF69696969
6969696969696969
FF00FF00FFFF000000FFFF00FF00FF000000FFFF00696969
69FF0000C8696A9A6945FFFF0000FF00FF00696969696969
696969696969ED00FF0069696969696969696969696969FF
00FF000000FFFF00FF00FF00696969696969696969696969
696969696969696969696969696969696900FF0069696969
6969696969696969
00FF00FF0000FFFFFF00006A70FF00FF0000FF00FF696969
69696C5E6969FF00FF000000FF00FFFF00FF696969696969
696969696969696A636969696969696969696969FF00FFFF
FF00FFFF0000FFFF000000FF696969696969696969696969
6969696969696969696969696969696969696F6869696969
6969696969696969
0000FFFF00FFFFFFFFFF676A70FF000000FF00FF7F696969
69696C5E6969FF000000FF00FFFF00FF0069696969696969
696969696969696A63696969696969696969696900FF0000
00000000FFFF000000FF6969696969696969696969696969
6969696969696969696969696969696969696F6869696969
6969696969696969
FF00FFFFFFFF00FF00FF0000FF00FFFFFF00FF7300FF00FF
0000635E696900FF00FF00FF00FF00696969696900FF00FF
FF00FF00ED69696A63696969696969696969696900FF00FF
FFFFFF00FF69696969696969696969696969696900FF0000
FF00FF00FF0069FF006969696969696969696F6869696969
6969696969696969
FFFFFF0000FFFFFFFFFF00FF00FF000000FFFF6900FFFF00
FFFF0000FF69FF00FF00FFFF000069696969698DFFFFFF00
00FF00FFFFFFFFFF00ED69696969696969696969FF00FF00
FF00FF6969696969696969696969696969696900FF00FFFF
00FF00FF00FF6B00FF00FF0000FFFF00FFFF006869696969
6969696969696969
00FF00FFFFFF0000FF0000FFFF000000FFFF00FFFF000000
FF00FFFF0069FF008D000000FFFF696969696900FF000000
FFFFFFFF00000000FF006969696969696969696969000000
00FFFF00696969696969696969696969696900FF00FF0000
FF00FF0000FF64FF00FF00FFFF0000FF000000FF69696969
6969696969696969
FF0000FF0000FF00FF000000FF000000FFFF0000FFFF00FF
0000FF00FF69650069FF00FF00FFFF696969FFFF00FF00FF
00000000FFFF00FF00FF696969696969696969696969FFFF
00FF00FF0069696969696969696969696900FF00FF00FF00
FFFF00FFFF006900FF00FF0000FF00FF00FFFF0069696969
6969696969696969
FFFF0000FFFFFF00FF0000FF00FF00FF0000FF00FFFF0000
00FF00FF006969FF698DFF00FFFF0045698D00FFFF00FF45
69698D00FF00FF00FF006969696969696969696969696900
FF00FF00FF00FF696969696969696900FFFF000000FFFF69
69696969696969696900FF00FF00FF00FF0000FF69696969
6969696969696969
00FF00FF0000FF00FFFFFF00697200FF00FFFFFF0000FF61
6969696969696900696900FF0000FFFF6900FF0000FFD869
696969696969696969696969696969696969696969696969
69FF00FF00FF00FF69696969696900FF00FF00FF00696969
696969696969696969696969696969696969696969696969
6969696969696969
FFFF00FFFF00FF00FFFF0000696A00FF00FFFFFF0000FF69
696969696969693A696969FF00FFFF00FFFF00FF00006969
696969696969696969696969696969696969696969696969
6969FF0000FFFFFF0069696969FFFF00FF00FF0069696969
696969696969696969696969696969696969696969696969
6969696969696969
FFFFFFFF00FF000000FF00FF6969FF00FF0000FFFF000069
69696969696969696969698DFF0000FF00FFFF00FF456969
696969696969696969696969696969696969696969696969
69696900FF00FF00FF00FF69FFFF00FF00FFFF6969696969
696969696969696969696969696969696969696969696969
6969696969696969
00000000FF00FFFF0000FF6A6969FFFF0000FF0000FF6169
69696969696969696969696900FFFF00FF0000FFDB696969
696969696969696969696969696969696969696969696969
6969696969FF00FF00FF00FFFFFF00FF00FF696969696969
696969696969696969696969696969696969696969696969
6969696969696969
FF0000FFFFFFFF0000FFFF696969FF000000FF0000FF6969
69696969696969696969696969FF00FF00FF000069696969
696969696969696969696969696969696969696969696969
69696969696900000000FF00FF00FF006969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
0000FF0000FF00FFFF00FF69696900006BFF00FF00006969
6969696969696969696969696900FF00FF00FFED69696969
696969696969696969696969696969696969696969696969
69696969696969FFFF00FFFF00FF00696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
FFE900FFFF33FF0000FF006969697EFF6900FFFFFF616969
696969696969696969696969696900FF00FFD86969696969
696969696969696969696969696969696969696969696969
696969696969696900FF000000FF69696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
B6B6B6B66969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
0000FF00000000FFFF00FF6969696A00694500FF00FF6969
696969696969696969696969696969FF00FF000069696969
696969696969696969696969696969696969696969696969
696969696969696969696900FF00FF696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
0000FFFF0000FFFF0000FF0000FF66FF69FFFF0000FF0069
FF0000FF696969696969696969696900FF000000FF696969
69696969FF0000FF69696969696969696969696969696969
6969696969696969696969FF00FF00FF0069696969696969
6969696969696969696969696900FF006969696969696969
6969696969696969
00FF00FFFFFF0000FFFF00FFFF006000690000FFFF00FF00
00FFFF00FF69696969696969696969FF00FF00FF00FF6969
696969FF00FFFF0000696969696969696969696969696969
69696969696969696969690000000000FF0000FF69696969
69696969696969696969690000FF0000FF69696969696969
6969696969696969
00FF00FFFFFFFF00000000FFFF00DCFF69FFFF0000FF00FF
0000FFFF006969696969696969696900FFFFFF00FF000069
69690000FF0000FFFF696969696969696969696969696969
6969696969696969696969FFFF00FFFFFF00FF00FF006969
696969696969696900FFFFFF0000FFFF0069696969696969
6969696969696969
00FF00FFFFFFFF00FF000000FFFF0000694500FFFF000000
FFFF00FFFF69696969696969696969FF000000FFFFFF00FF
000000FFFFFF00FF00696969696969696969696969696969
69696969696969696969690000FF696900FF000000FF0000
FF69696969690000FF00FF00FF00FF00FF69696969696969
6969696969696969
00000000FFFF00FFFFFFFF00FF00FF0069FF00FF00FFFF00
00FFFF00006969696969696969696900FF00FF0000FF0000
000000FF00FF0000FF696969696969696969696969696969
6969696969696969696900FF00696969696900FFFFFF00FF
FFFF00690000FF00FFFF00FF6969000000FF696969696969
6969696969696969
000000FF0000FF0000FFFFFFFF0000FF6900FF00FFFF00FF
FF00FF00FF69696969696969696969FF00FF0069FF00FF00
FF00FF00FFFF00FF00696969696969696969696969696969
69696969696969696969FF00FF696969696969696900FF00
FF00FF65FF0000FF00FF696969696900FF00696969696969
6969696969696969
FFFF000000FF00FFFFFF00FFFF00000069FF00FF0000FF00
FFFF0000FF6969696969696969696900FF00FF69696900FF
00FF00FF6900FFFF00006969696969696969696969696969
6969696969696969696900FF006969696969696969696969
00FF006A00FF006969696969696969FF0000FF6969696969
6969696969696969
00FFFFFFFFFFFF00626A00FF00FFFF696969687069696969
69FF00FF0069696969696969696969696669696969696969
696969696969FF00FFFF6969696969696969696969696969
69696969696969696969686D696969696969696969696969
69696969696969696969696969696969FFFF006969696969
6969696969696969
00FFFF00FF0000FFFF00FFFF00FFFF0069FF00FF00FF6969
69FFFFFF006969696969696969696900FF00006969696969
696969696969FF00FF006969696969696969696969696969
696969696969696969690000FF6969696969696969696969
69696969696969696969696969696969FF00FF6969696969
6969696969696969
FF0000FF00FF000000FF0000FF0000FF6900FF00FF006969
69FF0000FF69696969696969696969FF00FFFF6969696969
696969696969FF0000FF6969696969696969696969696969
69696969696969696969FFFF006969696969696969696969
69696969696969696969696969696969000000FF69696969
6969696969696969
FF00000000FF00FF646A0000FF00FF696969677169696969
69FF00000069696969696969696969696D69696969696969
696969696969FF00FF006969696969696969696969696969
69696969696969696969656A696969696969696969696969
696969696969696969696969696969696900FF0069696969
6969696969696969
00FFFF00FF0000FFFF0035FF00FF700069FF0000FF696969
6900FFFF00696969696969696969FF00FF00696969696969
69696969696900FF00FF6969696969696969696969696969
69696969696969696900FF00696969696969696969696969
6969696969696969696969696969696969FF00FF69696969
6969696969696969
FFFF00FFFF00FF0000FF00696E69FFFF6900FFFFFF696969
69696B616969696969696969696900FF00FF696969696969
696969696969696A65696969696969696969696969696969
696969696969696969FF00FF696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
0000FF0000FF0000FF00FF696E69FF00FF00FFFF00696969
69696B616969696969696969690000FFFF00696969696969
696969696969696A65696969696969696969696969696969
69696969696900FF00FFFF00696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
FF00FFFFFFFFFF0000FFFF696E69FF00FF0000FF00696969
69696B6169696969696969690000FFFFFFFF696969696969
696969696969696A65696969696969696969696969696969
6969696900FFFF00000000FF696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
00FF00000000FFFFFF007F696E5D00FF00FFFF0000696969
69696B61696969FF6969690000FFFF00FF69696969696969
696969696969696A65696969696969696969696969696969
69690000FF00FFFFFF006969696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
00FF00FF0000FFFFFF0069696E3400FF0000FFFF69696969
69696B61696945FF69FF000000FF00FF6969696969696969
696969696969696A65696969696969696969696969696900
FF00FF00FFFF00FF69696969696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
0000FFFF00FFFFFFFFFF69696EFF0000FFFF000069696969
69696B616969FF00FF00FF00FF00FF696969696969696969
696969696969696A6569696969696969696969696900FFFF
000000FF0069696969696969696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
0000FFFF00FF00FFFF0069696E00FF0000FFFF6969696969
69696B61696900FF00FF00FF00FF69696969696969696969
696969696969696A65696969696969696969696900FF00FF
FFFF00696969696969696969696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
00FF00000000FF00FF6669696E00000000FF8D6969696969
69696B61696900FF00FFFF00006969696969696969696969
696969696969696A65696969696969696969696900FFFF00
FF6969696969696969696969696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
000000FF00FFFFFFFF6969696EFF000000FF696969696969
69696B616969FF00FF0000FF696969696969696969696969
696969696969696A656969696969696969696969FF0000FF
696969696969696969696969696969696969696969696969
6969696969696969696969696969696969696D6969696969
6969696969696969
FF00FF00FF0000FF00FFFFFFFF00FFFF00FF006900FF00FF
00696B61696900FF00FF00FFFF6969696969696900FF00FF
FF0069696969696A65696969696969696969696969FFFFFF
006969696969696969696969696969696969696969FF0000
FF00FF0069696969696969696969696969696D6969696969
6969696969696969
FFFFFFFF00FF0000FFFFFFFF0000FF0000FFFF6900FFFF00
FFFFFF61696900FF69FF00FF006969696969696900FF00FF
00FF00FF0069696A6569696969696969696969696969FF00
FF00696969696969696969696969696969696969FFFFFF00
FFFF00FF00FF6A00FF6969696969696969696D6969696969
6969696969696969
00FF0000FFFFFF0000000000FFFF00FFFF00006900000000
00FF00FF6969000069FF0000FF6969696969696900FF0000
FFFFFF00FFFF006A65696969696969696969696969690000
00FF69696969696969696969696969696969696900FF00FF
0000FF0000FF65FF0000FF0000FF696969696D6969696969
6969696969696969
00FF00FFFFFFFF00000000FFFF000000FFFF008D00FF00FF
00FFFFFF0069000069FF0000FFFF69696969690000FF0000
FF000000FF000000FF006969696969696969696969696900
FFFF0069696969696969696969696969696969FF0000FF69
69696969FF006900FF00FF00FF0000FF0000FF6969696969
6969696969696969
FF00FFFF000000FFFF0000000000FF00FFFF00FF000000FF
FF00FF00006971FF6900FF00FF00696969696900FFFF00FF
696900FF00FF00FFFFFF69696969696969696969696969FF
0000FF00696969696969696969696969696969FFFF000069
696969696969696969FF00FF00FF00FF00FF00FF69696969
6969696969696969
FF000000FFFFFF00FF00FFFFFF0000FF0000FF00FF00FFFF
00FF0000FF6969FF6969FF0000FF6969696969FF00FF0069
6969696969FFFF0000006969696969696969696969696969
000000FF6969696969696969696969696969FF0000FF6969
6969696969696969696969696969FF00FF00FF0069696969
6969696969696969
00FF000000FFFFFFFFFF00FF6900FFFF0000FFFF00FF00FF
69696969696969FF6969FF0000FFFF6969690000FF000069
696969696969696969696969696969696969696969696969
6900FFFF00696969696969696969696969FF0000FF696969
696969696969696969696969696969696969696969696969
6969696969696969
00FFFFFF00FF00FFFF0000FF69ADFF00FF00FF00FFFF0045
6969696969696900696900FF00FF0069696900FFFF00FF69
696969696969696969696969696969696969696969696969
69FF0000FF696969696969696969696969FFFF0000696969
696969696969696969696969696969696969696969696969
6969696969696969
FF00FFFFFFFFFF00FF00FFFF6951FF00FF00FFFF00FF0069
69696969696969FF69696900FFFF00696969FF00FF006969
696969696969696969696969696969696969696969696969
696900FFFF0069696969696969696969FF0000FF69696969
696969696969696969696969696969696969696969696969
6969696969696969
00FFFF00000000FF00FF0000696F00FF00FF0000FF00FF69
6969696969696900696969FF000000FF690000FF00006969
696969696969696969696969696969696969696969696969
69696900FF00006969696969696969FF0000FF6969696969
696969696969696969696969696969696969696969696969
6969696969696969
00FF00000000FFFF00FF0000696900FF00FFFF00FF00FF69
69696969696969716969690000FFFF0069FF00FF00FF6969
696969696969696969696969696969696969696969696969
696969FF0000FF696969696969696900FF00006969696969
696969696969696969696969696969696969696969696969
6969696969696969
00FF00FF0000FFFFFFFF00FF696900FF00FFFFFFFFFF0069
69696969696969696969696900FFFF0069FF0000FF696969
696969696969696969696969696969696969696969696969
69696969FFFFFF00696969696969FF0000FF696969696969
696969696969696969696969696969696969696969696969
6969696969696969
FF00FF00FFFF000000FF00AF6969FF00FF0000FF00FF0069
696969696969696969696969FF00000069FF00FFFF696969
696969696969696969696969696969696969696969696969
696969696900FF000069696969FFFFFF0000696969696969
696969696969696969696969696969696969696969696969
6969696969696969
0000FF0000FF00FF0000FF606969FF00FF0000000000ED69
6969696969696969696969690000FFFF0000FF0000696969
696969696969696969696969696969696969696969696969
6969696969FF0000FF6969696900FF00FF69696969696969
696969696969696969696969696969696969696969696969
6969696969696969
000000FFFF00FFFF0000FF69696900FFFFFF000000FF6969
6969696969696969696969696900FFFFFF0000FF69696969
696969696969696969696969696969696969696969696969
696969696969FFFFFF006969FF0000FF6969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
FFFF00FFFF00FF0000FF0069696900FFB1FF0000FF006969
6969696969696969696969696900FF00FF00FFFF69696969
696969696969696969696969696969696969696969696969
69696969696969FF00FF0069FFFF00006969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
FFFFFF00FFFF0000FFFF00696969FF004D00FF00FF006969
69696969696969696969696969FF00FFFFFFFF0069696969
696969696969696969696969696969696969696969696969
69696969696969000000FFFF00FFFF696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
FF0000FFFF00FF0000FFFF696969FFFF6900FFFF00006969
696969696969696969696969696900FF0000FF6969696969
696969696969696969696969696969696969696969696969
696969696969696900FF000000FF69696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
0000FF0000FF00FFFF00FF696969000069FF000000D86969
6969696969696969696969696969FF00FF00006969696969
696969696969696969696969696969696969696969696969
6969696969696969FF00FFFFFF0069696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
9F9F9F9F6969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
A0A0A0A06969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
696969696969696969696969696969696969696969696969
6969696969696969
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.0055371 0.732558 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -59 0 ]
[.5 1.0125 59 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -120 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Defect) show
105.000000 13.000000 moveto
(Sample) show
147.000000 13.000000 moveto
(Photo) show
177.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFF00FF00FFFFFF0000FF00FF0000FFFF00FFFFFFFF
0000FFFF00FF9AFF98980000FF00FFFFFF00FF00FFFFFF00
00FF00FF0000FFFFFFFF00FF989898989696969696969696
0000000000FFFFFF00000000FF00FF000000FFFFFF000000
FFFF00FF000000FFFFFF00FFFF00FF00FF0000FFFFFF00FF
9696969696969696
FFFFFFFF00FF00FFFFFF00FFFF00FF00FF0000FFFF000000
FFFF00FF00FF9A519898FFFF0000000000FFFFFF00000000
0000FFFF000000FFFFFF00FF989898989696969696969696
FFFF0000000000FFFFFFFFFF00FFFFFFFFFFFFFF00000000
00FF00FF0000FF00FF0000FF00000000FF0000FF00FF00FF
9696969696969696
FFFFFFFFFFFFFF00FF00FFFF00FF00FF0000FF0000FFFFFF
FFFF00FFFF009AAA98982F000000FFFF00FFFF00FF00FF00
FFFFFFFFFFFFFF00FFFFFF00989898989696969696969696
0000FF000000FF00FF00000000FFFF00000000FFFF000000
FF000000FFFFFFFF000000FFFFFF0000000000FFFFFFFF00
9696969696969696
FFFFFFFF0000FFFF00FF0000FF00FFFFFF000000FF0000FF
0000FF0000FF9A009898FFFF00000000FF0000FFFFFF00FF
00FF00000000FFFFFF0000FF989898989696969696969696
FFFFFFFF0000FFFF00000000FF0000FFFFFFFF0000FFFFFF
00FFFF0000000000FFFFFF000000FFFFFFFFFF00000000FF
9696969696969696
000000FFFF00FF000000FF00FF0000FF00FF00FFFF00FFFF
0000FFFF00FF91FF91910000FFFF000000FFFFFF000000FF
FFFF0000FFFFFF0000FF00FF919191919191919191919191
000000FFFFFFFF00000000FF00FFFFFFFFFF000000FFFFFF
FFFFFF0000FF00FF00FFFF00FFFFFFFF0000FF00FF0000FF
9191919191919191
00FFFF0000FF00FFFFFF00FF0000FF00FF0000FFFF000000
FFFF00FF00FF91869191FFFF00000000FFFF00FF00000000
0000FFFF000000FFFFFF00FF919191919191919191919191
FFFF0000000000FFFFFFFFFFFF00FFFFFFFFFFFF000000FF
00FF00FFFF00FF00FF0000FFFF000000FF0000FF00FF00FF
9191919191919191
00000000000000FF00FF0000FF00FF00FF00FF00FFFF0000
0000FF0000FF91409191FFFF0000FFFF000000FFFFFF0000
00000000000000FF000000FF919191919191919191919191
FFFF680000FFFFFF00000000000000FFFFFFFF0000FFFF16
00FFFFFF00000000FFFFFF000000FFFFFFFFFF00000000FF
9191919191919191
FFFFFF0000FF00FFFF0000FF00FF000000FFFFFF00FFFF00
FFFF0000FF0091FF91910000FFFFFFFF00FF00FFFFFF0000
0000FF0000FF00FF0000FF00919191919191919191919191
0000000000FFFFFFFFFFFFFF00FF00FFFFFFFF0000FFFFFF
00FFFFFF0000FF00FFFFFF00000000FFFFFFFF0000FFFF00
9191919191919191
FFFF000000FF00FFFFFF00000000FF00FF00FF0000FF0000
FF00FF0000FF915D9191FFFF0000FF003C0000FFFFFF0000
00FF00000000FFFF00FF00FF919191919191919191919191
FFFF000000FFFFFF00000000FF00FF00FFFFFF0000FFFF00
00FF0000FFFF00FF000000FF0000FFFFFFFFFF00FFFF00FF
9191919191919191
0000FF00FF00000000FF00FF00FF00FF00FFFF00FF00FF00
FFFF00FFFF0091FF91910000FFFFFFFF0000FF000000FFFF
0000FF0000FF00FFFFFFFF00919191919191919191919191
00000000FF000000FFFFFF000000FFFF000000FFFF0000FF
FFFF00FF0000FF00FFFFFFFFFFFF00FFFF0000FFFF00FF00
9191919191919191
FFFFFFFFFF00FFFFFFFFFF0000FF00FFFF00FF0000FF00FF
0000FF00FF009100919100FF0000FFFFFF000000FFFF0000
FFFF0000FFFFFF000000FF00919191919191919191919191
0000FF000000FFFF0000FF00FF0000FF0000FFFFFF000000
0000FF00FFFF00FF00FFFF00FFFFFFFF00FFFF000000FF00
9191919191919191
0000000000FF000000000000FF00FF000000FFFFFF000000
000000FF00FF91FF9191FF000000FF0000FFFFFF00FFFF00
000000FF000000FFFFFF00FF919191919191919191919191
FFFFFF000000FFFF000000FFFFFFFFFFFFFF0000FFFFFF00
000000FF00000000FF0000FF0000FF00FF0000FF00FF00FF
9191919191919191
00FFFF00000000FFFFFF00FF00FF000000FF00FFFF00FF00
FFFFFF00FF00919691919100FFFF0000FF0000FF000000FF
0000FFFEFFFFFF000000FF00919191919191919191919191
95A100FFFFFF00FF0000FFFFFF0000FFFFFF00FF000000FF
FFFF00FF7A00FF87D08FFF00B7FF00FF00DEFF00FF00FF00
9191919191919191
FF0000FFFF00FF000000FFFF919198FF9100FF0000FF008B
919191919191919191919191919E00FF00FFFF00FF00FA8E
919191919191919191919191919191919191919191919191
919191919190DA00FFFF000000FFFFFF0000FFFF0000C290
919191919191919191919191919191919191919191919191
9191919191919191
FFFFFF00FFFF7BFF0000FFFF00FFB1B391917700FF00FFFF
FFFF00FF00919191919191919191918F68FF00FFC000FFFF
FFFFFF9DFFFFFF0000FF9791919191919191919191919191
9191919191919191919190FF00FFFF00FFFF0000B60000FF
FF002682FFFF87BF000000FFFFFFFF0000FF00FF48929191
9191919191919191
0000FF00000000FF00FF0000FF0000FF9192FF00FFFF0000
0000FF00FF0091919191919191928A54FF0000FFFFFF0000
00000000000000FF0000FF00919191919191919191919191
9191919191918F9788683AAF56D000FF0000FF0000FFFF00
00FFFFFF0000FF00FFFFFF00000000FFFFFFFF000000FF00
9191919191919191
00FF0000FFFF00FF00FFFFFFFFFF55D491917D00FF00FF00
13FF0000FF919191919191919191919191FF00FFFF00FFFF
C6769251FFFF00FF00FF9491919191919191919191919191
9191919191919191919191919191FF00FFFFFF00000000FF
FF00FF897E9291918E96E8FFFFFFFF00FFFF00FF6F919191
9191919191919191
000000FF0000000000FF0000FF0000FF9191FF0000FF0000
0000FF00FFAB919191919191919191919100FF00FFFF0000
00000000000000FF00000091919191919191919191919191
919191919191919191919191918E00FF0000FFFF00FFFF00
00FFFFFF0000FF00FFFFFF00000000FFFF00FF00FF4A9591
9191919191919191
FFFF0000FFFF00FF00FF0000FF00FFFF9191FF00FFFF00FF
FF00FFFF000091919191919191919191EC00FFFFFFFF0000
FFFFFFFF000000FF0000FF00919191919191919191919191
91919191919191919191919191000000FFFFFF0000FFFF00
FF0000FFFFFF00FF000000FFFF0000FFFFFF00FF0000FF0A
9191919191919191
FFFF000000FFFFFF0000FF000000FFFF924AFF000000FFFF
00FFFF0000FF9191919191919164FFFF000000000000FFFF
FFFF00FF0000FF00FF0000FF919191919191919191919191
919191918E96FF00FFFFFF00FF00FFFF000000FFFF00FFFF
00FFFFFF00000000FFFFFF000000FF000000FFFF00FF00FF
9191919191919191
0000FF00FF0000FFFF0000FF00FF0000FF0000FF00FFFF00
FFFF00FFFF0091639191FFFF00000000FFFFFF00929160FF
0000FF0000FF00FF00FFFF00919191919191919191919191
FFFF000000FFFFFF000000FFFFFFFF008691919191919183
E8FFFF00FF00FF000000FF00FFFF00FF9191FF00FFFFFF00
9191919191919191
FFFF00FF00FFFF0000FFFF00FF0000FF00FF00FFFF0000FF
0000FF0000FF91FF91910000FFFF0000FFFFFF0091910000
00FF00FFFF00FF00FF0000FF919191919191919191919191
0000FFFFFF000000FF0000FFFFFFFFF791919191919191A3
00FF00FF00FF00FF00F9F700A800FF00E88E8094000000FF
9191919191919191
FFFFFFFF00FF00FFFFFF00FFFFFFFF00FFFFFF000000FF00
FFFF00FFFFFA9100919100FF00FFFFFF0000FF789300FFFF
0000FFFF000000FFFF0000FF919191919191919191919191
000000FFFFFFFFFF00FFFF000000FF8691919191942C00FF
FFFF00FF0000FF00FF0000FF00000000FF0000FF00FF00FF
9191919191919191
0000FFFFFF00FFFFFFFFFFFF00FF00FF00FFFF0000FF0000
FFFFFF00FF0091FF91910000FF00FF00FF9091BD00FF00FF
0000FFFFFFFFFF000000FF00919191919191919191919191
00FF00FF0000FFFF00509E91919191919191B100FFFFFF00
FFFF00FF0000FF00FF00FF00FFFF00FF00FFFF00FF00FF00
9191919191919191
FF00000000FF000000000000FF00FF00FF0000FFFF00FF00
000000FF00FF914F91918EFF000000FFFF00D000FF00FF00
FFFF0000000000FFFFFF00FF919191919191919191919191
5D00FF000000FF00FFFFFF00FC9091940000FFFF0000FF00
0000FF00FFFF00FF00B000FF0000FF00FF0000FF00FF00FF
9191919191919191
FFFFFFFF00FF0000000000FFFFFFFF000000FFFFFFFF00FF
AF00FFFFFF0091919191919900FF00FF00FFFFFF000000FF
B9919194DB0000FF00FFFF00919191919191919191919191
91919100FFFF0000FF0000FF000000FFFFFF00FF000000FF
006891919191919191919F3A9400C500FF5FFF00FF00FF24
9191919191919191
FFFFFFFF00FF0000FFFF000091911A0094FF00FF0000FFE1
9191919191919191919191919100FF00FF0000FF00FF00BB
919191919191919191919191919191919191919191919191
91919191919F00FF000000FF00FFFF0000FF0000FFFF009C
919191919191919191919191919191919191919191919191
9191919191919191
0000FF00000000FF0000FFFF919194FF9100000000FF0091
919191919191919191919191919124FF00FFFF00FF009091
919191919191919191919191919191919191919191919191
919191919191919100FFFF0000FFFF000000FF009B919191
919191919191919191919191919191919191919191919191
9191919191919191
FFFF00FFFFFFFF00FFFF0090919191009191FFFFFF00A491
919191919191919191919191919191ABFFFF00FF00919191
919191919191919191919191919191919191919191919191
919191919191919191919F00FF0000FFFF008E9191919191
919191919191919191919191919191919191919191919191
9191919191919191
9A9A9A9A9191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
9A9A9A9A9191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
569D9C787C928CEC6BDB8A919191919191919187FF719291
919191919191919191919191919191919193148189919191
919191919191919191919191919191919191919191919191
9191919191919191919191919191912FF0978F9191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
FF004DFFFF71FF00FF00FF9391919187919193FF00FF7291
91919191919191919191919191919191912FFFFFFF869191
919191919191919191919191919191919191919191919191
919191919191919191919191919191FF0000FF9191919191
919191919191919191919191919191919191919191919191
9191919191919191
0000FF0000FF00FF00FF0000FF0000FF91910400FF00FF00
73FF0000FF919191919191919191919191FF00FF0000FF51
9191919180FF00FF00FF9191919191919191919191919191
9191919191919191919191919191FF00FFFF0000000000FF
91919191919191919191919191FFFF00FFFF00FF91919191
9191919191919191
0000FFFF0000FF00FF0000000000FFFF9191FF00FFFF00FF
FF00FFFF009D919191919191919191919100FF0000FF0000
00FF71FF00000000FF000091919191919191919191919191
919191919191919191919191919100FFFF0000FFFFFFFF00
00FF00FFFF679191FF000000000000FF0000FF00FF919191
9191919191919191
FFFF0000FFFF00FFFFFFFFFFFFFF1B0091913BFF00FF0000
00FFFFFFFF009191919191919191919191FF00FFFFFF00FF
00000000FF0000FF0000FF91919191919191919191919191
91919191919191919191919191910000FFFFFF0000FF0000
FF00FF000000FF00FFFFFFFFFFFF00FFFFFF00FF00FF9191
9191919191919191
FFFF00FF00FFFFFFFFFF000000FF3100919100FF0000FF00
FFFFFFFFFF00919191919191919191918EFF00FF0000FFFF
0000FF00FFFFFFFF0000FFA3919191919191919191919191
91919191919191919191919191FFFFFF0091FF00FF00FFFF
00FFFF00FFFF00FF0000FF000000FF0000FFFF0000FF0091
9191919191919191
0000000000FF00FF0000FFFF0000FFFF9191FF0000FF00FF
0000000000FF91919191919191919191FF00FF00868EFF00
FFFF00FF0000BA00FFFF0000919191919191919191919191
9191919191919191919191919100FF00FF919191919191FF
000000FF0000FF00FFFF00FF00FF9191919100FF0000FF67
9191919191919191
FF0000FFFFFFFF00FFFF00FF0000FF00919100FFFF00BF00
FFFF000000FF9191919191919191919100FF00FF91919191
CF00FFFF42FF00FFFF0000FF919191919191919191919191
91919191919191919191919191FF00FF9191919191919191
91919191FF00FF00FF67919191FF00FF919191FFFFFF00FF
9191919191919191
FFFF000000FF00FF0000FF00FFFF00FF916BFF0000FF00FF
0000FFFFFF00919191919191919180FF000000FF91919191
00FF00FFFF00FF0000FFFF00919191919191919191919191
919191919191919191FFFF00FF0000FF9191919191919191
9191919191FF00FF929292929200FF0091919191FFFFFF00
9191919191919191
0000FF00FF0000FFFF0000FF00FFFF0068FF00FFFF00FF00
FFFF00FF00FF919191919191AFFF0000FF00FF0091919191
FF00FF0000FF00FFFF0000FF919191919191919191919191
91919191FF0000FF000000FF0000FF009191919191919191
919191919100FF009191919191FF00FF91919191FF0000FF
9191919191919191
FFFF000000FF000000FFFF00FF00FF000000FFFF00FF00FF
0000FF00909191619191D2FF0000FF00FFFF00FF91919191
00FF00FFFF00FF0091919091919191919191919191919191
FFFF000000FFFF00FFFF00FFFFFF00FF9191919191919191
9191919191FF00FF929292929200FF009191919191919191
9191919191919191
000000FF0000FFFFFF0000FF00FF00FF0000FF00FF74B600
FFFF00FF909191FF91910000FF00FFFF0000FF9491919191
9D00FF0086FF00FF91919091919191919191919191919191
0000FFFF0000FFFF0000FF0000FF67919191919191919191
919191919100FF009191919191FF00FF9191919191919191
9191919191919191
0000FFFFFFFF00FFFFFF0000FF00FF00FFFF00FF9300FFFF
00DF8D92909191FF9191FF00FF0000FF77919191919100FF
00FF0000CF91919191919091919191919191919191919191
FF00FF00FFFF000000FF9191919191919191919191919191
00FF00FF00FF00FF00BC9191919191919191919191919191
9191919191919191
FFFF000000FFFFFFFFFF00FFFF0000FF0000FF869100FF00
FFFFFF00CA9191FF9191000000FFFF919191919191A3FFFF
FF00FFFF0000FF00009D9091919191919191919191919191
00FF00FF00BC919191919191919191919191919191919100
FF00FF00FF00FF00FF0000FF0000FFFF00FFFF0091919191
9191919191919191
00FF00FFFFFFFF00FFFF00FFFFFF00FF0000FFFFA8FF0000
FF0000FFFF0091FF9191A600FFFF00FF919191919100FFFF
0000FF00FFFF00FFFF00FF00919191919191919191919191
FFFF00FFFFFF00919191919191919191919191919191FFFF
00FF00FF0000FFFF00FFFF00FFFF0000FF0000FF00FFFF00
9191919191919191
FF0000FF00FFFFFFFFFFFF00FF0000FF00FFFF0000FFFFFF
000000FFFF009138919194FF0000FF008E91919113FF0000
FFFF00FF000000FF00FFFF00919191919191919191919191
9100FF00FF00FF00BC919191919191919191919100FFFF00
FF00FF00FFFF0000FF0000FF0000FF00FF00FF00FF00FF00
9191919191919191
00FFFF00FFFF000000FFFFFF0000FF00FF0000FF00FFFF00
00FF00FF00FF91939191911FFF0000FFFF9191A3FFFFFF00
0091916500FFFF00FF0000FF919191919191919191919191
919191FF00FF00FF00FF91919191919191919100FF00FF00
FFFF919191919191919100FF67FF00FF00FF00FF00FF00FF
9191919191919191
FFFF00FF00FFFF00000000FF0000FFFFFF0000FFFF0000FF
8C91900000D6919191919191FF00FFFF00CC9100FF0000FF
DD91919191919191620000D2919191919191919191919191
9191919100000000FFFF009191919191919100FF00FF00FF
009191919191919191919191919191919191919100FF00BC
9191919191919191
FF00FF00FFFF0000000000FF9191FF005B00FFFFFFFF0000
91919191919191919191919194FF0000FF00B3FF0000FF00
919191919191919191919191919191919191919191919191
919191919100FF00FF00FF00BC9191919100FF00FF00FF00
919191919191919191919191919191919191919191919191
9191919191919191
FFFFFF0000FF0000FF0000FF9191FF0093000000FFFF005E
919191919191919191919191911400FF00FF00FFFF00FF8E
919191919191919191919191919191919191919191919191
91919191919100FF00FF00FF00BC9100FFFF00000000BC91
919191919191919191919191919191919191919191919191
9191919191919191
00FFFF0000FF0000FFFFFF009191710091FF00000000FF90
9191919191919191919191919191FF00FFFFFF0000FF9B91
919191919191919191919191919191919191919191919191
9191919191919191FF000000FF0000FF00FF00FF0E919191
919191919191919191919191919191919191919191919191
9191919191919191
FFFFFFFFFFFF0000FFFF000091919400910000FF0000FF91
919191919191919191919191919186FF000000FF00009191
919191919191919191919191919191919191919191919191
919191919191919191FFFF00FFFFFF00FF00FF0091919191
919191919191919191919191919191919191919191919191
9191919191919191
0000FF00000000FF0000FFA1919191FF9197000000FF0091
919191919191919191919191919191000000FF00FF8E9191
919191919191919191919191919191919191919191919191
9191919191919191919100FF00FFFF0000FFBC9191919191
919191919191919191919191919191919191919191919191
9191919191919191
FFFF00FFFFFFFF00FFFF00919191910091918FFFFF008D91
91919191919191919191919191919191FFFF00FFCD919191
919191919191919191919191919191919191919191919191
919191919191919191919191FF0000FF00BC919191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
989898989191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
00FFFF0000FF00FF00FF0000919191FF91912F00FF00FF91
9191919191919191919191919191919191FF000000FF9191
919191919191919191919191919191919191919191919191
91919191919191919191919191919100FFFF009191919191
919191919191919191919191919191919191919191919191
9191919191919191
000000FF00FF0000FFFF0000FF00000091919FFF00FF0000
8E000000FF91919191919191919191919100FF00FF00FF91
9191919191FF00FF00FF9191919191919191919191919191
919191919191919191919191919191FFFF00FF0000FF9191
91919191919191919191919191919100FFFF00FF91919191
9191919191919191
0000FFFF0000FF00000000000000FFFF9191FF00FF0000FF
FF00FFFF0091919191919191919191919100FF0000FF00FF
91919191FF00FF00FF009191919191919191919191919191
919191919191919191919191919100FF00FFFF00FFFFFF00
919191919191919191919191910000FF00FFFF0091919191
9191919191919191
00FF00FFFFFF0000FFFFFFFFFF00FF00919161FF00FFFF00
00FF00FF00E29191919191919191919191FF00FFFFFFFF00
00FF91FF00FF00FFFF000091919191919191919191919191
9191919191919191919191919191FF00FF9100FF00FF00FF
00FF0091919191919191910000FF00FFFF000000FF919191
9191919191919191
FF000000FFFF00FF00FFFFFFFF00FF9191919191FFFF00FF
0000FFFF00439191919191919191919191919191FF00FF00
FF00FF00FF00FF000000FF91919191919191919191919191
91919191919191919191919191919192919191919100FFFF
0000FF0000FF919100FFFFFF0000FF00FF91FFFF00919191
9191919191919191
FFFFFF00FF0000FF0000000000FF00FF9191FF00FF00FF00
FFFFFF00FFFF919191919191919191919100FF0000BC00FF
00FF00FFFF0000FF00FF0091919191919191919191919191
91919191919191919191919191910000FF91919191919100
FFFFFF00FF00FF00FF00FF00FF0091919191FF00FFFF9191
9191919191919191
FFFFFF000000FFFFFF00FFFF00FF0000919141FF00FF00FF
00FFFF00FFFF9191919191919191919191FF00FFFF919100
FFFF00FF00FF9100FFFF0091919191919191919191919191
9191919191919191919191919191FFFF0091919191919191
919100FF0000FF00FFFF00FF91919191919100FFFF009191
9191919191919191
00000000FFFF000091FF0000FF00FF91919191919291FF00
FF0000FF00FF919191919191919191919191929191919191
0000FF00FF9191FF00FF0091919191919191919191919191
919191919191919191919191919191919191919191919191
9191919100FF00FF00FF91919191919191919100FF009191
9191919191919191
0000000000FF00FF0000FF000000FFFF9191FF0000FF9191
919400FF00FF91919191919191919191FF00FF0091919191
919191919191910000FF0000919191919191919191919191
9191919191919191919191919100FF009191919191919191
91919191919191919191919191919191919191FF0000FF91
9191919191919191
FF0000FFFFFFFF00FFFF00FF0000FF00919100FFFF009191
9191FF0000FF9191919191919191919100FF00FF91919191
9191919191919191FF0000FF919191919191919191919191
91919191919191919191919191FF00FF9191919191919191
9191919191919191919191919191919191919191FFFF0091
9191919191919191
00FFFF00FF00FFFF0000FFFFFFFF00FF9191F90000B09191
9191FF00FF0091919191919191919191BC00FF0091919191
9191919191919191FF00FF00919191919191919191919191
9191919191919191919191919100FF009191919191919191
9191919191919191919191919191919191919191FF00FFFF
9191919191919191
00FFFFFFFF00FFFF91929100FFFF00919191919192919191
919100FFFF00919191919191919191919191929191919191
919191919191919100FFFF00919191919191919191919191
919191919191919191919191919192919191919191919191
919191919191919191919191919191919191919100FFFF00
9191919191919191
FFFF000000FF00FF0000FF00FF00FFFF9191FF0000FF00FF
0000FF0000FF91919191919191919191FF0000FF91919191
00FF00FFFF00FF00FF0000FF919191919191919191919191
919191919191919191919191910000FF9191919191919191
9191919191FF00FF919191919100FF0091919191910000FF
9191919191919191
0000FF00FF0000FF000000FF00FF9100918E00FF00FFFF00
FFFF00FF9191919191919191919191FF00FF00FF91919191
FF00FF0000FF00FF91919191919191919191919191919191
919191919191919191919100FFFF00009191919191919191
919191919100FF009191919191FF00FF9191919191919191
9191919191919191
00FFFF0000FF0000FFFF009093906C0091FF00FFFF009192
9191929191919191919191919191FF00FF00FFFF91919191
919191919191929191919191919191919191919191919191
9191919191919191910000FF00FF00919191919191919191
919191919191919191919191919192919191919191919191
9191919191919191
0000FF00FF00000000FF00FF00FFFF00BD00FFFF00FFFF00
FFFF00FF9191919191919191910000FF00FF006791919191
FF00FF0000FF00FF91919191919191919191919191919191
91919191919100FF00FF00FFFF00FF919191919191919191
919191919100FF009191919191FF00FF9191919191919191
9191919191919191
FFFF00FF00FF000000FFFF00FF00FF00FF0000FF009100FF
0000FF0091919191919191910000FFFFFF00919191919191
00FF00FFFF00FF0091919191919191919191919191919191
9191919100FFFF000000FF00919191919191919191919191
9191919191FF00FF919191919100FF009191919191919191
9191919191919191
00FF00000000FFFFFF009391928F00FF00FFFF0077919191
91919192919191D29191910000FFFF00FF91919191919191
919191919191919191919191919191919191919191919191
91910000FF00FFFFFF009191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
00FF00FF0000FFFFFF009191925800FF0000FFFF91919191
91919192919191FF9191000000FF00FF9191919191919191
919191919191919191919191919191919191919191919191
0000FF00FFFF00FF91919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
0000FFFF00FF00FFFFFF91919200FF0000FF008691919191
91919192919191FF9191FF00FF00FF919191919191919191
919191919191919191919191919191919191919191919191
FF0000FF0091919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
0000FFFF00FF00FFFFFF91919271FF00FFFF009191919191
91919192919191FF9191FF00FF0091919191919191919191
919191919191919191919191919191919191919191919191
FF00FF009191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
FFFF00000000FF0000FF00FFC14100FF0000FF919100FFFF
00839192919191FF9191FF0000FF919191919191919100FF
00FFFF919191919191919191919191919191919191919191
000000FF9191919191919191919191919191919191919191
91FF00FF0091919191919191919191919191919191919191
9191919191919191
FFFF000000FFFF0000FFFFFF005300FF0000FF8391FF0000
FF00FF92919191FF9191FF00FF00FF91919191919191FF00
FF00FFFF0091919191919191919191919191919191919191
9100FF000091919191919191919191919191919191919191
FF00FF00FF00FF00FF009191919191919191919191919191
9191919191919191
00FF00FFFFFFFFFFFFFF0000FF0000FF0000FFFF91FF0000
FFFFFF00919191FF91916700FFFF0091919191919191FF00
0000FF000000FF0091919191919191919191919191919191
91FF0000FF91919191919191919191919191919191919191
FFFF00FF0000FFFF00FF00FF0000FF919191919191919191
9191919191919191
00FFFFFFFF00FFFFFFFF00FF00FFFF00FF00FFFFA3FF00FF
00FF00FF009191FF91919100FFFF0091919191919100FF00
FFFF00FF00FF00FFFF009191919191919191919191919191
9191FFFFFF009191919191919191919191919191919191FF
0000FF9191FF0000FF0000FF00FF0000FF0000FF91919191
9191919191919191
FF00FF000000000000FF0000FFFF00FF00FF00FFA2FF00FF
FF00FF00FF009173919191FF000000FF919191919100FFFF
009191FFFF0000FF0000FF00919191919191919191919191
91919100FF0000919191919191919191919191919191FFFF
FF009191919191919191FF00FF00FF00FF00FF0000FFFF00
9191919191919191
000000FF00FFFF00FF00FF000000FFFF00FFFF00FF00FF00
00FF000000FF91929191916700FFFF00919191919100FF00
FF9191919167FF00FF0000FF919191919191919191919191
919191FF0000FF91919191919191919191919191919100FF
00FF91919191919191919191919191FF00FF00FF00FF00FF
9191919191919191
000000FFFF00FFFFFFFFFF00FFFF00FF00FFFF0000FFFF00
F7919CFFFF0091919191919100FFFF009191919100FFFF00
0091919191919191FFFFFF00919191919191919191919191
91919191FFFFFF0091919191919191919191919191FF0000
FF91919191919191919191919191919191919191FF00FF00
9191919191919191
FF00FF00FF0000FF00FFFF009191FF00FF0000FF00FFFF00
8E9191919191919191919191FF000000FF91919100FFFF00
BC9191919191919191919191919191919191919191919191
919191919100FF00009191919191919191919191FFFFFF00
009191919191919191919191919191919191919191919191
9191919191919191
00FFFF0000FF0000000000FF9191FF00FF00FF00000000FF
9191919191919191919191916700FF000091919100FF00FF
919191919191919191919191919191919191919191919191
9191919191FF0000FF919191919191919191919100FF00FF
919191919191919191919191919191919191919191919191
9191919191919191
00FFFF0000FF0000000000FF9191FF00FF000000FF0000FF
9191919191919191919191919100FFFF00919100FFFF0000
919191919191919191919191919191919191919191919191
91919191919100FFFF00919191919191919191FF0000FF91
919191919191919191919191919191919191919191919191
9191919191919191
FF0000FFFF00FFFF0000FF00919100FF8AFF00FFFF00FFFF
91919191919191919191919191FFFF00FFFF9100FFFF00BC
919191919191919191919191919191919191919191919191
919191919191FF0000FF009191919191919191FFFF000091
919191919191919191919191919191919191919191919191
9191919191919191
FF00FF00FF000000FF00FF009191FF008F00FF00FF00FFFF
91919191919191919191919191FF00FF000091FF00FF0091
919191919191919191919191919191919191919191919191
91919191919191000000FF91919191919191FF00FFFF9191
919191919191919191919191919191919191919191919191
9191919191919191
00FFFF0000FF00FF00FF00FF9191FF009100FFFF00FF00B4
919191919191919191919191919100FFFF000000FF000091
919191919191919191919191919191919191919191919191
919191919191919100FFFF009191919191FF0000FF919191
919191919191919191919191919191919191919191919191
9191919191919191
FFFF00FF00FFFF00000000FF9191ADFF9100FFFFFFFF008E
9191919191919191919191919191FFFF00FF00FFFF00BC91
919191919191919191919191919191919191919191919191
9191919191919191FF0000FF0091919191FFFF0000919191
919191919191919191919191919191919191919191919191
9191919191919191
FF00FF00FF000000FF00FFFF9191830091FF00FF00FF0091
9191919191919191919191919191FF00FF00FF00FF009191
919191919191919191919191919191919191919191919191
919191919191919191000000FF919191FF0000FF91919191
919191919191919191919191919191919191919191919191
9191919191919191
00FFFF0000FF00FFFFFF000091918B0091FF00FFFF00FF91
91919191919191919191919191919100FF0000FF00009191
919191919191919191919191919191919191919191919191
9191919191919191919100FF000091FF0000FF9191919191
919191919191919191919191919191919191919191919191
9191919191919191
00FFFF0000FF00FFFFFF002191919200913EFFFFFF00FF91
919191919191919191919191919191FF000000FF00BC9191
919191919191919191919191919191919191919191919191
91919191919191919191FF0000FF9100FF00009191919191
919191919191919191919191919191919191919191919191
9191919191919191
FFFF00FFFFFFFF00FFFF00E2919191FF9192FFFFFF000091
91919191919191919191919191919167FF000000FF919191
919191919191919191919191919191919191919191919191
9191919191919191919191FFFFFFFF0000FF919191919191
919191919191919191919191919191919191919191919191
9191919191919191
0000FF00000000FF0000FF8B919191FF9191FF0000FFE791
919191919191919191919191919191910000FF0000919191
919191919191919191919191919191919191919191919191
91919191919191919191919100FFFF00FF00919191919191
919191919191919191919191919191919191919191919191
9191919191919191
FFFF00FFFFE8FF00FFFF00919191910091911EFFFF008E91
91919191919191919191919191919191FFFF00FFBC919191
919191919191919191919191919191919191919191919191
919191919191919191919191FF0000FF0091919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
969696969191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.0055371 0.97619 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -59 0 ]
[.5 1.0125 59 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -120 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Second) show
105.000000 13.000000 moveto
(Sample) show
147.000000 13.000000 moveto
(Photo) show
177.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFF00FF00FFFFFF0000FF00FF0000FFFF00FFFFFF00
FF0000FF00FF96FFBA910000FF00FFFFFF00FF00FFFFFFFF
0000B4FF0000FFFFFFFF00FF919191919191919AC688ACAA
0000000000FFFFFF00000000FF00FF4C0000FFFFFF000000
FFFF00FF2900FF00FFF200FF0000FF00FF0000FF9DFF00FF
9191919191919191
FFFFFFFF000000FFFFFF00FF0000FF00FF0000FFFF000000
00FF00FF00D594DDA055B2FF0000000000FFFFFF000000FF
000000ACFF0000FFFFFF00CC9191919191919194A6738E91
FFD04500000000FFFFFFFFFF00FFFFFFFFFFFFFF00000000
00FF03FF9E00751AFF00FFFFFF00FF3CFF7D00D634FF00B8
9191919191919191
FFFFFFFFFFFFFF00FF00FF0000FF0000FF00FF0000FFFFFF
FFFF00FFFF88400000FFFF0000FFFFFF00FFFF00FF7DFF61
FFCCFFFF00FFFF00FFFFFF8B919191929191913800FF9AAA
DF0000D28B86F066A0A4400000FFFF0000004ECAFF000051
FF0000B1FFFFABCA0F3900B4FFFFAC00000000FFFFFFFF8D
9191919191919191
FFFFFFFF0000FF0000FF0000FF0000FFFF000000FF430000
0000FF0000FF000000FF00FFFF000000FF0000FFFFFF0000
00000000001700FFFF0000FF919191949191910000FF315F
FFFFFFBC680293FF0000007FFF0000FFFFFFE90000FFFFC0
00FFFF470000BE00FFFFFF00000003FFFFFFFF00000000E4
9191919191919191
FF0000FFFF00FF000000FFFFFF0000FF00FF00FFFF00FF00
FFFF00FF00FF92FF9A910000FFFF000000FFFFFF0000FFFF
00FFFF00FF25FF0000FF00FF91919191919191939C8F9796
000000FFFFFFFF00000000FFFF00FFFFFFFF000072FFFFFF
FFFF0000FFFF63FF0000FF00FF0038FF0076FF40FF0000FF
9191919191919191
0000FF00000000FFFFFF00FF004E0000FF0000FFFF000000
00FF00FF0098840048FFDDCF007F0000FFFF00FF000000FF
00FF0000FF00A7D7FFB6009891919191919191822FFF9E91
EC7B4F76500900FFFFFFFFFFFF009DE9FFFFFFFF00000075
A8D20055C97D2F328D00FFFFB500CC57E68D00CA8AFF1295
9191919191919191
0000FF000000000000FF0000FF00FFFF00FF3900FFFF0000
0000FF0000C6FFFFFF008FFFFF0000C0000000FFFFFF002A
00000040000000FF000000B99191918D919191FFFF00FF1C
00FFFF00475C6EDE8B000046FF0000FFFFFFCD0000FFFF8F
00FFFFA90000B317FFFFFF00000028FFFFFFFF00000000AD
9191919191919191
FFFFFF0000FF00FF0000000000FF00FF00FFFFFF00FFFF00
0000FF00FF00620000FF0000FFFFFF5300FF00FFFFFF00FF
0000CFFF000000FF0000FF3D919191929191914900FF3240
00FFFF0000FFFCFFFF0000FF00FF00FFFFFFFF0000FFFF9B
00FF5FFF0000E84BFFFFFF00000044FFFFFFFF0000F3FF77
9191919191919191
FFFF00FF00FFFFFFFF000000000000FFFFFF00FF00FF0000
FF00FF0000FF86002B3A00FFFF0000FFFF0000FFFFFF0000
00FFFF00000000FF00FF00FF9191919191919179262C0000
00FFFF00FF0000FF00FFFF00FF00FF00FFFFE30000FFFF34
00B70000FFFF42FF00000098000000FFFFFFFF00FFFF00FF
9191919191919191
FFFFFF0000000000FFFF00FFFFFF00FF00FFFF00FF00FF00
00FF00FFFF0090C98E9B0000FFFF00FFFF00FF004E30FFFF
005331FF7159FF79FFFFFF0091919191919191908BA09E9B
00000800FF000000FFFFFF00004CFFFF606E8DBBE50C5BFD
FFFF43FF3800A267FFEFE5EC9755B001C53F32FFFF00FF00
9191919191919191
00FFFFFFFF00FFFFFFFFFF0000FF00FFFF00FFFF00FF00FF
00000000FF009164919100FF0000FFFF50FF0048FFFF0000
FFFF0000FFFF00000000FF00919191919191919191919191
0000FF000000FFFF000A6098FF0000978653FFFFFF490000
0000FF0000FF00FF00FFFF00FDFF00FF00B8FF652400FF00
9191919191919191
0000290000FF00000000FFFFFF00FF000000FFFFFF0000FF
00FF00FF00FF9195919198000000FF0000FFFFFF00FFFF00
FFFF00FFFF000DFFFFFF00FF919191919191919191919191
C8A1F1000000FFFF000000FF97FF9CFFFFFF0000FFFFFF00
0000FFFF12FF0000FF00FFFFFF00FF1CFF7800FF00FF00FF
9191919191919191
0000FF00FF0000FFFFFF00FF00FF800088FF00FFFF00FF00
0000FF20FF8991919191918EDFFF0000FF0000FF000000FF
00FF0000FF00FF7D6C80FF8A919191919191919191919191
919183B0E2EB00F8001AFFFFFF0000FFFFFF6BFF000000FF
C8C42022D2E200000000FFFF00FF79947C92B78C9A44FF8C
9191919191919191
FFFF70FF03D8FF880000F900759693BF988CFF0000FF7C7D
FFFF3C939191918E93839990919180FF00FFFF00FF819291
9280E1F300FF7B90919191919191919191919191928E9390
919191919191928CAEA8870017FF9CE20F00A6988D8C9191
919191918F8BA19E9BB5241CFF0097919191919191919191
9191919191919191
FFFF0000FF15FFCCDD1DFFFF00A500000000A47AFF00E397
9DE000FF8D913D0000FF00EB00BD9790909900E29142C099
969392919FA6AB778B979191919191929191913B00FF00E2
C1464AA69992939091919192889EA900FFCF8E62915E7892
A4859091939391918F8E8E9CA3AF955A8CC707BA90919191
9191919191919191
0000FF000000000000FF0000FF00FFFF00FF0000FFFF0000
0000FF00FF8AFFFFFF0000FFFF0000E8000000FFFFFF0000
00000000000000FF0000FF8C9191918B919191FFFF0000FF
00FFFF00350000E2C14649A6979500FF0000F14500FFFF87
00FFFF970000A33BFFFFFF00000000FFFFFFFF000000EA8E
9191919191919191
00FF000095ADFF0000FFCDE5FFFF0000FF00A266FF00F88F
90D100189991FF00FF00FF0000B99091919D00FFE000C693
9191919097B08EC5009D91919191918D919191FFFF00FF00
005900B195909191919191919191A100FFFF9400575A7F93
978D9291919191919191929496AA9749B7FF00AD91919191
9191919191919191
0000FFFF0000000000FF0000FF00000000FF000000FF0000
0000FF00FF91000000FFFF00FF0000B99000FF00FFFF0000
00223285000000FF00008E91919191949191910000FFFF00
00FFFF00005900B195909191919100FF0000FFFF00FFFF55
00FFDC9A00009775FFFFFF00000000FFFF00FF00BB909191
9191919191919191
FFFF0000FFFFFFFFFFFF0011FF0000FFFF00FF00D5FF00FF
FF00FFFF007E9700B40900FFFF00FF000000FFFFFFFF0000
FFFFFFFF000000FF0000FF8E9191919191919196E7001000
00FFFF0000FFFF00005900B195590000FFFFE70000FFFF00
FF0000FFFFFF59FF000000FFFF0000FFFFFF00FF0000C890
9191919191919191
FFFFAF0000FFFFFF0000FFFF0000FF0E00FF00FF0000FFFF
00FFFF0000FF91939190BC1900FFFF00FF00003F5925FFDC
FF6700FF5EFFFF00FF0000FF919191919191919191918AB1
DF00110000FFFF0000FFFF000000FFFF6B828DA4E4009FAA
00FFFFE90000B600FFFFFF0021ACAC004860B6FF00FF00FF
9191919191919191
ABFFFF0066000000FFFF0000FFFF0000FB000000FF0E9D36
BDA440FFFF009190919194C4000000FFFFFFFF1B91919099
7A89A36A9E91919315FFFF00919191919191919191919191
ACBC471AD55348FF00FFFF0000FFFF2C9191919191919191
92949D8D99B1909672829F8D929191919191942AFFFFFF00
9191919191919191
FF6900FFFF00FF0000FFED17000000FF00FF00FF849545FF
6B8D9100009C91AD91910000FFFF0000FFFF758D91918F80
5EE4856D97958F929300009D919191919191919191919191
0000FFFFFF000000FF000000FF00BF929191919191919191
86B585D18FCA89957592928B91949091929191918E00009B
9191919191919191
FFFFFFFF00FF00FFFFFF00FFFFEEFF00FFFFFF00A046FF00
FFFFFFE29A929100919178FF00FFA6FF2B00A0919188FFFF
0000FFFF0000FFFFFF1A7193919191919191919191919191
000000D1AFFFF4FF01ACFFA9217A969191919191919081FF
FFFF00FFA200FF00FF4C00FF6800EE73FF8A00AA75FF6992
9191919191919191
0000FFFFFF00FFFFFFFF00FF00FF00FF00FFFF006FFF00FF
FFFFFF00FF0091AD91918A00FF00FF009691919166FF0000
FF00FFFFFFFFFF000000FF00919191919191919191919191
60C700FF0000FFFF3A9091919191919191919179FFF5FF00
FF00FFFF0000FF00FF72FF00B1FF00FF00FFFF00FF00FF00
9191919191919191
FF00000000FF00000000FFFF0000FF00FF0000FFFF000000
FF0000FF00FF9190919191B9000000FFFF829148FF00FF00
FF00FF0000008CFFFFFF00F8919191919191919191919191
908FFF000000FF00FFFFFF61929191918D4FFFFF0000FF00
0000FFFF0000FFFF00004193AC00AA74FF8B00E800FF00D6
9191919191919191
FFFFFFFFFF0000000000000000FF9F008F00FFFFFFFF0000
00FF0091B38F9191919191918DFF00FF00FFFFFF000000FF
0000FF00FF00CFA2849CB58F919191919191919191919191
9191918CD8C30000FF0000FF8B6B89FFFFFF00FF000000FF
B8DE00110000FFFF0000FFFF0000B18F9E909D8F966BAF90
9191919191919191
00FF00FFFFFF0000FFFF00FFFF00900091DA00FF0000FFFF
0000FF3D9191919191919191918FFF00FF0000FF00FF8391
87FF0000FF00FFAA91919191919191919191919191919191
91919191919187D0000077FF00FFFF0000FF006AC7D18A91
9191918AB1DF00110000FFFF00FF00919191919191919191
9191919191919191
0000FF00000000FF0000FF0000A491FF918F8F0000FF7E8C
FFFF00959191919191919191919190E500FFFF00FF889191
919187FF00FF599091919191919191919191919191919191
91919191919191918FC2A10000FFFF000000D88991919191
919191919191918AB1DF0011FF009E919191919191919191
9191919191919191
FF858DFFB389AF00FFFF7D958891918A919192FFFF8C9191
8FB48B91919191919191919191919191969400EA8E919191
9191919181A1909191919191919191919191919191919191
919191919191919191919182FF007BE5D48E919191919191
91919191919191919191918A7A8291919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
8A9B00058F65FF86A4929191918A080000A6919193919191
91919191919175FF1AFF00B9909191919191909191919191
919191919191919191919191919191919191917555FF00B1
959091919191919191919191919191909291919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919196959192839190919191919195999891919191919191
919191919191918E92779691919191919191919191919191
91919191919191919191919191919191919191919B859291
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
70C200008A00FF2BF29191919179000000E5919191919191
91919191919110FF00FF00BF919191919191919191919191
919191919191919191919191919191929191915300FF00AB
909191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
FF00FFFFBFFF008A0064959191FFFFFFFF008E9700A59191
919191919191FF00FF00FF00B69191919190DD9B96919191
9191919191919191919191919191917D919191FF0000FF00
00AB90919191919191919191919191CD578D929191919191
919191919191919191919191919191919191919191919191
9191919191919191
00000000009300FF00FF0059FF3BFFFF0000FF00FF00FF8E
919F0000B19100FF00FF00FF00B6919191E700FF0000BE90
9191919191A234FF00B09191919191929191915700FF0000
FF0000AB909191919191919191919B00FFFF000000678D92
919191919191919191919191919B9836FFFF00AF91919191
9191919191919191
0000FFFF0000FF000000000000000000FFFF0000FFFF00E0
DB00FFFF00919D009C00FF00FF00B6919100FF0000FF0000
71A191B800000000FF008F91919191919191918FED0000FF
0000FF0000AB909191919191919100FFFF0000FFFFFFFF00
00FF42969C909191938E5C00000000FF0000FF00A6919191
9191919191919191
FFFF0000FFFF00FF00FFFFFFFF991D00FF0000FF00FF0000
00FFFFFFBB8E9124919C00FF00FF00B691C547FFFFFF00FF
00000000FF0000FF0000BE919191919191919191918FED00
00FF0000FF0000AB9091919191912D00FFFFB33500FF0000
FF00FF0000009E53F3FFFFFFFFFF00FFFFFF00FF00979191
9191919191919191
FFFF00FF00FFFFFFFFFF000000FF00FF00FFFFFF000EFF00
FFFFFFFFC28C919D91919C00FF00FF00B6FF00FF8E00C2FF
0000FF00FFFFFFFF0000CD9191919191919191919191918F
ED0000FF0000FF0000AB90919193FFFF0091937DC600FFB3
00FFFF00FFFF00FF0000FF001611C8006097FF0000EC8F91
9191919191919191
0000002700FFFFFFFF00FFFF000088FF24FF0000009600FF
0000680000B191919191919C00FF00FF0000FF3091919726
FFB200FF008F9176FFFF0084919191919191919191919191
918FED0000FF0000FF0000AB9000FF009291919191919193
856000C810009D57FFFF00C97F92919191916BFF0000FF90
9191919191919191
FF0000FFFFFF000000FF85CE0000FF009D00FFFFFF8191A4
8591C50000FF9191919191919C00FF00FFA900FF91919191
919A8AA090919191920000FF919191919191919191919191
9191918FED0000FF0000FF0000FF00FF9191919191919191
919191919385918F9C9091919191919191919193FFFF00E0
9191919191919191
00FFFF00F100BFFF0000FF49FFFF00629124FF0000FF9191
919144FFFF00919191919191919C00FF00FF00FF91919191
919191919191919158FFFF00919191919191919191919191
91919191918FED0000FF0000FF0000FF9191919191919191
9191919191919191919191919191919191919191A4FFFF00
9191919191919191
0081FF0000FF00FFFF002B941910970090C600FFFF009191
91919400009991919191919191AC0000FF00FF0091919191
91919191919191919400009A919191919191919191919191
91919191938E36FF000000FF0000FF4D9191919191919191
919191919191919191919191919191919191919193000099
9191919191919191
FF76FF00FFFD000000FF9B919191D7007A00FFFF009E9191
9191919191919190919191B40000FF00FFFF009591919191
919191919191919191919191919191919191919191919191
9BC1000000FFFF00FFFF0000FFFF48929191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
00EF00FF0000FFFFFF009191919000FF0000FF0096919191
91919191919191A991910000FF00FFB73F5B939191919191
919191919191919191919191919191919191919191919191
0000FFFF0000FFFF0011FF7F679291919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
002CFFFFC3FF00FFFFC00055948EFF00FFFF00A0918DFFFF
66929191919191FF9191FF00FF1B00A29191919191918EFF
00E780829191919191919191919191919191919191919191
FF00FF00A0FF006288929191919191919191919191919191
8FFF54FF89C28A9385919191919191919191919191919191
9191919191919191
FFFF000000FFFFFFFFFF00FFAD8824FF0000FF919172FF00
FFFFFF73919191A29191500000FF9291919191919191F4FF
FF00FFFF0000FF4B88919191919191919191919191919191
00D800FF7A91919191919191919191919191919191919191
FF00FF00DF00FF00FF5553FF8300AE9A5C939B8F91919191
9191919191919191
00FF00FFFFFFFF00FF00FFFFFFFF17FF0000FF9991000000
FF0000FFFF84919D91919100FFFF199291919191919000FF
0000FF00FFFF00FFFF00FF89919191919191919191919191
98BC00FFFFFF80919191919191919191919191919191A3FF
00FF00FF7300FFFF00C3FF00FFFF0000FF1600FF53FFFF8B
9191919191919191
FF0000FF00FFFFFFFFFF0000FF0000FF53FFFF0287FFFFFF
000068FFFF009190919191C80000FF459191919190FF0000
FF007BFF000000FF00FFFF00919191919191919191919191
918FFF00FF00FF8F9191919191919191919191918FCEFF00
FF0000FF00339372FF8A57FF8400FF00FF08FF00FF00FF15
9191919191919191
00FFEB00FFFF000000FFFF000000B300980000FF89FFFF00
00FF66A300A2919191919190B80000FF97919191C0FFFF00
00FF00FF85D5D800FF1600A2919191919191919191919191
919191D700FF00FF249391919191919191919186FF00FF00
0000FF0000FF0000AB908F9C90C28AB0009700A957FF009C
9191919191919191
FF1ED4FF0000FF000000FFFF00869FFF980000FFFF0000FF
FF00878883919191919191919200FFFF00919177FF0000FF
0000FF00FF8F9191908E8391919191919191919191919191
919191918F240000FFC589919191919191917DFF00FF00FF
85ED0000FF0000FF0000AB9091919191919191918F9E8591
9191919191919191
FFFF8C21FFFF0000000000FFFF8092009027FFFFFFFF9200
0000FF91919191919191919191B20000FF6591FF0000FF8A
FF0000FF00FF8F9191919191919191919191919191919191
91919191918FFF00FF00FF6991919191917AFF00FF00E68F
91918FED0000FF0000FF0000AB9091919191919191919191
9191919191919191
FF00FF0078000000FF00000000E3920091480000FFFF0000
FFFF00889191919191919191919000FF00FF6DFFFF009891
8FFF0000FF00FF9091919191919191919191919191919191
9191919191918FCE00FF00FF5391918FFFFF0000008C9191
919191918FED0000FF0000FF000097919191919191919191
9191919191919191
00FF0000FFFF0000FFFFFFFFFF16916191A400000000FFDD
0000FFAA91919191919191919191A000FFFFFF0000FF9191
918FFF0000FF008E91919191919191919191919191919191
9191919191919191AE003200FF6E8AFF00FF00FF90919191
9191919191918FED0000FF000000BD919191919191919191
9191919191919191
FF00FFFF00006A00FFFF00FF00FF9100918F00FF0000B28E
00FF00B29191919191919191919191F5000000FF008D9191
91918FFF00FF008391919191919191919191919191919191
91919191919191919198BC00FFFFFF00FF00DD8D91919191
91919191919191918FED00000000FF919191919191919191
9191919191919191
00FFEA0000F700FF0000FF59FF8C91FF91917B0000F58F91
A900DA9091919191919191919191918D0000FF00AF919191
9191918FFF009C9191919191919191919191919191919191
919191919191919191918FFF00FFFF0000B8919191919191
919191919191919191918FEDFFFF88919191919191919191
9191919191919191
FF968DFFAB92A600FFFF81919191918C919191FFFF8C9191
919191919191919191919191919191919DF500A591919191
919191919191919191919191919191919191919191919191
919191919191919191919191D70079FF8691919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
899F00008F53FF75A99191919189000000A4919191919191
9191919191916AFF2DFF0098919191919191919191919191
919191919191919191919191919191919191919100FF3291
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
897AFFD98EF1FFB7A991919191B9000000C6919191919191
919191919191FF00000000F7919191919191919191919191
9191919191919191919191919191919A91919100FF0000AB
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
B7A0FFD49A5700341E919191915CFFFFFF00919191919191
9191919191916AFF0000FF008F9191919191919191919191
9191919191919191919191919191919B91919100FFFF0000
AB9191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
B7AE7E619A18001D1C919191914AFFFFFF118A9191919191
91919191919100FF00FF0000ED9191919191919191919191
91919191919191919191919191919190919191AB00FFFF00
00AB91919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
00E5BF0000C6FFFF00FF008F91A6001D0000B000FF00A491
919191919191B100AB0000FF008F919191CD000000989191
9191919191919191919191919191919191919191AB00FFFF
0000AB91919191919191919191919100FFFF329191919191
919191919191919191919191919191919191919191919191
9191919191919191
000000FF00FF7B00FFFF0000FF0023FF0000DFFF00FF008F
91520000FF9195009000FF0000ED91919188FF00FF00AE91
91919191919300FF00FF9191919191919191919191AB00FF
FF0000AB9191919191919191919191FFFF00FF0000AB9191
91919191919191919191919191919118FFFF00FF91919191
9191919191919191
0000FFFF0000EA000000000000360000FFFF0000FF0000FF
A300FFFF3991905991AB0000FF008F919100FF0000FF00B8
919191919B00FF00FF00919191919191919191919191AB00
FFFF0000AB91919191919191919100FF00FFFF00FFFFFF32
919191919191919191919191910000FF00FFFF0091919191
9191919191919191
00FF0060FFFF210034FFFFFFFF000000FFFF10E800FFFF00
00FF00FF0A929100919000FF0000ED9191AE00FFFFFFFF00
0798919B00FF00FFFF0086919191919191919191919191AB
00FFFF0000AB9191919191919191EF00EF9177FF00FF00FF
00FF3291919191919191910000FF00FFFF380000FF919191
9191919191919191
FF004300FFA700FF00FFFFFFFF37E3FF000000B193FF00FF
0000FFFF849091B19191AB0000FF008F919191919316FF00
FF00A400FF00FF8A00009B91919191919191919191919191
AB00FFFF0000AB919191919191919191919191919100FFFF
0000FF0000AB919118FFFFFF0000FF009691FFFF04919191
9191919191919191
FFFFFF00FF0000FF0000000000FFB40000000000FF00FF00
FFFFFF00FF92919591919000FF0000ED9100FF00869137FF
00FF00FFFF528BFF00FF7A91919191919191919191919191
91AB00FFFF0000AB9191919191910000FF91919191919177
FFFFFF00FF00FF00FF00FF00FF7C91919191FF00EFAB9191
9191919191919191
FFFFFFFF0000FFFFFF03FFFF00FF32FF59FFFF431AA455FF
00FFFF00FF9E9190919191AB0000FF008FC100BF9291917C
FFFF00FF009B9154FFFF0091919191919191919191919191
9191AB00FFFF0000AB9191919191FFFF7C91919191919191
919100FF3200FF00FFFF009691919191919177FFFF009191
9191919191919191
000000FFFFFFFFFFFF200000FF0071FF00FFFF118A919200
FF8800FF009D91919191919000FF0000ED91919191919191
8B15EB009991919D00FF0091919191919191919191919191
919191AB00FFFF0000AB9191919191919191919191919191
9191919177FF8BAB009691919191919191919100FF009191
9191919191919191
6B00000000FF00FF000099700000D600B10000000F929191
91910BFF00AD919191919191AB0000FF0000FF7291919191
919191919191918F0DFF0086919191919191919191919191
91919191AB00FFFF0000AB919118FF189191919191919191
91919191919191919191919191919191919191EF0000FF91
9191919191919191
FF8F76FFFFFF9700FFFF4897000DA013950000FFFF899191
91919C00009A9191919191919000FF0000FF00FF91919191
91919191919191919C00009B919191919191919191919191
9191919191AB00FFFF0000AB91FF00FF9191919191919191
9191919191919191919191919191919191919191FFFF0491
9191919191919191
73FFFF59FF009BFF0000A49BFFFF4F009059FFFF00919191
9191DB5FFF5991919191919191AB0000FF00C18A91919191
9191919191919191FF00FF7A919191919191919191919191
919191919191AB00FFFF0000AB77FF779191919191919191
9191919191919191919191919191919191919191FF00EFAB
9191919191919191
AEFFFF85CA006BD600009E5AFFFF0C009100FFFF118A9191
919151FFFF00919191919191919000FF0000ED9191919191
919191919191919154FFFF00919191919191919191919191
91919191919191AB00FFFF0000AB91919191919191919191
919191919191919191919191919191919191919177FFFF00
9191919191919191
0041700072FF8DFF0000FF933C3595FF91B1000000FF9191
919193271C979191919191919191AB0000FF00FF91919191
919191919191919193160897919191919191919191919191
9191919191919191AB00FFFF000000FF9191919191919191
919191919191919191919191919191919191919191180896
9191919191919191
FFB786FFE59AC800FFFF1F919191917491950000FF2C9191
91919191919191919191919191919000FF00FF4591919191
919191919191919191919191919191919191919191919191
919191919191919191AB00FFFF00FF7C9191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
0080FF00009400FFFF00C0919191900091A700FF00839191
91919191919191919191919191919B00FF00FF9391919191
919191919191919191919191919191919191919191919191
9191919191919191910000FF00FF77919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
FF8EFF00FFA1000000FF9091919199009100FF7B8D939191
919191919191919191919191917600FF00FF739191919191
919191919191919191919191919191919191919191919191
91919191919118FF00FF00FFFF7C91919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
FF8DC8FFFFA4820000FF91919191B900AD0000FF8D919191
9191919191919191919191917F00FFFFF58B919191919191
919191919191919191919191919191919191919191919191
9191919118FFFF000000FF7C919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
00AE0000600AFFFFFF0D9191919100FF00FFFF0091919191
91919191919191919191916900FFFF009491919191919191
919191919191919191919191919191919191919191919191
91910000FF00FFFFFF7C9191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
00A000FF6949FFFFFF629191919074FF0000FF9991919191
91919191919191B49191690000FF009B9191919191919191
919191919191919191919191919191919191919191919191
0000FF00FFFF009691919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
0054FFFF6BFF00FFFF9E9191918BFF0000FF009191919191
91919191919191FF9191FF00FF2D92919191919191919191
919191919191919191919191919191919191919191919191
FF0000FF7C91919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
597FFFFF85E200FFFC9891919191FF00FFFF2F9191919191
91919191919191A49191FF1CFF4191919191919191919191
919191919191919191919191919191919191919191919191
EF00FF779191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
FFFF0000005EFF005CBE00FF919024FF0000FF919181FFFF
8C919191919191C19191A70000FF919191919191919186FF
00CB93919191919191919191919191919191919191919191
320000FF9191919191919191919191919191919191919191
91FF00FF7791919191919191919191919191919191919191
9191919191919191
FFFF000000FFFF0000B8FFFF00902EFF0000AB9191F80000
FF609491919191AA91919A00FF0A9391919191919191F700
FF00FFFF6B91919191919191919191919191919191919191
9100FF2D7791919191919191919191919191919191919191
FF00FF00FF00FF18FF779191919191919191919191919191
9191919191919191
00FF00CAFFFFDC4CEEFF0000FF7981FF0000B29591D10000
FFFFFF7E9191919291919028FFFF5491919191919191CA00
0000FF000000FF8A91919191919191919191919191919191
91AB0000FF91919191919191919191919191919191919191
FFFF00FF7700FFFF00FF00FF1800EF919191919191919191
9191919191919191
00FFFFFFFF00FFFFFFFFFFFF00FFFF00FF00FF9B91F70000
00FF00FF6E9191929191914DFFFF0991919191919191FF00
00FF00FF00FF00FFFF8A9191919191919191919191919191
9191ABFFFF77919191919191919191919191919191919191
FFFF00AB91FF7C18FF7700FF08FF0000FF1800EF91919191
9191919191919191
FF00FF00000000FF00FF0000FFFF00FF00FF009791FF00FF
0400FF00FF4C9191919191A30000299391919191917AFFFF
FF008F97FF0000FF0000FF74919191919191919191919191
91919100FF4777919191919191919191919191919191FFFF
00FFFF00AB9191919191AB009600EF00FF08FF0000FFFF77
9191919191919191
000000FF00FFFF00FF0000000000FFFF28FFFF639300FFFF
0B97000000FF91919191919028FFFF54919191919100E4FF
0000ED919190E000FF0000FF919191919191919191919191
919191AB0000FF91919191919191919191919191919100FF
0000FFFF00AB919191919191919191AB009600EF00FF00FF
9191919191919191
007100FFFF00FFFFFFFFFF00FFFF52FF51FFFF007DFFFF00
00B191FFFF889191919191914DFFFF099191919186FFFF00
00FF008F9191919197BDFF88919191919191919191919191
91919191ABFFFF7791919191919191919191919191FF0000
FF0000FFFF00AB91919191919191919191919191AB00FF8B
9191919191919191
FF00FF00FF7000FF00FFFF00B591B700B40000C766FFFF00
00DF91919191919191919191A30000299391919186FFFF00
FF0000ED9191919191919191919191919191919191919191
919191919100FF47779191919191919191919191FFFFFF29
8BAB0000FFFF00AB91919191919191919191919191919191
9191919191919191
00FFFF0000880000000000FF2491A1009500FF1D760000FF
FF00919191919191919191919000FF3C7D91919100FF00FB
0000FF008F91919191919191919191919191919191919191
9191919191AB0000FF919191919191919191919100FF00A5
9191AB0000FFFF00AB919191919191919191919191919191
9191919191919191
0894EE3B002E00000000FFFF1C91990095000074A60000FF
FF118A9191919191919191919100FFFF18919186FFFF1583
00FF0000ED91919191919191919191919191919191919191
91919191919100FFFF00919191919191919191FF0000FF91
919191AB0000FFFF00AB9191919191919191919191919191
9191919191919191
FF1600FFFF97FFFF0000FF07D38F8EFF91FF00FFFF00FF00
0000B19191919191919191919195FF00FF939161FFFF0091
AB0000FF008F919191919191919191919191919191919191
919191919191AB5200FF779191919191919191FFFF298B91
91919191AB0000FFFF00AB91919191919191919191919191
9191919191919191
FF18FF00FFAB0000FF00FFFFED8B94009100FF00FF00FF00
0000DF919191919191919191919200FF1D7D91FF00FF7991
9000FF0000ED919191919191919191919191919191919191
91919191919191320000FF91919191919191FF00FFA59191
9191919191AB0000FFFF00AB919191919191919191919191
9191919191919191
00D3E400004600B100FF000000A19300911EFFFF00FF0059
FFFF00919191919191919191919100FFFF188F11FF008C91
91AB0000FF008F9191919191919191919191919191919191
919191919191919100FFFF009191919191FF0000D0919191
919191919191AB0000FFFF00AB9191919191919191919191
9191919191919191
FF8035FF8F44FF0000000000009E91FF9180FFFFFFFF0100
FFFF118A9191919191919191919195FF00FF6DFFFF009191
919000FF0000ED9191919191919191919191919191919191
9191919191919191AB5200FF7791919191FFFF008B919191
91919191919191AB0000FFFF00AB91919191919191919191
9191919191919191
FF1EFF00FF350000FF00FFFF009B9108919A00FF00FF53B1
000000B1919191919191919191919200FF1DFF00FF809191
9191AB0000FF008F91919191919191919191919191919191
919191919191919191320000FF919191FF0000BF91919191
9191919191919191AB0000FFFF00AB919191919191919191
9191919191919191
00FF0000FFFF00FFFFFF43FFFF42912B919400FFFF00BA95
0000FF6F919191919191919191919100FF0028FF008C9191
91919000FF00FF9E91919191919191919191919191919191
9191919191919191919100FF2D7791FF0000D09191919191
919191919191919191AB0000FFFF00919191919191919191
9191919191919191
0000FF00000030FFFFFF00FF00BC91679190ABFFFF00A090
00FF00989191919191919191919191C4000000FF00919191
919191AB00FF938591919191919191919191919191919191
91919191919191919191AB0000FF9100FF008B9191919191
91919191919191919191AB000000FF919191919191919191
9191919191919191
FF4A6CFFBD5AFF00FFFF00A85293919C9191FFFFFF828691
84FF6592919191919191919191919190FF000000FF919191
919191903FBC7F9191919191919191919191919191919191
9191919191919191919191ABFFFFFF0000FF919191919191
9191919191919191919191ABFFB68B919191919191919191
9191919191919191
002BE000007900FF0000FF91919191F791919A0000F59291
919191919191919191919191919191910000FF0086919191
919191919191919191919191919191919191919191919191
91919191919191919191919100FFFF00FF8B919191919191
919191919191919191919191919191919191919191919191
9191919191919191
FF948EFFA1929D00FFFF86919191918D919190FFFF8D9191
9191919191919191919191919191919197FF0A9B91919191
919191919191919191919191919191919191919191919191
919191919191919191919191AB007CFF8B91919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
919191919191919191919191919191919191919191919191
9191919191919191
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{646.875, 150.125},
  ImageMargins->{{37, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:60000UQP00`40o`000?l0003ooooooooooon8
oooo003oooooooooohSoool00?ooooooooooR?ooo`00oooooooooon8oooo003oooooooooohSoool0
02Woool00`000?ooooooo`0;oooo0`0000?oool00`000?ooooooo`0:oooo0`0000;oool00`000?oo
ooooo`08oooo0P0000Coool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`030000oooooooo
00Goool500000_ooo`030000oooooooo00;oool00`000?ooooooo`03oooo1@000004oooo00000000
00000oooo`030000oooooooo02Soool00`000?ooooooo`0<oooo0`0000?oool00`000?ooooooo`09
oooo0`0000;oool00`000?ooooooo`09oooo0P0000Coool00`000?ooooooo`09oooo00<0003ooooo
ool00_ooo`030000oooooooo00Koool500000_ooo`030000oooooooo00;oool00`000?ooooooo`02
oooo1@000004oooo0000000000000oooo`030000oooooooo02coool00`000?ooooooo`0;oooo0`00
00?oool00`000?ooooooo`0:oooo0`0000;oool00`000?ooooooo`09oooo0P0000Coool00`000?oo
ooooo`09oooo00<0003oooooool00_ooo`030000oooooooo00Goool500000_ooo`030000oooooooo
00;oool00`000?ooooooo`03oooo1@000004oooo0000000000000oooo`030000oooooooo02[oool0
0`000?ooooooo`0<oooo0`0000?oool00`000?ooooooo`09oooo0`0000;oool00`000?ooooooo`09
oooo0P0000Coool00`000?ooooooo`09oooo00<0003oooooool00_ooo`030000oooooooo00Koool5
00000_ooo`030000oooooooo00;oool00`000?ooooooo`02oooo1@000004oooo0000000000000ooo
o`030000oooooooo01Ooool002Soool00`000?ooo`00000<oooo00<0003oooooool00_ooo`030000
oooo000000coool01P000?ooooooo`000?ooo`0000Woool00`000?ooo`000002oooo00<0003oool0
00002_ooo`030000oooo000000;oool00`000?ooo`000008oooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000000Koool01@000?ooooooooooo`000004oooo00<0003oool00000:?oo
o`030000oooo000000goool00`000?ooooooo`02oooo00<0003oool000002oooo`060000oooooooo
0000oooo00002_ooo`030000oooo000000;oool00`000?ooo`000009oooo00<0003oool000000_oo
o`030000oooo000000Woool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001Ooo
o`050000oooooooooooo000000Coool00`000?ooo`00000/oooo00<0003oool000003?ooo`030000
oooooooo00;oool00`000?ooo`00000<oooo00H0003oooooool0003oool0000:oooo00<0003oool0
00000_ooo`030000oooo000000Woool00`000?ooo`000002oooo00<0003oool000002?ooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`000006oooo00D0003oooooooooool000001?oo
o`030000oooo000002[oool00`000?ooo`00000=oooo00<0003oooooool00_ooo`030000oooo0000
00_oool01P000?ooooooo`000?ooo`0000[oool00`000?ooo`000002oooo00<0003oool000002Ooo
o`030000oooo000000;oool00`000?ooo`000009oooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000000Goool01@000?ooooooooooo`000004oooo00<0003oool000006?ooo`00:?oo
o`030000oooo000000goool01`000?ooooooooooo`000?ooo`00000:oooo10000004oooo0000oooo
00002Oooo`030000oooo000000;oool00`000?ooo`00000:oooo00<0003oool000000_ooo`030000
oooo000000Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001_ooo`030000
oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Xoooo00<0003oool000003_ooo`070000
oooooooooooo0000oooo000000Woool4000000Coool0003oool0000:oooo00<0003oool000000_oo
o`030000oooo000000Woool00`000?ooo`000002oooo00<0003oool000002Oooo`070000oooooooo
oooo0000oooo000000;oool00`000?ooo`000005oooo00<0003oooooool00_ooo`070000oooooooo
oooo0000oooo000002coool00`000?ooo`00000=oooo00L0003oooooooooool0003oool000002_oo
o`@000001?ooo`000?ooo`0000[oool00`000?ooo`000002oooo00<0003oool000002Oooo`030000
oooo000000;oool00`000?ooo`000008oooo00L0003oooooooooool0003oool000000_ooo`030000
oooo000000Koool00`000?ooooooo`02oooo00L0003oooooooooool0003oool00000:_ooo`030000
oooo000000koool01`000?ooooooooooo`000?ooo`000009oooo10000004oooo0000oooo00002_oo
o`030000oooo000000;oool00`000?ooo`000009oooo00<0003oool000000_ooo`030000oooo0000
00Woool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001Oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Hoooo000Xoooo00<0003oool000003Oooo`070000
oooooooooooo0000oooo000000[oool00`000?ooo`000002oooo00<0003oool000002Oooo`800003
oooo00<0003oool000002oooo`070000oooooooooooo0000oooo000000Soool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000001_ooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`00000Xoooo00<0003oool000003_ooo`070000oooooooooooo0000oooo000000Woool0
0`000?ooo`000002oooo00<0003oool000002_ooo`800003oooo00<0003oool000002_ooo`070000
oooooooooooo0000oooo000000Woool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00001Oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000/oooo00<0003oool0
00003Oooo`070000oooooooooooo0000oooo000000[oool00`000?ooo`000002oooo00<0003oool0
00002_ooo`800003oooo00<0003oool000002_ooo`070000oooooooooooo0000oooo000000Soool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001_ooo`030000oooooooo00;oool0
1`000?ooooooooooo`000?ooo`00000Zoooo00<0003oool000003_ooo`070000oooooooooooo0000
oooo000000Woool00`000?ooo`000002oooo00<0003oool000002_ooo`800003oooo00<0003oool0
00002_ooo`070000oooooooooooo0000oooo000000Woool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oool000001Oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000H
oooo000Xoooo00<0003oool000003?ooo`030000oooo000000;oool00`000?ooo`00000;oooo0P00
00;oool00`000?ooo`000009oooo00<0003oooooool00_ooo`030000oooo000000[oool00`000?oo
o`000002oooo00<0003oool000002?ooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`000006oooo00L0003oooooooooool0003oool000000_ooo`030000oooo000002Soool00`000?oo
o`00000=oooo00<0003oool000000_ooo`030000oooo000000[oool200000_ooo`030000oooo0000
00[oool00`000?ooooooo`02oooo00<0003oool000002Oooo`030000oooo000000;oool00`000?oo
o`000009oooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000Goool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool00000;?ooo`030000oooo000000coool00`000?oo
o`000002oooo00<0003oool000002oooo`800002oooo00<0003oool000002_ooo`030000oooooooo
00;oool00`000?ooo`000009oooo00<0003oool000000_ooo`030000oooo000000Soool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001_ooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`00000Zoooo00<0003oool000003Oooo`030000oooo000000;oool00`000?oo
o`00000:oooo0P0000;oool00`000?ooo`00000:oooo00<0003oooooool00_ooo`030000oooo0000
00Woool00`000?ooo`000002oooo00<0003oool000002Oooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`000005oooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
01Soool002Woool00`000?ooooooo`0<oooo00<0003oooooool00_ooo`030000oooooooo00_oool0
1@000?ooooooooooo`00000;oooo0P0000?oool00`000?ooooooo`0:oooo00<0003oooooool00_oo
o`030000oooooooo00Koool200001?ooo`030000oooooooo00;oool00`000?ooooooo`04oooo0P00
00Coool00`000?ooooooo`02oooo00<0003oooooool0:?ooo`030000oooooooo00goool00`000?oo
ooooo`02oooo00<0003oooooool02_ooo`050000oooooooooooo000000coool200000oooo`030000
oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool01oooo`800004oooo00<0003ooooo
ool00_ooo`030000oooooooo00?oool200001?ooo`030000oooooooo00;oool00`000?ooooooo`0/
oooo00<0003oooooool03?ooo`030000oooooooo00;oool00`000?ooooooo`0;oooo00D0003ooooo
ooooool000003?ooo`800003oooo00<0003oooooool02Oooo`030000oooooooo00;oool00`000?oo
ooooo`06oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool01?ooo`800004oooo00<0
003oooooool00_ooo`030000oooooooo02[oool00`000?ooooooo`0=oooo00<0003oooooool00_oo
o`030000oooooooo00[oool01@000?ooooooooooo`00000<oooo0P0000?oool00`000?ooooooo`09
oooo00<0003oooooool00_ooo`030000oooooooo00Ooool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`03oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool05oooo`00oooo
oooooon8oooo003oooooooooohSoool00?ooooooooooR?ooo`009oooogH0000UooooMP0002Oooomg
00009_ooogH0000Doooo000Soooo00L0003oooooooooool0003oool000001?ooo`050000oooooooo
oooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_ooo`050000oooooooo
oooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_ooo`050000oooooooo
oooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_ooo`050000oooooooo
oooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_ooo`050000oooooooo
oooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_ooo`030000oooooooo
01koool00`000?ooooooo`02oooo00<0003oool000000oooo`030000oooooooo00;oool01@000?oo
ooooooooo`000004oooo00D0003oooooooooool000000oooo`030000oooooooo00;oool01@000?oo
ooooooooo`000004oooo00D0003oooooooooool000000oooo`030000oooooooo00;oool01@000?oo
ooooooooo`000004oooo00D0003oooooooooool000000oooo`030000oooooooo00;oool01@000?oo
ooooooooo`000004oooo00D0003oooooooooool000000oooo`030000oooooooo00;oool01@000?oo
ooooooooo`000004oooo00D0003oooooooooool000000oooo`80000Soooo00D0003oooooooooool0
00000_ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00D0003oooooooooool0
00001?ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0003ooooo
ool00_ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0003ooooo
ool00_ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0003ooooo
ool00_ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0003ooooo
ool00_ooo`040000oooooooooooo0P00027oool00`000?ooooooo`02oooo00<0003oool000000ooo
o`030000oooooooo00;oool01@000?ooooooooooo`000004oooo00D0003oooooooooool000000ooo
o`030000oooooooo00;oool01@000?ooooooooooo`000004oooo00D0003oooooooooool000000ooo
o`030000oooooooo00;oool01@000?ooooooooooo`000004oooo00D0003oooooooooool000000ooo
o`030000oooooooo00;oool01@000?ooooooooooo`000004oooo00D0003oooooooooool000000ooo
o`030000oooooooo00;oool01@000?ooooooooooo`000004oooo00D0003oooooooooool000000ooo
o`80000Doooo000Roooo00<0003oool000000_ooo`030000oooooooo07;oool00`000?ooooooo`0M
oooo00<0003oool000000oooo`030000oooooooo07;oool00`000?ooooooo`0Poooo00<0003oool0
00000_ooo`030000oooooooo07?oool00`000?ooooooo`0Noooo00<0003oool000000oooo`030000
oooooooo07;oool00`000?ooooooo`0Boooo000Roooo00<0003oool000000_ooo`80001coooo00<0
003oooooool07Oooo`030000oooo000000?oool00`000?ooooooo`1aoooo0P0002;oool00`000?oo
o`000002oooo0P0007?oool200008?ooo`030000oooo000000?oool00`000?ooooooo`1aoooo0P00
01Coool002;oool00`000?ooo`000002oooo00<0003oooooool00_ooo`030000oooo000000?oool0
10000?ooo`000?ooo`800002oooo00<0003oooooool00P000006oooo0000oooo0000/[:boooo0Z2P
X08000001oooo`000?ooooooo`000?ooo`000003oooo0`000003oooo0000000000?oool00`000?oo
oj2PX002X:2P00>0P82CTi>CTi<019>CT`D00003oooo0`0000?oool300000_ooo`D000001Oooo`00
00000?ooo`000002oooo00H0003oool0003oool0003oool200000_ooo`030000ooooTi>C00JCTi<2
oooo00<0003oooooool07Oooo`030000oooo000000?oool00`000?ooooooo`03oooo0P000005oooo
0000oooo0000oooo00800003oooo00<0003oooooool00P0000?oool00`000?ooomKFeP0300001?oo
o`030000oooo000000Coool010000?ooooooo`0000Coool00`000?oookJf]P04][Jf00BFUYJOWinO
WinOWil200000_ooo`<00004oooo0P000003oooo0000oooo00Koool300000_ooo`D000001_ooo`00
0?ooo`000?ooo`0000?oool00`0009nOWinOW`09WinO0_ooo`030000oooooooo023oool00`000?oo
o`000002oooo00<0003oooooool00oooo`030000oooo000000?oool3000000?oool0000000000_oo
o`040000oooooooooooo0P000005oooo0000ooooVYZJoooo00:HV9P300000oooo`030000oooo0000
00;oool2000000Coool0000000000004oooo00<0002HV9RHV9P00YRHV0NFUYH400000oooo`D00000
1?ooo`000000000000;oool300000_ooo`@00003oooo00H0003oool0003oool0003oool200000_oo
o`030000ooooUYJF00JFUYH3oooo00<0003oooooool07_ooo`030000oooo000000?oool00`000?oo
ooooo`02oooo00<0003oool000000oooo`<000000oooo`0000000002oooo00D0003oooooool0003o
ool00P000006oooo0000UYJFoooo^[ZjTI6A0P000007oooo0000oooooooo0000oooo000000?oool2
000000Bd];Coool000000003oooo00<0003ooonATI401I6AT@04VYZJa/K6R8R8[:b/1@0000?oool3
000000Coool0003ooom<C4`200000_ooo`<000002Oooo`000?ooobTY:@000?ooo`000?oooo;blP03
000000?oool0003oool00P000004WIfMoooo0000oooo1i6AT@;oool00`000?ooooooo`0Boooo000R
oooo00<0003oool000000_ooo`030000oooooooo00;oool00`000?ooo`000003oooo0`000003oooo
0000oooo008000000oooo`0000000004000000Coool0002b/[800002X:2P0_ooo`@00003oooo1P00
0004oooo0000000000000_ooo`030000ooooX:2P00:PX:000h20P9>CTi>CT`05Ti>C00?oool00000
00000`0000Coool00`000?ooooooo`04oooo1P000006oooo00000000oooo0000oooo10000003oooo
0000oooo00<000000oooo`000?ooo`07Ti>C0_ooo`030000oooooooo01goool00`000?ooo`000003
oooo00<0003oooooool00_ooo`<00002oooo200000;oool2000000Woool00000003oool0003ooooF
e]H0003oool01@0000Coool400000_ooo`800002oooo0P000003oooo][Jf][Jf00>f][H4X:2P00?o
ool0000000000oooo`D000001?ooo`000?ooooooo`@00003oooo0`000004oooo0000000000000_oo
o`030000oooo0000008000000oooo`000?ooo`0300002J2PX0:OWil2oooo00<0003oooooool08?oo
o`030000oooo000000;oool00`000?ooooooo`03oooo00<0003oool000000oooo`060000oooo0000
oooo0000oooo0P000004oooo0000000000000_ooo`8000000ooooiZJVU5AD@02V9RH00?oool00000
00000`0000;oool6000000Coool0000000000003oooo00<0002HV9RHV9P00YRHV0NFUYH2oooo1000
00Coool00`000?ooooooo`04oooo1@000007oooo000000000000oooo0000oooo00H000001oooo`00
000000000?ooo`000?ooo`07UYJF0oooo`030000oooooooo01koool00`000?ooo`000003oooo00<0
003oooooool00_ooo`<00003oooo00H0003oool0003oool0003oool2000000?oool0000000000P00
000:oooo0000oooo0000U9BDgMgMX:2PEEEE/[:boooo100000?oool6000000B/[:coool000000002
oooo00<0003<c<bATI401I6AT@07U9BDYZJVLg=cSXj>TI6Ad=3@ADE500@00004oooo00<0003ooooo
ool01?ooo`D0000020<30ooooijNWP0007EeMAXJ6_ooo`0000;oool02P000?oooc`l??ooogemO@00
03@d=?ooo`000;Rh^0NATI42oooo00<0003oooooool04_ooo`008oooo`050000oooooooooooo0000
00Ooool00`000?ooo`000002oooo0P000004oooo00000000oooo0P0000Coool01@000?ooooooo`00
0?ooo`02X:2P10000006oooo0000oooooooo0000oooo0P0000Koool01@000?ooooooooooo`000003
X:2P00>0P82CTi>CTi<019>CT`8000001Oooo`00000000000?ooo`0500000_ooo`<00002oooo0`00
0003oooo0000000000;oool00`000?ooo`00000200000oooo`@00003oooo00<0002CTi>CTi<01I>C
T`;oool00`000?ooooooo`0Noooo00<0003oooooool00_ooo`030000oooooooo00Goool010000?oo
ooooooooo`<000000oooo`000?ooo`0200001?ooo`070000oooooooo0000e]KF0000JVYZ00800002
oooo0P000003oooo0000000000?oool010000?ooooooo`0000?oool00`000?ooo`000005][Jf00BF
UYJOWinOWinOWil200001oooo`<00002oooo0P0000;oool2000000?oool0000000000_ooo`<00003
oooo100000;oool01@000?ooooooooooo`00000;WinO0_ooo`030000oooooooo027oool01@000?oo
ooooooooo`000008oooo00P0003oool0003oool0003oool0003oool2000000?oool0003oool01?oo
o`050000oooo0000VYZJZZZZ00:HV9P00bl_;`0000000002oooo00<0003oooooool00P000003oooo
0000oooo00Goool01@000?ooooooooooo`000003V9RH1iJFUP8000001_ooo`0000000?ooo`000?oo
o`<00002oooo10000005oooo000000000000oooo00<00003oooo0`0000;oool500000oooo`030000
UYJFUYJF00FFUYH3oooo00<0003oooooool07oooo`030000oooooooo00;oool00`000?ooooooo`05
oooo00@0003oool0003oool4000000?oool0003oool00P0000Coool00`000?ooooooo`0300000_oo
o`800002oooo00T0003oooooool0003ooommOGeQHF7oooo<c<`00_ooo`030000oooo000000?oool0
1H^;Ri6ATI6ATI6ATI2@T002TI6A00Dh>3P0003ooonJVYZ:RXX00P000007d];BRh^;QXJ6l?3`IVIV
X:2P@41000800002oooo0`000008b/[:oooo00000000DE5Aoooo0000/K6a0_ooo`05Zj^[b/[:3`l?
>CTi000000;oool00jb/[0000000000200000oooo`03SHf=TI6ATI6A00FATI42oooo00<0003ooooo
ool04_ooo`009oooo`L000000oooo`0000000005000000?oool0000000001`000005oooo00000000
<30`0000008P8208000000?oool0000000002`000005oooo820P820P820P000000H@4103000000Co
ool00000003oool700000_ooo`<00003oooo00<0003oool000001@000003oooo0000000000800000
0oooo`0000000004000000?oool@410@41001A0@40;oool00`000?ooooooo`0Soooo00D0003oool0
0000003oool01`000003oooo0000oooo00@000000oooo`0000000002000000?oool0000000002`00
0003oooo0000000000D000000oooo`0000000003000000?ooolP820P82001b0P80030000oooo0000
00H00002oooo0`000003oooo0000000000D000000oooo`0000000002000000?oool0000000000`00
0006oooo000000000000oooo00000_ooo`030000820P820P00TP8202oooo00<0003oooooool09Ooo
o`8000000oooo`0000000003000000?oool0000000001@000003oooo0000000000@000002?ooo`00
00000?ooo`000?oooi2@T00000:@T90;000000?oool0003oool00`000003oooo000000000080000;
T92@1@000003oooo0000000000D00003oooo0P0000?oool00`000?ooooooo`0500000_ooo`800002
oooo0P000005oooo000000000000oooo00N@T902oooo0P0002Koool00`000?ooooooo`04000000?o
ool0000000001@000003oooo0000000000d00000196AT@0000000?ooo`D000000oooo`0000000006
000000<51@D0000000000P000005ooooTI6ATI6ATI6AT92@00:ATI42000000>?ShlA4A4000000P00
0004_;blJ6QX0P82Ti>C0`000004Ogmooooo000000000_ooo`<00002oooo00?0`<00000000000`00
00038R8R0000000000D000000oooo`0007IfMP04000000?Ti>BATI6ATI401I6AT@03oooo00000000
01Coool002Ooool00`000?ooo`000002oooo00<0003oool000000oooo`060000oooo0000oooo0000
oooo0P000004oooo0000000000000_ooo`050000oooo0000M7Ad:BTY009dM7@2oooo0`0000;oool0
0`000?ooo`000005000000?oool0000000000oooo`030000ooooM7Ad00YdM7@00oooo`0000000003
00001Oooo`030000oooooooo00?oool3000000?oool0000000000_ooo`040000oooo0000oooo0P00
0005oooo0000oooo0000oooo00<000000oooo`000?ooo`07M7Ad0_ooo`030000oooooooo02?oool0
20000?ooo`0000000?ooo`000?ooo`0000;oool2000000?oool0000000000`000004oooo00000000
00001?ooo`050000ooooJFUY0000oooo00D000001?ooo`000?ooooooo`@00002oooo0P0000;oool2
000000?ooomYJFUYJFT01fUYJ@06oooo00000000oooo0000oooo10000003oooo0000000000800002
oooo0P0000;oool4000000Coool0000000000002oooo00L0003oool0003oool0003oool000000_oo
o`80000;JFUY0_ooo`030000oooooooo02Goool010000?ooooooo`0000;oool00`000?ooo`000003
oooo0`000003oooo0000oooo008000001?ooo`000000000000;oool2000000?ooonATI66QXH00Y6A
T@03oooo0000000000800002oooo1`000004oooo0000000000000oooo`030000TI6ATI6A00VATI42
oooo100000Goool00`000?ooooooo`03oooo0`000009oooo0000oooo0000oooo0000oooo0000oooo
008000001Oooo`00000000000?ooo`03000000?oool0003oool01i6AT@?oool00`000?ooooooo`0T
oooo00D0003oool00000003oool00`0000?oool00`000?ooo`000002000000Coool00000003oool4
000000[oool0003oool00020P8000018B4SooooMgMg?cll300000_ooo`030000oooo000000<00000
2_ooo`0000000?ooo`0008N7QooookJf]P0009RHV0JATI402h:2PRl_;ooooijNWX20P7]kNdm?CgIf
MU1@D0T92@000005oooo00<0002MWIgYjNT00oooo`<000005WEeMJRXZ00005EEELW9bGemOBl_;c8b
<Xf=S@000?oookFe]@000<c<c5MGEnKViXf=S@0008Z:R_oooa8B4YFEU@NATI42oooo00<0003ooooo
ool04_ooo`009oooo`030000oooo000000D000000oooo`000?ooo`03000000Ooool0003oool0003o
ool0003oool010000005oooo00000000M7Ad0000009dM7@2oooo0P000004oooo0000000000000ooo
o`/000000oooogAdM7AdM009M7Ad00Coool0000000000003oooo10000003oooo0000oooo00;oool2
00000_ooo`800002oooo0P000004oooo0000oooooooo100000?oool4000000?ooomdM7AdM7@01GAd
M0;oool00`000?ooooooo`0Soooo00D0003oool00000003oool00`000006oooo0000oooo0000oooo
00000_ooo`040000oooo0000oooo10000005oooo00000000oooo000000?oool00`000?ooooooo`03
000000?oool0000000001@000004oooo00000000oooo0P000003ooooJFUYJFUY00MYJFT2oooo0P00
00Koool4000000?oool0000000000_ooo`800002oooo0P000003oooo0000Rh^;00@00002oooo0`00
0003oooo000000000080000;JFUY0_ooo`030000oooooooo02Goool00`000?ooooooo`06000000?o
ool0003oool00`000007oooo0000oooo0000oooo0000oooo00@000001Oooo`000?oooi6ATD10@002
TI6A00?oool0000000000_ooo`<00002oooo20000004oooo0000000000002i6AT@;oool00fQXJ000
0?ooo`02oooo1P0000Coool01@000?oooooooaHF5P000002oooo100000?oool200001Oooo`<00000
0ooooi6ATI6AT@05TI6A0oooo`030000oooooooo02Coool01@000?ooo`0000000?ooo`05000000Co
ool0000000000002oooo00D0003oooli>CT0003oool010000004oooo00000000a/K60_ooo`060000
Shn?oooooooo0000`<300`0000?oool4000000=0@4000000000010000005^KViTI6ATI6ATI6APH61
00:ATI42oooo00<0003oool000000_ooo`050000AdM7G5aLKVi^g]kN0080000014I6A_ooo`000000
00;oool00lg=c@0000000002oooo00B?Shl0003ooonYZJT2000000Bc/k<G5aOoooooool3000000@X
:2Soooooooooool4000000>][JfATI6ATI401I6AT@;oool00`000?ooooooo`0Boooo000Woooo00<0
003oooooool00_ooo`030000oooo000000;oool700000oooo`030000oooo0000008000001Oooo`00
0?ooo`000?ooo`02M7Ad0P0000?oool00`000?ooo`000003oooo10000003oooo0000000000<00000
0oooo`0007AdM009M7Ad1@0000Koool00`000?ooo`000003oooo0P0000?oool00`000?ooooooo`02
000000Coool0003oooooool400000oooo`800002oooo00<0001dM7AdM7@01GAdM0;oool00`000?oo
ooooo`0Soooo00@0003oooooooooool2000000Koool00000003oool0003oool300001?ooo`<00000
1oooo`00000000000?ooo`0006UYJ@0300001Oooo`030000oooo0000008000001?ooo`000?oooooo
o`D000000oooo`0006UYJ@08JFUY0P0000;oool300000oooo`050000oooooooo0000oooo00800002
oooo0P000003oooo0000000000@00003oooo00<0003oooooool00`000003oooo000000000080000;
JFUY0_ooo`030000oooooooo02Goool00`000?ooooooo`03oooo00<0003oool000000_ooo`<00000
1?ooo`000000000000;oool010000?ooooooo`0000;oool3000000BATI7ooonATI6ATI4200000ooo
o`030000oooo000000;oool4000000Goool0003oool0003oool00P000003oooo0000TI6A00VATI44
00001_ooo`030000oooo000000Coool01@000?ooooooooooo`000002oooo0P000003oooo0000oooo
00;oool300001?ooo`040000oooooooo00001i6AT@?oool00`000?ooooooo`0Toooo00<0003ooooo
ool00_ooo`040000oooo0000oooo1P000003oooo0000oooo00;oool00`000?ooo`000002000000?o
ool0003oool00`000003oooo0000000000;oool015=CD`000?ooo`0000?oool3000000??clooool0
000010000003oooo?CdmTI6A00:ATI40292@T96ATI6ATDU9B@000?oooc8b<P0000;oool2000000?o
ooolo?coool00P000004oooo0000oooo00000oooo`800002oooo00BKVi/0001OGeooool2000000CX
j>Q;Bd_oooooool3000000A4A4Coooooooooool2000000?clo?ooomgMgL01i6AT@;oool00`000?oo
ooooo`0Boooo000Woooo0P0000;oool2000000?oool0003oool00_ooo`<000001Oooo`000?ooo`00
0?ooo`04000000?oool0003oool00P000004M7Ad0000M7AdM7Ad0_ooo`H00003oooo0P0000;oool5
000000?oool0003oool02gAdM004oooo0000000000000oooo`<000001?ooo`000?ooo`0000;oool2
00000_ooo`@00002oooo00<0003oool000001@0000?oool01@000?ooooooo`000?ooo`07M7Ad0_oo
o`030000oooooooo02?oool01@000?ooooooooooo`000003oooo00@0003oool0003oool2000000?o
ool0003oool01@000009oooo00000000oooo0000oooo0000ooooEUIF00?oool300000_ooo`<00000
1?ooo`000?ooooooo`H000000oooofUYJFUYJ@07JFUY0_ooo`8000001?ooo`000000000000?oool2
00000_ooo`800002oooo00@0003oool000000002oooo0P000004HV9Roooooooooooo1P000005oooo
0000oooooooo000000]YJFT2oooo00<0003oooooool09Oooo`800003oooo0P000003oooo0000oooo
00;oool3000000Ooool0003oool0003oool0003oool00P000007oooo0000oooo0000ooooTI6AGEeM
00:ATI401_ooo`0000000?ooo`0003`l?0800002oooo0`000004oooo0000000000000_ooo`030000
oooo000000^ATI42oooo0P0000?oool5000000?oool0003oool00_ooo`030000oooooooo00800000
1_ooo`0000000?ooo`000?ooo`D00005oooo00@0003oool0003oool7TI6A0_ooo`80000Voooo00@0
003oooooooooool200001?ooo`D00003oooo00<0003oool000000P000003oooo0000oooo00800000
1HJ6QP0002/[:cXj>P000002oooo00<0003oooooool00P0000?oool200000_ooo`D000000oooo`00
0?ooo`06TI6A00=iNGTV9RH/;2`00P0000;oool03P000?ooo`0000000?ooo`000?ooo`000?ooo`00
0?ooo`000?ooon?Sh`800002oooo00@d=3@0000000000002oooo00=2@T;oool000001@0000?oool0
1@000?ooooooo`000?ooo`07TI6A00?oool0000000005?ooo`009oooo`030000oooooooo00;oool5
000000Ooool0003oooooool0003oool000000_ooo`8000001Oooo`0000000?ooo`000002oooo00@0
003ooomdM7AdM7@200000oooo`8000001Oooo`00000000000?ooo`03000000Coool0000000000003
oooo00<0001dM7AdM7@027AdM0@000001?ooo`000000000000;oool300000_ooo`800002oooo0P00
0004oooo0000oooooooo0P000003oooo0000oooo00?oool010000?ooo`000?ooo`8000001?ooo`00
0?ooo`0000MdM7@2oooo00<0003oooooool08oooo`040000oooooooooooo1P000003oooo0000oooo
00800004oooo00@0003oool000000004oooo00<0001YJFT000000P000003oooo0000oooo00;oool0
1P000?ooooooooooo`000?ooo`8000000oooo`000?ooo`04oooo00<0001YJFUYJFT01fUYJ@800002
oooo0`000008oooo000000000000oooo0000oooo00000_ooo`040000oooo000000000_ooo`800002
oooo1@0000;oool010000?ooooooo`0000?oool00`0006UYJFUYJ@09JFUY0_ooo`030000oooooooo
02Goool00`000?ooooooo`02000000?oool0000000000`000007oooo00000000oooo0000oooo0000
00;oool2000000Woool0003oooooool0003oool0002ATI7oool00Y6AT@800003oooo0P000003oooo
0000000000;oool2000000Coool0003oool00004oooo00<0002ATI6ATI40296AT@L00003oooo0P00
00;oool3000000?oool0000000000oooo`<000000oooo`000?ooo`04oooo00<0003oooooool00P00
0004oooo0000oooo00001i6AT@?oool00`000?ooooooo`0Toooo00<0003oooooool00_ooo`@00002
oooo00H0003oooooool0003oool00002oooo0P000005oooo00000000oooo000000;oool010000<W9
bHj>SY^KV`8000004Oooo`000?ooooooo`000?ooo`0004i>CS0`<?ooo`0005=CDc4a<Oooog5aLEUI
FGUiN@03oooo00<0002ATI6ATI40196AT@04T92@Rh^;X:2PWYjN0P00000320P80000oooo00<00002
oooo0P00000OC4a<ooooooooH61P30`<^k^kiNGU30`<Fe]KoOgmoooo@d=3oooo>3Ph0000XZ:RIfMW
ooookno_i>CTUiNGEEEE/;2`0@41aLG5?clo<S8boooo0000oooo000000NATI42oooo00<0003ooooo
ool04_ooo`009oooo`030000oooooooo00?oool00`000?ooooooo`03oooo0`0000;oool00`000?oo
o`000002000000?oool0000000000P000003oooo00000000009dM7@010000?ooo`00000000;oool3
00000_ooo`030000oooooooo00800002oooo0`000003oooo0000M7Ad00UdM7@2000000Coool00000
00000002oooo00<0003oool000000_ooo`040000oooo000000000_ooo`H00002oooo00D0003oool0
003oool000000_ooo`040000oooo0000oooo0`000003oooo0000M7Ad00IdM7@2oooo00<0003ooooo
ool08oooo`030000oooooooo00;oool00`000?ooo`000004oooo00<0003oooooool00P0000?oool0
0`000?ooo`000003000000Koool00000003oool0003oool2000000Goool00000003oool000000ooo
o`@000001oooo`000?ooooooo`000?ooo`000009JFUY0oooo`030000oooo000000800003oooo00@0
003oool0003oool200001Oooo`030000oooooooo00800002oooo0P000003oooo0000000000800000
0oooo`000?ooo`0300002fUYJ@;oool00`000?ooooooo`0Uoooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooo`000002oooo00H0003oool0003oool0003oool2000000Goool00000
002ATI4000000Y6AT@<00003oooo0`000003oooo0000000000;oool200000_ooo`<000000oooo`00
096AT@09TI6A0P000003oooo0000000000;oool2000000Goool000000000003oool00P0000;oool5
000000Koool0003oool0003oool00002oooo00D0003oooooooooool000000_ooo`8000000oooo`00
096AT@06TI6A0oooo`030000oooooooo02Coool00`000?ooo`000003oooo00<0003oooooool00ooo
o`<00002oooo00<0003oooooool00P000003oooo00000000008000000oooo`0006ATI002TI6A00T0
003oool00000003ooom@D53oool00018B4P00_ooo`030000oooooooo00800002oooo0`000003oooo
0000TI6A00VATI42000000Coool0000000000002oooo00@0001PH62HV9Soool2000000>GUiN6QXIC
De<00_ooo`03BDU90000000000@000004Oooo`000?ooo`000?ooo`000?gmoOooo`000?ooo`000;Rh
^6EUIB@T90000?ooo`000007TI6A0_ooo`030000oooooooo01;oool002Ooool00`000?ooo`00000@
000000?oool0000000001`000004U9BDM7AdM7AdMWIf1`000003oooo0000000000@000000oooo`00
0000000500002WAdM00310@4fm_K000000@000000oooo`0000000002oooo0P0000;oool8000000Ko
ool00000003oool0003oool=00001gAdM0;oool00`000?ooooooo`0Soooo00<0003oool000003`00
0003oooo0000000000L000000fUYJ@000>CTi00700000_ooo`d00009JFUY1@000003oooo00000000
00L00002oooo3@000003HF5Q0000000000T0000;JFUY0_ooo`030000oooooooo02Goool00`000?oo
ooooo`0A000000?oool0000000001P000003TI6AUYJFTI6A00:ATI4F00002Y6AT@03UIFEXJ6Q0000
00<000001Oooo`00000000000?ooo`0200000oooo``000000m3@d0000000000;00001i6AT@?oool0
0`000?ooooooo`0Toooo00D0003oool00000000Y:BT01`000003oooo0000P82000@000000oooo`00
00000004000000<P82000021PH400i6AT@03T92@0000000000D000000oooo`0000000002000000[o
ool00000003oool0000=3@e/K6b0P800002:RXX:TI6A00>0P821PH61PH4010000005n?Sh00000000
ooooUiNG00800002oooo200000038R8R4Q8Bh^;R00@000001oooo`00000007UiNA@D57alO10@4002
000000=4A4@0002<S8`01i6AT@;oool00`000?ooooooo`0Boooo000Woooo00<0003oooooool00P00
0003oooo0000oooo00<00002oooo00IdM7BSXj?ooomcLg<0003oool3000000==CDedM7AdM7@02WAd
M0030000oooo000000;oool010000?ooo`00061PH1YdM7@016e]KOooo`000?ooo`<00003oooo0P00
0005oooo00000000ooooKfm_01adM7@2oooo00<0003oooooool08oooo`030000oooo000000;oool3
00000_ooo`0<0000oooo0000JFUY0000oooo0000oooo0000oooo0000oooo1fUYJ@05Hf=SJFUYJFUY
IVIVoooo00<000001oooo`0000000?ooo`000?ooofQXJ00FJFUY00?oool0000000000_ooo`800003
oooo0`0000;oool00`000?ooof5QH@0OJFUY0_ooo`030000oooooooo02Goool010000?oooooooooo
o`8000000oooo`000?ooo`03000000cooonATI6ATI6HV9SooonATI40003oool0003oool0002;Rh/;
TI6A00BNWYh0003oool00002oooo0P000003n_[jSXj>TI6A01RATI400i2@T=[JfP000002oooo0P00
00?oool2000000Goool000000032`/:@T900796AT@?oool00`000?ooooooo`0Toooo00T0003ooooo
oooooom`L7030`?Hf=Sooon8R8P00P000008nOWi000051@DTi>C_knoV9RHS8b<oooo0P000006O7al
OGemoooooooo?3`lTi>C0Y6AT@09SXj>Ti>CPh>3VIVIT92@TI6AP820oooo000000;oool02`000?oo
oh61PI2@T9:BTX20P>7QhO?cl`000?oooa0@400;TI6A00BBTY:>SXjCTi>@T905TI6A00jBTY:<S8bX
Z:R7QhL0000G5aOooonLW9cRh^8?3`l0002HV9R=SHf<S8`5TI6A00Z?Shn;Rh^QXJ6NWYjKVi^e]KD4
10Coool0002GUiL?TI6A0_ooo`030000oooooooo01;oool002Ooool200000oooo`040000oooo0000
oooo0P0000;oool00`000?ooooooo`02M7Ad0`0000Coool010000?ooo`00071`L0MdM7@016MWI`00
0?ooo`0000;oool00`000?ooooooo`02oooo00?0`<3oooooool00P000003ooooVYZJM7Ad01=dM7@0
0fe]KOooo`000002oooo00D0003oool00000003oool00P0000;oool01P0000h>3_oooooooc8b<_oo
o`<00003oooo0P000004oooo00000000Ng]k2GAdM0;oool00`000?ooooooo`0Soooo00D0003ooooo
ooooool000000oooo`030000oooooooo00;oool01@0008B4Q00006UYJ@000004oooo00H0003ooooo
ooooool0001UIFD7JFUY00@0003oooooool00004oooo0`000003ooooinOWoooo00;oool00j>SXfUY
JFUYJ@0AJFUY00EMGEd000000000003oool00P000003oooo0000000000;oool00`0002h^;_ooo`02
oooo00@T92AYJFT000000002oooo0`0000;oool010000?ooo`0009BDU0aYJFT2oooo00<0003ooooo
ool09Oooo`800004oooo00@0003ooomkNg_oool2000000Goool0003ooona/K6c/k<00Y6AT@03MgMg
0000000000Coool200002I6AT@06Shn?J6QXoooo0000`<3000001Oooo`03WIfMoooooooo00800000
0ooooiNGUi6AT@0CTI6A00F@T900003oooooool000000_ooo`@00002oooo00H0000V9RJ2PX;ooon7
QhNo_kl300000oooo`8000001?ooo`0004Q8B9:BTPVATI42oooo0P0002Koool010000?oooooooooo
o`8000001ADE5Oooolc<c=gMgAdM7@02oooo1@00000;Y:BTNWYj0000hn?SUiNGWIfMh>3P0000oooo
SHf=4A4A008000001Oooo`000>_[j`0009FEU@02T92@00nIVIT0003Rh^:ATI52@T:0P82FUYJCTi>B
TY:ATI6OWinVYZHS8b>;Rh^GUiL01I6AT@0?T92@TI6ATI6A>c/k0000oooo0000`<30ATI6BTY:YZJV
VIVITY:BTi>CT92@00:ATI403i:BTXR8R9jNWZVYZ@000?ooohj>SV9RHY6ATEiNGWQhN9:BTZBTY820
P96AT@02Ti>C0Y6AT@0;Shn?SXj>S8b<Xj>S[jn_UIFEFUYJS8b<alO70P82T92@00ZATI400oooo`00
0000000Doooo000Woooo00D0003oool00000003oool00`000003oooo0000oooo00@000001_ooogAd
M7]kNoooo`000?ooo`@000001?ooo`000?ooo`0000IdM7@00d10@0000?ooo`0200000oooo`X00000
0oooo`0007AdM00>M7Ad00=cLg=UIFFKVi/00P000005ooooBTY:00000000oooo00@00002oooo0P00
00;oool2000000Coool0003oooooool400000oooo`<000000oooo`0007AdM006M7Ad0_ooo`030000
oooooooo02?oool01@000?ooo`0000000?ooo`03000000Woool000000000003oool0003oool0001Y
JFT00P000003oooo00000000008000001?ooo`000?ooo`0000MYJFT0110@4?ooo`000?ooo`L00000
0oooo`0000000002000000?oool0001YJFT03fUYJ@08JVYZJ6QXCTi>[Zj^0000oooo0000oooo0P00
00;oool2000000Oooonj^[X00000003oool0001YJFT0100000;oool3000000Goool0003oool0000K
6a/02fUYJ@;oool00`000?ooooooo`0Uoooo00<0003oooooool00P000007oooo000000000000oooo
0000oooo00@000001_oooi6ATI:BT_ooo`000?ooo`@000000oooo`0000000006TI6A00BBTY::RXYD
E5Coool200000_ooo`P000001Oooo`0000000?ooo`00000?TI6A00V?ShnGUiN8R8QXJ6Pj>SX61PK@
d=00003oool00P000004oooo0000oooooooo0P0000;oool2000000?oool0003oool00_ooo`<00004
oooo0P000003oooo0000TI6A00JATI43oooo00<0003oooooool09?ooo`050000oooo00000000oooo
00D000001?ooo`000000000000;oool01@000?ooo`0000000?ooo`04000000Coool0003ooon:RXX2
oooo0P0000;oool00`000>SXj000000200000oooo`X000000oooohb<S96AT@02TI6A00>1PH6ATI6A
TI400_ooo`<00002oooo00`0000e=CD00000003Rh^90@419BDVVYZJGUiNEUID0003oool2000000Q5
ADD0003ooooooon7QhL0003ooonGUiL2000000BSXj<k>c_oooooool400000oooo`<000000n[ZjXj>
SY6AT@06TI6A0_ooo`030000oooooooo01;oool001goool300000oooo`080000oooooooooooo0000
oooo0000oooo0P000004oooo0000oooo00001?ooo`040000ooooM7AdM7Ad0`000004oooo00000000
oooo0P000003ooooL71`M7Ad00QdM7@01Oooo`000?ooooooo`000002oooo00<0001gMgL000000_oo
o`8000000oooohF5QGAdM00GM7Ad00Coool0003oooooool400000_ooo`040000?Shn0000N7Qh0WAd
M003H61PTI6Aoooo00?oool00`000?ooooooo`0200002WAdM0;oool00`000?ooooooo`0Hoooo0`00
00?oool00`000?ooooooo`02oooo00D0003oooooooooool000000oooo`0:0000oooooooo0000oooo
0000JFUY0000JFUYJf][0oooo`030000M7Ad000000;oool00`0006QXJ6UYJ@07JFUY00<0003oool0
00000oooo`060000JFUYJFUYJFUYI6AT00000_ooo`03ZZZZM7AdJFUY01IYJFT01?ooo`0000000?oo
o`8000001?ooo`000?ooode=C@UYJFT00dE5AIfMWOooo`02oooo00<0003oool000003FUYJ@;oool0
0`000?ooooooo`0Koooo0`0000?oool01@000?ooooooooooo`000002oooo00P0003oool00000003o
ool0003oool00004oooo00EEEEGDe=BATI6ATI5mOGd00P000004oooo00004a<Coooo0P0000^ATI40
1?ooo`000?ooo`0000;oool02/K6aWIfMY:BTU5ADOooo`000?ooo`000?oooiBDU1NATI400oooo`00
0?ooo`02oooo0`0000;oool010000?ooo`P829:BTP:ATI400hj>SYJFU^SXj003oooo00D0003ooooo
ool0001_Kfl02Y6AT@?oool00`000?ooooooo`0Ioooo0`0000?oool00`000?ooooooo`02oooo00@0
003oool0003oool2000000R][Jgoool00000003oooo=cLgUiNGoool20000017oool0002RXZ9VIVH0
003hn?R?Shn@T93AdM40000H61RIVIVATI40003oool0003oool00P000009T92@TI6ATI6AWIfM0000
ooooh>3P0000PX:200>ATI401Y2@T9NGUk2`/8B4Q00009fMW@FATI400h61PI6ATI6AT@02oooo00P0
003oool0001IFET0002a/K6EUIF@T907TI6A00^QXJ40003ooonDU9@0001GEeMJFUYoOgnCTi>GUiN0
P8001i6AT@08T92@UYJFZZZZUiNGBDU9]kNgoooo00002i6AT@;oool00`000?ooooooo`0Boooo000M
oooo00<0003oooooool00_ooo`030000oooo000000;oool00`000?ooo`000007000000?oool00000
00000P000004ooooM7AdM7Adoooo1P000003oooo0000oooo00YdM7@00`000?ooo`000002oooo2`00
0003LW9bM7AdM7Ad01AdM7@00f1PH0000?ooo`02000000Coool0003oooooool200000_ooo`800000
1?ooo`000?ooooooo`@00002oooo0P000003oooo0000SHf=00QdM7@2oooo00<0003oooooool06?oo
o`030000oooooooo00;oool00`000?ooo`000003oooo00D0003oool00000003oool00`000003oooo
0000000000<000000f5QH@0006UYJ@02000000Coool00000003oool300000_ooo`QYJFT00oooo`00
0?ooo`0500000_ooo`H0000FJFUY00?oool0003oool00P0000;oool200000_ooo`@000000fUYJOoo
ooooo`0200000_ooo`<000001Oooo`000?ooo`00065QH@0;JFUY0_ooo`030000oooooooo01_oool0
0`000?ooooooo`02oooo00<0003oool000000_ooo`030000oooooooo00P000000oooo`0000000002
000000KooonATI6ATI7oool0003oool4000000?oool0002[Zj/02Y6AT@040000oooo0000oooo2000
0004oooo0000000000005Y6AT@03SXj>0000oooo008000001?ooo`000?ooooooo`800002oooo0P00
0003oooo0000oooo00;oool300000_ooo`050000oooo0000BTY:UIFE00RATI43oooo00<0003ooooo
ool06Oooo`030000oooooooo00;oool00`000?ooo`000003oooo00D0003oool00000003oool01@00
0003oooo0000000000@000000oooo`0000000005000000?oool0003oool00`0000;oool020000?oo
o`000;Vi^I2@T0000?ooo`0000;oool2000000<R8R8b<S:5QHD01@000003SXj>TI6ATI6A00:ATI40
0i2@T96ATI6AT@0200000_ooo`030000oooooooo0080000015UIF@000;6a/I2@T0BATI401P000?oo
o`0000000?ooo`0000;oool015EEE@000=cLg9ZJVP80000019NGUgEeMOooooooo`@00002oooo0P00
0003^k^kT92@TI6A00RATI42oooo00<0003oooooool04_ooo`007_ooo`070000oooooooooooo0000
oooo000000;oool200000_ooo`8000001Oooo`000?ooo`000?ooo`0300000_ooo`9dM7@01?ooo`00
0?ooo`0000;oool00`000?ooooooo`02000027AdM003oooo0000oooo00?oool00`000?ooooooo`02
oooo1@000003oooo0000M7Ad01AdM7@0161PH0000000000000;oool200000_ooo`030000oooo0000
00?oool00`000?ooo`000002000000?oool0000000000oooo`<000000oooo`0007AdM006M7Ad0_oo
o`030000oooooooo01Woool01`000?ooooooooooo`000?ooo`000003oooo00D0003oool0003oool0
00000oooo`030000oooo000000<000003?ooo`0006UYJOooo`000?ooo`000?ooo`000?ooo`000?oo
o`800008JFUY00<0003oooooool00`000004oooo0000000000000_ooo`<000000oooo`0006UYJ@0D
JFUY00<0003oooooool00P000005oooo00000000oooo000000;oool010000?ooo`0006MWI`<00000
1Oooo`00000000000?ooo`02000000Coool000000000000;JFUY00?oool0000000007_ooo`070000
oooooooooooo0000oooo000000;oool200000oooo`8000001Oooo`000?ooo`000?ooo`0300000_oo
o`:ATI401?ooo`000?ooo`0000;oool010000?ooo`00000000VATI400nc/k0000?ooo`02oooo0P00
00?oool3000000Goool00000003oool000005I6AT@<00003oooo00D0003oooooool0003oool00P00
00;oool00`000?ooo`000002000000?oool0000000000oooo`<000000oooo`X:2Y6AT@06TI6A0_oo
o`80000Loooo00L0003oooooooooool0003oool000000oooo`040000oooooooooooo0P0000Goool0
1000014A4@00000000;oool01@000?ooo`000=GEe@000002oooo00T0003oooooool0000F5QH0002d
];@92@T000000_ooo`@00004oooo00<0003oooooool00_ooo`D000000oooohj>SY6AT@05TI6A00FF
UYKWinL0000@410000000_ooo`800002oooo0`000003/K6aUIFEFEUI008000001?ooonOWi`000000
00;oool00`000?ooo`000003oooo00=IFEWoool000000P000003oooo0000000000?oool3000000?8
b<R@T92ATI401Y6AT@03oooo0000000001Coool001koool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oool000000_ooo`<000001?ooo`0000000?ooo`@000000gQhN00000000002000000Co
ool00000003oool5000017AdM0l000000k^k^`0000000003000037AdM0<000000i6ATOooo`000003
000000?oool0003oool00`00009dM7@01@0007AdM1DE5@000?ooo`09000000<Y:BUdM7@000001000
0003oooo0000000000MdM7@2oooo00<0003oooooool06Oooo`070000oooooooooooo0000oooo0000
00?oool010000?ooo`000?ooo`D000000oooo`0000000004000000=aLG40000000002@000003BDU9
JFUY:BTY00=YJFT400000_ooo`T000001?ooo`000000000000UYJFT01@0006UYJ@00000006UYJ@03
000000>MWIgoool0000010000003SHf=JFUY000000T000000f5QH@0000000007000000Goool00000
003oool000002fUYJ@;oool00`000?ooooooo`0Loooo00L0003oooooooooool0003oool000000_oo
o`030000oooooooo00H000000oooo`0000000005000000>BTY80000000000P000004oooo00000000
oooo0`000003TI6A0@41TI6A00:ATI49000000=PH63oool000002P0000bATI42000000>FUYKoool0
00001@000003oooo00000000008000001I6AT@00096ATH>3P`000002oooo1P000003oooo00000000
00@000000oooo`000?ooo`0200001i6AT@?oool00`000?ooooooo`0Joooo00L0003oooooooooool0
003oool000000oooo`050000ooooZj^[oooo[jn_010000001IfMWCHf=P000:BTY410@003000000B@
T92ATI6@T92DU9@4000000ooool00000000K6a/A4A410@6@T91jNWX10@40001ZJVXN7QjATI40000E
5AD00`0000VATI42P82000H000010@400000001CDe=8B4P2000000Ooool000000000003oool/;2`1
0@400h20P0060000TI6AP8200000U9BDRHV90P000004T92@0000LW9bPX:20P0000:0P805000000?o
ool0000000001i6AT@;oool00`000?ooooooo`0Boooo000Moooo00<0003oool000000_ooo`030000
oooo000000;oool00`000?ooooooo`02000000?oool0003oool00P0000;oool3000000Goool0003o
ool0003oool00P000004oooo00000000Ng]k0P000004M7AdooooM7AdM7Ad0P000003oooo00000000
00Coool01GAdM79bLP0000000?ooo`0200000_ooo`050000oooo00000000oooo00YdM7@200000ooo
o`D00003oooo00<0003ooomdM7@01GAdM00;inOW00000000oooo0000oooo0000oooo0000oooo0000
00;oool0100001DE5Oooof1PH0@000000oooogAdM7AdM005M7Ad0_ooo`030000oooooooo01Soool0
0`000?ooo`000002oooo00<0003oool000000oooo`040000oooooooooooo0`000003oooo00000000
00;oool02`000?ooo`000?ooo`000?ooo`000?ooo`000?ooo`000002oooo0P000004ooooJFUY0000
oooo0`000004oooo00000000oooo0P000003JFUYP8200000008000001Oooo`000<O7afMWIfUYJ@02
000000?ooomYJFUYJFT01fUYJ@800002oooo0P0000;oool4000000?oool0003oool01VUYJ@04SHf=
0000oooooooo0P000006oooo0000kNg]JFUY0000QHF51VUYJ@03oooo0000000000]YJFT2oooo00<0
003oooooool06oooo`030000oooo000000;oool00`000?ooo`000002oooo00<0003oooooool00_oo
o`800002oooo0P0000;oool3000000Goool0003oool0003oool00P000008oooo00000000oooo0000
ooooTI6Aoooo0Y6AT@8000000oooo`0000000003oooo00<0002ATI4000000P000007oooo0000oooo
0000oooo0000oooo0080000;TI6A0P0000;oool3000000?oool0000000000oooo`03moOgTI6ATI6A
00BATI400j>SX`000?ooo`02000000Koool0003oool0003inOWgmoL2000000Goool0003Xj>R>SXj0
P8000`000003ooooTI6ATI6A00FATI43oooo00<0003oooooool06Oooo`030000oooo000000;oool0
0`000?ooo`000003oooo00P0003ooooooomYJFT0003oool0003oool2000000?oooo]kNdG5aL00P00
000;oooo0000oooo0000ooooQ8B4ADE5ooooJf][SHf=TI6A00800000192@T:f][I6ATI6AT@800000
0oooo`0000000002oooo00eeMGF=SHfATI6ATI60P81NGUkTi>B5QHE]KFfGUiNEUIF2PX:CTi<00P00
0003WIfMTI6ATI6A00RATI4200000oooo`H000001?ooo`000;no_i:BTPNATI403hJ6QXF5QM7AdHn?
Sl[:bXV9RIFEUGEeMI:BTX:2PY6ATIBDU92@T96ATI:BTP02TI6A00B>SXh00000002KVi/7TI6A0_oo
o`030000oooooooo01;oool001koool00`000?ooooooo`02oooo00D0003oooooooooool000001?oo
o`030000oooo000000?oool01@000?ooooooooooo`000003oooo0P000003oooo0000oooo00Coool0
1gAdM00007AdM7AdM0000?ooo`000002oooo0P000005oooo0000PH610000oooo00800002oooo0P00
00;oool2000000?ooomdM7AdM7@027AdM0<00005oooo00<0003oool000000P000003oooo:BTYM7Ad
009dM7@00hR8R00000000002oooo00L0003oool00000003oool0003oool010000003oooo0000oooo
00<000000oooo`000?ooo`07M7Ad0_ooo`030000oooooooo01Woool00`000?ooooooo`02oooo00<0
003oooooool00_ooo`080000oooooooo0000oooo0000oooo00000oooo`040000oooo0000oooo0P00
00;oool3000000?oool0003oool00P000003oooo0000oooo00;oool2000000[oool0003oool0003o
oomYJFWoool0003oool00002oooo0P0000?oool00`000?ooofUYJ@08JFUY00Coool00000003oool3
00001?ooo`8000000oooofUYJFUYJ@04JFUY00<0003oooooool00P000008oooo000000000000oooo
JFUY0000oooo0`0000;oool010000?ooooooo`0000]YJFT2oooo00<0003oooooool07?ooo`030000
oooooooo00;oool01@000?ooooooooooo`000005oooo00<0003oool000000oooo`050000oooooooo
oooo000000?oool2000000Woool0003oooooool0003oooojn_ZATI4000000Y6AT@800003oooo0P00
0003oooo410@000000;oool2000000Coool0000000000002oooo0P0000^ATI4300001?ooo`030000
oooooooo008000000oooohJ6QY6AT@02TI6A00>@T90/;2`000000oooo`<000000oooo`000?ooo`06
000000Ooool000000000003oool0003oool01i6AT@?oool00`000?ooooooo`0Joooo00<0003ooooo
ool00_ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003oool000000oooo`050000
ooook^k^oooo000000?oool2000000?oool0003oool00_ooo`04h^;RVYZJT92@00000Y6AT@08N7Qh
oooo0000YZJVoooo:b/[0000X:2P0Y6AT@04R8R8oooo000000000_ooo`800002oooo00<J6QYaLG6C
Ti<02Y6AT@<000002m7AdJn_[oooooCdm?ooo`000?ooojVYZB4Q8GYjNYJFUP05TI6A01R@T921PH7o
ooooool0003ooonRXZ80003oool0003ooom<C4`0001XJ6P0003^k^icLg?ooon:RXX0001eMGGooomY
JFVBTY87TI6A0_ooo`030000oooooooo01;oool002Ooool010000?ooo`00000000;oool00`000?oo
ooooo`04oooo0P000004oooo0000oooooooo100000?oool010000?ooo`000?ooo`9dM7@2000000Wo
ool00000003ooom^KVidM7Coool0003oool00`0000Coool3000000?oool0001dM7@02GAdM0040000
oooo0000oooo0P0000;oool00`000<O7agAdM006M7Ad00P0003oooooooooool0003oool0003oool2
000000?oool0003oool00P0000;oool02@000?ooo`000?ooo`000?ooo`000?ooo`000007M7Ad0_oo
o`030000oooooooo02?oool010000?ooo`000?ooo`800002oooo00H0003oool0003oool0003oool3
000000Coool0000000000002oooo0P0000;oool0200006UYJ@000?ooo`000?ooo`000?ooo`800000
1gmoOfUYJOooo`000?ooo`000?ooo`02000000Ooool00000003oool0003oool000002FUYJ@@00003
oooo0P0000;oool00`0006UYJFUYJ@03JFUY00>=SHd0000000000_ooo`030000oooooooo00800002
oooo00D0001[Jf_oool0003oool00P000003oooo0000oooo00<0000;JFUY0_ooo`030000oooooooo
02Goool00`000?ooooooo`0200000_ooo`030000oooooooo00?oool01@000?ooo`000?ooo`000002
oooo00@0003oool000000003oooo0P000004TI6AooooTI6ATI6A0`000009oooo0000ooooT92@TI6A
0000oooo0000oooo00800004oooo0`000003oooo0000TI6A00VATI400`000?ooo`00000200000_oo
o`030000D51@WYjN00JATI401K6a/@000?ooooooo`000002oooo0`00000:oooo0000oooo0000oooo
0000oooo0000oooo00000_ooo`8000000oooo`00096AT@06TI6A0oooo`030000oooooooo02Coool0
10000?ooo`00000000;oool00`000?ooooooo`02oooo00H0003oool00000003oool00002oooo00<0
001_Kfl000001?ooo`040000oooo0000[Jf]0Y6AT@03RXZ:0000oooo008000002IJFUY6ATI6ATI6A
TFIVI_ooo`000?ooo`000004oooo0`000003oooo0000TI6A00VATI4010000<O7a`000?ooo`800002
oooo00<@412ATI6ATI401Y6AT@08NGUioooomOGeoooo0000oooo0000oooo0P00000@oooo0000oooo
LW9b0000/K6aoooo0000oooo0000oooo0000oooo0000oooo00001i6AT@;oool00`000?ooooooo`0B
oooo000Woooo0P000005oooo000000000000oooo00L000000oooo`000?ooo`02000000?oool0003o
ool010000004oooo0000M7Ad00000WAdM004GUiNoooo000000000_ooo`040000oooo0000oooo0P00
00;oool500000_ooo`030000ooooM7Ad00UdM7@2000000Koool000000000003oool00002oooo00D0
003ooom`L71dM7B8R8P00P000004oooo00000000oooo100000;oool010000?ooo`000?ooo`<00000
0oooo`000?ooo`03000000?oool0003oool01gAdM0;oool00`000?ooooooo`0Soooo00<0003ooooo
ool010000003oooo0000oooo00D00002oooo00H0003oool0003oool0003oool2000000?oool0003o
ool00`000003oooo0000oooo008000000ooooeQHF0000002oooo0`0000;oool200000_ooo`800000
0oooofUYJFUYJ@07JFUY00D0003oooooool0003oool00P0000;oool2000016UYJ@800002oooo00<0
003oooooool00`000008oooo000000000000ooooJFUY0000oooo0`000003oooo0000oooo00<0000;
JFUY0_ooo`030000oooooooo02Goool200000_ooo`<000000oooo`0000000005000000?oool0003o
ool00P000003oooo0000oooo00D000000ooooi6ATDm?C`02TI6A00B>SXh0000000000002oooo00H0
003@d=000000003oool00002oooo100000?oool00`00096ATI6AT@09TI6A00=MGEd0003oool00P00
0003oooo0000oooo00;oool01000092@T96ATIBDU08000001?ooo`0000000?ooo`<000001oooo`00
0?ooo`000?ooo`000;2`/003000000?oool0003oool00`000003oooo0000oooo00NATI42oooo0P00
02Koool00`000?ooooooo`03000000?oool0000000000P0000;oool010000?ooo`000?ooo`800000
1Oooo`00000000000?ooo`02000000Coool0002ATI6@T903TI6A00>i^KT0000000000_ooo`04PX:2
TI6AB4Q8oooo0P000003oooo0000oooo00<000001Hb<S?ooooooo`000?Shn00:TI6A00>@T92?Shoo
ool00`000006oooo0000ooooooooHF5QTY:B0i6AT@03SHf=Cdm?oooo008000001Oooo`0000000000
0?ooo`0200000_ooo`8000001`410Jb/[0000:ZZZWAdM?oooh^;R`02000000?oool0003Fe]H01i6A
T@03oooo0000000001Coool002Ooool00`000?ooooooo`02oooo00<0003oool00000100000?oool3
00000oooo`040000oooooooo00000oooo`030000Lg=cM7Ad009dM7@01J^[Z`0000000?ooo`000003
oooo0`000005YZJVKFe]M7AdRHV9oooo00<00002oooo00<0001dM7AdM7@02gAdM0030000oooooooo
00@000001?ooo`000000000000;oool00`000?ooo`000002000000?oool0000000001gAdM0060000
R8R80000oooo0000oooo0P000004oooo0000oooo00001gAdM0;oool00`000?ooooooo`0Soooo00@0
003oool0003oool3000000Koool0003oooooool0003oool2000000?oool0003oool00_ooo`030000
oooo000000;oool020000?ooo`0006QXJ?ooofUYJD51@Oooo`<000002?ooo`000?ooo`000?ooo`00
0?ooo`0000Coool3000000?oool0001YJFT02VUYJ@D000001_ooo`0000000?ooo`000?ooo`800002
oooo1@000003oooo0000oooo00@000002_ooofUYJOooo`000?ooo`000?ooo`000?ooo`0000;oool0
0`0006UYJFUYJ@09JFUY0_ooo`030000oooooooo02Goool00`000?ooooooo`03oooo00<0003oool0
0000100000?oool300000oooo`040000oooo[jn_00000_ooo`030000TI6ATI6A00>ATI401@000?oo
o`000?ooo`000002oooo0`000005oooo^KViTI6ATI6AT92@008000001Oooo`000?ooooooo`00000=
TI6A00D0003oool00000003oool01@0000?oool4000000?oool0001XJ6P01i6AT@08WinO410@0000
aLG50000ooooGemOoooo0P000003oooo92@TTI6A00JATI43oooo00<0003oooooool09?ooo`030000
oooooooo00?oool8000000BOWil0002?Shl00003oooo0`000005oooo0000TI6A/k>cPH6100FATI40
18f=S@000?ooo`0000?oool5000000Woool0003oool00022PX:4Q8BLW9be]KF?Shl03I6AT@03S8b<
f=SH`l?300@000001?oooh^;Rf][JhV9R@;oool00`000?ooo`000002000000Cooonh^;P0000A4A42
00000_ooo`8000003?ooo`0000000;6a/Hn?SijNWY2@T8f=SIJFUV][Jjn_[i2@T0NATI42oooo00<0
003oooooool04_ooo`009oooo`030000oooooooo00;oool010000?ooo`00000000;oool2000000Qd
M7@000000026QXKoool0003oool00002oooo2gAdM004LW9b00000000oooo0P000004oooo0000oooo
00006WAdM003dm?C0000oooo008000001?ooo`000?ooooooo`@00002oooo00<0002n_[idM7@06gAd
M0;oool00`000?ooooooo`0Soooo00<0003oooooool00_ooo`030000oooo0000008000001oooo`00
0?ooofQXJ?ooo`000?ooo`05000000=ZJVYYJFUYJFT016UYJ@06^[ZjJFUYJFUYTI6A0000oooo0P00
0007oooo0000oooo0000oooo0000HF5Q01IYJFT00`000?ooooooo`0200000_ooo`800002oooo00<0
003oool000000`000003f=SHJFUYJFUY01eYJFT2oooo00<0003oooooool09Oooo`030000oooooooo
00?oool010000?ooo`00000000;oool2000000FATI4J6QX0002DU9Coool00`000003oooohN7QTI6A
00ZATI4010000?ooo`000?ooo`<000000oooo`000;^k^`0ITI6A00>OWil0003oool0100000;oool2
000000Koool00000003oool0002LW9`LTI6A0oooo`030000oooooooo02Coool01@000?ooo`000?oo
o`000002oooo0P0000;oool02P000?ooo`00092@T000096ATM[JfP000?ooo`0000;oool2000000?o
oolm?CfATI401i6AT@03Shn?0000oooo008000001_ooo`000?oooh61PHN7Qoooo`8000000oooo`00
0:ZZZP0DTI6A00J7QhO@d=00001gMgOoool00002oooo0`000004JVYZalO7dM7ARXZ:0i6AT@05RXZ:
/K6agmoO00004A4A008000001?ooo`000?ooo`0000nATI42oooo00<0003oooooool04_ooo`009ooo
o`030000oooo000000T000001F][JgAdM0@4100007AdM00500003GAdM0040000oooo0000oooo1000
0003I6ATM7AdM7Ad01]dM7@00`000=?Cd`000007000000<`<31dM7AdM7@07GAdM0;oool00`000?oo
ooooo`0Soooo00<0003oool000002@000003BDU9JFUY000000H0000<JFUY00=PH600000000001000
0003oooo0000J6QX01YYJFT00`0006UYJ@000007000000?ooomYJFT000008FUYJ@;oool00`000?oo
ooooo`0Uoooo00<0003oooooool02P000005T92@TI6AT92@0000TI6A00D0000=TI6A00@0002[Zj/0
003oool3000000>@T92ATI6ATI406i6AT@030000TI6AWinO00H000000hj>SP00096AT@0NTI6A0ooo
o`030000oooooooo02Coool01@000?ooo`00000008f=S@06000000QmOGd00000002ATI6:RXZATI61
PH62PX82000000D@4120P82?Shnd];@000002I6AT@04T92@PH610000U9BD0P000003SXj>P820TI6A
00:ATI401H61PI6AT@000:6QXA0@400FTI6A00>0P821PH4000000P000005Ng]k000000000000PH61
00ZATI401h20P96ATI6AT@0007YjNP00092@T00?TI6A0_ooo`030000oooooooo01;oool002Ooool2
00000k:b/P03<30`M7AdM7Ad06]dM7@2oooo00<0003oooooool08oooo`080000oooo0000d];Boooo
0000KFe]00000_ooo`080000LG5aJFUYJFUYJ6QX0000JFUYb/[:0`0000iYJFT01D51@@000?ooo`00
065QH@0QJFUY00D0003ooooooooooom5ADD09FUYJ@;oool00`000?ooooooo`0Uoooo0P000005oooo
VYZJVYZJVYZJT92@06bATI42oooo0P0002Koool00`000?oooi6AT@1`TI6A00?oool0000000005?oo
o`009oooo`030000oooo/[:b00:b/[800c0`<7AdM7AdM01[M7Ad0_ooo`030000oooooooo02?oool0
0`000?ooomKFeP02e]KF00=0@41YJFUYJFT0JfUYJ@;oool00`000?ooooooo`0Uoooo00<0003ooooo
ool00iZJVP03T92@TI6ATI6A06ZATI43oooo00<0003oooooool09?ooo`030000ooooTI6A072ATI42
oooo00<0003oooooool04_ooo`009oooo`0<0000oooo0000`L71^KVi0000MgMgD51@oooo0000oooo
AdM70gAdM007MGEeM7AdM7AdM7Ad<S8b0000MgMg011dM7@01GinOP0000X:2Shn?WEeM@0TM7Ad00<0
003oool410@08GAdM0;oool00`000?ooooooo`0Soooo00<0003ooooFe]H00]KFeP03@410JFUYJFUY
06]YJFT2oooo00<0003oooooool09Oooo`0=0000ooooooooEUIFWIfMW9bLN7QhTY:BS8b<k>c/Jf][
fm_KRXZ:00NATI400hN7Qg5aLI:BTP0@TI6A00>CTi<D51B1PH409I6AT@04;bl_l?3`UiNGShn?896A
T@?oool00`000?ooooooo`0Toooo00/0003ooon:RXZKVi/000051@EUIFGooon6QXJTY:BBTY800Y6A
T@05P82020P800000000YZJV00ZATI401a4A4OoooaXJ6_ooo`000;Vi^I2@T004TI6A00>@T92ATI6A
TI404i6AT@06MGEeEEEEoooo0000TI6AT92@396AT@03T92@TY:BTI6A026ATI42oooo00<0003ooooo
ool04_ooo`009oooo`030000ooooX:2P00:PX:000b0P87AdM7AdM01[M7Ad0_ooo`030000oooooooo
02?oool00`000?oookJf]P02][Jf00<P821YJFUYJFT0JfUYJ@;oool00`000?ooooooo`0Uoooo00<0
003oooooool00iRHV003T92@TI6ATI6A06ZATI43oooo00<0003oooooool09?ooo`030000ooooTI6A
072ATI42oooo00<0003oooooool04_ooo`009oooo`800003X:2P00<P821dM7AdM7@0JgAdM0;oool0
0`000?ooooooo`0Soooo00<0003ooonf][H00[Jf]P03820PJFUYJFUY06]YJFT2oooo00<0003ooooo
ool09Oooo`8000001OoooiRHV9RHV9RHV92@T01/TI6A0_ooo`80000Voooo00X0003ooonATI6ATI6F
UYJATI6BTY:3Ph>ATI6@T904TI6A00>EUIFIVIVHV9P0396AT@04SXj>TY:BMgMgUYJF7I6AT@03Vi^K
QHF5TY:B03:ATI400oooo`000000000Doooo000Woooo00<0003ooonPX:000Z2PX003820PM7AdM7Ad
06]dM7@2oooo00<0003oooooool08oooo`030000oooo][Jf00:f][H00b0P86UYJFUYJ@1[JFUY0_oo
o`030000oooooooo02Goool00`000?ooooooo`03V9RH00>@T92ATI6ATI40JY6AT@?oool00`000?oo
ooooo`0Toooo00@0003ooom`L732`/83000000?oool[:b_bl_800i6AT@054A4A000000000000iNGU
00ZATI401Q0@4?ooo`000?ooo`000;no_aRATI40292@T96ATI6ATE=CD`000?ooo`000820P36ATI42
oooo00<0003oooooool04_ooo`009oooo`030000oooo000000`000000c<c<gAdM7AdM006000000=d
M7@0000000002gAdM08000001?ooo`000000000000AdM7@0100007AdM000000001]dM7@700003WAd
M0040000M7AdM7Ad00002gAdM0;oool00`000?ooooooo`0Soooo00<0003oool000000[Jf]P030000
JFUY0000009YJFT03P00061PH6UYJ@0006UYJ@0006UYJF5QH@0006UYJ@00065QHFUYJ@00009YJFT0
0`0006UYJFUYJ@08JFUY00D0001YJFUYJFUYJFT000001VUYJ@030000JFUYH61P01QYJFT01@0006UY
J@0006UYJ@00000CJFUY00<0001YJFUYJFT03FUYJ@;oool00`000?ooooooo`0Uoooo00<0003ooooo
ool00P000003CDe=0000LG5a00P000000hN7Qi6ATI6AT@03000000AbLW80000A4A6ATI4200002i6A
T@06;bl_000000000000TI6A4A4A0i6AT@05P820TI6A0000TI6A000001ZATI4700003Y6AT@040000
TI6ATI6A00002i6AT@?oool00`000?ooooooo`0Toooo00<0003oool000000`000006Ti>C0000RXZ:
0000I6AT00000Q4A4@;oool2000000F>SXh00000002ATI60P8000Y6AT@8000000i6AT@0000000005
000000J@T92ATI6ATI60P800002KVi/2000000>@T92ATI6ATI400i6AT@04P820410@0000T92@1I6A
T@04410@TI6ATI6AEeMG1P000003PH61T92@TI6A00RATI400`0005MGE`000002000000<10@61PH6@
T900396AT@05T92@410@TI6ATI6A000000^ATI42oooo00<0003oooooool04_ooo`007_ooo`<00002
oooo00H0003oooooooooool0003oool2000000Koool00000003oool0003oool400000_ooo`9dM7@0
1?ooo`000?ooo`0000;oool01@000?ooooooo`000410@009M7Ad00D0003oool00000003oool00P00
0003oooo0000oooo00<000000oooo`000000000HM7Ad00@0003oooooool00004oooo0`0000;oool0
100007AdM7AdM?ooo`D000001Oooo`00000000000?ooo`0:M7Ad0_ooo`030000oooooooo01Woool3
00000_ooo`030000oooooooo00;oool01@000?ooo`0000000?ooo`03000000Coool00000003oool2
000000=YJFT0001YJFT010000003oooo0000oooo008000000ooooi^KVfUYJ@07JFUY00?oool0003o
ool00`000004oooo20P8JFUYJFUY0_ooo`@0000GJFUY00@0003oooooool00002oooo00@0003oool0
003oool9JFUY00?oool0000000000P000003oooo0000oooo00eYJFT2oooo00<0003oooooool07?oo
o`<00002oooo00D0003oooooooooool000000_ooo`8000001_ooo`0000000?ooo`000?ooo`@00002
oooo0Y6AT@04oooo0000oooo00000_ooo`040000oooo0000WIfM2Y6AT@040000oooo0000oooo0`00
0003ooooLG5a000000<000000oooo`000000000GTI6A00<0003oooooool00P0000?oool2000000Co
ool0003ooomWIfL2TI6A00?oool0000000000`000005oooo00000000oooo000000ZATI43oooo00<0
003oooooool06_ooo`<00002oooo00<0003oooooool00_ooo`050000oooo00000000oooo00800000
0oooo`000000000600000_ooo`8000001Oooo`000>3Ph=_Kf`000002oooo00T0002ATI40002LW9`0
003oool0003oool000000Y6AT@0:0000oooo00000000oooo0000LG5aXJ6QTI6A^;Rh0`000003oooo
0000Shn?00NATI400hn?Sng]k@000003000000Goool00000002[Zj^@T9001Y6AT@040000oooooooo
00001?ooo`8000001492@YJFUYbLW92@T0:ATI400i>CThj>SP000003000000Goool000000000002V
YZH02Y6AT@;oool00`000?ooooooo`0Boooo000Ooooo00H0003oooooool0003oool00002oooo00@0
003oooooooooool2000000?oool0003oool01Oooo`800002M7Ad00<0003oool000000`0000Coool0
0`0007AdM7AdM007M7Ad00?oool0003oool00_ooo`D000000oooo`0000000002000000?ooomdM7Ad
M7@05WAdM0800002oooo0P000004oooo00000000oooo10000003oooo0000oooo00Coool010000?oo
ooooooooo`8000000oooogAdM7AdM007M7Ad0_ooo`030000oooooooo01[oool01P000?ooooooo`00
0?ooo`0000?oool00`000?ooo`00000200000_ooo`800002oooo00H0003oool0003Fe]H0001YJFT2
000000Goool00000003oool000000_ooo`800008JFUY00Coool0000000000002oooo0P0000;oool2
000000Coool00000003ooolFJFUY00?oool00000000010000003oooo0000oooo00D000000fUYJOoo
ooooo`0200001Oooo`040000oooo0000000036UYJ@;oool00`000?ooooooo`0Moooo00H0003ooooo
ool0003oool00002oooo00<0003oooooool00_ooo`8000000oooo`000?ooo`05oooo00LK6a/0002A
TI6ATI4k>c/0003oool00`0000?oool00`00096ATI6AT@08TI6A00Koool0003oooooool0003oool6
000000Coool00000003ooolGTI6A0P0000?oool01`000?ooo`0000000?ooo`000?ooo`02000000?o
ool0003oool01?ooo`040000oooooooooooo0P000003ooooTI6ATI6A00NATI43oooo00<0003ooooo
ool06oooo`060000oooooooo0000oooo00000oooo`040000oooooooooooo0P000004oooo0000oooo
00000oooo`04VIVI7AdM0000oooo0P000003oooo0000000000800003oooo00Nk^k^0P80T92BATI6L
W9`0003oool00P000004][JfTI6AaLG5AdM70oooo`D000000oooo`0000000002000000>n_[jATI6A
TI401i6AT@04Shn?kNg]0000oooo0P000005oooo00000000Zj^[T92@00BATI401bd];@000?oook>c
/cDe=@000?ooo`02000000?oool0000000000P000003WYjNDe=Clo?c00Coool010000?oooooooooo
o`8000000iNGUi6ATI6AT@07TI6A0_ooo`030000oooooooo01;oool001goool4000000Coool0003o
ool00002oooo0P0000;oool200001Oooo`D00002M7Ad00D0003oool0003oool000001Oooo`030000
M7AdM7Ad00IdM7@0161PH?ooo`000?ooo`8000001Oooo`0000000?ooo`000003oooo0P000003oooo
inOWM7Ad01EdM7@3oooo00D0001dM7@0003oool000000_ooo`030000oooo000000;oool00`000?oo
o`000004000000Coool00000003oool2000000?oool0001dM7@01gAdM0;oool00`000?ooooooo`0H
oooo10000004oooo0000oooo00000oooo`050000oooo0000oooo000000;oool2000000?oool0003o
ool00P000009oooo0000JFUYoooo0000oooo0000oooo000000?oool2000026UYJ@030000oooo0000
00?oool4000000Ooool0003oooooool0003ooon=SHd05FUYJ@030000oooo000000Coool400000ooo
o`040000JFUY000000000_ooo`D000001Oooo`0000000?ooo`00000;JFUY00?oool0000000007Ooo
o`@000001?ooo`000?ooo`0000;oool200000oooo`800005oooo0P000003oooo<C4a000000:ATI43
000000?oool0003oool00oooo`030000TI6ATI6A00NATI400hj>S_ooo`00000200000_ooo`800000
0oooo`000?ooo`02oooo0P000003ooooPH61TI6A01BATI43oooo00<0002ATI7oool00P0000;oool0
1`000?ooooooo`000?ooo`000?ooo`02000000Coool00000003oool200000_ooo`030000oooo0000
00RATI42oooo0P0001_oool4000000Coool0003oool00003oooo00@0003oooooooooool200001Ooo
o`@000000oooo`000?ooo`02oooo00<0003oool000001?ooo`03`/;2P820WIfM00:ATI400ibLW000
0?ooo`02000000Nf][Koool0003ooon>SXh00032`/800P000003oooo0000oooo00;oool2000000?=
cLfATI6ATI402I6AT@04SHf=00000000oooo0P000004oooo00000000T92@0Y6AT@0=Ti>Coooooooo
0000TI6AOGema/K60000oooo/k>c0000oooo000000;oool00`000?ooo`000002000000HF5QHA4A78
b<P0001PH62GUiL2000000?/k>b?ShnATI401i6AT@03oooo0000000001Coool001goool00`000?oo
o`000002oooo00<0003oool000000_ooo`030000oooo000000<000000oooo`000?ooo`0200000_oo
o`030000oooooooo009dM7@01Oooo`00000000000?ooo`0500002GAdM007oooo0000oooo0000:2PX
H61P000000;oool00`000?ooo`00000200000_ooo`80000FM7Ad00@0003oool0003oool5M7Ad00Co
ool00000003oool2000000Coool0003oooooool2000000?ooomdM7AdM7@00WAdM0<000000oooo`00
07AdM006M7Ad0_ooo`030000oooooooo01Soool00`000?ooo`000002oooo00<0003oool000000ooo
o`040000oooooooooooo0P0000?oool010000?ooo`000?ooo`8000001_ooofUYJ@000?ooo`000?oo
o`8000000oooo`0000000002oooo26UYJ@03oooo0000oooo00<000001?ooo`000?ooo`0000;oool2
000000?oool0000000005FUYJ@04oooo0000oooo00000VUYJ@03oooo0000oooo00;oool2000000Co
ool0001]KFgoool200000oooo`8000000oooo`000?ooo`02000036UYJ@;oool00`000?ooooooo`0K
oooo00<0003oool000000_ooo`030000oooo000000;oool00`000?ooooooo`04000000?oool0003o
ool00P000003oooo0000000000;oool2TI6A00Goool0003oool0003oool010000003ooooTI6ATI6A
00NATI401oooo`000?ooo`0008j>S_ooo`000002oooo0`000004^[Zj0000oooooooo0P0001FATI40
10000?ooo`000?ooo`FATI400oooo`0000000003000000Coool0003oooooool2000000?ooonATI6A
TI400Y6AT@<000000oooofMWIi6AT@06TI6A0oooo`030000oooooooo01Woool00`000?ooo`000002
oooo00<0003oool000000oooo`030000oooo000000<00004oooo00P0003oooooool00028R8SooolT
92Coool4000000Coool00000001XJ6P200001I6AT@04W9bL00000000oooo0P00000<oooo<30`TI6A
TI6A1PH6oooo/[:b0000oooo0000Shn?410@0_ooo`030000Q8B4TI6A00ZATI401Hn?Sng]k@000000
0?ooo`04000000J[Zj^@T900003oool0002BTY85TI6A00RCTi>5QHD00038b<P@4100002MWIeGEeL2
oooo00<0001oOgnBTY80196AT@05Jf][00000000ooooT92@00NATI42oooo00<0003oooooool04_oo
o`007_ooo`800002oooo00<0003oool000000_ooo`030000oooooooo00800003oooo00P0003ooooo
ool0003oool0003oool00002M7Ad00H0003oool0000h>3Soool00002oooo0P0000UdM7@010000?oo
o`000?ooo`=dM7@2oooo00H0003oool0001dM7APH63oool2000000?ooomdM7AdM7@04gAdM0;oool0
0`000?ooogAdM009M7Ad00Koool0003oool0003oool00008M7Ad0_ooo`030000ooooM7Ad00IdM7@2
oooo00<0003oooooool06Oooo`800002oooo00<0003oool000000oooo`030000oooo000000;oool0
0`000?ooo`000002oooo00@0003oooooooooool2000000IYJFWoool0003oool0003oool2000000Co
ool00000003oool8JFUY00L0003oool00000001YJFU5ADGoool00P000005oooo0000oooo0000oooo
008000000oooofUYJFUYJ@0CJFUY0P000003ooooJFUYJFUY00EYJFT00oooo`000?ooo`02000000MY
JFT0003oooooool0003oool0000016UYJ@040000oooooooo00002fUYJ@;oool00`000?ooooooo`0L
oooo0P0000;oool00`000?ooo`000002oooo00@0003oooooooooool200000oooo`030000oooooooo
00<000002Oooo`00096ATI6AT@000?ooo`000;no_`000002oooo0P000003ooooTI6ATI6A00NATI40
0`000?ooo`000004TI6A00K?cll0003ooom2@T;oool00002oooo0P0001JATI400oooo`000?ooo`0;
TI6A00D0003oool0003ooomWIfL00Y6AT@03oooo0000oooo00>ATI42oooo00<0003ooonATI401Y6A
T@?oool00`000?ooooooo`0Joooo0P0000;oool00`000?ooo`000003oooo00<0003oooooool00P00
00;oool3000000Sooon5QHG>c/h0003oool0002MWId00002oooo00J1PH6ATI6TY:B5QHFATI75aLD2
00001Y6AT@07W9bL00000000ooooZJVY0000oooo00BATI4019ZJVXZ:RZ2PX92@T0:ATI4019:BTP00
00000?ooo`fATI401hn?Sng]k@0000000?ooo`000?ooo`02000000?oool0003oool02Y6AT@06Ti>C
QHF5TI6AShn?W9bLT92@296AT@;oool00`000>3Ph96AT@06TI6A0_ooo`030000oooooooo01;oool0
01ooool01@000?ooooooooooo`000003oooo00<0003oool000000_ooo`<000002oooo`0000000?oo
o`000?ooo`000?ooogAdM0000?ooo`02000017AdM0040000oooooooo00001WAdM0030000oooo0000
008000000oooogAdM7AdM008M7Ad00@0003oooooool0000CM7Ad00?oool0000000000P000003oooo
M7AdM7Ad01IdM7@3oooo00<0001dM7AdM7@01GAdM0;oool00`000?ooooooo`0Joooo00D0003ooooo
ooooool000001?ooo`030000oooooooo00<00002oooo0P000004oooo0000000000000_ooo`03JFUY
0000oooo00800003JFUY00@0003oooooool00008JFUY00Coool0003oooooool:JFUY00<0003oool0
000056UYJ@040000oooooooo000066UYJ@030000oooo000000]YJFT2oooo00<0003oooooool07Ooo
o`050000oooooooooooo000000?oool00`000?ooooooo`02oooo0P000003oooo0000oooo00800000
3?ooo`000?ooo`000?oooi6ATF][Joooo`000?ooo`000?ooo`800002oooo00<0002ATI6ATI401I6A
T@03P820oooo000000800004TI6A00H0003oool0003oool0003oool200000_ooo`030000TI6ATI6A
012ATI42oooo0`000003ooooTI6ATI6A00VATI400oooo`000?ooo`04TY:B00<0003oool00000196A
T@;oool00`00096ATI6AT@05TI6A0oooo`030000oooooooo01_oool01@000?ooooooooooo`000004
oooo00<0003oool000000_ooo`8000003;no_oooo`0000000?ooodU9BOooo`00069RHY6ATB@T9?oo
o`800004TI6A00A4A4Coooooool00006TI6A00H0003oool0003oool0003oool:TI6A00AHF5Sooooo
ool0000?TI6A00>?Sho]kNd000000`000004oooo00000000oooo696AT@04Y:BToooooooo00001i6A
T@;oool00`000?ooooooo`0Boooo000Woooo10000003oooo0000oooo00D000000gAdM0000?ooo`04
000000?oool0001dM7@017AdM08000000gAdM00007AdM003M7Ad0`000004oooo0000000000002gAd
M080000=M7Ad20000003oooo000000000080000IM7Ad0P0000QdM7@2oooo00<0003oooooool08ooo
o`050000oooo00000000oooo01000003JFUY10000004J6QX20P8JFUY@D510VUYJ@H0000:JFUY0`00
00aYJFT00`0006UYJ@000006000000?oool0001YJFT06FUYJ@80000;JFUY0_ooo`030000oooooooo
02Goool2000000?oool0000000002P000003oooo0000000000X00002TI6A00@10@6ATI6ATI6@T904
000000Coool0000000000003TI6A1`000003TI6A0000000000fATI4<00002i6AT@<00004T92@0`00
00BATI420000296AT@;oool200009_ooo`070000oooo00000000oooo0000oOgm00@000001P/;2i2@
T10@49NGU`00010@408000000oooo`00096AT@03TI6A00F@T9000000002ATI6@T9000i6AT@05T92@
000000000000oooo00<0000:TI6A00B@T9000000002@T90;TI6A00J1PH4000000000002>SXhf=SH6
000000=8B4P0002ATI40696AT@800008TI6A00?oool0000000005?ooo`009oooo`040000oooo0000
oooo0`0000?oool2000000AdM7@00000003oool2000000?oool0000000001GAdM004MgMgKVi^M7Ad
oooo0WAdM08000000oooo`000?ooo`02000000?ooon8R8QdM7@02WAdM003MWIfL71`M7Ad00YdM7@2
00000_ooo`800002oooo00H0003oool00000003oool0000KM7Ad00=aLG5dM7AdM7@01WAdM0;oool0
0`000?ooooooo`0Soooo00@0003oool0003oool300000oooo`80000016YZJW1`L0000?ooo`800000
0oooo`0006UYJ@04JFUY00I/K6aNGUiYJFUYJFT0003oool3000000Goool0003oool0003oool02fUY
J@03J6QXHf=SJFUY00UYJFT01Oooo`000?ooooooo`000002oooo0P0000;oool2000000?ooomYJFUY
JFT06FUYJ@03J6QXJFUYJFUY00UYJFT2oooo00<0003oooooool09Oooo`030000oooooooo00D00003
oooo0`000003oooo0000oooo008000001Oooo`0007AdM;Jf]P000002oooo00D0002@T92ATI6ATI7o
ool00Y6AT@<00002oooo0P000003ooooT92@TI6A00:ATI401ifMW@000?ooo`000?ooo`000?ooo`02
TI6A00>@T92ATI6ATI402I6AT@8000000oooo`0000000002oooo0P000004oooo0000ooooIfMW396A
T@030000oooo000000BATI400oooo`000?ooo`0>TI6A0oooo`030000oooooooo02Coool010000?oo
o`000>o_k`<00003oooo00H0002ATI6ATI6@T900003oool2000000?oool0002@T900296AT@03ZJVY
TI6ATI6A008000001_ooo`000;Ng]clo?e]KFi>CTaVATI4200000_ooo`800002oooo00D0003ooomo
OgmWIfNBTY809I6AT@;oool00`000?ooooooo`0Boooo000Woooo00@0003oool000000003oooo00@0
003oooooooooool3000000Ooool0003oooooool0003oool000000_ooo`070000ooooEUIFMgMgKVi^
M7Adoooo009dM7@01_ooo`000?ooo`000?ooo`0000EdM7@2000000Coool00000003oool3M7Ad00=f
MWI`L71dM7@02gAdM0030000oooo000000;oool300003GAdM08000001oooo`000?ooo`000?ooo`00
0?ooo`0:M7Ad00=aLG5dM7AdM7@01WAdM0;oool00`000?ooooooo`0Soooo00H0003oool00000003o
ool00005oooo00=WIfMZJVY`L7000`000003oooo0000oooo00EYJFT016a/K5iNGVUYJFUYJ@<00000
1_ooo`000?ooo`000?ooo`0000aYJFT00fQXJ6=SHfUYJ@09JFUY00<0003oool00000100000;oool3
00007FUYJ@03J6QXJFUYJFUY00UYJFT2oooo00<0003oooooool09Oooo`030000oooooooo00800003
oooo00@0003oooooooooool3000000Ooool0003oooooool0002CTi<000000_ooo`040000gmoOSHf=
T92@0Y6AT@04ooooTI6ATI6Aoooo0`000003ooooMgMgTI6A00>ATI4010000?ooo`000?ooo`800005
TI6A00>@T92ATI6ATI402I6AT@05oooo0000oooo0000oooo00<000000ooooi6ATI6AT@0:TI6A00T0
003oool00000003oool0003oool0002l_;`04i6AT@?oool00`000?ooooooo`0Toooo00P0003oool0
000/;2coooo3`l?oool00002oooo00K0`<00001EEEF4Q8Coool00002oooo00<0002PX:21PH400_oo
o`03IVIVTY:BTI6A00>ATI402?oooi6ATI6ATOooo`000?ooo`000::RXPJATI401Hj>SP000>OWih20
P8:2PP0BTI6A00P0003oool0002PX:3oool0001RHV:0P80=TI6A00R?ShmDE5Cooon9RHW2`/::RXZC
Ti>5QHDDTI6A0_ooo`030000oooooooo01;oool002Ooool010000?ooooooooooo`800005oooo00D0
003oool00000003oool00P000005oooo;Bd]0000oooo000000?oool010000?ooogAdM?ooo`9dM7@3
000000?ooomdM7AdM7@017AdM004inOWoooooooo00000_ooo`@000000l;2`W1`L7AdM00:M7Ad00H0
003oool0003oool0003oool?M7Ad00T0003oool00000003oool0003oool0003oool0100000;oool0
0`000?ooo`000002M7Ad00=aLG5dM7AdM7@01WAdM0;oool00`000?ooooooo`0Soooo00@0003ooooo
ool00003oooo00@0003oool0003oool300000oooo`030000ooooLg=c008000003?ooo`00000006=S
HeiNGVUYJ@000?ooo`000?ooo`000?ooo`800005JFUY00/0003oool0003oool0003oool0003]kNeY
JFUXJ6QSHf<02VUYJ@030000oooo000000?oool00`000?ooofUYJ@0<JFUY00D0003oool00000003o
ool00P000005oooo0000JFUYoooo000000QYJFT00fQXJ6UYJFUYJ@09JFUY0_ooo`030000oooooooo
02Goool00`000?ooooooo`02oooo0P0000Goool01@000?ooo`0000000?ooo`02000000Gooon0P800
003oool000000oooo`040000TI6ATI6Aoooo0Y6AT@800002oooo1I6AT@06Xj>Soooooooooooo0000
oooo0P000005oooo00000000WIfMT92@00^ATI401@000?ooo`0000000;bl_00?TI6A00@0003oool0
003oool2000000?oool0003oool0100000;oool010000?ooooooo`0000ZATI43oooo00<0003ooooo
ool09?ooo`040000oooooooooooo0P0000Goool01@000?ooohR8R2@T9?ooo`02000000GooonATI4@
413oool000000oooo`04Lg=cTI6ATI6AXZ:R0Y6AT@04D51@00000000TY:B1i6AT@03m?Cdoooo0000
00;oool2000000=;Bd^8R8RATI40396AT@050000f=SH0000ooooNWYj016ATI404Oooo`0000000=oO
g`000?ooo`000?oooeEEEE=CDh>3P`000:j^[YZJVUaLG9>CTh^;R`0;TI6A0_ooo`030000oooooooo
01;oool002Ooool010000?ooo`000?ooo`800002oooo00@0003oooooool00002oooo00@0003oool0
00000003oooo0P000003oooo0000000000;oool02@000?ooogAdM7AdM?ooo`000?ooo`000?ooo`05
M7Ad00H0003oool00000003oool00002oooo00D0003oool0003oool000002gAdM003oooo0000oooo
00;oool00`0007AdM7AdM00;M7Ad0_ooo`8000000oooo`0000000002oooo00<0003oool000000_oo
o`8000001?ooo`000000000000;oool00`0007AdM7AdM005M7Ad0_ooo`030000oooooooo02?oool0
0`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooo000000<00002oooo00AYJFT0003o
ool00002oooo0P000005ooooJFUY0000oooo000000;oool2000016UYJ@03SHf=oooooooo00800000
0oooo`000?ooo`03oooo00<0003]kNeYJFT026UYJ@03oooo0000oooo008000000oooofUYJFUYJ@0<
JFUY00<0003oool000000_ooo`8000001_ooo`000?ooof][J`000?ooo`<00002oooo00@0003ooooo
ool0000;JFUY0_ooo`030000oooooooo02Goool01P000?ooooooo`000?ooo`0000?oool010000?oo
ooooo`0000;oool01`000?ooo`0000000?ooojRXZ?ooo`02000000Ooool00000003oool0002ATI7o
ool00Y6AT@05YZJV0000oooo0000oooo00BATI400`000?ooooooo`02000000Coool0003oool00002
oooo00<0003oool000002Y6AT@;oool010000?ooooooo`0000fATI42oooo00<0003oool000000P00
00;oool01@000?ooooooo`000?ooo`02000000Coool0000000000002oooo00<0002ATI6ATI401I6A
T@?oool00`000?ooooooo`0Toooo00D0003oool0003oool000000oooo`030000oooo000000?oool0
1QLG5oooo`0000000?oooiVIV@<000000oooo`0000000002oooo00>0P82MWIfATI400Y6AT@040000
oooo6ATITY:B1I6AT@06T92@000000000000oooo00000_ooo`050000oooo0000ooooRHV900ZATI40
0i2@T;bl_0000003oooo00>0P82ATI6ATI402i6AT@07Xj>Soooo00000000ooooLg=c000000;oool0
0`000<?3``000002oooo0P000004oooo5QHF0000De=C0_ooo`03Rh^;TI6ATI6A00FATI42oooo00<0
003oooooool04_ooo`009oooo`8000001?ooo`000000000000Koool3000000Coool0003oooooool2
000000?oool0000000000P0000;oool200000WAdM003R8R8oooo0000008000001f1PH7AdM7AdM7Ad
M0000?ooo`000002oooo00<0003oool000000`0000;oool00`0007AdM7AdM009M7Ad00L0003oool0
003oool0003oool000002WAdM0030000oooooooo00@00002oooo0P000003oooo0000000000800000
0oooo`000?ooo`02000000Coool0003oool00007M7Ad0_ooo`030000oooooooo02?oool01@000?oo
o`000?ooo`000002oooo0P000004oooo00000000oooo0`0000;oool00`000?ooo`000002000000So
ool0003oooooool0001YJFT0002=SHd3000000?ooomYJFUYJFT00fUYJ@040000oooo000000001?oo
o`<000000oooo`0006UYJ@09JFUY0`0000;oool00`0006UYJFUYJ@0:JFUY00@0003oool0003oool2
000000_oool000000000003ooomTI6Coool0003oool0003oool00P000004oooo0000000000002fUY
J@;oool00`000?ooooooo`0Uoooo0P0000;oool300001_ooo`<000001Oooo`000?ooooooo`000003
oooo0`000004oooo0000TI6A>3Ph0Y6AT@06U9BD00000000oooo0000SXj>0Y6AT@044A4Aoooo0000
00000_ooo`@000001Oooo`000?ooooooo`00000;TI6A00L0003oool00000003oool0002l_;`02I6A
T@090000oooooooo0000oooo0000oooo0000oooo008000000oooo`0000000002000000Goool0003o
ool0003oool00P000003oooo0000TI6A00JATI42oooo0P0002Koool00`000?ooooooo`0300001Ooo
o`@000001_oooe=CDoooooooo`820XN7Q`;oool2000000EXJ6Soooooool0002@T9000i6AT@04b<S8
00000000ADE5196AT@07T92@oooo0000oooo0000Ng]koooo00@00002oooo00<0002ATI6ATI402I6A
T@07Shn?oooo0000oooo0000ooooShn?00ZATI406Hn?Slk>c_ooo`000?ooo`000?ooo`0003<c<i>C
Tg9bL_ooohZ:RUMGEhB4Q0000?ooo`000?ooo`P820000?ooo`000?oooaDE5@07TI6A00?oool00000
00005?ooo`009oooo`030000oooo000000;oool00`000?ooo`00000200000oooo`040000oooo0000
oooo0P000003oooo0000oooo008000001_ooo`000?ooo`0007AdM820P0=dM7@00`000?ooo`000002
oooo0WAdM003inOWoooooooo008000001m?CdgAdM00000000?ooo`000?ooo`02000000?ooomdM7Ad
M7@02gAdM006oooo0000oooo0000oooo000027AdM0070000oooo0000oooo0000oooo000000MdM7@2
000000Goool0003oool0003oool00P000003oooo0000oooo00MdM7@2oooo00<0003oooooool08ooo
o`030000oooooooo00@000000oooo`000?ooo`0600000_ooo`8000000oooo`000?ooo`02000000_o
ool0003ooomQHF40001YJFWoool0003oool0003oool00fUYJ@;oool00`000?ooo`00000400000_oo
o`8000000oooofUYJFUYJ@09JFUY00Koool0003oool0003oool0000;JFUY0P000006oooo0000oooo
0000oooo00000_ooo`040000JFUY0000oooo0`000006oooo0000oooo0000oooo00002fUYJ@;oool0
0`000?ooooooo`0Uoooo00@0003oooooool00002oooo00<0003oool000000P0000;oool2000000?o
ool0003oool00`0000;oool2000000Koool00000003ooonATI6CTi<3TI6A00<O7al0000000000_oo
o`:ATI400j>SXoooooooo`0200000Y6AT@050000oooooooo0000oooo0080000>TI6A00H0003oool0
003oool0003oool8TI6A0P000004oooo0000oooooooo1i6AT@070000IfMWoooo0000oooo0000oooo
008000000oooo`000?ooo`07TI6A0oooo`030000oooooooo02Coool01`000?ooo`000?ooon_[j`00
0?ooo`0300000_ooo`8000000k>c/`0009RHV002000000?ooon9RHWoool00P000005ooooIVIVXj>S
0000P82000BATI401I2@T;Rh^0000?oooiNGU`03TI6A00k0`<3oool00000003oool0003ooon5QHGE
eMD0003ooolF5QH0002RXZ8=TI6A00KGemL0003oool0003oool00008TI6A00B6QXKoool0003oool5
0000017oool00000002[Zj^@T92<S8b@T932`/::RXZ`/;00002GUiL0001GEeOoool0002LW9`01i6A
T@;oool00`000?ooooooo`0Boooo000Woooo00<0003oooooool00`000003oooo0000000000<00000
0oooo`000?ooo`04000000Ooool0000000000014A4AdM7ATI6@00P0000IdM7@00hR8R00000000002
000000=dM7@0000000000P0000MdM7@300003gAdM0L00005M7Ad1`00011dM7@00`0007AdM0000008
M7Ad0_ooo`030000oooooooo02?oool010000?ooo`000?ooo`<000000oooo`000?ooo`05000000Co
ool00000003oool5000000QYJFT0001YJFT0001YJFT0001YJFT92@T4000000=5ADEYJFT000001000
0006@410JFUYJFUY2@T90000JFUY0P000003JFUY0000JFUY00]YJFT700001VUYJ@H0000;JFUY0P00
0005JFUY0000JFUY0000JFUY0080000;JFUY0_ooo`030000oooooooo02Goool010000?oooooooooo
o`<000000oooo`0000000005000000?oool0001KFe/00P000009oooo000000000000P820TI6AT92@
0000T92@00FATI400i2@T00000000003000000>ATI40000000000P0000NATI43000000>@T92ATI6A
TI402i6AT@@000001?ooo`000000000000BATI470000496AT@040000TI6A0000T92@1i6AT@?oool0
0`000?ooooooo`0Toooo00D0003ooooooolN7Qj4Q8@01`000005oooo0000TY:B0000T92@00800000
0oooo`0000000003000000>7QhN0P821PH401Y6AT@07T92@0000000000000@41TI6AMgMg00P00000
1Hn?Sh61PI2@T820P861P@0?TI6A00>1PH4410@000000P000003RHV90@41TI6A00BATI400a0@4000
00000002000000>?Shn1PH40000020000003PH61T92@TI6A00BATI400h61PI2@T861P@08TI6A0_oo
o`030000oooooooo01;oool002Ooool00`000?ooooooo`02oooo00D0003oool00000003oool00P00
0005ooooM7Adoooo0000PH6100<000000oooo`000000000<M7Ad00D0003oool0003oool000000_oo
o`030000H61PM7Ad01YdM7@02P000?ooo`0000000?ooo`000?ooogAdM0000?ooo`@000000oooogAd
M7AdM00KM7Ad0_ooo`030000oooooooo02?oool02@000?ooooooooooo`000?ooo`000?ooo`000002
oooo0P000004J6QX0000oooo00000oooo`030000ooooJFUY00IYJFT023Xj>VUYJFUYJFUYJOooo`00
0?ooo`0000;oool010000?ooo`00000001QYJFT00oooo`0000000003oooo00@0001YJFUYJFUYJFT2
oooo00@0003oool00000000PJFUY0_ooo`030000oooooooo02Goool00`000?ooooooo`03oooo00D0
003oool00000003oool00P0000:ATI400oooo`0009>CT`03000000?oool0001NGUh02i6AT@0:51@D
0000oooo0000oooo0000oooo0000ooooSXj>6Y6AT@040000oooo0000oooo0P000003_;blTI6A0000
00;oool3000000>l_;bATI6ATI406i6AT@?oool00`000?ooooooo`0Toooo00D0003oooooool0003o
ool010000003oooo000000000080000019:BTP00096ATDQ8B08000000oooo`0000000002oooo00<0
0028R8RATI401i6AT@050000oooo0000ooooKFe]00;oool01000092@T8n?Soooo`8000000oooo`00
092@T00DTI6A00J?Sho>c/h00000003ooomCDe<2TI6A00>?Shooool000000P000003S8b<TI6ATI6A
00>ATI401Hn?Sng]k@0000000?ooo`04000000>GUiNATI6ATI403I6AT@;oool00`000?ooooooo`0B
oooo000Woooo0`0000;oool010000?ooo`00000000?oool01P0007AdM000000007AdM?ooo`<00000
0oooofm_KgAdM00<M7Ad00@0003oooooooooool2000000?oool`<31dM7@077AdM0<000001?ooo`00
00000?ooo`8000000oooo`0007AdM00NM7Ad0_ooo`030000oooooooo02?oool00`000?ooooooo`02
oooo00<0003oool000000P000007oooo0000ooooJFUYoooo0000oooo008000000oooo`000000000;
JFUY00F=SHgoool0003oool000000_ooo`030000ooooADE501UYJFT010000?ooo`000?ooo`800000
2?ooofUYJOooooooo`000?ooo`000?ooob5YJFT2oooo00<0003oooooool09Oooo`8000001_ooo`00
0?ooooooo`000?ooo`800003oooo00H0002ATI5aLG40002ATI7oool3000000?ooon@T92ATI402i6A
T@03oooo0000oooo00;oool00`000?oooi^KV`0MTI6A00?oool0000000000`000005oooo0000oooo
00003Ph>01nATI42oooo0P0002Koool010000?ooo`000?ooo`8000000oooo`0000000004oooo00DF
5QJATI5QHF6ATI6TY:@00`000006oooogMgM00000000ooooZZZZ296AT@03P8200000oooo00;oool2
000000GooonATI6ATI6?Shooool00P000003oooo0000TI6A01FATI401`00038b<P000?ooofi^KXZ:
R_ooo`02000000?ooon@T92ATI401i6AT@03Shn?kNg]000000@000000kfm_I6ATI6AT@0=TI6A00?o
ool0000000005?ooo`009oooo`030000oooooooo00Coool200000_ooo`80000017AdM8F5Q@0007Ad
M08000000oooo`000?ooo`0=M7Ad00<P823oool000000P000003oooo0000000001mdM7@00oooo`00
0?ooo`02oooo00@0003oool00000000PM7Ad0_ooo`030000oooooooo02?oool00`000?ooo`000004
00000_ooo`8000000oooofYZJVUYJ@02oooo0P000004oooo00000000HF5Q36UYJ@040000oooo0000
oooo0P000003oooofm_KJFUY01]YJFT00oooo`000?ooo`0200000oooo`030000oooo0000029YJFT2
oooo00<0003oooooool09Oooo`030000oooooooo00Goool200000_ooo`800000196ATIBDU000096A
T@@000000ooooi6ATI6AT@0;TI6A00>6QXKoool00000100001nATI42oooo00P0003oooooool0003o
ool0003oool0000OTI6A0oooo`030000oooooooo02Coool01@000?ooooooo`000?ooo`02000001AZ
JVX0003oooooool0003oool0002ATI40002ATI6?Shl0003oool0002b/[:>SXh0003oool0002b/[89
TI6A00OemOD000000000003oool0002=SHd00i6AT@05Shn?oooo0000oooo000001JATI400i2@T;bl
_0000003oooo00@0003oool0002=SHd;TI6A00>?Sho]kNd000000P000003ooooTI6ATI6A00fATI42
oooo00<0003oooooool04_ooo`009oooo`050000oooo00000000oooo00<000002_ooo`0000000?oo
on3Ph7AdM7=cLoooogAdM9VIV@@0000>M7Ad0`000004oooo0000ooooH61P7gAdM0030000oooo0000
00;oool2000000?ooomdM7AdM7@07gAdM0;oool00`000?ooooooo`0Soooo00<0003oooooool00P00
00?oool200000_ooo`9YJFT01Oooo`00000000000?ooo`0200003VUYJ@040000oooo0000oooo0P00
01iYJFT3000000Koool0003oool0003oool0000SJFUY0_ooo`030000oooooooo02Goool00`000?oo
ooooo`02000000Goool000000000003oool00P000007ooooPH61TI6ATI6AooooTI6AUiNG00800000
0oooo`00096AT@0=TI6A0`000003oooo0000SXj>022ATI4200000_ooo`8000000ooookbl_96AT@0O
TI6A0oooo`030000oooooooo02Coool02@000?ooo`000?ooon[ZjP000?Ogm`000?ooo`02000000Go
oomIFEV<S8bATI7oool00Y6AT@09Ng]k00000000Shn?TI6AZJVY0000f][JT92@00VATI401Xf=S@00
00000?ooo`000:n_[`FATI4018n?Soooo`00092@T1NATI400hn?Soooo`000002oooo0P000003T92@
TI6ATI6A00bATI4018f=SOooooooohR8R0nATI42oooo00<0003oooooool04_ooo`007Oooo`800004
oooo00D0003oooooooooool000000oooo`050000oooooooooooo000000;oool01@0007IfMWAdM7Ad
M0000002M7Ad00ASHf?oool0001GEeL?M7Ad0_ooo`030000oooooooo029dM7@01Oooo`0000000?oo
o`00000RM7Ad0_ooo`030000oooooooo01Soool200001?ooo`030000oooooooo00;oool020000?oo
o`0000000?ooo`000?ooo`0000;oool010000?ooofUYJFUYJ@8000001F][Joooo`000?ooo`00000>
JFUY0P000004oooo0000ooookNg]7fUYJ@07oooo0000oooooooo0000oooo000002AYJFT2oooo00<0
003oooooool06oooo`800004oooo00D0003oooooooooool000001?ooo`050000oooooooooooo0000
00;oool01@00096ATI6ATI6AT@000002TI6A00B?Shooool0002=SHd?TI6A0_ooo`030000cLg=TI6A
02:ATI42000000?oool0002l_;`08I6AT@?oool00`000?ooooooo`0Ioooo0P0000Coool00`000?oo
ooooo`02oooo00T0003ooooooonFUYJ=SHf[Zj^BTY:VYZH000000_ooo`05PH61TI6ATI6ATI6AS8b<
00>ATI400oooohb<S96AT@0?TI6A00BMWIgemOD0002UYJDSTI6A00GGemL0001iNGWooon6QXH08Y6A
T@;oool00`000?ooooooo`0Boooo000Moooo00<0003oool000000_ooo`030000oooo000000;oool0
0`000?oooj2PX002X:2P00<P821dM7AdM7@0JgAdM0;oool00`000?ooooooo`0Hoooo00<0003oool0
00000_ooo`030000oooo000000?oool020000?ooooooonWYj@000?oooc<c<oooo`8000002?ooo`00
06UYJFUYJGinO_ooofUYJ@0000;oool00f5QHFUYJFUYJ@0<JFUY00D0003oool0003ooooHf=P08FUY
J@@000000oooofUYJFUYJ@0SJFUY0_ooo`030000oooooooo01_oool00`000?ooo`000002oooo00<0
003oool000000_ooo`030000oooooooo00>HV9P00i2@T96ATI6AT@1ZTI6A0oooo`030000oooooooo
01Woool00`000?ooo`000002oooo00<0003oool000000oooo`030000ooooTI6A072ATI42oooo00<0
003oooooool04_ooo`007Oooo`030000oooo000000;oool00`000?ooo`000002oooo0P0000>PX:00
0b0P87AdM7AdM01[M7Ad0_ooo`030000oooooooo01Soool00`000?ooo`000002oooo00<0003oool0
00000oooo`030000oooo][Jf00:f][H00b0P86UYJFUYJ@1[JFUY00?oool0000000007Oooo`030000
oooo000000;oool00`000?ooo`000002oooo0P000005ooooV9RHV9RHV9RHT92@06bATI42oooo0P00
01_oool00`000?ooo`000002oooo00<0003oool000000oooo`030000ooooTI6A072ATI400oooo`00
0000000Doooo000Moooo0P0000?oool00`000?ooo`000002oooo00<0003ooonPX:000Z2PX003820P
M7AdM7Ad06]dM7@2oooo00<0003oooooool06?ooo`800003oooo00<0003oool000000oooo`030000
oooo][Jf00:f][H00b0P86UYJFUYJ@1[JFUY0_ooo`030000oooooooo01_oool200000oooo`030000
oooo000000;oool00`000?ooooooo`03V9RH00>@T92ATI6ATI40JY6AT@?oool00`000?ooooooo`0I
oooo0P0000?oool00`000?ooo`000003oooo00<0003ooonATI40L96AT@;oool00`000?ooooooo`0B
oooo000Moooo00<0003oooooool00_ooo`030000oooo000000;oool00`000?oooj2PX002X:2P00<P
821dM7AdM7@0JgAdM0;oool00`000?ooooooo`0Hoooo00<0003oooooool00_ooo`030000oooo0000
00?oool00`000?oookJf]P02][Jf00<P821YJFUYJFT0JfUYJ@;oool00`000?ooooooo`0Koooo00<0
003oooooool00_ooo`030000oooo000000;oool00`000?ooooooo`03V9RH00>@T92ATI6ATI40JY6A
T@?oool00`000?ooooooo`0Ioooo00<0003oooooool00_ooo`030000oooo000000?oool00`000?oo
oi6AT@1`TI6A0_ooo`030000oooooooo01;oool001koool200000oooo`060000oooooooooooo0000
oooo0j2PX003820PM7AdM7Ad06]dM7@2oooo00<0003oooooool06Oooo`800003oooo00<0003ooooo
ool00_ooo`030000oooo][Jf00:f][H00b0P86UYJFUYJ@1[JFUY0_ooo`030000oooooooo01coool2
00000oooo`050000oooooooooooo000000;oool3V9RH00>@T92ATI6ATI40JY6AT@?oool00`000?oo
ooooo`0Joooo0P0000?oool00`000?ooooooo`02oooo00<0003ooonATI40L96AT@;oool00`000?oo
ooooo`0Boooo000Woooo0P0000>CTi<00a0@47AdM7AdM01[M7Ad0_ooo`030000oooooooo02?oool0
0`000?oooinOW`02WinO00<92@UYJFUYJFT0JfUYJ@;oool00`000?ooooooo`0Uoooo0P000005oooo
UYJFUYJFUYJFT92@06bATI42oooo0P0002Koool00`000?oooi6AT@1`TI6A00?oool0000000005?oo
o`009oooo`030000ooooTi>C00:CTi<00a0@47AdM7AdM01[M7Ad0_ooo`030000oooooooo02?oool0
0`000?oooinOW`02WinO00<92@UYJFUYJFT0JfUYJ@;oool00`000?ooooooo`0Uoooo00<0003ooooo
ool00iJFUP03T92@TI6ATI6A06ZATI43oooo00<0003oooooool09?ooo`030000ooooTI6A072ATI42
oooo00<0003oooooool04_ooo`009oooo`030000ooooTi>C00:CTi<00a0@47AdM7AdM01[M7Ad0_oo
o`030000oooooooo02?oool00`000?oooinOW`02WinO00<92@UYJFUYJFT0JfUYJ@;oool00`000?oo
ooooo`0Uoooo00<0003oooooool00iJFUP03T92@TI6ATI6A06ZATI43oooo00<0003oooooool09?oo
o`030000ooooTI6A072ATI42oooo00<0003oooooool04_ooo`009oooo`030000ooooTi>C00:CTi<0
0a0@47AdM7AdM01[M7Ad0_ooo`030000oooooooo02?oool00`000?oooinOW`02WinO00<92@UYJFUY
JFT0JfUYJ@;oool00`000?ooooooo`0Uoooo00<0003oooooool00iJFUP03T92@TI6ATI6A06ZATI43
oooo00<0003oooooool09?ooo`030000ooooTI6A072ATI42oooo00<0003oooooool04_ooo`009ooo
o`800003Ti>C00<@411dM7AdM7@0JgAdM0;oool00`000?ooooooo`0Soooo00<0003ooonOWil00YnO
W`032@T9JFUYJFUY06]YJFT2oooo00<0003oooooool09Oooo`8000001OoooiJFUYJFUYJFUY2@T01/
TI6A0_ooo`80000Voooo00<0003ooonATI40L96AT@03oooo0000000001Coool002Ooool00`000?oo
oi>CT`02Ti>C00<@411dM7AdM7@0JgAdM0;oool00`000?ooooooo`0Soooo00<0003ooonOWil00YnO
W`032@T9JFUYJFUY06]YJFT2oooo00<0003oooooool09Oooo`030000oooooooo00>FUYH00i2@T96A
TI6AT@1ZTI6A0oooo`030000oooooooo02Coool00`000?oooi6AT@1`TI6A0_ooo`030000oooooooo
01;oool002Ooool00`000?oooi>CT`02Ti>C00<@411dM7AdM7@0JgAdM0;oool00`000?ooooooo`0S
oooo00<0003ooonOWil00YnOW`032@T9JFUYJFUY06]YJFT2oooo00<0003oooooool09Oooo`030000
oooooooo00>FUYH00i2@T96ATI6AT@1ZTI6A0oooo`030000oooooooo02Coool010000?ooohV9RInO
W`80000015=CDoooogEeMJVYZ@>ATI401H61P@00000000000:BTY00:TI6A00H0003oool];Bgoool0
002HV9PLTI6A00<0003ooolb<S80<Y6AT@;oool00`000?ooooooo`0Boooo000Woooo00<0003ooonC
Ti<00Y>CT`03410@M7AdM7Ad06]dM7@2oooo00<0003oooooool08oooo`030000ooooWinO00:OWil0
0`T92FUYJFUYJ@1[JFUY0_ooo`030000oooooooo02Goool00`000?ooooooo`03UYJF00>@T92ATI6A
TI40JY6AT@?oool00`000?ooooooo`0Toooo00X0003ooon9RHUjNW[ooon8R8SalO7ooong]kNYZJT4
TI6A0`000003a/K6TI6ATI6A00VATI44000000?gmoNATI6ATI405Y6AT@05T92@TI6ATI6A0000oooo
008000000h61PI6ATI6AT@0_TI6A0_ooo`030000oooooooo01;oool002Ooool00`000?oooi>CT`02
Ti>C00<@411dM7AdM7@0JgAdM0;oool00`000?ooooooo`0Soooo00<0003ooonOWil00YnOW`032@T9
JFUYJFUY06]YJFT2oooo00<0003oooooool09Oooo`030000oooooooo00>FUYH00i2@T96ATI6AT@1Z
TI6A0oooo`030000oooooooo02Coool02P000?oookNg]j2PX?oooi2@T5MGE`0003@d=1hN7P>ATI40
1A0@4?ooooooooooo`00000:TI6A00L0003oool00000003oool0002?Shl06Y6AT@030000oooooooo
0080000aTI6A0_ooo`030000oooooooo01;oool002Ooool200000i>CT`03410@M7AdM7Ad06]dM7@2
oooo00<0003oooooool08oooo`030000ooooWinO00:OWil00`T92FUYJFUYJ@1[JFUY0_ooo`030000
oooooooo02Goool2000000GooonFUYJFUYJFUYJ@T900K96AT@;oool200009_ooo`0:0000oooo]kNg
[Zj^OWin000061PH00007AdM71`L0i6AT@060000oooooooooooo4A4ARXZ:2I6AT@040000oooo0000
oooo0P000003kNg]TI6ATI6A01FATI401I2@T96ATI6ATJ^[Z`000002oooo00<0002[Zj^ATI40;i6A
T@03oooo0000000001Coool002Ooool00`000?ooo`000003000000Goool000000000003oool01@00
009dM7@5000000APH60000000000000;M7Ad1@0000MdM7@200006gAdM0030000oooo00000080000@
M7Ad00@0001dM7AdM7@0000;M7Ad0_ooo`030000oooooooo02?oool01@000?ooo`00000009nOW`03
00000VUYJ@0;0000JFUYJFUYJFUYJ6QX0000JFUY@D510000JFUY0000011YJFT0100006UYJ@000000
029YJFT00`0006UYJ@00000UJFUY0_ooo`030000oooooooo02Goool00`000?ooooooo`04000000Go
ool000000000003oool01@0000:ATI400`l?3`0000000002000000B0P80000000000000;TI6A1000
00NATI400`00096AT@00000JTI6A00<0003oool000000P00012ATI401000096ATI6AT@0000^ATI43
oooo00<0003oooooool09?ooo`030000oooo000000<000001LK6aW]kN`0000000?ooo`04000000@M
7Ad00000002@T903000000>1PH6ATI4@41000P0000:ATI400`000820P0000003000000B1PH6ATI6A
TI68R8P4000000>0P82ATI6ATI40196AT@80000:TI6A00>1PH40000000000`000003PH61TI6ATI6A
00RATI400`000?ooo`000002000000>1PH6ATI6ATI403I6AT@04410@TI6ATI6A00002i6AT@;oool0
0`000?ooooooo`0Boooo000Noooo00<0003oooooool00_ooo`060000oooooooooooo0000oooo0P00
0004oooo00000000oooo1P0000;oool2M7Ad00Coool0000000000002oooo00@0003oooooool0000:
M7Ad00H0003oool00000003oool00004M7Ad00Goool00000003oool000006GAdM0050000oooo0000
oooo000000?oool00`0007AdM7AdM009M7Ad0P000004oooo0000oooo00002gAdM0;oool00`000?oo
ooooo`0Ioooo00<0003oooooool00_ooo`030000oooooooo00;oool01@000?ooo`0000000?ooo`02
00000_ooo`8000001_ooo`00000006IVI_ooofUYJ@;oool3000000EYJFWoool00000003oool02FUY
J@030000oooo0000008000000oooofUYJFUYJ@04JFUY00?oool00000000066UYJ@06oooo0000oooo
0000oooo00004FUYJ@030000oooo000000iYJFT2oooo00<0003oooooool07?ooo`030000oooooooo
00;oool01@000?ooooooooooo`000002oooo0P000004oooo00000000oooo1P0000;oool2TI6A00Co
ool0000000000002oooo00<0003oool000002i6AT@060000oooo0000oooo0000oooo196AT@050000
oooo0000oooo000001RATI400`000?ooo`000002oooo00@0003oooooool0000;TI6A0P000005oooo
0000oooooooo000000ZATI43oooo00<0003oooooool06_ooo`030000oooooooo00;oool00`000?oo
ooooo`02oooo00D0003oool00000003oool00P000003j^[Z0000000000H00002oooo10000003oooo
Xj>S000000;oool01CTi>I2@T5UIFI6ATJ^[Z`02000000Koool0002ATI6ATI40003oool2000000?o
ool0002ATI400i6AT@05Vi^K00000000oooo000000^ATI400j^[Z`000?ooo`02000000>[Zj^ATI6A
TI401Y6AT@050000oooo0000oooo000000?oool00c8b<Y6ATI6AT@09TI6A0P000004oooo0000oooo
00002i6AT@;oool00`000?ooooooo`0Boooo000Moooo00<0003oool000000_ooo`030000oooo0000
00;oool01@000?ooo`000?ooo`000002oooo0P0000Coool00`000?ooo`000002M7Ad00@0003oool0
003oool2000000Coool0003oool0000:M7Ad00?oool0003oool00_ooo`8000001oooogAdM?ooo`00
0?ooo`000?ooo`02000067AdM009oooo0000oooo0000oooo0000oooo0000oooo00800007M7Ad0P00
0004oooo0000oooooooo0P000003ooooM7AdM7Ad00QdM7@2oooo00<0003oooooool06?ooo`030000
oooo000000;oool00`000?ooo`000003oooo00D0003oool0003oool000000_ooo`800002oooo00H0
003oool0001PH600001YJFT2000000?oool0003oool00P0000;oool00`000?ooofUYJ@07JFUY00Oo
ool0003oool0003oool0003oool016UYJ@03oooo0000oooo0080000GJFUY1@000003oooo0000oooo
00eYJFT2000000Coool00000003oool=JFUY0_ooo`030000oooooooo01_oool00`000?ooo`000002
oooo00<0003oool000000_ooo`060000oooooooo0000oooo00000_ooo`800004oooo00<0003oool0
00000Y6AT@04HF5Q0000oooooooo0P000004oooo00000000h^;R2Y6AT@03oooo0000oooo00;oool2
000000GooonATI40003oool000000_ooo`80000GTI6A00Coool0003ooonATI42000000Koool0003o
ool0003oool00007TI6A00<0003oool000000_ooo`<0000:TI6A0oooo`030000oooooooo01Woool0
0`000?ooo`000002oooo00<0003oool000000oooo`0:0000oooo0000oooo0000H61Poooo8B4Q0000
=3@d0oooo`<00002oooo00@@413Xj>P0003oool2000000[oool0003oool:2PZ@T900002ATI6@T900
003oool200000Y6AT@03[Zj^0000oooo00;oool02`0000L71iRHV96ATI^KV`000?ooo`000?ooo`00
08J6QP0;TI6A00<0003oooooool00P000003Zj^[TI6ATI6A00FATI402no_k`000>o_ka4A4Oooo`00
0?ooo`000?ooo`00038b<P07TI6A0P000007oooo0000oooooooo>3Ph0000oooo00ZATI42oooo00<0
003oooooool04_ooo`007Oooo`030000oooo000000;oool00`000?ooo`000002oooo0P000008oooo
000000000000oooo0000oooo00000oooo`030000ooooM7Ad00=dM7@017=cLoooo`000?ooo`800002
oooo0P0000YdM7@00g9bLWAdM?ooo`02000000Goool0003oool0003oool010000003ooooM7AdM7Ad
01MdM7@00gIfMWAdM7AdM002M7Ad00<0003oooooool010000004ooooM7AdM7Ad00000_ooo`800000
1_ooo`000?ooogAdM?ooo`0000YdM7@2oooo00<0003oooooool06?ooo`030000oooo000000;oool0
0`000?ooo`000003oooo00D0003oool0003oool000000oooo`@000001Oooo`000=cLg?ooofUYJ@02
oooo0`000003oooo0000000000;oool00`0006UYJFUYJ@06JFUY00H0003oooooooooool0003oool2
00000VUYJ@8000001?ooo`0000000?oooaMYJFT2oooo00@0003oooooooooool2000000?oool0001Y
JFT026UYJ@030000oooooooo00800002oooo00<0001YJFUYJFT02fUYJ@03oooo0000000001goool0
0`000?ooo`000002oooo00<0003oool000000_ooo`800002oooo0`000004oooo0000oooo00000ooo
o`030000ooooTI6A00BATI400oooo`000?ooo`02000000?oool00013@d<03I6AT@060000oooo0000
oooo0000oooo0P000005oooo000000000000oooo01RATI400i:BTY6ATI6AT@02TI6A00<0003ooooo
ool00P000003oooo0000oooo00:ATI400`000?ooooooo`02000000Koool0003ooonATI7oool0000:
TI6A0_ooo`80000Koooo00<0003oool000000_ooo`030000oooo000000?oool02P000?ooooooo`00
04=3@`000:NWY`000?ooo`0000?oool00cLg=n?Shoooo`03000000Ba/K6CTi<0003oool200000_oo
o`03Q8B4T92@/K6a00:ATI401J^[Z`000000000008n?S`04TI6A00ZCTi<F5QH0003oool0002TY:@0
003oool0002:RXX2000000>KVi^ATI6ATI402I6AT@04PH610000oooooooo0P000003Zj^[TI6ATI6A
00ZATI400`000?ooooooo`04000000B[Zj^ATI6ATI4H61P2oooo0P000006oooo0000UYJFTI6Aoooo
10@42Y6AT@03oooo0000000001Coool001koool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oooooool00_ooo`<000000oooo`0000000004000000CooomdM7AdM7Coool2000000?oool0003o
ool00_ooo`030000ooooM7Ad00UdM7@01@000?ooo`0000000?ooo`02000000Coool0003oooooool3
000000?oool0001dM7@05gAdM08000000oooogAdM7AdM003M7Ad00T0003oooooool0003oool0003o
ool0003oool00P000003oooo0000M7Ad00=dM7@00`000?ooooooo`09M7Ad0_ooo`030000oooooooo
01Woool01`000?ooooooooooo`000?ooo`000003oooo00D0003oool0003oool000000oooo`030000
oooo0000008000001oooo`00000006UYJDE5A@000?ooo`0300000_ooo`030000oooooooo00QYJFT0
1?ooo`000000000000?oool400000oooo`80000GJFUY0P000003ooooJFUYJFUY00@000001?ooo`00
00000?ooo`AYJFT2000000Soool00000003oool0003oool0003oool=JFUY0_ooo`030000oooooooo
01coool01`000?ooooooooooo`000?ooo`000002oooo00<0003oooooool00oooo`<000000oooo`00
00000002000000?oool0003oool00Y6AT@05oooo00000000oooo000000?oool00`000?oooi6AT@09
TI6A00X0003oool0002l_;`0003oool0003oool0003oool2000000Coool0003oool0000GTI6A0P00
0003ooooTI6ATI6A00>ATI4010000?ooooooooooo`8000001Oooo`000?ooo`000?ooo`020000196A
T@03oooo0000oooo00VATI43oooo00<0003oooooool06_ooo`070000oooooooooooo0000oooo0000
00?oool00`000?ooooooo`02oooo0`000003oooo0000000000<000000kBd]00000000004000000?o
ool0003oool00_ooo`040000ooooT92@UIFE0Y6AT@0?T92@0000oooo0000kNg]TI6A0000oooo0000
QXJ6TI6A=cLg0000oooo000000;oool01E9BDX^;R`000?ooogYjNP0<TI6A00B[Zj/0003oooooool2
000000>[Zj^ATI6ATI400i6AT@8000000ooooi6ATI6AT@03TI6A00UgMgOoooooool0003oool0003o
ool0003oool00P000003ooooO7alTI6A00>ATI400`000>o_kj^[Z`09TI6A0_ooo`030000oooooooo
01;oool001goool00`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo00;oool2
00000oooo`030000oooooooo00<00002M7Ad00H0003oool00000003oool00002oooo00<0003ooomd
M7@02GAdM006oooo0000ooooooooM7Ad00000_ooo`050000oooo0000oooo000000;oool00`0007Ad
M7AdM00FM7Ad0_ooo`030000M7AdM7Ad00EdM7@01P000?ooo`0000000?ooo`0000;oool00`0007Ad
M7AdM004M7Ad00<0003oool000002GAdM0;oool00`000?ooooooo`0Hoooo00<0003oool000000_oo
o`030000oooo000000?oool00`000?ooo`000003000000?oool0003oool00oooo`8000002?ooo`00
06UYJOooo`000?ooo`000?ooo`800002oooo0P0000QYJFT010000?ooo`000?ooo`8000000oooo`00
00000002000000Goool0003oool0003oool05VUYJ@030000oooo000000AYJFT01@000?oooooooooo
o`000002oooo00H0001YJFT00000003oool00002oooo00<0001YJFUYJFT00`000003ooooJFUYJFUY
00YYJFT2oooo00<0003oooooool06oooo`030000oooo000000;oool00`000?ooo`000002oooo00<0
003oooooool00oooo`800003oooo00@0003oool0003oool200000Y6AT@06@D510000oooo0000oooo
00000_ooo`030000ooooTI6A00VATI400oooo`000?ooo`02TI6A00<0003oooooool00P000003oooo
TI6A000000;oool00`00096ATI6AT@0ETI6A0_ooo`030000TI6ATI6A00JATI43000000Goool0003o
ooooool000001Y6AT@030000oooo000000VATI43oooo00<0003oooooool06Oooo`030000oooo0000
00;oool00`000?ooo`000003oooo00<0003oooooool00_ooo`800003oooo00L30`?oooooool0000b
<S;ooomIFET00_ooo`05@d=30000EEEEoooo000000;oool010000?oooi2@T92@T0>ATI402j^[Z`00
0000000008n?Sl71`@000;no_i:BTY6ATA0@4002oooo00D0003oool0002KVi/@41000_ooo`030000
TI6ATI6A00^ATI401:^[Z`000?ooooooo`8000000h61PI6ATI6AT@02TI6A0_ooo`03O7alTI6ATI6A
00FATI401P000?oooc8b<P000?ooo`0000;oool00`00096ATI6AT@04TI6A00=gMgOoool000002I6A
T@;oool00`000?ooooooo`0Boooo000Noooo00<0003oooooool00_ooo`060000oooooooooooo0000
oooo10000005oooo00000000LG5aoooo00<000000oooogAdM7AdM002M7Ad00EcLg=`L73oool0003o
ool00P000003oooo0000M7Ad00YdM7@00gIfMWAdM7AdM002M7Ad0P000003oooo0000oooo009dM7@0
0`000?ooo`00000HM7Ad00=bLW9dM7AdM7@02GAdM0060000oooo0000oooo0000oooo1gAdM0030000
oooo000000UdM7@2oooo00<0003oooooool06Oooo`030000oooooooo00;oool00`000?ooooooo`02
oooo00<0003oool0000010000003oooo0000000000?oool2000000OooomYJFT0003oool0003oool0
00000_ooo`040000oooo0000oooo26UYJ@06oooo0000oooo0000JFUYoooo0P000004oooo0000oooo
00000_ooo`80000FJFUY00?oool0003oool01fUYJ@070000oooo0000oooo0000IFEUoooo00800000
0oooo`000?ooo`04JFUY00<0003oool0000036UYJ@;oool00`000?ooooooo`0Loooo00<0003ooooo
ool00_ooo`050000oooooooooooo000000;oool4000000Goool00000002ATI7oool00`000003oooo
TI6ATI6A00:ATI401I2@T96ATOooo`000?ooo`03000000?ooonATI6ATI402I6AT@03TY:BTI6ATI6A
00:ATI42000000Soool0002ATI6ATI7oool0003oool0000STI6A00H0003oool0003oool0003oool8
TI6A0P0000VATI43oooo00<0003oooooool06_ooo`030000oooooooo00;oool00`000?ooooooo`02
oooo00<0003oool000000P0000Goool01b0P800000000000075aLOooo`000002oooo00TA4A60P82B
TY80003ooon8R8P0003oool000001I6AT@05T92@000000000000kNg]00JATI401H^;RaDE5N_[j`00
09VIV@02TI6A00<0003oool000003Y6AT@04Zj^[0000oooooooo0P00012ATI401WMgMooooh^;Rj^[
Z`0009JFUPNATI400`000?ooo`000009TI6A0_ooo`030000oooooooo01;oool002Ooool00`000?oo
o`000003000000?oool0000000001@000004oooo0000M7AdM7Ad0`0000=dM7@010@4100000000000
00UdM7@400002GAdM0D0000FM7Ad0`0001QdM7@3000027AdM0;oool00`000?ooooooo`0Soooo00@0
003oool0003oool2000000Ooool00000001RHV9ZJVX0003oool00`00009YJFT01`00071`L00006UY
J@0006UYJOooo`03000026UYJ@030000IVIV000000AYJFT2000000AYJFT0001YJFUYJFT400005FUY
J@030000KFe]000000YYJFT2000000AXJ6P0001YJFT00008JFUY0`0000]YJFT2oooo00<0003ooooo
ool09Oooo`030000oooooooo00@000000oooo`0000000005000000Coool0002ATI6ATI4300000i6A
T@04T92@00000000oooo2I6AT@@00009TI6A1@0001FATI430000696AT@<00008TI6A0oooo`030000
oooooooo02Coool00`000?ooof][J`03000000?oool0000000000P00000620P8410@0000P8200000
TI6A100000BATI4010P8200000000820P0FATI400h20P00000000003000000=bLW:ATI6ATI401i6A
T@05PH6130`<00000000PX:200jATI401861P@0000000?ooo`8000001H61PI6ATAPH600001PH600G
TI6A00B1PH400000000410@8TI6A0_ooo`030000oooooooo01;oool002Ooool300000_ooo`800002
oooo0P0000?oool01@000?ooogAdM7AdM?ooo`02000017AdM004oooo0000oooo000027AdM004oooo
0000oooo00002WAdM004oooo0000oooo00005WAdM0030000oooo000001QdM7@01?ooo`000?oooooo
o`MdM7@2oooo00<0003oooooool08oooo`030000oooo000000;oool300000_ooo`0;0000oooooooo
0000oooo0000JFUYoooo0000oooo000000=YJFT3oooo00<0001YJFUYJFT01VUYJ@040000oooo0000
00002VUYJ@030000oooo000001EYJFT2000000?ooomYJFUYJFT05VUYJ@03oooo0000JFUY00]YJFT2
oooo00<0003oooooool09Oooo`8000001?ooo`000?ooooooo`800002oooo0P0000?oool01`000?oo
oi6ATI6ATOWin@000;2`/004TI6A00?oool0000000002I6AT@04_;bl0000oooo00002Y6AT@04oooo
0000oooo00005I6AT@030000oooo000001VATI400`000?ooooooo`07TI6A0_ooo`80000Voooo00<0
003ooomcLg<00_ooo`04FEUI0000Vi^Koooo0P000007Y:BTVi^KooooCdm?0000T92@FEUI00;oool0
0`00096ATI6AT@02TI6A00CKfm]OGeoooolA4A46TI6A0P000004oooo0000`L71RXZ:2Y6AT@04oooo
0000ooooNWYj496AT@03Zj^[0000oooo008000001:^[ZgMgMoooogMgMaRATI401?ooo`000>o_kj^[
Z`NATI400oooo`000000000Doooo000Woooo00<0003oool000000oooo`090000ooooooooL71`NGUi
M7Ad0000oooo000000AdM7@00g9bLW1`L7AdM003M7Ad00@0003oooooool00009M7Ad00=cLg=gMgMd
M7@02WAdM0040000oooooooo00005gAdM003MWIfM7AdM7Ad01MdM7@010000?ooooooo`0000MdM7@2
oooo00<0003oooooool08oooo`030000oooooooo00<000001Oooo`00000000000?ooo`04000000Co
oomYJFT0003oool200000fUYJ@04oooo00000000oooo26UYJ@04oooo0000oooooooo2VUYJ@800000
0oooofUYJFUYJ@0CJFUY0_ooo`030000JFUYJFUY01IYJFT300002fUYJ@;oool00`000?ooooooo`0U
oooo00@0003oooooool00003oooo00T0003ooooooonATI6BTY:ATI40003oool00000196AT@03T92@
TI6ATI6A00>ATI400`000?ooo`00000;TI6A00>BTY:ATI6ATI402I6AT@040000oooooooo00005Y6A
T@03TY:BTI6ATI6A01NATI4010000?ooooooo`0000NATI43oooo00<0003oooooool09?ooo`030000
oooo[Zj^00;oool01820P00006][JmKFeP8000001ijNWUYJF_ooo``<3000096AT@000002oooo00<0
002ATI6ATI400Y6AT@04DE5Aoooooooo00001Y6AT@050000oooo00000000kNg]00^ATI4015ADE?oo
ooooo`00016ATI400j^[Z`000?ooo`02000000>[Zj^ATI6ATI40696AT@04MgMgoooooooo00001i6A
T@;oool00`000?ooooooo`0Boooo000Woooo00<0003oool000000`000003oooo0000oooo00800002
oooo00<0003oooooool00WAdM003oooo0000000000AdM7@00oooo`0000000009M7Ad00Coool00000
003oool:M7Ad00Coool00000003ooolEM7Ad0`000003ooooM7AdM7Ad01MdM7@2000000?ooomdM7Ad
M7@01GAdM0;oool00`000?ooooooo`0Soooo00<0003oooooool00`000005oooo0000ooooI6ATJVYZ
00<000001_ooofUYJFUYJFUYJFMWIg5aL@AYJFT01?ooo`000000000000UYJFT00fe]KFUYJFUYJ@0:
JFUY00<0003oool000005FUYJ@03IFEUJVYZJFUY01UYJFT200002fUYJ@;oool00`000?ooooooo`0U
oooo00<0003oooooool00_ooo`8000000oooo`000?ooo`02000000?oool0000000000_ooo`:ATI40
1Oooo`000?ooo`000?ooo`02000000?oool0003oool02I6AT@03oooo0000000000BATI4020000?oo
o`000?ooo`000?ooo`000?ooo`80000FTI6A0P000003ooooTI6ATI6A00VATI400oooo`000?ooo`04
TI6A00<0003oool00000196AT@8000000ooooi6ATI6AT@05TI6A0oooo`030000oooooooo02Coool0
2@000?ooo`000451@G1`L0000?ooohf=SOooo`02000000OooonCTi<d=3BEUIGooonATI6a/K400`00
00BATI400i>CTbLW9a`L7007TI6A00J1PH400000003oool0003oool:TI6A00BCTi<F5QH820RGUiLB
TI6A00<0003oooooool00`000003ooooTI6ATI6A01NATI400aPH60P829JFUP07TI6A0_ooo`030000
oooooooo01;oool002Ooool01@000?ooooooooooo`000003oooo00d0003oooooool0001dM7AXJ6Qd
M7@0001dM7APH600003oool000001GAdM003MWIfL71`M7Ad00MdM7@01Oooo`0000000?ooo`00000;
M7Ad00=eMGEaLG5dM7@057AdM0050000oooo0000oooo000001YdM7@00g9bLWAdM7AdM006M7Ad0_oo
o`030000oooooooo02?oool00`000?ooo`000002oooo0`0000;oool0200003De=Oooo`00071`L000
06UYJOooo`800004JFUY00@0003oooooool00008JFUY00<0003oool000002fUYJ@8000000oooofUY
JFUYJ@0BJFUY00<0003oool000006VUYJ@03oooo0000JFUY00YYJFT2oooo00<0003oooooool09Ooo
o`030000oooooooo008000001Oooo`00000000000?ooo`04000000GooonATI40002ATI6>SXh00P00
00;oool010000?ooooooo`0000ZATI401?ooo`000?ooo`0000BATI401oooo`000?ooo`000?ooo`00
0?ooo`0HTI6A00@0003oool00000000;TI6A00<0003oool00000196AT@03oooo0000oooo00jATI43
oooo00<0003oooooool09?ooo`090000oooooooo]kNgQXJ6iNGUVYZJb<S8000000;oool01alO7i6A
TI6ATI6ATGAdM96ATIFEU@02000000</;2bATI6ATI40396AT@06T92@0000oooo0000ooooADE5896A
T@07PH610000oooooooo0000ooooO7al02>ATI42oooo00<0003oooooool04_ooo`009oooo`<00002
oooo00@0003oool000000002oooo00<0001dM7AXJ6P00P000005M7Adoooo0000oooo000000EdM7@0
0gIfMW1`L7AdM007M7Ad00<0003oool000000_ooo`]dM7@00gEeMG5aLGAdM00BM7Ad0P000004oooo
0000oooo00006gAdM003LW9bM7AdM7Ad00IdM7@2oooo00<0003oooooool08oooo`080000oooooooo
oooo0000oooo0000oooo0P000004oooo0000JFUYJ6QX0_ooo`04JFUY0000oooooooo1FUYJ@03Jf][
HF5QJFUY00MYJFT010000?ooo`000?ooo`]YJFT00fQXJ6EUIFUYJ@0EJFUY00<0003ooomYJFT09VUY
J@;oool00`000?ooooooo`0Uoooo0P000006oooo0000oooooooo0000oooo0P0000;oool03000092@
T92@T6a/K000096ATOooo`000?ooo`00096ATI:BTP:ATI400i:BTY6ATI6AT@07TI6A00Goool0003o
ool0003oool02I6AT@03TY:BTI6ATI6A01FATI43000000?oool0002ATI404i6AT@03TY:BTI6ATI6A
00fATI42oooo0P0002Koool020000?ooo`000820P?ooo`0009BDU00000;oool02`000<30`96ATI6A
TI2@T000096ATJNWY`000?ooo`00000?TI6A00D0003oool0003ooonCTi<0896AT@8000001?ooo`00
0?ooogMgMbBATI400oooo`000000000Doooo000Woooo00L0003oooooool0003oool0003oool00`00
00;oool01WAdM6QXJ?ooo`000?ooo`0000;oool00`0007AdM7AdM003M7Ad00=fMWI`L71dM7@01WAd
M0040000oooo0000oooo0P0000]dM7@00gEeMG5aLGAdM00@M7Ad00@0003oool000000002oooo00<0
003ooomdM7@06WAdM003LW9bM7AdM7Ad00IdM7@2oooo00<0003oooooool08oooo`070000oooo0000
0000oooo0000oooo008000002Oooo`000?ooofUYJFQXJ?ooo`000?ooo`000002oooo00<0001YJFUY
JFT00VUYJ@03Jf][HF5QJFUY00MYJFT010000?ooooooo`0000]YJFT00fQXJ6EUIFUYJ@0BJFUY00D0
003oool0003oool000009fUYJ@;oool00`000?ooooooo`0Uoooo00<0003oooooool00P000003oooo
0000000000<000000oooo`0000000002oooo00D0002m_Kd0003oool000000_ooo`040000oooooooo
0000296AT@8000001Oooo`000?ooo`0000410@03TI6A00Ooool0003oool0003oool0003oool04i6A
T@080000oooo0000oooo0000oooo0000oooo396AT@030000oooo000000BATI400oooo`000?ooo`0>
TI6A0oooo`030000oooooooo02Coool01`000?ooooooohj>S_ooo`000:6QX@03000000_ooon@T92A
TI6ATI6IVIT0002ATI40003ooomkNg^1PH403Y6AT@050000oooo0000ooooLg=c01nATI4011PH6?oo
o`00000000;oool00galO96ATI6AT@0STI6A0_ooo`030000oooooooo01;oool002Ooool00`000?oo
o`000008000000>0P81dM7AXJ6P01`0000EdM7@00gIfMW1`L7AdM004M7Ad10000003oooo0000M7Ad
00adM7@00gEeMG5aLGAdM00<M7Ad10000005oooo00000000M7Ad000001idM7@00g9bLWAdM7AdM006
M7Ad0_ooo`030000oooooooo02?oool00`000?ooo`000004000000Ooool000000000001oOgmYJFU8
B4P01`0000AYJFT00f][Jf5QHFUYJ@05JFUY10000003ooooJFUYJFUY00YYJFT00fQXJ6EUIFUYJ@0>
JFUY10000004oooo000000000000:6UYJ@;oool00`000?ooooooo`0Uoooo00D0003oooooool0003o
ool01`000003Ti>C0000000000H000000i6AT@00096AT@02000000FATI40002ATI6ATI6@T9000i6A
T@8000001?ooo`000?ooo`0000FATI401`00096AT@00096AT@00096AT@00000@TI6A0`000006oooo
000000000000TI6A00003i6AT@030000TI6ATI6A00>ATI400`00096AT@00000>TI6A0oooo`030000
oooooooo02Coool010000?ooo`0008b<S0<0000018:2PP00000000d=3@>ATI46000000>1PH6ATI6A
TI402Y6AT@060@41000000000000U9BDPH61796AT@8000000aPH60000?ooo`02000000>ATI4@412A
TI409Y6AT@;oool00`000?ooooooo`0Boooo000Woooo00@0003oool0003oool300000oooo`030000
M7AdM7Ad008000000oooo`0000000002oooo1WAdM004MWIfL71`M7Adoooo0WAdM0@000000oooogAd
M7AdM00=M7Ad00=eMGEaLG5dM7@02WAdM08000001_ooo`000?ooooooo`000?ooob5dM7@00g9bLWAd
M7AdM006M7Ad0_ooo`030000oooooooo02?oool010000?ooo`000?ooo`<00003oooo00H0001YJFUY
JFTT92@0003oool200000_ooo`EYJFT01f][Jf5QHFUYJD51@OooofUYJOooo`04000000?ooomYJFUY
JFT02fUYJ@03J6QXIFEUJFUY00aYJFT2000000Koool0003oooooool0003ooolZJFUY0_ooo`030000
oooooooo02Goool01@000?ooooooo`000?ooo`0300000oooo`060000TI6AT92@F5QH0000oooo0P00
0003ooooTI6ATI6A00FATI40192@T96ATI6ATOooo`:ATI42000000?oool0003oool0796AT@800000
1Oooo`000?ooo`000?ooo`0ZTI6A0oooo`030000oooooooo02Coool01`000?ooo`000:2PX00006UY
JDU9B@03oooo00IRHV:ATI6ATI6@T91dM7Coool2000000?ooonIVIVATI40296AT@04];BdTI6ATI6A
JFUY0`000003Vi^KTI6ATI6A01ZATI42000000Koool0003oooooool0002FUYHZTI6A0_ooo`030000
oooooooo01;oool002Ooool4000000Coool0003oool00003oooo0WAdM0070000oooo00000000oooo
0000:BTY00IdM7@017IfMW1`L7AdM?ooo`9dM7@01?ooo`000?ooo`00011dM7@00gEeMG5aLGAdM00;
M7Ad0P000003oooo0000M7Ad02=dM7@00g9bLWAdM7AdM006M7Ad0_ooo`030000oooooooo02?oool0
1P000?ooo`0000000?ooo`0000Goool2JFUY00=^KVh0000000000_ooo`800005JFUY00][Jf]QHF5Y
JFUYJFT0003oool0003oool0003oool000003VUYJ@03J6QXIFEUJFUY00YYJFT00`000?ooo`000002
000000?oool0001YJFT0;6UYJ@;oool00`000?ooooooo`0Uoooo0P000007oooo00000000oooo0000
oooo000000?oool0196ATI2@T0000?ooo`8000000oooo`000820P006TI6A00B@T92ATI6ATI7oool2
TI6A00Coool00000003ooolMTI6A00Coool000000000000]TI6A0_ooo`80000Voooo00P0003oool0
001DE5Cooom[Jf_oool00002oooo00FNWYjATI6ATI61PH7oool00P000003oooo0000TI6A00VATI40
1ooooi6ATI6ATOooo`000?ooo`00000NTI6A0P000003ooooO7alTI6A02bATI400oooo`000000000D
oooo000Woooo00P0003oool00000003oool0003oool00003oooo0WAdM0030000oooo000000;oool0
0`0007AdM7AdM005M7Ad00AfMWI`L71dM7Coool2M7Ad00Coool0003oool0000@M7Ad00=eMGEaLG5d
M7@02gAdM0030000oooo000002EdM7@00g9bLWAdM7AdM006M7Ad0_ooo`030000oooooooo02?oool0
20000?ooo`0000000?ooo`000?ooo`0000;oool01@0006UYJFUYJ@000?ooo`0200000_ooo`IYJFT0
2V][Jf5QHFUYJ@000?ooo`000?ooo`000?ooo`0000mYJFT00fQXJ6EUIFUYJ@09JFUY00<0003oool0
00000_ooo`030000JFUYJFUY02eYJFT2oooo00<0003oooooool09Oooo`030000oooooooo00800000
1?ooo`000?ooo`0000?oool01I6ATI2@T75aLOooo`000002oooo00<0002ATI6ATI401I6AT@04T92@
TI6ATI6Aoooo0Y6AT@03oooo0000000001jATI401?ooo`000?ooo`0002fATI43oooo00<0003ooooo
ool09?ooo`0;0000ooooFEUIOgmoooooQHF5h^;R0000ooooo?clV9RH00>ATI401Oooo`000?oooooo
obl_;`0:TI6A00NTY:BATI6ATI7ooolL71coool10@407I6AT@04PH610000ooooMgMg;Y6AT@;oool0
0`000?ooooooo`0Boooo000Woooo00@0003oooooooooool3000000Koool00000003oool0003oool2
000000Koool00000003ooomdM7@00002oooo00L0000E5AEdM7AfMWI`L71dM7Coool00WAdM003oooo
0000000000QdM7@200000_ooo`EdM7@00gEeMG5aLGAdM00:M7Ad0`000003ooooM7AdM7Ad015dM7@0
0`000?ooo`00000?M7Ad00=bLW9dM7AdM7@01WAdM0;oool00`000?ooooooo`0Soooo00@0003oool0
003oool3000000Coool0003ooomVIVH2JFUY10000003ooooSHf=JFUY00EYJFT01V][Jf5QHFUYJ@00
0?ooo`0000;oool200003fUYJ@03J6QXIFEUJFUY00UYJFT010000?ooooooo`00035YJFT2oooo00<0
003oooooool09Oooo`030000oooooooo00;oool3000000Woool00000003oool00031`L51@D40003o
ool00P000003ooooTI6A000000;oool0100008>3Pi6ATI2@T0:ATI401_oooi6ATI6ATOooo`000?oo
o`NATI400`000?ooo`000002oooo4Y6AT@<0000CTI6A00?oool000000000696AT@?oool00`000?oo
ooooo`0Toooo00@0003oooooooooool2000000YNGUkoool0001LG5bn_[h0003ooon@T90T92Coool2
000000?ooonATI61PH400_ooo`03S8b<TI6ATI6A00>ATI401<71`I6ATI6ATJNWY`800008TI6A00B6
QXH0003;bl^CTi<BTI6A00@@41000000003ooolCTI6A00<0003ooomgMgL0696AT@;oool00`000?oo
ooooo`0Boooo000Goooo1@0000;oool00`000?ooooooo`02oooo00D0003oooooooooool000000ooo
o`800002oooo0P0000?oool2000000Koool00000003ooolE5AEdM7@2000000Ooool0003ooomfMWI`
L71dM7Coool00WAdM004oooo0000oooo00001gAdM0030000oooo000000;oool01P0007AdM7AdM7Ad
M7EeMG5aL@adM7@010000?ooo`000000015dM7@02Oooo`0000000?ooo`000?ooo`000?ooo`00000:
M7Ad00=bLW9dM7AdM7@01WAdM0;oool00`000?ooooooo`0Boooo1@0000;oool00`000?ooooooo`02
oooo00<0003oooooool00_ooo`030000oooo000000<00004oooo0fUYJ@05KVi^000000000000oooo
00MYJFT01V][Jf5QHFUYJFUYJ@000?ooo`8000000oooofUYJFUYJ@0>JFUY00=XJ6QUIFEYJFT02FUY
J@03oooo00000000039YJFT2oooo00<0003oooooool05Oooo`D00002oooo00<0003oooooool00_oo
o`050000oooooooooooo000000Coool200000_ooo`800002oooo00@0001CDe<0003oool2000000?o
oon1PH7oool00P000004oooo0000ooooT92@0Y6AT@04ooooTI6ATI6Aoooo0P000003ooooTI6ATI6A
00BATI401_ooo`000?ooo`000?ooo`0001:ATI400`000?ooo`00000ATI6A00?oool0003oool00P00
0004oooo0000oooo00004i6AT@?oool00`000?ooooooo`0Coooo1@0000;oool00`000?ooooooo`02
oooo00<0003oooooool00_ooo`040000oooooooooooo0P0000;oool2000000Jh^;Soooooool0000^
;Rkoool2000000>[Zj^ATI6@T9000P000003ooooH61PU9BD00>ATI401jZZZY6ATI6ATIZJVP000?oo
o`820P07TI6A00<0003oool000000_ooo`03Jf][TI6ATI6A00nATI4010000?ooobd];GMgMa6ATI40
2Oooo`0000000?ooo`000?oooaPH6?ooogMgM`0CTI6A0_ooo`030000oooooooo01;oool001Woool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000_ooo`050000oooo0000oooo0000
00?oool00`000?ooooooo`04000000?oool0000000000_ooo`03M7Ad0000000000?oool01000071`
L7AdM?ooo`9dM7@2000000?oool0001dM7@01WAdM0<000000oooo`0000000002000000=dM7AeMGEa
LG4037AdM004oooo00000000oooo4GAdM003oooo0000oooo00800002oooo00<0003oool000000P00
0003ooooM7AdM7Ad00AdM7@00g9bLWAdM7AdM006M7Ad0_ooo`030000oooooooo01Coool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000000oooo`050000oooooooo0000oooo00<00000
0oooo`000?ooo`02oooo00L0003oooooool0003oool0001YJFT00P00000;oooo0000JFUYJf][HF5Q
JFUY0000oooo0000oooo000000;oool6JFUY00D0003oool0003oool0000016UYJ@03J6QXIFEUJFUY
00YYJFT2oooo00<0001YJFUYJFT046UYJ@04oooo00000000oooo0P0001UYJFT2oooo00<0003ooooo
ool05oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000002oooo00H0003ooooo
ool0003oool00006oooo10000006oooo00000000ooooTI6Aoooo0P0000?oool01000096ATI6ATOoo
o`:ATI4016MWI`000?ooo`0000JATI401Oooo`00000000000?ooo`02000000?oool0002ATI403Y6A
T@03oooo00000000016ATI42oooo0`0000;oool00`000?ooo`000002000000?ooonATI6ATI403I6A
T@?oool00`000?ooooooo`0Eoooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00?oool02`000?ooo`000?ooo`000<[:b_ooomcLg4a<C>k^k_ooo`02000000=iNGV1PH7oool00P00
0003/[:bUIFETI6A00800003oooo00AnOWjATI6ATI6BTY82TI6A00B@T90X:2SooomDE5@7TI6A0`00
0005oooo000000000000RXZ:00nATI401:^[Z`0000000?oooa6ATI401Oooo`000?ooogMgM`000002
oooo00H0003oool0000H61P0003_knl?TI6A0_ooo`030000oooooooo01;oool001Woool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000000_ooo`8000000oooo`000?ooo`05000000?o
ool0000000001P000003ooooi>CT000000P00003M7Ad0`0000IdM7@5000000?oool0000000000`00
0003LG5a0000M7Ad00adM7@010000?ooo`00000000idM7@00oooo`0000000003M7Ad0P000003M7Ad
0000000000@000001oooo`000000000007AdM79bLP000007M7Ad0_ooo`030000oooooooo01Coool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`040000oooo0000oooo0P00
0003oooo0000000000X000000fUYJ@0000000002000000Coool0001QHF5YJFT2000000=YJFWoool0
00000P0000IYJFT01@000?ooo`0000000?ooo`03000000=YJFT0001UIFD036UYJ@<0000@JFUY00<0
003oool000001@000003ooooH61P000000@0000AJFUY00?oool0000000006Oooo`070000oooooooo
oooo0000oooo000000;oool00`000?ooo`000002oooo0P000004oooo00000000oooo1@000004oooo
00000000oooo1@000004XZ:Roooo0000oooo1@000003TI6ALg=cTI6A00:ATI4300001I6AT@050000
oooo00000000TI6A00@000001Oooo`000000096AT@00000=TI6A0`0000jATI400oooo`0000000003
TI6A0P000003TI6A0000000000@000001?ooo`000000000000:ATI400`00096ATI6AT@05TI6A0_oo
o`80000Goooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000?oool01@000?oo
o`0000000?ooo`03000000?oool0003oool020000003Ti>CTI6A000000D000000fi^KP00092@T003
TI6A00<10@40000000001Y6AT@03410@00000000008000000iNGU`0000000003000000>ATI4@412A
TI402i6AT@05PH610000ooooAdM74A4A00nATI43000000J1PH6ATI4@410@412ATI4A4A45000000Co
ool820P000000002TI6A00<A4A6ATI6ATI401I6AT@03oooo0000000001Coool001Woool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000000_ooo`030000oooo000000<00002oooo00@0
003oool0003oool200000_ooo`030000oooooooo008000001?ooo`0000000?ooo`<000000gAdM7Qh
N7AdM002M7Ad0P000003oooo0000M7Ad00AdM7@2000000?ooomdM7AdM7@00WAdM08000001?ooo`00
00000?ooo`edM7@01?ooo`0000000?ooo`edM7@00`000?ooo`00000<M7Ad00?oool0003oool00P00
0003oooo0000oooo00MdM7@2oooo00<0003oooooool05?ooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`000003oooo00D0003oool0003oool000000oooo`@000001?ooo`0000000000
00;oool01P0008f=S@0000000?ooo`0000?oool3000000EYJFWoool00000003oool01FUYJ@800000
0oooo`000?ooo`03000000Goool00000003oool0000036UYJ@030000oooo000000iYJFT01?ooo`00
00000?ooo`AYJFT01Oooo`0006UYJ@000?ooo`02000000Coool00000003oool2000036UYJ@;oool0
0`000?ooooooo`0Goooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000;oool0
0`000?ooooooo`0400000_ooo`040000oooo0000oooo0P0000;oool00`000?ooooooo`02000000Co
ool00000003oool2000000?ooonATI6BTY800i6AT@040000oooooooo0000196AT@040000oooo0000
oooo0i6AT@04IfMWoooo0000oooo0P0000jATI42000000?ooonATI6ATI402i6AT@040000oooo0000
oooo2i6AT@03oooo0000oooo008000000oooo`000?ooo`07TI6A0oooo`030000oooooooo01Goool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`030000oooo000000<00002
oooo00<0003oool000000`0000;oool01BPX:?ooooooof=SH`000002oooo00<;2`^GUiL000000P00
00FATI40192@T2PX:?oooeADE0FATI401@000>CTi00000000>g]k@02TI6A00>@T900003oool00P00
0003ooooTI6ATI6A00^ATI401:^[Z`0000000?ooo`fATI401`000?ooo`0000000?ooo`000:^[Z`08
TI6A00>[Zj/0002FUYH00P000003oooo0000oooo00NATI42oooo00<0003oooooool04_ooo`006Ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`000002oooo00<0003oool000000P00
0003oooo0000oooo00Coool01@000?ooo`000?ooo`000002oooo0P000005oooo0000ooooM7Ad^[Zj
00;oool00`0007AdM7AdM003M7Ad00<0003oool0000017AdM0040000oooo000000001WAdM0?oool0
0`0007AdM7AdM00<M7Ad0oooo`030000M7AdM7Ad00UdM7@01?ooo`0000000?oooa1dM7@01?ooo`00
0?ooo`0000MdM7@2oooo00<0003oooooool05?ooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000003oooo00D0003oooooool0003oool00`0000;oool4000000Koool0003oooooool0
003oool200000_ooo`0<0000oooo00000000HF5QooooJFUY0000oooo0000oooo000016UYJ@040000
oooooooo00000VUYJ@050000oooo0000oooo000000;oool<JFUY0P000003oooo0000JFUY00aYJFT2
oooo0P0000UYJFT02Oooo`0000000?ooo`000?ooo`000?ooo`00000;JFUY0_ooo`030000oooooooo
01Ooool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo
00<000000oooo`000?ooo`04oooo00D0003oool0003oool000000_ooo`090000oooooooo0000moOg
TI6AW9bLoooo000000FATI4010000?ooooooo`0000>ATI400`000?ooooooo`0200001Y6AT@?oool0
0`00096ATI6AT@0<TI6A0_ooo`030000TI6ATI6A00VATI401?ooo`0000000?oooa6ATI400`000?oo
o`000007TI6A0oooo`030000oooooooo01Goool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000000oooo`070000oooo0000LG5a0000oooo000000Goool01@000?oooe9BD_oooe5AD@02
oooo00<0001mOGgoool00P000005/K6aTI6AooooooooP82000FATI400de=COooo`T92@04TI6A00N6
QXKoool00000003oool0002?Shl00i6AT@04UiNG_KfmooooR8R83Y6AT@04Zj^[ooooooooMgMg2i6A
T@05oooo00000000oooo000000;oool00`000:^[Zi6AT@0:TI6A00B[Zj/0003ooon;Rh/7TI6A0_oo
o`030000oooooooo01;oool001Soool200001?ooo`030000oooooooo00;oool01@000?oooooooooo
o`000002oooo00<0003oool000000P000009oooo0000oooooooo0000M7Adoooo0000oooo00800000
1Oooo`000?ooo`00061PH00:M7Ad00Coool00000003oool3M7Ad00@0003oool0003ooolIM7Ad00@0
003oool000000009M7Ad0oooo`80000KM7Ad0_ooo`030000oooooooo01?oool200001?ooo`030000
oooooooo00;oool00`000?ooooooo`02oooo00<0003oooooool00`0000;oool00`000?ooo`000002
oooo0P000004oooo00000000oooo0P0000;oool01`000?ooo`0000000?ooofUYJOooo`02JFUY00?o
ool0000000001FUYJ@04oooo0000oooo00001FUYJ@04oooo00000000000036UYJ@<000000oooofUY
JFUYJ@0;JFUY0P000003ooooJFUYJFUY00aYJFT00oooo`000?ooo`0200002fUYJ@;oool00`000?oo
ooooo`0Foooo0P0000Coool00`000?ooooooo`02oooo00D0003oooooooooool000000oooo`030000
oooo0000008000002Oooo`000?ooooooo`00096ATOooo`000?ooo`0300000_ooo`030000SXj>TI6A
00VATI43000000CooonATI6ATI400002oooo00<0002l_;bATI405i6AT@040000oooo000000002Y6A
T@;oool200006i6AT@?oool00`000?ooooooo`0Doooo0P0000Coool00`000?ooooooo`02oooo00<0
003oooooool00_ooo`0:0000oooooooo0000oooo0000L71`0000oooo00000_ooo`050000TI6A]kNg
0000];Bd008000000lO7afIVI_ooo`02000000?OgmnATI6ATI401i6AT@04Xj>S0000:BTYTi>C0i6A
T@04QXJ6oooo0000oooo0P000003kNg]TI6ATI6A01BATI4010000?ooodM7Aa4A4@VATI43oooo00@Y
:BV;Rh/000000002oooo00<0002[Zj^ATI40596AT@;oool00`000?ooooooo`0Boooo000Woooo0`00
00;oool00`000?ooo`000004000000OooomdM7Coool0003oool0003oool00`000003ooooM7AdM7Ad
00UdM7@400000gAdM0030000oooo000001YdM7@00oooo`000000000:M7Ad00@0003oool0003ooolL
M7Ad0_ooo`030000oooooooo02?oool010000?ooo`000?ooo`800005oooo00<0003oool000000_oo
o`800002oooo0P000003ooooJFUYJFUY00AYJFT01?ooofUYJFUYJOooo`8000001?ooofUYJFUYJFUY
J@8000000oooo`000000000FJFUY00@0003oooooool0000;JFUY0P000003ooooJFUYJFUY01eYJFT2
oooo00<0003oooooool09Oooo`8000001_ooo`000?ooooooo`000?ooo`D00002TI6A00Goool0003o
ool0003oool00`000003ooooTI6ATI6A00RATI400`410@000?ooo`0200000Y6AT@040000oooo0000
oooo6I6AT@04oooo00000000oooo2I6AT@040000oooo0000oooo796AT@;oool200009_ooo`030000
oooo000000;oool00`0008R8R0000004000000Soool0002QXJ40002EUID0003ooolM7Ad200000_oo
o`030000TI6ATI6A00NATI40192@T00003`l?7emO@>ATI400`000?ooo`000002000000?oool0002?
Shl05I6AT@03Zj^[0000000000ZATI401P000?ooo`000:FUYI6ATH61P@800002oooo00<0002[Zj^A
TI404i6AT@03oooo0000000001Coool002Ooool00`000?ooo`000002oooo00<0003oool000001000
0005ooooM7Adoooo0000oooo00D000000oooogAdM7AdM00:M7Ad00<0003oool000000WAdM0040000
oooooooo00006gAdM0030000oooo000000QdM7@01?ooo`0000000?oooaedM7@2oooo00<0003ooooo
ool08oooo`030000oooo000000;oool00`000?ooo`000002oooo0P00000;oooo:BTYoooo0000oooo
0000oooo0000oooo0000ADE500IYJFT01@0006UYJFUYJ@000?ooo`0200000fUYJ@040000oooooooo
00005fUYJ@04oooo00000000oooo2fUYJ@03oooo0000000001mYJFT2oooo00<0003oooooool09Ooo
o`040000oooooooo00000_ooo`030000oooo000000@00002TI6A00?oool0003oool01@000003oooo
TI6ATI6A00VATI4010000?ooooooo`0000:ATI4010000?ooo`00000001ZATI4010000?ooooooo`00
00RATI42000000?ooonATI6ATI406i6AT@?oool00`000?ooooooo`0Toooo00L0003oool820RDU9C^
k^h0000^;Rh0100000;oool0110@49VIV@0009FEU@8000000gAdM00000000002oooo00<A4A6:RXZA
TI40296AT@030000oooo61PH00:ATI401XJ6Q_ooooooo`410@000?ooo`8000000ng]kI6ATI6AT@0D
TI6A00<0003oool00000296AT@04oooo00000000oooo0i6AT@03Zj^[0000000000;oool00`000:^[
Zi6AT@0BTI6A0_ooo`030000oooooooo01;oool002Ooool00`000?ooooooo`02000000Coool0003o
ooooool2000000[oool0001dM7@0003ooom5ADGoool0003oool00002oooo37AdM006oooo0000oooo
ooooM7Ad00000_ooo`030000M7AdM7Ad01UdM7@01?ooo`000000000000MdM7@2oooo0P0001edM7@2
oooo00<0003oooooool08oooo`040000oooooooo00001?ooo`030000oooo000000;oool01D51@Ooo
o`000?ooo`000002oooo0P0000MYJFT01oooofUYJFUYJFUYJ@000?ooo`000003JFUY00Coool0003o
ool0000HJFUY00@0003oooooool00009JFUY00?oool0003oool086UYJ@;oool00`000?ooooooo`0U
oooo00@0003oooooooooool2000000Coool0003oooooool2000000[oool0002ATI40003ooon:RX[o
ool0003oool00002oooo2i6AT@;oool020000?oooooooi6AT@000?ooo`000;bl_1ZATI401Oooo`00
00000?ooo`000007TI6A00?oool0000000007I6AT@?oool00`000?ooooooo`0Toooo00L0003ooooo
oolF5QH0003ooonGUiL00_ooo`8000002oooo`L71h>3Phj>S_oooi6ATOooo`000?ooo`000?ooo`03
000000>a/K6ATI6ATI401i6AT@06UIFE0000ooooTi>CTI6AHF5Q0_ooo`070000Zj^[00000000oooo
0000Shn?01FATI401:^[Ze9BDP0007MgM`NATI42oooo00<Y:BV;Rh^ATI400i6AT@03Zj^[00000000
00;oool00`000861PI6AT@0ATI6A0_ooo`030000oooooooo01;oool002Ooool01@000?ooo`000000
0?ooo`08000000IdM7Coool0001TI6@0003oool3000000?ooomdM7AdM7@02WAdM0030000oooo0000
00H0000LM7Ad0P000003oooo0000M7Ad00AdM7@2000000?ooomdM7AdM7@07GAdM0;oool00`000?oo
ooooo`0Soooo00@0003oool0003oool4000000?oool0003oool00P000005JFUY0000oooo0000oooo
00<000000oooofUYJFUYJ@05JFUY00@0001YJFUYJFUYJFT4000000AYJFT00000003oool200006FUY
J@@00007JFUY0`00025YJFT2oooo00<0003oooooool09Oooo`030000oooooooo008000000oooo`00
00000006000000JATI7oool00021PH40003oool3000000>d];BATI6ATI402Y6AT@030000oooo0000
00D0000LTI6A0`000003oooo0000TI6A00BATI4200007i6AT@?oool00`000?ooooooo`0Toooo00L0
003oool0000@413Ti>@000020P801`000005T92@0000TI6A0000oooo00L00009TI6A00H0003ooolM
7AdH61R1PH4A4A43000000>@T900000000000`000003PH61TI6ATI6A01>ATI40110@40000?ooo`00
00FATI42000000?@d=21PH6ATI401I6AT@07PH61000000000000oooo0000PH61016ATI42oooo00<0
003oooooool04_ooo`009oooo`040000oooooooooooo0P0000;oool4000000KooomdM7Cooooooomd
M7@00003oooo00<0001PH61dM7@037AdM004oooo0000oooo00000_ooo`030000M7AdM7Ad01adM7@2
000000?oool0001dM7@00gAdM003oooo0000000001mdM7@2oooo00<0003oooooool08oooo`040000
oooo0000oooo0`0000Coool01P000?ooofUYJ@000?ooo`0000Coool00`0006UYJFUYJ@0:JFUY00D0
003oool0001YJFWoool00P000003ooooJFUYJFUY01UYJFT3oooo00<0001YJFUYJFT00fUYJ@03oooo
00000000029YJFT2oooo00<0003oooooool09Oooo`030000oooooooo00;oool200000_ooo`@00002
TI6A00B][JgooonATI400003oooo00<0002>SXjATI402i6AT@;oool01P000?ooo`000?ooo`000;bl
_1fATI401?ooo`000000000000BATI42oooo00<0002ATI6ATI407I6AT@?oool00`000?ooooooo`0T
oooo00P0003ooooooon0P80e=CF?Shm4A4Coool6000000BATI7ooonATI60P803oooo00H10@40003o
oooooolA4A6:RXX9TI6A00Coool0003ooom]KFd2oooo00H0002ATI6ATI6@T900003oool2000000>1
PH6ATI6ATI40596AT@040P820000ooooMgMg196AT@03oooo0000Rh^;00VATI401Z^[Z`0000000?oo
o`000:^[Za2ATI42oooo00<0003oooooool04_ooo`009oooo`8000000oooo`000?ooo`04000000_o
ool0003ooooooomdM7@C4a<0001dM7Coool0003oool00P0000idM7@01`000?ooo`000?ooo`000?oo
o`00000NM7Ad0`000007ooooM7AdM7AdM7Adoooo0000oooo021dM7@2oooo00<0003oooooool08ooo
o`070000oooooooo0000oooo0000oooo00<000001oooo`000:n_[fUYJOooo`000?ooo`02000000?o
ool00000000036UYJ@06oooo00000000JFUYoooo00000_oooaaYJFT010000?ooo`00000000=YJFT3
oooo0P00025YJFT2oooo00<0003oooooool09Oooo`800002oooo00<0003oool000000`000003oooo
0000oooo00:ATI4018>3P`00096ATOooo`8000000oooo`00096AT@0<TI6A00Goool0003oool0003o
ool00P0001nATI4300000i6AT@03oooo00000000022ATI42oooo0P0002Koool01`000?oooooooahN
7_ooo`0003De=@02000000koool0003oooooool0002ATI4820RATI6JVYX0003oool0001CDe>a/K43
000000>a/K6ATI6ATI401Y6AT@08T92@0000oooo7AdMoooo0000ooooP8200i6AT@05Zj^[00000000
oooo000001JATI40110@400000000?ooo`>ATI400oooo`000;no_`0;TI6A00J[Zj/00000003oool0
002[Zj/?TI6A00?oool0000000005?ooo`009oooo`030000oooo000000;oool00`000?ooo`000003
oooo0P000009M7AdCTi>0000M7Adoooo0000oooo0000oooo00idM7@01@000?ooo`0000000?ooo`02
00007gAdM0060000oooo00000000M7Adoooo0P00025dM7@2oooo00<0003oooooool08oooo`090000
oooo00000000oooo0000oooo0000oooo008000001_ooof1PH6UYJOooo`000?ooo`@000000ng]kFUY
JFUYJ@0:JFUY0P000004oooo00000000oooo0P0001aYJFT00oooo`0000000004JFUY00@0003oool0
003ooolRJFUY0_ooo`030000oooooooo02Goool010000?ooooooo`0000;oool00`000?ooo`000003
oooo0P000009TI6ARh^;0000TI6Aoooo0000oooo0000oooo00jATI400`000?ooo`0000030000896A
T@<000001I6ATOooo`0000000?ooo`0PTI6A0oooo`030000oooooooo02Coool010000?ooo`000?oo
o`8000000oooo`000?ooo`02oooo00a3@d?ooom2@T:ATI4[:b^ATI6DU9@0003oool0002j^[ZEUID2
000000?ooom_KfnATI40296AT@070000oooo0000:2PXoooo0000S8b<00>ATI401I2@T0000?ooo`00
09jNWP0GTI6A00H0003oool];BegMgNATI7oool200003I6AT@05Zj^[0000oooooooo000000nATI42
oooo00<0003oooooool04_ooo`009oooo`030000oooo000000;oool00`000?ooo`000003oooo0P00
0005M7AdOGem0000M7Ad000000;oool00`000?ooogAdM00=M7Ad00Ooool000000000003oool0003o
ool07gAdM008oooo00000000ooooM7Ad0000oooo00008GAdM0;oool00`000?ooooooo`0Soooo00<0
003oool000000P000004oooo0000oooooooo0P000004ooooJFUYJFUY00000oooo`<0000>JFUY00<0
003oooooool00P000003ooooJFUYJFUY01aYJFT2oooo00@0001YJFUYJFWoool2000000?ooomYJFUY
JFT08FUYJ@;oool00`000?ooooooo`0Uoooo00@0003oooooool00002oooo00<0003oool000000ooo
o`0700000@41TI6ATY:B0000TI6A?Shn00;oool00`000?oooi6AT@0=TI6A00?oool0000000000P00
0003_;blTI6ATI6A01jATI401_ooo`000?oooi6AT@000?ooo`80000PTI6A0oooo`030000oooooooo
02Coool01@000?ooo`0000000?ooo`02000001@`<33oooooooooool0003oool0002ATI5WIfNATI6@
T92[Zj_oool0002PX:2@T900003oool0002HV9P9TI6A00K4a<@000000000003oool00005TI6A00B[
Zj/0003ooon1PH4GTI6A00R[Zj/00000003ooonATI40003oool0000>TI6A0`000003ooooTI6ATI6A
00fATI42oooo00<0003oooooool04_ooo`009oooo`050000oooooooooooo000000?oool01@000?oo
ooooo`000?ooo`02M7Ad00?ooomdM7AhN7P00_ooo`80000>M7Ad00<0003oool000000P000003oooo
M7AdM7Ad01mdM7@4oooo0P00029dM7@2oooo00<0003oooooool08oooo`080000oooooooooooo0000
oooo0000oooo0P000008oooo0000JFUYJFUY0000oooo/K6aoooo0`0000iYJFT2000000Coool0003o
oooooolOJFUY00Coool00000001YJFT2oooo0P0002=YJFT2oooo00<0003oooooool09Oooo`030000
oooooooo00;oool01@000?ooooooooooo`000002oooo00L00020P82ATI6ATI7ooonATI6BTY800_oo
o`80000>TI6A00=WIfOoool000000P0002:ATI43oooo0P000003ooooTI6ATI6A01nATI43oooo00<0
003oooooool09?ooo`090000ooooooooBTY:K6a/_KfmFUYJoooo000000;oool01@000:RXZ18B4Y6A
TIbLW002TI6A0_ooo`07PX:2QXJ6TI6AQ8B4ooooIFEUTY:B00VATI400i2@T?ooo`000002000000?o
oonATI6ATI400i6AT@04T92@?clo_;bl4A4A696AT@04Zj^[oooooooooooo0P0000nATI401861POoo
okJf]X^;R`nATI42oooo00<0003oooooool04_ooo`009oooo`@000001Oooo`00000000000?ooo`02
000000Gooom;Bd]dM7AdM7Coool00WAdM004oooo00000000oooo3gAdM08000000oooo`000000000R
M7Ad00H0003oooooool0003oool0000QM7Ad0_ooo`030000oooooooo02?oool00`000?ooooooo`02
oooo00@0003oool000000002oooo00P0001YJFUYJFWoool0001=CDd0003oool200003VUYJ@030000
oooooooo00;oool00`0006UYJFUYJ@0MJFUY0P0000;oool00`000?ooooooo`0TJFUY0_ooo`030000
oooooooo02Goool2000000Coool00000003oool3000000Goool00000003ooon1PH400Y6AT@07oooo
TI6ATI6Aoooo0000ooooinOW00nATI42000000?oool0002ATI408I6AT@060000oooooooo0000oooo
00008I6AT@;oool200009_ooo`090000oooo0000:b/[h>3P0000NGUi0000oooo008000001Ooooi6A
TI6ATI6ATOOgm`02TI6A00BJVYX00000002BTY8?TI6A0P000003oooo0000QXJ602:ATI401P000?oo
ooooo`000?oooh61PB6ATI400oooo`000000000Doooo000Woooo00H0003ooonCTi>CTi<0000@4102
M7Ad00@0001dM7AdM7@00003M7Ad00L0001dM7AdM7@0001dM7@0001PH6004GAdM0030000M7AdM7Ad
02=dM7@2000000=dM7@0001dM7@08GAdM0;oool00`000?ooooooo`0Soooo00<0003oool000002000
0003ooooJFUYJFUY008000000fUYJ@000000000200003VUYJ@D0000QJFUY1@0002EYJFT2oooo00<0
003oooooool09Oooo`030000oooooooo00:FUYH01@00092@T820P96AT@000002TI6A00D0002ATI6A
TI6ATI4000000Y6AT@04410@TI6A0000P8204I6AT@030000T92@TI6A02:ATI42000000>ATI40002A
TI408I6AT@?oool00`000?ooooooo`0Toooo00T0003ooonATI6@T920P821PH6@T92ATI4000000Y6A
T@05P820TI6ATI6ATI6APH6100:ATI400i2@T96ATH61P@0BTI6A00<0002ATI6ATI408Y6AT@05PH61
0000410@TI6APH6102:ATI42oooo00<0003oooooool04_ooo`005oooo`D000001?ooo`0000000000
00?oool01P000?ooooooooooo`000?ooo`>CTi<00a0@47AdM7AdM01[M7Ad0_ooo`030000oooooooo
01;oool5000000Coool0000000000003oooo00<0003oooooool00_ooo`030000ooooWinO00:OWil0
0`T92FUYJFUYJ@1[JFUY0_ooo`030000oooooooo01Goool5000000Coool0000000000003oooo00D0
003oooooooooool000000_ooo`>FUYH00i2@T96ATI6AT@1ZTI6A0oooo`030000oooooooo01?oool5
000000Coool0000000000003oooo00<0003oooooool00_ooo`030000ooooTI6A072ATI42oooo00<0
003oooooool04_ooo`006Oooo`050000oooooooooooo000000Coool00`000?ooo`000002oooo00<0
003ooonCTi<00Y>CT`03410@M7AdM7Ad06]dM7@2oooo00<0003oooooool05?ooo`050000oooooooo
oooo000000Coool00`000?ooo`000003oooo00<0003ooonOWil00YnOW`032@T9JFUYJFUY06]YJFT2
oooo00<0003oooooool05oooo`050000oooooooooooo000000Coool00`000?ooo`000002oooo00<0
003oooooool00iJFUP03T92@TI6ATI6A06ZATI43oooo00<0003oooooool05Oooo`050000oooooooo
oooo000000Coool00`000?ooo`000003oooo00<0003ooonATI40L96AT@;oool00`000?ooooooo`0B
oooo000Ioooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000;oool200000i>C
T`03410@M7AdM7Ad06]dM7@2oooo00<0003oooooool05?ooo`030000oooooooo00;oool01`000?oo
ooooooooo`000?ooo`000003oooo00<0003ooonOWil00YnOW`032@T9JFUYJFUY06]YJFT00oooo`00
0000000Ioooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000;oool2000000Go
oonFUYJFUYJFUYJ@T900K96AT@;oool200005oooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`000003oooo00<0003ooonATI40L96AT@03oooo0000000001Coool001Woool00`000?oo
ooooo`02oooo00L0003oooooooooool0003oool000000_ooo`030000ooooTi>C00:CTi<00a0@47Ad
M7AdM01[M7Ad0_ooo`030000oooooooo01Coool00`000?ooooooo`02oooo00L0003oooooooooool0
003oool000000oooo`030000ooooWinO00:OWil00`T92FUYJFUYJ@1[JFUY0_ooo`030000oooooooo
01Ooool00`000?ooooooo`02oooo00L0003oooooooooool0003oool000000_ooo`030000oooooooo
00>FUYH00i2@T96ATI6AT@1ZTI6A0oooo`030000oooooooo01Goool00`000?ooooooo`02oooo00L0
003oooooooooool0003oool000000oooo`030000ooooTI6A072ATI42oooo00<0003oooooool04_oo
o`006Oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000002oooo00<0003ooonC
Ti<00Y>CT`03410@M7AdM7Ad06]dM7@2oooo00<0003oooooool05?ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000003oooo00<0003ooonOWil00YnOW`032@T9JFUYJFUY06]YJFT2
oooo00<0003oooooool05oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000002
oooo00<0003oooooool00iJFUP03T92@TI6ATI6A06ZATI43oooo00<0003oooooool05Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`000003oooo00<0003ooonATI40L96AT@;oool0
0`000?ooooooo`0Boooo000Hoooo0P0000Coool00`000?ooooooo`02oooo00H0003oooooooooool0
003oool3Ti>C00<@411dM7AdM7@0JgAdM0;oool00`000?ooooooo`0Coooo0P0000Coool00`000?oo
ooooo`02oooo00<0003oooooool00_ooo`030000ooooWinO00:OWil00`T92FUYJFUYJ@1[JFUY0_oo
o`030000oooooooo01Koool200001?ooo`030000oooooooo00;oool01@000?ooooooooooo`000002
oooo0iJFUP03T92@TI6ATI6A06ZATI43oooo00<0003oooooool05?ooo`800004oooo00<0003ooooo
ool00_ooo`030000oooooooo00;oool00`000?oooi6AT@1`TI6A0_ooo`030000oooooooo01;oool0
02Ooool00`000?oooi>CT`02Ti>C00<@411dM7AdM7@0JgAdM0;oool00`000?ooooooo`0Soooo00<0
003ooonOWil00YnOW`032@T9JFUYJFUY06]YJFT2oooo00<0003oooooool09Oooo`030000oooooooo
00>FUYH00i2@T96ATI6AT@1ZTI6A0oooo`030000oooooooo02Coool00`000?oooi6AT@1`TI6A0_oo
o`030000oooooooo01;oool002Ooool200000i>CT`03410@M7AdM7Ad06]dM7@2oooo00<0003ooooo
ool08oooo`030000ooooWinO00:OWil00`T92FUYJFUYJ@1[JFUY0_ooo`030000oooooooo02Goool2
000000GooonFUYJFUYJFUYJ@T900K96AT@;oool200009_ooo`030000ooooTI6A072ATI400oooo`00
0000000Doooo000Woooo00<0003ooonCTi<00Y>CT`03410@M7AdM7Ad06]dM7@2oooo00<0003ooooo
ool08oooo`030000ooooWinO00:OWil00`T92FUYJFUYJ@1[JFUY0_ooo`030000oooooooo02Goool0
0`000?ooooooo`03UYJF00>@T92ATI6ATI40JY6AT@?oool00`000?ooooooo`0Toooo00<0003ooonA
TI40L96AT@;oool00`000?ooooooo`0Boooo000Woooo00<0003ooonCTi<00Y>CT`03410@M7AdM7Ad
06]dM7@2oooo00<0003oooooool08oooo`030000ooooX:2P00:PX:000b0P86UYJFUYJ@1[JFUY0_oo
o`030000oooooooo02Goool00`000?ooooooo`03UYJF00>@T92ATI6ATI40JY6AT@?oool00`000?oo
ooooo`0Toooo00<0003ooonATI40L96AT@;oool00`000?ooooooo`0Boooo000Woooo00<0003ooooo
ool0L_ooo`030000oooooooo02?oool00`000?ooooooo`1boooo00<0003oooooool09Oooo`030000
oooooooo07?oool00`000?ooooooo`0Toooo00<0003oooooool0L_ooo`030000oooooooo01;oool0
02Ooool300001?ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0
003oooooool00_ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0
003oooooool00_ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0
003oooooool00_ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0
003oooooool00_ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0
003oooooool00_ooo`030000oooooooo02?oool00`000?ooo`000003oooo00<0003oooooool00_oo
o`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_oo
o`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_oo
o`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_oo
o`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo00<0003oooooool00_oo
o`050000oooooooooooo000000Coool01@000?ooooooooooo`000003oooo0P0002Ooool2000000?o
ool0003oool00_ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000004oooo00D0
003oooooooooool000001?ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00D0
003oooooooooool000001?ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00D0
003oooooooooool000001?ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00D0
003oooooooooool000001?ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00@0
003oooooooooool200009_ooo`030000oooo000000?oool00`000?ooooooo`02oooo00D0003ooooo
ooooool000001?ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00D0003ooooo
ooooool000001?ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00D0003ooooo
ooooool000001?ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00D0003ooooo
ooooool000001?ooo`050000oooooooooooo000000?oool00`000?ooooooo`02oooo00D0003ooooo
ooooool000001?ooo`050000oooooooooooo000000?oool200005?ooo`009oooogH0000UooooMP00
02Oooomg00009_ooogH0000Doooo003oooooooooohSoool00?ooooooooooR?ooo`00oooooooooon8
oooo001=oooo0`000:ooool30000V?ooo`<0002Ioooo0`0004goool004koool00`000?ooooooo`2_
oooo00<0003oooooool0V?ooo`030000oooooooo09Woool00`000?ooooooo`1<oooo000ooooo0`00
00;oool5000000Goool0003oool0003oool00`0000;oool300000oooo`80000=oooo0`0000;oool3
000000Coool0003oooooool200000oooo`800003oooo0P00047oool3000000Ooool000000000003o
ool0003oool00`0000;oool300000oooo`800003oooo0P0000?oool300003_ooo`<00002oooo1@00
0005oooo0000oooo0000oooo00<00002oooo0`0000?oool200003Oooo`<00002oooo0`000004oooo
0000oooooooo0P0000?oool200000oooo`80000_oooo100000?oool200000_ooo`<00003oooo0P00
00;oool300000oooo`80000>oooo0`0000;oool5000000Goool0003oool0003oool00`0000;oool3
00000oooo`80000=oooo0`0000;oool3000000Coool0003oooooool200000oooo`800003oooo0P00
037oool300000oooo`800002oooo0`0000?oool2000000?oool0000000000_ooo`030000oooooooo
00<0000=oooo0`0000;oool5000000Goool0003oool0003oool00`0000;oool300000oooo`80000=
oooo0`0000;oool3000000Coool0003oooooool200000oooo`800003oooo0P0001goool003ooool0
0`000?ooo`000002oooo0`000008oooo0000oooo0000oooo0000oooo00000_ooo`040000oooooooo
00000oooo`030000oooooooo00koool00`000?ooooooo`02oooo00H0003oooooool0003oool00002
oooo00<0003oool000000_ooo`030000oooo000000;oool00`000?ooooooo`0noooo00<0003oool0
00000_ooo`040000oooooooo00000_ooo`030000oooooooo00;oool01@000?ooooooooooo`000002
oooo00<0003oool000001?ooo`040000oooooooo00003_ooo`030000oooo000000;oool3000000So
ool0003oool0003oool0003oool00002oooo00@0003oooooool00003oooo00<0003oooooool03_oo
o`030000oooooooo00;oool01P000?ooooooo`000?ooo`0000;oool00`000?ooo`000002oooo00<0
003oool000000_ooo`030000oooooooo02goool01P000?ooooooo`000?ooo`0000Goool01@000?oo
ooooooooo`000004oooo00<0003oooooool00_ooo`040000oooooooo00003Oooo`030000oooo0000
00;oool3000000Soool0003oool0003oool0003oool00002oooo00@0003oooooool00003oooo00<0
003oooooool03_ooo`030000oooooooo00;oool01P000?ooooooo`000?ooo`0000;oool00`000?oo
o`000002oooo00<0003oool000000_ooo`030000oooooooo02koool00`000?ooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00;oool01P000?ooooooo`000?ooo`0000;oool00`000?oo
o`000002oooo00<0003oooooool02oooo`030000oooo000000;oool3000000Soool0003oool0003o
ool0003oool00002oooo00@0003oooooool00003oooo00<0003oooooool03_ooo`030000oooooooo
00;oool01P000?ooooooo`000?ooo`0000;oool00`000?ooo`000002oooo00<0003oool000000_oo
o`030000oooooooo01[oool0047oool00`000?ooooooo`02oooo00T0003oool0003oool0003oool0
003oool000000_ooo`040000oooooooo00000oooo`<0000>oooo0`0000;oool01P000?ooooooo`00
0?ooo`0000;oool00`000?ooo`000004oooo00@0003oooooool00012oooo00@0003oooooool00002
oooo00@0003oooooool00004oooo00D0003oooooooooool000001?ooo`<00002oooo00@0003ooooo
ool0000@oooo00<0003oooooool00_ooo`090000oooo0000oooo0000oooo0000oooo000000;oool0
10000?ooooooo`0000?oool300003_ooo`<00002oooo00H0003oooooool0003oool00002oooo00<0
003oool000001?ooo`040000oooooooo0000;oooo`050000oooooooo0000oooo00<00003oooo00@0
003oooooooooool300000_ooo`030000oooooooo00;oool00`000?ooooooo`0@oooo00<0003ooooo
ool00_ooo`090000oooo0000oooo0000oooo0000oooo000000;oool010000?ooooooo`0000?oool3
00003_ooo`<00002oooo00H0003oooooool0003oool00002oooo00<0003oool000001?ooo`040000
oooooooo0000<_ooo`030000oooooooo00<00002oooo00<0003oooooool00_ooo`060000oooooooo
0000oooo00000_ooo`030000oooo000000;oool00`000?ooooooo`0=oooo00<0003oooooool00_oo
o`090000oooo0000oooo0000oooo0000oooo000000;oool010000?ooooooo`0000?oool300003_oo
o`<00002oooo00H0003oooooool0003oool00002oooo00<0003oool000001?ooo`040000oooooooo
00007?ooo`00@?ooo`030000oooooooo00;oool2000000Koool00000003oool0003oool400000ooo
o`040000oooooooooooo0`0000koool01@000?ooooooo`000?ooo`0300000oooo`8000000oooo`00
0000000200000oooo`800012oooo00@0003oooooooooool300000_ooo`800003oooo0`000003oooo
0000000000800002oooo0`0000?oool300003oooo`030000oooooooo00;oool2000000Koool00000
003oool0003oool400000oooo`040000oooooooooooo0`0000koool01@000?ooooooo`000?ooo`03
00000oooo`8000000oooo`000000000200000oooo`80000`oooo00D0003oooooool0003oool00`00
00;oool300000_ooo`<00002oooo0`000003oooo000000000080000?oooo00<0003oooooool00_oo
o`8000001_ooo`0000000?ooo`000?ooo`@00003oooo00@0003oooooooooool300003_ooo`050000
oooooooo0000oooo00<00003oooo0P000003oooo0000000000800003oooo0P0003;oool010000?oo
ooooooooo`<00002oooo0`0000?oool2000000?oool0000000000P0000?oool300003_ooo`030000
oooooooo00;oool2000000Koool00000003oool0003oool400000oooo`040000oooooooooooo0`00
00koool01@000?ooooooo`000?ooo`0300000oooo`8000000oooo`000000000200000oooo`80000M
oooo000ooooo00<0003oool000004_ooo`030000oooooooo01;oool01P000?ooooooo`000?ooo`00
00Woool00`000?ooooooo`16oooo00<0003oool000000_ooo`030000oooooooo00Soool01@000?oo
ooooooooo`00000<oooo00<0003oooooool03?ooo`030000oooo000001;oool00`000?ooooooo`0B
oooo00H0003oooooool0003oool00009oooo00<0003oooooool0=Oooo`040000oooooooo00001ooo
o`030000oooooooo00_oool00`000?ooooooo`0>oooo00<0003oool000004_ooo`030000oooooooo
01;oool01P000?ooooooo`000?ooo`0000Woool00`000?ooooooo`0foooo00<0003oool000006Ooo
o`030000oooooooo00_oool00`000?ooo`00000Boooo00<0003oooooool04_ooo`060000oooooooo
0000oooo00002Oooo`030000oooooooo02;oool003ooool300004Oooo`80000Coooo10000003oooo
0000000005;oool3000000?oool0000000001Oooo`030000oooooooo00?oool00`000?ooooooo`0<
oooo0P0000koool300004Oooo`80000Coooo10000003oooo00000000043oool400002Oooo`030000
oooooooo01_oool300004Oooo`80000Coooo10000003oooo0000000004;oool300006?ooo`80000=
oooo0`00017oool200004oooo`@000000oooo`000000000^oooo003oooooooooohSoool00?oooooo
ooooR?ooo`00oooooooooon8oooo003oooooooooohSoool00?ooooooooooR?ooo`00oooooooooon8
oooo0000\
\>"],
  ImageRangeCache->{{{0, 645.875}, {149.125, 0}} -> {-0.115226, -0.0232607, 
  0.00654996, 0.00654996}, {{17.5625, 159.563}, {145.563, 
  3.5}} -> {-47.5242, -18.4869, 1.1353, 1.1353}, {{173.813, 315.813}, {
  145.563, 3.5}} -> {-223.072, -18.4869, 1.1353, 1.1353}, {{330, 472}, {
  145.563, 3.5}} -> {-402.095, -18.4869, 1.1353, 1.1353}, {{486.25, 628.25}, {
  145.563, 3.5}} -> {-579.486, -18.4869, 1.1353, 1.1353}}]
}, Open  ]],

Cell["\<\
roundWin=Compile[{{xOrigin,_Integer},{yOrigin,_Integer},
\t{radius,_Integer},{dataMatrix, _Real, 2}},
\tModule[{i=0,j=0,k=0,win={{0.}},dim={0}},
\t\tdim=Table[Dimensions[dataMatrix][[i]],{i,2}];
\t\twin=Table[0.,{dim[[1]]},{dim[[2]]}];
\t\tDo[
\t\t\tj=Round[Sqrt[radius^2-i^2]];
\t\t\tDo[win[[yOrigin+i,k]]=1.,
\t\t\t{k,xOrigin-j,xOrigin+j}],
\t\t{i,-radius,radius}];
\t\twin dataMatrix]];\
\>", "Input"],

Cell["\<\
fourierWavelet[sample_,test_,base_]:=
\tModule[{n,m,wMatrix,varyPartSpect,partSpect,testFourier},
\t\tn=Length[sample];
\t\tm=Ceiling[Log[2.,Length[Transpose[base]]]]-1;
\t\twMatrix=waveletMatrix[n,base];
\t\ttestFourier=Fourier[test];
\t\tvaryPartSpect=
\t\t\twMatrix.Re[InverseFourier[
\t\t\t\t(imageNormalize[Abs[testFourier]]-
\t\t\t\t\timageNormalize[Abs[Fourier[sample]]])*
\t\t\t\t\ttestFourier]].Transpose[wMatrix];
\t\tpartSpect=ZeroMatrix[n];
\t\tDo[partSpect[[i,j]]=varyPartSpect[[i,j]],{i,2^m},{j,2^m}];
\t\troundWin[n/2,n/2,(n/2)-3,
\t\t\timageNormalize[Transpose[wMatrix].partSpect.wMatrix]]
\t];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\(SampleFW = fourierWavelet[sample, sample, coif30]; \)\)], "Input"],

Cell[BoxData[
    \(\(ShiftedFW = fourierWavelet[sample, shiftedsample, coif30]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(DefectFW = fourierWavelet[sample, badsample, coif30]; \)\)], "Input"],

Cell[BoxData[
    \(\(SecondFW = fourierWavelet[sample, sample2, coif30]; \)\)], "Input"],

Cell[BoxData[
    \(\(Sample = 
      ListDensityPlot[SampleFW, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<Sample Photo\>", \n\tDisplayFunction -> Identity]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(ShiftedSample = 
      ListDensityPlot[ShiftedFW, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<shifted Sample Photo\>", \n\t
        DisplayFunction -> Identity]; \)\)], "Input"],

Cell[BoxData[
    \(\(DefectSample = 
      ListDensityPlot[DefectFW, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<defect Sample Photo\>", \n\t
        DisplayFunction -> Identity]; \)\)], "Input"],

Cell[BoxData[
    \(\(SecondSample = 
      ListDensityPlot[SecondFW, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<second Sample Photo\>", \n\t
        DisplayFunction -> Identity]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[GraphicsArray[{Sample, ShiftedSample, DefectSample, SecondSample}]]
      \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .23256 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0055371 0.238095 [
[ 0 0 0 0 ]
[ 1 .23256 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .23256 L
0 .23256 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0055371 0.245293 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.0055371 0.488926 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -62 0 ]
[.5 1.0125 62 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -123 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(shifted) show
111.000000 13.000000 moveto
(Sample) show
153.000000 13.000000 moveto
(Photo) show
183.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000100000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
00000000403E3B37332E28231E1915131110101112141619
1B1E20000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
40414141403E3C38342F2A25201B1815141313141517191B
1E202325282A2B0000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000393B3D3E
3F404140403E3C3834302B26211D1A1816161617181A1C1E
212325282A2C2D2E2E2E2E00000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000000000323436393A3C3E
3F3F3F3F3E3D3A3734302B27231F1C1A1919191A1B1D1F21
2325282A2C2D2F2F2F2F2F2E2D2C00000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000002D30323436383A3C3D
3D3E3E3D3C3A3835322F2B2724211E1D1C1C1C1D1E202224
26282A2C2D2F30303130302F2E2D2C2B0000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000002B2C2E30323537393A3B3C
3C3C3B3A39373533302D2A272422201F1E1E1F2021232426
282A2C2D2F303132323131302F2E2D2C2C2B000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000028292B2D2F31333537393A3A3B
3A3A39373634322F2D2B2926252322212121222324252728
2A2C2D2F303132333332323130302F2E2D2C2B2A00000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000000000000002426282A2C2E303234363739393A39
3937363432302E2C2A29272625242323232425262728292B
2C2E2F3132333334343333323231302F2E2D2D2C2B2A0000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000001D202325282A2C2E313335363839393938
373533312F2C2B292827262525252526262728282A2B2C2D
2F3031323334343535343433333231302F2F2E2D2C2B2A29
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000181C1F2225282A2D2F323435373838383836
3533302E2B2928262625252626272828292A2B2B2C2D2F30
3132333435353636363635353433323131302F2E2D2C2B2A
290000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000001214171B1E2124282B2D30323436373738373635
33302E2B292725252425252628292A2B2C2D2E2F2F303132
3334353637373737373736363534333232312F2E2D2C2B2A
2A2928000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000F1114171A1D2124282B2E30323435363636363533
312E2C2A27262424242527282A2C2D2F3030313232333435
363737383939393939393837363635333231302F2D2C2B2A
2A2928280000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000D0F101214171A1D2124272B2D30323334353534343331
2F2D2B29272625252627292B2D2F31323334353536363737
38393A3A3B3B3B3B3B3A3A39383736343331302E2D2C2B2A
2A2929292827000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0E1011121315171A1D2124272A2D2F31323333333231302F
2D2C2A2928272728292B2D2F313335363738383939393A3A
3B3C3C3D3D3E3E3E3D3D3C3B3A3837353432302E2D2B2A29
292929292929280000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000010
111213141517191B1E2124272A2D2E3031313130302F2E2D
2C2B2A2A29292A2B2D2F313336383A3B3C3C3C3C3C3C3D3D
3E3E3F4040404140403F3E3D3C3A38363432302E2C2A2929
2929292A2A2A292800000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000001214
1515161717181A1C1F2224272A2C2E2F2F2F2E2E2D2C2C2B
2B2B2B2B2C2D2E30323436393B3D3E3F4040404040404040
41414243434344434342413F3E3C3A383533302E2C2A2928
28292A2B2B2C2C2B29000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000141617
181919191A1A1C1D202225272A2B2D2D2D2D2C2C2B2A2A2A
2A2B2C2D2F31323537393C3E404243444444444443434343
444445464647474746454442413F3C3A3734312E2C2A2828
28292A2C2D2D2E2D2C2B0000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000015181A1B
1B1C1C1C1C1C1D1F21232528292B2C2C2C2B2B2A29292929
2A2C2E303235373A3C3F4143454748484848484747474647
474849494A4A4A4A4948474644413F3C3935322F2C2A2928
292A2B2D2E2F30302F2E2C00000000000000000000000000
0000000000000000
0000000000000000000000000000000000000016181B1D1E
1F1F1F1E1E1E1F20222426282A2B2C2C2B2B2A2928282829
2B2E303336393C3F424446484A4B4C4D4D4C4C4B4B4A4A4B
4B4C4D4D4E4E4F4E4E4C4B494745423F3B3834312E2B2A29
2A2B2D2F3032333332312F2D000000000000000000000000
0000000000000000
00000000000000000000000000000000000015191B1E2021
2222212120202021232426282A2B2C2C2B2B2A292828292B
2D3033373A3E414447494B4D4E5050515150504F4F4F4E4F
4F5051525353535352514F4E4C4946423F3B3733302E2C2C
2C2D2F3133343536353432312E0000000000000000000000
0000000000000000
000000000000000000000000000000000014181B1E212324
2424232222212122242527292B2C2D2D2C2C2B2A2A2A2B2D
3033373A3E4246494B4E4F51525354545454545353535354
545556575858585857565453504E4A47433F3B3734312F2F
2F3032343637383838373533312F00000000000000000000
0000000000000000
000000000000000000000000000000001316191D20232526
26262524232222232426282A2C2D2E2E2E2D2D2C2C2D2E30
33363A3E42464A4D4F525355565757585858585858585859
5A5B5C5D5D5E5E5E5D5B5A5855534F4C48433F3C38353433
33343637393A3B3B3B39383634312F000000000000000000
0000000000000000
0000000000000000000000000000001114171B1E22252728
28282625242323242527292B2D2F303030302F2F2F303234
373A3E42464A4E5153555658595A5A5B5B5B5C5C5C5C5D5E
5F6061626363636362615F5D5B5855514D4945413E3B3938
38393A3B3C3D3E3E3D3C3A383634312F0000000000000000
0000000000000000
0000000000000000000000000000001215181C202427292A
2A2928262524242426272A2C2E3032323333333333343638
3B3F43474A4E51545658595A5B5C5D5E5E5F5F6060616263
646566676869696968676563615E5B57534F4B4743413F3D
3D3E3E3F40414141403E3C3A383633310000000000000000
0000000000000000
0000000000000000000000000000111316191D2125282B2C
2B2B29282625252526282B2D303233353536363637383A3D
4043474B4E525557595B5C5D5E5F5F606161626364656667
696A6B6D6D6E6E6E6D6C6B696664605D5955514D4A474543
434343444444444442413F3C3A3835343200000000000000
0000000000000000
00000000000000000000000000121214171A1E23272A2C2D
2D2C2B2927262626282A2C2F313335373839393A3B3C3E41
44474B4F5255585A5C5D5E5F606061626364656667686A6B
6D6E7071727373737271706E6C6966635F5B5753504D4B49
48484848484848474543413E3C3A38363433000000000000
0000000000000000
00000000000000000000000015131415181C2024282C2E2F
2F2E2C2B29282728292B2D30333537393A3B3C3D3F404245
484B4F5255585B5D5E5F60616162636464666768696B6C6E
707173747576777776767473716E6C6865615D5A5653514F
4E4D4D4C4C4C4B4A484643413E3C3A383736350000000000
0000000000000000
000000000000000000000000161516171A1E22272B2E3031
31302E2D2B2A292A2B2D2F323437393B3C3E3F4041434548
4B4F5255595B5E5F6161626363636465666768696B6C6E70
7273757677787979797978777573716E6B6763605C595755
53525151504F4E4D4B494644413F3D3B3A39380000000000
0000000000000000
00000000000000000000001A1918181A1D2125292D313334
3433312F2E2C2C2C2D2F313436393B3D3E3F41424345484A
4E5155585B5E606263636464646465656667696A6B6D6F70
7274757778797A7B7B7B7B7A79787673706D6965625F5C5A
58575655545352504E4C4A474543413F3E3C3B3A00000000
0000000000000000
000000000000000000001F1D1B1B1B1D2024282C30333637
36363432312F2F2F30323436383B3D3E404142434547494C
4F53575A5D60626465656565656565666667686A6B6D6E70
7173747677797A7B7C7D7D7D7D7C7A7875726E6A6764615E
5C5B5A595857555452504D4B4946444341403F3D3C000000
0000000000000000
0000000000000000000022201F1E1F2123272B2F3336393A
3A39373634333233333537393B3D3F404142434446474A4D
5054585C5F6265666767676766666666666768696A6B6D6E
707173747677797A7C7D7E7F7F7F7E7C7976726F6B686562
605F5E5C5B5A59575553514F4D4B4947454442403F000000
0000000000000000
00000000000000000026252322222324272B2F33363A3C3D
3D3C3B3A3837373737383A3C3E3F41424343444546484B4E
5155595D61646768696969686767666666666768696A6B6C
6E6F7072747577797B7D7F818182817F7D7A76736F6C6866
646261605E5D5C5B59575553514F4D4B49474543413E0000
0000000000000000
000000000000000000292826262626282B2F32363A3D3F40
40403F3E3C3B3B3B3C3D3E3F414243444445454647494B4E
52565B5F6366686A6B6B6A6968676766666666676768696A
6B6C6E6F717376787B7D808283848482807D7A76726F6C69
6765646261605F5E5C5B59575553514F4D4B484643400000
0000000000000000
00000000000000002C2C2B2A292A2A2C2F32363A3D404243
4443434241404040404142434445464647474748494A4C50
53575C6064676A6C6C6C6C6B6A6867666665656566666768
696A6C6D6F7274777A7D80838586868583807D7975716E6B
69676665646362605F5E5C5A58565452504D4B4845413E00
0000000000000000
00000000000000002F2E2E2D2D2D2E303336393D40434546
47474746464545454546464748484949494949494A4C4E51
55595D6266696C6D6E6E6D6C6B6A68676665656565656566
67686A6C6E7073777A7E81848687888785827E7A77736F6D
6A6967666564646261605E5D5B595755524F4C4946423E00
0000000000000000
0000000000000031323131313131323436393C3F42454749
4A4B4B4B4B4B4A4A4A4A4B4B4B4B4B4B4B4B4B4C4C4E5053
575B5F64676B6D6F70706F6E6D6B6A686766656464646465
6667696B6E7174777B7F82858789898886837F7B7773706D
6B696867666665646361605E5C5A585653504D4A46423E3A
0000000000000000
00000000000000343535343434343537393B3E414447494B
4D4E4F4F50505050504F4F4F4E4E4E4D4D4D4E4E50515457
5A5E62666A6D6F71727271706F6E6C6A6867666464636464
6667696C6F7275797D8083868889898886837F7B77736F6D
6B696867666665646362605F5D5B585653504C4945423E39
0000000000000000
000000000000003838383837373738393B3E404346494B4D
50515354555656565555545352515050505051525355585B
5E6265696C6F71737374737372706E6C6A69676564646465
66686B6E7175787C7F838588898A898885827E7A75716E6B
69686767666665646362605E5C5A5755524F4B4844403D39
0000000000000000
0000000000003A3B3B3B3B3A3A3A3B3C3D3F4244474A4D4F
525557595A5C5C5C5B5A59575654545353545556585A5D60
6366696C6F717374757676757573726F6D6B696766656566
686B6E7175787C80838588898A8A898784807C78736F6C69
686766656565646362615F5D5B595653504D4946433F3C38
3500000000000000
0000000000003D3E3E3E3E3D3D3D3D3E3F414346484B4E51
55585B5E6061626261605E5C5A59585757585A5B5D606265
686A6D6F717375777878797878777573716E6C6968676768
6A6D7175797D808486888A8B8B8A8886827E7A76716D6A67
666564646464636361605E5C5A5754514E4B4844413E3B38
3500000000000000
0000000000404142424141403F3F3F4041424447494C5053
575B5F626567696968666462605E5D5C5D5E5F616366686B
6D6F7173757678797A7B7C7C7B7B797774726F6C6B6A6A6B
6E7175797D8185888A8B8C8C8B8A8884817C78736F6B6865
6463636363636362615F5D5B585653504C494643403D3A38
3634000000000000
00000000004344454544434242414142424446484A4E5155
5A5E63676A6D6F6F6F6D6B6967656463646566686A6D6F71
7274757678797A7C7D7E7F7F7F7F7E7C797673706E6D6D6F
7175797E8286898C8D8E8E8D8C8A87837F7A76716D696664
6262626262626262605F5D5A5855524F4C4945423F3D3A38
3735000000000000
00000000004647474747464544434343444547494C4F5357
5C61666B6F73757676767472706F6D6D6D6E6F7172747577
7879797A7B7C7D7E80818283848483817E7B787573717173
76797D82868A8D8F90908F8E8C8986827D7974706B676563
6161616262626262615F5D5B5855524F4C494643403E3B3A
3837000000000000
0000000048494A4A49494847464545454647494B4E51555A
5F656A6F74787C7E7F7F7E7E7C7B7A7A797A7A7B7B7C7C7D
7D7D7E7E7E7F8082838586888989888684817E7B78777678
7A7E82868A8E90929292918F8C8985817D78746F6B676463
626262626363646362615F5C5A5754514E4B484543403E3C
3B3A3A0000000000
000000004A4B4C4C4B4A49484847474748494B4D5054585D
62686E73797E8285888A8B8B8B8B8B8A8988878685848383
828282828283848587898B8C8E8E8E8C8A8784817F7D7C7D
7F82868A8D9092939393918F8C8985817D7874706C686664
6363646465656665656362605E5B5856534F4C4947444240
3F3E3D0000000000
000000004B4C4D4D4D4C4B4A494848494A4B4D5053575C60
666B71777D82888D9195989B9C9D9D9C9B989693908D8A88
87868585858687898B8D8F9193949493918E8B8886848383
85878A8D8F9293949493918F8C8985817D7975716E6B6867
66666667686869696867666563615E5B5855524F4C494745
4342410000000000
000000004C4D4E4E4E4D4C4B4A4A4A4A4C4D5053565B5F64
696F747A81878D949BA1A6ABAFB1B1B0AEAAA5A09B96918E
8B8A8989898A8B8D8F929496999A9A9A989693908E8B8A8A
8B8C8E8F919393949392908E8C8986827F7B7774706E6C6A
6A696A6A6B6C6C6C6C6C6B6A69676562605D595653504D4A
4847450000000000
0000004B4D4E4E4E4E4D4D4C4B4B4B4C4D4F52565A5E6267
6C72787E848B939BA4ACB4BBC1C4C6C4C1BBB4ADA69E9893
908E8C8C8C8D8F919396999B9EA0A1A09F9D9B9895939190
909091929393939392918F8D8B898683807D797674716F6E
6D6D6D6E6F6F7071717171706F6E6C6A6764615D5A575350
4E4B494800000000
0000004C4D4E4F4F4E4E4D4C4C4C4C4D4F5154585C61666A
6F757A80878F98A2ACB7C1CBD2D7D9D7D3CCC3B9B0A79F98
9491909090919395989B9DA0A3A5A6A7A6A4A2A09D9B9897
9695949494939392918F8E8C8B898684817E7C7977757372
717171727273747575767676767574726F6C6865615D5A56
53504E4B00000000
0000004C4D4E4F4F4E4E4D4C4C4C4D4E5053565A5F64686D
72777D838A929CA7B4C0CDD8E1E7E9E8E2DAD0C4B9AEA59D
98959493949597999C9FA2A5A8AAACADACABA9A7A5A29F9D
9B999896959392918F8E8D8B8A88868482807E7B79787675
75757575767777797A7B7B7C7C7C7A7976736F6C68635F5C
5855514F00000000
0000004C4D4E4E4E4E4E4D4C4C4C4D4E5053575C60656A6F
74797F858C95A0ACBAC8D5E2ECF3F6F4EEE5D9CDC0B4AAA2
9C99979798999B9EA0A3A6A9ACAFB1B2B2B1B0AEABA9A6A3
A09D9B989693918F8E8C8B8A8988868483817F7D7B7A7978
78777878797A7B7C7D7F80818181807E7C7975716D696460
5C58555200000000
0000004C4D4E4E4E4E4D4D4C4C4C4C4E5054575C61666B70
757B81878F98A3B0BECDDBE8F2F9FCFBF4EBDFD2C5B9AEA6
A09D9B9B9C9D9FA2A4A7AAADB0B3B5B6B7B6B5B3B1AEABA8
A5A19D9A9793918E8C8B8A888786858482817F7D7C7B7A7A
79797A7A7B7C7D7F8082838485858482807D7975716C6863
5F5B575400000000
0000004D4D4E4E4E4D4D4C4B4B4B4C4D5053575B60666B70
767C8289919AA5B2C0CEDCE9F3FAFDFBF5ECE1D4C8BCB1A9
A4A19F9FA0A1A3A6A8ABAEB0B3B6B8B9BABAB9B8B6B3B0AC
A8A4A09C9894918E8B8A888786858382817F7E7D7C7B7A7A
7A7A7B7B7C7D7F808284858687878685827F7B77736E6A65
615D595500000000
00004D4D4E4E4E4E4D4C4B4A4A4A4B4C4E51555A5F646A70
767C838B939CA7B3C0CEDAE5EFF5F7F6F1E8DED3C8BDB4AD
A8A5A4A3A4A5A7AAACAEB1B3B6B8BABCBDBDBCBBB9B7B3B0
ACA7A29E9995918E8B898785848281807E7D7C7B7A797979
797A7A7B7C7E7F818284868787878685827F7B77736E6A65
615D5A5653000000
00004E4E4E4E4E4D4C4B4A494949494A4C4F53575C62686E
757C848C959EA8B3BFCAD5DFE6ECEEECE8E1D9CFC6BDB5AF
ABA9A8A8A8AAABADAFB1B3B6B8BABCBDBEBEBEBDBBB9B6B2
AEA9A49F9A96918E8A88858382807F7D7B7A797877777677
7778797A7C7D7F808284858686868583807D7A76716D6965
615D5A5654000000
00004E4E4E4E4E4D4C4B4A48484748494B4D51555A5F666D
747C848D969FA9B2BCC5CED5DBDFE0DFDCD7D1C9C2BCB6B1
AEADACACACAEAFB1B3B4B6B8BABCBDBFBFC0BFBEBDBBB8B4
B0ABA6A19B96928E8A878482807E7C7A7877757474737374
757677797A7C7E7F81828384848382807D7A77736F6B6763
5F5C595654000000
00004F4F4F4E4E4D4C4A494847464647494B4E52575D636B
737B848D97A0A8B1B8BFC5CACED1D1D1CECBC7C3BEBAB6B3
B1B0B0B0B0B1B3B4B6B7B9BABCBDBFBFC0C0C0BFBDBBB8B5
B0ACA7A19C97928E8A8683807E7B79777573727070707070
72737576787A7C7D7F80808181807E7C7A76736F6B686460
5D5A585553000000
00004F4F4F4E4E4C4B4A48474645454647494C50555B6169
727B848E979FA7AEB4B8BCBFC1C2C2C2C1BFBDBBB9B7B5B4
B3B3B3B3B4B5B6B7B9BABBBDBEBFC0C0C1C1C0BFBDBBB8B5
B1ACA7A29D97928E8A86827F7C79767472706E6D6C6C6C6D
6E7072747677797B7C7D7D7D7D7C7A7875726F6B6864615E
5B58565453000000
00004F4F4F4E4D4C4B4947464545454546484B4F53596068
717A848D969EA5ABAFB1B3B3B4B4B3B3B3B3B4B4B4B4B4B4
B5B5B6B6B7B8B9BABCBDBEBFC0C0C1C1C1C1C0BEBDBAB7B4
B0ABA7A19C97928E8985817E7A7774726F6D6B6968686869
6A6C6E70727476777879797978777573716E6A6764605D5B
5856555352000000
00004F4F4F4E4D4C4A4947464544444546484B4F53595F67
707A838D959DA3A7A9AAAAA9A8A7A7A7A8A9ABADAFB1B3B4
B6B7B8B9BABBBCBDBEBFC0C1C2C2C2C2C1C0BFBDBBB9B6B2
AEAAA5A09B97928D8985817D7A7673706D6A686665646465
66686A6C6E707274747575757472716F6C696663605D5A58
5654535251000000
00004F4F4E4E4D4B4A4847464545454547494C4F54596068
7079828B939A9FA3A4A4A3A1A09E9E9EA0A2A5A8ACAFB2B4
B6B7B9BABBBDBEBFC0C2C3C3C4C4C3C3C2C0BEBCBAB7B3B0
ACA8A39F9A95918C8884807D7976726F6C69666462616161
626466686A6C6E6F707070706F6E6C6A6765625F5C5A5755
5452515150000000
00004E4E4E4D4C4B4A48474645454647484B4E51565B6169
7179828A91979C9E9F9E9D9B999897989A9DA1A5A9ACB0B3
B5B7B9BBBCBEBFC1C2C4C5C6C6C6C5C4C2C0BEBBB8B4B0AD
A9A5A09C9894908B8884807D7976726F6B686562605E5E5E
5E6062636567696A6B6B6B6B6A69686663615E5C59575553
5251504F4F000000
00004E4D4D4D4C4B4A484747464647484A4D5054585E646A
727981888E9397999A99989695949394979A9EA2A6AAAEB2
B4B7B9BBBDBFC1C3C4C6C7C8C8C8C7C5C3C0BDB9B5B1ADA9
A5A19D9995928E8A8784807D7A77736F6C6864615E5C5B5A
5B5C5D5F616264656666666665646362605D5B5956545251
504F4E4E4E000000
00004D4D4C4C4B4B4A4948484748494A4D5053575C61666C
73797F858B8F9294959493929191919295989CA0A4A8ACB0
B3B6B8BBBDBFC2C4C6C8CACBCBCBCAC7C4C1BCB8B3AEAAA5
A19D9A9693908C898683817E7B7874706C6864605D5B5958
5758595A5C5D5E606061616161605F5E5C5A58565452504F
4E4E4D4D4D000000
00004C4C4C4C4B4B4A494949494A4B4D5053575B5F64696E
74797E83878A8D8F8F908F8F8F8F8F9193979A9EA2A6AAAE
B1B4B7BABDBFC2C5C8CACCCDCECECCC9C6C1BCB6B1ABA6A1
9D9A9693908D8B888683817E7C7975726D6965605D595755
545455565758595A5B5B5C5C5C5B5B5A5857555352504F4D
4D4C4C4C4B000000
00004B4B4B4C4B4B4B4A4A4A4B4C4D5053565A5E63676C70
74787C80838688898A8B8B8C8C8D8E909295999CA0A4A8AC
AFB3B6B9BCBFC3C6C9CCCFD1D2D1CFCCC8C2BCB5AFA9A39E
999693908E8C8A888684827F7D7A77736F6A65615C595653
52515151525354545556565757575756555452514F4E4D4C
4B4B4A4A4A000000
00004A4B4B4C4C4C4C4C4C4C4D4E505256595D62666A6E72
75787A7D7F81828485868788898B8C8E9194979A9EA2A6AA
ADB1B5B8BCBFC3C7CBCFD2D5D6D6D4D0CBC4BDB5ADA6A09A
9693908E8C8A8987868482807E7B7874706B66625D595552
504F4E4E4E4E4F4F50515152535353535251504F4D4C4B4A
4949494848000000
0000494A4B4C4C4D4D4D4E4E4F505255585C6064686C7072
7577787A7B7C7D7E8081838486888A8C8F9195989C9FA3A7
ABAFB3B7BBC0C4C9CED2D6D9DBDBD9D5CFC7BFB6ADA59D97
93908D8C8A898887868583817F7C7975716D68635E5A5652
504D4C4B4A4A4A4A4B4C4D4E4F4F50504F4E4D4C4B4A4948
4847474747000000
0000004A4B4C4D4E4F4F5050525355585B5F63676A6E7173
74757677777878797B7C7E80828486898B8E9195999DA1A5
A9ADB2B6BBC0C5CBD1D6DBDFE2E2E0DBD4CCC2B7ADA49C95
918E8C8A8A89898887858482807D7A76726E6A65605B5753
504D4B49474646464748494A4B4C4D4D4D4C4B4B4A494847
4645454500000000
0000004A4B4D4F50515152535456585A5D6165686C6E7172
73747473737374747577797B7D7F8284878A8D9195999EA2
A7ACB1B6BBC0C6CDD4DBE1E6E9EAE8E2DAD1C5BAAEA39A94
8F8C8B8A8A8A898988868482807D7A7773706B67625E5955
514D4A47454343424344454648494A4B4B4A4A4948474645
4443434200000000
000000494C4E50525354555657585A5C5F6366696C6E7071
72717170706F6F6F70727375777A7C7F8285898D91969BA0
A5AAAFB5BAC1C7CFD7DFE6ECF0F1EFE9E1D6C9BCAFA49A93
8E8B8A8A8A8A8A8A89878583807D7B7774716D6965615C57
534E4A474341403F3F404244454748494949484746454443
4241414000000000
000000494C4F515355565758595A5C5E6164676A6C6E6F70
706F6E6D6C6B6B6B6C6D6E70727476797D8084898E93989D
A3A8AEB3B9C0C8D1DAE2EAF1F6F8F6F0E6DBCDBFB1A49A92
8D8B8A8A8B8B8C8B8A888583807D7A7875726F6C68645F5A
55504B46423F3D3C3D3E3F41434546474747474645444342
403F3E3E00000000
000000494D5053555758595A5B5D5E606365686A6C6D6E6E
6E6D6C6A696867676768696A6C6E7174777B80858A8F959B
A0A6ACB2B8BFC8D1DBE5EEF5FBFDFBF5EBDED0C1B2A59A92
8D8A8A8A8B8C8D8C8A8885827F7D7A777573716E6B67625D
58524C47423E3B3A3A3B3D3F414344454646454443424140
3F3D3C3C00000000
000000494D515457595A5C5D5D5F60626466686A6B6C6D6C
6C6A6967666564636363646667696C6F73777B81868C9298
9EA3A9AFB6BEC6D0DBE5EFF7FDFFFEF8EEE1D2C2B3A59991
8C8A8A8B8C8D8D8D8B8885827F7C7977757472706D6A6560
5A544D47413D3A3838393A3C3F414244444444434241403E
3D3C3B3A00000000
000000004E5255585A5C5D5E5F606163646668696A6B6B6A
69686665636260605F6060616365676A6E73777D83898F95
9BA0A6ACB3BBC3CDD8E3EDF6FCFFFEF8EEE1D2C2B2A49991
8C8A8A8B8C8D8E8D8B8885817E7B7876757473716F6C6862
5C554E47413C39373637383A3D3F40424242424141403E3D
3C3A390000000000
000000004F5356595C5D5E5F606162636466676869696968
67666462605F5D5D5C5C5C5D5F6163666A6F747A80868C92
979DA3A9AFB6BFC9D3DEE8F1F7FAF9F4EADECFC0B1A39890
8C8A8A8B8C8D8D8C8A8783807C79777675747372706D6964
5D564F48413C3835353536383A3C3E3F4040403F3F3E3D3C
3A39380000000000
000000004F54575A5C5E5F60616162636465666768686766
656361605E5C5B5A5959595A5B5D6063676C71777D83898F
94999EA4AAB0B8C2CCD6E0E8EEF1F0EBE3D7CABCAEA19790
8B89898A8B8C8C8B8985827E7B78767474737372706E6A65
5E574F48413B373433333436383A3B3C3D3D3D3D3D3D3C3B
3A39380000000000
000000005054585B5D5E5F60616162626364656666666564
63615F5D5C5A595757565657585A5D6064696E747A80868B
90959A9EA3A9B0B9C2CBD4DBE1E4E3DFD8CEC2B5A99E958E
8B8988898A8A8A898683807C7976747372727271706D6A64
5E574F48413B373432323334353738393A3A3B3B3B3B3A3A
3938370000000000
000000000054585B5C5E5F5F606061616263646464646462
615F5D5B5A5857555554545556585A5E62676C72787D8388
8C9094989CA1A7AEB6BEC5CCD1D4D3D0CAC2B8AEA39A928D
8A8887878888878683817D7A77747271717070706E6C6863
5D564F48413B363331303131323335363737383839393939
3838000000000000
000000000054585A5C5D5E5E5F5F60606162626363626261
5F5D5C5A58565554535252535456585C60656A6F757B7F84
888B8E9194989DA2A9AFB5BBBFC1C1BFBAB4ADA59D958F8B
8886868585858482807D7A777472706F6F6E6E6D6C6A6661
5C554E47413B3633302F2F2F2F3031323334353536373737
3737000000000000
00000000005457595B5C5D5D5D5E5E5E5F6060616160605F
5D5C5A5857555452525151515254575A5E63686D73787C80
8385888A8C8F92969B9FA4A8ACAEAEADAAA6A09B95908C89
868584838382817F7C7A7774726F6E6C6C6B6B6A6967635F
5A544D47403B3632302E2D2D2D2D2E2E2F30313233343536
3637000000000000
00000000000056585A5A5B5B5C5C5C5D5D5E5E5F5F5E5E5D
5C5A59575554535151505050515355585C61666B7074787B
7E808182838587898D909396999B9B9B999794918E8B8886
848381807F7E7D7B787673716E6C6A69696867676563605C
57524C46403B36322F2D2C2B2A2A2A2B2C2D2E2F30323334
3500000000000000
00000000000055565859595A5A5A5A5B5B5C5C5D5D5D5C5B
5A5957565553525150504F50505254575B5F64696D717577
797A7A7A7B7B7C7D7F8183858788898A8A89888786848382
81807F7D7C7B797774726F6D6A68676665646362615F5C59
544F4A443F3A36322F2C2B292828282828292A2C2D2E3031
3300000000000000
00000000000000545656575758585859595A5A5B5B5B5B5A
595857555453525150504F4F505154565A5E62666A6E7072
7373737272717171727374757778797B7C7C7D7E7E7E7E7E
7D7C7B7A78777572706E6B6966646261605F5F5E5C5B5855
514D48433E3935312E2C2A282726252525262728292B2C2E
0000000000000000
000000000000005253545555565656575858595959595959
58575655545352515050505050515356595D6064676A6C6D
6D6D6C6A69686767676768696A6B6C6E7072737576777879
797877767573716E6C696764615F5D5C5B5A595957565451
4D4A45413C3834312E2B292725242323232323242526282A
0000000000000000
000000000000004F50515253545455555657575858585858
57565655545352525151515151525356585B5E6164666767
67666462615F5E5D5D5D5D5E5F61626466696B6D6F717273
73737372716F6D6A6865625F5C5A58565555545352514F4D
4A46423F3B3733302D2B2826252322212020202021222325
0000000000000000
00000000000000004D4F5051515253545455565657575757
56565555545453535252525252535456585A5C5F60626262
615F5D5B595755545454555657595B5D5F616466686A6C6D
6E6E6E6D6C6B696664615D5A575452514F4F4E4E4D4C4B48
4643403C3935322F2D2A2826252321201F1D1D1C1C1D1E00
0000000000000000
00000000000000004A4C4D4E4F5051525354555556565656
5656555555545454535353535354545657595A5C5D5D5D5C
5B585654514F4E4D4D4D4E4F51535557595B5E6062636566
6768686868676562605C5955524F4C4B4A49484848474644
423F3D3A3734312E2C2A28262523211F1D1B1A1918181900
0000000000000000
000000000000000000494A4C4D4F50515253535455555555
555555555555555554545454545555565758585959595857
55524F4D4A4847464647484A4C4E50525456585A5B5D5E60
616263636362615E5B5854504D4947454443434343424140
3E3C3A3734322F2D2B2A28272523211F1C1A171514130000
0000000000000000
00000000000000000046484A4B4D4E4F5051525353545455
555555555656565656565656565656565656565656555452
4F4C49464442414041424446484A4D4F5052535455565859
5B5C5D5E5E5E5C5A57534F4B4744413F3E3E3E3E3E3E3D3C
3B39373532302E2C2B2A28272523211E1B181513110F0000
0000000000000000
000000000000000000004547494B4C4E4F50515152535354
545555555656565757575757575756565655555453514F4D
4A4744413E3D3C3B3C3E404245474A4B4D4E4E4F50505153
5456585959595856534F4B47433F3C3A39393939393A3939
38363432312F2D2C2B2A29282624221F1B1814110E000000
0000000000000000
00000000000000000000434547494A4C4D4E4F5051525253
54545555565657575858585858575756555453514F4D4B48
45423F3C3A383738393A3D3F42444648494A4A4A4A4B4C4D
4F505253545453514E4A46423E3B38363535353536363636
353432312F2E2C2B2B2A29282725221F1B1714100D000000
0000000000000000
0000000000000000000000434547484A4B4C4D4E4F505152
525354555656575858585959585857565453514E4C494744
413E3B383635343536383A3C3F4143444546464545464647
494B4D4E4F4F4E4C4A46423E3A3734333232323333343434
333231302E2D2C2B2B2A2A29282623201C18141000000000
0000000000000000
00000000000000000000000043454648494A4B4C4D4E4F50
5152535455565758585959595958575553514F4C49464340
3D3A3735343232323435373A3C3E40414142414141414243
444647494A4A494845423E3A373431302F2F303031323232
3231302F2E2D2C2C2B2B2B2A292725211D19150000000000
0000000000000000
000000000000000000000000414344454648494A4B4C4D4E
50515253545556575859595959585655524F4C494643403C
3A3735333231313132333537393B3C3D3D3E3D3D3D3D3D3E
4041434445454443403D3A3734312F2E2E2E2E2F30313131
3130302F2E2D2C2C2C2C2B2B2A2826221F1B160000000000
0000000000000000
0000000000000000000000000041424344454648494A4B4D
4E505152535556575858595958575653514E4A4743403D3A
3735333231303030313233353638393A3A3A3A3A39393A3A
3B3D3E3F3F403F3E3C393734312F2D2D2C2D2D2E2F303131
31302F2F2E2D2D2C2C2C2C2B2A292724201C000000000000
0000000000000000
000000000000000000000000000040414243444647484A4B
4D4E50515354555657585858575654524F4C4844413D3A37
353332313030303030313233343536363737373636363637
3838393A3A3A3A39373533312F2D2C2B2C2C2D2E2F303031
3030302F2E2E2D2D2D2D2C2C2B2927252100000000000000
0000000000000000
0000000000000000000000000000003F404142444547484A
4B4D4F505253545556575757565553504D4A46423F3B3836
343231303030303030313132333334343434343433333334
34343535353535343331302E2D2C2B2B2B2C2D2E2F2F3030
3030302F2E2E2D2D2D2D2C2C2B2A28250000000000000000
0000000000000000
0000000000000000000000000000003D3E3F414244454748
4A4C4E4F51525454555555555452504E4B4744403D393734
333231303030303030313131313131323232313131313131
313131313130302F2E2D2C2C2B2A2A2A2B2C2D2E2F2F3030
3030302F2F2E2E2D2D2D2C2C2B2A28260000000000000000
0000000000000000
000000000000000000000000000000003D3E3F4142444648
4A4C4D4F515253545454535351504E4B4845423E3B383634
333231313131313130303030303030303030302F2F2F2F2E
2E2D2D2C2C2B2B2A2A2A29292929292A2B2C2D2D2E2F3030
30302F2F2E2E2D2D2D2C2C2B2A2927000000000000000000
0000000000000000
00000000000000000000000000000000003D3F4042444547
494B4D4F51525253535251504E4C4A4745423F3D3A383634
33323231313131313030302F2F2F2E2E2E2E2E2E2E2D2D2C
2B2A292827272626262626272728292A2B2C2C2D2E2F2F2F
2F2F2F2E2E2D2D2C2C2B2A29282700000000000000000000
0000000000000000
0000000000000000000000000000000000003E4042434547
494C4E4F5152525251504F4D4B484644413F3D3B39383635
343332323231313130302F2F2E2E2D2D2D2D2D2C2C2C2B2A
2827252423222121222324252627292A2B2B2C2D2D2E2E2E
2E2E2E2E2D2D2C2B2A2A2928260000000000000000000000
0000000000000000
000000000000000000000000000000000000004042434548
4A4C4E5051525251504E4C49474442403E3C3B3A39383736
3534333332313130302F2F2E2D2D2C2C2C2C2C2B2B2A2928
262422201F1D1D1D1E1F2123242628292A2B2C2C2C2D2D2D
2D2D2D2D2C2C2B2A29282625000000000000000000000000
0000000000000000
000000000000000000000000000000000000000042444648
4A4C4E50515251504E4C494642403D3B3A39393939383837
36353433323131302F2E2E2D2D2C2C2B2B2B2B2A2A292726
23211F1C1B1919191A1C1E21232527292A2B2B2B2B2B2B2B
2B2C2B2B2B2A292827262400000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000444648
4B4D4F505151514F4C4946423E3B39373737373839393939
383735343331302F2E2E2D2C2C2B2B2B2A2A292928272624
211E1C191716151617191C1F22242628292A2A2A2A2A2A2A
2A2A2A2A2A29282725230000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000004649
4B4D4F505151504D4A46423E3B37353434353637393A3A3A
393836353331302E2E2D2C2C2B2A2A2A2929282827262421
1F1C1916141212121416191D202325272829292929282828
282829282827262523000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000049
4B4D4E4F504F4E4B48443F3B3734323131333437383A3B3B
3A39373533312F2E2D2C2B2B2A2A2929282827262523221F
1C19161311100F101214171B1E2124262727282727272727
272727272726252300000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
4B4C4D4E4E4D4C4945413D383531302F30313436383A3B3B
3A39373432302E2D2C2B2B2A2A2929282726252423211F1C
1A1714110F0D0D0E0F1215181C1F21232525262625252525
252626262525230000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
004B4C4C4C4A4846423E3A3633302E2E2F313336383A3B3B
3A383634312F2D2C2B2B2A2A2929282726252322201E1C19
1714110F0D0C0C0C0E101316191C1E202223232324242424
242525252423000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
00000049484745423F3B3835322F2E2E2F31333537393A3A
39373533312E2D2B2B2A2A2A292928262523211F1D1B1816
14110F0D0C0B0B0B0D0F111316191B1D1E20202122222223
232424240000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000004543413E3B39363331302F2F3031333537383939
383634322F2D2C2B2A2A2A292928272624211F1C1A171512
100F0D0C0B0B0B0B0C0D0F11131517191B1C1E1F20202122
222323000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000000003C3A38363433313030303132333536373737
363432302E2C2B2A2A2A292929282725221F1C191613110F
0D0C0B0B0B0B0B0B0C0D0E0F1012131517191A1C1E1F2021
220000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000003635343332323131323233343535363635
3433312F2D2C2A2A2929292929282624211D1A1613100D0B
0A0A0A0A0B0B0C0C0C0C0D0D0D0E10111315171A1C1D1F20
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000323232323233333434343535353434
3331302E2C2B2A2929292929282725231F1B17130F0C0A08
0808090A0B0C0D0D0D0C0C0B0B0C0C0E101215171A1C0000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000032333434353535353534343332
31302F2D2C2B2A2929292928282624211D1915100C090706
0607080A0C0D0E0E0E0D0C0B0A0A0A0B0D10121500000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000003436363636363534343332
31302F2D2C2B2A29292828272625221F1B17120E0A070504
0506080A0D0F10100F0E0C0B0909090A0B0E000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000373737363535343332
31302F2E2C2B2A29292827262523201D1914100B08050303
0406080B0E101112110F0D0B0A0908090000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000037373635343433
3231302F2E2C2B2A2927262423201D1A16120D0906030202
0406090C0F11131313110F0D0B0A00000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000036353534
333231302F2D2C2A29272523201E1B17130F0B0805030203
04070A0D1013151515131100000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
35343332312F2D2B292624211E1B1814100D0A0704030304
06080C0F1215160000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000032312E2C2926221F1C1815110E0B080604030405
070A0D000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000000F0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.0055371 0.732558 0.227021 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -59 0 ]
[.5 1.0125 59 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -120 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(defect) show
105.000000 13.000000 moveto
(Sample) show
147.000000 13.000000 moveto
(Photo) show
177.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000001B0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000001F1F1F1F1F1F1E1E1D1D1C1B1A19181716161514
141414000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
1F1F1F1F1F1F1F1F1E1E1E1E1D1C1C1B1A19181716151413
131312121313140000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000001D1E1E1E
1E1E1E1E1E1E1E1E1E1E1D1D1C1C1B1A1918171615141312
121111111112121314161700000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000000000000000001C1C1D1D1D1D1E
1E1E1E1D1D1D1D1D1C1C1C1C1B1B1A191817161514131211
101010101010111213141617181A00000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000000000000000000000000001B1C1C1C1C1D1D1D1D
1D1D1C1C1C1B1B1B1B1A1A1A191918171615141312111010
0F0F0F0F0F0F1011121314161718191A0000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000001C1C1C1C1C1C1C1C1C1C1C
1C1B1B1A1A191919181818171716161514131211100F0F0E
0E0E0E0E0E0E0F1011121315161718181919000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
00000000000000000000001D1D1D1D1D1D1D1C1C1C1C1B1B
1A1A19191817171616151515141413121211100F0F0E0D0D
0D0D0D0D0D0E0E0F10111213141516171717171700000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
00000000000000000020201F1F1F1E1E1E1D1D1C1C1B1B1A
191818171615141413131212121111100F0F0E0E0D0D0C0C
0C0C0C0D0D0E0E0F10111213131415151515151616160000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000000000023232222212120201F1E1E1D1D1C1B1A19
1817161514131212111110100F0F0F0E0E0D0D0C0C0C0C0C
0C0C0C0D0D0E0E0F10111112131314141414141414151516
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000262525242323222221201F1F1E1D1C1B1A19
1816151413121110100F0F0E0E0D0D0D0D0C0C0C0C0C0C0C
0C0D0D0D0E0E0F1010111112121313131313131313141415
160000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000000028282727262625242423222121201F1E1C1B1A19
18161514131110100F0E0E0D0D0D0D0D0C0C0C0C0C0C0D0D
0D0E0E0F0F10101111121212131313131313131313141415
161819000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000002A2A29292828272726252424232221201F1D1C1B1A
1817161413121110100F0E0E0E0E0E0D0D0D0E0E0E0E0E0F
0F1010101111121212131313131314141313131414141516
17191B1C0000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
002C2C2B2B2A2A292928282726252524232221201F1E1D1B
1A1917161514131211111110101010101010101011111112
121213131313141414141415151515151515151515161718
191B1D1E2022000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
2D2D2C2C2B2B2A2A29292828272626252424232221201F1E
1C1B1A191817161515141414141313141414141415151515
15161616161616161616161717171717171717171818191A
1C1D1F212325270000000000000000000000000000000000
0000000000000000
00000000000000000000000000000000000000000000002E
2E2D2D2C2C2B2B2A2A292928282727262625242423222120
1F1E1D1C1B1A1A1919181818181818181819191919191A1A
1A1A1A1919191919191919191919191919191A1A1B1B1C1E
1F21222426282A2B00000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000002F2E
2E2D2D2C2C2B2B2A2A292929282827272726262625252423
222221201F1F1E1E1D1D1D1D1D1D1D1D1E1E1E1E1F1F1F1F
1E1E1E1E1D1D1D1C1C1C1C1C1C1C1C1C1D1D1D1E1E1F2021
23242627292B2C2E2F000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000002F2F2E
2E2D2D2C2C2B2B2A2A292929292828282828282727272726
262524242323222222222222222223232324242424242424
242323222221212020202020202020202020212122232425
27282A2B2D2E2F3132330000000000000000000000000000
0000000000000000
00000000000000000000000000000000000000002F2F2F2F
2E2E2D2C2C2B2A2A2A292929292929292929292929292929
2828272727262626262627272728282929292A2A2A2A2A2A
292928272626252424242424242424242425252626272829
2B2C2D2F3031323334353500000000000000000000000000
0000000000000000
000000000000000000000000000000000000002F2F2F2F2F
2E2E2D2D2C2B2B2A2A2A2A2929292A2A2A2A2A2B2B2B2B2B
2A2A2A2A2A292A2A2A2A2B2B2C2D2D2E2F2F303030303030
2F2F2E2D2C2B2A2A292928282828282929292A2A2B2C2D2E
2F3031323334353636373737000000000000000000000000
0000000000000000
0000000000000000000000000000000000002F2F2F2F2F2F
2F2E2E2D2C2C2B2B2A2A2A2A2A2A2A2B2B2B2B2B2C2C2C2C
2C2C2C2B2B2C2C2C2D2D2E2F303132333434353636363636
363534333231302F2F2E2E2E2E2E2E2E2E2E2F2F30303132
333435363737383839393938380000000000000000000000
0000000000000000
00000000000000000000000000000000002E2F2F30303030
2F2F2E2E2D2D2C2C2B2B2B2B2B2B2B2B2C2C2C2C2C2C2C2C
2C2C2C2C2C2C2D2D2E2F30323334353738393A3B3C3C3D3D
3C3B3B3A3938373635353434343434343434343435353636
373838393A3A3A3B3B3A3A3A393800000000000000000000
0000000000000000
000000000000000000000000000000002E2F2F3030303130
30302F2F2E2E2D2D2D2D2D2D2C2C2C2C2C2C2C2C2C2C2C2B
2B2B2B2B2C2C2D2E2F3032333537383A3C3D3F4041424343
43424241403F3E3D3C3C3B3B3A3A3A3A393939393A3A3A3A
3B3B3C3C3C3D3D3D3C3C3B3B3A3938000000000000000000
0000000000000000
0000000000000000000000000000002D2E2F303031313131
31313130302F2F2F2E2E2E2E2E2E2D2D2D2C2C2C2B2B2B2A
2A2A2A2A2A2B2C2D2E30323436383A3D3F41434546484949
494949484746454544434242414140403F3F3F3E3E3E3E3E
3F3F3F3F3F3F3F3E3E3D3D3C3B3A39370000000000000000
0000000000000000
0000000000000000000000000000002D2E2F303131323232
32323231313130303030302F2F2F2E2E2D2D2C2B2B2A2929
2828282829292A2C2E30323437393C3F424447494B4D4E4F
4F504F4F4E4E4D4C4B4A4949484746464544444343434242
42424241414140403F3F3E3D3C3B3A380000000000000000
0000000000000000
00000000000000000000000000002C2E2F30303131323232
32323232323232323131313130302F2E2E2D2C2B2A292827
272726272728292B2D2F3234373A3E4144474A4D4F515354
55565656555454535251504F4E4D4C4B4A49494847464645
454444444343424141403F3E3D3C3A393800000000000000
0000000000000000
000000000000000000000000002B2D2E2F30303131323232
3333333333333333333232323131302F2E2D2B2A29282726
262525252627282A2C2F3134383B3F42464A4D5053555859
5A5B5B5B5B5B5A5958575655545351504F4E4D4C4B4A4948
47474645454443424241403F3E3C3B3A3938000000000000
0000000000000000
0000000000000000000000002A2B2D2E2F2F303131313232
3233333333333333333333323231302F2E2C2B2A28272625
25242424252628292C2E3135383C4044484B4F5356595B5D
5E5F606060605F5E5D5C5B5A585756545351504F4E4C4B4A
49484747464544434241403F3E3D3C3B3A38370000000000
0000000000000000
0000000000000000000000002A2B2C2D2E2F2F3030313131
3232323333333333333332323131302F2D2C2B2928272625
242424242526282A2C2F3235393D4145494D5154585B5D60
616263646463636261605F5D5C5A5957555452514F4E4D4C
4A49484746454544434241403F3E3D3C3A39380000000000
0000000000000000
000000000000000000000028292A2C2C2D2E2E2E2F2F2F30
30303131313232323231313130302F2E2D2B2A2928272625
252525252627292B2D3033363A3D4145494D5155595C5F61
63646565666565646362615F5E5C5A5857555352504F4D4C
4B4A494847464544434241403F3E3D3C3B3A393800000000
0000000000000000
000000000000000000002628292A2B2B2C2C2D2D2D2D2D2E
2E2E2F2F2F30303030302F2F2F2E2E2D2C2B2A2928282727
26272728292A2B2D2F3235383B3E42464A4E5255595C5F61
6364656666666665646361605E5C5B5957555452504F4D4C
4B4A48474645454443424140403F3E3D3C3B3A3937000000
0000000000000000
00000000000000000000262728292A2A2A2B2B2B2B2B2B2B
2C2C2C2D2D2D2D2E2E2E2D2D2D2D2C2C2B2B2A2A29292929
29292A2B2C2D2E303234373A3C4043464A4E5255595C5E61
6364656666666665646361605E5C5A5957555352504F4D4C
4A4948474645444443424141403F3E3E3D3C3B3938000000
0000000000000000
000000000000000000252627272828292929292929292929
29292A2A2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2A2B2B2B2B
2C2C2D2E3031323436383A3C3E4144474B4E5255585B5E60
6263656566666565646361605E5C5A5856555351504E4D4B
4A494847464544444342424140403F3E3D3C3B3A39380000
0000000000000000
000000000000000000252626272727272727272727272727
2727282828292929292A2A2A2A2A2A2A2B2B2B2C2C2D2E2E
2F303133343537383A3B3D3F414346494C4F5255585B5D60
6163646565656564646261605E5C5A5857555351504E4D4B
4A49484746454444434342414140403F3E3D3C3B3A390000
0000000000000000
000000000000000025252626262626262626262525252525
252526262727282828282929292A2A2B2B2C2D2E2F303132
33353637393A3B3D3E3F41424446484A4D505356595B5E60
6163646565656565646362605F5D5B5958565452514F4E4C
4B4948474645454443434242414140403F3E3D3C3B393800
0000000000000000
000000000000000025262626262626252525242424232323
2424252526262728282829292A2A2B2C2D2E303132343537
383A3B3D3E3F41424344454648494B4D4F5255575A5C5F61
626465656666666665646362605F5D5B5958565452514F4E
4C4B4A48474646454444434342424141403F3E3D3C3A3900
0000000000000000
000000000000002626262626262625252524242323232323
2324252526272828292A2A2B2C2D2E2F3032333537383A3C
3D3F41424445464848494A4B4C4E4F515355585A5D5F6163
6466676768686868676766656362605E5D5B595756545250
4F4D4C4A49484746454544444343424141403F3E3D3C3A38
0000000000000000
000000000000002626262626262625252524242323232323
2425252628292A2B2B2C2D2E2F3032333536383A3C3E4041
434547484A4B4D4E4E4F505152535456585A5C5F61636567
68696A6B6B6C6C6C6B6B6A696866656362605E5C5A585654
52514F4D4C4A494847464645444443424241403F3E3D3B3A
0000000000000000
000000000000002726262626262626252525242424242424
252627292A2C2D2E2F313233343637393A3C3E4042444648
494B4D4F505253545556565758595B5C5E60626466686A6C
6D6E6F70707171717170706F6E6D6B6A68666462605E5C5A
575553514F4E4C4B4948474646454443434241403F3E3D3B
0000000000000000
000000000000272727272727272726262626252525252626
27292A2C2E2F3133343637393A3C3D3F41434546484A4C4E
505153555658595A5B5C5D5E5F6061636567696B6D6F7172
73747576767777777777777675747372706E6C6A67656360
5D5B585653514F4E4C4B49484746454544434241403F3E3C
3B00000000000000
000000000000282827272727282828272727272727272829
2A2C2E30323436383A3B3D3F41424446484A4B4D4F515354
5658595B5C5E5F60616264656667696A6C6E707274767879
7A7B7C7D7D7E7E7F7F7F7F7F7E7D7C7B79777572706D6A67
64615E5B585653514F4D4B4A494847464544434342413F3E
3C00000000000000
0000000000292928282828292929292929292929292A2B2C
2D2F323436393B3D4042444547494B4D4F5152545657595B
5C5E5F616263656667696A6B6D6E70727476787A7C7E7F81
8283848485868687878888888887868583817E7C7976726F
6B6864615D5A575452504E4C4B494847464545444342413F
3D3C000000000000
00000000002A2A2929292A2A2A2B2B2B2B2B2B2B2C2D2E2F
313336393B3E414345484A4C4E5052545557595A5C5D5F60
6263646667696A6B6D6E7072737577797B7D7F8183858788
8A8B8C8C8D8E8F9091919292929291908E8C8986827F7B77
736F6B66635F5B585553504E4C4B49484746464544434240
3F3D000000000000
00000000002C2B2B2B2B2B2C2C2D2D2D2E2E2E2E2F303133
35383A3D404346494B4E50525456585A5B5D5F6061636465
6668696A6B6D6E7072737577797B7D7F818486888A8C8E90
919394959697989A9B9C9D9E9E9E9D9C9A9794918D898480
7B76716D68645F5C585553504E4D4B4A4948474645444341
403E000000000000
000000002E2D2D2D2D2D2E2E2F2F30303131313233343537
393C3F4245484B4E50535557595B5D5F6062636566676869
6A6B6C6D6F7072737577797B7E808285878A8C8E91939597
999B9C9E9FA1A3A4A6A8AAABACACABAAA7A4A19D98938E89
837E78736D68645F5C585553504E4D4B4A49484746454442
413F3D0000000000
0000000030302F2F2F30303132323334343435363738393B
3E404346494C4F525557595C5D5F616364656768696A6B6B
6C6D6E6F71727475777A7C7E818486898B8E919496999B9E
A0A2A4A7A9ABADB0B3B5B7B9BABBBAB8B6B2AEA9A49E9892
8B857F78736D68635F5B585552504E4D4B4A494846454443
41403E0000000000
000000003232323232333334353636373838393A3B3C3E40
4245484B4E505356585B5D5F606264656667696A6A6B6C6D
6D6E6F7071737476797B7E808386898C8F9295989B9EA1A4
A7A9ACAFB2B5B8BCBFC3C5C8C9CAC9C8C5C1BCB6B0A9A29B
938C857E77716B66625E5A575452504E4D4B4A4847464443
42403F0000000000
00000000353535353536363738393A3B3C3C3D3E3F404244
46494C4E515457595B5D5F616364656668696A6A6B6C6C6D
6E6E6F7071737476797B7E8184878A8E9194979B9EA2A5A9
ACB0B4B7BBBFC3C7CCD0D3D6D8D9D8D6D3CEC9C2BBB3ABA3
9B938B837C756F6964605C59565452504E4C4A4947464443
42403F0000000000
000000383737373838393A3B3C3D3E3F3F40414243454648
4A4D4F525557595C5E5F61626465666768696A6A6B6C6C6D
6D6E6F7071727476787B7E8184888B8F9295999DA1A4A9AD
B1B5BABEC3C8CDD2D7DCE0E3E6E7E6E4E0DBD4CDC5BCB3AA
A19890877F78716C66625E5B585653514F4D4B4948464443
42403F3E00000000
0000003A3A3A3A3B3C3C3D3E3F4041424344454647494A4C
4E505355575A5C5E5F6162636566666768696A6A6B6B6C6C
6D6D6E6F70717375777A7D8184888B8F92969A9EA2A6ABB0
B5BABFC4CACFD5DBE0E6EBEEF1F2F2EFEBE5DED6CDC4BAB0
A79D948B827B746D6864605C59575552504E4C4A48464443
41403F3E00000000
0000003C3C3C3D3E3E3F4041434445464748494A4B4C4E50
525456585A5C5D5F60626364656666676868696A6A6B6B6C
6C6C6D6E6F70727476797C8083878B8E92969A9EA3A8ACB2
B7BDC2C8CED4DBE1E7EDF3F7FAFBFBF8F3EDE6DDD3C9BFB5
AAA0978D847C756F6965615D5A585553514E4C4A48464442
41403F3E00000000
0000003D3E3F3F4041424344464748494A4B4C4D4E505153
5456585A5B5D5E606162636465656667676869696A6B6B6B
6C6C6C6D6E6F717375787B7F82868A8E9195999EA3A7ADB2
B8BEC4CAD0D7DEE4EBF1F7FBFEFFFFFCF8F1E9E0D6CCC1B7
ACA2988E857D766F6A65615E5B585654514F4C4A48464442
41403F3E00000000
0000003F3F4041424344454748494A4B4D4E4F5051525355
5658595B5C5D5F606162636364656666676869696A6B6B6C
6C6C6D6D6E6F717275787B7E8285898D9094989DA1A6ACB1
B7BDC3C9CFD6DDE3EAF0F6FAFDFFFEFBF7F0E8DFD6CBC1B6
ABA1978E857D756F6965615E5B585654514F4C4A48454442
41403F3F00000000
0000004040414243454647484A4B4C4D4E50515253545556
57585A5B5C5D5E5F60616263636465666768696A6B6C6C6D
6D6D6E6E6F70717375787A7E8184888B8F93979B9FA4A9AE
B4B9BFC5CBD1D8DEE4EAF0F4F7F8F7F5F0EAE3DAD1C7BCB2
A89E958B837B746E6864605D5A585653514E4C4A47464442
4140403F00000000
0000404041424344454748494B4C4D4F5051525354555556
5758595A5B5C5D5E5F6061626364656667696A6B6C6D6E6F
6F6F70707071727476787A7D8083878A8D9194989CA1A5AA
AFB4B9BEC4C9CFD5DAE0E4E8EBECECE9E5E0D9D1C8BFB5AC
A29990888078716C67625F5C59575552504E4C4947464443
4241403F3F000000
00004040414243444647484A4B4D4E4F5051525354555656
575858595A5B5B5C5D5E606162636566686A6B6D6E707171
727272727373747577797B7D808386888B8E9295999DA1A5
A9ADB1B6BABFC3C8CDD2D6D9DBDCDCDAD6D1CBC4BDB5ACA4
9B938B837B756E6964605D5A585553514F4D4B4947464443
424140403F000000
00004040414243444647494A4C4D4F505152535454555556
5657575858595A5B5C5D5E6061636567696B6D6F71727374
7575757575767677787A7C7E80828487898C8F9295989B9E
A2A5A8ABAFB2B6BABEC1C5C7C9CACAC8C5C1BCB6AFA8A19A
928B847D76706B66615E5B58555351504E4C4A4847464443
4241414040000000
00003F40404142444547484A4C4D4F505152535454555555
55565656575758595A5B5D5F616365676A6C6F7173757677
78787878787979797A7B7D7E8081838587898C8E90939598
9A9C9EA0A2A5A7AAADB0B2B4B5B6B6B4B2AFABA6A19B958F
89837D77716B66625E5B585553514F4E4C4A494846454443
424141403F000000
00003E3F404142434546484A4C4D4F505152535454555555
5555555555565657595A5C5E606365686B6E71737678797B
7B7C7C7C7C7B7B7C7C7D7E7F808182848587888A8C8E8F91
929394959697999A9C9EA0A1A2A2A2A19F9D9A96928E8984
7F7A75706B66625E5B585552504F4D4B4A49484746454443
424140403F000000
00003E3E3F4041424446484A4C4E4F515253535454555555
5454545454555556585A5B5E606366696C6F7275787A7C7D
7E7F7F7F7F7E7E7E7E7E7F7F80808182838485868788898A
8A8A8A8A8A8B8B8C8D8D8E8F8F908F8F8D8C8A8784817E7A
76726E6965615D5A5754524F4D4C4A494847464544444342
4141403F3E000000
00003D3D3E3F40424446484A4C4E50515253545555555555
555454545455555658595C5E6163676A6D7174777A7D7F80
818282828181818080808080808080808181828383838483
83828281807F7F7F7F7F7F8080807F7F7E7D7C7A78767370
6D6A6763605C595653514E4C4A4947464544434342424141
403F3F3E3D000000
00003C3C3D3E40414346484A4C4E50525354555556565656
5555555555555657585A5C5F6164686B6F7275797C7E8182
838484848483838282818180807F7F7F7F7F7F7F7F7F7F7E
7D7C7A797877767574747474737373727271706F6E6D6B69
6663615E5B5855524F4D4B49474544434241414040403F3F
3E3E3D3C3C000000
00003A3B3C3E3F414346484A4D4F51535455565757575757
57575656565757585A5C5E606366696C7073777A7D808284
858686868685848483828281807F7F7E7E7D7D7C7C7B7A79
7876757371706F6D6D6C6B6B6B6A6A6A6969686867666462
605E5B595653514E4B4947454342403F3F3E3E3D3D3D3D3C
3C3B3B3A3A000000
0000393A3B3D3F