var express = require('express')
    , http = require('http')
    , path = require('path')
    , fs = require('fs');

var app = express(),
    dataDir = './public/images/',
    users = [
        {user: "scott", password: "aaa"},
        {user: "tiger", password: "bbb"}
    ];

app.configure(function () {
    app.set('port', process.argv[2] || 3000);
    app.use(express.favicon());
    app.use(express.logger('dev'));
    app.use(express.bodyParser());
    app.use(express.methodOverride());
    app.use(express.cookieParser());
    app.use(express.session({secret: "secretcode"}));
    app.use(app.router);
    app.use(express.static(path.join(__dirname, 'public')));
});

var loginCheck = function (req, res, next) {
    if (req.session.user) {
        next();
    } else {
        res.send("auth_required");
    }
};

app.get('/auth', function (req, res) {
    res.setHeader('Content-Type', 'text/plain');
    if (req.session.user) {
        res.send("true");
    } else {
        res.send("false");
    }
});

app.delete('/auth', function (req, res) {
    res.setHeader('Content-Type', 'text/plain');
    delete req.session.user;
    res.send("true");
});

app.post('/auth', function (req, res) {
    var result = false;
    users.forEach(function (u) {
        if (u.user == req.body.user && u.password == req.body.password) {
            req.session.user = req.body.user;
            result = true;
        }
    });
    if (result) {
        res.send("true");
    } else {
        res.send("false");
    }
});

app.get('/list', loginCheck, function (req, res) {
    fs.readdir(dataDir + req.session.user + "/", function (err, files) {
        res.setHeader('Content-Type', 'application/json');
        var i;
        for (i = 0; i < files.length; i++) {
            files[i] = req.session.user + "/" + files[i];
        }
        console.log(files);
        res.send(JSON.stringify(files));
    });
});

app.post('/upload', loginCheck, function (req, res) {
    var files = fs.readdirSync(dataDir + req.session.user + "/"),
        max = 0,
        outStream;

    files.forEach(function (file) {
        max = Math.max(max, Number(file.slice(0, file.lastIndexOf('.'))));
    });
    outStream = fs.createWriteStream(dataDir + req.session.user + "/" + (++max) + '.jpeg');
    req.pipe(outStream);
    outStream.on("close", function () {
        res.send("true");
    });
});

http.createServer(app).listen(app.get('port'), function () {
    console.log("Express server listening on port " + app.get('port'));
});
