/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sfc.turtle.Line;
import sfc.turtle.LineList;
import sfc.turtle.ShapeTurtle;
import sfc.turtle.Turtle;
import sfc.turtle.TurtleAnimator;
import sfc.turtle.TurtleFrame;

class DefaultTurtle
extends ShapeTurtle {
    private static final double kameScale = 0.4;
    private static final Color kameColor = Color.green;
    private Turtle client;
    private int kameType = 0;
    private double dx = 0.0;
    private double dy = -1.0;
    private TurtleAnimator animator;
    private static final short[][] kame = new short[][]{{-12, -6, -12, 6, 0, 18, 12, 6, 12, -6, 0, -18, -12, -6}, {-18, -12, -12, -6}, {-6, -24, 0, -18, 6, -24}, {12, -6, 18, -12}, {12, 6, 18, 12}, {-6, 24, 0, 18, 6, 24}, {-18, 12, -12, 6}, {-18, 12, -18, -12, -6, -24, 6, -24, 18, -12, 18, 12, 6, 24, -6, 24, -18, 12}, {-15, -15, -18, -24, -9, -21}, {9, -21, 18, -24, 15, -15}, {15, 15, 18, 24, 9, 21}, {-9, 21, -18, 24, -15, 15}, {-3, 24, 0, 30, 3, 24}, {-6, -24, -12, -36, -6, -48, 6, -48, 12, -36, 6, -24}};
    private static final short[][] kameR = new short[][]{{-12, -6, -12, 6, 0, 18, 12, 6, 12, -6, 0, -18, -12, -6}, {-18, -12, -12, -6}, {-6, -24, 0, -18, 6, -24}, {12, -6, 18, -12}, {12, 6, 18, 12}, {-6, 24, 0, 18, 6, 24}, {-18, 12, -12, 6}, {-18, 12, -18, -12, -6, -24, 6, -24, 18, -12, 18, 12, 6, 24, -6, 24, -18, 12}, {-15, -15, -24, -18, -9, -21}, {-9, 21, -24, 18, -15, 15}, {-3, 24, -3, 30, 3, 24}, {-6, -24, -6, -36, 0, -48, 12, -48, 18, -36, 6, -24}, {9, -21, 18, -30, 15, -15}, {15, 15, 18, 30, 9, 21}};
    private static final short[][] kameL = new short[][]{{-12, -6, -12, 6, 0, 18, 12, 6, 12, -6, 0, -18, -12, -6}, {-18, -12, -12, -6}, {-6, -24, 0, -18, 6, -24}, {12, -6, 18, -12}, {12, 6, 18, 12}, {-6, 24, 0, 18, 6, 24}, {-18, 12, -12, 6}, {-18, 12, -18, -12, -6, -24, 6, -24, 18, -12, 18, 12, 6, 24, -6, 24, -18, 12}, {-15, -15, -18, -30, -9, -21}, {-9, 21, -18, 30, -15, 15}, {-3, 24, 3, 30, 3, 24}, {-6, -24, -18, -36, -12, -48, 0, -48, 6, -36, 6, -24}, {9, -21, 24, -18, 15, -15}, {15, 15, 24, 18, 9, 21}};

    DefaultTurtle(Turtle client, TurtleFrame container) {
        super(container);
        this.client = client;
        this.initializeShape();
    }

    protected void initializeShape() {
        LineList defaultTurtle = new LineList();
        for (int i = 0; i < kame.length; ++i) {
            double lastx = (double)kame[i][0] * 0.4;
            double lasty = (double)kame[i][1] * 0.4;
            for (int j = 2; j < kame[i].length; j += 2) {
                defaultTurtle.add(new Line(lastx, lasty, (double)kame[i][j] * 0.4, (double)kame[i][j + 1] * 0.4, kameColor, false));
            }
        }
        this.setOriginalShape(defaultTurtle);
        this.resetShape();
        Rectangle2D bounds = defaultTurtle.getBounds();
        this.setSize(bounds.getWidth(), bounds.getHeight());
    }

    void updateShape() {
        this.penup();
        this.setX(this.client.getX());
        this.setY(this.client.getY());
        ((Point2D.Double)this.getBalance()).x = this.client.getBalanceX();
        ((Point2D.Double)this.getBalance()).y = this.client.getBalanceY();
    }

    public void paint(Graphics g) {
        this.animator = this.client.getTurtleAnimator();
        if (this.animator == null) {
            return;
        }
        if (this.animator.hasRubber()) {
            g.setColor(this.client.getPenColor());
            ((Graphics2D)g).setStroke(this.client.getPenStroke());
            g.drawLine((int)this.animator.rx, (int)this.animator.ry, (int)this.animator.x, (int)this.animator.y);
        }
        if (this.client.isTurtleVisible()) {
            this.setTemporaryAngle();
            switch (this.kameType / 2 % 4) {
                case 0: 
                case 2: {
                    this.drawKame(g, kame);
                    break;
                }
                case 1: {
                    this.drawKame(g, kameR);
                    break;
                }
                case 3: {
                    this.drawKame(g, kameL);
                }
            }
        }
        ++this.kameType;
    }

    private void setTemporaryAngle() {
        double theta = this.animator.getCurrentTheta();
        this.dx = Math.sin(theta);
        this.dy = -Math.cos(theta);
    }

    private void drawKame(Graphics g, short[][] data) {
        int ix = (int)this.animator.x;
        int iy = (int)this.animator.y;
        g.setColor(this.client.getTurtleColor());
        ((Graphics2D)g).setStroke(new BasicStroke());
        for (int i = 0; i < data.length; ++i) {
            int px = 0;
            int py = 0;
            for (int j = 0; j < data[i].length; j += 2) {
                short kx = data[i][j];
                short ky = data[i][j + 1];
                int nx = (int)(((double)kx * -this.dy + (double)ky * -this.dx) * 0.4 * this.animator.getCurrentScaleX());
                int ny = (int)(((double)kx * this.dx + (double)ky * -this.dy) * 0.4 * this.animator.getCurrentScaleY());
                if (j > 0) {
                    g.drawLine(ix + px, iy + py, ix + nx, iy + ny);
                }
                px = nx;
                py = ny;
            }
        }
    }
}

