/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import sfc.turtle.Line;
import sfc.turtle.LineList;
import sfc.turtle.ShapeTurtle;
import sfc.turtle.TurtleAnimator;
import sfc.turtle.TurtleFrame;

public class ImageTurtle
extends ShapeTurtle {
    private BufferedImage image = null;
    private Rectangle2D original = null;
    private boolean showImageBounds = false;

    public ImageTurtle(TurtleFrame t) {
        super(t);
        this.setImage(this.turtleContainer.createTextImage("Untitled"));
        this.init(true);
        t.update();
    }

    public ImageTurtle(String filename, TurtleFrame t) {
        super(t);
        this.setImage(filename);
        this.init(true);
        t.update();
    }

    public void setImage(String filename) {
        if (this.turtleContainer != null) {
            this.setImage(this.turtleContainer.loadBufferedImage(filename));
        }
    }

    protected void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public boolean isShowImageBounds() {
        return this.showImageBounds;
    }

    public void setShowImageBounds(boolean t) {
        this.showImageBounds = t;
    }

    public synchronized void init(boolean locationSwitch) {
        if (this.image != null && this.turtleContainer != null) {
            this.setImageBounds(locationSwitch);
            this.setImageShape(locationSwitch);
        }
        this.penup();
    }

    protected void initializeShape() {
        this.setImageShape(true);
        this.resetShape();
    }

    protected synchronized void setImageBounds(boolean locationSwitch) {
        double iy;
        double ix;
        double iwidth = this.image.getWidth();
        double iheight = this.image.getHeight();
        double cwidth = this.turtleContainer.getWidth();
        double cheight = this.turtleContainer.getHeight();
        if (locationSwitch) {
            ix = !ImageTurtle.isCenterOriented() ? 100.0 - iwidth / 2.0 : cwidth / 2.0 - iwidth / 2.0;
            iy = !ImageTurtle.isCenterOriented() ? 100.0 - iheight / 2.0 : cheight / 2.0 - iheight / 2.0;
            this.setLocation(ix + iwidth / 2.0, iy + iheight / 2.0);
        } else {
            ix = this.getX() - iwidth / 2.0;
            iy = this.getY() - iheight / 2.0;
        }
        this.original = new Rectangle2D.Double(ix, iy, iwidth, iheight);
        this.setSize(iwidth, iheight);
        this.setAngle(0.0);
    }

    protected synchronized void setImageShape(boolean locationSwitch) {
        if (this.image != null) {
            double iy;
            double ix;
            LineList bounds = new LineList();
            if (locationSwitch) {
                ix = this.original.getX();
                iy = this.original.getY();
            } else {
                ix = this.getX();
                iy = this.getY();
            }
            double halfwidth = this.original.getWidth() / 2.0;
            double halfheight = this.original.getHeight() / 2.0;
            Color c = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            bounds.add(new Line(ix - halfwidth, iy - halfheight, ix + halfwidth, iy - halfheight, c, true));
            bounds.add(new Line(ix + halfwidth, iy - halfheight, ix + halfwidth, iy + halfheight, c, false));
            bounds.add(new Line(ix + halfwidth, iy + halfheight, ix - halfwidth, iy + halfheight, c, false));
            bounds.add(new Line(ix - halfwidth, iy + halfheight, ix - halfwidth, iy - halfheight, c, false));
            this.setOriginalShape(bounds);
        }
    }

    protected synchronized AffineTransformOp createTransformOp(double theta, double x, double y, double width, double height, double scalex, double scaley, double balancex, double balancey) {
        AffineTransform transform = new AffineTransform();
        double centerX = width / 2.0;
        double centerY = height / 2.0;
        transform.rotate(theta, balancex, balancey);
        transform.translate(balancex, balancey);
        transform.scale(scalex, scaley);
        transform.translate(-balancex, -balancey);
        transform.translate(x, y);
        transform.translate(-centerX, -centerY);
        AffineTransformOp transformOp = new AffineTransformOp(transform, 1);
        return transformOp;
    }

    public synchronized Rectangle2D getCurrentRotatedBounds() {
        AffineTransform at = new AffineTransform();
        TurtleAnimator animator = super.getTurtleAnimator();
        at.rotate(animator.getCurrentTheta(), animator.balancex, animator.balancey);
        Rectangle2D.Double bounds = new Rectangle2D.Double(animator.x - this.getWidth() / 2.0, animator.y - this.getHeight() / 2.0, this.getWidth(), this.getHeight());
        Shape r = at.createTransformedShape(bounds);
        return r.getBounds2D();
    }

    public void paint(Graphics g) {
        if (this.getLooks() == this) {
            TurtleAnimator animator = super.getTurtleAnimator();
            if (animator == null) {
                this.fixedpaint((Graphics2D)g);
            } else {
                this.animatedpaint((Graphics2D)g, animator);
            }
        }
    }

    private void fixedpaint(Graphics2D g) {
        if (this.isTurtleVisible() && this.image != null) {
            Rectangle2D rbounds = this.getShapeBounds();
            if (this.showImageBounds) {
                g.setColor(this.getPenColor());
                g.setStroke(this.getPenStroke());
                g.draw(rbounds);
            }
            AffineTransformOp transformOp = this.createTransformOp(this.getTheta(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getScaleX(), this.getScaleY(), this.getBalanceX(), this.getBalanceY());
            g.drawImage(this.image, transformOp, 0, 0);
        }
    }

    private void animatedpaint(Graphics2D g, TurtleAnimator animator) {
        if (animator.hasRubber()) {
            g.setColor(this.getPenColor());
            g.setStroke(this.getPenStroke());
            g.drawLine((int)animator.rx, (int)animator.ry, (int)animator.x, (int)animator.y);
        }
        if (this.isTurtleVisible() && this.image != null) {
            Rectangle2D rbounds = this.getCurrentRotatedBounds();
            if (this.showImageBounds) {
                g.setColor(this.getPenColor());
                g.setStroke(this.getPenStroke());
                g.draw(rbounds);
            }
            AffineTransformOp transformOp = this.createTransformOp(animator.getCurrentTheta(), animator.x, animator.y, this.original.getWidth(), this.original.getHeight(), animator.getCurrentScaleX(), animator.getCurrentScaleY(), animator.balancex, animator.balancey);
            g.drawImage(this.image, transformOp, 0, 0);
        }
    }
}

