/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

class Line {
    private Point2D p1 = null;
    private Point2D p2 = null;
    private Color color = null;
    private BasicStroke stroke = new BasicStroke();
    private boolean strokebegin = true;

    public Line(Point2D p1, Point2D p2, Color color, boolean sb) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY(), color, sb);
    }

    public Line(double p1X, double p1Y, double p2X, double p2Y, Color color, boolean sb) {
        this.p1 = new Point2D.Double(p1X, p1Y);
        this.p2 = new Point2D.Double(p2X, p2Y);
        this.color = color;
        this.strokebegin = sb;
    }

    public Line(Line line) {
        this.p1 = new Point2D.Double(line.p1.getX(), line.p1.getY());
        this.p2 = new Point2D.Double(line.p2.getX(), line.p2.getY());
        this.color = line.color;
        this.strokebegin = line.strokebegin;
    }

    public void transform(AffineTransform transform) {
        transform.transform(this.p1, this.p1);
        transform.transform(this.p2, this.p2);
    }

    public Line2D getLine2D() {
        return new Line2D.Double(this.p1, this.p2);
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke bs) {
        this.stroke = bs;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isStrokebegin() {
        return this.strokebegin;
    }

    public void paint(Graphics2D g) {
        Color originalColor = g.getColor();
        Stroke originalStroke = g.getStroke();
        g.setStroke(this.stroke);
        g.setColor(this.color);
        g.draw(this.getLine2D());
        g.setColor(originalColor);
        g.setStroke(originalStroke);
    }
}

