/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sfc.turtle.Line;

class LineList {
    private boolean dirty = false;
    private Rectangle2D bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private List lines = new ArrayList();
    private boolean fillSwitch = false;

    public LineList() {
    }

    public LineList(LineList lines) {
        Iterator i = lines.lines.iterator();
        while (i.hasNext()) {
            Line line = (Line)i.next();
            this.lines.add(new Line(line));
            this.dirty = true;
        }
    }

    public synchronized void add(Line line) {
        this.lines.add(line);
        this.dirty = true;
    }

    public synchronized void remove(Line line) {
        this.lines.remove(line);
        this.dirty = true;
    }

    public synchronized void transform(AffineTransform transform) {
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            Line line = (Line)i.next();
            line.transform(transform);
        }
        this.dirty = true;
    }

    public synchronized void setFill(boolean sw) {
        this.fillSwitch = sw;
    }

    public synchronized boolean getFill() {
        return this.fillSwitch;
    }

    public synchronized void paint(Graphics2D g) {
        if (this.fillSwitch) {
            Stroke originalStroke;
            Color originalColor;
            Iterator i = this.lines.iterator();
            Point2D last = new Point2D.Double(0.0, 0.0);
            Color lastcolor = null;
            BasicStroke laststroke = null;
            Line line = null;
            GeneralPath gp = null;
            while (i.hasNext()) {
                Line2D linepoint;
                line = (Line)i.next();
                if (line.isStrokebegin() && gp != null) {
                    originalColor = g.getColor();
                    originalStroke = g.getStroke();
                    if (line != null) {
                        g.setStroke(laststroke);
                        g.setColor(lastcolor);
                    }
                    g.fill(gp);
                    g.setColor(originalColor);
                    g.setStroke(originalStroke);
                    gp = null;
                }
                if (line.isStrokebegin() && gp == null) {
                    gp = new GeneralPath();
                    gp.moveTo((float)((Point2D)last).getX(), (float)((Point2D)last).getY());
                    lastcolor = line.getColor();
                    laststroke = line.getStroke();
                }
                if ((linepoint = line.getLine2D()).getP1().distance(last) <= 0.1) {
                    gp.lineTo((float)linepoint.getP2().getX(), (float)linepoint.getP2().getY());
                } else {
                    gp.moveTo((float)linepoint.getP1().getX(), (float)linepoint.getP1().getY());
                    gp.lineTo((float)linepoint.getP2().getX(), (float)linepoint.getP2().getY());
                }
                last = linepoint.getP2();
            }
            if (gp != null) {
                originalColor = g.getColor();
                originalStroke = g.getStroke();
                if (line != null) {
                    g.setStroke(laststroke);
                    g.setColor(lastcolor);
                }
                g.draw(gp);
                g.fill(gp);
                g.setColor(originalColor);
                g.setStroke(originalStroke);
            }
        } else {
            Iterator i = this.lines.iterator();
            while (i.hasNext()) {
                Line line = (Line)i.next();
                line.paint(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Rectangle2D getBounds() {
        if (this.dirty) {
            LineList lineList = this;
            synchronized (lineList) {
                Rectangle2D allBounds = null;
                Iterator i = this.lines.iterator();
                while (i.hasNext()) {
                    Line line = (Line)i.next();
                    Rectangle2D bounds = line.getLine2D().getBounds2D();
                    if (allBounds == null) {
                        allBounds = bounds;
                        continue;
                    }
                    allBounds = ((Rectangle2D)allBounds).createUnion(bounds);
                }
                if (allBounds == null) {
                    allBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                }
                this.bounds = allBounds;
                this.dirty = false;
            }
        }
        return this.bounds;
    }

    public synchronized boolean intersects(Rectangle2D rectangle) {
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            Line line = (Line)i.next();
            if (!rectangle.intersectsLine(line.getLine2D())) continue;
            return true;
        }
        return false;
    }
}

