/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import sfc.turtle.LineList;
import sfc.turtle.Scale;
import sfc.turtle.Turtle;
import sfc.turtle.TurtleFrame;

public class ShapeTurtle
extends Turtle {
    protected static boolean instanciationLock = false;
    private AffineTransform currentTransform = null;
    private LineList shape = null;
    private LineList originalShape = null;
    protected TurtleFrame turtleContainer = null;

    public ShapeTurtle(TurtleFrame container) {
        super(container);
        this.turtleContainer = container;
    }

    protected void initializeShape() {
        this.originalShape = null;
    }

    protected LineList getShape() {
        return this.shape;
    }

    protected void setShape(LineList s) {
        this.shape = s;
    }

    protected void resetShape() {
        if (this.originalShape != null) {
            this.shape = this.originalShape;
        }
        this.currentTransform = null;
    }

    protected LineList getOriginalShape() {
        return this.originalShape;
    }

    protected void setOriginalShape(LineList o) {
        this.originalShape = o;
        this.setShape(new LineList(o));
    }

    protected Shape getRotatedShape() {
        AffineTransform transform = new AffineTransform();
        transform.rotate(this.getTheta(), this.getBalanceX(), this.getBalanceY());
        return transform.createTransformedShape(this.getBounds());
    }

    Rectangle2D getShapeBounds() {
        return this.shape.getBounds();
    }

    protected Rectangle2D getOriginalBounds() {
        return this.originalShape.getBounds();
    }

    protected boolean intersects(Rectangle2D bounds) {
        Rectangle2D rbounds = this.getRotatedBounds();
        return rbounds.intersects(bounds);
    }

    synchronized void doTransform() {
        if (this.currentTransform != null) {
            try {
                AffineTransform reverse = this.currentTransform.createInverse();
                if (this.shape != null) {
                    this.shape.transform(reverse);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.shape != null) {
            AffineTransform transform = this.createTransform();
            this.shape.transform(transform);
            this.currentTransform = transform;
        }
    }

    protected synchronized AffineTransform createTransform() {
        AffineTransform transform = new AffineTransform();
        Rectangle2D r = this.shape.getBounds();
        Scale scale = new Scale(r.getWidth(), r.getHeight(), this.getWidth(), this.getHeight());
        transform.rotate(this.getTheta(), this.getBalanceX(), this.getBalanceY());
        transform.translate(this.getBalanceX(), this.getBalanceY());
        transform.scale(scale.getX(), scale.getY());
        transform.translate(-this.getBalanceX(), -this.getBalanceY());
        transform.translate(this.getX(), this.getY());
        transform.translate(-r.getCenterX(), -r.getCenterY());
        return transform;
    }

    public void paint(Graphics g) {
        if (this.shape != null) {
            this.shape.paint((Graphics2D)g);
        }
    }
}

