/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import sfc.turtle.Line;
import sfc.turtle.LineList;
import sfc.turtle.ShapeTurtle;
import sfc.turtle.TurtleAnimator;
import sfc.turtle.TurtleFrame;

public class TextTurtle
extends ShapeTurtle {
    private int fontsize = 24;
    private String typeface = "Dialog";
    private String text = null;
    private Font font = null;
    private FontMetrics fm = null;
    private Dimension original = null;
    private boolean showTextBounds = false;

    public TextTurtle(TurtleFrame t) {
        this("Text Turtle", t);
    }

    public TextTurtle(int value, TurtleFrame t) {
        this(new Integer(value), t);
    }

    public TextTurtle(long value, TurtleFrame t) {
        this(new Long(value), t);
    }

    public TextTurtle(double value, TurtleFrame t) {
        this(new Double(value), t);
    }

    public TextTurtle(boolean value, TurtleFrame t) {
        this(new Boolean(value), t);
    }

    public TextTurtle(String text, TurtleFrame t) {
        this((Object)text, t);
    }

    public TextTurtle(String text, int s, TurtleFrame t) {
        this((Object)text, s, t);
    }

    public TextTurtle(String text, Color c, TurtleFrame t) {
        this((Object)text, c, 24, t);
    }

    public TextTurtle(String text, String fn, TurtleFrame t) {
        this((Object)text, fn, 24, t);
    }

    public TextTurtle(String text, String fn, int s, TurtleFrame t) {
        this((Object)text, fn, s, t);
    }

    public TextTurtle(String text, String fn, Color c, TurtleFrame t) {
        this((Object)text, c, fn, 24, t);
    }

    public TextTurtle(String text, Color c, int s, TurtleFrame t) {
        this((Object)text, c, s, t);
    }

    public TextTurtle(String text, Color c, String fn, TurtleFrame t) {
        this((Object)text, c, fn, 24, t);
    }

    public TextTurtle(String text, int s, Color c, TurtleFrame t) {
        this((Object)text, c, s, t);
    }

    public TextTurtle(String text, int s, String fn, TurtleFrame t) {
        this((Object)text, fn, s, t);
    }

    public TextTurtle(String text, Color c, String fn, int s, TurtleFrame t) {
        this((Object)text, c, fn, s, t);
    }

    public TextTurtle(String text, Color c, int s, String fn, TurtleFrame t) {
        this((Object)text, c, fn, s, t);
    }

    public TextTurtle(String text, String fn, Color c, int s, TurtleFrame t) {
        this((Object)text, c, fn, s, t);
    }

    public TextTurtle(String text, String fn, int s, Color c, TurtleFrame t) {
        this((Object)text, c, fn, s, t);
    }

    public TextTurtle(String text, int s, Color c, String fn, TurtleFrame t) {
        this((Object)text, c, fn, s, t);
    }

    public TextTurtle(String text, int s, String fn, Color c, TurtleFrame t) {
        this((Object)text, c, fn, s, t);
    }

    public TextTurtle(Object text, TurtleFrame t) {
        super(t);
        this.init(text);
    }

    public TextTurtle(Object text, int size, TurtleFrame t) {
        super(t);
        this.fontsize = size;
        this.init(text);
    }

    public TextTurtle(Object text, String fontname, int size, TurtleFrame t) {
        super(t);
        this.fontsize = size;
        this.typeface = new String(fontname);
        this.init(text);
    }

    public TextTurtle(Object text, Color color, int size, TurtleFrame t) {
        super(t);
        this.setTurtleColor(color);
        this.fontsize = size;
        this.init(text);
    }

    public TextTurtle(Object text, Color color, String fontname, int size, TurtleFrame t) {
        super(t);
        this.setTurtleColor(color);
        this.fontsize = size;
        this.typeface = new String(fontname);
        this.init(text);
    }

    private void init(Object text) {
        this.penup();
        if (this.fontsize == 0) {
            this.fontsize = 24;
        }
        if (this.typeface == null) {
            this.typeface = "Dialog";
        }
        this.font = new Font(this.typeface, 0, this.fontsize);
        this.setText(text.toString());
    }

    public void setText(int value) {
        this.setText(new Integer(value));
    }

    public void setText(long value) {
        this.setText(new Long(value));
    }

    public void setText(double value) {
        this.setText(new Double(value));
    }

    public void setText(boolean value) {
        this.setText(new Boolean(value));
    }

    public void setText(String text) {
        this.setText((Object)text);
    }

    public void setText(Object text) {
        this.text = text != null ? text.toString() : "null";
        this.resetImage();
    }

    public String getText() {
        return this.text;
    }

    public void setTypeface(String typeface) {
        this.typeface = typeface;
        this.resetImage();
    }

    public String getTypeface() {
        return new String(this.typeface);
    }

    public void setFontSize(int fontsize) {
        this.fontsize = fontsize;
        this.resetImage();
    }

    public int getFontSize() {
        return this.fontsize;
    }

    private synchronized void resetImage() {
        this.font = new Font(this.typeface, 0, this.fontsize);
        this.fm = this.turtleContainer.getFontMetrics(this.font);
        this.setTextBounds();
        this.setTextShape();
    }

    public boolean isShowTextBounds() {
        return this.showTextBounds;
    }

    public void setShowTextBounds(boolean t) {
        this.showTextBounds = t;
    }

    synchronized void setTextBounds() {
        double iwidth = SwingUtilities.computeStringWidth(this.fm, this.text == null ? "null" : this.text);
        double iheight = this.fm.getHeight();
        this.original = new Dimension();
        this.original.setSize(iwidth, iheight);
        this.setSize(iwidth, iheight);
        this.setAngle(this.getAngle());
    }

    synchronized void setTextShape() {
        if (this.original != null) {
            LineList bounds = new LineList();
            double ix = this.getX();
            double iy = this.getY();
            double halfwidth = this.original.getWidth() / 2.0;
            double halfheight = this.original.getHeight() / 2.0;
            Color c = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            bounds.add(new Line(ix - halfwidth, iy - halfheight, ix + halfwidth, iy - halfheight, c, true));
            bounds.add(new Line(ix + halfwidth, iy - halfheight, ix + halfwidth, iy + halfheight, c, false));
            bounds.add(new Line(ix + halfwidth, iy + halfheight, ix - halfwidth, iy + halfheight, c, false));
            bounds.add(new Line(ix - halfwidth, iy + halfheight, ix - halfwidth, iy - halfheight, c, false));
            this.setOriginalShape(bounds);
        }
    }

    synchronized Rectangle2D getCurrentBounds() {
        TurtleAnimator animator = super.getTurtleAnimator();
        return new Rectangle2D.Double(0.0, 0.0, animator.width, animator.height);
    }

    private AffineTransform currentTransform(TurtleAnimator animator) {
        AffineTransform transform = new AffineTransform();
        double centerX = this.original.getWidth() / 2.0;
        double centerY = this.original.getHeight() / 2.0;
        transform.rotate(animator.getCurrentTheta(), animator.balancex, animator.balancey);
        transform.translate(animator.balancex, animator.balancey);
        transform.scale(animator.getCurrentScaleX(), animator.getCurrentScaleY());
        transform.translate(-animator.balancex, -animator.balancey);
        transform.translate(animator.x, animator.y);
        transform.translate(-centerX, -centerY);
        return transform;
    }

    public void paint(Graphics g) {
        if (this.getLooks() == this) {
            TurtleAnimator animator = super.getTurtleAnimator();
            if (animator == null) {
                this.fixedpaint((Graphics2D)g);
            } else {
                this.animatedpaint((Graphics2D)g, animator);
            }
        }
    }

    private void fixedpaint(Graphics2D g) {
        if (this.isTurtleVisible() && this.font != null) {
            AffineTransform reserved = g.getTransform();
            AffineTransform transform = this.createTransform();
            g.setTransform(transform);
            if (this.showTextBounds) {
                Rectangle2D tbounds = this.getShapeBounds();
                g.setColor(this.getPenColor());
                g.setStroke(this.getPenStroke());
                g.draw(tbounds);
            }
            g.setFont(this.font);
            g.setColor(this.getTurtleColor());
            g.drawString(this.text, 0.0f, (float)this.getHeight());
            g.setTransform(reserved);
        }
    }

    private void animatedpaint(Graphics2D g, TurtleAnimator animator) {
        if (animator.hasRubber()) {
            g.setColor(this.getPenColor());
            g.setStroke(this.getPenStroke());
            g.drawLine((int)animator.rx, (int)animator.ry, (int)animator.x, (int)animator.y);
        }
        if (this.isTurtleVisible() && this.font != null) {
            AffineTransform reserved = g.getTransform();
            AffineTransform transform = this.currentTransform(animator);
            g.setTransform(transform);
            Rectangle2D tbounds = this.getCurrentBounds();
            if (this.showTextBounds) {
                g.setColor(this.getPenColor());
                g.setStroke(this.getPenStroke());
                g.draw(tbounds);
            }
            g.setFont(this.font);
            g.setColor(this.getTurtleColor());
            g.drawString(this.text, 0.0f, (float)animator.height);
            g.setTransform(reserved);
        }
    }
}

