/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sfc.turtle.DefaultTurtle;
import sfc.turtle.DoubleDimension;
import sfc.turtle.Line;
import sfc.turtle.LineList;
import sfc.turtle.RelativePoint;
import sfc.turtle.Scale;
import sfc.turtle.ShapeTurtle;
import sfc.turtle.TurtleAnimator;
import sfc.turtle.TurtleFrame;

public class Turtle {
    private static final Color[] colorOrders = new Color[]{Color.green, Color.red, Color.blue, Color.magenta, Color.cyan, Color.orange, Color.yellow, Color.pink};
    private static boolean centerOriented = true;
    private static boolean showTurtleAtCreation = true;
    private static boolean multipleColorAtCreation = true;
    private static int colororder = 0;
    private TurtleFrame turtleContainer = null;
    private boolean penDown = true;
    private Color penColor = Color.black;
    private Color turtleColor = Color.green;
    private boolean show = true;
    private boolean turtleShow = true;
    private Point2D location = new Point2D.Double(100.0, 100.0);
    private Point2D balance = new Point2D.Double(this.location.getX(), this.location.getY());
    private Dimension2D size = new DoubleDimension(100.0, 100.0);
    private double angle = 0.0;
    private double direction = 0.0;
    private Dimension2D scale = new DoubleDimension(1.0, 1.0);
    private ShapeTurtle originalLooks = null;
    private ShapeTurtle looks = null;
    private LineList locus = new LineList();
    private BasicStroke stroke = new BasicStroke();
    private boolean pathbegin = true;
    private TurtleAnimator animator = null;
    private boolean dirty = true;
    static /* synthetic */ Class class$sfc$turtle$Turtle;

    public static boolean setSpeed(int step) {
        return TurtleAnimator.setSpeed(step);
    }

    public static int getSpeed() {
        return TurtleAnimator.getSpeed();
    }

    public static boolean isCenterOriented() {
        return centerOriented;
    }

    public static void setCenterOriented(boolean o) {
        centerOriented = o;
    }

    public static boolean isMultipleColorAtCreation() {
        return multipleColorAtCreation;
    }

    public static void setMultipleColorAtCreation(boolean m) {
        multipleColorAtCreation = m;
        if (m) {
            Turtle.resetColorOrderAtCreation();
        }
    }

    public static void resetColorOrderAtCreation() {
        colororder = 0;
    }

    public static void setShowTurtleAtCreation(boolean s) {
        showTurtleAtCreation = s;
    }

    public static boolean isShowTurtleAtCreation() {
        return showTurtleAtCreation;
    }

    public Turtle() {
        if (this.turtleContainer != null) {
            this.initialize();
            this.turtleContainer.registerTurtle(this);
        }
    }

    public Turtle(TurtleFrame myframe) {
        this.turtleContainer = myframe;
        if (this.turtleContainer != null) {
            this.initialize();
            this.turtleContainer.registerTurtle(this);
        }
    }

    public synchronized void initialize() {
        this.initializeParameter();
        if (this.getClass() == (class$sfc$turtle$Turtle == null ? (class$sfc$turtle$Turtle = Turtle.class$("sfc.turtle.Turtle")) : class$sfc$turtle$Turtle)) {
            DefaultTurtle delegator = new DefaultTurtle(this, this.turtleContainer);
            this.initializeLooks(delegator);
            this.animator = new TurtleAnimator(this);
            this.setSize(delegator.getWidth(), delegator.getHeight());
            if (!Turtle.isShowTurtleAtCreation()) {
                this.setTurtleVisible(false);
            } else {
                this.turtleContainer.update();
            }
        } else if (this instanceof ShapeTurtle) {
            this.initializeLooks((ShapeTurtle)this);
            this.animator = new TurtleAnimator((ShapeTurtle)this);
            if (!Turtle.isShowTurtleAtCreation()) {
                this.setTurtleVisible(false);
            } else {
                this.turtleContainer.update();
            }
        } else {
            System.out.println("Other Turtle created..." + this.getClass().getName());
        }
    }

    private void initializeParameter() {
        if (this.turtleContainer == null || !centerOriented) {
            this.location = new Point2D.Double(100.0, 100.0);
            this.balance = new Point2D.Double(this.location.getX(), this.location.getY());
        } else {
            double centerx = (double)this.turtleContainer.getWidth() / 2.0;
            double centery = (double)this.turtleContainer.getHeight() / 2.0;
            this.location = new Point2D.Double(centerx, centery);
            this.balance = new Point2D.Double(centerx, centery);
        }
        this.size = new DoubleDimension(100.0, 100.0);
        this.angle = 0.0;
        this.direction = 0.0;
        this.scale = new DoubleDimension(1.0, 1.0);
        if (this.getClass() == (class$sfc$turtle$Turtle == null ? (class$sfc$turtle$Turtle = Turtle.class$("sfc.turtle.Turtle")) : class$sfc$turtle$Turtle) && multipleColorAtCreation) {
            this.turtleColor = colorOrders[colororder];
            colororder = (colororder + 1) % colorOrders.length;
        } else {
            this.turtleColor = Color.green;
        }
        this.show = true;
        this.turtleShow = true;
        this.penDown = true;
        this.penColor = Color.black;
        LineList locus = new LineList();
        this.pathbegin = true;
        this.animator = null;
    }

    final TurtleFrame getTurtleContainer() {
        return this.turtleContainer;
    }

    final TurtleAnimator getTurtleAnimator() {
        return this.animator;
    }

    public void initializeLooks(ShapeTurtle looks) {
        this.originalLooks = looks;
        this.setLooks(looks);
    }

    public synchronized void setLooks(ShapeTurtle looks) {
        this.looks = looks;
        looks.initializeShape();
        this.dirty = true;
        this.turtleContainer.update();
    }

    public ShapeTurtle getLooks() {
        return this.looks;
    }

    public void resetLooks() {
        this.setLooks(this.originalLooks);
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isVisible() {
        return this.show;
    }

    public void setVisible(boolean show) {
        this.show = show;
        this.setTurtleVisible(show);
    }

    public void showTurtle() {
        this.setTurtleVisible(true);
    }

    public void hideTurtle() {
        this.setTurtleVisible(false);
    }

    public boolean isTurtleVisible() {
        return this.turtleShow;
    }

    public void setTurtleVisible(boolean show) {
        this.turtleShow = show;
        if (show && this.turtleContainer != null) {
            this.turtleContainer.update();
        }
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setLocation(Point2D location) {
        this.setLocation(location.getX(), location.getY());
    }

    public void setLocation(double x, double y) {
        if (this.penDown) {
            Point2D.Double newLocation = new Point2D.Double(x, y);
            Line locusline = new Line(this.location, newLocation, this.penColor, this.pathbegin);
            locusline.setStroke(this.getPenStroke());
            this.locus.add(locusline);
            if (this.pathbegin) {
                this.pathbegin = false;
            }
        }
        double moveX = x - this.getX();
        double moveY = y - this.getY();
        this.location.setLocation(x, y);
        this.balance.setLocation(this.balance.getX() + moveX, this.balance.getY() + moveY);
        this.dirty = true;
        if (this.getClass() == (class$sfc$turtle$Turtle == null ? (class$sfc$turtle$Turtle = Turtle.class$("sfc.turtle.Turtle")) : class$sfc$turtle$Turtle)) {
            ((DefaultTurtle)this.looks).updateShape();
        }
        if (this.animator != null) {
            this.animator.updateTurtle();
        }
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public int getIntegerX() {
        return (int)this.location.getX();
    }

    public int getIntegerY() {
        return (int)this.location.getY();
    }

    public void setX(double x) {
        this.setLocation(x, this.getY());
    }

    public void setY(double y) {
        this.setLocation(this.getX(), y);
    }

    public double minX() {
        return this.getX() - this.getWidth() / 2.0;
    }

    public double minY() {
        return this.getY() - this.getHeight() / 2.0;
    }

    public double maxX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double maxY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public Point2D getRotatedLocation() {
        return new Point2D.Double(this.getRotatedX(), this.getRotatedY());
    }

    public double getRotatedX() {
        return this.looks.getShapeBounds().getCenterX();
    }

    public double getRotatedY() {
        return this.looks.getShapeBounds().getCenterY();
    }

    public double getRotatedMinX() {
        return this.getRotatedX() - this.getRotatedWidth() / 2.0;
    }

    public double getRotatedMinY() {
        return this.getRotatedY() - this.getRotatedHeight() / 2.0;
    }

    public double getRotatedMaxX() {
        return this.getRotatedX() + this.getRotatedWidth() / 2.0;
    }

    public double getRotatedMaxY() {
        return this.getRotatedY() + this.getRotatedHeight() / 2.0;
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.minX(), this.minY(), this.getWidth(), this.getHeight());
    }

    public void setBounds(Rectangle2D r) {
        this.setLocation(r.getCenterX(), r.getCenterY());
        this.setSize(r.getWidth(), r.getHeight());
    }

    public void setBounds(double x, double y, double width, double height) {
        this.setBounds(new Rectangle2D.Double(x, y, width, height));
    }

    public Rectangle2D getRotatedBounds() {
        return this.looks.getShapeBounds();
    }

    public void setSize(Dimension2D dimension) {
        this.setSize(dimension.getWidth(), dimension.getHeight());
    }

    public void setSize(double width, double height) {
        if (width <= 0.1) {
            width = 0.1;
        }
        if (height <= 0.1) {
            height = 0.1;
        }
        this.size.setSize(width, height);
        this.dirty = true;
        if (this.animator != null) {
            this.animator.updateTurtle();
        }
    }

    public Dimension2D getSize() {
        return new DoubleDimension(this.size);
    }

    public double getWidth() {
        return this.size.getWidth();
    }

    public double getHeight() {
        return this.size.getHeight();
    }

    public void setWidth(double width) {
        this.setSize(width, this.getHeight());
    }

    public void setHeight(double height) {
        this.setSize(this.getWidth(), height);
    }

    public double getRotatedWidth() {
        return this.getRotatedBounds().getWidth();
    }

    public double getRotatedHeight() {
        return this.getRotatedBounds().getHeight();
    }

    public void setScale(double scale) {
        this.setScale(scale, scale);
    }

    public void setScale(double scaleX, double scaleY) {
        this.scale.setSize(this.scale.getWidth() * scaleX, this.scale.getHeight() * scaleY);
        this.setSize(this.getWidth() * scaleX, this.getHeight() * scaleY);
    }

    public void resetScale(double scalex, double scaley) {
        Rectangle2D org = this.looks.getOriginalBounds();
        this.scale.setSize(scalex, scaley);
        this.setSize(org.getWidth() * scalex, org.getHeight() * scaley);
    }

    public void resetScale(double scale) {
        Rectangle2D org = this.looks.getOriginalBounds();
        this.scale.setSize(scale, scale);
        this.setSize(org.getWidth() * scale, org.getHeight() * scale);
    }

    public void resetScale() {
        this.resetScale(1.0);
    }

    public Scale getScale() {
        Rectangle2D org = this.looks.getOriginalBounds();
        return new Scale(org.getWidth(), org.getHeight(), this.getWidth(), this.getHeight());
    }

    public double getScaleX() {
        return this.getScale().getX();
    }

    public double getScaleY() {
        return this.getScale().getY();
    }

    public Point2D getBalance() {
        return this.balance;
    }

    public double getBalanceX() {
        return this.getBalance().getX();
    }

    public double getBalanceY() {
        return this.getBalance().getY();
    }

    public int getIntegerBalanceX() {
        return (int)this.getBalanceX();
    }

    public int getIntegerBalanceY() {
        return (int)this.getBalanceY();
    }

    public void setBalance(double percentX, double percentY) {
        double xMag = percentX / 100.0;
        double yMag = percentY / 100.0;
        RelativePoint rp = new RelativePoint(xMag, yMag);
        this.balance = rp.getPoint(this.getBounds());
    }

    public void setAngle(double angle) {
        this.angle = angle %= 360.0;
        this.dirty = true;
        if (this.animator != null) {
            this.animator.updateTurtle();
        }
    }

    public void setTheta(double theta) {
        this.setAngle(Math.toDegrees(theta));
    }

    public double getAngle() {
        return this.angle;
    }

    public double getTheta() {
        return Math.toRadians(this.getAngle());
    }

    public void setDirection(double direction) {
        this.direction = direction;
    }

    public double getDirection() {
        return this.direction;
    }

    public void rotateDirection(double direction) {
        this.setDirection(this.direction + direction);
    }

    public void move(double length, double direction) {
        double theta = Math.toRadians(this.getAngle() + this.getDirection() + direction);
        double xLength = Math.sin(theta) * length;
        double yLength = -Math.cos(theta) * length;
        double newX = this.getX() + xLength;
        double newY = this.getY() + yLength;
        if (this.animator != null) {
            this.animator.moveTurtle(this.getX(), this.getY(), newX, newY);
        }
        this.setLocation(newX, newY);
    }

    public void forward(double length) {
        this.move(length, 0.0);
    }

    public void back(double length) {
        this.move(length, 180.0);
    }

    public void right(double length) {
        this.move(length, 90.0);
    }

    public void left(double length) {
        this.move(length, -90.0);
    }

    public void translate(double tx, double ty) {
        this.move(Math.sqrt(tx * tx + ty * ty), Math.toDegrees(Math.atan2(ty, tx)) + 90.0);
    }

    public void moveTo(double x, double y) {
        this.rotate(Math.toDegrees(Math.atan2(y - this.getY(), x - this.getX())) + 90.0 - this.angle);
        this.move(Math.sqrt((x - this.getX()) * (x - this.getX()) + (y - this.getY()) * (y - this.getY())), 0.0);
    }

    public void rotate(double angle) {
        if (this.animator != null) {
            this.animator.rotateTurtle(this.angle, this.angle + angle);
        }
        this.setAngle(this.angle + angle);
    }

    public void rescale(double scale) {
        this.rescale(scale, scale);
    }

    public void rescale(double scaleX, double scaleY) {
        if (this.animator != null) {
            this.animator.resizeTurtle(this.getWidth(), this.getHeight(), this.getWidth() * scaleX, this.getHeight() * scaleY);
        }
        this.setScale(scaleX, scaleY);
    }

    public void resize(double width, double height) {
        if (this.animator != null) {
            this.animator.resizeTurtle(this.getWidth(), this.getHeight(), width, height);
        }
        this.setSize(width, height);
    }

    public void large(double width, double height) {
        this.resize(this.getWidth() + width, this.getHeight() + height);
    }

    public void large(double length) {
        this.large(length, length);
    }

    public void wide(double length) {
        this.large(length, 0.0);
    }

    public void tall(double length) {
        this.large(0.0, length);
    }

    public void small(double width, double height) {
        this.large(-width, -height);
    }

    public void small(double length) {
        this.large(-length);
    }

    public void narrow(double length) {
        this.wide(-length);
    }

    public void little(double length) {
        this.tall(-length);
    }

    public void penup() {
        this.penDown = false;
    }

    public void pendown() {
        this.penDown = true;
        this.pathbegin = true;
    }

    public boolean isPenDown() {
        return this.penDown;
    }

    public void clearLocus() {
        this.locus = new LineList();
        this.pathbegin = true;
    }

    protected LineList getLocus() {
        return this.locus;
    }

    public void setFillLocus(boolean sw) {
        if (this.locus != null) {
            this.locus.setFill(sw);
        }
    }

    public boolean getFillLocus() {
        if (this.locus != null) {
            return this.locus.getFill();
        }
        return false;
    }

    public BasicStroke getPenStroke() {
        return this.stroke;
    }

    public void setPenStroke(BasicStroke s) {
        this.stroke = s;
    }

    public void setPenWidth(double w) {
        this.stroke = new BasicStroke((float)w, this.stroke.getEndCap(), this.stroke.getLineJoin());
    }

    public double getPenWidth() {
        return this.stroke.getLineWidth();
    }

    public void setPenColor(Color penColor) {
        this.penColor = penColor;
        this.pathbegin = true;
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setTurtleColor(Color turtlecolor) {
        this.turtleColor = turtlecolor;
    }

    public Color getTurtleColor() {
        return this.turtleColor;
    }

    public boolean intersects(Turtle target) {
        if (!this.show || !target.isVisible()) {
            return false;
        }
        this.reshape();
        target.reshape();
        Rectangle2D r1 = this.getRotatedBounds();
        Rectangle2D r2 = target.getRotatedBounds();
        Rectangle2D intersection = r1.createIntersection(r2);
        if (intersection.isEmpty()) {
            return false;
        }
        return this.intersectsBounds(intersection) && target.intersectsBounds(intersection);
    }

    protected boolean intersectsBounds(Rectangle2D bounds) {
        return this.looks.intersects(bounds);
    }

    public boolean contains(double x, double y) {
        if (!this.show) {
            return false;
        }
        this.reshape();
        Rectangle2D rect = this.looks.getShape().getBounds();
        return rect.contains(x, y);
    }

    public void paint(Graphics2D g) {
        if (this.show) {
            this.reshape();
            this.draw(g);
        }
    }

    public void draw(Graphics2D g) {
        if (this.locus != null) {
            this.locus.paint(g);
        }
        if (this.looks != null && this.turtleShow) {
            this.looks.paint((Graphics)g);
        }
    }

    protected void reshape() {
        if (this.dirty && this.looks != null) {
            this.looks.doTransform();
            this.dirty = false;
        }
    }

    public void die() {
        if (this.turtleContainer.getAllInstances().contains(this)) {
            this.turtleContainer.removeTurtle(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

