/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import sfc.turtle.Turtle;
import sfc.turtle.TurtleFrame;

class TurtleAnimator {
    private static final int rotateWait = 20;
    private static final int moveWait = 20;
    private static final int resizeWait = 20;
    private static int rotateStep = 5;
    private static int moveStep = 5;
    private static int resizeStep = 5;
    private static boolean waitTurtle = true;
    private Turtle turtle;
    double angle = 0.0;
    double x = 100.0;
    double y = 100.0;
    double balancex = this.x;
    double balancey = this.y;
    double width = 100.0;
    double height = 100.0;
    double rx;
    double ry;
    private boolean rubber = false;

    static boolean setSpeed(int step) {
        waitTurtle = step > 0;
        rotateStep = waitTurtle ? step : -step;
        moveStep = waitTurtle ? step : -step;
        resizeStep = waitTurtle ? step : -step;
        return true;
    }

    static int getSpeed() {
        return moveStep;
    }

    TurtleAnimator(Turtle turtle) {
        this.turtle = turtle;
        this.updateTurtleStatus();
    }

    void updateTurtleStatus() {
        this.angle = this.turtle.getAngle();
        this.x = this.turtle.getX();
        this.y = this.turtle.getY();
        this.balancex = this.turtle.getBalanceX();
        this.balancey = this.turtle.getBalanceY();
        this.width = this.turtle.getWidth();
        this.height = this.turtle.getHeight();
    }

    double getCurrentTheta() {
        return Math.toRadians(this.angle);
    }

    double getCurrentScaleX() {
        return this.turtle.getScaleX() * this.width / this.turtle.getWidth();
    }

    double getCurrentScaleY() {
        return this.turtle.getScaleY() * this.height / this.turtle.getHeight();
    }

    boolean hasRubber() {
        return this.rubber;
    }

    void moveTurtle(double oldx, double oldy, double newx, double newy) {
        this.updateTurtleStatus();
        int n = (int)Math.sqrt((oldx - newx) * (oldx - newx) + (oldy - newy) * (oldy - newy));
        double theta = Math.atan2(newy - oldy, newx - oldx);
        double dx = Math.cos(theta);
        double dy = Math.sin(theta);
        double oldBalancex = this.balancex;
        double oldBalancey = this.balancey;
        if (this.turtle.isPenDown()) {
            this.rx = oldx;
            this.ry = oldy;
            this.rubber = true;
        }
        for (int i = moveStep; i < n; i += moveStep) {
            this.x = oldx + dx * (double)i;
            this.balancex = oldBalancex + dx * (double)i;
            this.y = oldy + dy * (double)i;
            this.balancey = oldBalancey + dy * (double)i;
            this.drawTurtle(20);
        }
        this.x = newx;
        this.y = newy;
        this.balancex = oldBalancex + (newx - oldx);
        this.balancey = oldBalancey + (newy - oldy);
        this.drawTurtle(20);
        if (this.turtle.isPenDown()) {
            this.rubber = false;
        }
    }

    void rotateTurtle(double from, double to) {
        this.updateTurtleStatus();
        int n = (int)(to - from);
        if (n > 0) {
            for (int i = rotateStep; i < n; i += rotateStep) {
                this.angle = from + (double)i;
                this.drawTurtle(20);
            }
        } else if (n < 0) {
            for (int i = rotateStep; i < -n; i += rotateStep) {
                this.angle = from - (double)i;
                this.drawTurtle(20);
            }
        }
        this.angle = to;
        this.drawTurtle(20);
    }

    void resizeTurtle(double oldwidth, double oldheight, double newwidth, double newheight) {
        this.updateTurtleStatus();
        int n = (int)Math.sqrt((oldwidth - newwidth) * (oldwidth - newwidth) + (oldheight - newheight) * (oldheight - newheight));
        this.width = newwidth;
        this.height = newheight;
        this.drawTurtle(20);
    }

    private void drawTurtle(int wait) {
        TurtleFrame turtleContainer = this.turtle.getTurtleContainer();
        if (turtleContainer == null) {
            return;
        }
        turtleContainer.update();
        if (waitTurtle) {
            turtleContainer.sleep((double)wait / 1000.0);
        }
    }

    void updateTurtle() {
        this.updateTurtleStatus();
        this.drawTurtle(1);
    }
}

