/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Iterator;
import sfc.turtle.Turtle;
import sfc.turtle.TurtleFrame;

class TurtleCanvas
extends Canvas {
    private Object mappedLock = "mappedLock";
    private boolean mapped = false;
    private Image offScreen = null;
    private TurtleFrame turtleContainer = null;
    private boolean windows = false;
    private Color background = Color.white;

    public TurtleCanvas(TurtleFrame container) {
        this.turtleContainer = container;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.windows = System.getProperty("os.name").contains("Windows");
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r.x, r.y, r.width, r.height);
        this.offScreen = this.createImage(r.width, r.height);
    }

    void setBackgroundColor(Color c) {
        this.background = c;
        if (this.turtleContainer != null) {
            this.turtleContainer.update();
        }
    }

    Color getBackgroundColor() {
        return this.background;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Color defaultColor = g.getColor();
        g.setColor(this.background);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(defaultColor);
        if (!this.windows || this.offScreen == null) {
            try {
                Iterator i = this.turtleContainer.getAllInstances().iterator();
                while (i.hasNext()) {
                    Turtle sprite = (Turtle)i.next();
                    sprite.paint((Graphics2D)g);
                }
            }
            catch (Exception exc) {}
        } else {
            Graphics2D offG2d = (Graphics2D)this.offScreen.getGraphics();
            defaultColor = offG2d.getColor();
            offG2d.setColor(Color.white);
            offG2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            offG2d.setColor(defaultColor);
            Iterator i = this.turtleContainer.getAllInstances().iterator();
            while (i.hasNext()) {
                Turtle sprite = (Turtle)i.next();
                sprite.paint(offG2d);
            }
            g.drawImage(this.offScreen, 0, 0, null);
            offG2d.dispose();
        }
        this.mappedNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedWait() {
        Object object = this.mappedLock;
        synchronized (object) {
            if (!this.mapped) {
                try {
                    this.mappedLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedNotify() {
        Object object = this.mappedLock;
        synchronized (object) {
            if (!this.mapped) {
                this.mapped = true;
                this.mappedLock.notify();
            }
        }
    }
}

