/*
 * Decompiled with CFR 0.152.
 */
package sfc.turtle;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Scanner;
import java.util.TimeZone;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import sfc.turtle.TextTurtle;
import sfc.turtle.Turtle;
import sfc.turtle.TurtleAnimator;
import sfc.turtle.TurtleCanvas;

public class TurtleFrame
extends JFrame
implements ActionListener,
ItemListener,
KeyListener,
MouseListener,
MouseMotionListener {
    public static final int NoTurtle = 0;
    public static final int NormalTurtle = 1;
    public static final int Heart = 2;
    public static final int Diamond = 3;
    public static final int Clover = 4;
    public static final int Spade = 5;
    public static final int Star = 6;
    public static final int HexaStar = 7;
    public static final int Polygon = 8;
    public static final int RoundRect = 9;
    public static final int Leaf = 10;
    public static final String LibraryVersion = "0.9.7.2";
    public static final Color Green = Color.green;
    public static final Color Red = Color.red;
    public static final Color Blue = Color.blue;
    public static final Color Yellow = Color.yellow;
    public static final Color Magenta = Color.magenta;
    public static final Color Cyan = Color.cyan;
    public static final Color Orange = Color.orange;
    public static final Color Pink = Color.pink;
    public static final Color Gray = Color.gray;
    public static final Color White = Color.white;
    public static final Color Black = Color.black;
    private static final String[] propertyMenuString = new String[]{"Center Oriented", "Color Turtles", "Show Turtle"};
    private static final String[] speedMenuString = new String[]{"No Wait", "Fast", "Normal", "Slow"};
    private static final int[] speedStep = new int[]{-20, 20, 5, 2};
    private static final MenuItem[] fileMenuItem = new MenuItem[]{new MenuItem("Restart", new MenuShortcut(82)), new MenuItem("Stop", new MenuShortcut(83)), new MenuItem("Quit", new MenuShortcut(81))};
    private static final String[] fileMenuAction = new String[]{"Restart", "Stop", "Quit"};
    private static final Rectangle defaultBounds = new Rectangle(100, 100, 400, 400);
    private static final Rectangle dialogBounds = new Rectangle(200, 200, 400, 200);
    private static final String[] dialogButtons = new String[]{"Cancel", "OK"};
    private Applet applet = null;
    private MenuBar menubar = null;
    private TurtleCanvas canvas = null;
    private TurtleThread thread = null;
    private CheckboxMenuItem[] speedMenu = null;
    private CheckboxMenuItem[] propertyMenu = null;
    private Object restartLock = "Restart Locked";
    private boolean instanciationCompleted = true;
    private List allReservedInstances = new ArrayList();
    private List allInstances = new ArrayList();
    private boolean localTurtle = false;
    private boolean inputCaptured = true;
    private KeyEvent keyEvent = null;
    private MouseEvent mouseEvent = null;
    private MouseEvent mouseMotionEvent = null;

    public TurtleFrame() {
        this(defaultBounds);
        this.allReservedInstances.clear();
        this.addKeyListener(this);
        this.addWindowListener(new MyWindowAdapter());
        this.getCanvas().addKeyListener(this);
        this.getCanvas().addMouseListener(this);
        this.getCanvas().addMouseMotionListener(this);
        this.setVisible(true);
        this.getCanvas().mappedWait();
        this.restart();
        this.bluejInputLoop();
    }

    public TurtleFrame(Rectangle bounds) {
        super("Turtle Frame");
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        Menu file = new Menu("File", true);
        for (int i = 0; i < fileMenuItem.length; ++i) {
            MenuItem item = fileMenuItem[i];
            item.addActionListener(this);
            item.setActionCommand(fileMenuAction[i]);
            file.add(item);
        }
        this.menubar.add(file);
        Menu speed = new Menu("Speed", true);
        this.speedMenu = new CheckboxMenuItem[speedMenuString.length];
        for (int i = 0; i < speedMenuString.length; ++i) {
            this.speedMenu[i] = new CheckboxMenuItem(speedMenuString[i], false);
            this.speedMenu[i].addItemListener(this);
            speed.add(this.speedMenu[i]);
        }
        this.menubar.add(speed);
        this.speedMenu[2].setState(true);
        Menu property = new Menu("Property", true);
        this.propertyMenu = new CheckboxMenuItem[propertyMenuString.length];
        for (int i = 0; i < propertyMenuString.length; ++i) {
            this.propertyMenu[i] = new CheckboxMenuItem(propertyMenuString[i], false);
            this.propertyMenu[i].addItemListener(this);
            this.propertyMenu[i].setState(true);
            property.add(this.propertyMenu[i]);
        }
        this.menubar.add(property);
        this.canvas = new TurtleCanvas(this);
        this.getContentPane().add("Center", this.getCanvas());
        this.getCanvas().setBounds(bounds);
        this.setSize(bounds.width, bounds.height + 30);
    }

    private void bluejInputLoop() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    void restart() {
        this.stopThread();
        Turtle.resetColorOrderAtCreation();
        this.thread = new TurtleThread();
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThread() {
        Object object = this.restartLock;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.restartLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void dispose() {
        this.stopThread();
        super.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Quit")) {
            try {
                this.stopThread();
                System.exit(0);
            }
            catch (Exception ex) {
                this.dispose();
            }
        } else if (cmd.equals("Restart")) {
            this.stopThread();
            this.restart();
        } else if (cmd.equals("Stop")) {
            this.stopThread();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int i;
        String s = (String)e.getItem();
        for (i = 0; i < speedMenuString.length; ++i) {
            if (!s.equals(speedMenuString[i])) continue;
            if (TurtleAnimator.setSpeed(speedStep[i])) {
                for (int j = 0; j < speedMenuString.length; ++j) {
                    this.speedMenu[j].setState(i == j);
                }
            }
            return;
        }
        block7: for (i = 0; i < propertyMenuString.length; ++i) {
            if (!s.equals(propertyMenuString[i])) continue;
            switch (i) {
                case 0: {
                    Turtle.setCenterOriented(this.propertyMenu[i].getState());
                    continue block7;
                }
                case 1: {
                    Turtle.setMultipleColorAtCreation(this.propertyMenu[i].getState());
                    continue block7;
                }
                case 2: {
                    Turtle.setShowTurtleAtCreation(this.propertyMenu[i].getState());
                    continue block7;
                }
            }
        }
    }

    public void setWaitTurtle(boolean sw) {
        block4: {
            block3: {
                if (!sw) break block3;
                if (!TurtleAnimator.setSpeed(speedStep[2])) break block4;
                for (int j = 0; j < speedMenuString.length; ++j) {
                    this.speedMenu[j].setState(2 == j);
                }
                break block4;
            }
            if (TurtleAnimator.setSpeed(speedStep[0])) {
                for (int j = 0; j < speedMenuString.length; ++j) {
                    this.speedMenu[j].setState(0 == j);
                }
            }
        }
    }

    private synchronized void setLocalTurtle(boolean t) {
        this.localTurtle = t;
    }

    private synchronized boolean isLocalTurtle() {
        return this.localTurtle;
    }

    public List getAllInstances() {
        return this.allInstances;
    }

    public ArrayList getAllReservedInstances() {
        return new ArrayList(this.allReservedInstances);
    }

    public synchronized void registerTurtle(Turtle t) {
        this.getCanvas().mappedWait();
        if (!this.isLocalTurtle()) {
            this.allReservedInstances.add(t);
        }
        this.allInstances.add(t);
    }

    public synchronized void removeTurtle(Turtle t) {
        this.getCanvas().mappedWait();
        this.allReservedInstances.remove(t);
        this.allInstances.remove(t);
    }

    public synchronized void resetAllInstances() {
        this.getCanvas().mappedWait();
        this.allInstances = new ArrayList();
        for (int i = 0; i < this.allReservedInstances.size(); ++i) {
            Turtle t = (Turtle)this.allReservedInstances.get(i);
            t.initialize();
            this.allInstances.add(t);
        }
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
        this.validate();
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
        this.validate();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    public void keyPressed(KeyEvent e) {
        this.keyEvent = e;
        this.inputCaptured = false;
        this.keyPressed(e.getKeyCode());
    }

    public void keyReleased(KeyEvent e) {
        this.keyReleased(e.getKeyCode());
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public int getKey() {
        this.inputCaptured = true;
        return this.keyEvent != null ? this.keyEvent.getKeyCode() : -1;
    }

    public boolean isKeyDown() {
        this.inputCaptured = true;
        return this.keyEvent != null;
    }

    private void resetKey() {
        if (this.inputCaptured) {
            this.keyEvent = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        this.inputCaptured = false;
        this.mousePressed(e.getX(), e.getY());
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseReleased(e.getX(), e.getY());
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMotionEvent = e;
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseMotionEvent = e;
    }

    public void mousePressed(int x, int y) {
    }

    public void mouseReleased(int x, int y) {
    }

    public int getMouseX() {
        this.inputCaptured = true;
        if (this.mouseEvent != null) {
            return this.mouseEvent.getX();
        }
        if (this.mouseMotionEvent != null) {
            return this.mouseMotionEvent.getX();
        }
        return 0;
    }

    public int getMouseY() {
        this.inputCaptured = true;
        if (this.mouseEvent != null) {
            return this.mouseEvent.getY();
        }
        if (this.mouseMotionEvent != null) {
            return this.mouseMotionEvent.getY();
        }
        return 0;
    }

    public boolean isMouseDown() {
        this.inputCaptured = true;
        return this.mouseEvent != null;
    }

    public boolean isLeftMouseDown() {
        this.inputCaptured = true;
        return this.mouseEvent == null ? false : this.mouseEvent.getButton() == 1;
    }

    public boolean isRightMouseDown() {
        this.inputCaptured = true;
        return this.mouseEvent == null ? false : this.mouseEvent.getButton() == 3;
    }

    public boolean isDoubleClick() {
        this.inputCaptured = true;
        return this.mouseEvent == null ? false : this.mouseEvent.getClickCount() == 2;
    }

    private void resetMouse() {
        if (this.inputCaptured) {
            this.mouseEvent = null;
        }
    }

    public String inputString(String prompt) {
        System.out.print(prompt);
        return this.inputString();
    }

    public String inputString() {
        try {
            return new Scanner(System.in).next();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getLineFeed() {
        return System.getProperty("line.separator");
    }

    public int inputInteger(String prompt) {
        System.out.print(prompt);
        return this.inputInteger();
    }

    public int inputInteger() {
        int value = 0;
        value = Integer.parseInt(this.inputString());
        return value;
    }

    public int inputInteger(String prompt, int base) {
        System.out.print(prompt);
        return this.inputInteger(base);
    }

    public int inputInteger(int base) {
        int value = 0;
        value = Integer.parseInt(this.inputString(), base);
        return value;
    }

    public long inputLongInteger(String prompt) {
        System.out.print(prompt);
        return this.inputLongInteger();
    }

    public long inputLongInteger() {
        long value = 0L;
        value = Long.parseLong(this.inputString());
        return value;
    }

    public long inputLongInteger(String prompt, int base) {
        System.out.print(prompt);
        return this.inputLongInteger(base);
    }

    public long inputLongInteger(int base) {
        long value = 0L;
        value = Long.parseLong(this.inputString(), base);
        return value;
    }

    public double inputNumber(String prompt) {
        System.out.print(prompt);
        return this.inputNumber();
    }

    public double inputNumber() {
        double value = 0.0;
        value = Double.parseDouble(this.inputString());
        return value;
    }

    public void print(Object o) {
        System.out.print(o);
    }

    public void print(int x) {
        System.out.print(x);
    }

    public void print(long x) {
        System.out.print(x);
    }

    public void print(float x) {
        System.out.print(x);
    }

    public void print(double x) {
        System.out.print(x);
    }

    public void print(boolean x) {
        System.out.print(x);
    }

    public void printLine(Object o) {
        System.out.println(o);
    }

    public void printLine(int x) {
        System.out.println(x);
    }

    public void printLine(long x) {
        System.out.println(x);
    }

    public void printLine(double x) {
        System.out.println(x);
    }

    public void printLine(float x) {
        System.out.println(x);
    }

    public void printLine(boolean x) {
        System.out.println(x);
    }

    public void printLine() {
        System.out.println();
    }

    public void printTurtleVersion() {
        System.out.println("SFC Turtle Graphics version 0.9.7.2 by Tatsuo Minohara");
    }

    public void displayDialog(int value) {
        this.displayDialog("" + value, 18);
    }

    public void displayDialog(int value, int base) {
        this.displayDialog(Integer.toString(value, base), 18);
    }

    public void displayDialog(long value) {
        this.displayDialog("" + value, 18);
    }

    public void displayDialog(long value, int base) {
        this.displayDialog(Long.toString(value, base), 18);
    }

    public void displayDialog(double value) {
        this.displayDialog("" + value, 18);
    }

    public void displayDialog(String message) {
        this.displayDialog(message, 18);
    }

    public void displayDialog(String message, int size) {
        this.displayDialog(message, new Font("Dialog", 0, size));
    }

    public void displayDialog(String message, Font font) {
        int value;
        JOptionPane pane = new JOptionPane(message, 1, 2);
        this.setFontRecursive(pane, font);
        JDialog dialog = pane.createDialog(this, "Message Dialog");
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            System.exit(0);
        }
        if ((value = ((Integer)selectedValue).intValue()) == 2) {
            System.exit(0);
        }
    }

    void setFontRecursive(Container p, Font font) {
        Component[] c = p.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof JLabel || c[i] instanceof TextComponent || c[i] instanceof JTextComponent) {
                c[i].setFont(font);
            }
            if (!(c[i] instanceof Container)) continue;
            this.setFontRecursive((Container)c[i], font);
        }
    }

    public int displayInputDialog(String message, int defaultvalue) {
        String result = this.displayInputDialog(message, "" + defaultvalue);
        return this.convertToInteger(result);
    }

    public int displayInputDialog(String message, int defaultvalue, int base) {
        String result = this.displayInputDialog(message, "" + defaultvalue);
        return this.convertToInteger(result, base);
    }

    public long displayInputDialog(String message, long defaultvalue) {
        String result = this.displayInputDialog(message, "" + defaultvalue);
        return this.convertToLongInteger(result);
    }

    public long displayInputDialog(String message, long defaultvalue, int base) {
        String result = this.displayInputDialog(message, "" + defaultvalue);
        return this.convertToLongInteger(result, base);
    }

    public double displayInputDialog(String message, double defaultvalue) {
        String result = this.displayInputDialog(message, "" + defaultvalue);
        return this.convertToNumber(result);
    }

    public String displayInputDialog(String message, String defaultvalue) {
        return this.displayInputDialog(message, defaultvalue, 18);
    }

    public String displayInputDialog(String message, String defaultvalue, int size) {
        return this.displayInputDialog(message, defaultvalue, new Font("Dialog", 0, size));
    }

    public String displayInputDialog(String message, String defaultvalue, Font font) {
        int value;
        JOptionPane pane = new JOptionPane(message, 3, 2);
        pane.setWantsInput(true);
        this.setFontRecursive(pane, font);
        this.setInputValue(pane, defaultvalue);
        JDialog dialog = pane.createDialog(this, "Input Value Dialog");
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            System.exit(0);
        }
        if ((value = ((Integer)selectedValue).intValue()) == 2) {
            System.exit(0);
        }
        return (String)pane.getInputValue();
    }

    void setInputValue(Container p, String value) {
        Component[] c = p.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof JTextComponent) {
                ((JTextComponent)c[i]).setText(value);
                continue;
            }
            if (!(c[i] instanceof Container)) continue;
            this.setInputValue((Container)c[i], value);
        }
    }

    public String displaySelectDialog(String message, String[] values) {
        return this.displaySelectDialog(message, values, 18);
    }

    public String displaySelectDialog(String message, String[] values, int size) {
        return this.displaySelectDialog(message, (Object[])values, new Font("Dialog", 0, size));
    }

    public String displaySelectDialog(String message, Object[] values, Font font) {
        JOptionPane pane = new JOptionPane(message, 1, 2, null, values, values[0]);
        this.setFontRecursive(pane, font);
        JDialog dialog = pane.createDialog(this, "Select Value Dialog");
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            System.exit(0);
        }
        return (String)selectedValue;
    }

    public String displayChoiceSelectDialog(String message, Object[] values) {
        Object selectedValue = JOptionPane.showInputDialog(this, message, "Select Value Dialog", 1, null, values, values[0]);
        if (selectedValue == null) {
            System.exit(0);
        }
        return (String)selectedValue;
    }

    public int displaySelectTurtle(int x, int y, int size, String message, int defaultanswer) {
        TextTurtle tt3;
        TextTurtle tt2;
        TextTurtle tt1;
        int rpoint = message.indexOf("\n");
        if (rpoint == -1) {
            tt1 = new TextTurtle(message, Black, size, this);
            tt1.setLocation(tt1.getWidth() / 2.0 + (double)x, tt1.getHeight() / 2.0 + (double)y);
            tt2 = null;
            tt3 = new TextTurtle("" + defaultanswer, Blue, size, this);
            tt3.setLocation(tt3.getWidth() / 2.0 + (double)x, tt3.getHeight() / 2.0 + (double)y + (double)size + 2.0);
        } else {
            tt1 = new TextTurtle(message.substring(0, rpoint), Black, size, this);
            tt1.setLocation(tt1.getWidth() / 2.0 + (double)x, tt1.getHeight() / 2.0 + (double)y);
            tt2 = new TextTurtle(message.substring(rpoint + 1), Black, size, this);
            tt2.setLocation(tt2.getWidth() / 2.0 + (double)x, tt2.getHeight() / 2.0 + (double)y + (double)size + 2.0);
            tt3 = new TextTurtle("" + defaultanswer, Blue, size, this);
            tt3.setLocation(tt3.getWidth() / 2.0 + (double)x, tt3.getHeight() / 2.0 + (double)y + (double)(size * 2) + 4.0);
        }
        int answer = defaultanswer;
        while (true) {
            int code;
            if ((code = this.getKey()) == 10) {
                tt1.hideTurtle();
                if (rpoint != -1) {
                    tt2.hideTurtle();
                }
                tt3.hideTurtle();
                this.update();
                return answer;
            }
            if (code >= 48 && code <= 57) {
                tt3.setText("" + (code - 48));
                answer = code - 48;
            }
            this.update();
            this.sleep(0.3);
        }
    }

    public String displayInputTurtle(int x, int y, int size, String message, String defaultinput) {
        String answer = defaultinput;
        TextTurtle tt1 = new TextTurtle(message, Black, size, this);
        tt1.setLocation(tt1.getWidth() / 2.0 + (double)x, tt1.getHeight() / 2.0 + (double)y);
        TextTurtle tt2 = new TextTurtle(answer, Blue, size, this);
        tt2.setLocation(tt2.getWidth() / 2.0 + (double)x, tt2.getHeight() / 2.0 + (double)y + (double)size + 2.0);
        while (true) {
            int code;
            if ((code = this.getKey()) == 10) {
                tt1.hideTurtle();
                tt2.hideTurtle();
                this.update();
                return answer;
            }
            if (code == 8 || code == 127) {
                if (answer.length() > 0) {
                    answer = answer.substring(0, answer.length() - 1);
                    tt2.setText(answer);
                }
            } else if (code == 32) {
                answer = answer + " ";
                tt2.setText(answer);
            } else if (code >= 48 && code <= 57) {
                answer = answer + (char)(code - 48 + 48);
                tt2.setText(answer);
            } else if (code >= 65 && code <= 90) {
                answer = answer + (char)(code - 65 + 97);
                tt2.setText(answer);
            }
            this.update();
            this.sleep(0.1);
        }
    }

    public int convertToInteger(String s) {
        int value = 0;
        value = Integer.parseInt(s);
        return value;
    }

    public long convertToLongInteger(String s) {
        long value = 0L;
        value = Long.parseLong(s);
        return value;
    }

    public int convertToInteger(String s, int base) {
        int value = 0;
        value = Integer.parseInt(s, base);
        return value;
    }

    public long convertToLongInteger(String s, int base) {
        long value = 0L;
        value = Long.parseLong(s, base);
        return value;
    }

    public double convertToNumber(String s) {
        double value = 0.0;
        value = Double.parseDouble(s);
        return value;
    }

    public String formatInteger(int min, int max, long value) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(min);
        nf.setMaximumIntegerDigits(max);
        nf.setGroupingUsed(false);
        return nf.format(value);
    }

    public String formatNumber(int min, int max, int fmin, int fmax, double value) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(min);
        nf.setMaximumIntegerDigits(max);
        nf.setMinimumFractionDigits(fmin);
        nf.setMaximumFractionDigits(fmax);
        nf.setGroupingUsed(false);
        return nf.format(value);
    }

    public int getYear() {
        return this.getCalendar().get(1);
    }

    public int getMonth() {
        return this.getCalendar().get(2) + 1;
    }

    public int getDay() {
        return this.getCalendar().get(5);
    }

    public int getWeekDay() {
        return this.getCalendar().get(7) - 1;
    }

    public int getHour() {
        return this.getCalendar().get(11);
    }

    public int getMinute() {
        return this.getCalendar().get(12);
    }

    public int getSecond() {
        return this.getCalendar().get(13);
    }

    public long getMilliSecond() {
        return this.getCalendar().get(14);
    }

    public long getTotalMilliSecond() {
        return this.getCalendar().getTimeInMillis();
    }

    public Calendar getCalendar() {
        return new GregorianCalendar(TimeZone.getTimeZone("GMT+09"));
    }

    public String getDateString() {
        return this.getCalendar().getTime().toString();
    }

    public int random(int max) {
        return (int)(Math.random() * (double)max);
    }

    public double randomNumber(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public int randomInteger(int min, int max) {
        return (int)(Math.random() * (double)(max + 1 - min)) + min;
    }

    public void sleep(double second) {
        if (!this.instanciationCompleted) {
            throw new RuntimeException("Sleep method is called while a turtle creation.");
        }
        try {
            Thread.sleep((long)(second * 1000.0));
        }
        catch (Exception ex) {
            throw new RuntimeException();
        }
    }

    public AudioClip getAudioClip(String filename) {
        return Applet.newAudioClip(this.getClass().getResource(filename));
    }

    public BufferedImage loadBufferedImage(String filename) {
        Image image = this.loadImage(filename);
        if (image != null) {
            return this.createBufferedImage(image);
        }
        return this.createTextImage(filename);
    }

    public Image loadImage(String filename) {
        try {
            if (this.applet == null && !new File(filename).exists()) {
                this.print("Error: Image File is not found at " + filename);
                return null;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            MediaTracker mt = new MediaTracker(this);
            Image image = null;
            if (this.applet == null) {
                image = toolkit.getImage(filename);
            } else {
                image = this.applet.getImage(this.applet.getCodeBase(), filename);
                System.out.println(this.applet.getCodeBase());
            }
            mt.addImage(image, 0);
            mt.waitForAll();
            if (mt.isErrorID(0)) {
                if (new File(filename).exists()) {
                    this.print("Error: the image format is not acceptable in " + filename);
                }
                return null;
            }
            return image;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public BufferedImage createBufferedImage(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 6);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public BufferedImage createTextImage(String text) {
        int width = 100;
        int height = 100;
        BufferedImage bufferedImage = new BufferedImage(width, height, 6);
        Graphics g = bufferedImage.getGraphics();
        g.setColor(Color.black);
        g.drawRect(0, 0, width - 1, height - 1);
        g.drawString(text, 20, height / 2);
        g.dispose();
        return bufferedImage;
    }

    public void update() {
        this.getCanvas().repaint();
        this.resetKey();
        this.resetMouse();
    }

    public void paint(Graphics2D g) {
        this.getCanvas().paint(g);
    }

    public void start() {
        System.out.println("TurtleFrame's start");
    }

    public TurtleCanvas getCanvas() {
        return this.canvas;
    }

    public void setBackgroundColor(Color c) {
        this.canvas.setBackgroundColor(c);
    }

    public Color getBackgoundColor() {
        return this.canvas.getBackgroundColor();
    }

    class MyWindowAdapter
    extends WindowAdapter {
        MyWindowAdapter() {
        }

        public void windowClosing(WindowEvent event) {
            TurtleFrame.this.setVisible(false);
            System.exit(0);
        }
    }

    class TurtleThread
    extends Thread {
        TurtleThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                TurtleFrame.this.resetAllInstances();
                TurtleFrame.this.setLocalTurtle(true);
                TurtleFrame.this.start();
                Object object = TurtleFrame.this.restartLock;
                synchronized (object) {
                    TurtleFrame.this.setLocalTurtle(false);
                    TurtleFrame.this.thread = null;
                    TurtleFrame.this.restartLock.notify();
                }
            }
            catch (Exception ex) {
                Object object = TurtleFrame.this.restartLock;
                synchronized (object) {
                    TurtleFrame.this.setLocalTurtle(false);
                    TurtleFrame.this.thread = null;
                    TurtleFrame.this.restartLock.notify();
                }
            }
        }
    }
}

