﻿#define _WIN32_WINNT 0x600
#define WIN32_LEAN_AND_MEAN 1
#define UNICODE  1
#define _UNICODE 1
#include <Windows.h>
enum Encoding;
#include "encoding.h"
namespace Ck{
namespace Enc{
static const WCHAR _sjis_to_ucs_0000_data []={ //0001 00FF
	       0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
	0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,0x0088,0x0089,0x008A,0x008B,0x008C,0x008D,0x008E,0x008F,
	0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,0x0098,0x0099,0x009A,0x009B,0x009C,0x009D,0x009E,0x009F,
	0xF8F0,0xFF61,0xFF62,0xFF63,0xFF64,0xFF65,0xFF66,0xFF67,0xFF68,0xFF69,0xFF6A,0xFF6B,0xFF6C,0xFF6D,0xFF6E,0xFF6F,
	0xFF70,0xFF71,0xFF72,0xFF73,0xFF74,0xFF75,0xFF76,0xFF77,0xFF78,0xFF79,0xFF7A,0xFF7B,0xFF7C,0xFF7D,0xFF7E,0xFF7F,
	0xFF80,0xFF81,0xFF82,0xFF83,0xFF84,0xFF85,0xFF86,0xFF87,0xFF88,0xFF89,0xFF8A,0xFF8B,0xFF8C,0xFF8D,0xFF8E,0xFF8F,
	0xFF90,0xFF91,0xFF92,0xFF93,0xFF94,0xFF95,0xFF96,0xFF97,0xFF98,0xFF99,0xFF9A,0xFF9B,0xFF9C,0xFF9D,0xFF9E,0xFF9F,
	0x00E0,0x00E1,0x00E2,0x00E3,0x00E4,0x00E5,0x00E6,0x00E7,0x00E8,0x00E9,0x00EA,0x00EB,0x00EC,0x00ED,0x00EE,0x00EF,
	0x00F0,0x00F1,0x00F2,0x00F3,0x00F4,0x00F5,0x00F6,0x00F7,0x00F8,0x00F9,0x00FA,0x00FB,0x00FC,0xF8F1,0xF8F2,0xF8F3,
};
static const WCHAR _sjis_to_ucs_8100_data []={ //8140 81FC
	0x3000,0x3001,0x3002,0xFF0C,0xFF0E,0x30FB,0xFF1A,0xFF1B,0xFF1F,0xFF01,0x309B,0x309C,0x00B4,0xFF40,0x00A8,0xFF3E,
	0xFFE3,0xFF3F,0x30FD,0x30FE,0x309D,0x309E,0x3003,0x4EDD,0x3005,0x3006,0x3007,0x30FC,0x2015,0x2010,0xFF0F,0xFF3C,
	0xFF5E,0x2225,0xFF5C,0x2026,0x2025,0x2018,0x2019,0x201C,0x201D,0xFF08,0xFF09,0x3014,0x3015,0xFF3B,0xFF3D,0xFF5B,
	0xFF5D,0x3008,0x3009,0x300A,0x300B,0x300C,0x300D,0x300E,0x300F,0x3010,0x3011,0xFF0B,0xFF0D,0x00B1,0x00D7,0x0000,
	0x00F7,0xFF1D,0x2260,0xFF1C,0xFF1E,0x2266,0x2267,0x221E,0x2234,0x2642,0x2640,0x00B0,0x2032,0x2033,0x2103,0xFFE5,
	0xFF04,0xFFE0,0xFFE1,0xFF05,0xFF03,0xFF06,0xFF0A,0xFF20,0x00A7,0x2606,0x2605,0x25CB,0x25CF,0x25CE,0x25C7,0x25C6,
	0x25A1,0x25A0,0x25B3,0x25B2,0x25BD,0x25BC,0x203B,0x3012,0x2192,0x2190,0x2191,0x2193,0x3013,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2208,0x220B,0x2286,0x2287,0x2282,0x2283,0x222A,0x2229,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2227,0x2228,0xFFE2,0x21D2,0x21D4,0x2200,0x2203,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2220,0x22A5,0x2312,0x2202,0x2207,0x2261,
	0x2252,0x226A,0x226B,0x221A,0x223D,0x221D,0x2235,0x222B,0x222C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x212B,0x2030,0x266F,0x266D,0x266A,0x2020,0x2021,0x00B6,0x0000,0x0000,0x0000,0x0000,0x25EF,
};
static const WCHAR _sjis_to_ucs_8200_data []={ //824F 82F1
	                                                                                                         0xFF10,
	0xFF11,0xFF12,0xFF13,0xFF14,0xFF15,0xFF16,0xFF17,0xFF18,0xFF19,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xFF21,0xFF22,0xFF23,0xFF24,0xFF25,0xFF26,0xFF27,0xFF28,0xFF29,0xFF2A,0xFF2B,0xFF2C,0xFF2D,0xFF2E,0xFF2F,0xFF30,
	0xFF31,0xFF32,0xFF33,0xFF34,0xFF35,0xFF36,0xFF37,0xFF38,0xFF39,0xFF3A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xFF41,0xFF42,0xFF43,0xFF44,0xFF45,0xFF46,0xFF47,0xFF48,0xFF49,0xFF4A,0xFF4B,0xFF4C,0xFF4D,0xFF4E,0xFF4F,
	0xFF50,0xFF51,0xFF52,0xFF53,0xFF54,0xFF55,0xFF56,0xFF57,0xFF58,0xFF59,0xFF5A,0x0000,0x0000,0x0000,0x0000,0x3041,
	0x3042,0x3043,0x3044,0x3045,0x3046,0x3047,0x3048,0x3049,0x304A,0x304B,0x304C,0x304D,0x304E,0x304F,0x3050,0x3051,
	0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,0x3058,0x3059,0x305A,0x305B,0x305C,0x305D,0x305E,0x305F,0x3060,0x3061,
	0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,0x3068,0x3069,0x306A,0x306B,0x306C,0x306D,0x306E,0x306F,0x3070,0x3071,
	0x3072,0x3073,0x3074,0x3075,0x3076,0x3077,0x3078,0x3079,0x307A,0x307B,0x307C,0x307D,0x307E,0x307F,0x3080,0x3081,
	0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,0x3088,0x3089,0x308A,0x308B,0x308C,0x308D,0x308E,0x308F,0x3090,0x3091,
	0x3092,0x3093,
};
static const WCHAR _sjis_to_ucs_8300_data []={ //8340 83D6
	0x30A1,0x30A2,0x30A3,0x30A4,0x30A5,0x30A6,0x30A7,0x30A8,0x30A9,0x30AA,0x30AB,0x30AC,0x30AD,0x30AE,0x30AF,0x30B0,
	0x30B1,0x30B2,0x30B3,0x30B4,0x30B5,0x30B6,0x30B7,0x30B8,0x30B9,0x30BA,0x30BB,0x30BC,0x30BD,0x30BE,0x30BF,0x30C0,
	0x30C1,0x30C2,0x30C3,0x30C4,0x30C5,0x30C6,0x30C7,0x30C8,0x30C9,0x30CA,0x30CB,0x30CC,0x30CD,0x30CE,0x30CF,0x30D0,
	0x30D1,0x30D2,0x30D3,0x30D4,0x30D5,0x30D6,0x30D7,0x30D8,0x30D9,0x30DA,0x30DB,0x30DC,0x30DD,0x30DE,0x30DF,0x0000,
	0x30E0,0x30E1,0x30E2,0x30E3,0x30E4,0x30E5,0x30E6,0x30E7,0x30E8,0x30E9,0x30EA,0x30EB,0x30EC,0x30ED,0x30EE,0x30EF,
	0x30F0,0x30F1,0x30F2,0x30F3,0x30F4,0x30F5,0x30F6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0391,
	0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039A,0x039B,0x039C,0x039D,0x039E,0x039F,0x03A0,0x03A1,
	0x03A3,0x03A4,0x03A5,0x03A6,0x03A7,0x03A8,0x03A9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x03B1,
	0x03B2,0x03B3,0x03B4,0x03B5,0x03B6,0x03B7,0x03B8,0x03B9,0x03BA,0x03BB,0x03BC,0x03BD,0x03BE,0x03BF,0x03C0,0x03C1,
	0x03C3,0x03C4,0x03C5,0x03C6,0x03C7,0x03C8,0x03C9,
};
static const WCHAR _sjis_to_ucs_8400_data []={ //8440 84BE
	0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0401,0x0416,0x0417,0x0418,0x0419,0x041A,0x041B,0x041C,0x041D,0x041E,
	0x041F,0x0420,0x0421,0x0422,0x0423,0x0424,0x0425,0x0426,0x0427,0x0428,0x0429,0x042A,0x042B,0x042C,0x042D,0x042E,
	0x042F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0451,0x0436,0x0437,0x0438,0x0439,0x043A,0x043B,0x043C,0x043D,0x0000,
	0x043E,0x043F,0x0440,0x0441,0x0442,0x0443,0x0444,0x0445,0x0446,0x0447,0x0448,0x0449,0x044A,0x044B,0x044C,0x044D,
	0x044E,0x044F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2500,
	0x2502,0x250C,0x2510,0x2518,0x2514,0x251C,0x252C,0x2524,0x2534,0x253C,0x2501,0x2503,0x250F,0x2513,0x251B,0x2517,
	0x2523,0x2533,0x252B,0x253B,0x254B,0x2520,0x252F,0x2528,0x2537,0x253F,0x251D,0x2530,0x2525,0x2538,0x2542,
};
static const WCHAR _sjis_to_ucs_8700_data []={ //8740 8799
	0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467,0x2468,0x2469,0x246A,0x246B,0x246C,0x246D,0x246E,0x246F,
	0x2470,0x2471,0x2472,0x2473,0x2160,0x2161,0x2162,0x2163,0x2164,0x2165,0x2166,0x2167,0x2168,0x2169,0x0000,0x3349,
	0x3314,0x3322,0x334D,0x3318,0x3327,0x3303,0x3336,0x3351,0x3357,0x330D,0x3326,0x3323,0x332B,0x334A,0x333B,0x339C,
	0x339D,0x339E,0x338E,0x338F,0x33C4,0x33A1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x337B,0x0000,
	0x301D,0x301F,0x2116,0x33CD,0x2121,0x32A4,0x32A5,0x32A6,0x32A7,0x32A8,0x3231,0x3232,0x3239,0x337E,0x337D,0x337C,
	0x0000,0x0000,0x0000,0x222E,0x2211,0x0000,0x0000,0x0000,0x221F,0x22BF,
};
static const WCHAR _sjis_to_ucs_8800_data []={ //889F 88FC
	                                                                                                         0x4E9C,
	0x5516,0x5A03,0x963F,0x54C0,0x611B,0x6328,0x59F6,0x9022,0x8475,0x831C,0x7A50,0x60AA,0x63E1,0x6E25,0x65ED,0x8466,
	0x82A6,0x9BF5,0x6893,0x5727,0x65A1,0x6271,0x5B9B,0x59D0,0x867B,0x98F4,0x7D62,0x7DBE,0x9B8E,0x6216,0x7C9F,0x88B7,
	0x5B89,0x5EB5,0x6309,0x6697,0x6848,0x95C7,0x978D,0x674F,0x4EE5,0x4F0A,0x4F4D,0x4F9D,0x5049,0x56F2,0x5937,0x59D4,
	0x5A01,0x5C09,0x60DF,0x610F,0x6170,0x6613,0x6905,0x70BA,0x754F,0x7570,0x79FB,0x7DAD,0x7DEF,0x80C3,0x840E,0x8863,
	0x8B02,0x9055,0x907A,0x533B,0x4E95,0x4EA5,0x57DF,0x80B2,0x90C1,0x78EF,0x4E00,0x58F1,0x6EA2,0x9038,0x7A32,0x8328,
	0x828B,0x9C2F,0x5141,0x5370,0x54BD,0x54E1,0x56E0,0x59FB,0x5F15,0x98F2,0x6DEB,0x80E4,0x852D,
};
static const WCHAR _sjis_to_ucs_8900_data []={ //8940 89FC
	0x9662,0x9670,0x96A0,0x97FB,0x540B,0x53F3,0x5B87,0x70CF,0x7FBD,0x8FC2,0x96E8,0x536F,0x9D5C,0x7ABA,0x4E11,0x7893,
	0x81FC,0x6E26,0x5618,0x5504,0x6B1D,0x851A,0x9C3B,0x59E5,0x53A9,0x6D66,0x74DC,0x958F,0x5642,0x4E91,0x904B,0x96F2,
	0x834F,0x990C,0x53E1,0x55B6,0x5B30,0x5F71,0x6620,0x66F3,0x6804,0x6C38,0x6CF3,0x6D29,0x745B,0x76C8,0x7A4E,0x9834,
	0x82F1,0x885B,0x8A60,0x92ED,0x6DB2,0x75AB,0x76CA,0x99C5,0x60A6,0x8B01,0x8D8A,0x95B2,0x698E,0x53AD,0x5186,0x0000,
	0x5712,0x5830,0x5944,0x5BB4,0x5EF6,0x6028,0x63A9,0x63F4,0x6CBF,0x6F14,0x708E,0x7114,0x7159,0x71D5,0x733F,0x7E01,
	0x8276,0x82D1,0x8597,0x9060,0x925B,0x9D1B,0x5869,0x65BC,0x6C5A,0x7525,0x51F9,0x592E,0x5965,0x5F80,0x5FDC,0x62BC,
	0x65FA,0x6A2A,0x6B27,0x6BB4,0x738B,0x7FC1,0x8956,0x9D2C,0x9D0E,0x9EC4,0x5CA1,0x6C96,0x837B,0x5104,0x5C4B,0x61B6,
	0x81C6,0x6876,0x7261,0x4E59,0x4FFA,0x5378,0x6069,0x6E29,0x7A4F,0x97F3,0x4E0B,0x5316,0x4EEE,0x4F55,0x4F3D,0x4FA1,
	0x4F73,0x52A0,0x53EF,0x5609,0x590F,0x5AC1,0x5BB6,0x5BE1,0x79D1,0x6687,0x679C,0x67B6,0x6B4C,0x6CB3,0x706B,0x73C2,
	0x798D,0x79BE,0x7A3C,0x7B87,0x82B1,0x82DB,0x8304,0x8377,0x83EF,0x83D3,0x8766,0x8AB2,0x5629,0x8CA8,0x8FE6,0x904E,
	0x971E,0x868A,0x4FC4,0x5CE8,0x6211,0x7259,0x753B,0x81E5,0x82BD,0x86FE,0x8CC0,0x96C5,0x9913,0x99D5,0x4ECB,0x4F1A,
	0x89E3,0x56DE,0x584A,0x58CA,0x5EFB,0x5FEB,0x602A,0x6094,0x6062,0x61D0,0x6212,0x62D0,0x6539,
};
static const WCHAR _sjis_to_ucs_8A00_data []={ //8A40 8AFC
	0x9B41,0x6666,0x68B0,0x6D77,0x7070,0x754C,0x7686,0x7D75,0x82A5,0x87F9,0x958B,0x968E,0x8C9D,0x51F1,0x52BE,0x5916,
	0x54B3,0x5BB3,0x5D16,0x6168,0x6982,0x6DAF,0x788D,0x84CB,0x8857,0x8A72,0x93A7,0x9AB8,0x6D6C,0x99A8,0x86D9,0x57A3,
	0x67FF,0x86CE,0x920E,0x5283,0x5687,0x5404,0x5ED3,0x62E1,0x64B9,0x683C,0x6838,0x6BBB,0x7372,0x78BA,0x7A6B,0x899A,
	0x89D2,0x8D6B,0x8F03,0x90ED,0x95A3,0x9694,0x9769,0x5B66,0x5CB3,0x697D,0x984D,0x984E,0x639B,0x7B20,0x6A2B,0x0000,
	0x6A7F,0x68B6,0x9C0D,0x6F5F,0x5272,0x559D,0x6070,0x62EC,0x6D3B,0x6E07,0x6ED1,0x845B,0x8910,0x8F44,0x4E14,0x9C39,
	0x53F6,0x691B,0x6A3A,0x9784,0x682A,0x515C,0x7AC3,0x84B2,0x91DC,0x938C,0x565B,0x9D28,0x6822,0x8305,0x8431,0x7CA5,
	0x5208,0x82C5,0x74E6,0x4E7E,0x4F83,0x51A0,0x5BD2,0x520A,0x52D8,0x52E7,0x5DFB,0x559A,0x582A,0x59E6,0x5B8C,0x5B98,
	0x5BDB,0x5E72,0x5E79,0x60A3,0x611F,0x6163,0x61BE,0x63DB,0x6562,0x67D1,0x6853,0x68FA,0x6B3E,0x6B53,0x6C57,0x6F22,
	0x6F97,0x6F45,0x74B0,0x7518,0x76E3,0x770B,0x7AFF,0x7BA1,0x7C21,0x7DE9,0x7F36,0x7FF0,0x809D,0x8266,0x839E,0x89B3,
	0x8ACC,0x8CAB,0x9084,0x9451,0x9593,0x9591,0x95A2,0x9665,0x97D3,0x9928,0x8218,0x4E38,0x542B,0x5CB8,0x5DCC,0x73A9,
	0x764C,0x773C,0x5CA9,0x7FEB,0x8D0B,0x96C1,0x9811,0x9854,0x9858,0x4F01,0x4F0E,0x5371,0x559C,0x5668,0x57FA,0x5947,
	0x5B09,0x5BC4,0x5C90,0x5E0C,0x5E7E,0x5FCC,0x63EE,0x673A,0x65D7,0x65E2,0x671F,0x68CB,0x68C4,
};
static const WCHAR _sjis_to_ucs_8B00_data []={ //8B40 8BFC
	0x6A5F,0x5E30,0x6BC5,0x6C17,0x6C7D,0x757F,0x7948,0x5B63,0x7A00,0x7D00,0x5FBD,0x898F,0x8A18,0x8CB4,0x8D77,0x8ECC,
	0x8F1D,0x98E2,0x9A0E,0x9B3C,0x4E80,0x507D,0x5100,0x5993,0x5B9C,0x622F,0x6280,0x64EC,0x6B3A,0x72A0,0x7591,0x7947,
	0x7FA9,0x87FB,0x8ABC,0x8B70,0x63AC,0x83CA,0x97A0,0x5409,0x5403,0x55AB,0x6854,0x6A58,0x8A70,0x7827,0x6775,0x9ECD,
	0x5374,0x5BA2,0x811A,0x8650,0x9006,0x4E18,0x4E45,0x4EC7,0x4F11,0x53CA,0x5438,0x5BAE,0x5F13,0x6025,0x6551,0x0000,
	0x673D,0x6C42,0x6C72,0x6CE3,0x7078,0x7403,0x7A76,0x7AAE,0x7B08,0x7D1A,0x7CFE,0x7D66,0x65E7,0x725B,0x53BB,0x5C45,
	0x5DE8,0x62D2,0x62E0,0x6319,0x6E20,0x865A,0x8A31,0x8DDD,0x92F8,0x6F01,0x79A6,0x9B5A,0x4EA8,0x4EAB,0x4EAC,0x4F9B,
	0x4FA0,0x50D1,0x5147,0x7AF6,0x5171,0x51F6,0x5354,0x5321,0x537F,0x53EB,0x55AC,0x5883,0x5CE1,0x5F37,0x5F4A,0x602F,
	0x6050,0x606D,0x631F,0x6559,0x6A4B,0x6CC1,0x72C2,0x72ED,0x77EF,0x80F8,0x8105,0x8208,0x854E,0x90F7,0x93E1,0x97FF,
	0x9957,0x9A5A,0x4EF0,0x51DD,0x5C2D,0x6681,0x696D,0x5C40,0x66F2,0x6975,0x7389,0x6850,0x7C81,0x50C5,0x52E4,0x5747,
	0x5DFE,0x9326,0x65A4,0x6B23,0x6B3D,0x7434,0x7981,0x79BD,0x7B4B,0x7DCA,0x82B9,0x83CC,0x887F,0x895F,0x8B39,0x8FD1,
	0x91D1,0x541F,0x9280,0x4E5D,0x5036,0x53E5,0x533A,0x72D7,0x7396,0x77E9,0x82E6,0x8EAF,0x99C6,0x99C8,0x99D2,0x5177,
	0x611A,0x865E,0x55B0,0x7A7A,0x5076,0x5BD3,0x9047,0x9685,0x4E32,0x6ADB,0x91E7,0x5C51,0x5C48,
};
static const WCHAR _sjis_to_ucs_8C00_data []={ //8C40 8CFC
	0x6398,0x7A9F,0x6C93,0x9774,0x8F61,0x7AAA,0x718A,0x9688,0x7C82,0x6817,0x7E70,0x6851,0x936C,0x52F2,0x541B,0x85AB,
	0x8A13,0x7FA4,0x8ECD,0x90E1,0x5366,0x8888,0x7941,0x4FC2,0x50BE,0x5211,0x5144,0x5553,0x572D,0x73EA,0x578B,0x5951,
	0x5F62,0x5F84,0x6075,0x6176,0x6167,0x61A9,0x63B2,0x643A,0x656C,0x666F,0x6842,0x6E13,0x7566,0x7A3D,0x7CFB,0x7D4C,
	0x7D99,0x7E4B,0x7F6B,0x830E,0x834A,0x86CD,0x8A08,0x8A63,0x8B66,0x8EFD,0x981A,0x9D8F,0x82B8,0x8FCE,0x9BE8,0x0000,
	0x5287,0x621F,0x6483,0x6FC0,0x9699,0x6841,0x5091,0x6B20,0x6C7A,0x6F54,0x7A74,0x7D50,0x8840,0x8A23,0x6708,0x4EF6,
	0x5039,0x5026,0x5065,0x517C,0x5238,0x5263,0x55A7,0x570F,0x5805,0x5ACC,0x5EFA,0x61B2,0x61F8,0x62F3,0x6372,0x691C,
	0x6A29,0x727D,0x72AC,0x732E,0x7814,0x786F,0x7D79,0x770C,0x80A9,0x898B,0x8B19,0x8CE2,0x8ED2,0x9063,0x9375,0x967A,
	0x9855,0x9A13,0x9E78,0x5143,0x539F,0x53B3,0x5E7B,0x5F26,0x6E1B,0x6E90,0x7384,0x73FE,0x7D43,0x8237,0x8A00,0x8AFA,
	0x9650,0x4E4E,0x500B,0x53E4,0x547C,0x56FA,0x59D1,0x5B64,0x5DF1,0x5EAB,0x5F27,0x6238,0x6545,0x67AF,0x6E56,0x72D0,
	0x7CCA,0x88B4,0x80A1,0x80E1,0x83F0,0x864E,0x8A87,0x8DE8,0x9237,0x96C7,0x9867,0x9F13,0x4E94,0x4E92,0x4F0D,0x5348,
	0x5449,0x543E,0x5A2F,0x5F8C,0x5FA1,0x609F,0x68A7,0x6A8E,0x745A,0x7881,0x8A9E,0x8AA4,0x8B77,0x9190,0x4E5E,0x9BC9,
	0x4EA4,0x4F7C,0x4FAF,0x5019,0x5016,0x5149,0x516C,0x529F,0x52B9,0x52FE,0x539A,0x53E3,0x5411,
};
static const WCHAR _sjis_to_ucs_8D00_data []={ //8D40 8DFC
	0x540E,0x5589,0x5751,0x57A2,0x597D,0x5B54,0x5B5D,0x5B8F,0x5DE5,0x5DE7,0x5DF7,0x5E78,0x5E83,0x5E9A,0x5EB7,0x5F18,
	0x6052,0x614C,0x6297,0x62D8,0x63A7,0x653B,0x6602,0x6643,0x66F4,0x676D,0x6821,0x6897,0x69CB,0x6C5F,0x6D2A,0x6D69,
	0x6E2F,0x6E9D,0x7532,0x7687,0x786C,0x7A3F,0x7CE0,0x7D05,0x7D18,0x7D5E,0x7DB1,0x8015,0x8003,0x80AF,0x80B1,0x8154,
	0x818F,0x822A,0x8352,0x884C,0x8861,0x8B1B,0x8CA2,0x8CFC,0x90CA,0x9175,0x9271,0x783F,0x92FC,0x95A4,0x964D,0x0000,
	0x9805,0x9999,0x9AD8,0x9D3B,0x525B,0x52AB,0x53F7,0x5408,0x58D5,0x62F7,0x6FE0,0x8C6A,0x8F5F,0x9EB9,0x514B,0x523B,
	0x544A,0x56FD,0x7A40,0x9177,0x9D60,0x9ED2,0x7344,0x6F09,0x8170,0x7511,0x5FFD,0x60DA,0x9AA8,0x72DB,0x8FBC,0x6B64,
	0x9803,0x4ECA,0x56F0,0x5764,0x58BE,0x5A5A,0x6068,0x61C7,0x660F,0x6606,0x6839,0x68B1,0x6DF7,0x75D5,0x7D3A,0x826E,
	0x9B42,0x4E9B,0x4F50,0x53C9,0x5506,0x5D6F,0x5DE6,0x5DEE,0x67FB,0x6C99,0x7473,0x7802,0x8A50,0x9396,0x88DF,0x5750,
	0x5EA7,0x632B,0x50B5,0x50AC,0x518D,0x6700,0x54C9,0x585E,0x59BB,0x5BB0,0x5F69,0x624D,0x63A1,0x683D,0x6B73,0x6E08,
	0x707D,0x91C7,0x7280,0x7815,0x7826,0x796D,0x658E,0x7D30,0x83DC,0x88C1,0x8F09,0x969B,0x5264,0x5728,0x6750,0x7F6A,
	0x8CA1,0x51B4,0x5742,0x962A,0x583A,0x698A,0x80B4,0x54B2,0x5D0E,0x57FC,0x7895,0x9DFA,0x4F5C,0x524A,0x548B,0x643E,
	0x6628,0x6714,0x67F5,0x7A84,0x7B56,0x7D22,0x932F,0x685C,0x9BAD,0x7B39,0x5319,0x518A,0x5237,
};
static const WCHAR _sjis_to_ucs_8E00_data []={ //8E40 8EFC
	0x5BDF,0x62F6,0x64AE,0x64E6,0x672D,0x6BBA,0x85A9,0x96D1,0x7690,0x9BD6,0x634C,0x9306,0x9BAB,0x76BF,0x6652,0x4E09,
	0x5098,0x53C2,0x5C71,0x60E8,0x6492,0x6563,0x685F,0x71E6,0x73CA,0x7523,0x7B97,0x7E82,0x8695,0x8B83,0x8CDB,0x9178,
	0x9910,0x65AC,0x66AB,0x6B8B,0x4ED5,0x4ED4,0x4F3A,0x4F7F,0x523A,0x53F8,0x53F2,0x55E3,0x56DB,0x58EB,0x59CB,0x59C9,
	0x59FF,0x5B50,0x5C4D,0x5E02,0x5E2B,0x5FD7,0x601D,0x6307,0x652F,0x5B5C,0x65AF,0x65BD,0x65E8,0x679D,0x6B62,0x0000,
	0x6B7B,0x6C0F,0x7345,0x7949,0x79C1,0x7CF8,0x7D19,0x7D2B,0x80A2,0x8102,0x81F3,0x8996,0x8A5E,0x8A69,0x8A66,0x8A8C,
	0x8AEE,0x8CC7,0x8CDC,0x96CC,0x98FC,0x6B6F,0x4E8B,0x4F3C,0x4F8D,0x5150,0x5B57,0x5BFA,0x6148,0x6301,0x6642,0x6B21,
	0x6ECB,0x6CBB,0x723E,0x74BD,0x75D4,0x78C1,0x793A,0x800C,0x8033,0x81EA,0x8494,0x8F9E,0x6C50,0x9E7F,0x5F0F,0x8B58,
	0x9D2B,0x7AFA,0x8EF8,0x5B8D,0x96EB,0x4E03,0x53F1,0x57F7,0x5931,0x5AC9,0x5BA4,0x6089,0x6E7F,0x6F06,0x75BE,0x8CEA,
	0x5B9F,0x8500,0x7BE0,0x5072,0x67F4,0x829D,0x5C61,0x854A,0x7E1E,0x820E,0x5199,0x5C04,0x6368,0x8D66,0x659C,0x716E,
	0x793E,0x7D17,0x8005,0x8B1D,0x8ECA,0x906E,0x86C7,0x90AA,0x501F,0x52FA,0x5C3A,0x6753,0x707C,0x7235,0x914C,0x91C8,
	0x932B,0x82E5,0x5BC2,0x5F31,0x60F9,0x4E3B,0x53D6,0x5B88,0x624B,0x6731,0x6B8A,0x72E9,0x73E0,0x7A2E,0x816B,0x8DA3,
	0x9152,0x9996,0x5112,0x53D7,0x546A,0x5BFF,0x6388,0x6A39,0x7DAC,0x9700,0x56DA,0x53CE,0x5468,
};
static const WCHAR _sjis_to_ucs_8F00_data []={ //8F40 8FFC
	0x5B97,0x5C31,0x5DDE,0x4FEE,0x6101,0x62FE,0x6D32,0x79C0,0x79CB,0x7D42,0x7E4D,0x7FD2,0x81ED,0x821F,0x8490,0x8846,
	0x8972,0x8B90,0x8E74,0x8F2F,0x9031,0x914B,0x916C,0x96C6,0x919C,0x4EC0,0x4F4F,0x5145,0x5341,0x5F93,0x620E,0x67D4,
	0x6C41,0x6E0B,0x7363,0x7E26,0x91CD,0x9283,0x53D4,0x5919,0x5BBF,0x6DD1,0x795D,0x7E2E,0x7C9B,0x587E,0x719F,0x51FA,
	0x8853,0x8FF0,0x4FCA,0x5CFB,0x6625,0x77AC,0x7AE3,0x821C,0x99FF,0x51C6,0x5FAA,0x65EC,0x696F,0x6B89,0x6DF3,0x0000,
	0x6E96,0x6F64,0x76FE,0x7D14,0x5DE1,0x9075,0x9187,0x9806,0x51E6,0x521D,0x6240,0x6691,0x66D9,0x6E1A,0x5EB6,0x7DD2,
	0x7F72,0x66F8,0x85AF,0x85F7,0x8AF8,0x52A9,0x53D9,0x5973,0x5E8F,0x5F90,0x6055,0x92E4,0x9664,0x50B7,0x511F,0x52DD,
	0x5320,0x5347,0x53EC,0x54E8,0x5546,0x5531,0x5617,0x5968,0x59BE,0x5A3C,0x5BB5,0x5C06,0x5C0F,0x5C11,0x5C1A,0x5E84,
	0x5E8A,0x5EE0,0x5F70,0x627F,0x6284,0x62DB,0x638C,0x6377,0x6607,0x660C,0x662D,0x6676,0x677E,0x68A2,0x6A1F,0x6A35,
	0x6CBC,0x6D88,0x6E09,0x6E58,0x713C,0x7126,0x7167,0x75C7,0x7701,0x785D,0x7901,0x7965,0x79F0,0x7AE0,0x7B11,0x7CA7,
	0x7D39,0x8096,0x83D6,0x848B,0x8549,0x885D,0x88F3,0x8A1F,0x8A3C,0x8A54,0x8A73,0x8C61,0x8CDE,0x91A4,0x9266,0x937E,
	0x9418,0x969C,0x9798,0x4E0A,0x4E08,0x4E1E,0x4E57,0x5197,0x5270,0x57CE,0x5834,0x58CC,0x5B22,0x5E38,0x60C5,0x64FE,
	0x6761,0x6756,0x6D44,0x72B6,0x7573,0x7A63,0x84B8,0x8B72,0x91B8,0x9320,0x5631,0x57F4,0x98FE,
};
static const WCHAR _sjis_to_ucs_9000_data []={ //9040 90FC
	0x62ED,0x690D,0x6B96,0x71ED,0x7E54,0x8077,0x8272,0x89E6,0x98DF,0x8755,0x8FB1,0x5C3B,0x4F38,0x4FE1,0x4FB5,0x5507,
	0x5A20,0x5BDD,0x5BE9,0x5FC3,0x614E,0x632F,0x65B0,0x664B,0x68EE,0x699B,0x6D78,0x6DF1,0x7533,0x75B9,0x771F,0x795E,
	0x79E6,0x7D33,0x81E3,0x82AF,0x85AA,0x89AA,0x8A3A,0x8EAB,0x8F9B,0x9032,0x91DD,0x9707,0x4EBA,0x4EC1,0x5203,0x5875,
	0x58EC,0x5C0B,0x751A,0x5C3D,0x814E,0x8A0A,0x8FC5,0x9663,0x976D,0x7B25,0x8ACF,0x9808,0x9162,0x56F3,0x53A8,0x0000,
	0x9017,0x5439,0x5782,0x5E25,0x63A8,0x6C34,0x708A,0x7761,0x7C8B,0x7FE0,0x8870,0x9042,0x9154,0x9310,0x9318,0x968F,
	0x745E,0x9AC4,0x5D07,0x5D69,0x6570,0x67A2,0x8DA8,0x96DB,0x636E,0x6749,0x6919,0x83C5,0x9817,0x96C0,0x88FE,0x6F84,
	0x647A,0x5BF8,0x4E16,0x702C,0x755D,0x662F,0x51C4,0x5236,0x52E2,0x59D3,0x5F81,0x6027,0x6210,0x653F,0x6574,0x661F,
	0x6674,0x68F2,0x6816,0x6B63,0x6E05,0x7272,0x751F,0x76DB,0x7CBE,0x8056,0x58F0,0x88FD,0x897F,0x8AA0,0x8A93,0x8ACB,
	0x901D,0x9192,0x9752,0x9759,0x6589,0x7A0E,0x8106,0x96BB,0x5E2D,0x60DC,0x621A,0x65A5,0x6614,0x6790,0x77F3,0x7A4D,
	0x7C4D,0x7E3E,0x810A,0x8CAC,0x8D64,0x8DE1,0x8E5F,0x78A9,0x5207,0x62D9,0x63A5,0x6442,0x6298,0x8A2D,0x7A83,0x7BC0,
	0x8AAC,0x96EA,0x7D76,0x820C,0x8749,0x4ED9,0x5148,0x5343,0x5360,0x5BA3,0x5C02,0x5C16,0x5DDD,0x6226,0x6247,0x64B0,
	0x6813,0x6834,0x6CC9,0x6D45,0x6D17,0x67D3,0x6F5C,0x714E,0x717D,0x65CB,0x7A7F,0x7BAD,0x7DDA,
};
static const WCHAR _sjis_to_ucs_9100_data []={ //9140 91FC
	0x7E4A,0x7FA8,0x817A,0x821B,0x8239,0x85A6,0x8A6E,0x8CCE,0x8DF5,0x9078,0x9077,0x92AD,0x9291,0x9583,0x9BAE,0x524D,
	0x5584,0x6F38,0x7136,0x5168,0x7985,0x7E55,0x81B3,0x7CCE,0x564C,0x5851,0x5CA8,0x63AA,0x66FE,0x66FD,0x695A,0x72D9,
	0x758F,0x758E,0x790E,0x7956,0x79DF,0x7C97,0x7D20,0x7D44,0x8607,0x8A34,0x963B,0x9061,0x9F20,0x50E7,0x5275,0x53CC,
	0x53E2,0x5009,0x55AA,0x58EE,0x594F,0x723D,0x5B8B,0x5C64,0x531D,0x60E3,0x60F3,0x635C,0x6383,0x633F,0x63BB,0x0000,
	0x64CD,0x65E9,0x66F9,0x5DE3,0x69CD,0x69FD,0x6F15,0x71E5,0x4E89,0x75E9,0x76F8,0x7A93,0x7CDF,0x7DCF,0x7D9C,0x8061,
	0x8349,0x8358,0x846C,0x84BC,0x85FB,0x88C5,0x8D70,0x9001,0x906D,0x9397,0x971C,0x9A12,0x50CF,0x5897,0x618E,0x81D3,
	0x8535,0x8D08,0x9020,0x4FC3,0x5074,0x5247,0x5373,0x606F,0x6349,0x675F,0x6E2C,0x8DB3,0x901F,0x4FD7,0x5C5E,0x8CCA,
	0x65CF,0x7D9A,0x5352,0x8896,0x5176,0x63C3,0x5B58,0x5B6B,0x5C0A,0x640D,0x6751,0x905C,0x4ED6,0x591A,0x592A,0x6C70,
	0x8A51,0x553E,0x5815,0x59A5,0x60F0,0x6253,0x67C1,0x8235,0x6955,0x9640,0x99C4,0x9A28,0x4F53,0x5806,0x5BFE,0x8010,
	0x5CB1,0x5E2F,0x5F85,0x6020,0x614B,0x6234,0x66FF,0x6CF0,0x6EDE,0x80CE,0x817F,0x82D4,0x888B,0x8CB8,0x9000,0x902E,
	0x968A,0x9EDB,0x9BDB,0x4EE3,0x53F0,0x5927,0x7B2C,0x918D,0x984C,0x9DF9,0x6EDD,0x7027,0x5353,0x5544,0x5B85,0x6258,
	0x629E,0x62D3,0x6CA2,0x6FEF,0x7422,0x8A17,0x9438,0x6FC1,0x8AFE,0x8338,0x51E7,0x86F8,0x53EA,
};
static const WCHAR _sjis_to_ucs_9200_data []={ //9240 92FC
	0x53E9,0x4F46,0x9054,0x8FB0,0x596A,0x8131,0x5DFD,0x7AEA,0x8FBF,0x68DA,0x8C37,0x72F8,0x9C48,0x6A3D,0x8AB0,0x4E39,
	0x5358,0x5606,0x5766,0x62C5,0x63A2,0x65E6,0x6B4E,0x6DE1,0x6E5B,0x70AD,0x77ED,0x7AEF,0x7BAA,0x7DBB,0x803D,0x80C6,
	0x86CB,0x8A95,0x935B,0x56E3,0x58C7,0x5F3E,0x65AD,0x6696,0x6A80,0x6BB5,0x7537,0x8AC7,0x5024,0x77E5,0x5730,0x5F1B,
	0x6065,0x667A,0x6C60,0x75F4,0x7A1A,0x7F6E,0x81F4,0x8718,0x9045,0x99B3,0x7BC9,0x755C,0x7AF9,0x7B51,0x84C4,0x0000,
	0x9010,0x79E9,0x7A92,0x8336,0x5AE1,0x7740,0x4E2D,0x4EF2,0x5B99,0x5FE0,0x62BD,0x663C,0x67F1,0x6CE8,0x866B,0x8877,
	0x8A3B,0x914E,0x92F3,0x99D0,0x6A17,0x7026,0x732A,0x82E7,0x8457,0x8CAF,0x4E01,0x5146,0x51CB,0x558B,0x5BF5,0x5E16,
	0x5E33,0x5E81,0x5F14,0x5F35,0x5F6B,0x5FB4,0x61F2,0x6311,0x66A2,0x671D,0x6F6E,0x7252,0x753A,0x773A,0x8074,0x8139,
	0x8178,0x8776,0x8ABF,0x8ADC,0x8D85,0x8DF3,0x929A,0x9577,0x9802,0x9CE5,0x52C5,0x6357,0x76F4,0x6715,0x6C88,0x73CD,
	0x8CC3,0x93AE,0x9673,0x6D25,0x589C,0x690E,0x69CC,0x8FFD,0x939A,0x75DB,0x901A,0x585A,0x6802,0x63B4,0x69FB,0x4F43,
	0x6F2C,0x67D8,0x8FBB,0x8526,0x7DB4,0x9354,0x693F,0x6F70,0x576A,0x58F7,0x5B2C,0x7D2C,0x722A,0x540A,0x91E3,0x9DB4,
	0x4EAD,0x4F4E,0x505C,0x5075,0x5243,0x8C9E,0x5448,0x5824,0x5B9A,0x5E1D,0x5E95,0x5EAD,0x5EF7,0x5F1F,0x608C,0x62B5,
	0x633A,0x63D0,0x68AF,0x6C40,0x7887,0x798E,0x7A0B,0x7DE0,0x8247,0x8A02,0x8AE6,0x8E44,0x9013,
};
static const WCHAR _sjis_to_ucs_9300_data []={ //9340 93FC
	0x90B8,0x912D,0x91D8,0x9F0E,0x6CE5,0x6458,0x64E2,0x6575,0x6EF4,0x7684,0x7B1B,0x9069,0x93D1,0x6EBA,0x54F2,0x5FB9,
	0x64A4,0x8F4D,0x8FED,0x9244,0x5178,0x586B,0x5929,0x5C55,0x5E97,0x6DFB,0x7E8F,0x751C,0x8CBC,0x8EE2,0x985B,0x70B9,
	0x4F1D,0x6BBF,0x6FB1,0x7530,0x96FB,0x514E,0x5410,0x5835,0x5857,0x59AC,0x5C60,0x5F92,0x6597,0x675C,0x6E21,0x767B,
	0x83DF,0x8CED,0x9014,0x90FD,0x934D,0x7825,0x783A,0x52AA,0x5EA6,0x571F,0x5974,0x6012,0x5012,0x515A,0x51AC,0x0000,
	0x51CD,0x5200,0x5510,0x5854,0x5858,0x5957,0x5B95,0x5CF6,0x5D8B,0x60BC,0x6295,0x642D,0x6771,0x6843,0x68BC,0x68DF,
	0x76D7,0x6DD8,0x6E6F,0x6D9B,0x706F,0x71C8,0x5F53,0x75D8,0x7977,0x7B49,0x7B54,0x7B52,0x7CD6,0x7D71,0x5230,0x8463,
	0x8569,0x85E4,0x8A0E,0x8B04,0x8C46,0x8E0F,0x9003,0x900F,0x9419,0x9676,0x982D,0x9A30,0x95D8,0x50CD,0x52D5,0x540C,
	0x5802,0x5C0E,0x61A7,0x649E,0x6D1E,0x77B3,0x7AE5,0x80F4,0x8404,0x9053,0x9285,0x5CE0,0x9D07,0x533F,0x5F97,0x5FB3,
	0x6D9C,0x7279,0x7763,0x79BF,0x7BE4,0x6BD2,0x72EC,0x8AAD,0x6803,0x6A61,0x51F8,0x7A81,0x6934,0x5C4A,0x9CF6,0x82EB,
	0x5BC5,0x9149,0x701E,0x5678,0x5C6F,0x60C7,0x6566,0x6C8C,0x8C5A,0x9041,0x9813,0x5451,0x66C7,0x920D,0x5948,0x90A3,
	0x5185,0x4E4D,0x51EA,0x8599,0x8B0E,0x7058,0x637A,0x934B,0x6962,0x99B4,0x7E04,0x7577,0x5357,0x6960,0x8EDF,0x96E3,
	0x6C5D,0x4E8C,0x5C3C,0x5F10,0x8FE9,0x5302,0x8CD1,0x8089,0x8679,0x5EFF,0x65E5,0x4E73,0x5165,
};
static const WCHAR _sjis_to_ucs_9400_data []={ //9440 94FC
	0x5982,0x5C3F,0x97EE,0x4EFB,0x598A,0x5FCD,0x8A8D,0x6FE1,0x79B0,0x7962,0x5BE7,0x8471,0x732B,0x71B1,0x5E74,0x5FF5,
	0x637B,0x649A,0x71C3,0x7C98,0x4E43,0x5EFC,0x4E4B,0x57DC,0x56A2,0x60A9,0x6FC3,0x7D0D,0x80FD,0x8133,0x81BF,0x8FB2,
	0x8997,0x86A4,0x5DF4,0x628A,0x64AD,0x8987,0x6777,0x6CE2,0x6D3E,0x7436,0x7834,0x5A46,0x7F75,0x82AD,0x99AC,0x4FF3,
	0x5EC3,0x62DD,0x6392,0x6557,0x676F,0x76C3,0x724C,0x80CC,0x80BA,0x8F29,0x914D,0x500D,0x57F9,0x5A92,0x6885,0x0000,
	0x6973,0x7164,0x72FD,0x8CB7,0x58F2,0x8CE0,0x966A,0x9019,0x877F,0x79E4,0x77E7,0x8429,0x4F2F,0x5265,0x535A,0x62CD,
	0x67CF,0x6CCA,0x767D,0x7B94,0x7C95,0x8236,0x8584,0x8FEB,0x66DD,0x6F20,0x7206,0x7E1B,0x83AB,0x99C1,0x9EA6,0x51FD,
	0x7BB1,0x7872,0x7BB8,0x8087,0x7B48,0x6AE8,0x5E61,0x808C,0x7551,0x7560,0x516B,0x9262,0x6E8C,0x767A,0x9197,0x9AEA,
	0x4F10,0x7F70,0x629C,0x7B4F,0x95A5,0x9CE9,0x567A,0x5859,0x86E4,0x96BC,0x4F34,0x5224,0x534A,0x53CD,0x53DB,0x5E06,
	0x642C,0x6591,0x677F,0x6C3E,0x6C4E,0x7248,0x72AF,0x73ED,0x7554,0x7E41,0x822C,0x85E9,0x8CA9,0x7BC4,0x91C6,0x7169,
	0x9812,0x98EF,0x633D,0x6669,0x756A,0x76E4,0x78D0,0x8543,0x86EE,0x532A,0x5351,0x5426,0x5983,0x5E87,0x5F7C,0x60B2,
	0x6249,0x6279,0x62AB,0x6590,0x6BD4,0x6CCC,0x75B2,0x76AE,0x7891,0x79D8,0x7DCB,0x7F77,0x80A5,0x88AB,0x8AB9,0x8CBB,
	0x907F,0x975E,0x98DB,0x6A0B,0x7C38,0x5099,0x5C3E,0x5FAE,0x6787,0x6BD8,0x7435,0x7709,0x7F8E,
};
static const WCHAR _sjis_to_ucs_9500_data []={ //9540 95FC
	0x9F3B,0x67CA,0x7A17,0x5339,0x758B,0x9AED,0x5F66,0x819D,0x83F1,0x8098,0x5F3C,0x5FC5,0x7562,0x7B46,0x903C,0x6867,
	0x59EB,0x5A9B,0x7D10,0x767E,0x8B2C,0x4FF5,0x5F6A,0x6A19,0x6C37,0x6F02,0x74E2,0x7968,0x8868,0x8A55,0x8C79,0x5EDF,
	0x63CF,0x75C5,0x79D2,0x82D7,0x9328,0x92F2,0x849C,0x86ED,0x9C2D,0x54C1,0x5F6C,0x658C,0x6D5C,0x7015,0x8CA7,0x8CD3,
	0x983B,0x654F,0x74F6,0x4E0D,0x4ED8,0x57E0,0x592B,0x5A66,0x5BCC,0x51A8,0x5E03,0x5E9C,0x6016,0x6276,0x6577,0x0000,
	0x65A7,0x666E,0x6D6E,0x7236,0x7B26,0x8150,0x819A,0x8299,0x8B5C,0x8CA0,0x8CE6,0x8D74,0x961C,0x9644,0x4FAE,0x64AB,
	0x6B66,0x821E,0x8461,0x856A,0x90E8,0x5C01,0x6953,0x98A8,0x847A,0x8557,0x4F0F,0x526F,0x5FA9,0x5E45,0x670D,0x798F,
	0x8179,0x8907,0x8986,0x6DF5,0x5F17,0x6255,0x6CB8,0x4ECF,0x7269,0x9B92,0x5206,0x543B,0x5674,0x58B3,0x61A4,0x626E,
	0x711A,0x596E,0x7C89,0x7CDE,0x7D1B,0x96F0,0x6587,0x805E,0x4E19,0x4F75,0x5175,0x5840,0x5E63,0x5E73,0x5F0A,0x67C4,
	0x4E26,0x853D,0x9589,0x965B,0x7C73,0x9801,0x50FB,0x58C1,0x7656,0x78A7,0x5225,0x77A5,0x8511,0x7B86,0x504F,0x5909,
	0x7247,0x7BC7,0x7DE8,0x8FBA,0x8FD4,0x904D,0x4FBF,0x52C9,0x5A29,0x5F01,0x97AD,0x4FDD,0x8217,0x92EA,0x5703,0x6355,
	0x6B69,0x752B,0x88DC,0x8F14,0x7A42,0x52DF,0x5893,0x6155,0x620A,0x66AE,0x6BCD,0x7C3F,0x83E9,0x5023,0x4FF8,0x5305,
	0x5446,0x5831,0x5949,0x5B9D,0x5CF0,0x5CEF,0x5D29,0x5E96,0x62B1,0x6367,0x653E,0x65B9,0x670B,
};
static const WCHAR _sjis_to_ucs_9600_data []={ //9640 96FC
	0x6CD5,0x6CE1,0x70F9,0x7832,0x7E2B,0x80DE,0x82B3,0x840C,0x84EC,0x8702,0x8912,0x8A2A,0x8C4A,0x90A6,0x92D2,0x98FD,
	0x9CF3,0x9D6C,0x4E4F,0x4EA1,0x508D,0x5256,0x574A,0x59A8,0x5E3D,0x5FD8,0x5FD9,0x623F,0x66B4,0x671B,0x67D0,0x68D2,
	0x5192,0x7D21,0x80AA,0x81A8,0x8B00,0x8C8C,0x8CBF,0x927E,0x9632,0x5420,0x982C,0x5317,0x50D5,0x535C,0x58A8,0x64B2,
	0x6734,0x7267,0x7766,0x7A46,0x91E6,0x52C3,0x6CA1,0x6B86,0x5800,0x5E4C,0x5954,0x672C,0x7FFB,0x51E1,0x76C6,0x0000,
	0x6469,0x78E8,0x9B54,0x9EBB,0x57CB,0x59B9,0x6627,0x679A,0x6BCE,0x54E9,0x69D9,0x5E55,0x819C,0x6795,0x9BAA,0x67FE,
	0x9C52,0x685D,0x4EA6,0x4FE3,0x53C8,0x62B9,0x672B,0x6CAB,0x8FC4,0x4FAD,0x7E6D,0x9EBF,0x4E07,0x6162,0x6E80,0x6F2B,
	0x8513,0x5473,0x672A,0x9B45,0x5DF3,0x7B95,0x5CAC,0x5BC6,0x871C,0x6E4A,0x84D1,0x7A14,0x8108,0x5999,0x7C8D,0x6C11,
	0x7720,0x52D9,0x5922,0x7121,0x725F,0x77DB,0x9727,0x9D61,0x690B,0x5A7F,0x5A18,0x51A5,0x540D,0x547D,0x660E,0x76DF,
	0x8FF7,0x9298,0x9CF4,0x59EA,0x725D,0x6EC5,0x514D,0x68C9,0x7DBF,0x7DEC,0x9762,0x9EBA,0x6478,0x6A21,0x8302,0x5984,
	0x5B5F,0x6BDB,0x731B,0x76F2,0x7DB2,0x8017,0x8499,0x5132,0x6728,0x9ED9,0x76EE,0x6762,0x52FF,0x9905,0x5C24,0x623B,
	0x7C7E,0x8CB0,0x554F,0x60B6,0x7D0B,0x9580,0x5301,0x4E5F,0x51B6,0x591C,0x723A,0x8036,0x91CE,0x5F25,0x77E2,0x5384,
	0x5F79,0x7D04,0x85AC,0x8A33,0x8E8D,0x9756,0x67F3,0x85AE,0x9453,0x6109,0x6108,0x6CB9,0x7652,
};
static const WCHAR _sjis_to_ucs_9700_data []={ //9740 97FC
	0x8AED,0x8F38,0x552F,0x4F51,0x512A,0x52C7,0x53CB,0x5BA5,0x5E7D,0x60A0,0x6182,0x63D6,0x6709,0x67DA,0x6E67,0x6D8C,
	0x7336,0x7337,0x7531,0x7950,0x88D5,0x8A98,0x904A,0x9091,0x90F5,0x96C4,0x878D,0x5915,0x4E88,0x4F59,0x4E0E,0x8A89,
	0x8F3F,0x9810,0x50AD,0x5E7C,0x5996,0x5BB9,0x5EB8,0x63DA,0x63FA,0x64C1,0x66DC,0x694A,0x69D8,0x6D0B,0x6EB6,0x7194,
	0x7528,0x7AAF,0x7F8A,0x8000,0x8449,0x84C9,0x8981,0x8B21,0x8E0A,0x9065,0x967D,0x990A,0x617E,0x6291,0x6B32,0x0000,
	0x6C83,0x6D74,0x7FCC,0x7FFC,0x6DC0,0x7F85,0x87BA,0x88F8,0x6765,0x83B1,0x983C,0x96F7,0x6D1B,0x7D61,0x843D,0x916A,
	0x4E71,0x5375,0x5D50,0x6B04,0x6FEB,0x85CD,0x862D,0x89A7,0x5229,0x540F,0x5C65,0x674E,0x68A8,0x7406,0x7483,0x75E2,
	0x88CF,0x88E1,0x91CC,0x96E2,0x9678,0x5F8B,0x7387,0x7ACB,0x844E,0x63A0,0x7565,0x5289,0x6D41,0x6E9C,0x7409,0x7559,
	0x786B,0x7C92,0x9686,0x7ADC,0x9F8D,0x4FB6,0x616E,0x65C5,0x865C,0x4E86,0x4EAE,0x50DA,0x4E21,0x51CC,0x5BEE,0x6599,
	0x6881,0x6DBC,0x731F,0x7642,0x77AD,0x7A1C,0x7CE7,0x826F,0x8AD2,0x907C,0x91CF,0x9675,0x9818,0x529B,0x7DD1,0x502B,
	0x5398,0x6797,0x6DCB,0x71D0,0x7433,0x81E8,0x8F2A,0x96A3,0x9C57,0x9E9F,0x7460,0x5841,0x6D99,0x7D2F,0x985E,0x4EE4,
	0x4F36,0x4F8B,0x51B7,0x52B1,0x5DBA,0x601C,0x73B2,0x793C,0x82D3,0x9234,0x96B7,0x96F6,0x970A,0x9E97,0x9F62,0x66A6,
	0x6B74,0x5217,0x52A3,0x70C8,0x88C2,0x5EC9,0x604B,0x6190,0x6F23,0x7149,0x7C3E,0x7DF4,0x806F,
};
static const WCHAR _sjis_to_ucs_9800_data []={ //9840 98FC
	0x84EE,0x9023,0x932C,0x5442,0x9B6F,0x6AD3,0x7089,0x8CC2,0x8DEF,0x9732,0x52B4,0x5A41,0x5ECA,0x5F04,0x6717,0x697C,
	0x6994,0x6D6A,0x6F0F,0x7262,0x72FC,0x7BED,0x8001,0x807E,0x874B,0x90CE,0x516D,0x9E93,0x7984,0x808B,0x9332,0x8AD6,
	0x502D,0x548C,0x8A71,0x6B6A,0x8CC4,0x8107,0x60D1,0x67A0,0x9DF2,0x4E99,0x4E98,0x9C10,0x8A6B,0x85C1,0x8568,0x6900,
	0x6E7E,0x7897,0x8155,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x5F0C,
	0x4E10,0x4E15,0x4E2A,0x4E31,0x4E36,0x4E3C,0x4E3F,0x4E42,0x4E56,0x4E58,0x4E82,0x4E85,0x8C6B,0x4E8A,0x8212,0x5F0D,
	0x4E8E,0x4E9E,0x4E9F,0x4EA0,0x4EA2,0x4EB0,0x4EB3,0x4EB6,0x4ECE,0x4ECD,0x4EC4,0x4EC6,0x4EC2,0x4ED7,0x4EDE,0x4EED,
	0x4EDF,0x4EF7,0x4F09,0x4F5A,0x4F30,0x4F5B,0x4F5D,0x4F57,0x4F47,0x4F76,0x4F88,0x4F8F,0x4F98,0x4F7B,0x4F69,0x4F70,
	0x4F91,0x4F6F,0x4F86,0x4F96,0x5118,0x4FD4,0x4FDF,0x4FCE,0x4FD8,0x4FDB,0x4FD1,0x4FDA,0x4FD0,0x4FE4,0x4FE5,0x501A,
	0x5028,0x5014,0x502A,0x5025,0x5005,0x4F1C,0x4FF6,0x5021,0x5029,0x502C,0x4FFE,0x4FEF,0x5011,0x5006,0x5043,0x5047,
	0x6703,0x5055,0x5050,0x5048,0x505A,0x5056,0x506C,0x5078,0x5080,0x509A,0x5085,0x50B4,0x50B2,
};
static const WCHAR _sjis_to_ucs_9900_data []={ //9940 99FC
	0x50C9,0x50CA,0x50B3,0x50C2,0x50D6,0x50DE,0x50E5,0x50ED,0x50E3,0x50EE,0x50F9,0x50F5,0x5109,0x5101,0x5102,0x5116,
	0x5115,0x5114,0x511A,0x5121,0x513A,0x5137,0x513C,0x513B,0x513F,0x5140,0x5152,0x514C,0x5154,0x5162,0x7AF8,0x5169,
	0x516A,0x516E,0x5180,0x5182,0x56D8,0x518C,0x5189,0x518F,0x5191,0x5193,0x5195,0x5196,0x51A4,0x51A6,0x51A2,0x51A9,
	0x51AA,0x51AB,0x51B3,0x51B1,0x51B2,0x51B0,0x51B5,0x51BD,0x51C5,0x51C9,0x51DB,0x51E0,0x8655,0x51E9,0x51ED,0x0000,
	0x51F0,0x51F5,0x51FE,0x5204,0x520B,0x5214,0x520E,0x5227,0x522A,0x522E,0x5233,0x5239,0x524F,0x5244,0x524B,0x524C,
	0x525E,0x5254,0x526A,0x5274,0x5269,0x5273,0x527F,0x527D,0x528D,0x5294,0x5292,0x5271,0x5288,0x5291,0x8FA8,0x8FA7,
	0x52AC,0x52AD,0x52BC,0x52B5,0x52C1,0x52CD,0x52D7,0x52DE,0x52E3,0x52E6,0x98ED,0x52E0,0x52F3,0x52F5,0x52F8,0x52F9,
	0x5306,0x5308,0x7538,0x530D,0x5310,0x530F,0x5315,0x531A,0x5323,0x532F,0x5331,0x5333,0x5338,0x5340,0x5346,0x5345,
	0x4E17,0x5349,0x534D,0x51D6,0x535E,0x5369,0x536E,0x5918,0x537B,0x5377,0x5382,0x5396,0x53A0,0x53A6,0x53A5,0x53AE,
	0x53B0,0x53B6,0x53C3,0x7C12,0x96D9,0x53DF,0x66FC,0x71EE,0x53EE,0x53E8,0x53ED,0x53FA,0x5401,0x543D,0x5440,0x542C,
	0x542D,0x543C,0x542E,0x5436,0x5429,0x541D,0x544E,0x548F,0x5475,0x548E,0x545F,0x5471,0x5477,0x5470,0x5492,0x547B,
	0x5480,0x5476,0x5484,0x5490,0x5486,0x54C7,0x54A2,0x54B8,0x54A5,0x54AC,0x54C4,0x54C8,0x54A8,
};
static const WCHAR _sjis_to_ucs_9A00_data []={ //9A40 9AFC
	0x54AB,0x54C2,0x54A4,0x54BE,0x54BC,0x54D8,0x54E5,0x54E6,0x550F,0x5514,0x54FD,0x54EE,0x54ED,0x54FA,0x54E2,0x5539,
	0x5540,0x5563,0x554C,0x552E,0x555C,0x5545,0x5556,0x5557,0x5538,0x5533,0x555D,0x5599,0x5580,0x54AF,0x558A,0x559F,
	0x557B,0x557E,0x5598,0x559E,0x55AE,0x557C,0x5583,0x55A9,0x5587,0x55A8,0x55DA,0x55C5,0x55DF,0x55C4,0x55DC,0x55E4,
	0x55D4,0x5614,0x55F7,0x5616,0x55FE,0x55FD,0x561B,0x55F9,0x564E,0x5650,0x71DF,0x5634,0x5636,0x5632,0x5638,0x0000,
	0x566B,0x5664,0x562F,0x566C,0x566A,0x5686,0x5680,0x568A,0x56A0,0x5694,0x568F,0x56A5,0x56AE,0x56B6,0x56B4,0x56C2,
	0x56BC,0x56C1,0x56C3,0x56C0,0x56C8,0x56CE,0x56D1,0x56D3,0x56D7,0x56EE,0x56F9,0x5700,0x56FF,0x5704,0x5709,0x5708,
	0x570B,0x570D,0x5713,0x5718,0x5716,0x55C7,0x571C,0x5726,0x5737,0x5738,0x574E,0x573B,0x5740,0x574F,0x5769,0x57C0,
	0x5788,0x5761,0x577F,0x5789,0x5793,0x57A0,0x57B3,0x57A4,0x57AA,0x57B0,0x57C3,0x57C6,0x57D4,0x57D2,0x57D3,0x580A,
	0x57D6,0x57E3,0x580B,0x5819,0x581D,0x5872,0x5821,0x5862,0x584B,0x5870,0x6BC0,0x5852,0x583D,0x5879,0x5885,0x58B9,
	0x589F,0x58AB,0x58BA,0x58DE,0x58BB,0x58B8,0x58AE,0x58C5,0x58D3,0x58D1,0x58D7,0x58D9,0x58D8,0x58E5,0x58DC,0x58E4,
	0x58DF,0x58EF,0x58FA,0x58F9,0x58FB,0x58FC,0x58FD,0x5902,0x590A,0x5910,0x591B,0x68A6,0x5925,0x592C,0x592D,0x5932,
	0x5938,0x593E,0x7AD2,0x5955,0x5950,0x594E,0x595A,0x5958,0x5962,0x5960,0x5967,0x596C,0x5969,
};
static const WCHAR _sjis_to_ucs_9B00_data []={ //9B40 9BFC
	0x5978,0x5981,0x599D,0x4F5E,0x4FAB,0x59A3,0x59B2,0x59C6,0x59E8,0x59DC,0x598D,0x59D9,0x59DA,0x5A25,0x5A1F,0x5A11,
	0x5A1C,0x5A09,0x5A1A,0x5A40,0x5A6C,0x5A49,0x5A35,0x5A36,0x5A62,0x5A6A,0x5A9A,0x5ABC,0x5ABE,0x5ACB,0x5AC2,0x5ABD,
	0x5AE3,0x5AD7,0x5AE6,0x5AE9,0x5AD6,0x5AFA,0x5AFB,0x5B0C,0x5B0B,0x5B16,0x5B32,0x5AD0,0x5B2A,0x5B36,0x5B3E,0x5B43,
	0x5B45,0x5B40,0x5B51,0x5B55,0x5B5A,0x5B5B,0x5B65,0x5B69,0x5B70,0x5B73,0x5B75,0x5B78,0x6588,0x5B7A,0x5B80,0x0000,
	0x5B83,0x5BA6,0x5BB8,0x5BC3,0x5BC7,0x5BC9,0x5BD4,0x5BD0,0x5BE4,0x5BE6,0x5BE2,0x5BDE,0x5BE5,0x5BEB,0x5BF0,0x5BF6,
	0x5BF3,0x5C05,0x5C07,0x5C08,0x5C0D,0x5C13,0x5C20,0x5C22,0x5C28,0x5C38,0x5C39,0x5C41,0x5C46,0x5C4E,0x5C53,0x5C50,
	0x5C4F,0x5B71,0x5C6C,0x5C6E,0x4E62,0x5C76,0x5C79,0x5C8C,0x5C91,0x5C94,0x599B,0x5CAB,0x5CBB,0x5CB6,0x5CBC,0x5CB7,
	0x5CC5,0x5CBE,0x5CC7,0x5CD9,0x5CE9,0x5CFD,0x5CFA,0x5CED,0x5D8C,0x5CEA,0x5D0B,0x5D15,0x5D17,0x5D5C,0x5D1F,0x5D1B,
	0x5D11,0x5D14,0x5D22,0x5D1A,0x5D19,0x5D18,0x5D4C,0x5D52,0x5D4E,0x5D4B,0x5D6C,0x5D73,0x5D76,0x5D87,0x5D84,0x5D82,
	0x5DA2,0x5D9D,0x5DAC,0x5DAE,0x5DBD,0x5D90,0x5DB7,0x5DBC,0x5DC9,0x5DCD,0x5DD3,0x5DD2,0x5DD6,0x5DDB,0x5DEB,0x5DF2,
	0x5DF5,0x5E0B,0x5E1A,0x5E19,0x5E11,0x5E1B,0x5E36,0x5E37,0x5E44,0x5E43,0x5E40,0x5E4E,0x5E57,0x5E54,0x5E5F,0x5E62,
	0x5E64,0x5E47,0x5E75,0x5E76,0x5E7A,0x9EBC,0x5E7F,0x5EA0,0x5EC1,0x5EC2,0x5EC8,0x5ED0,0x5ECF,
};
static const WCHAR _sjis_to_ucs_9C00_data []={ //9C40 9CFC
	0x5ED6,0x5EE3,0x5EDD,0x5EDA,0x5EDB,0x5EE2,0x5EE1,0x5EE8,0x5EE9,0x5EEC,0x5EF1,0x5EF3,0x5EF0,0x5EF4,0x5EF8,0x5EFE,
	0x5F03,0x5F09,0x5F5D,0x5F5C,0x5F0B,0x5F11,0x5F16,0x5F29,0x5F2D,0x5F38,0x5F41,0x5F48,0x5F4C,0x5F4E,0x5F2F,0x5F51,
	0x5F56,0x5F57,0x5F59,0x5F61,0x5F6D,0x5F73,0x5F77,0x5F83,0x5F82,0x5F7F,0x5F8A,0x5F88,0x5F91,0x5F87,0x5F9E,0x5F99,
	0x5F98,0x5FA0,0x5FA8,0x5FAD,0x5FBC,0x5FD6,0x5FFB,0x5FE4,0x5FF8,0x5FF1,0x5FDD,0x60B3,0x5FFF,0x6021,0x6060,0x0000,
	0x6019,0x6010,0x6029,0x600E,0x6031,0x601B,0x6015,0x602B,0x6026,0x600F,0x603A,0x605A,0x6041,0x606A,0x6077,0x605F,
	0x604A,0x6046,0x604D,0x6063,0x6043,0x6064,0x6042,0x606C,0x606B,0x6059,0x6081,0x608D,0x60E7,0x6083,0x609A,0x6084,
	0x609B,0x6096,0x6097,0x6092,0x60A7,0x608B,0x60E1,0x60B8,0x60E0,0x60D3,0x60B4,0x5FF0,0x60BD,0x60C6,0x60B5,0x60D8,
	0x614D,0x6115,0x6106,0x60F6,0x60F7,0x6100,0x60F4,0x60FA,0x6103,0x6121,0x60FB,0x60F1,0x610D,0x610E,0x6147,0x613E,
	0x6128,0x6127,0x614A,0x613F,0x613C,0x612C,0x6134,0x613D,0x6142,0x6144,0x6173,0x6177,0x6158,0x6159,0x615A,0x616B,
	0x6174,0x616F,0x6165,0x6171,0x615F,0x615D,0x6153,0x6175,0x6199,0x6196,0x6187,0x61AC,0x6194,0x619A,0x618A,0x6191,
	0x61AB,0x61AE,0x61CC,0x61CA,0x61C9,0x61F7,0x61C8,0x61C3,0x61C6,0x61BA,0x61CB,0x7F79,0x61CD,0x61E6,0x61E3,0x61F6,
	0x61FA,0x61F4,0x61FF,0x61FD,0x61FC,0x61FE,0x6200,0x6208,0x6209,0x620D,0x620C,0x6214,0x621B,
};
static const WCHAR _sjis_to_ucs_9D00_data []={ //9D40 9DFC
	0x621E,0x6221,0x622A,0x622E,0x6230,0x6232,0x6233,0x6241,0x624E,0x625E,0x6263,0x625B,0x6260,0x6268,0x627C,0x6282,
	0x6289,0x627E,0x6292,0x6293,0x6296,0x62D4,0x6283,0x6294,0x62D7,0x62D1,0x62BB,0x62CF,0x62FF,0x62C6,0x64D4,0x62C8,
	0x62DC,0x62CC,0x62CA,0x62C2,0x62C7,0x629B,0x62C9,0x630C,0x62EE,0x62F1,0x6327,0x6302,0x6308,0x62EF,0x62F5,0x6350,
	0x633E,0x634D,0x641C,0x634F,0x6396,0x638E,0x6380,0x63AB,0x6376,0x63A3,0x638F,0x6389,0x639F,0x63B5,0x636B,0x0000,
	0x6369,0x63BE,0x63E9,0x63C0,0x63C6,0x63E3,0x63C9,0x63D2,0x63F6,0x63C4,0x6416,0x6434,0x6406,0x6413,0x6426,0x6436,
	0x651D,0x6417,0x6428,0x640F,0x6467,0x646F,0x6476,0x644E,0x652A,0x6495,0x6493,0x64A5,0x64A9,0x6488,0x64BC,0x64DA,
	0x64D2,0x64C5,0x64C7,0x64BB,0x64D8,0x64C2,0x64F1,0x64E7,0x8209,0x64E0,0x64E1,0x62AC,0x64E3,0x64EF,0x652C,0x64F6,
	0x64F4,0x64F2,0x64FA,0x6500,0x64FD,0x6518,0x651C,0x6505,0x6524,0x6523,0x652B,0x6534,0x6535,0x6537,0x6536,0x6538,
	0x754B,0x6548,0x6556,0x6555,0x654D,0x6558,0x655E,0x655D,0x6572,0x6578,0x6582,0x6583,0x8B8A,0x659B,0x659F,0x65AB,
	0x65B7,0x65C3,0x65C6,0x65C1,0x65C4,0x65CC,0x65D2,0x65DB,0x65D9,0x65E0,0x65E1,0x65F1,0x6772,0x660A,0x6603,0x65FB,
	0x6773,0x6635,0x6636,0x6634,0x661C,0x664F,0x6644,0x6649,0x6641,0x665E,0x665D,0x6664,0x6667,0x6668,0x665F,0x6662,
	0x6670,0x6683,0x6688,0x668E,0x6689,0x6684,0x6698,0x669D,0x66C1,0x66B9,0x66C9,0x66BE,0x66BC,
};
static const WCHAR _sjis_to_ucs_9E00_data []={ //9E40 9EFC
	0x66C4,0x66B8,0x66D6,0x66DA,0x66E0,0x663F,0x66E6,0x66E9,0x66F0,0x66F5,0x66F7,0x670F,0x6716,0x671E,0x6726,0x6727,
	0x9738,0x672E,0x673F,0x6736,0x6741,0x6738,0x6737,0x6746,0x675E,0x6760,0x6759,0x6763,0x6764,0x6789,0x6770,0x67A9,
	0x677C,0x676A,0x678C,0x678B,0x67A6,0x67A1,0x6785,0x67B7,0x67EF,0x67B4,0x67EC,0x67B3,0x67E9,0x67B8,0x67E4,0x67DE,
	0x67DD,0x67E2,0x67EE,0x67B9,0x67CE,0x67C6,0x67E7,0x6A9C,0x681E,0x6846,0x6829,0x6840,0x684D,0x6832,0x684E,0x0000,
	0x68B3,0x682B,0x6859,0x6863,0x6877,0x687F,0x689F,0x688F,0x68AD,0x6894,0x689D,0x689B,0x6883,0x6AAE,0x68B9,0x6874,
	0x68B5,0x68A0,0x68BA,0x690F,0x688D,0x687E,0x6901,0x68CA,0x6908,0x68D8,0x6922,0x6926,0x68E1,0x690C,0x68CD,0x68D4,
	0x68E7,0x68D5,0x6936,0x6912,0x6904,0x68D7,0x68E3,0x6925,0x68F9,0x68E0,0x68EF,0x6928,0x692A,0x691A,0x6923,0x6921,
	0x68C6,0x6979,0x6977,0x695C,0x6978,0x696B,0x6954,0x697E,0x696E,0x6939,0x6974,0x693D,0x6959,0x6930,0x6961,0x695E,
	0x695D,0x6981,0x696A,0x69B2,0x69AE,0x69D0,0x69BF,0x69C1,0x69D3,0x69BE,0x69CE,0x5BE8,0x69CA,0x69DD,0x69BB,0x69C3,
	0x69A7,0x6A2E,0x6991,0x69A0,0x699C,0x6995,0x69B4,0x69DE,0x69E8,0x6A02,0x6A1B,0x69FF,0x6B0A,0x69F9,0x69F2,0x69E7,
	0x6A05,0x69B1,0x6A1E,0x69ED,0x6A14,0x69EB,0x6A0A,0x6A12,0x6AC1,0x6A23,0x6A13,0x6A44,0x6A0C,0x6A72,0x6A36,0x6A78,
	0x6A47,0x6A62,0x6A59,0x6A66,0x6A48,0x6A38,0x6A22,0x6A90,0x6A8D,0x6AA0,0x6A84,0x6AA2,0x6AA3,
};
static const WCHAR _sjis_to_ucs_9F00_data []={ //9F40 9FFC
	0x6A97,0x8617,0x6ABB,0x6AC3,0x6AC2,0x6AB8,0x6AB3,0x6AAC,0x6ADE,0x6AD1,0x6ADF,0x6AAA,0x6ADA,0x6AEA,0x6AFB,0x6B05,
	0x8616,0x6AFA,0x6B12,0x6B16,0x9B31,0x6B1F,0x6B38,0x6B37,0x76DC,0x6B39,0x98EE,0x6B47,0x6B43,0x6B49,0x6B50,0x6B59,
	0x6B54,0x6B5B,0x6B5F,0x6B61,0x6B78,0x6B79,0x6B7F,0x6B80,0x6B84,0x6B83,0x6B8D,0x6B98,0x6B95,0x6B9E,0x6BA4,0x6BAA,
	0x6BAB,0x6BAF,0x6BB2,0x6BB1,0x6BB3,0x6BB7,0x6BBC,0x6BC6,0x6BCB,0x6BD3,0x6BDF,0x6BEC,0x6BEB,0x6BF3,0x6BEF,0x0000,
	0x9EBE,0x6C08,0x6C13,0x6C14,0x6C1B,0x6C24,0x6C23,0x6C5E,0x6C55,0x6C62,0x6C6A,0x6C82,0x6C8D,0x6C9A,0x6C81,0x6C9B,
	0x6C7E,0x6C68,0x6C73,0x6C92,0x6C90,0x6CC4,0x6CF1,0x6CD3,0x6CBD,0x6CD7,0x6CC5,0x6CDD,0x6CAE,0x6CB1,0x6CBE,0x6CBA,
	0x6CDB,0x6CEF,0x6CD9,0x6CEA,0x6D1F,0x884D,0x6D36,0x6D2B,0x6D3D,0x6D38,0x6D19,0x6D35,0x6D33,0x6D12,0x6D0C,0x6D63,
	0x6D93,0x6D64,0x6D5A,0x6D79,0x6D59,0x6D8E,0x6D95,0x6FE4,0x6D85,0x6DF9,0x6E15,0x6E0A,0x6DB5,0x6DC7,0x6DE6,0x6DB8,
	0x6DC6,0x6DEC,0x6DDE,0x6DCC,0x6DE8,0x6DD2,0x6DC5,0x6DFA,0x6DD9,0x6DE4,0x6DD5,0x6DEA,0x6DEE,0x6E2D,0x6E6E,0x6E2E,
	0x6E19,0x6E72,0x6E5F,0x6E3E,0x6E23,0x6E6B,0x6E2B,0x6E76,0x6E4D,0x6E1F,0x6E43,0x6E3A,0x6E4E,0x6E24,0x6EFF,0x6E1D,
	0x6E38,0x6E82,0x6EAA,0x6E98,0x6EC9,0x6EB7,0x6ED3,0x6EBD,0x6EAF,0x6EC4,0x6EB2,0x6ED4,0x6ED5,0x6E8F,0x6EA5,0x6EC2,
	0x6E9F,0x6F41,0x6F11,0x704C,0x6EEC,0x6EF8,0x6EFE,0x6F3F,0x6EF2,0x6F31,0x6EEF,0x6F32,0x6ECC,
};
static const WCHAR _sjis_to_ucs_E000_data []={ //E040 E0FC
	0x6F3E,0x6F13,0x6EF7,0x6F86,0x6F7A,0x6F78,0x6F81,0x6F80,0x6F6F,0x6F5B,0x6FF3,0x6F6D,0x6F82,0x6F7C,0x6F58,0x6F8E,
	0x6F91,0x6FC2,0x6F66,0x6FB3,0x6FA3,0x6FA1,0x6FA4,0x6FB9,0x6FC6,0x6FAA,0x6FDF,0x6FD5,0x6FEC,0x6FD4,0x6FD8,0x6FF1,
	0x6FEE,0x6FDB,0x7009,0x700B,0x6FFA,0x7011,0x7001,0x700F,0x6FFE,0x701B,0x701A,0x6F74,0x701D,0x7018,0x701F,0x7030,
	0x703E,0x7032,0x7051,0x7063,0x7099,0x7092,0x70AF,0x70F1,0x70AC,0x70B8,0x70B3,0x70AE,0x70DF,0x70CB,0x70DD,0x0000,
	0x70D9,0x7109,0x70FD,0x711C,0x7119,0x7165,0x7155,0x7188,0x7166,0x7162,0x714C,0x7156,0x716C,0x718F,0x71FB,0x7184,
	0x7195,0x71A8,0x71AC,0x71D7,0x71B9,0x71BE,0x71D2,0x71C9,0x71D4,0x71CE,0x71E0,0x71EC,0x71E7,0x71F5,0x71FC,0x71F9,
	0x71FF,0x720D,0x7210,0x721B,0x7228,0x722D,0x722C,0x7230,0x7232,0x723B,0x723C,0x723F,0x7240,0x7246,0x724B,0x7258,
	0x7274,0x727E,0x7282,0x7281,0x7287,0x7292,0x7296,0x72A2,0x72A7,0x72B9,0x72B2,0x72C3,0x72C6,0x72C4,0x72CE,0x72D2,
	0x72E2,0x72E0,0x72E1,0x72F9,0x72F7,0x500F,0x7317,0x730A,0x731C,0x7316,0x731D,0x7334,0x732F,0x7329,0x7325,0x733E,
	0x734E,0x734F,0x9ED8,0x7357,0x736A,0x7368,0x7370,0x7378,0x7375,0x737B,0x737A,0x73C8,0x73B3,0x73CE,0x73BB,0x73C0,
	0x73E5,0x73EE,0x73DE,0x74A2,0x7405,0x746F,0x7425,0x73F8,0x7432,0x743A,0x7455,0x743F,0x745F,0x7459,0x7441,0x745C,
	0x7469,0x7470,0x7463,0x746A,0x7476,0x747E,0x748B,0x749E,0x74A7,0x74CA,0x74CF,0x74D4,0x73F1,
};
static const WCHAR _sjis_to_ucs_E100_data []={ //E140 E1FC
	0x74E0,0x74E3,0x74E7,0x74E9,0x74EE,0x74F2,0x74F0,0x74F1,0x74F8,0x74F7,0x7504,0x7503,0x7505,0x750C,0x750E,0x750D,
	0x7515,0x7513,0x751E,0x7526,0x752C,0x753C,0x7544,0x754D,0x754A,0x7549,0x755B,0x7546,0x755A,0x7569,0x7564,0x7567,
	0x756B,0x756D,0x7578,0x7576,0x7586,0x7587,0x7574,0x758A,0x7589,0x7582,0x7594,0x759A,0x759D,0x75A5,0x75A3,0x75C2,
	0x75B3,0x75C3,0x75B5,0x75BD,0x75B8,0x75BC,0x75B1,0x75CD,0x75CA,0x75D2,0x75D9,0x75E3,0x75DE,0x75FE,0x75FF,0x0000,
	0x75FC,0x7601,0x75F0,0x75FA,0x75F2,0x75F3,0x760B,0x760D,0x7609,0x761F,0x7627,0x7620,0x7621,0x7622,0x7624,0x7634,
	0x7630,0x763B,0x7647,0x7648,0x7646,0x765C,0x7658,0x7661,0x7662,0x7668,0x7669,0x766A,0x7667,0x766C,0x7670,0x7672,
	0x7676,0x7678,0x767C,0x7680,0x7683,0x7688,0x768B,0x768E,0x7696,0x7693,0x7699,0x769A,0x76B0,0x76B4,0x76B8,0x76B9,
	0x76BA,0x76C2,0x76CD,0x76D6,0x76D2,0x76DE,0x76E1,0x76E5,0x76E7,0x76EA,0x862F,0x76FB,0x7708,0x7707,0x7704,0x7729,
	0x7724,0x771E,0x7725,0x7726,0x771B,0x7737,0x7738,0x7747,0x775A,0x7768,0x776B,0x775B,0x7765,0x777F,0x777E,0x7779,
	0x778E,0x778B,0x7791,0x77A0,0x779E,0x77B0,0x77B6,0x77B9,0x77BF,0x77BC,0x77BD,0x77BB,0x77C7,0x77CD,0x77D7,0x77DA,
	0x77DC,0x77E3,0x77EE,0x77FC,0x780C,0x7812,0x7926,0x7820,0x792A,0x7845,0x788E,0x7874,0x7886,0x787C,0x789A,0x788C,
	0x78A3,0x78B5,0x78AA,0x78AF,0x78D1,0x78C6,0x78CB,0x78D4,0x78BE,0x78BC,0x78C5,0x78CA,0x78EC,
};
static const WCHAR _sjis_to_ucs_E200_data []={ //E240 E2FC
	0x78E7,0x78DA,0x78FD,0x78F4,0x7907,0x7912,0x7911,0x7919,0x792C,0x792B,0x7940,0x7960,0x7957,0x795F,0x795A,0x7955,
	0x7953,0x797A,0x797F,0x798A,0x799D,0x79A7,0x9F4B,0x79AA,0x79AE,0x79B3,0x79B9,0x79BA,0x79C9,0x79D5,0x79E7,0x79EC,
	0x79E1,0x79E3,0x7A08,0x7A0D,0x7A18,0x7A19,0x7A20,0x7A1F,0x7980,0x7A31,0x7A3B,0x7A3E,0x7A37,0x7A43,0x7A57,0x7A49,
	0x7A61,0x7A62,0x7A69,0x9F9D,0x7A70,0x7A79,0x7A7D,0x7A88,0x7A97,0x7A95,0x7A98,0x7A96,0x7AA9,0x7AC8,0x7AB0,0x0000,
	0x7AB6,0x7AC5,0x7AC4,0x7ABF,0x9083,0x7AC7,0x7ACA,0x7ACD,0x7ACF,0x7AD5,0x7AD3,0x7AD9,0x7ADA,0x7ADD,0x7AE1,0x7AE2,
	0x7AE6,0x7AED,0x7AF0,0x7B02,0x7B0F,0x7B0A,0x7B06,0x7B33,0x7B18,0x7B19,0x7B1E,0x7B35,0x7B28,0x7B36,0x7B50,0x7B7A,
	0x7B04,0x7B4D,0x7B0B,0x7B4C,0x7B45,0x7B75,0x7B65,0x7B74,0x7B67,0x7B70,0x7B71,0x7B6C,0x7B6E,0x7B9D,0x7B98,0x7B9F,
	0x7B8D,0x7B9C,0x7B9A,0x7B8B,0x7B92,0x7B8F,0x7B5D,0x7B99,0x7BCB,0x7BC1,0x7BCC,0x7BCF,0x7BB4,0x7BC6,0x7BDD,0x7BE9,
	0x7C11,0x7C14,0x7BE6,0x7BE5,0x7C60,0x7C00,0x7C07,0x7C13,0x7BF3,0x7BF7,0x7C17,0x7C0D,0x7BF6,0x7C23,0x7C27,0x7C2A,
	0x7C1F,0x7C37,0x7C2B,0x7C3D,0x7C4C,0x7C43,0x7C54,0x7C4F,0x7C40,0x7C50,0x7C58,0x7C5F,0x7C64,0x7C56,0x7C65,0x7C6C,
	0x7C75,0x7C83,0x7C90,0x7CA4,0x7CAD,0x7CA2,0x7CAB,0x7CA1,0x7CA8,0x7CB3,0x7CB2,0x7CB1,0x7CAE,0x7CB9,0x7CBD,0x7CC0,
	0x7CC5,0x7CC2,0x7CD8,0x7CD2,0x7CDC,0x7CE2,0x9B3B,0x7CEF,0x7CF2,0x7CF4,0x7CF6,0x7CFA,0x7D06,
};
static const WCHAR _sjis_to_ucs_E300_data []={ //E340 E3FC
	0x7D02,0x7D1C,0x7D15,0x7D0A,0x7D45,0x7D4B,0x7D2E,0x7D32,0x7D3F,0x7D35,0x7D46,0x7D73,0x7D56,0x7D4E,0x7D72,0x7D68,
	0x7D6E,0x7D4F,0x7D63,0x7D93,0x7D89,0x7D5B,0x7D8F,0x7D7D,0x7D9B,0x7DBA,0x7DAE,0x7DA3,0x7DB5,0x7DC7,0x7DBD,0x7DAB,
	0x7E3D,0x7DA2,0x7DAF,0x7DDC,0x7DB8,0x7D9F,0x7DB0,0x7DD8,0x7DDD,0x7DE4,0x7DDE,0x7DFB,0x7DF2,0x7DE1,0x7E05,0x7E0A,
	0x7E23,0x7E21,0x7E12,0x7E31,0x7E1F,0x7E09,0x7E0B,0x7E22,0x7E46,0x7E66,0x7E3B,0x7E35,0x7E39,0x7E43,0x7E37,0x0000,
	0x7E32,0x7E3A,0x7E67,0x7E5D,0x7E56,0x7E5E,0x7E59,0x7E5A,0x7E79,0x7E6A,0x7E69,0x7E7C,0x7E7B,0x7E83,0x7DD5,0x7E7D,
	0x8FAE,0x7E7F,0x7E88,0x7E89,0x7E8C,0x7E92,0x7E90,0x7E93,0x7E94,0x7E96,0x7E8E,0x7E9B,0x7E9C,0x7F38,0x7F3A,0x7F45,
	0x7F4C,0x7F4D,0x7F4E,0x7F50,0x7F51,0x7F55,0x7F54,0x7F58,0x7F5F,0x7F60,0x7F68,0x7F69,0x7F67,0x7F78,0x7F82,0x7F86,
	0x7F83,0x7F88,0x7F87,0x7F8C,0x7F94,0x7F9E,0x7F9D,0x7F9A,0x7FA3,0x7FAF,0x7FB2,0x7FB9,0x7FAE,0x7FB6,0x7FB8,0x8B71,
	0x7FC5,0x7FC6,0x7FCA,0x7FD5,0x7FD4,0x7FE1,0x7FE6,0x7FE9,0x7FF3,0x7FF9,0x98DC,0x8006,0x8004,0x800B,0x8012,0x8018,
	0x8019,0x801C,0x8021,0x8028,0x803F,0x803B,0x804A,0x8046,0x8052,0x8058,0x805A,0x805F,0x8062,0x8068,0x8073,0x8072,
	0x8070,0x8076,0x8079,0x807D,0x807F,0x8084,0x8086,0x8085,0x809B,0x8093,0x809A,0x80AD,0x5190,0x80AC,0x80DB,0x80E5,
	0x80D9,0x80DD,0x80C4,0x80DA,0x80D6,0x8109,0x80EF,0x80F1,0x811B,0x8129,0x8123,0x812F,0x814B,
};
static const WCHAR _sjis_to_ucs_E400_data []={ //E440 E4FC
	0x968B,0x8146,0x813E,0x8153,0x8151,0x80FC,0x8171,0x816E,0x8165,0x8166,0x8174,0x8183,0x8188,0x818A,0x8180,0x8182,
	0x81A0,0x8195,0x81A4,0x81A3,0x815F,0x8193,0x81A9,0x81B0,0x81B5,0x81BE,0x81B8,0x81BD,0x81C0,0x81C2,0x81BA,0x81C9,
	0x81CD,0x81D1,0x81D9,0x81D8,0x81C8,0x81DA,0x81DF,0x81E0,0x81E7,0x81FA,0x81FB,0x81FE,0x8201,0x8202,0x8205,0x8207,
	0x820A,0x820D,0x8210,0x8216,0x8229,0x822B,0x8238,0x8233,0x8240,0x8259,0x8258,0x825D,0x825A,0x825F,0x8264,0x0000,
	0x8262,0x8268,0x826A,0x826B,0x822E,0x8271,0x8277,0x8278,0x827E,0x828D,0x8292,0x82AB,0x829F,0x82BB,0x82AC,0x82E1,
	0x82E3,0x82DF,0x82D2,0x82F4,0x82F3,0x82FA,0x8393,0x8303,0x82FB,0x82F9,0x82DE,0x8306,0x82DC,0x8309,0x82D9,0x8335,
	0x8334,0x8316,0x8332,0x8331,0x8340,0x8339,0x8350,0x8345,0x832F,0x832B,0x8317,0x8318,0x8385,0x839A,0x83AA,0x839F,
	0x83A2,0x8396,0x8323,0x838E,0x8387,0x838A,0x837C,0x83B5,0x8373,0x8375,0x83A0,0x8389,0x83A8,0x83F4,0x8413,0x83EB,
	0x83CE,0x83FD,0x8403,0x83D8,0x840B,0x83C1,0x83F7,0x8407,0x83E0,0x83F2,0x840D,0x8422,0x8420,0x83BD,0x8438,0x8506,
	0x83FB,0x846D,0x842A,0x843C,0x855A,0x8484,0x8477,0x846B,0x84AD,0x846E,0x8482,0x8469,0x8446,0x842C,0x846F,0x8479,
	0x8435,0x84CA,0x8462,0x84B9,0x84BF,0x849F,0x84D9,0x84CD,0x84BB,0x84DA,0x84D0,0x84C1,0x84C6,0x84D6,0x84A1,0x8521,
	0x84FF,0x84F4,0x8517,0x8518,0x852C,0x851F,0x8515,0x8514,0x84FC,0x8540,0x8563,0x8558,0x8548,
};
static const WCHAR _sjis_to_ucs_E500_data []={ //E540 E5FC
	0x8541,0x8602,0x854B,0x8555,0x8580,0x85A4,0x8588,0x8591,0x858A,0x85A8,0x856D,0x8594,0x859B,0x85EA,0x8587,0x859C,
	0x8577,0x857E,0x8590,0x85C9,0x85BA,0x85CF,0x85B9,0x85D0,0x85D5,0x85DD,0x85E5,0x85DC,0x85F9,0x860A,0x8613,0x860B,
	0x85FE,0x85FA,0x8606,0x8622,0x861A,0x8630,0x863F,0x864D,0x4E55,0x8654,0x865F,0x8667,0x8671,0x8693,0x86A3,0x86A9,
	0x86AA,0x868B,0x868C,0x86B6,0x86AF,0x86C4,0x86C6,0x86B0,0x86C9,0x8823,0x86AB,0x86D4,0x86DE,0x86E9,0x86EC,0x0000,
	0x86DF,0x86DB,0x86EF,0x8712,0x8706,0x8708,0x8700,0x8703,0x86FB,0x8711,0x8709,0x870D,0x86F9,0x870A,0x8734,0x873F,
	0x8737,0x873B,0x8725,0x8729,0x871A,0x8760,0x875F,0x8778,0x874C,0x874E,0x8774,0x8757,0x8768,0x876E,0x8759,0x8753,
	0x8763,0x876A,0x8805,0x87A2,0x879F,0x8782,0x87AF,0x87CB,0x87BD,0x87C0,0x87D0,0x96D6,0x87AB,0x87C4,0x87B3,0x87C7,
	0x87C6,0x87BB,0x87EF,0x87F2,0x87E0,0x880F,0x880D,0x87FE,0x87F6,0x87F7,0x880E,0x87D2,0x8811,0x8816,0x8815,0x8822,
	0x8821,0x8831,0x8836,0x8839,0x8827,0x883B,0x8844,0x8842,0x8852,0x8859,0x885E,0x8862,0x886B,0x8881,0x887E,0x889E,
	0x8875,0x887D,0x88B5,0x8872,0x8882,0x8897,0x8892,0x88AE,0x8899,0x88A2,0x888D,0x88A4,0x88B0,0x88BF,0x88B1,0x88C3,
	0x88C4,0x88D4,0x88D8,0x88D9,0x88DD,0x88F9,0x8902,0x88FC,0x88F4,0x88E8,0x88F2,0x8904,0x890C,0x890A,0x8913,0x8943,
	0x891E,0x8925,0x892A,0x892B,0x8941,0x8944,0x893B,0x8936,0x8938,0x894C,0x891D,0x8960,0x895E,
};
static const WCHAR _sjis_to_ucs_E600_data []={ //E640 E6FC
	0x8966,0x8964,0x896D,0x896A,0x896F,0x8974,0x8977,0x897E,0x8983,0x8988,0x898A,0x8993,0x8998,0x89A1,0x89A9,0x89A6,
	0x89AC,0x89AF,0x89B2,0x89BA,0x89BD,0x89BF,0x89C0,0x89DA,0x89DC,0x89DD,0x89E7,0x89F4,0x89F8,0x8A03,0x8A16,0x8A10,
	0x8A0C,0x8A1B,0x8A1D,0x8A25,0x8A36,0x8A41,0x8A5B,0x8A52,0x8A46,0x8A48,0x8A7C,0x8A6D,0x8A6C,0x8A62,0x8A85,0x8A82,
	0x8A84,0x8AA8,0x8AA1,0x8A91,0x8AA5,0x8AA6,0x8A9A,0x8AA3,0x8AC4,0x8ACD,0x8AC2,0x8ADA,0x8AEB,0x8AF3,0x8AE7,0x0000,
	0x8AE4,0x8AF1,0x8B14,0x8AE0,0x8AE2,0x8AF7,0x8ADE,0x8ADB,0x8B0C,0x8B07,0x8B1A,0x8AE1,0x8B16,0x8B10,0x8B17,0x8B20,
	0x8B33,0x97AB,0x8B26,0x8B2B,0x8B3E,0x8B28,0x8B41,0x8B4C,0x8B4F,0x8B4E,0x8B49,0x8B56,0x8B5B,0x8B5A,0x8B6B,0x8B5F,
	0x8B6C,0x8B6F,0x8B74,0x8B7D,0x8B80,0x8B8C,0x8B8E,0x8B92,0x8B93,0x8B96,0x8B99,0x8B9A,0x8C3A,0x8C41,0x8C3F,0x8C48,
	0x8C4C,0x8C4E,0x8C50,0x8C55,0x8C62,0x8C6C,0x8C78,0x8C7A,0x8C82,0x8C89,0x8C85,0x8C8A,0x8C8D,0x8C8E,0x8C94,0x8C7C,
	0x8C98,0x621D,0x8CAD,0x8CAA,0x8CBD,0x8CB2,0x8CB3,0x8CAE,0x8CB6,0x8CC8,0x8CC1,0x8CE4,0x8CE3,0x8CDA,0x8CFD,0x8CFA,
	0x8CFB,0x8D04,0x8D05,0x8D0A,0x8D07,0x8D0F,0x8D0D,0x8D10,0x9F4E,0x8D13,0x8CCD,0x8D14,0x8D16,0x8D67,0x8D6D,0x8D71,
	0x8D73,0x8D81,0x8D99,0x8DC2,0x8DBE,0x8DBA,0x8DCF,0x8DDA,0x8DD6,0x8DCC,0x8DDB,0x8DCB,0x8DEA,0x8DEB,0x8DDF,0x8DE3,
	0x8DFC,0x8E08,0x8E09,0x8DFF,0x8E1D,0x8E1E,0x8E10,0x8E1F,0x8E42,0x8E35,0x8E30,0x8E34,0x8E4A,
};
static const WCHAR _sjis_to_ucs_E700_data []={ //E740 E7FC
	0x8E47,0x8E49,0x8E4C,0x8E50,0x8E48,0x8E59,0x8E64,0x8E60,0x8E2A,0x8E63,0x8E55,0x8E76,0x8E72,0x8E7C,0x8E81,0x8E87,
	0x8E85,0x8E84,0x8E8B,0x8E8A,0x8E93,0x8E91,0x8E94,0x8E99,0x8EAA,0x8EA1,0x8EAC,0x8EB0,0x8EC6,0x8EB1,0x8EBE,0x8EC5,
	0x8EC8,0x8ECB,0x8EDB,0x8EE3,0x8EFC,0x8EFB,0x8EEB,0x8EFE,0x8F0A,0x8F05,0x8F15,0x8F12,0x8F19,0x8F13,0x8F1C,0x8F1F,
	0x8F1B,0x8F0C,0x8F26,0x8F33,0x8F3B,0x8F39,0x8F45,0x8F42,0x8F3E,0x8F4C,0x8F49,0x8F46,0x8F4E,0x8F57,0x8F5C,0x0000,
	0x8F62,0x8F63,0x8F64,0x8F9C,0x8F9F,0x8FA3,0x8FAD,0x8FAF,0x8FB7,0x8FDA,0x8FE5,0x8FE2,0x8FEA,0x8FEF,0x9087,0x8FF4,
	0x9005,0x8FF9,0x8FFA,0x9011,0x9015,0x9021,0x900D,0x901E,0x9016,0x900B,0x9027,0x9036,0x9035,0x9039,0x8FF8,0x904F,
	0x9050,0x9051,0x9052,0x900E,0x9049,0x903E,0x9056,0x9058,0x905E,0x9068,0x906F,0x9076,0x96A8,0x9072,0x9082,0x907D,
	0x9081,0x9080,0x908A,0x9089,0x908F,0x90A8,0x90AF,0x90B1,0x90B5,0x90E2,0x90E4,0x6248,0x90DB,0x9102,0x9112,0x9119,
	0x9132,0x9130,0x914A,0x9156,0x9158,0x9163,0x9165,0x9169,0x9173,0x9172,0x918B,0x9189,0x9182,0x91A2,0x91AB,0x91AF,
	0x91AA,0x91B5,0x91B4,0x91BA,0x91C0,0x91C1,0x91C9,0x91CB,0x91D0,0x91D6,0x91DF,0x91E1,0x91DB,0x91FC,0x91F5,0x91F6,
	0x921E,0x91FF,0x9214,0x922C,0x9215,0x9211,0x925E,0x9257,0x9245,0x9249,0x9264,0x9248,0x9295,0x923F,0x924B,0x9250,
	0x929C,0x9296,0x9293,0x929B,0x925A,0x92CF,0x92B9,0x92B7,0x92E9,0x930F,0x92FA,0x9344,0x932E,
};
static const WCHAR _sjis_to_ucs_E800_data []={ //E840 E8FC
	0x9319,0x9322,0x931A,0x9323,0x933A,0x9335,0x933B,0x935C,0x9360,0x937C,0x936E,0x9356,0x93B0,0x93AC,0x93AD,0x9394,
	0x93B9,0x93D6,0x93D7,0x93E8,0x93E5,0x93D8,0x93C3,0x93DD,0x93D0,0x93C8,0x93E4,0x941A,0x9414,0x9413,0x9403,0x9407,
	0x9410,0x9436,0x942B,0x9435,0x9421,0x943A,0x9441,0x9452,0x9444,0x945B,0x9460,0x9462,0x945E,0x946A,0x9229,0x9470,
	0x9475,0x9477,0x947D,0x945A,0x947C,0x947E,0x9481,0x947F,0x9582,0x9587,0x958A,0x9594,0x9596,0x9598,0x9599,0x0000,
	0x95A0,0x95A8,0x95A7,0x95AD,0x95BC,0x95BB,0x95B9,0x95BE,0x95CA,0x6FF6,0x95C3,0x95CD,0x95CC,0x95D5,0x95D4,0x95D6,
	0x95DC,0x95E1,0x95E5,0x95E2,0x9621,0x9628,0x962E,0x962F,0x9642,0x964C,0x964F,0x964B,0x9677,0x965C,0x965E,0x965D,
	0x965F,0x9666,0x9672,0x966C,0x968D,0x9698,0x9695,0x9697,0x96AA,0x96A7,0x96B1,0x96B2,0x96B0,0x96B4,0x96B6,0x96B8,
	0x96B9,0x96CE,0x96CB,0x96C9,0x96CD,0x894D,0x96DC,0x970D,0x96D5,0x96F9,0x9704,0x9706,0x9708,0x9713,0x970E,0x9711,
	0x970F,0x9716,0x9719,0x9724,0x972A,0x9730,0x9739,0x973D,0x973E,0x9744,0x9746,0x9748,0x9742,0x9749,0x975C,0x9760,
	0x9764,0x9766,0x9768,0x52D2,0x976B,0x9771,0x9779,0x9785,0x977C,0x9781,0x977A,0x9786,0x978B,0x978F,0x9790,0x979C,
	0x97A8,0x97A6,0x97A3,0x97B3,0x97B4,0x97C3,0x97C6,0x97C8,0x97CB,0x97DC,0x97ED,0x9F4F,0x97F2,0x7ADF,0x97F6,0x97F5,
	0x980F,0x980C,0x9838,0x9824,0x9821,0x9837,0x983D,0x9846,0x984F,0x984B,0x986B,0x986F,0x9870,
};
static const WCHAR _sjis_to_ucs_E900_data []={ //E940 E9FC
	0x9871,0x9874,0x9873,0x98AA,0x98AF,0x98B1,0x98B6,0x98C4,0x98C3,0x98C6,0x98E9,0x98EB,0x9903,0x9909,0x9912,0x9914,
	0x9918,0x9921,0x991D,0x991E,0x9924,0x9920,0x992C,0x992E,0x993D,0x993E,0x9942,0x9949,0x9945,0x9950,0x994B,0x9951,
	0x9952,0x994C,0x9955,0x9997,0x9998,0x99A5,0x99AD,0x99AE,0x99BC,0x99DF,0x99DB,0x99DD,0x99D8,0x99D1,0x99ED,0x99EE,
	0x99F1,0x99F2,0x99FB,0x99F8,0x9A01,0x9A0F,0x9A05,0x99E2,0x9A19,0x9A2B,0x9A37,0x9A45,0x9A42,0x9A40,0x9A43,0x0000,
	0x9A3E,0x9A55,0x9A4D,0x9A5B,0x9A57,0x9A5F,0x9A62,0x9A65,0x9A64,0x9A69,0x9A6B,0x9A6A,0x9AAD,0x9AB0,0x9ABC,0x9AC0,
	0x9ACF,0x9AD1,0x9AD3,0x9AD4,0x9ADE,0x9ADF,0x9AE2,0x9AE3,0x9AE6,0x9AEF,0x9AEB,0x9AEE,0x9AF4,0x9AF1,0x9AF7,0x9AFB,
	0x9B06,0x9B18,0x9B1A,0x9B1F,0x9B22,0x9B23,0x9B25,0x9B27,0x9B28,0x9B29,0x9B2A,0x9B2E,0x9B2F,0x9B32,0x9B44,0x9B43,
	0x9B4F,0x9B4D,0x9B4E,0x9B51,0x9B58,0x9B74,0x9B93,0x9B83,0x9B91,0x9B96,0x9B97,0x9B9F,0x9BA0,0x9BA8,0x9BB4,0x9BC0,
	0x9BCA,0x9BB9,0x9BC6,0x9BCF,0x9BD1,0x9BD2,0x9BE3,0x9BE2,0x9BE4,0x9BD4,0x9BE1,0x9C3A,0x9BF2,0x9BF1,0x9BF0,0x9C15,
	0x9C14,0x9C09,0x9C13,0x9C0C,0x9C06,0x9C08,0x9C12,0x9C0A,0x9C04,0x9C2E,0x9C1B,0x9C25,0x9C24,0x9C21,0x9C30,0x9C47,
	0x9C32,0x9C46,0x9C3E,0x9C5A,0x9C60,0x9C67,0x9C76,0x9C78,0x9CE7,0x9CEC,0x9CF0,0x9D09,0x9D08,0x9CEB,0x9D03,0x9D06,
	0x9D2A,0x9D26,0x9DAF,0x9D23,0x9D1F,0x9D44,0x9D15,0x9D12,0x9D41,0x9D3F,0x9D3E,0x9D46,0x9D48,
};
static const WCHAR _sjis_to_ucs_EA00_data []={ //EA40 EAA4
	0x9D5D,0x9D5E,0x9D64,0x9D51,0x9D50,0x9D59,0x9D72,0x9D89,0x9D87,0x9DAB,0x9D6F,0x9D7A,0x9D9A,0x9DA4,0x9DA9,0x9DB2,
	0x9DC4,0x9DC1,0x9DBB,0x9DB8,0x9DBA,0x9DC6,0x9DCF,0x9DC2,0x9DD9,0x9DD3,0x9DF8,0x9DE6,0x9DED,0x9DEF,0x9DFD,0x9E1A,
	0x9E1B,0x9E1E,0x9E75,0x9E79,0x9E7D,0x9E81,0x9E88,0x9E8B,0x9E8C,0x9E92,0x9E95,0x9E91,0x9E9D,0x9EA5,0x9EA9,0x9EB8,
	0x9EAA,0x9EAD,0x9761,0x9ECC,0x9ECE,0x9ECF,0x9ED0,0x9ED4,0x9EDC,0x9EDE,0x9EDD,0x9EE0,0x9EE5,0x9EE8,0x9EEF,0x0000,
	0x9EF4,0x9EF6,0x9EF7,0x9EF9,0x9EFB,0x9EFC,0x9EFD,0x9F07,0x9F08,0x76B7,0x9F15,0x9F21,0x9F2C,0x9F3E,0x9F4A,0x9F52,
	0x9F54,0x9F63,0x9F5F,0x9F60,0x9F61,0x9F66,0x9F67,0x9F6C,0x9F6A,0x9F77,0x9F72,0x9F76,0x9F95,0x9F9C,0x9FA0,0x582F,
	0x69C7,0x9059,0x7464,0x51DC,0x7199,
};
static const WCHAR _sjis_to_ucs_F000_data []={ //F040 F0FC
	0xE000,0xE001,0xE002,0xE003,0xE004,0xE005,0xE006,0xE007,0xE008,0xE009,0xE00A,0xE00B,0xE00C,0xE00D,0xE00E,0xE00F,
	0xE010,0xE011,0xE012,0xE013,0xE014,0xE015,0xE016,0xE017,0xE018,0xE019,0xE01A,0xE01B,0xE01C,0xE01D,0xE01E,0xE01F,
	0xE020,0xE021,0xE022,0xE023,0xE024,0xE025,0xE026,0xE027,0xE028,0xE029,0xE02A,0xE02B,0xE02C,0xE02D,0xE02E,0xE02F,
	0xE030,0xE031,0xE032,0xE033,0xE034,0xE035,0xE036,0xE037,0xE038,0xE039,0xE03A,0xE03B,0xE03C,0xE03D,0xE03E,0x0000,
	0xE03F,0xE040,0xE041,0xE042,0xE043,0xE044,0xE045,0xE046,0xE047,0xE048,0xE049,0xE04A,0xE04B,0xE04C,0xE04D,0xE04E,
	0xE04F,0xE050,0xE051,0xE052,0xE053,0xE054,0xE055,0xE056,0xE057,0xE058,0xE059,0xE05A,0xE05B,0xE05C,0xE05D,0xE05E,
	0xE05F,0xE060,0xE061,0xE062,0xE063,0xE064,0xE065,0xE066,0xE067,0xE068,0xE069,0xE06A,0xE06B,0xE06C,0xE06D,0xE06E,
	0xE06F,0xE070,0xE071,0xE072,0xE073,0xE074,0xE075,0xE076,0xE077,0xE078,0xE079,0xE07A,0xE07B,0xE07C,0xE07D,0xE07E,
	0xE07F,0xE080,0xE081,0xE082,0xE083,0xE084,0xE085,0xE086,0xE087,0xE088,0xE089,0xE08A,0xE08B,0xE08C,0xE08D,0xE08E,
	0xE08F,0xE090,0xE091,0xE092,0xE093,0xE094,0xE095,0xE096,0xE097,0xE098,0xE099,0xE09A,0xE09B,0xE09C,0xE09D,0xE09E,
	0xE09F,0xE0A0,0xE0A1,0xE0A2,0xE0A3,0xE0A4,0xE0A5,0xE0A6,0xE0A7,0xE0A8,0xE0A9,0xE0AA,0xE0AB,0xE0AC,0xE0AD,0xE0AE,
	0xE0AF,0xE0B0,0xE0B1,0xE0B2,0xE0B3,0xE0B4,0xE0B5,0xE0B6,0xE0B7,0xE0B8,0xE0B9,0xE0BA,0xE0BB,
};
static const WCHAR _sjis_to_ucs_F100_data []={ //F140 F1FC
	0xE0BC,0xE0BD,0xE0BE,0xE0BF,0xE0C0,0xE0C1,0xE0C2,0xE0C3,0xE0C4,0xE0C5,0xE0C6,0xE0C7,0xE0C8,0xE0C9,0xE0CA,0xE0CB,
	0xE0CC,0xE0CD,0xE0CE,0xE0CF,0xE0D0,0xE0D1,0xE0D2,0xE0D3,0xE0D4,0xE0D5,0xE0D6,0xE0D7,0xE0D8,0xE0D9,0xE0DA,0xE0DB,
	0xE0DC,0xE0DD,0xE0DE,0xE0DF,0xE0E0,0xE0E1,0xE0E2,0xE0E3,0xE0E4,0xE0E5,0xE0E6,0xE0E7,0xE0E8,0xE0E9,0xE0EA,0xE0EB,
	0xE0EC,0xE0ED,0xE0EE,0xE0EF,0xE0F0,0xE0F1,0xE0F2,0xE0F3,0xE0F4,0xE0F5,0xE0F6,0xE0F7,0xE0F8,0xE0F9,0xE0FA,0x0000,
	0xE0FB,0xE0FC,0xE0FD,0xE0FE,0xE0FF,0xE100,0xE101,0xE102,0xE103,0xE104,0xE105,0xE106,0xE107,0xE108,0xE109,0xE10A,
	0xE10B,0xE10C,0xE10D,0xE10E,0xE10F,0xE110,0xE111,0xE112,0xE113,0xE114,0xE115,0xE116,0xE117,0xE118,0xE119,0xE11A,
	0xE11B,0xE11C,0xE11D,0xE11E,0xE11F,0xE120,0xE121,0xE122,0xE123,0xE124,0xE125,0xE126,0xE127,0xE128,0xE129,0xE12A,
	0xE12B,0xE12C,0xE12D,0xE12E,0xE12F,0xE130,0xE131,0xE132,0xE133,0xE134,0xE135,0xE136,0xE137,0xE138,0xE139,0xE13A,
	0xE13B,0xE13C,0xE13D,0xE13E,0xE13F,0xE140,0xE141,0xE142,0xE143,0xE144,0xE145,0xE146,0xE147,0xE148,0xE149,0xE14A,
	0xE14B,0xE14C,0xE14D,0xE14E,0xE14F,0xE150,0xE151,0xE152,0xE153,0xE154,0xE155,0xE156,0xE157,0xE158,0xE159,0xE15A,
	0xE15B,0xE15C,0xE15D,0xE15E,0xE15F,0xE160,0xE161,0xE162,0xE163,0xE164,0xE165,0xE166,0xE167,0xE168,0xE169,0xE16A,
	0xE16B,0xE16C,0xE16D,0xE16E,0xE16F,0xE170,0xE171,0xE172,0xE173,0xE174,0xE175,0xE176,0xE177,
};
static const WCHAR _sjis_to_ucs_F200_data []={ //F240 F2FC
	0xE178,0xE179,0xE17A,0xE17B,0xE17C,0xE17D,0xE17E,0xE17F,0xE180,0xE181,0xE182,0xE183,0xE184,0xE185,0xE186,0xE187,
	0xE188,0xE189,0xE18A,0xE18B,0xE18C,0xE18D,0xE18E,0xE18F,0xE190,0xE191,0xE192,0xE193,0xE194,0xE195,0xE196,0xE197,
	0xE198,0xE199,0xE19A,0xE19B,0xE19C,0xE19D,0xE19E,0xE19F,0xE1A0,0xE1A1,0xE1A2,0xE1A3,0xE1A4,0xE1A5,0xE1A6,0xE1A7,
	0xE1A8,0xE1A9,0xE1AA,0xE1AB,0xE1AC,0xE1AD,0xE1AE,0xE1AF,0xE1B0,0xE1B1,0xE1B2,0xE1B3,0xE1B4,0xE1B5,0xE1B6,0x0000,
	0xE1B7,0xE1B8,0xE1B9,0xE1BA,0xE1BB,0xE1BC,0xE1BD,0xE1BE,0xE1BF,0xE1C0,0xE1C1,0xE1C2,0xE1C3,0xE1C4,0xE1C5,0xE1C6,
	0xE1C7,0xE1C8,0xE1C9,0xE1CA,0xE1CB,0xE1CC,0xE1CD,0xE1CE,0xE1CF,0xE1D0,0xE1D1,0xE1D2,0xE1D3,0xE1D4,0xE1D5,0xE1D6,
	0xE1D7,0xE1D8,0xE1D9,0xE1DA,0xE1DB,0xE1DC,0xE1DD,0xE1DE,0xE1DF,0xE1E0,0xE1E1,0xE1E2,0xE1E3,0xE1E4,0xE1E5,0xE1E6,
	0xE1E7,0xE1E8,0xE1E9,0xE1EA,0xE1EB,0xE1EC,0xE1ED,0xE1EE,0xE1EF,0xE1F0,0xE1F1,0xE1F2,0xE1F3,0xE1F4,0xE1F5,0xE1F6,
	0xE1F7,0xE1F8,0xE1F9,0xE1FA,0xE1FB,0xE1FC,0xE1FD,0xE1FE,0xE1FF,0xE200,0xE201,0xE202,0xE203,0xE204,0xE205,0xE206,
	0xE207,0xE208,0xE209,0xE20A,0xE20B,0xE20C,0xE20D,0xE20E,0xE20F,0xE210,0xE211,0xE212,0xE213,0xE214,0xE215,0xE216,
	0xE217,0xE218,0xE219,0xE21A,0xE21B,0xE21C,0xE21D,0xE21E,0xE21F,0xE220,0xE221,0xE222,0xE223,0xE224,0xE225,0xE226,
	0xE227,0xE228,0xE229,0xE22A,0xE22B,0xE22C,0xE22D,0xE22E,0xE22F,0xE230,0xE231,0xE232,0xE233,
};
static const WCHAR _sjis_to_ucs_F300_data []={ //F340 F3FC
	0xE234,0xE235,0xE236,0xE237,0xE238,0xE239,0xE23A,0xE23B,0xE23C,0xE23D,0xE23E,0xE23F,0xE240,0xE241,0xE242,0xE243,
	0xE244,0xE245,0xE246,0xE247,0xE248,0xE249,0xE24A,0xE24B,0xE24C,0xE24D,0xE24E,0xE24F,0xE250,0xE251,0xE252,0xE253,
	0xE254,0xE255,0xE256,0xE257,0xE258,0xE259,0xE25A,0xE25B,0xE25C,0xE25D,0xE25E,0xE25F,0xE260,0xE261,0xE262,0xE263,
	0xE264,0xE265,0xE266,0xE267,0xE268,0xE269,0xE26A,0xE26B,0xE26C,0xE26D,0xE26E,0xE26F,0xE270,0xE271,0xE272,0x0000,
	0xE273,0xE274,0xE275,0xE276,0xE277,0xE278,0xE279,0xE27A,0xE27B,0xE27C,0xE27D,0xE27E,0xE27F,0xE280,0xE281,0xE282,
	0xE283,0xE284,0xE285,0xE286,0xE287,0xE288,0xE289,0xE28A,0xE28B,0xE28C,0xE28D,0xE28E,0xE28F,0xE290,0xE291,0xE292,
	0xE293,0xE294,0xE295,0xE296,0xE297,0xE298,0xE299,0xE29A,0xE29B,0xE29C,0xE29D,0xE29E,0xE29F,0xE2A0,0xE2A1,0xE2A2,
	0xE2A3,0xE2A4,0xE2A5,0xE2A6,0xE2A7,0xE2A8,0xE2A9,0xE2AA,0xE2AB,0xE2AC,0xE2AD,0xE2AE,0xE2AF,0xE2B0,0xE2B1,0xE2B2,
	0xE2B3,0xE2B4,0xE2B5,0xE2B6,0xE2B7,0xE2B8,0xE2B9,0xE2BA,0xE2BB,0xE2BC,0xE2BD,0xE2BE,0xE2BF,0xE2C0,0xE2C1,0xE2C2,
	0xE2C3,0xE2C4,0xE2C5,0xE2C6,0xE2C7,0xE2C8,0xE2C9,0xE2CA,0xE2CB,0xE2CC,0xE2CD,0xE2CE,0xE2CF,0xE2D0,0xE2D1,0xE2D2,
	0xE2D3,0xE2D4,0xE2D5,0xE2D6,0xE2D7,0xE2D8,0xE2D9,0xE2DA,0xE2DB,0xE2DC,0xE2DD,0xE2DE,0xE2DF,0xE2E0,0xE2E1,0xE2E2,
	0xE2E3,0xE2E4,0xE2E5,0xE2E6,0xE2E7,0xE2E8,0xE2E9,0xE2EA,0xE2EB,0xE2EC,0xE2ED,0xE2EE,0xE2EF,
};
static const WCHAR _sjis_to_ucs_F400_data []={ //F440 F4FC
	0xE2F0,0xE2F1,0xE2F2,0xE2F3,0xE2F4,0xE2F5,0xE2F6,0xE2F7,0xE2F8,0xE2F9,0xE2FA,0xE2FB,0xE2FC,0xE2FD,0xE2FE,0xE2FF,
	0xE300,0xE301,0xE302,0xE303,0xE304,0xE305,0xE306,0xE307,0xE308,0xE309,0xE30A,0xE30B,0xE30C,0xE30D,0xE30E,0xE30F,
	0xE310,0xE311,0xE312,0xE313,0xE314,0xE315,0xE316,0xE317,0xE318,0xE319,0xE31A,0xE31B,0xE31C,0xE31D,0xE31E,0xE31F,
	0xE320,0xE321,0xE322,0xE323,0xE324,0xE325,0xE326,0xE327,0xE328,0xE329,0xE32A,0xE32B,0xE32C,0xE32D,0xE32E,0x0000,
	0xE32F,0xE330,0xE331,0xE332,0xE333,0xE334,0xE335,0xE336,0xE337,0xE338,0xE339,0xE33A,0xE33B,0xE33C,0xE33D,0xE33E,
	0xE33F,0xE340,0xE341,0xE342,0xE343,0xE344,0xE345,0xE346,0xE347,0xE348,0xE349,0xE34A,0xE34B,0xE34C,0xE34D,0xE34E,
	0xE34F,0xE350,0xE351,0xE352,0xE353,0xE354,0xE355,0xE356,0xE357,0xE358,0xE359,0xE35A,0xE35B,0xE35C,0xE35D,0xE35E,
	0xE35F,0xE360,0xE361,0xE362,0xE363,0xE364,0xE365,0xE366,0xE367,0xE368,0xE369,0xE36A,0xE36B,0xE36C,0xE36D,0xE36E,
	0xE36F,0xE370,0xE371,0xE372,0xE373,0xE374,0xE375,0xE376,0xE377,0xE378,0xE379,0xE37A,0xE37B,0xE37C,0xE37D,0xE37E,
	0xE37F,0xE380,0xE381,0xE382,0xE383,0xE384,0xE385,0xE386,0xE387,0xE388,0xE389,0xE38A,0xE38B,0xE38C,0xE38D,0xE38E,
	0xE38F,0xE390,0xE391,0xE392,0xE393,0xE394,0xE395,0xE396,0xE397,0xE398,0xE399,0xE39A,0xE39B,0xE39C,0xE39D,0xE39E,
	0xE39F,0xE3A0,0xE3A1,0xE3A2,0xE3A3,0xE3A4,0xE3A5,0xE3A6,0xE3A7,0xE3A8,0xE3A9,0xE3AA,0xE3AB,
};
static const WCHAR _sjis_to_ucs_F500_data []={ //F540 F5FC
	0xE3AC,0xE3AD,0xE3AE,0xE3AF,0xE3B0,0xE3B1,0xE3B2,0xE3B3,0xE3B4,0xE3B5,0xE3B6,0xE3B7,0xE3B8,0xE3B9,0xE3BA,0xE3BB,
	0xE3BC,0xE3BD,0xE3BE,0xE3BF,0xE3C0,0xE3C1,0xE3C2,0xE3C3,0xE3C4,0xE3C5,0xE3C6,0xE3C7,0xE3C8,0xE3C9,0xE3CA,0xE3CB,
	0xE3CC,0xE3CD,0xE3CE,0xE3CF,0xE3D0,0xE3D1,0xE3D2,0xE3D3,0xE3D4,0xE3D5,0xE3D6,0xE3D7,0xE3D8,0xE3D9,0xE3DA,0xE3DB,
	0xE3DC,0xE3DD,0xE3DE,0xE3DF,0xE3E0,0xE3E1,0xE3E2,0xE3E3,0xE3E4,0xE3E5,0xE3E6,0xE3E7,0xE3E8,0xE3E9,0xE3EA,0x0000,
	0xE3EB,0xE3EC,0xE3ED,0xE3EE,0xE3EF,0xE3F0,0xE3F1,0xE3F2,0xE3F3,0xE3F4,0xE3F5,0xE3F6,0xE3F7,0xE3F8,0xE3F9,0xE3FA,
	0xE3FB,0xE3FC,0xE3FD,0xE3FE,0xE3FF,0xE400,0xE401,0xE402,0xE403,0xE404,0xE405,0xE406,0xE407,0xE408,0xE409,0xE40A,
	0xE40B,0xE40C,0xE40D,0xE40E,0xE40F,0xE410,0xE411,0xE412,0xE413,0xE414,0xE415,0xE416,0xE417,0xE418,0xE419,0xE41A,
	0xE41B,0xE41C,0xE41D,0xE41E,0xE41F,0xE420,0xE421,0xE422,0xE423,0xE424,0xE425,0xE426,0xE427,0xE428,0xE429,0xE42A,
	0xE42B,0xE42C,0xE42D,0xE42E,0xE42F,0xE430,0xE431,0xE432,0xE433,0xE434,0xE435,0xE436,0xE437,0xE438,0xE439,0xE43A,
	0xE43B,0xE43C,0xE43D,0xE43E,0xE43F,0xE440,0xE441,0xE442,0xE443,0xE444,0xE445,0xE446,0xE447,0xE448,0xE449,0xE44A,
	0xE44B,0xE44C,0xE44D,0xE44E,0xE44F,0xE450,0xE451,0xE452,0xE453,0xE454,0xE455,0xE456,0xE457,0xE458,0xE459,0xE45A,
	0xE45B,0xE45C,0xE45D,0xE45E,0xE45F,0xE460,0xE461,0xE462,0xE463,0xE464,0xE465,0xE466,0xE467,
};
static const WCHAR _sjis_to_ucs_F600_data []={ //F640 F6FC
	0xE468,0xE469,0xE46A,0xE46B,0xE46C,0xE46D,0xE46E,0xE46F,0xE470,0xE471,0xE472,0xE473,0xE474,0xE475,0xE476,0xE477,
	0xE478,0xE479,0xE47A,0xE47B,0xE47C,0xE47D,0xE47E,0xE47F,0xE480,0xE481,0xE482,0xE483,0xE484,0xE485,0xE486,0xE487,
	0xE488,0xE489,0xE48A,0xE48B,0xE48C,0xE48D,0xE48E,0xE48F,0xE490,0xE491,0xE492,0xE493,0xE494,0xE495,0xE496,0xE497,
	0xE498,0xE499,0xE49A,0xE49B,0xE49C,0xE49D,0xE49E,0xE49F,0xE4A0,0xE4A1,0xE4A2,0xE4A3,0xE4A4,0xE4A5,0xE4A6,0x0000,
	0xE4A7,0xE4A8,0xE4A9,0xE4AA,0xE4AB,0xE4AC,0xE4AD,0xE4AE,0xE4AF,0xE4B0,0xE4B1,0xE4B2,0xE4B3,0xE4B4,0xE4B5,0xE4B6,
	0xE4B7,0xE4B8,0xE4B9,0xE4BA,0xE4BB,0xE4BC,0xE4BD,0xE4BE,0xE4BF,0xE4C0,0xE4C1,0xE4C2,0xE4C3,0xE4C4,0xE4C5,0xE4C6,
	0xE4C7,0xE4C8,0xE4C9,0xE4CA,0xE4CB,0xE4CC,0xE4CD,0xE4CE,0xE4CF,0xE4D0,0xE4D1,0xE4D2,0xE4D3,0xE4D4,0xE4D5,0xE4D6,
	0xE4D7,0xE4D8,0xE4D9,0xE4DA,0xE4DB,0xE4DC,0xE4DD,0xE4DE,0xE4DF,0xE4E0,0xE4E1,0xE4E2,0xE4E3,0xE4E4,0xE4E5,0xE4E6,
	0xE4E7,0xE4E8,0xE4E9,0xE4EA,0xE4EB,0xE4EC,0xE4ED,0xE4EE,0xE4EF,0xE4F0,0xE4F1,0xE4F2,0xE4F3,0xE4F4,0xE4F5,0xE4F6,
	0xE4F7,0xE4F8,0xE4F9,0xE4FA,0xE4FB,0xE4FC,0xE4FD,0xE4FE,0xE4FF,0xE500,0xE501,0xE502,0xE503,0xE504,0xE505,0xE506,
	0xE507,0xE508,0xE509,0xE50A,0xE50B,0xE50C,0xE50D,0xE50E,0xE50F,0xE510,0xE511,0xE512,0xE513,0xE514,0xE515,0xE516,
	0xE517,0xE518,0xE519,0xE51A,0xE51B,0xE51C,0xE51D,0xE51E,0xE51F,0xE520,0xE521,0xE522,0xE523,
};
static const WCHAR _sjis_to_ucs_F700_data []={ //F740 F7FC
	0xE524,0xE525,0xE526,0xE527,0xE528,0xE529,0xE52A,0xE52B,0xE52C,0xE52D,0xE52E,0xE52F,0xE530,0xE531,0xE532,0xE533,
	0xE534,0xE535,0xE536,0xE537,0xE538,0xE539,0xE53A,0xE53B,0xE53C,0xE53D,0xE53E,0xE53F,0xE540,0xE541,0xE542,0xE543,
	0xE544,0xE545,0xE546,0xE547,0xE548,0xE549,0xE54A,0xE54B,0xE54C,0xE54D,0xE54E,0xE54F,0xE550,0xE551,0xE552,0xE553,
	0xE554,0xE555,0xE556,0xE557,0xE558,0xE559,0xE55A,0xE55B,0xE55C,0xE55D,0xE55E,0xE55F,0xE560,0xE561,0xE562,0x0000,
	0xE563,0xE564,0xE565,0xE566,0xE567,0xE568,0xE569,0xE56A,0xE56B,0xE56C,0xE56D,0xE56E,0xE56F,0xE570,0xE571,0xE572,
	0xE573,0xE574,0xE575,0xE576,0xE577,0xE578,0xE579,0xE57A,0xE57B,0xE57C,0xE57D,0xE57E,0xE57F,0xE580,0xE581,0xE582,
	0xE583,0xE584,0xE585,0xE586,0xE587,0xE588,0xE589,0xE58A,0xE58B,0xE58C,0xE58D,0xE58E,0xE58F,0xE590,0xE591,0xE592,
	0xE593,0xE594,0xE595,0xE596,0xE597,0xE598,0xE599,0xE59A,0xE59B,0xE59C,0xE59D,0xE59E,0xE59F,0xE5A0,0xE5A1,0xE5A2,
	0xE5A3,0xE5A4,0xE5A5,0xE5A6,0xE5A7,0xE5A8,0xE5A9,0xE5AA,0xE5AB,0xE5AC,0xE5AD,0xE5AE,0xE5AF,0xE5B0,0xE5B1,0xE5B2,
	0xE5B3,0xE5B4,0xE5B5,0xE5B6,0xE5B7,0xE5B8,0xE5B9,0xE5BA,0xE5BB,0xE5BC,0xE5BD,0xE5BE,0xE5BF,0xE5C0,0xE5C1,0xE5C2,
	0xE5C3,0xE5C4,0xE5C5,0xE5C6,0xE5C7,0xE5C8,0xE5C9,0xE5CA,0xE5CB,0xE5CC,0xE5CD,0xE5CE,0xE5CF,0xE5D0,0xE5D1,0xE5D2,
	0xE5D3,0xE5D4,0xE5D5,0xE5D6,0xE5D7,0xE5D8,0xE5D9,0xE5DA,0xE5DB,0xE5DC,0xE5DD,0xE5DE,0xE5DF,
};
static const WCHAR _sjis_to_ucs_F800_data []={ //F840 F8FC
	0xE5E0,0xE5E1,0xE5E2,0xE5E3,0xE5E4,0xE5E5,0xE5E6,0xE5E7,0xE5E8,0xE5E9,0xE5EA,0xE5EB,0xE5EC,0xE5ED,0xE5EE,0xE5EF,
	0xE5F0,0xE5F1,0xE5F2,0xE5F3,0xE5F4,0xE5F5,0xE5F6,0xE5F7,0xE5F8,0xE5F9,0xE5FA,0xE5FB,0xE5FC,0xE5FD,0xE5FE,0xE5FF,
	0xE600,0xE601,0xE602,0xE603,0xE604,0xE605,0xE606,0xE607,0xE608,0xE609,0xE60A,0xE60B,0xE60C,0xE60D,0xE60E,0xE60F,
	0xE610,0xE611,0xE612,0xE613,0xE614,0xE615,0xE616,0xE617,0xE618,0xE619,0xE61A,0xE61B,0xE61C,0xE61D,0xE61E,0x0000,
	0xE61F,0xE620,0xE621,0xE622,0xE623,0xE624,0xE625,0xE626,0xE627,0xE628,0xE629,0xE62A,0xE62B,0xE62C,0xE62D,0xE62E,
	0xE62F,0xE630,0xE631,0xE632,0xE633,0xE634,0xE635,0xE636,0xE637,0xE638,0xE639,0xE63A,0xE63B,0xE63C,0xE63D,0xE63E,
	0xE63F,0xE640,0xE641,0xE642,0xE643,0xE644,0xE645,0xE646,0xE647,0xE648,0xE649,0xE64A,0xE64B,0xE64C,0xE64D,0xE64E,
	0xE64F,0xE650,0xE651,0xE652,0xE653,0xE654,0xE655,0xE656,0xE657,0xE658,0xE659,0xE65A,0xE65B,0xE65C,0xE65D,0xE65E,
	0xE65F,0xE660,0xE661,0xE662,0xE663,0xE664,0xE665,0xE666,0xE667,0xE668,0xE669,0xE66A,0xE66B,0xE66C,0xE66D,0xE66E,
	0xE66F,0xE670,0xE671,0xE672,0xE673,0xE674,0xE675,0xE676,0xE677,0xE678,0xE679,0xE67A,0xE67B,0xE67C,0xE67D,0xE67E,
	0xE67F,0xE680,0xE681,0xE682,0xE683,0xE684,0xE685,0xE686,0xE687,0xE688,0xE689,0xE68A,0xE68B,0xE68C,0xE68D,0xE68E,
	0xE68F,0xE690,0xE691,0xE692,0xE693,0xE694,0xE695,0xE696,0xE697,0xE698,0xE699,0xE69A,0xE69B,
};
static const WCHAR _sjis_to_ucs_F900_data []={ //F940 F9FC
	0xE69C,0xE69D,0xE69E,0xE69F,0xE6A0,0xE6A1,0xE6A2,0xE6A3,0xE6A4,0xE6A5,0xE6A6,0xE6A7,0xE6A8,0xE6A9,0xE6AA,0xE6AB,
	0xE6AC,0xE6AD,0xE6AE,0xE6AF,0xE6B0,0xE6B1,0xE6B2,0xE6B3,0xE6B4,0xE6B5,0xE6B6,0xE6B7,0xE6B8,0xE6B9,0xE6BA,0xE6BB,
	0xE6BC,0xE6BD,0xE6BE,0xE6BF,0xE6C0,0xE6C1,0xE6C2,0xE6C3,0xE6C4,0xE6C5,0xE6C6,0xE6C7,0xE6C8,0xE6C9,0xE6CA,0xE6CB,
	0xE6CC,0xE6CD,0xE6CE,0xE6CF,0xE6D0,0xE6D1,0xE6D2,0xE6D3,0xE6D4,0xE6D5,0xE6D6,0xE6D7,0xE6D8,0xE6D9,0xE6DA,0x0000,
	0xE6DB,0xE6DC,0xE6DD,0xE6DE,0xE6DF,0xE6E0,0xE6E1,0xE6E2,0xE6E3,0xE6E4,0xE6E5,0xE6E6,0xE6E7,0xE6E8,0xE6E9,0xE6EA,
	0xE6EB,0xE6EC,0xE6ED,0xE6EE,0xE6EF,0xE6F0,0xE6F1,0xE6F2,0xE6F3,0xE6F4,0xE6F5,0xE6F6,0xE6F7,0xE6F8,0xE6F9,0xE6FA,
	0xE6FB,0xE6FC,0xE6FD,0xE6FE,0xE6FF,0xE700,0xE701,0xE702,0xE703,0xE704,0xE705,0xE706,0xE707,0xE708,0xE709,0xE70A,
	0xE70B,0xE70C,0xE70D,0xE70E,0xE70F,0xE710,0xE711,0xE712,0xE713,0xE714,0xE715,0xE716,0xE717,0xE718,0xE719,0xE71A,
	0xE71B,0xE71C,0xE71D,0xE71E,0xE71F,0xE720,0xE721,0xE722,0xE723,0xE724,0xE725,0xE726,0xE727,0xE728,0xE729,0xE72A,
	0xE72B,0xE72C,0xE72D,0xE72E,0xE72F,0xE730,0xE731,0xE732,0xE733,0xE734,0xE735,0xE736,0xE737,0xE738,0xE739,0xE73A,
	0xE73B,0xE73C,0xE73D,0xE73E,0xE73F,0xE740,0xE741,0xE742,0xE743,0xE744,0xE745,0xE746,0xE747,0xE748,0xE749,0xE74A,
	0xE74B,0xE74C,0xE74D,0xE74E,0xE74F,0xE750,0xE751,0xE752,0xE753,0xE754,0xE755,0xE756,0xE757,
};
static const WCHAR _sjis_to_ucs_FA00_data []={ //FA40 FAFC
	0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176,0x2177,0x2178,0x2179,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xFFE4,0xFF07,0xFF02,0x0000,0x0000,0x0000,0x0000,0x7E8A,0x891C,0x9348,0x9288,
	0x84DC,0x4FC9,0x70BB,0x6631,0x68C8,0x92F9,0x66FB,0x5F45,0x4E28,0x4EE1,0x4EFC,0x4F00,0x4F03,0x4F39,0x4F56,0x4F92,
	0x4F8A,0x4F9A,0x4F94,0x4FCD,0x5040,0x5022,0x4FFF,0x501E,0x5046,0x5070,0x5042,0x5094,0x50F4,0x50D8,0x514A,0x0000,
	0x5164,0x519D,0x51BE,0x51EC,0x5215,0x529C,0x52A6,0x52C0,0x52DB,0x5300,0x5307,0x5324,0x5372,0x5393,0x53B2,0x53DD,
	0xFA0E,0x549C,0x548A,0x54A9,0x54FF,0x5586,0x5759,0x5765,0x57AC,0x57C8,0x57C7,0xFA0F,0xFA10,0x589E,0x58B2,0x590B,
	0x5953,0x595B,0x595D,0x5963,0x59A4,0x59BA,0x5B56,0x5BC0,0x752F,0x5BD8,0x5BEC,0x5C1E,0x5CA6,0x5CBA,0x5CF5,0x5D27,
	0x5D53,0xFA11,0x5D42,0x5D6D,0x5DB8,0x5DB9,0x5DD0,0x5F21,0x5F34,0x5F67,0x5FB7,0x5FDE,0x605D,0x6085,0x608A,0x60DE,
	0x60D5,0x6120,0x60F2,0x6111,0x6137,0x6130,0x6198,0x6213,0x62A6,0x63F5,0x6460,0x649D,0x64CE,0x654E,0x6600,0x6615,
	0x663B,0x6609,0x662E,0x661E,0x6624,0x6665,0x6657,0x6659,0xFA12,0x6673,0x6699,0x66A0,0x66B2,0x66BF,0x66FA,0x670E,
	0xF929,0x6766,0x67BB,0x6852,0x67C0,0x6801,0x6844,0x68CF,0xFA13,0x6968,0xFA14,0x6998,0x69E2,0x6A30,0x6A6B,0x6A46,
	0x6A73,0x6A7E,0x6AE2,0x6AE4,0x6BD6,0x6C3F,0x6C5C,0x6C86,0x6C6F,0x6CDA,0x6D04,0x6D87,0x6D6F,
};
static const WCHAR _sjis_to_ucs_FB00_data []={ //FB40 FBFC
	0x6D96,0x6DAC,0x6DCF,0x6DF8,0x6DF2,0x6DFC,0x6E39,0x6E5C,0x6E27,0x6E3C,0x6EBF,0x6F88,0x6FB5,0x6FF5,0x7005,0x7007,
	0x7028,0x7085,0x70AB,0x710F,0x7104,0x715C,0x7146,0x7147,0xFA15,0x71C1,0x71FE,0x72B1,0x72BE,0x7324,0xFA16,0x7377,
	0x73BD,0x73C9,0x73D6,0x73E3,0x73D2,0x7407,0x73F5,0x7426,0x742A,0x7429,0x742E,0x7462,0x7489,0x749F,0x7501,0x756F,
	0x7682,0x769C,0x769E,0x769B,0x76A6,0xFA17,0x7746,0x52AF,0x7821,0x784E,0x7864,0x787A,0x7930,0xFA18,0xFA19,0x0000,
	0xFA1A,0x7994,0xFA1B,0x799B,0x7AD1,0x7AE7,0xFA1C,0x7AEB,0x7B9E,0xFA1D,0x7D48,0x7D5C,0x7DB7,0x7DA0,0x7DD6,0x7E52,
	0x7F47,0x7FA1,0xFA1E,0x8301,0x8362,0x837F,0x83C7,0x83F6,0x8448,0x84B4,0x8553,0x8559,0x856B,0xFA1F,0x85B0,0xFA20,
	0xFA21,0x8807,0x88F5,0x8A12,0x8A37,0x8A79,0x8AA7,0x8ABE,0x8ADF,0xFA22,0x8AF6,0x8B53,0x8B7F,0x8CF0,0x8CF4,0x8D12,
	0x8D76,0xFA23,0x8ECF,0xFA24,0xFA25,0x9067,0x90DE,0xFA26,0x9115,0x9127,0x91DA,0x91D7,0x91DE,0x91ED,0x91EE,0x91E4,
	0x91E5,0x9206,0x9210,0x920A,0x923A,0x9240,0x923C,0x924E,0x9259,0x9251,0x9239,0x9267,0x92A7,0x9277,0x9278,0x92E7,
	0x92D7,0x92D9,0x92D0,0xFA27,0x92D5,0x92E0,0x92D3,0x9325,0x9321,0x92FB,0xFA28,0x931E,0x92FF,0x931D,0x9302,0x9370,
	0x9357,0x93A4,0x93C6,0x93DE,0x93F8,0x9431,0x9445,0x9448,0x9592,0xF9DC,0xFA29,0x969D,0x96AF,0x9733,0x973B,0x9743,
	0x974D,0x974F,0x9751,0x9755,0x9857,0x9865,0xFA2A,0xFA2B,0x9927,0xFA2C,0x999E,0x9A4E,0x9AD9,
};
static const WCHAR _sjis_to_ucs_FC00_data []={ //FC40 FC4B
	0x9ADC,0x9B75,0x9B72,0x9B8F,0x9BB1,0x9BBB,0x9C00,0x9D70,0x9D6B,0xFA2D,0x9E19,0x9ED1,
};
extern const struct _encoding_table_a _sjis_to_ucs_table []={
	{ 0x00FF,0x0001,_sjis_to_ucs_0000_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x81FC,0x8140,_sjis_to_ucs_8100_data },
	{ 0x82F1,0x824F,_sjis_to_ucs_8200_data },
	{ 0x83D6,0x8340,_sjis_to_ucs_8300_data },
	{ 0x84BE,0x8440,_sjis_to_ucs_8400_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x8799,0x8740,_sjis_to_ucs_8700_data },
	{ 0x88FC,0x889F,_sjis_to_ucs_8800_data },
	{ 0x89FC,0x8940,_sjis_to_ucs_8900_data },
	{ 0x8AFC,0x8A40,_sjis_to_ucs_8A00_data },
	{ 0x8BFC,0x8B40,_sjis_to_ucs_8B00_data },
	{ 0x8CFC,0x8C40,_sjis_to_ucs_8C00_data },
	{ 0x8DFC,0x8D40,_sjis_to_ucs_8D00_data },
	{ 0x8EFC,0x8E40,_sjis_to_ucs_8E00_data },
	{ 0x8FFC,0x8F40,_sjis_to_ucs_8F00_data },
	{ 0x90FC,0x9040,_sjis_to_ucs_9000_data },
	{ 0x91FC,0x9140,_sjis_to_ucs_9100_data },
	{ 0x92FC,0x9240,_sjis_to_ucs_9200_data },
	{ 0x93FC,0x9340,_sjis_to_ucs_9300_data },
	{ 0x94FC,0x9440,_sjis_to_ucs_9400_data },
	{ 0x95FC,0x9540,_sjis_to_ucs_9500_data },
	{ 0x96FC,0x9640,_sjis_to_ucs_9600_data },
	{ 0x97FC,0x9740,_sjis_to_ucs_9700_data },
	{ 0x98FC,0x9840,_sjis_to_ucs_9800_data },
	{ 0x99FC,0x9940,_sjis_to_ucs_9900_data },
	{ 0x9AFC,0x9A40,_sjis_to_ucs_9A00_data },
	{ 0x9BFC,0x9B40,_sjis_to_ucs_9B00_data },
	{ 0x9CFC,0x9C40,_sjis_to_ucs_9C00_data },
	{ 0x9DFC,0x9D40,_sjis_to_ucs_9D00_data },
	{ 0x9EFC,0x9E40,_sjis_to_ucs_9E00_data },
	{ 0x9FFC,0x9F40,_sjis_to_ucs_9F00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xE0FC,0xE040,_sjis_to_ucs_E000_data },
	{ 0xE1FC,0xE140,_sjis_to_ucs_E100_data },
	{ 0xE2FC,0xE240,_sjis_to_ucs_E200_data },
	{ 0xE3FC,0xE340,_sjis_to_ucs_E300_data },
	{ 0xE4FC,0xE440,_sjis_to_ucs_E400_data },
	{ 0xE5FC,0xE540,_sjis_to_ucs_E500_data },
	{ 0xE6FC,0xE640,_sjis_to_ucs_E600_data },
	{ 0xE7FC,0xE740,_sjis_to_ucs_E700_data },
	{ 0xE8FC,0xE840,_sjis_to_ucs_E800_data },
	{ 0xE9FC,0xE940,_sjis_to_ucs_E900_data },
	{ 0xEAA4,0xEA40,_sjis_to_ucs_EA00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xF0FC,0xF040,_sjis_to_ucs_F000_data },
	{ 0xF1FC,0xF140,_sjis_to_ucs_F100_data },
	{ 0xF2FC,0xF240,_sjis_to_ucs_F200_data },
	{ 0xF3FC,0xF340,_sjis_to_ucs_F300_data },
	{ 0xF4FC,0xF440,_sjis_to_ucs_F400_data },
	{ 0xF5FC,0xF540,_sjis_to_ucs_F500_data },
	{ 0xF6FC,0xF640,_sjis_to_ucs_F600_data },
	{ 0xF7FC,0xF740,_sjis_to_ucs_F700_data },
	{ 0xF8FC,0xF840,_sjis_to_ucs_F800_data },
	{ 0xF9FC,0xF940,_sjis_to_ucs_F900_data },
	{ 0xFAFC,0xFA40,_sjis_to_ucs_FA00_data },
	{ 0xFBFC,0xFB40,_sjis_to_ucs_FB00_data },
	{ 0xFC4B,0xFC40,_sjis_to_ucs_FC00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
};
static const WORD _ucs_to_sjis_0000_data []={ //0001 00FF
	       0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
	0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,0x0088,0x0089,0x008A,0x008B,0x008C,0x008D,0x008E,0x008F,
	0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,0x0098,0x0099,0x009A,0x009B,0x009C,0x009D,0x009E,0x009F,
	0x00A0,0x00A1,0x00A2,0x00A3,0x00A4,0x00A5,0x00A6,0x8198,0x814E,0x00A9,0x00AA,0x00AB,0x00AC,0x00AD,0x00AE,0x00AF,
	0x818B,0x817D,0x00B2,0x00B3,0x814C,0x00B5,0x81F7,0x00B7,0x00B8,0x00B9,0x00BA,0x00BB,0x00BC,0x00BD,0x00BE,0x00BF,
	0x00C0,0x00C1,0x00C2,0x00C3,0x00C4,0x00C5,0x00C6,0x00C7,0x00C8,0x00C9,0x00CA,0x00CB,0x00CC,0x00CD,0x00CE,0x00CF,
	0x00D0,0x00D1,0x00D2,0x00D3,0x00D4,0x00D5,0x00D6,0x817E,0x00D8,0x00D9,0x00DA,0x00DB,0x00DC,0x00DD,0x00DE,0x00DF,
	0x00E0,0x00E1,0x00E2,0x00E3,0x00E4,0x00E5,0x00E6,0x00E7,0x00E8,0x00E9,0x00EA,0x00EB,0x00EC,0x00ED,0x00EE,0x00EF,
	0x00F0,0x00F1,0x00F2,0x00F3,0x00F4,0x00F5,0x00F6,0x8180,0x00F8,0x00F9,0x00FA,0x00FB,0x00FC,0x00FD,0x00FE,0x00FF,
};
static const WORD _ucs_to_sjis_0300_data []={ //0391 03C9
	       0x839F,0x83A0,0x83A1,0x83A2,0x83A3,0x83A4,0x83A5,0x83A6,0x83A7,0x83A8,0x83A9,0x83AA,0x83AB,0x83AC,0x83AD,
	0x83AE,0x83AF,0x0000,0x83B0,0x83B1,0x83B2,0x83B3,0x83B4,0x83B5,0x83B6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x83BF,0x83C0,0x83C1,0x83C2,0x83C3,0x83C4,0x83C5,0x83C6,0x83C7,0x83C8,0x83C9,0x83CA,0x83CB,0x83CC,0x83CD,
	0x83CE,0x83CF,0x0000,0x83D0,0x83D1,0x83D2,0x83D3,0x83D4,0x83D5,0x83D6,
};
static const WORD _ucs_to_sjis_0400_data []={ //0401 0451
	       0x8446,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8440,0x8441,0x8442,0x8443,0x8444,0x8445,0x8447,0x8448,0x8449,0x844A,0x844B,0x844C,0x844D,0x844E,0x844F,0x8450,
	0x8451,0x8452,0x8453,0x8454,0x8455,0x8456,0x8457,0x8458,0x8459,0x845A,0x845B,0x845C,0x845D,0x845E,0x845F,0x8460,
	0x8470,0x8471,0x8472,0x8473,0x8474,0x8475,0x8477,0x8478,0x8479,0x847A,0x847B,0x847C,0x847D,0x847E,0x8480,0x8481,
	0x8482,0x8483,0x8484,0x8485,0x8486,0x8487,0x8488,0x8489,0x848A,0x848B,0x848C,0x848D,0x848E,0x848F,0x8490,0x8491,
	0x0000,0x8476,
};
static const WORD _ucs_to_sjis_2000_data []={ //2010 203B
	0x815D,0x0000,0x0000,0x0000,0x0000,0x815C,0x0000,0x0000,0x8165,0x8166,0x0000,0x0000,0x8167,0x8168,0x0000,0x0000,
	0x81F5,0x81F6,0x0000,0x0000,0x0000,0x8164,0x8163,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x81F1,0x0000,0x818C,0x818D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x81A6,
};
static const WORD _ucs_to_sjis_2100_data []={ //2103 21D4
	                     0x818E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8782,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x8784,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x81F0,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8754,0x8755,0x8756,0x8757,0x8758,0x8759,0x875A,0x875B,0x875C,0x875D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xFA40,0xFA41,0xFA42,0xFA43,0xFA44,0xFA45,0xFA46,0xFA47,0xFA48,0xFA49,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x81A9,0x81AA,0x81A8,0x81AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x81CB,0x0000,0x81CC,
};
static const WORD _ucs_to_sjis_2200_data []={ //2200 22BF
	0x81CD,0x0000,0x81DD,0x81CE,0x0000,0x0000,0x0000,0x81DE,0x81B8,0x0000,0x0000,0x81B9,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x8794,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x81E3,0x0000,0x0000,0x81E5,0x8187,0x8798,
	0x81DA,0x0000,0x0000,0x0000,0x0000,0x8161,0x0000,0x81C8,0x81C9,0x81BF,0x81BE,0x81E7,0x81E8,0x0000,0x8793,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8188,0x81E6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x81E4,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x81E0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8182,0x81DF,0x0000,0x0000,0x0000,0x0000,0x8185,0x8186,0x0000,0x0000,0x81E1,0x81E2,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x81BC,0x81BD,0x0000,0x0000,0x81BA,0x81BB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x81DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8799,
};
static const WORD _ucs_to_sjis_2300_data []={ //2312 2312
	              0x81DC,
};
static const WORD _ucs_to_sjis_2400_data []={ //2460 2473
	0x8740,0x8741,0x8742,0x8743,0x8744,0x8745,0x8746,0x8747,0x8748,0x8749,0x874A,0x874B,0x874C,0x874D,0x874E,0x874F,
	0x8750,0x8751,0x8752,0x8753,
};
static const WORD _ucs_to_sjis_2500_data []={ //2500 25EF
	0x849F,0x84AA,0x84A0,0x84AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x84A1,0x0000,0x0000,0x84AC,
	0x84A2,0x0000,0x0000,0x84AD,0x84A4,0x0000,0x0000,0x84AF,0x84A3,0x0000,0x0000,0x84AE,0x84A5,0x84BA,0x0000,0x0000,
	0x84B5,0x0000,0x0000,0x84B0,0x84A7,0x84BC,0x0000,0x0000,0x84B7,0x0000,0x0000,0x84B2,0x84A6,0x0000,0x0000,0x84B6,
	0x84BB,0x0000,0x0000,0x84B1,0x84A8,0x0000,0x0000,0x84B8,0x84BD,0x0000,0x0000,0x84B3,0x84A9,0x0000,0x0000,0x84B9,
	0x0000,0x0000,0x84BE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x84B4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x81A1,0x81A0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x81A3,0x81A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x81A5,0x81A4,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x819F,0x819E,0x0000,0x0000,0x0000,0x819B,0x0000,0x0000,0x819D,0x819C,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x81FC,
};
static const WORD _ucs_to_sjis_2600_data []={ //2605 266F
	                                   0x819A,0x8199,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x818A,0x0000,0x8189,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x81F4,0x0000,0x0000,0x81F3,0x0000,0x81F2,
};
static const WORD _ucs_to_sjis_3000_data []={ //3000 30FE
	0x8140,0x8141,0x8142,0x8156,0x0000,0x8158,0x8159,0x815A,0x8171,0x8172,0x8173,0x8174,0x8175,0x8176,0x8177,0x8178,
	0x8179,0x817A,0x81A7,0x81AC,0x816B,0x816C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8780,0x0000,0x8781,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x829F,0x82A0,0x82A1,0x82A2,0x82A3,0x82A4,0x82A5,0x82A6,0x82A7,0x82A8,0x82A9,0x82AA,0x82AB,0x82AC,0x82AD,
	0x82AE,0x82AF,0x82B0,0x82B1,0x82B2,0x82B3,0x82B4,0x82B5,0x82B6,0x82B7,0x82B8,0x82B9,0x82BA,0x82BB,0x82BC,0x82BD,
	0x82BE,0x82BF,0x82C0,0x82C1,0x82C2,0x82C3,0x82C4,0x82C5,0x82C6,0x82C7,0x82C8,0x82C9,0x82CA,0x82CB,0x82CC,0x82CD,
	0x82CE,0x82CF,0x82D0,0x82D1,0x82D2,0x82D3,0x82D4,0x82D5,0x82D6,0x82D7,0x82D8,0x82D9,0x82DA,0x82DB,0x82DC,0x82DD,
	0x82DE,0x82DF,0x82E0,0x82E1,0x82E2,0x82E3,0x82E4,0x82E5,0x82E6,0x82E7,0x82E8,0x82E9,0x82EA,0x82EB,0x82EC,0x82ED,
	0x82EE,0x82EF,0x82F0,0x82F1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x814A,0x814B,0x8154,0x8155,0x0000,
	0x0000,0x8340,0x8341,0x8342,0x8343,0x8344,0x8345,0x8346,0x8347,0x8348,0x8349,0x834A,0x834B,0x834C,0x834D,0x834E,
	0x834F,0x8350,0x8351,0x8352,0x8353,0x8354,0x8355,0x8356,0x8357,0x8358,0x8359,0x835A,0x835B,0x835C,0x835D,0x835E,
	0x835F,0x8360,0x8361,0x8362,0x8363,0x8364,0x8365,0x8366,0x8367,0x8368,0x8369,0x836A,0x836B,0x836C,0x836D,0x836E,
	0x836F,0x8370,0x8371,0x8372,0x8373,0x8374,0x8375,0x8376,0x8377,0x8378,0x8379,0x837A,0x837B,0x837C,0x837D,0x837E,
	0x8380,0x8381,0x8382,0x8383,0x8384,0x8385,0x8386,0x8387,0x8388,0x8389,0x838A,0x838B,0x838C,0x838D,0x838E,0x838F,
	0x8390,0x8391,0x8392,0x8393,0x8394,0x8395,0x8396,0x0000,0x0000,0x0000,0x0000,0x8145,0x815B,0x8152,0x8153,
};
static const WORD _ucs_to_sjis_3200_data []={ //3231 32A8
	       0x878A,0x878B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x878C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8785,0x8786,0x8787,0x8788,0x8789,
};
static const WORD _ucs_to_sjis_3300_data []={ //3303 33CD
	                     0x8765,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8769,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8760,0x0000,0x0000,0x0000,0x8763,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8761,0x876B,0x0000,0x0000,0x876A,0x8764,0x0000,0x0000,0x0000,0x876C,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8766,0x0000,0x0000,0x0000,0x0000,0x876E,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x875F,0x876D,0x0000,0x0000,0x8762,0x0000,0x0000,
	0x0000,0x8767,0x0000,0x0000,0x0000,0x0000,0x0000,0x8768,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x877E,0x878F,0x878E,0x878D,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8772,0x8773,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x876F,0x8770,0x8771,0x0000,
	0x0000,0x8775,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8774,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8783,
};
static const WORD _ucs_to_sjis_4E00_data []={ //4E00 4EFC
	0x88EA,0x929A,0x0000,0x8EB5,0x0000,0x0000,0x0000,0x969C,0x8FE4,0x8E4F,0x8FE3,0x89BA,0x0000,0x9573,0x975E,0x0000,
	0x98A0,0x894E,0x0000,0x0000,0x8A8E,0x98A1,0x90A2,0x99C0,0x8B75,0x95B8,0x0000,0x0000,0x0000,0x0000,0x8FE5,0x0000,
	0x0000,0x97BC,0x0000,0x0000,0x0000,0x0000,0x95C0,0x0000,0xFA68,0x0000,0x98A2,0x0000,0x0000,0x9286,0x0000,0x0000,
	0x0000,0x98A3,0x8BF8,0x0000,0x0000,0x0000,0x98A4,0x0000,0x8ADB,0x924F,0x0000,0x8EE5,0x98A5,0x0000,0x0000,0x98A6,
	0x0000,0x0000,0x98A7,0x9454,0x0000,0x8B76,0x0000,0x0000,0x0000,0x0000,0x0000,0x9456,0x0000,0x93E1,0x8CC1,0x9652,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE568,0x98A8,0x8FE6,0x98A9,0x89B3,0x0000,0x0000,0x0000,0x8BE3,0x8CEE,0x96E7,
	0x0000,0x0000,0x9BA4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9790,0x0000,0x93FB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8AA3,0x0000,
	0x8B54,0x0000,0x98AA,0x0000,0x0000,0x98AB,0x97B9,0x0000,0x975C,0x9188,0x98AD,0x8E96,0x93F1,0x0000,0x98B0,0x0000,
	0x0000,0x895D,0x8CDD,0x0000,0x8CDC,0x88E4,0x0000,0x0000,0x986A,0x9869,0x0000,0x8DB1,0x889F,0x0000,0x98B1,0x98B2,
	0x98B3,0x9653,0x98B4,0x0000,0x8CF0,0x88E5,0x9692,0x0000,0x8B9C,0x0000,0x0000,0x8B9D,0x8B9E,0x92E0,0x97BA,0x0000,
	0x98B5,0x0000,0x0000,0x98B6,0x0000,0x0000,0x98B7,0x0000,0x0000,0x0000,0x906C,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8F59,0x906D,0x98BC,0x0000,0x98BA,0x0000,0x98BB,0x8B77,0x0000,0x0000,0x8DA1,0x89EE,0x0000,0x98B9,0x98B8,0x95A7,
	0x0000,0x0000,0x0000,0x0000,0x8E65,0x8E64,0x91BC,0x98BD,0x9574,0x90E5,0x0000,0x0000,0x0000,0x8157,0x98BE,0x98C0,
	0x0000,0xFA69,0x0000,0x91E3,0x97DF,0x88C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x98BF,0x89BC,0x0000,
	0x8BC2,0x0000,0x9287,0x0000,0x0000,0x0000,0x8C8F,0x98C1,0x0000,0x0000,0x0000,0x9443,0xFA6A,
};
static const WORD _ucs_to_sjis_4F00_data []={ //4F00 4FFF
	0xFA6B,0x8AE9,0x0000,0xFA6C,0x0000,0x0000,0x0000,0x0000,0x0000,0x98C2,0x88C9,0x0000,0x0000,0x8CDE,0x8AEA,0x959A,
	0x94B0,0x8B78,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89EF,0x0000,0x98E5,0x9360,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x948C,
	0x98C4,0x0000,0x0000,0x0000,0x94BA,0x0000,0x97E0,0x0000,0x904C,0xFA6D,0x8E66,0x0000,0x8E97,0x89BE,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x92CF,0x0000,0x0000,0x9241,0x98C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x88CA,0x92E1,0x8F5A,
	0x8DB2,0x9743,0x0000,0x91CC,0x0000,0x89BD,0xFA6E,0x98C7,0x0000,0x975D,0x98C3,0x98C5,0x8DEC,0x98C6,0x9B43,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x98CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x98D1,
	0x98CF,0x0000,0x0000,0x89C0,0x0000,0x95B9,0x98C9,0x0000,0x0000,0x0000,0x0000,0x98CD,0x8CF1,0x0000,0x0000,0x8E67,
	0x0000,0x0000,0x0000,0x8AA4,0x0000,0x0000,0x98D2,0x0000,0x98CA,0x0000,0xFA70,0x97E1,0x0000,0x8E98,0x0000,0x98CB,
	0x0000,0x98D0,0xFA6F,0x0000,0xFA72,0x0000,0x98D3,0x0000,0x98CC,0x0000,0xFA71,0x8B9F,0x0000,0x88CB,0x0000,0x0000,
	0x8BA0,0x89BF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B44,0x0000,0x9699,0x958E,0x8CF2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x904E,0x97B5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x95D6,
	0x0000,0x0000,0x8C57,0x91A3,0x89E2,0x0000,0x0000,0x0000,0x0000,0xFA61,0x8F72,0x0000,0x0000,0xFA73,0x98D7,0x0000,
	0x98DC,0x98DA,0x0000,0x0000,0x98D5,0x0000,0x0000,0x91AD,0x98D8,0x0000,0x98DB,0x98D9,0x0000,0x95DB,0x0000,0x98D6,
	0x0000,0x904D,0x0000,0x9693,0x98DD,0x98DE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8F43,0x98EB,
	0x0000,0x0000,0x0000,0x946F,0x0000,0x9555,0x98E6,0x0000,0x95EE,0x0000,0x89B4,0x0000,0x0000,0x0000,0x98EA,0xFA76,
};
static const WORD _ucs_to_sjis_5000_data []={ //5005 50FB
	                                   0x98E4,0x98ED,0x0000,0x0000,0x9171,0x0000,0x8CC2,0x0000,0x947B,0x0000,0xE0C5,
	0x0000,0x98EC,0x937C,0x0000,0x98E1,0x0000,0x8CF4,0x0000,0x0000,0x8CF3,0x98DF,0x0000,0x0000,0x0000,0xFA77,0x8ED8,
	0x0000,0x98E7,0xFA75,0x95ED,0x926C,0x98E3,0x8C91,0x0000,0x98E0,0x98E8,0x98E2,0x97CF,0x98E9,0x9860,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8BE4,0x0000,0x0000,0x8C90,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xFA74,0x0000,0xFA7A,0x98EE,0x0000,0x0000,0xFA78,0x98EF,0x98F3,0x88CC,0x0000,0x0000,0x0000,0x0000,0x0000,0x95CE,
	0x98F2,0x0000,0x0000,0x0000,0x0000,0x98F1,0x98F5,0x0000,0x0000,0x0000,0x98F4,0x0000,0x92E2,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x8C92,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x98F6,0x0000,0x0000,0x0000,
	0xFA79,0x0000,0x8EC3,0x0000,0x91A4,0x92E3,0x8BF4,0x0000,0x98F7,0x0000,0x0000,0x0000,0x0000,0x8B55,0x0000,0x0000,
	0x98F8,0x0000,0x0000,0x0000,0x0000,0x98FA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9654,0x0000,0x0000,
	0x0000,0x8C86,0x0000,0x0000,0xFA7B,0x0000,0x0000,0x0000,0x8E50,0x94F5,0x98F9,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8DC3,0x9762,0x0000,0x0000,
	0x0000,0x0000,0x98FC,0x9942,0x98FB,0x8DC2,0x0000,0x8F9D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C58,0x0000,
	0x0000,0x0000,0x9943,0x0000,0x0000,0x8BCD,0x0000,0x0000,0x0000,0x9940,0x9941,0x0000,0x0000,0x93AD,0x0000,0x919C,
	0x0000,0x8BA1,0x0000,0x0000,0x0000,0x966C,0x9944,0x0000,0xFA7D,0x0000,0x97BB,0x0000,0x0000,0x0000,0x9945,0x0000,
	0x0000,0x0000,0x0000,0x9948,0x0000,0x9946,0x0000,0x916D,0x0000,0x0000,0x0000,0x0000,0x0000,0x9947,0x9949,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xFA7C,0x994B,0x0000,0x0000,0x0000,0x994A,0x0000,0x95C6,
};
static const WORD _ucs_to_sjis_5100_data []={ //5100 51FE
	0x8B56,0x994D,0x994E,0x0000,0x89AD,0x0000,0x0000,0x0000,0x0000,0x994C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8EF2,0x0000,0x9951,0x9950,0x994F,0x0000,0x98D4,0x0000,0x9952,0x0000,0x0000,0x0000,0x0000,0x8F9E,
	0x0000,0x9953,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9744,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x96D7,0x0000,0x0000,0x0000,0x0000,0x9955,0x0000,0x0000,0x9954,0x9957,0x9956,0x0000,0x0000,0x9958,
	0x9959,0x88F2,0x0000,0x8CB3,0x8C5A,0x8F5B,0x929B,0x8BA2,0x90E6,0x8CF5,0xFA7E,0x8D8E,0x995B,0x96C6,0x9365,0x0000,
	0x8E99,0x0000,0x995A,0x0000,0x995C,0x0000,0x0000,0x0000,0x0000,0x0000,0x937D,0x0000,0x8A95,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x995D,0x0000,0xFA80,0x93FC,0x0000,0x0000,0x9153,0x995F,0x9960,0x94AA,0x8CF6,0x985A,0x9961,0x0000,
	0x0000,0x8BA4,0x0000,0x0000,0x0000,0x95BA,0x91B4,0x8BEF,0x9354,0x0000,0x0000,0x0000,0x8C93,0x0000,0x0000,0x0000,
	0x9962,0x0000,0x9963,0x0000,0x0000,0x93E0,0x897E,0x0000,0x0000,0x9966,0x8DFB,0x0000,0x9965,0x8DC4,0x0000,0x9967,
	0xE3EC,0x9968,0x9660,0x9969,0x0000,0x996A,0x996B,0x8FE7,0x0000,0x8ECA,0x0000,0x0000,0x0000,0xFA81,0x0000,0x0000,
	0x8AA5,0x0000,0x996E,0x0000,0x996C,0x96BB,0x996D,0x0000,0x9579,0x996F,0x9970,0x9971,0x937E,0x0000,0x0000,0x0000,
	0x9975,0x9973,0x9974,0x9972,0x8DE1,0x9976,0x96E8,0x97E2,0x0000,0x0000,0x0000,0x0000,0x0000,0x9977,0xFA82,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x90A6,0x9978,0x8F79,0x0000,0x0000,0x9979,0x0000,0x929C,0x97BD,0x9380,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x99C3,0x0000,0x0000,0x0000,0x0000,0x997A,0xEAA3,0x8BC3,0x0000,0x0000,
	0x997B,0x967D,0x0000,0x0000,0x0000,0x0000,0x8F88,0x91FA,0x0000,0x997D,0x93E2,0x0000,0xFA83,0x997E,0x0000,0x0000,
	0x9980,0x8A4D,0x0000,0x0000,0x0000,0x9981,0x8BA5,0x0000,0x93CA,0x899A,0x8F6F,0x0000,0x0000,0x949F,0x9982,
};
static const WORD _ucs_to_sjis_5200_data []={ //5200 52FF
	0x9381,0x0000,0x0000,0x906E,0x9983,0x0000,0x95AA,0x90D8,0x8AA0,0x0000,0x8AA7,0x9984,0x0000,0x0000,0x9986,0x0000,
	0x0000,0x8C59,0x0000,0x0000,0x9985,0xFA84,0x0000,0x97F1,0x0000,0x0000,0x0000,0x0000,0x0000,0x8F89,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x94BB,0x95CA,0x0000,0x9987,0x0000,0x9798,0x9988,0x0000,0x0000,0x0000,0x9989,0x0000,
	0x939E,0x0000,0x0000,0x998A,0x0000,0x0000,0x90A7,0x8DFC,0x8C94,0x998B,0x8E68,0x8D8F,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x92E4,0x998D,0x0000,0x0000,0x91A5,0x0000,0x0000,0x8DED,0x998E,0x998F,0x914F,0x0000,0x998C,
	0x0000,0x0000,0x0000,0x0000,0x9991,0x0000,0x9655,0x0000,0x0000,0x0000,0x0000,0x8D84,0x0000,0x0000,0x9990,0x0000,
	0x0000,0x0000,0x0000,0x8C95,0x8DDC,0x948D,0x0000,0x0000,0x0000,0x9994,0x9992,0x0000,0x0000,0x0000,0x0000,0x959B,
	0x8FE8,0x999B,0x8A84,0x9995,0x9993,0x916E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9997,0x0000,0x9996,
	0x0000,0x0000,0x0000,0x8A63,0x0000,0x0000,0x0000,0x8C80,0x999C,0x97AB,0x0000,0x0000,0x0000,0x9998,0x0000,0x0000,
	0x0000,0x999D,0x999A,0x0000,0x9999,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x97CD,0xFA85,0x0000,0x0000,0x8CF7,
	0x89C1,0x0000,0x0000,0x97F2,0x0000,0x0000,0xFA86,0x0000,0x0000,0x8F95,0x9377,0x8D85,0x99A0,0x99A1,0x0000,0xFB77,
	0x0000,0x97E3,0x0000,0x0000,0x984A,0x99A3,0x0000,0x0000,0x0000,0x8CF8,0x0000,0x0000,0x99A2,0x0000,0x8A4E,0x0000,
	0xFA87,0x99A4,0x0000,0x9675,0x0000,0x92BA,0x0000,0x9745,0x0000,0x95D7,0x0000,0x0000,0x0000,0x99A5,0x0000,0x0000,
	0x0000,0x0000,0xE8D3,0x0000,0x0000,0x93AE,0x0000,0x99A6,0x8AA8,0x96B1,0x0000,0xFA88,0x0000,0x8F9F,0x99A7,0x95E5,
	0x99AB,0x0000,0x90A8,0x99A8,0x8BCE,0x0000,0x99A9,0x8AA9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8C4D,0x99AC,0x0000,0x99AD,0x0000,0x0000,0x99AE,0x99AF,0x8ED9,0x0000,0x0000,0x0000,0x8CF9,0x96DC,
};
static const WORD _ucs_to_sjis_5300_data []={ //5300 53FA
	0xFA89,0x96E6,0x93F5,0x0000,0x0000,0x95EF,0x99B0,0xFA8A,0x99B1,0x0000,0x0000,0x0000,0x0000,0x99B3,0x0000,0x99B5,
	0x99B4,0x0000,0x0000,0x0000,0x0000,0x99B6,0x89BB,0x966B,0x0000,0x8DFA,0x99B7,0x0000,0x0000,0x9178,0x0000,0x0000,
	0x8FA0,0x8BA7,0x0000,0x99B8,0xFA8B,0x0000,0x0000,0x0000,0x0000,0x0000,0x94D9,0x0000,0x0000,0x0000,0x0000,0x99B9,
	0x0000,0x99BA,0x0000,0x99BB,0x0000,0x0000,0x0000,0x0000,0x99BC,0x9543,0x8BE6,0x88E3,0x0000,0x0000,0x0000,0x93BD,
	0x99BD,0x8F5C,0x0000,0x90E7,0x0000,0x99BF,0x99BE,0x8FA1,0x8CDF,0x99C1,0x94BC,0x0000,0x0000,0x99C2,0x0000,0x0000,
	0x0000,0x94DA,0x91B2,0x91EC,0x8BA6,0x0000,0x0000,0x93EC,0x9250,0x0000,0x948E,0x0000,0x966D,0x0000,0x99C4,0x0000,
	0x90E8,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C54,0x0000,0x0000,0x99C5,0x0000,0x0000,0x0000,0x0000,0x99C6,0x894B,
	0x88F3,0x8AEB,0xFA8C,0x91A6,0x8B70,0x9791,0x0000,0x99C9,0x89B5,0x0000,0x0000,0x99C8,0x0000,0x0000,0x0000,0x8BA8,
	0x0000,0x0000,0x99CA,0x0000,0x96EF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xFA8D,0x0000,0x0000,0x99CB,0x0000,0x97D0,0x0000,0x8CFA,0x0000,0x0000,0x0000,0x0000,0x8CB4,
	0x99CC,0x0000,0x0000,0x0000,0x0000,0x99CE,0x99CD,0x0000,0x907E,0x8958,0x0000,0x0000,0x0000,0x897D,0x99CF,0x0000,
	0x99D0,0x0000,0xFA8E,0x8CB5,0x0000,0x0000,0x99D1,0x0000,0x0000,0x0000,0x0000,0x8B8E,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8E51,0x99D2,0x0000,0x0000,0x0000,0x0000,0x9694,0x8DB3,0x8B79,0x9746,0x916F,0x94BD,0x8EFB,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8F66,0x0000,0x8EE6,0x8EF3,0x0000,0x8F96,0x0000,0x94BE,0x0000,0xFA8F,0x0000,0x99D5,
	0x0000,0x8962,0x9170,0x8CFB,0x8CC3,0x8BE5,0x0000,0x0000,0x99D9,0x9240,0x91FC,0x8BA9,0x8FA2,0x99DA,0x99D8,0x89C2,
	0x91E4,0x8EB6,0x8E6A,0x8945,0x0000,0x0000,0x8A90,0x8D86,0x8E69,0x0000,0x99DB,
};
static const WORD _ucs_to_sjis_5400_data []={ //5401 54FF
	       0x99DC,0x0000,0x8B68,0x8A65,0x0000,0x0000,0x0000,0x8D87,0x8B67,0x92DD,0x8944,0x93AF,0x96BC,0x8D40,0x9799,
	0x9366,0x8CFC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C4E,0x0000,0x99E5,0x0000,0x8BE1,
	0x9669,0x0000,0x0000,0x0000,0x0000,0x0000,0x94DB,0x0000,0x0000,0x99E4,0x0000,0x8ADC,0x99DF,0x99E0,0x99E2,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x99E3,0x0000,0x8B7A,0x9081,0x0000,0x95AB,0x99E1,0x99DD,0x8CE1,0x0000,
	0x99DE,0x0000,0x9843,0x0000,0x0000,0x0000,0x95F0,0x0000,0x92E6,0x8CE0,0x8D90,0x0000,0x0000,0x0000,0x99E6,0x0000,
	0x0000,0x93DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x99EA,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8EFC,0x0000,0x8EF4,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x99ED,0x99EB,0x0000,0x96A1,0x0000,0x99E8,0x99F1,0x99EC,0x0000,0x0000,0x0000,0x99EF,0x8CC4,0x96BD,0x0000,0x0000,
	0x99F0,0x0000,0x0000,0x0000,0x99F2,0x0000,0x99F4,0x0000,0x0000,0x0000,0xFA92,0x8DEE,0x9861,0x0000,0x99E9,0x99E7,
	0x99F3,0x0000,0x99EE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFA91,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x99F6,0x0000,0x9A42,0x99F8,0x0000,0x0000,0x99FC,0xFA93,0x0000,0x9A40,0x99F9,0x0000,0x0000,0x9A5D,
	0x0000,0x0000,0x8DE7,0x8A50,0x0000,0x0000,0x0000,0x0000,0x99F7,0x0000,0x0000,0x0000,0x9A44,0x88F4,0x9A43,0x0000,
	0x88A3,0x9569,0x9A41,0x0000,0x99FA,0x0000,0x0000,0x99F5,0x99FB,0x8DC6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A45,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x88F5,0x9A4E,0x0000,0x0000,0x9A46,0x9A47,0x0000,0x8FA3,0x9689,0x0000,0x0000,0x0000,0x9A4C,0x9A4B,0x0000,
	0x0000,0x0000,0x934E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A4D,0x0000,0x0000,0x9A4A,0x0000,0xFA94,
};
static const WORD _ucs_to_sjis_5500_data []={ //5504 55FE
	                            0x8953,0x0000,0x8DB4,0x904F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A48,
	0x9382,0x0000,0x0000,0x0000,0x9A49,0x0000,0x88A0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A53,0x9742,
	0x0000,0x8FA5,0x0000,0x9A59,0x0000,0x0000,0x0000,0x0000,0x9A58,0x9A4F,0x0000,0x0000,0x0000,0x0000,0x91C1,0x0000,
	0x9A50,0x0000,0x0000,0x0000,0x91ED,0x9A55,0x8FA4,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A52,0x0000,0x0000,0x96E2,
	0x0000,0x0000,0x0000,0x8C5B,0x0000,0x0000,0x9A56,0x9A57,0x0000,0x0000,0x0000,0x0000,0x9A54,0x9A5A,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9A51,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A60,0x9A65,0x0000,0x9A61,0x0000,
	0x9A5C,0x0000,0x0000,0x9A66,0x9150,0x0000,0xFA95,0x9A68,0x0000,0x8D41,0x9A5E,0x929D,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A62,0x9A5B,0x8AAB,0x0000,0x8AEC,0x8A85,0x9A63,0x9A5F,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C96,0x9A69,0x9A67,0x9172,0x8B69,0x8BAA,0x0000,0x9A64,0x0000,
	0x8BF2,0x0000,0x0000,0x0000,0x0000,0x0000,0x8963,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9A6D,0x9A6B,0x0000,0x9AA5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9A70,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A6A,0x0000,0x9A6E,0x0000,0x0000,0x9A6C,
	0x0000,0x0000,0x0000,0x8E6B,0x9A6F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A72,0x0000,0x9A77,0x0000,0x0000,0x0000,0x9A75,0x9A74,
};
static const WORD _ucs_to_sjis_5600_data []={ //5606 56FF
	                                          0x9251,0x0000,0x0000,0x89C3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9A71,0x0000,0x9A73,0x8FA6,0x8952,0x0000,0x0000,0x9A76,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89DC,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A82,
	0x0000,0x8FFA,0x9A7D,0x0000,0x9A7B,0x0000,0x9A7C,0x0000,0x9A7E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x895C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9158,0x0000,0x9A78,0x0000,
	0x9A79,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8A9A,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9A81,0x0000,0x0000,0x0000,0x8AED,0x0000,0x9A84,0x9A80,0x9A83,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x95AC,0x0000,0x0000,0x0000,0x93D3,0x0000,0x94B6,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9A86,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A85,0x8A64,0x0000,0x0000,0x9A87,0x0000,0x0000,0x0000,0x0000,0x9A8A,
	0x0000,0x0000,0x0000,0x0000,0x9A89,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9A88,0x0000,0x9458,0x0000,0x0000,0x9A8B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A8C,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9A8E,0x0000,0x9A8D,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A90,0x0000,0x0000,0x0000,
	0x9A93,0x9A91,0x9A8F,0x9A92,0x0000,0x0000,0x0000,0x0000,0x9A94,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A95,0x0000,
	0x0000,0x9A96,0x0000,0x9A97,0x0000,0x0000,0x0000,0x9A98,0x9964,0x0000,0x8EFA,0x8E6C,0x0000,0x0000,0x89F1,0x0000,
	0x88F6,0x0000,0x0000,0x9263,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A99,0x0000,
	0x8DA2,0x0000,0x88CD,0x907D,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A9A,0x8CC5,0x0000,0x0000,0x8D91,0x0000,0x9A9C,
};
static const WORD _ucs_to_sjis_5700_data []={ //5700 57FC
	0x9A9B,0x0000,0x0000,0x95DE,0x9A9D,0x0000,0x0000,0x0000,0x9A9F,0x9A9E,0x0000,0x9AA0,0x0000,0x9AA1,0x0000,0x8C97,
	0x0000,0x0000,0x8980,0x9AA2,0x0000,0x0000,0x9AA4,0x0000,0x9AA3,0x0000,0x0000,0x0000,0x9AA6,0x0000,0x0000,0x9379,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9AA7,0x88B3,0x8DDD,0x0000,0x0000,0x0000,0x0000,0x8C5C,0x0000,0x0000,
	0x926E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9AA8,0x9AA9,0x0000,0x0000,0x9AAB,0x0000,0x0000,0x0000,0x0000,
	0x9AAC,0x0000,0x8DE2,0x0000,0x0000,0x0000,0x0000,0x8BCF,0x0000,0x0000,0x9656,0x0000,0x0000,0x0000,0x9AAA,0x9AAD,
	0x8DBF,0x8D42,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFA96,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9AB1,0x0000,0x0000,0x8DA3,0xFA97,0x9252,0x0000,0x0000,0x9AAE,0x92D8,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9AB2,
	0x0000,0x0000,0x9082,0x0000,0x0000,0x0000,0x0000,0x0000,0x9AB0,0x9AB3,0x0000,0x8C5E,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9AB4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9AB5,0x0000,0x8D43,0x8A5F,0x9AB7,0x0000,0x0000,0x0000,0x0000,0x0000,0x9AB8,0x0000,0xFA98,0x0000,0x0000,0x0000,
	0x9AB9,0x0000,0x0000,0x9AB6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9AAF,0x0000,0x0000,0x9ABA,0x0000,0x0000,0x9ABB,0xFA9A,0xFA99,0x0000,0x0000,0x9684,0x0000,0x0000,0x8FE9,0x0000,
	0x0000,0x0000,0x9ABD,0x9ABE,0x9ABC,0x0000,0x9AC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x9457,0x0000,0x0000,0x88E6,
	0x9575,0x0000,0x0000,0x9AC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8FFB,0x0000,0x0000,0x8EB7,0x0000,0x947C,0x8AEE,0x0000,0x8DE9,
};
static const WORD _ucs_to_sjis_5800_data []={ //5800 58FD
	0x9678,0x0000,0x93B0,0x0000,0x0000,0x8C98,0x91CD,0x0000,0x0000,0x0000,0x9ABF,0x9AC2,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x91C2,0x0000,0x0000,0x0000,0x9AC3,0x0000,0x0000,0x0000,0x9AC4,0x0000,0x0000,
	0x0000,0x9AC6,0x0000,0x0000,0x92E7,0x0000,0x0000,0x0000,0x0000,0x0000,0x8AAC,0x0000,0x0000,0x0000,0x0000,0xEA9F,
	0x8981,0x95F1,0x0000,0x0000,0x8FEA,0x9367,0x0000,0x0000,0x0000,0x0000,0x8DE4,0x0000,0x0000,0x9ACC,0x0000,0x0000,
	0x95BB,0x97DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89F2,0x9AC8,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9159,0x9ACB,0x0000,0x9383,0x0000,0x0000,0x9368,0x9384,0x94B7,0x92CB,0x0000,0x0000,0x0000,0x8DC7,0x0000,
	0x0000,0x0000,0x9AC7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8996,0x0000,0x9355,0x0000,0x0000,0x0000,0x0000,
	0x9AC9,0x0000,0x9AC5,0x0000,0x0000,0x906F,0x0000,0x0000,0x0000,0x9ACD,0x0000,0x0000,0x0000,0x0000,0x8F6D,0x0000,
	0x0000,0x0000,0x0000,0x8BAB,0x0000,0x9ACE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x95E6,0x0000,0x0000,0x0000,0x919D,0x0000,0x0000,0x0000,0x0000,0x92C4,0x0000,0xFA9D,0x9AD0,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x966E,0x0000,0x0000,0x9AD1,0x0000,0x0000,0x9AD6,0x0000,
	0x0000,0x0000,0xFA9E,0x95AD,0x0000,0x0000,0x0000,0x0000,0x9AD5,0x9ACF,0x9AD2,0x9AD4,0x0000,0x0000,0x8DA4,0x0000,
	0x0000,0x95C7,0x0000,0x0000,0x0000,0x9AD7,0x0000,0x9264,0x0000,0x0000,0x89F3,0x0000,0x8FEB,0x0000,0x0000,0x0000,
	0x0000,0x9AD9,0x0000,0x9AD8,0x0000,0x8D88,0x0000,0x9ADA,0x9ADC,0x9ADB,0x0000,0x0000,0x9ADE,0x0000,0x9AD3,0x9AE0,
	0x0000,0x0000,0x0000,0x0000,0x9ADF,0x9ADD,0x0000,0x0000,0x0000,0x0000,0x0000,0x8E6D,0x9070,0x0000,0x9173,0x9AE1,
	0x90BA,0x88EB,0x9484,0x0000,0x0000,0x0000,0x0000,0x92D9,0x0000,0x9AE3,0x9AE2,0x9AE4,0x9AE5,0x9AE6,
};
static const WORD _ucs_to_sjis_5900_data []={ //5902 59FF
	              0x9AE7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x95CF,0x9AE8,0xFA9F,0x0000,0x0000,0x0000,0x89C4,
	0x9AE9,0x0000,0x0000,0x0000,0x0000,0x975B,0x8A4F,0x0000,0x99C7,0x8F67,0x91BD,0x9AEA,0x96E9,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x96B2,0x0000,0x0000,0x9AEC,0x0000,0x91E5,0x0000,0x9356,0x91BE,0x9576,0x9AED,0x9AEE,0x899B,0x0000,
	0x0000,0x8EB8,0x9AEF,0x0000,0x0000,0x0000,0x0000,0x88CE,0x9AF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x9AF1,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8982,0x0000,0x0000,0x8AEF,0x93DE,0x95F2,0x0000,0x0000,0x0000,0x0000,0x9AF5,0x9174,
	0x9AF4,0x8C5F,0x0000,0xFAA0,0x967A,0x9AF3,0x0000,0x9385,0x9AF7,0x0000,0x9AF6,0xFAA1,0x0000,0xFAA2,0x0000,0x0000,
	0x9AF9,0x0000,0x9AF8,0xFAA3,0x0000,0x899C,0x0000,0x9AFA,0x8FA7,0x9AFC,0x9244,0x0000,0x9AFB,0x0000,0x95B1,0x0000,
	0x0000,0x0000,0x0000,0x8F97,0x937A,0x0000,0x0000,0x0000,0x9B40,0x0000,0x0000,0x0000,0x0000,0x8D44,0x0000,0x0000,
	0x0000,0x9B41,0x9440,0x94DC,0x96CF,0x0000,0x0000,0x0000,0x0000,0x0000,0x9444,0x0000,0x0000,0x9B4A,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x8B57,0x0000,0x0000,0x9764,0x0000,0x0000,0x96AD,0x0000,0x9BAA,0x0000,0x9B42,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9B45,0xFAA4,0x91C3,0x0000,0x0000,0x9657,0x0000,0x0000,0x0000,0x9369,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9B46,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9685,0xFAA5,0x8DC8,0x0000,0x0000,0x8FA8,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B47,0x0000,0x0000,0x8E6F,0x0000,0x8E6E,0x0000,0x0000,0x0000,0x0000,
	0x88B7,0x8CC6,0x0000,0x90A9,0x88CF,0x0000,0x0000,0x0000,0x0000,0x9B4B,0x9B4C,0x0000,0x9B49,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x8957,0x8AAD,0x0000,0x9B48,0x0000,0x96C3,0x9550,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x88A6,0x0000,0x0000,0x0000,0x0000,0x88F7,0x0000,0x0000,0x0000,0x8E70,
};
static const WORD _ucs_to_sjis_5A00_data []={ //5A01 5AFB
	       0x88D0,0x0000,0x88A1,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B51,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9B4F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x96BA,0x0000,0x9B52,0x0000,0x9B50,0x0000,0x0000,0x9B4E,
	0x9050,0x0000,0x0000,0x0000,0x0000,0x9B4D,0x0000,0x0000,0x0000,0x95D8,0x0000,0x0000,0x0000,0x0000,0x0000,0x8CE2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x9B56,0x9B57,0x0000,0x0000,0x0000,0x0000,0x0000,0x8FA9,0x0000,0x0000,0x0000,
	0x9B53,0x984B,0x0000,0x0000,0x0000,0x0000,0x946B,0x0000,0x0000,0x9B55,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8DA5,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9B58,0x0000,0x0000,0x0000,0x9577,0x0000,0x0000,0x0000,0x9B59,0x0000,0x9B54,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x96B9,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x947D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B5A,0x9551,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B5B,0x9B5F,0x9B5C,0x0000,
	0x0000,0x89C5,0x9B5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8EB9,0x0000,0x9B5D,0x8C99,0x0000,0x0000,0x0000,
	0x9B6B,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B64,0x9B61,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9284,0x0000,0x9B60,0x0000,0x0000,0x9B62,0x0000,0x0000,0x9B63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B65,0x9B66,
};
static const WORD _ucs_to_sjis_5B00_data []={ //5B09 5BFF
	                                                               0x8AF0,0x0000,0x9B68,0x9B67,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B69,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8FEC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B6C,0x0000,0x92DA,0x0000,0x0000,0x0000,
	0x8964,0x0000,0x9B6A,0x0000,0x0000,0x0000,0x9B6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B6E,0x0000,
	0x9B71,0x0000,0x0000,0x9B6F,0x0000,0x9B70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8E71,0x9B72,0x0000,0x0000,0x8D45,0x9B73,0xFAA6,0x8E9A,0x91B6,0x0000,0x9B74,0x9B75,0x8E79,0x8D46,0x0000,0x96D0,
	0x0000,0x0000,0x0000,0x8B47,0x8CC7,0x9B76,0x8A77,0x0000,0x0000,0x9B77,0x0000,0x91B7,0x0000,0x0000,0x0000,0x0000,
	0x9B78,0x9BA1,0x0000,0x9B79,0x0000,0x9B7A,0x0000,0x0000,0x9B7B,0x0000,0x9B7D,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9B7E,0x0000,0x0000,0x9B80,0x0000,0x91EE,0x0000,0x8946,0x8EE7,0x88C0,0x0000,0x9176,0x8AAE,0x8EB3,0x0000,0x8D47,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x9386,0x0000,0x8F40,0x8AAF,0x9288,0x92E8,0x88B6,0x8B58,0x95F3,0x0000,0x8EC0,
	0x0000,0x0000,0x8B71,0x90E9,0x8EBA,0x9747,0x9B81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B7B,0x0000,
	0x8DC9,0x0000,0x0000,0x8A51,0x8983,0x8FAA,0x89C6,0x0000,0x9B82,0x9765,0x0000,0x0000,0x0000,0x0000,0x0000,0x8F68,
	0xFAA7,0x0000,0x8EE2,0x9B83,0x8AF1,0x93D0,0x96A7,0x9B84,0x0000,0x9B85,0x0000,0x0000,0x9578,0x0000,0x0000,0x0000,
	0x9B87,0x0000,0x8AA6,0x8BF5,0x9B86,0x0000,0x0000,0x0000,0xFAA9,0x0000,0x0000,0x8AB0,0x0000,0x9051,0x9B8B,0x8E40,
	0x0000,0x89C7,0x9B8A,0x0000,0x9B88,0x9B8C,0x9B89,0x944A,0x9ECB,0x9052,0x0000,0x9B8D,0xFAAA,0x0000,0x97BE,0x0000,
	0x9B8E,0x0000,0x0000,0x9B90,0x0000,0x929E,0x9B8F,0x0000,0x90A1,0x0000,0x8E9B,0x0000,0x0000,0x0000,0x91CE,0x8EF5,
};
static const WORD _ucs_to_sjis_5C00_data []={ //5C01 5CFD
	       0x9595,0x90EA,0x0000,0x8ECB,0x9B91,0x8FAB,0x9B92,0x9B93,0x88D1,0x91B8,0x9071,0x0000,0x9B94,0x93B1,0x8FAC,
	0x0000,0x8FAD,0x0000,0x9B95,0x0000,0x0000,0x90EB,0x0000,0x0000,0x0000,0x8FAE,0x0000,0x0000,0x0000,0xFAAB,0x0000,
	0x9B96,0x0000,0x9B97,0x0000,0x96DE,0x0000,0x0000,0x0000,0x9B98,0x0000,0x0000,0x0000,0x0000,0x8BC4,0x0000,0x0000,
	0x0000,0x8F41,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9B99,0x9B9A,0x8EDA,0x904B,0x93F2,0x9073,0x94F6,0x9441,
	0x8BC7,0x9B9B,0x0000,0x0000,0x0000,0x8B8F,0x9B9C,0x0000,0x8BFC,0x0000,0x93CD,0x89AE,0x0000,0x8E72,0x9B9D,0x9BA0,
	0x9B9F,0x8BFB,0x0000,0x9B9E,0x0000,0x9357,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x91AE,0x0000,
	0x936A,0x8EC6,0x0000,0x0000,0x9177,0x979A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BA2,0x0000,0x9BA3,0x93D4,
	0x0000,0x8E52,0x0000,0x0000,0x0000,0x0000,0x9BA5,0x0000,0x0000,0x9BA6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BA7,0x0000,0x0000,0x0000,
	0x8AF2,0x9BA8,0x0000,0x0000,0x9BA9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x89AA,0x0000,0x0000,0x0000,0x0000,0xFAAC,0x0000,0x915A,0x8AE2,0x0000,0x9BAB,0x96A6,0x0000,0x0000,0x0000,
	0x0000,0x91D0,0x0000,0x8A78,0x0000,0x0000,0x9BAD,0x9BAF,0x8ADD,0x0000,0xFAAD,0x9BAC,0x9BAE,0x0000,0x9BB1,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x9BB0,0x0000,0x9BB2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BB3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x93BB,0x8BAC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89E3,0x9BB4,0x9BB9,0x0000,0x0000,0x9BB7,0x0000,0x95F5,
	0x95F4,0x0000,0x0000,0x0000,0x0000,0xFAAE,0x9387,0x0000,0x0000,0x0000,0x9BB6,0x8F73,0x0000,0x9BB5,
};
static const WORD _ucs_to_sjis_5D00_data []={ //5D07 5DFE
	                                                 0x9092,0x0000,0x0000,0x0000,0x9BBA,0x0000,0x0000,0x8DE8,0x0000,
	0x0000,0x9BC0,0x0000,0x0000,0x9BC1,0x9BBB,0x8A52,0x9BBC,0x9BC5,0x9BC4,0x9BC3,0x9BBF,0x0000,0x0000,0x0000,0x9BBE,
	0x0000,0x0000,0x9BC2,0x0000,0x0000,0x0000,0x0000,0xFAAF,0x0000,0x95F6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xFAB2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BC9,0x9BC6,0x0000,0x9BC8,0x0000,
	0x9792,0x0000,0x9BC7,0xFAB0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BBD,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9093,0x0000,0x0000,0x9BCA,0xFAB3,0x0000,0x8DB5,
	0x0000,0x0000,0x0000,0x9BCB,0x0000,0x0000,0x9BCC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9BCF,0x0000,0x9BCE,0x0000,0x0000,0x9BCD,0x0000,0x0000,0x0000,0x9388,0x9BB8,0x0000,0x0000,0x0000,
	0x9BD5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BD1,0x0000,0x0000,
	0x0000,0x0000,0x9BD0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BD2,0x0000,0x9BD3,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BD6,0xFAB4,0xFAB5,0x97E4,0x0000,0x9BD7,0x9BD4,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BD8,0x0000,0x0000,0x8ADE,0x9BD9,0x0000,0x0000,
	0xFAB6,0x0000,0x9BDB,0x9BDA,0x0000,0x0000,0x9BDC,0x0000,0x0000,0x0000,0x0000,0x9BDD,0x0000,0x90EC,0x8F42,0x0000,
	0x0000,0x8F84,0x0000,0x9183,0x0000,0x8D48,0x8DB6,0x8D49,0x8B90,0x0000,0x0000,0x9BDE,0x0000,0x0000,0x8DB7,0x0000,
	0x0000,0x8CC8,0x9BDF,0x96A4,0x9462,0x9BE0,0x0000,0x8D4A,0x0000,0x0000,0x0000,0x8AAA,0x0000,0x9246,0x8BD0,
};
static const WORD _ucs_to_sjis_5E00_data []={ //5E02 5EFF
	              0x8E73,0x957A,0x0000,0x0000,0x94BF,0x0000,0x0000,0x0000,0x0000,0x9BE1,0x8AF3,0x0000,0x0000,0x0000,
	0x0000,0x9BE4,0x0000,0x0000,0x0000,0x0000,0x929F,0x0000,0x0000,0x9BE3,0x9BE2,0x9BE5,0x0000,0x92E9,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x9083,0x0000,0x0000,0x0000,0x0000,0x0000,0x8E74,0x0000,0x90C8,0x0000,0x91D1,
	0x8B41,0x0000,0x0000,0x92A0,0x0000,0x0000,0x9BE6,0x9BE7,0x8FED,0x0000,0x0000,0x0000,0x0000,0x9658,0x0000,0x0000,
	0x9BEA,0x0000,0x0000,0x9BE9,0x9BE8,0x959D,0x0000,0x9BF1,0x0000,0x0000,0x0000,0x0000,0x9679,0x0000,0x9BEB,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9BED,0x968B,0x0000,0x9BEC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9BEE,
	0x0000,0x94A6,0x9BEF,0x95BC,0x9BF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8AB1,0x95BD,0x944E,0x9BF2,0x9BF3,0x0000,0x8D4B,0x8AB2,0x9BF4,0x8CB6,0x9763,0x9748,0x8AF4,0x9BF6,
	0x0000,0x92A1,0x0000,0x8D4C,0x8FAF,0x0000,0x0000,0x94DD,0x0000,0x0000,0x8FB0,0x0000,0x0000,0x0000,0x0000,0x8F98,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x92EA,0x95F7,0x9358,0x0000,0x0000,0x8D4D,0x0000,0x957B,0x0000,0x0000,0x0000,
	0x9BF7,0x0000,0x0000,0x0000,0x0000,0x0000,0x9378,0x8DC0,0x0000,0x0000,0x0000,0x8CC9,0x0000,0x92EB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x88C1,0x8F8E,0x8D4E,0x9766,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9BF8,0x9BF9,0x9470,0x0000,0x0000,0x0000,0x0000,0x9BFA,0x97F5,0x984C,0x0000,0x0000,0x0000,0x0000,0x9BFC,
	0x9BFB,0x0000,0x0000,0x8A66,0x0000,0x0000,0x9C40,0x0000,0x0000,0x0000,0x9C43,0x9C44,0x0000,0x9C42,0x0000,0x955F,
	0x8FB1,0x9C46,0x9C45,0x9C41,0x0000,0x0000,0x0000,0x0000,0x9C47,0x9C48,0x0000,0x0000,0x9C49,0x0000,0x0000,0x0000,
	0x9C4C,0x9C4A,0x0000,0x9C4B,0x9C4D,0x0000,0x8984,0x92EC,0x9C4E,0x0000,0x8C9A,0x89F4,0x9455,0x0000,0x9C4F,0x93F9,
};
static const WORD _ucs_to_sjis_5F00_data []={ //5F01 5FFF
	       0x95D9,0x0000,0x9C50,0x984D,0x0000,0x0000,0x0000,0x0000,0x9C51,0x95BE,0x9C54,0x989F,0x98AF,0x0000,0x8EAE,
	0x93F3,0x9C55,0x0000,0x8B7C,0x92A2,0x88F8,0x9C56,0x95A4,0x8D4F,0x0000,0x0000,0x926F,0x0000,0x0000,0x0000,0x92ED,
	0x0000,0xFAB7,0x0000,0x0000,0x0000,0x96ED,0x8CB7,0x8CCA,0x0000,0x9C57,0x0000,0x0000,0x0000,0x9C58,0x0000,0x9C5E,
	0x0000,0x8EE3,0x0000,0x0000,0xFAB8,0x92A3,0x0000,0x8BAD,0x9C59,0x0000,0x0000,0x0000,0x954A,0x0000,0x9265,0x0000,
	0x0000,0x9C5A,0x0000,0x0000,0x0000,0xFA67,0x0000,0x0000,0x9C5B,0x0000,0x8BAE,0x0000,0x9C5C,0x0000,0x9C5D,0x0000,
	0x0000,0x9C5F,0x0000,0x9396,0x0000,0x0000,0x9C60,0x9C61,0x0000,0x9C62,0x0000,0x0000,0x9C53,0x9C52,0x0000,0x0000,
	0x0000,0x9C63,0x8C60,0x0000,0x0000,0x0000,0x9546,0xFAB9,0x0000,0x8DCA,0x9556,0x92A4,0x956A,0x9C64,0x0000,0x0000,
	0x8FB2,0x8965,0x0000,0x9C65,0x0000,0x0000,0x0000,0x9C66,0x0000,0x96F0,0x0000,0x0000,0x94DE,0x0000,0x0000,0x9C69,
	0x899D,0x90AA,0x9C68,0x9C67,0x8C61,0x91D2,0x0000,0x9C6D,0x9C6B,0x0000,0x9C6A,0x97A5,0x8CE3,0x0000,0x0000,0x0000,
	0x8F99,0x9C6C,0x936B,0x8F5D,0x0000,0x0000,0x0000,0x93BE,0x9C70,0x9C6F,0x0000,0x0000,0x0000,0x0000,0x9C6E,0x0000,
	0x9C71,0x8CE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9C72,0x959C,0x8F7A,0x0000,0x0000,0x9C73,0x94F7,0x0000,
	0x0000,0x0000,0x0000,0x93BF,0x92A5,0x0000,0x0000,0xFABA,0x0000,0x934F,0x0000,0x0000,0x9C74,0x8B4A,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9053,0x0000,0x954B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8AF5,0x9445,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9C75,0x8E75,0x9659,0x965A,0x0000,0x0000,0x899E,0x9C7A,0xFABB,0x0000,
	0x9289,0x0000,0x0000,0x0000,0x9C77,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89F5,0x0000,0x0000,0x0000,0x0000,
	0x9CAB,0x9C79,0x0000,0x0000,0x0000,0x944F,0x0000,0x0000,0x9C78,0x0000,0x0000,0x9C76,0x0000,0x8D9A,0x0000,0x9C7C,
};
static const WORD _ucs_to_sjis_6000_data []={ //600E 60FB
	                                                                                                  0x9C83,0x9C89,
	0x9C81,0x0000,0x937B,0x0000,0x0000,0x9C86,0x957C,0x0000,0x0000,0x9C80,0x0000,0x9C85,0x97E5,0x8E76,0x0000,0x0000,
	0x91D3,0x9C7D,0x0000,0x0000,0x0000,0x8B7D,0x9C88,0x90AB,0x8985,0x9C82,0x89F6,0x9C87,0x0000,0x0000,0x0000,0x8BAF,
	0x0000,0x9C84,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9C8A,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9C8C,0x9C96,0x9C94,0x0000,0x0000,0x9C91,0x0000,0x0000,0x0000,0x9C90,0x97F6,0x0000,0x9C92,0x0000,0x0000,
	0x8BB0,0x0000,0x8D50,0x0000,0x0000,0x8F9A,0x0000,0x0000,0x0000,0x9C99,0x9C8B,0x0000,0x0000,0xFABC,0x0000,0x9C8F,
	0x9C7E,0x0000,0x89F8,0x9C93,0x9C95,0x9270,0x0000,0x0000,0x8DA6,0x89B6,0x9C8D,0x9C98,0x9C97,0x8BB1,0x0000,0x91A7,
	0x8A86,0x0000,0x0000,0x0000,0x0000,0x8C62,0x0000,0x9C8E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9C9A,0x0000,0x9C9D,0x9C9F,0xFABD,0x0000,0x0000,0x0000,0x8EBB,0xFABE,0x9CA5,0x92EE,0x9C9B,0x0000,0x0000,
	0x0000,0x0000,0x9CA3,0x0000,0x89F7,0x0000,0x9CA1,0x9CA2,0x0000,0x0000,0x9C9E,0x9CA0,0x0000,0x0000,0x0000,0x8CE5,
	0x9749,0x0000,0x0000,0x8AB3,0x0000,0x0000,0x8978,0x9CA4,0x0000,0x9459,0x88AB,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x94DF,0x9C7B,0x9CAA,0x9CAE,0x96E3,0x0000,0x9CA7,0x0000,0x0000,0x0000,0x9389,0x9CAC,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x8FEE,0x9CAD,0x93D5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9866,0x0000,0x9CA9,0x0000,0xFAC0,0x0000,0x0000,0x9CAF,0x0000,0x8D9B,0x0000,0x90C9,0x0000,0xFABF,0x88D2,
	0x9CA8,0x9CA6,0x0000,0x9179,0x0000,0x0000,0x0000,0x9C9C,0x8E53,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x91C4,0x9CBB,0xFAC2,0x917A,0x9CB6,0x0000,0x9CB3,0x9CB4,0x0000,0x8EE4,0x9CB7,0x9CBA,
};
static const WORD _ucs_to_sjis_6100_data []={ //6100 61FF
	0x9CB5,0x8F44,0x0000,0x9CB8,0x0000,0x0000,0x9CB2,0x0000,0x96FA,0x96F9,0x0000,0x0000,0x0000,0x9CBC,0x9CBD,0x88D3,
	0x0000,0xFAC3,0x0000,0x0000,0x0000,0x9CB1,0x0000,0x0000,0x0000,0x0000,0x8BF0,0x88A4,0x0000,0x0000,0x0000,0x8AB4,
	0xFAC1,0x9CB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x9CC1,0x9CC0,0x0000,0x0000,0x0000,0x9CC5,0x0000,0x0000,0x0000,
	0xFAC5,0x0000,0x0000,0x0000,0x9CC6,0x0000,0x0000,0xFAC4,0x0000,0x0000,0x0000,0x0000,0x9CC4,0x9CC7,0x9CBF,0x9CC3,
	0x0000,0x0000,0x9CC8,0x0000,0x9CC9,0x0000,0x0000,0x9CBE,0x8E9C,0x0000,0x9CC2,0x91D4,0x8D51,0x9CB0,0x9054,0x0000,
	0x0000,0x0000,0x0000,0x9CD6,0x0000,0x95E7,0x0000,0x0000,0x9CCC,0x9CCD,0x9CCE,0x0000,0x0000,0x9CD5,0x0000,0x9CD4,
	0x0000,0x0000,0x969D,0x8AB5,0x0000,0x9CD2,0x0000,0x8C64,0x8A53,0x0000,0x0000,0x9CCF,0x0000,0x0000,0x97B6,0x9CD1,
	0x88D4,0x9CD3,0x0000,0x9CCA,0x9CD0,0x9CD7,0x8C63,0x9CCB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x977C,0x0000,
	0x0000,0x0000,0x974A,0x0000,0x0000,0x0000,0x0000,0x9CDA,0x0000,0x0000,0x9CDE,0x0000,0x0000,0x0000,0x919E,0x0000,
	0x97F7,0x9CDF,0x0000,0x0000,0x9CDC,0x0000,0x9CD9,0x0000,0xFAC6,0x9CD8,0x9CDD,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x95AE,0x0000,0x0000,0x93B2,0x0000,0x8C65,0x0000,0x9CE0,0x9CDB,0x0000,0x9CE1,0x0000,
	0x0000,0x0000,0x8C9B,0x0000,0x0000,0x0000,0x89AF,0x0000,0x0000,0x0000,0x9CE9,0x0000,0x0000,0x0000,0x8AB6,0x0000,
	0x0000,0x0000,0x0000,0x9CE7,0x0000,0x0000,0x9CE8,0x8DA7,0x9CE6,0x9CE4,0x9CE3,0x9CEA,0x9CE2,0x9CEC,0x0000,0x0000,
	0x89F9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9CEE,0x0000,0x0000,0x9CED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x92A6,0x0000,0x9CF1,0x0000,0x9CEF,0x9CE5,0x8C9C,0x0000,0x9CF0,0x0000,0x9CF4,0x9CF3,0x9CF5,0x9CF2,
};
static const WORD _ucs_to_sjis_6200_data []={ //6200 62FF
	0x9CF6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9CF7,0x9CF8,0x95E8,0x0000,0x9CFA,0x9CF9,0x8F5E,0x0000,
	0x90AC,0x89E4,0x89FA,0xFAC7,0x9CFB,0x0000,0x88BD,0x0000,0x0000,0x0000,0x90CA,0x9CFC,0x0000,0xE6C1,0x9D40,0x8C81,
	0x0000,0x9D41,0x0000,0x0000,0x0000,0x0000,0x90ED,0x0000,0x0000,0x0000,0x9D42,0x0000,0x0000,0x0000,0x9D43,0x8B59,
	0x9D44,0x0000,0x9D45,0x9D46,0x91D5,0x0000,0x0000,0x0000,0x8CCB,0x0000,0x0000,0x96DF,0x0000,0x0000,0x0000,0x965B,
	0x8F8A,0x9D47,0x0000,0x0000,0x0000,0x0000,0x0000,0x90EE,0xE7BB,0x94E0,0x0000,0x8EE8,0x0000,0x8DCB,0x9D48,0x0000,
	0x0000,0x0000,0x0000,0x91C5,0x0000,0x95A5,0x0000,0x0000,0x91EF,0x0000,0x0000,0x9D4B,0x0000,0x0000,0x9D49,0x0000,
	0x9D4C,0x0000,0x0000,0x9D4A,0x0000,0x0000,0x0000,0x0000,0x9D4D,0x0000,0x0000,0x0000,0x0000,0x0000,0x95AF,0x0000,
	0x0000,0x88B5,0x0000,0x0000,0x0000,0x0000,0x957D,0x0000,0x0000,0x94E1,0x0000,0x0000,0x9D4E,0x0000,0x9D51,0x8FB3,
	0x8B5A,0x0000,0x9D4F,0x9D56,0x8FB4,0x0000,0x0000,0x0000,0x0000,0x9D50,0x9463,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x977D,0x9D52,0x9D53,0x9D57,0x938A,0x9D54,0x8D52,0x90DC,0x0000,0x0000,0x9D65,0x94B2,0x0000,0x91F0,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAC8,0x0000,0x0000,0x0000,0x0000,0x94E2,0x9DAB,0x0000,0x0000,0x0000,
	0x0000,0x95F8,0x0000,0x0000,0x0000,0x92EF,0x0000,0x0000,0x0000,0x9695,0x0000,0x9D5A,0x899F,0x928A,0x0000,0x0000,
	0x0000,0x0000,0x9D63,0x0000,0x0000,0x9253,0x9D5D,0x9D64,0x9D5F,0x9D66,0x9D62,0x0000,0x9D61,0x948F,0x0000,0x9D5B,
	0x89FB,0x9D59,0x8B91,0x91F1,0x9D55,0x0000,0x0000,0x9D58,0x8D53,0x90D9,0x0000,0x8FB5,0x9D60,0x9471,0x0000,0x0000,
	0x8B92,0x8A67,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8A87,0x9040,0x9D68,0x9D6D,
	0x0000,0x9D69,0x0000,0x8C9D,0x0000,0x9D6E,0x8E41,0x8D89,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8F45,0x9D5C,
};
static const WORD _ucs_to_sjis_6300_data []={ //6301 63FA
	       0x8E9D,0x9D6B,0x0000,0x0000,0x0000,0x0000,0x8E77,0x9D6C,0x88C2,0x0000,0x0000,0x9D67,0x0000,0x0000,0x0000,
	0x0000,0x92A7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B93,0x0000,0x0000,0x0000,0x0000,0x0000,0x8BB2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9D6A,0x88A5,0x0000,0x0000,0x8DC1,0x0000,0x0000,0x0000,0x9055,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x92F0,0x0000,0x0000,0x94D2,0x9D70,0x917D,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x91A8,0x0000,0x0000,0x8E4A,0x9D71,0x0000,0x9D73,
	0x9D6F,0x0000,0x0000,0x0000,0x0000,0x95DF,0x0000,0x92BB,0x0000,0x0000,0x0000,0x0000,0x917B,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x95F9,0x8ECC,0x9D80,0x0000,0x9D7E,0x0000,0x0000,0x9098,0x0000,
	0x0000,0x0000,0x8C9E,0x0000,0x0000,0x0000,0x9D78,0x8FB7,0x0000,0x0000,0x93E6,0x9450,0x0000,0x0000,0x0000,0x0000,
	0x9D76,0x0000,0x0000,0x917C,0x0000,0x0000,0x0000,0x0000,0x8EF6,0x9D7B,0x0000,0x0000,0x8FB6,0x0000,0x9D75,0x9D7A,
	0x0000,0x0000,0x9472,0x0000,0x0000,0x0000,0x9D74,0x0000,0x8C40,0x0000,0x0000,0x8A7C,0x0000,0x0000,0x0000,0x9D7C,
	0x97A9,0x8DCC,0x9254,0x9D79,0x0000,0x90DA,0x0000,0x8D54,0x9084,0x8986,0x915B,0x9D77,0x8B64,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8C66,0x0000,0x92CD,0x9D7D,0x0000,0x0000,0x0000,0x0000,0x0000,0x917E,0x0000,0x0000,0x9D81,0x0000,
	0x9D83,0x0000,0x0000,0x91B5,0x9D89,0x0000,0x9D84,0x0000,0x0000,0x9D86,0x0000,0x0000,0x0000,0x0000,0x0000,0x9560,
	0x92F1,0x0000,0x9D87,0x0000,0x0000,0x0000,0x974B,0x0000,0x0000,0x0000,0x9767,0x8AB7,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x88AC,0x0000,0x9D85,0x0000,0x0000,0x0000,0x0000,0x0000,0x9D82,0x0000,0x0000,0x0000,0x0000,0x8AF6,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8987,0xFAC9,0x9D88,0x0000,0x0000,0x0000,0x9768,
};
static const WORD _ucs_to_sjis_6400_data []={ //6406 64FE
	                                          0x9D8C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x91B9,0x0000,0x9D93,
	0x0000,0x0000,0x0000,0x9D8D,0x0000,0x0000,0x9D8A,0x9D91,0x0000,0x0000,0x0000,0x0000,0x9D72,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9D8E,0x0000,0x9D92,0x0000,0x0000,0x0000,0x94C0,0x938B,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9D8B,0x0000,0x9D8F,0x0000,0x0000,0x0000,0x8C67,0x0000,0x0000,0x0000,0x8DEF,0x0000,
	0x0000,0x0000,0x90DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9D97,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9345,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xFACA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9D94,0x0000,0x9680,0x0000,0x0000,0x0000,0x0000,0x0000,0x9D95,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9D96,0x0000,0x96CC,0x0000,0x90A0,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x8C82,0x0000,0x0000,0x0000,0x0000,0x9D9D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8E54,0x9D9A,0x0000,0x9D99,0x0000,0x0000,0x0000,0x0000,0x9451,0x0000,0x0000,0xFACB,0x93B3,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9350,0x9D9B,0x0000,0x0000,0x0000,0x9D9C,0x0000,0x958F,0x0000,0x9464,0x8E42,0x0000,
	0x90EF,0x0000,0x966F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8A68,0x0000,0x9DA3,0x9D9E,0x0000,0x0000,0x0000,
	0x0000,0x9769,0x9DA5,0x0000,0x0000,0x9DA1,0x0000,0x9DA2,0x0000,0x0000,0x0000,0x0000,0x0000,0x9180,0xFACC,0x0000,
	0x0000,0x0000,0x9DA0,0x0000,0x9D5E,0x0000,0x0000,0x0000,0x9DA4,0x0000,0x9D9F,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9DA9,0x9DAA,0x9346,0x9DAC,0x0000,0x0000,0x8E43,0x9DA7,0x0000,0x0000,0x0000,0x0000,0x8B5B,0x0000,0x0000,0x9DAD,
	0x0000,0x9DA6,0x9DB1,0x0000,0x9DB0,0x0000,0x9DAF,0x0000,0x0000,0x0000,0x9DB2,0x0000,0x0000,0x9DB4,0x8FEF,
};
static const WORD _ucs_to_sjis_6500_data []={ //6500 65FB
	0x9DB3,0x0000,0x0000,0x0000,0x0000,0x9DB7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9DB5,0x0000,0x0000,0x0000,0x9DB6,0x9D90,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9DB9,0x9DB8,0x0000,0x0000,0x0000,0x0000,0x0000,0x9D98,0x9DBA,0x9DAE,0x0000,0x0000,0x8E78,
	0x0000,0x0000,0x0000,0x0000,0x9DBB,0x9DBC,0x9DBE,0x9DBD,0x9DBF,0x89FC,0x0000,0x8D55,0x0000,0x0000,0x95FA,0x90AD,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x8CCC,0x0000,0x0000,0x9DC1,0x0000,0x0000,0x0000,0x0000,0x9DC4,0xFACD,0x9571,
	0x0000,0x8B7E,0x0000,0x0000,0x0000,0x9DC3,0x9DC2,0x9473,0x9DC5,0x8BB3,0x0000,0x0000,0x0000,0x9DC7,0x9DC6,0x0000,
	0x0000,0x0000,0x8AB8,0x8E55,0x0000,0x0000,0x93D6,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C68,0x0000,0x0000,0x0000,
	0x9094,0x0000,0x9DC8,0x0000,0x90AE,0x9347,0x0000,0x957E,0x9DC9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9DCA,0x9DCB,0x0000,0x0000,0x0000,0x95B6,0x9B7C,0x90C4,0x0000,0x0000,0x956B,0x0000,0x8DD6,0x0000,
	0x94E3,0x94C1,0x0000,0x0000,0x0000,0x0000,0x0000,0x936C,0x0000,0x97BF,0x0000,0x9DCD,0x8ECE,0x0000,0x0000,0x9DCE,
	0x0000,0x88B4,0x0000,0x0000,0x8BD2,0x90CB,0x0000,0x9580,0x0000,0x0000,0x0000,0x9DCF,0x8E61,0x9266,0x0000,0x8E7A,
	0x9056,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9DD0,0x0000,0x95FB,0x0000,0x0000,0x8997,0x8E7B,0x0000,0x0000,
	0x0000,0x9DD3,0x0000,0x9DD1,0x9DD4,0x97B7,0x9DD2,0x0000,0x0000,0x0000,0x0000,0x90F9,0x9DD5,0x0000,0x0000,0x91B0,
	0x0000,0x0000,0x9DD6,0x0000,0x0000,0x0000,0x0000,0x8AF8,0x0000,0x9DD8,0x0000,0x9DD7,0x0000,0x0000,0x0000,0x0000,
	0x9DD9,0x9DDA,0x8AF9,0x0000,0x0000,0x93FA,0x9255,0x8B8C,0x8E7C,0x9181,0x0000,0x0000,0x8F7B,0x88AE,0x0000,0x0000,
	0x0000,0x9DDB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89A0,0x9DDF,
};
static const WORD _ucs_to_sjis_6600_data []={ //6600 66FF
	0xFACE,0x0000,0x8D56,0x9DDE,0x0000,0x0000,0x8DA9,0x8FB8,0x0000,0xFAD1,0x9DDD,0x0000,0x8FB9,0x0000,0x96BE,0x8DA8,
	0x0000,0x0000,0x0000,0x88D5,0x90CC,0xFACF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9DE4,0x0000,0xFAD3,0x90AF,
	0x8966,0x0000,0x0000,0x0000,0xFAD4,0x8F74,0x0000,0x9686,0x8DF0,0x0000,0x0000,0x0000,0x0000,0x8FBA,0xFAD2,0x90A5,
	0x0000,0xFA63,0x0000,0x0000,0x9DE3,0x9DE1,0x9DE2,0x0000,0x0000,0x0000,0x0000,0xFAD0,0x928B,0x0000,0x0000,0x9E45,
	0x0000,0x9DE8,0x8E9E,0x8D57,0x9DE6,0x0000,0x0000,0x0000,0x0000,0x9DE7,0x0000,0x9057,0x0000,0x0000,0x0000,0x9DE5,
	0x0000,0x0000,0x8E4E,0x0000,0x0000,0x0000,0x0000,0xFAD6,0x0000,0xFAD7,0x0000,0x0000,0x0000,0x9DEA,0x9DE9,0x9DEE,
	0x0000,0x0000,0x9DEF,0x0000,0x9DEB,0xFAD5,0x8A41,0x9DEC,0x9DED,0x94D3,0x0000,0x0000,0x0000,0x0000,0x9581,0x8C69,
	0x9DF0,0x0000,0x0000,0xFAD9,0x90B0,0x0000,0x8FBB,0x0000,0x0000,0x0000,0x9271,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x8BC5,0x0000,0x9DF1,0x9DF5,0x0000,0x0000,0x89C9,0x9DF2,0x9DF4,0x0000,0x0000,0x0000,0x0000,0x9DF3,0x0000,
	0x0000,0x8F8B,0x0000,0x0000,0x0000,0x0000,0x9267,0x88C3,0x9DF6,0xFADA,0x0000,0x0000,0x0000,0x9DF7,0x0000,0x0000,
	0xFADB,0x0000,0x92A8,0x0000,0x0000,0x0000,0x97EF,0x0000,0x0000,0x0000,0x0000,0x8E62,0x0000,0x0000,0x95E9,0x0000,
	0x0000,0x0000,0xFADC,0x0000,0x965C,0x0000,0x0000,0x0000,0x9E41,0x9DF9,0x0000,0x0000,0x9DFC,0x0000,0x9DFB,0xFADD,
	0x0000,0x9DF8,0x0000,0x0000,0x9E40,0x0000,0x0000,0x93DC,0x0000,0x9DFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9E42,0x0000,0x0000,0x8F8C,0x9E43,0x0000,0x976A,0x9498,0x0000,0x0000,
	0x9E44,0x0000,0x0000,0x0000,0x0000,0x0000,0x9E46,0x0000,0x0000,0x9E47,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9E48,0x0000,0x8BC8,0x8967,0x8D58,0x9E49,0x0000,0x9E4A,0x8F91,0x9182,0xFADE,0xFA66,0x99D6,0x915D,0x915C,0x91D6,
};
static const WORD _ucs_to_sjis_6700_data []={ //6700 67FF
	0x8DC5,0x0000,0x0000,0x98F0,0x0000,0x0000,0x0000,0x0000,0x8C8E,0x974C,0x0000,0x95FC,0x0000,0x959E,0xFADF,0x9E4B,
	0x0000,0x0000,0x0000,0x0000,0x8DF1,0x92BD,0x9E4C,0x984E,0x0000,0x0000,0x0000,0x965D,0x0000,0x92A9,0x9E4D,0x8AFA,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9E4E,0x9E4F,0x96D8,0x0000,0x96A2,0x9696,0x967B,0x8E44,0x9E51,0x0000,
	0x0000,0x8EE9,0x0000,0x0000,0x9670,0x0000,0x9E53,0x9E56,0x9E55,0x0000,0x8AF7,0x0000,0x0000,0x8B80,0x0000,0x9E52,
	0x0000,0x9E54,0x0000,0x0000,0x0000,0x0000,0x9E57,0x0000,0x0000,0x9099,0x0000,0x0000,0x0000,0x0000,0x979B,0x88C7,
	0x8DDE,0x91BA,0x0000,0x8EDB,0x0000,0x0000,0x8FF1,0x0000,0x0000,0x9E5A,0x0000,0x0000,0x936D,0x0000,0x9E58,0x91A9,
	0x9E59,0x8FF0,0x96DB,0x9E5B,0x9E5C,0x9788,0xFAE1,0x0000,0x0000,0x0000,0x9E61,0x0000,0x0000,0x8D59,0x0000,0x9474,
	0x9E5E,0x938C,0x9DDC,0x9DE0,0x0000,0x8B6E,0x0000,0x9466,0x0000,0x0000,0x0000,0x0000,0x9E60,0x0000,0x8FBC,0x94C2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x9E66,0x0000,0x94F8,0x0000,0x9E5D,0x0000,0x9E63,0x9E62,0x0000,0x0000,0x0000,
	0x90CD,0x0000,0x0000,0x0000,0x0000,0x968D,0x0000,0x97D1,0x0000,0x0000,0x9687,0x0000,0x89CA,0x8E7D,0x0000,0x0000,
	0x9867,0x9E65,0x9095,0x0000,0x0000,0x0000,0x9E64,0x0000,0x0000,0x9E5F,0x0000,0x0000,0x0000,0x0000,0x0000,0x8CCD,
	0x0000,0x0000,0x0000,0x9E6B,0x9E69,0x0000,0x89CB,0x9E67,0x9E6D,0x9E73,0x0000,0xFAE2,0x0000,0x0000,0x0000,0x0000,
	0xFAE4,0x91C6,0x0000,0x0000,0x95BF,0x0000,0x9E75,0x0000,0x0000,0x0000,0x9541,0x0000,0x0000,0x0000,0x9E74,0x9490,
	0x965E,0x8AB9,0x0000,0x90F5,0x8F5F,0x0000,0x0000,0x0000,0x92D1,0x0000,0x974D,0x0000,0x0000,0x9E70,0x9E6F,0x0000,
	0x0000,0x0000,0x9E71,0x0000,0x9E6E,0x0000,0x0000,0x9E76,0x0000,0x9E6C,0x0000,0x0000,0x9E6A,0x0000,0x9E72,0x9E68,
	0x0000,0x928C,0x0000,0x96F6,0x8EC4,0x8DF2,0x0000,0x0000,0x0000,0x0000,0x0000,0x8DB8,0x0000,0x0000,0x968F,0x8A60,
};
static const WORD _ucs_to_sjis_6800_data []={ //6801 68FA
	       0xFAE5,0x92CC,0x93C8,0x8968,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x90F0,0x0000,0x0000,0x90B2,0x8C49,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9E78,0x0000,
	0x0000,0x8D5A,0x8A9C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9E7A,0x8A94,0x9E81,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9E7D,0x0000,0x90F1,0x0000,0x0000,0x0000,0x8A6A,0x8DAA,0x0000,0x0000,0x8A69,0x8DCD,0x0000,0x0000,
	0x9E7B,0x8C85,0x8C6A,0x938D,0xFAE6,0x0000,0x9E79,0x0000,0x88C4,0x0000,0x0000,0x0000,0x0000,0x9E7C,0x9E7E,0x0000,
	0x8BCB,0x8C4B,0xFAE3,0x8ABA,0x8B6A,0x0000,0x0000,0x0000,0x0000,0x9E82,0x0000,0x0000,0x8DF7,0x9691,0x0000,0x8E56,
	0x0000,0x0000,0x0000,0x9E83,0x0000,0x0000,0x0000,0x954F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9E8F,0x0000,0x89B1,0x9E84,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9E95,0x9E85,
	0x0000,0x97C0,0x0000,0x9E8C,0x0000,0x947E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9E94,0x0000,0x9E87,
	0x0000,0x0000,0x0000,0x88B2,0x9E89,0x0000,0x0000,0x8D5B,0x0000,0x0000,0x0000,0x9E8B,0x0000,0x9E8A,0x0000,0x9E86,
	0x9E91,0x0000,0x8FBD,0x0000,0x0000,0x0000,0x9AEB,0x8CE6,0x979C,0x0000,0x0000,0x0000,0x0000,0x9E88,0x0000,0x92F2,
	0x8A42,0x8DAB,0x0000,0x9E80,0x0000,0x9E90,0x8A81,0x0000,0x0000,0x9E8E,0x9E92,0x0000,0x938E,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8AFC,0x0000,0x9EB0,0x0000,0xFA64,0x96C7,0x9E97,0x8AFB,0x0000,0x9E9E,0x0000,0xFAE7,
	0x0000,0x0000,0x965F,0x0000,0x9E9F,0x9EA1,0x0000,0x9EA5,0x9E99,0x0000,0x9249,0x0000,0x0000,0x0000,0x0000,0x938F,
	0x9EA9,0x9E9C,0x0000,0x9EA6,0x0000,0x0000,0x0000,0x9EA0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9058,0x9EAA,
	0x0000,0x0000,0x90B1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9EA8,0x8ABB,
};
static const WORD _ucs_to_sjis_6900_data []={ //6900 69FF
	0x986F,0x9E96,0x0000,0x0000,0x9EA4,0x88D6,0x0000,0x0000,0x9E98,0x0000,0x0000,0x96B8,0x9E9D,0x9041,0x92C5,0x9E93,
	0x0000,0x0000,0x9EA3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x909A,0x9EAD,0x8A91,0x8C9F,0x0000,0x0000,0x0000,
	0x0000,0x9EAF,0x9E9A,0x9EAE,0x0000,0x9EA7,0x9E9B,0x0000,0x9EAB,0x0000,0x9EAC,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9EBD,0x0000,0x0000,0x0000,0x93CC,0x0000,0x9EA2,0x0000,0x0000,0x9EB9,0x0000,0x0000,0x0000,0x9EBB,0x0000,0x92D6,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x976B,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9596,0x9EB6,0x91C8,0x0000,0x0000,0x0000,0x9EBC,0x915E,0x0000,0x9EB3,0x9EC0,0x9EBF,0x0000,
	0x93ED,0x9EBE,0x93E8,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAE9,0x0000,0x9EC2,0x9EB5,0x0000,0x8BC6,0x9EB8,0x8F7C,
	0x0000,0x0000,0x0000,0x9480,0x9EBA,0x8BC9,0x0000,0x9EB2,0x9EB4,0x9EB1,0x0000,0x0000,0x984F,0x8A79,0x9EB7,0x0000,
	0x0000,0x9EC1,0x8A54,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8DE5,0x0000,0x0000,0x0000,0x897C,0x0000,
	0x0000,0x9ED2,0x0000,0x0000,0x9850,0x9ED5,0x0000,0x0000,0xFAEB,0x0000,0x0000,0x9059,0x9ED4,0x0000,0x0000,0x0000,
	0x9ED3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9ED0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9EC4,0x0000,
	0x0000,0x9EE1,0x9EC3,0x0000,0x9ED6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9ECE,0x0000,0x0000,0x9EC9,0x9EC6,
	0x0000,0x9EC7,0x0000,0x9ECF,0x0000,0x0000,0x0000,0xEAA0,0x0000,0x0000,0x9ECC,0x8D5C,0x92C6,0x9184,0x9ECA,0x0000,
	0x9EC5,0x0000,0x0000,0x9EC8,0x0000,0x0000,0x0000,0x0000,0x976C,0x968A,0x0000,0x0000,0x0000,0x9ECD,0x9ED7,0x0000,
	0x0000,0x0000,0xFAEC,0x0000,0x0000,0x0000,0x0000,0x9EDF,0x9ED8,0x0000,0x0000,0x9EE5,0x0000,0x9EE3,0x0000,0x0000,
	0x0000,0x0000,0x9EDE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9EDD,0x0000,0x92CE,0x0000,0x9185,0x0000,0x9EDB,
};
static const WORD _ucs_to_sjis_6A00_data []={ //6A02 6AFB
	              0x9ED9,0x0000,0x0000,0x9EE0,0x0000,0x0000,0x0000,0x0000,0x9EE6,0x94F3,0x9EEC,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9EE7,0x9EEA,0x9EE4,0x0000,0x0000,0x9294,0x0000,0x9557,0x0000,0x9EDA,0x0000,0x0000,0x9EE2,0x8FBE,
	0x0000,0x96CD,0x9EF6,0x9EE9,0x0000,0x0000,0x0000,0x0000,0x0000,0x8CA0,0x89A1,0x8A7E,0x0000,0x0000,0x9ED1,0x0000,
	0xFAED,0x0000,0x0000,0x0000,0x0000,0x8FBF,0x9EEE,0x0000,0x9EF5,0x8EF7,0x8A92,0x0000,0x0000,0x924D,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9EEB,0x0000,0xFAEF,0x9EF0,0x9EF4,0x0000,0x0000,0x8BB4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B6B,0x9EF2,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B40,
	0x0000,0x93C9,0x9EF1,0x0000,0x0000,0x0000,0x9EF3,0x0000,0x0000,0x0000,0x0000,0xFAEE,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9EED,0xFAF0,0x0000,0x0000,0x0000,0x0000,0x9EEF,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAF1,0x8A80,
	0x9268,0x0000,0x0000,0x0000,0x9EFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9EF8,0x8CE7,0x0000,
	0x9EF7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9F40,0x0000,0x0000,0x0000,0x0000,0x9E77,0x0000,0x0000,0x0000,
	0x9EF9,0x0000,0x9EFB,0x9EFC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9F4B,0x0000,0x9F47,0x0000,0x9E8D,0x0000,
	0x0000,0x0000,0x0000,0x9F46,0x0000,0x0000,0x0000,0x0000,0x9F45,0x0000,0x0000,0x9F42,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9EE8,0x9F44,0x9F43,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9F49,0x0000,0x9845,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9F4C,0x8BF9,0x0000,0x0000,0x9F48,0x9F4A,
	0x0000,0x0000,0xFAF2,0x0000,0xFAF3,0x0000,0x0000,0x0000,0x94A5,0x0000,0x9F4D,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9F51,0x9F4E,
};
static const WORD _ucs_to_sjis_6B00_data []={ //6B04 6BF3
	                            0x9793,0x9F4F,0x0000,0x0000,0x0000,0x0000,0x9EDC,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9F52,0x0000,0x0000,0x0000,0x9F53,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8954,0x0000,0x9F55,
	0x8C87,0x8E9F,0x0000,0x8BD3,0x0000,0x0000,0x0000,0x89A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x977E,0x0000,0x0000,0x0000,0x0000,0x9F57,0x9F56,0x9F59,0x8B5C,0x0000,0x0000,0x8BD4,0x8ABC,0x0000,
	0x0000,0x0000,0x0000,0x9F5C,0x0000,0x0000,0x0000,0x9F5B,0x0000,0x9F5D,0x0000,0x0000,0x89CC,0x0000,0x9256,0x0000,
	0x9F5E,0x0000,0x0000,0x8ABD,0x9F60,0x0000,0x0000,0x0000,0x0000,0x9F5F,0x0000,0x9F61,0x0000,0x0000,0x0000,0x9F62,
	0x0000,0x9F63,0x8E7E,0x90B3,0x8D9F,0x0000,0x9590,0x0000,0x0000,0x95E0,0x9863,0x0000,0x0000,0x0000,0x0000,0x8E95,
	0x0000,0x0000,0x0000,0x8DCE,0x97F0,0x0000,0x0000,0x0000,0x9F64,0x9F65,0x0000,0x8E80,0x0000,0x0000,0x0000,0x9F66,
	0x9F67,0x0000,0x0000,0x9F69,0x9F68,0x0000,0x9677,0x0000,0x0000,0x8F7D,0x8EEA,0x8E63,0x0000,0x9F6A,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x9F6C,0x9042,0x0000,0x9F6B,0x0000,0x0000,0x0000,0x0000,0x0000,0x9F6D,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9F6E,0x0000,0x0000,0x0000,0x0000,0x0000,0x9F6F,0x9F70,0x0000,0x0000,0x0000,0x9F71,
	0x0000,0x9F73,0x9F72,0x9F74,0x89A3,0x9269,0x0000,0x9F75,0x0000,0x0000,0x8E45,0x8A6B,0x9F76,0x0000,0x0000,0x9361,
	0x9ACA,0x0000,0x0000,0x0000,0x0000,0x8B42,0x9F77,0x0000,0x0000,0x0000,0x0000,0x9F78,0x0000,0x95EA,0x9688,0x0000,
	0x0000,0x0000,0x93C5,0x9F79,0x94E4,0x0000,0xFAF4,0x0000,0x94F9,0x0000,0x0000,0x96D1,0x0000,0x0000,0x0000,0x9F7A,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9F7C,0x9F7B,0x0000,0x0000,0x9F7E,
	0x0000,0x0000,0x0000,0x9F7D,
};
static const WORD _ucs_to_sjis_6C00_data []={ //6C08 6CF3
	                                                        0x9F81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8E81,
	0x0000,0x96AF,0x0000,0x9F82,0x9F83,0x0000,0x0000,0x8B43,0x0000,0x0000,0x0000,0x9F84,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9F86,0x9F85,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x9085,0x0000,0x0000,0x9558,0x8969,0x0000,0x0000,0x0000,0x0000,0x0000,0x94C3,0xFAF5,
	0x92F3,0x8F60,0x8B81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x94C4,0x0000,
	0x8EAC,0x0000,0x0000,0x0000,0x0000,0x9F88,0x0000,0x8ABE,0x0000,0x0000,0x8998,0x0000,0xFAF6,0x93F0,0x9F87,0x8D5D,
	0x9272,0x0000,0x9F89,0x0000,0x0000,0x0000,0x0000,0x0000,0x9F91,0x0000,0x9F8A,0x0000,0x0000,0x0000,0x0000,0xFAF8,
	0x91BF,0x0000,0x8B82,0x9F92,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C88,0x0000,0x0000,0x8B44,0x9F90,0x0000,
	0x0000,0x9F8E,0x9F8B,0x9780,0x0000,0x0000,0xFAF7,0x0000,0x92BE,0x0000,0x0000,0x0000,0x93D7,0x9F8C,0x0000,0x0000,
	0x9F94,0x0000,0x9F93,0x8C42,0x0000,0x0000,0x89AB,0x0000,0x0000,0x8DB9,0x9F8D,0x9F8F,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9676,0x91F2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9697,0x0000,0x0000,0x9F9C,0x0000,
	0x0000,0x9F9D,0x0000,0x89CD,0x0000,0x0000,0x0000,0x0000,0x95A6,0x96FB,0x9F9F,0x8EA1,0x8FC0,0x9F98,0x9F9E,0x8988,
	0x0000,0x8BB5,0x0000,0x0000,0x9F95,0x9F9A,0x0000,0x0000,0x0000,0x90F2,0x9491,0x0000,0x94E5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9F97,0x0000,0x9640,0x0000,0x9F99,0x0000,0x9FA2,0xFAF9,0x9FA0,0x0000,0x9F9B,0x0000,0x0000,
	0x0000,0x9641,0x9467,0x8B83,0x0000,0x9344,0x0000,0x0000,0x928D,0x0000,0x9FA3,0x0000,0x0000,0x0000,0x0000,0x9FA1,
	0x91D7,0x9F96,0x0000,0x896A,
};
static const WORD _ucs_to_sjis_6D00_data []={ //6D04 6DFC
	                            0xFAFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x976D,0x9FAE,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9FAD,0x0000,0x0000,0x0000,0x0000,0x90F4,0x0000,0x9FAA,0x0000,0x978C,0x0000,0x0000,0x93B4,0x9FA4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x92C3,0x0000,0x0000,0x0000,0x896B,0x8D5E,0x9FA7,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8F46,0x9FAC,0x0000,0x9FAB,0x9FA6,0x0000,0x9FA9,0x0000,0x0000,0x8A88,0x0000,0x9FA8,0x9468,0x0000,
	0x0000,0x97AC,0x0000,0x0000,0x8FF2,0x90F3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9FB4,0x9FB2,0x0000,0x956C,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x9FAF,0x9FB1,0x0000,0x8959,0x0000,0x0000,0x8D5F,0x9851,0x0000,0x8A5C,0x0000,0x9582,0xFAFC,
	0x0000,0x0000,0x0000,0x0000,0x9781,0x0000,0x0000,0x8A43,0x905A,0x9FB3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x9FB8,0x0000,0xFAFB,0x8FC1,0x0000,0x0000,0x0000,0x974F,0x0000,0x9FB5,0x0000,
	0x0000,0x0000,0x0000,0x9FB0,0x0000,0x9FB6,0xFB40,0x0000,0x0000,0x97DC,0x0000,0x9393,0x93C0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB41,0x0000,0x0000,0x8A55,
	0x0000,0x0000,0x8974,0x0000,0x0000,0x9FBC,0x0000,0x0000,0x9FBF,0x0000,0x0000,0x0000,0x97C1,0x0000,0x0000,0x0000,
	0x9784,0x0000,0x0000,0x0000,0x0000,0x9FC6,0x9FC0,0x9FBD,0x0000,0x0000,0x0000,0x97D2,0x9FC3,0x0000,0x0000,0xFB42,
	0x0000,0x8F69,0x9FC5,0x0000,0x0000,0x9FCA,0x0000,0x0000,0x9391,0x9FC8,0x0000,0x0000,0x0000,0x0000,0x9FC2,0x0000,
	0x0000,0x9257,0x0000,0x0000,0x9FC9,0x0000,0x9FBE,0x0000,0x9FC4,0x0000,0x9FCB,0x88FA,0x9FC1,0x0000,0x9FCC,0x0000,
	0x0000,0x905B,0xFB44,0x8F7E,0x0000,0x95A3,0x0000,0x8DAC,0xFB43,0x9FB9,0x9FC7,0x9359,0xFB45,
};
static const WORD _ucs_to_sjis_6E00_data []={ //6E05 6EFF
	                                   0x90B4,0x0000,0x8A89,0x8DCF,0x8FC2,0x9FBB,0x8F61,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x8C6B,0x0000,0x9FBA,0x0000,0x0000,0x0000,0x9FD0,0x8F8D,0x8CB8,0x0000,0x9FDF,0x0000,0x9FD9,
	0x8B94,0x936E,0x0000,0x9FD4,0x9FDD,0x88AD,0x8951,0xFB48,0x0000,0x89B7,0x0000,0x9FD6,0x91AA,0x9FCD,0x9FCF,0x8D60,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9FE0,0xFB46,0x9FDB,0x0000,0xFB49,0x0000,0x9FD3,0x0000,
	0x0000,0x0000,0x0000,0x9FDA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x96A9,0x0000,0x0000,0x9FD8,0x9FDC,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8CCE,0x0000,0x8FC3,0x0000,0x0000,0x9258,0xFB47,0x0000,0x0000,0x9FD2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x974E,0x0000,0x0000,0x0000,0x9FD5,0x0000,0x0000,0x9FCE,0x9392,
	0x0000,0x0000,0x9FD1,0x0000,0x0000,0x0000,0x9FD7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9870,0x8EBC,
	0x969E,0x0000,0x9FE1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x94AC,0x0000,0x0000,0x9FED,
	0x8CB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x8F80,0x0000,0x9FE3,0x0000,0x0000,0x0000,0x97AD,0x8D61,0x0000,0x9FF0,
	0x0000,0x0000,0x88EC,0x0000,0x0000,0x9FEE,0x0000,0x0000,0x0000,0x0000,0x9FE2,0x0000,0x0000,0x0000,0x0000,0x9FE8,
	0x0000,0x0000,0x9FEA,0x0000,0x0000,0x0000,0x976E,0x9FE5,0x0000,0x0000,0x934D,0x0000,0x0000,0x9FE7,0x0000,0xFB4A,
	0x0000,0x0000,0x9FEF,0x0000,0x9FE9,0x96C5,0x0000,0x0000,0x0000,0x9FE4,0x0000,0x8EA0,0x9FFC,0x0000,0x0000,0x0000,
	0x0000,0x8A8A,0x0000,0x9FE6,0x9FEB,0x9FEC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x91EA,0x91D8,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9FF4,0x0000,0x0000,0x9FFA,
	0x0000,0x0000,0x9FF8,0x0000,0x9348,0x0000,0x0000,0xE042,0x9FF5,0x0000,0x0000,0x0000,0x0000,0x0000,0x9FF6,0x9FDE,
};
static const WORD _ucs_to_sjis_6F00_data []={ //6F01 6FFE
	       0x8B99,0x9559,0x0000,0x0000,0x0000,0x8EBD,0x0000,0x0000,0x8D97,0x0000,0x0000,0x0000,0x0000,0x0000,0x9852,
	0x0000,0x9FF2,0x0000,0xE041,0x8989,0x9186,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9499,0x0000,0x8ABF,0x97F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x969F,0x92D0,0x0000,0x0000,0x0000,
	0x0000,0x9FF9,0x9FFB,0x0000,0x0000,0x0000,0x0000,0x0000,0x9151,0x0000,0x0000,0x0000,0x0000,0x0000,0xE040,0x9FF7,
	0x0000,0x9FF1,0x0000,0x0000,0x0000,0x8AC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8C89,0x0000,0x0000,0x0000,0xE04E,0x0000,0x0000,0xE049,0x90F6,0x0000,0x0000,0x8A83,
	0x0000,0x0000,0x0000,0x0000,0x8F81,0x0000,0xE052,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE04B,0x92AA,0xE048,
	0x92D7,0x0000,0x0000,0x0000,0xE06B,0x0000,0x0000,0x0000,0xE045,0x0000,0xE044,0x0000,0xE04D,0x0000,0x0000,0x0000,
	0xE047,0xE046,0xE04C,0x0000,0x909F,0x0000,0xE043,0x0000,0xFB4B,0x0000,0x0000,0x0000,0x0000,0x0000,0xE04F,0x0000,
	0x0000,0xE050,0x0000,0x0000,0x0000,0x0000,0x0000,0x8AC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE055,0x0000,0xE054,0xE056,0x0000,0x0000,0x0000,0x0000,0x0000,0xE059,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9362,0x0000,0xE053,0x0000,0xFB4C,0x0000,0x0000,0x0000,0xE057,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8C83,0x91F7,0xE051,0x945A,0x0000,0x0000,0xE058,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE05D,0xE05B,0x0000,0x0000,0xE05E,0x0000,0x0000,0xE061,0x0000,0x0000,0x0000,0xE05A,
	0x8D8A,0x9447,0x0000,0x0000,0x9FB7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9794,0xE05C,0x0000,0xE060,0x91F3,
	0x0000,0xE05F,0x0000,0xE04A,0x0000,0xFB4D,0xE889,0x0000,0x0000,0x0000,0xE064,0x0000,0x0000,0x0000,0xE068,
};
static const WORD _ucs_to_sjis_7000_data []={ //7001 70FD
	       0xE066,0x0000,0x0000,0x0000,0xFB4E,0x0000,0xFB4F,0x0000,0xE062,0x0000,0xE063,0x0000,0x0000,0x0000,0xE067,
	0x0000,0xE065,0x0000,0x0000,0x0000,0x956D,0x0000,0x0000,0xE06D,0x0000,0xE06A,0xE069,0x0000,0xE06C,0x93D2,0xE06E,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9295,0x91EB,0xFB50,0x0000,0x0000,0x0000,0x90A3,0x0000,0x0000,0x0000,
	0xE06F,0x0000,0xE071,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE070,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9FF3,0x0000,0x0000,0x0000,
	0x0000,0xE072,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x93E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE073,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89CE,0x0000,0x0000,0x0000,0x9394,
	0x8A44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B84,0x0000,0x0000,0x0000,0x8EDC,0x8DD0,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xFB51,0x0000,0x0000,0x0000,0x9846,0x9086,0x0000,0x0000,0x0000,0x898A,0x0000,
	0x0000,0x0000,0xE075,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE074,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB52,0xE078,0x9259,0xE07B,0xE076,
	0x0000,0x0000,0x0000,0xE07A,0x0000,0x0000,0x0000,0x0000,0xE079,0x935F,0x88D7,0xFA62,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x97F3,0x0000,0x0000,0xE07D,0x0000,0x0000,0x0000,0x8947,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE080,0x0000,0x0000,0x0000,0xE07E,0x0000,0xE07C,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE077,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9642,0x0000,0x0000,0x0000,0xE082,
};
static const WORD _ucs_to_sjis_7100_data []={ //7104 71FF
	                            0xFB54,0x0000,0x0000,0x0000,0x0000,0xE081,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB53,
	0x0000,0x0000,0x0000,0x0000,0x898B,0x0000,0x0000,0x0000,0x0000,0xE084,0x95B0,0x0000,0xE083,0x0000,0x0000,0x0000,
	0x0000,0x96B3,0x0000,0x0000,0x0000,0x0000,0x8FC5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9152,0x0000,0x0000,0x0000,0x0000,0x0000,0x8FC4,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB56,0xFB57,0x0000,0x97F9,0x0000,0x0000,0xE08A,0x0000,0x90F7,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE086,0xE08B,0x0000,0x0000,0x898C,0x0000,0x0000,0xFB55,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE089,0x0000,0x9481,0xE085,0xE088,0x8FC6,0x0000,0x94CF,0x0000,0x0000,0xE08C,0x0000,0x8ECF,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x90F8,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE08F,0x0000,0x0000,0x0000,0xE087,0x0000,0x8C46,0x0000,0x0000,0x0000,0x0000,0xE08D,
	0x0000,0x0000,0x0000,0x0000,0x976F,0xE090,0x0000,0x0000,0x0000,0xEAA4,0x0000,0x0000,0x0000,0x0000,0x0000,0x8F6E,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE091,0x0000,0x0000,0x0000,0xE092,0x0000,0x0000,0x0000,
	0x0000,0x944D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE094,0x0000,0x0000,0x0000,0x0000,0xE095,0x0000,
	0x0000,0xFB59,0x0000,0x9452,0x0000,0x0000,0x0000,0x0000,0x9395,0xE097,0x0000,0x0000,0x0000,0x0000,0xE099,0x0000,
	0x97D3,0x0000,0xE096,0x0000,0xE098,0x898D,0x0000,0xE093,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9A7A,
	0xE09A,0x0000,0x0000,0x0000,0x0000,0x9187,0x8E57,0xE09C,0x0000,0x0000,0x0000,0x0000,0xE09B,0x9043,0x99D7,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE09D,0x0000,0x0000,0x0000,0xE09F,0x0000,0xE08E,0xE09E,0x0000,0xFB5A,0xE0A0,
};
static const WORD _ucs_to_sjis_7200_data []={ //7206 72FD
	                                          0x949A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0A1,0x0000,0x0000,
	0xE0A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0A3,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0A4,0x0000,0x92DC,0x0000,0xE0A6,0xE0A5,0x0000,0x0000,
	0xE0A7,0x0000,0xE0A8,0x0000,0x0000,0x8EDD,0x9583,0x0000,0x0000,0x0000,0x96EA,0xE0A9,0xE0AA,0x9175,0x8EA2,0xE0AB,
	0xE0AC,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0AD,0x95D0,0x94C5,0x0000,0x0000,0xE0AE,0x9476,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x92AB,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0AF,0x89E5,0x0000,0x8B8D,0x0000,0x96C4,0x0000,0x96B4,
	0x0000,0x89B2,0x9853,0x0000,0x0000,0x0000,0x0000,0x9671,0x0000,0x95A8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x90B5,0x0000,0xE0B0,0x0000,0x0000,0x0000,0x0000,0x93C1,0x0000,0x0000,0x0000,0x8CA1,0xE0B1,0x0000,
	0x8DD2,0xE0B3,0xE0B2,0x0000,0x0000,0x0000,0x0000,0xE0B4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE0B5,0x0000,0x0000,0x0000,0xE0B6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8B5D,0x0000,0xE0B7,0x0000,0x0000,0x0000,0x0000,0xE0B8,0x0000,0x0000,0x0000,0x0000,0x8CA2,0x0000,0x0000,0x94C6,
	0x0000,0xFB5B,0xE0BA,0x0000,0x0000,0x0000,0x8FF3,0x0000,0x0000,0xE0B9,0x0000,0x0000,0x0000,0x0000,0xFB5C,0x0000,
	0x0000,0x0000,0x8BB6,0xE0BB,0xE0BD,0x0000,0xE0BC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0BE,0x0000,
	0x8CCF,0x0000,0xE0BF,0x0000,0x0000,0x0000,0x0000,0x8BE7,0x0000,0x915F,0x0000,0x8D9D,0x0000,0x0000,0x0000,0x0000,
	0xE0C1,0xE0C2,0xE0C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8EEB,0x0000,0x0000,0x93C6,0x8BB7,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0C4,0x924B,0xE0C3,0x0000,0x0000,0x9854,0x9482,
};
static const WORD _ucs_to_sjis_7300_data []={ //730A 73FE
	                                                                      0xE0C7,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0C9,0xE0C6,0x0000,0x0000,0x0000,0x96D2,0xE0C8,0xE0CA,0x0000,0x97C2,
	0x0000,0x0000,0x0000,0x0000,0xFB5D,0xE0CE,0x0000,0x0000,0x0000,0xE0CD,0x9296,0x944C,0x0000,0x0000,0x8CA3,0xE0CC,
	0x0000,0x0000,0x0000,0x0000,0xE0CB,0x0000,0x9750,0x9751,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0CF,0x898E,
	0x0000,0x0000,0x0000,0x0000,0x8D96,0x8E82,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0D0,0xE0D1,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0D3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x8F62,0x0000,0x0000,0x0000,0x0000,0xE0D5,0x0000,0xE0D4,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE0D6,0x0000,0x8A6C,0x0000,0x0000,0xE0D8,0x0000,0xFB5F,0xE0D7,0x0000,0xE0DA,0xE0D9,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x8CBA,0x0000,0x0000,0x97A6,0x0000,0x8BCA,0x0000,0x89A4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8BE8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8ADF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x97E6,0xE0DC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0DE,0x0000,0xFB60,0x0000,0x0000,
	0xE0DF,0x0000,0x89CF,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0DB,0xFB61,0x8E58,0x0000,0x0000,0x92BF,0xE0DD,0x0000,
	0x0000,0x0000,0xFB64,0x0000,0x0000,0x0000,0xFB62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0E2,0x0000,
	0x8EEC,0x0000,0x0000,0xFB63,0x0000,0xE0E0,0x0000,0x0000,0x0000,0x0000,0x8C5D,0x0000,0x0000,0x94C7,0xE0E1,0x0000,
	0x0000,0xE0FC,0x0000,0x0000,0x0000,0xFB66,0x0000,0x0000,0xE0E7,0x0000,0x0000,0x0000,0x0000,0x0000,0x8CBB,
};
static const WORD _ucs_to_sjis_7400_data []={ //7403 74F8
	                     0x8B85,0x0000,0xE0E4,0x979D,0xFB65,0x0000,0x97AE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x91F4,0x0000,0x0000,0xE0E6,0xFB67,0x0000,0x0000,0xFB69,0xFB68,0x0000,0x0000,0x0000,0xFB6A,0x0000,
	0x0000,0x0000,0xE0E8,0x97D4,0x8BD5,0x94FA,0x9469,0x0000,0x0000,0x0000,0xE0E9,0x0000,0x0000,0x0000,0x0000,0xE0EB,
	0x0000,0xE0EE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE0EA,0x0000,0x0000,0x0000,0xE0ED,0x8CE8,0x896C,0xE0EF,0x0000,0x9090,0xE0EC,
	0x97DA,0x0000,0xFB6B,0xE0F2,0xEAA2,0x0000,0x0000,0x0000,0x0000,0xE0F0,0xE0F3,0x0000,0x0000,0x0000,0x0000,0xE0E5,
	0xE0F1,0x0000,0x0000,0x8DBA,0x0000,0x0000,0xE0F4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0F5,0x0000,
	0x0000,0x0000,0x0000,0x979E,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB6C,0x0000,0xE0F6,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0F7,0xFB6D,
	0x0000,0x0000,0xE0E3,0x0000,0x0000,0x0000,0x0000,0xE0F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8AC2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8EA3,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0F9,0x0000,0x0000,0x0000,0x0000,0xE0FA,
	0x0000,0x0000,0x0000,0x0000,0xE0FB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x895A,0x0000,0x0000,0x0000,
	0xE140,0x0000,0x955A,0xE141,0x0000,0x0000,0x8AA2,0xE142,0x0000,0xE143,0x0000,0x0000,0x0000,0x0000,0xE144,0x0000,
	0xE146,0xE147,0xE145,0x0000,0x0000,0x0000,0x9572,0xE149,0xE148,
};
static const WORD _ucs_to_sjis_7500_data []={ //7501 75FF
	       0xFB6E,0x0000,0xE14B,0xE14A,0xE14C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE14D,0xE14F,0xE14E,0x0000,
	0x0000,0x8D99,0x0000,0xE151,0x0000,0xE150,0x0000,0x0000,0x8AC3,0x0000,0x9072,0x0000,0x935B,0x0000,0xE152,0x90B6,
	0x0000,0x0000,0x0000,0x8E59,0x0000,0x8999,0xE153,0x0000,0x9770,0x0000,0x0000,0x95E1,0xE154,0x0000,0x0000,0xFAA8,
	0x9363,0x9752,0x8D62,0x905C,0x0000,0x0000,0x0000,0x926A,0x99B2,0x0000,0x92AC,0x89E6,0xE155,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE156,0x0000,0xE15B,0x0000,0x0000,0xE159,0xE158,0x9DC0,0x8A45,0xE157,0x0000,0x88D8,
	0x0000,0x94A8,0x0000,0x0000,0x94C8,0x0000,0x0000,0x0000,0x0000,0x97AF,0xE15C,0xE15A,0x927B,0x90A4,0x0000,0x0000,
	0x94A9,0x0000,0x954C,0x0000,0xE15E,0x97AA,0x8C6C,0xE15F,0x0000,0xE15D,0x94D4,0xE160,0x0000,0xE161,0x0000,0xFB6F,
	0x88D9,0x0000,0x0000,0x8FF4,0xE166,0x0000,0xE163,0x93EB,0xE162,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B45,
	0x0000,0x0000,0xE169,0x0000,0x0000,0x0000,0xE164,0xE165,0x0000,0xE168,0xE167,0x9544,0x0000,0x0000,0x9161,0x9160,
	0x0000,0x8B5E,0x0000,0x0000,0xE16A,0x0000,0x0000,0x0000,0x0000,0x0000,0xE16B,0x0000,0x0000,0xE16C,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE16E,0x0000,0xE16D,0x0000,0x0000,0x0000,0x0000,0x0000,0x8975,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE176,0x94E6,0xE170,0x0000,0xE172,0x0000,0x0000,0xE174,0x905D,0x0000,0x0000,0xE175,0xE173,0x8EBE,0x0000,
	0x0000,0x0000,0xE16F,0xE171,0x0000,0x9561,0x0000,0x8FC7,0x0000,0x0000,0xE178,0x0000,0x0000,0xE177,0x0000,0x0000,
	0x0000,0x0000,0xE179,0x0000,0x8EA4,0x8DAD,0x0000,0x0000,0x9397,0xE17A,0x0000,0x92C9,0x0000,0x0000,0xE17C,0x0000,
	0x0000,0x0000,0x979F,0xE17B,0x0000,0x0000,0x0000,0x0000,0x0000,0x9189,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE182,0x0000,0xE184,0xE185,0x9273,0x0000,0x0000,0x0000,0x0000,0x0000,0xE183,0x0000,0xE180,0x0000,0xE17D,0xE17E,
};
static const WORD _ucs_to_sjis_7600_data []={ //7601 76FE
	       0xE181,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE188,0x0000,0xE186,0x0000,0xE187,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE189,
	0xE18B,0xE18C,0xE18D,0x0000,0xE18E,0x0000,0x0000,0xE18A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE190,0x0000,0x0000,0x0000,0xE18F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE191,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x97C3,0x0000,0x0000,0x0000,0xE194,0xE192,0xE193,0x0000,0x0000,0x0000,0x8AE0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x96FC,0x0000,0x0000,0x0000,0x95C8,0x0000,0xE196,0x0000,0x0000,0x0000,0xE195,0x0000,0x0000,0x0000,
	0x0000,0xE197,0xE198,0x0000,0x0000,0x0000,0x0000,0xE19C,0xE199,0xE19A,0xE19B,0x0000,0xE19D,0x0000,0x0000,0x0000,
	0xE19E,0x0000,0xE19F,0x0000,0x0000,0x0000,0xE1A0,0x0000,0xE1A1,0x0000,0x94AD,0x936F,0xE1A2,0x9492,0x9553,0x0000,
	0xE1A3,0x0000,0xFB70,0xE1A4,0x9349,0x0000,0x8A46,0x8D63,0xE1A5,0x0000,0x0000,0xE1A6,0x0000,0x0000,0xE1A7,0x0000,
	0x8E48,0x0000,0x0000,0xE1A9,0x0000,0x0000,0xE1A8,0x0000,0x0000,0xE1AA,0xE1AB,0xFB73,0xFB71,0x0000,0xFB72,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB74,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x94E7,0x0000,
	0xE1AC,0x0000,0x0000,0x0000,0xE1AD,0x0000,0x0000,0xEA89,0xE1AE,0xE1AF,0xE1B0,0x0000,0x0000,0x0000,0x0000,0x8E4D,
	0x0000,0x0000,0xE1B1,0x9475,0x0000,0x0000,0x967E,0x0000,0x896D,0x0000,0x8976,0x0000,0x0000,0xE1B2,0x0000,0x0000,
	0x0000,0x0000,0xE1B4,0x0000,0x0000,0x0000,0xE1B3,0x9390,0x0000,0x0000,0x0000,0x90B7,0x9F58,0x0000,0xE1B5,0x96BF,
	0x0000,0xE1B6,0x0000,0x8AC4,0x94D5,0xE1B7,0x0000,0xE1B8,0x0000,0x0000,0xE1B9,0x0000,0x0000,0x0000,0x96DA,0x0000,
	0x0000,0x0000,0x96D3,0x0000,0x92BC,0x0000,0x0000,0x0000,0x918A,0x0000,0x0000,0xE1BB,0x0000,0x0000,0x8F82,
};
static const WORD _ucs_to_sjis_7700_data []={ //7701 77FC
	       0x8FC8,0x0000,0x0000,0xE1BE,0x0000,0x0000,0xE1BD,0xE1BC,0x94FB,0x0000,0x8AC5,0x8CA7,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1C4,0x0000,0x0000,0xE1C1,0x905E,
	0x96B0,0x0000,0x0000,0x0000,0xE1C0,0xE1C2,0xE1C3,0x0000,0x0000,0xE1BF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1C5,0xE1C6,0x0000,0x92AD,0x0000,0x8AE1,0x0000,0x0000,0x0000,
	0x9285,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB76,0xE1C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1C8,0xE1CB,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9087,0x0000,0x93C2,0x0000,0xE1CC,0x9672,0x0000,0xE1C9,0x0000,0x0000,0xE1CA,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1CF,0x0000,0x0000,0x0000,0x0000,0xE1CE,0xE1CD,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1D1,0x0000,0x0000,0xE1D0,0x0000,
	0x0000,0xE1D2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1D4,0x0000,
	0xE1D3,0x0000,0x0000,0x0000,0x0000,0x95CB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8F75,0x97C4,0x0000,0x0000,
	0xE1D5,0x0000,0x0000,0x93B5,0x0000,0x0000,0xE1D6,0x0000,0x0000,0xE1D7,0x0000,0xE1DB,0xE1D9,0xE1DA,0x0000,0xE1D8,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1DC,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1DD,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1DE,0x0000,0x0000,0xE1DF,0x96B5,0xE1E0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x96EE,0xE1E1,0x0000,0x926D,0x0000,0x948A,0x0000,0x8BE9,0x0000,0x0000,0x0000,0x925A,0xE1E2,0x8BB8,
	0x0000,0x0000,0x0000,0x90CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1E3,
};
static const WORD _ucs_to_sjis_7800_data []={ //7802 78FD
	              0x8DBB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1E4,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE1E5,0x0000,0x8CA4,0x8DD3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE1E7,0xFB78,0x0000,0x0000,0x0000,0x9375,0x8DD4,0x8B6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9643,0x0000,0x946A,0x0000,0x0000,0x0000,0x0000,0x0000,0x9376,0x0000,0x0000,0x0000,0x0000,0x8D7B,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE1E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB79,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8FC9,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xFB7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x97B0,0x8D64,0x0000,0x0000,0x8CA5,
	0x0000,0x0000,0x94A1,0x0000,0xE1EB,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB7B,0x0000,0xE1ED,0x0000,0x0000,0x0000,
	0x0000,0x8CE9,0x0000,0x0000,0x0000,0x0000,0xE1EC,0x92F4,0x0000,0x0000,0x0000,0x0000,0xE1EF,0x8A56,0xE1EA,0x0000,
	0x0000,0x94E8,0x0000,0x894F,0x0000,0x8DEA,0x0000,0x9871,0x0000,0x0000,0xE1EE,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE1F0,0x0000,0x0000,0x0000,0x95C9,0x0000,0x90D7,0xE1F2,0x0000,0x0000,0x0000,0x0000,0xE1F3,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE1F1,0x0000,0x0000,0x0000,0x0000,0x8A6D,0x0000,0xE1F9,0x0000,0xE1F8,0x0000,
	0x0000,0x8EA5,0x0000,0x0000,0x0000,0xE1FA,0xE1F5,0x0000,0x0000,0x0000,0xE1FB,0xE1F6,0x0000,0x0000,0x0000,0x0000,
	0x94D6,0xE1F4,0x0000,0x0000,0xE1F7,0x0000,0x0000,0x0000,0x0000,0x0000,0xE241,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE240,0x9681,0x0000,0x0000,0x0000,0xE1FC,0x0000,0x0000,0x88E9,
	0x0000,0x0000,0x0000,0x0000,0xE243,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE242,
};
static const WORD _ucs_to_sjis_7900_data []={ //7901 79FB
	       0x8FCA,0x0000,0x0000,0x0000,0x0000,0x0000,0xE244,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9162,0x0000,
	0x0000,0xE246,0xE245,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE247,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1E6,0x0000,0x0000,0x0000,0xE1E8,0xE249,0xE248,0x0000,0x0000,0x0000,
	0xFB7C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8EA6,0x0000,0x97E7,0x0000,0x8ED0,0x0000,
	0xE24A,0x8C56,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B5F,0x8B46,0x8E83,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9753,0x0000,0x0000,0xE250,0x0000,0xE24F,0x9163,0xE24C,0x0000,0x0000,0xE24E,0x0000,0x0000,0x8F6A,0x905F,0xE24D,
	0xE24B,0x0000,0x9449,0x0000,0x0000,0x8FCB,0x0000,0x0000,0x955B,0x0000,0x0000,0x0000,0x0000,0x8DD5,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9398,0x0000,0x0000,0xE251,0x0000,0x0000,0x0000,0x0000,0xE252,
	0xE268,0x8BD6,0x0000,0x0000,0x985C,0x9154,0x0000,0x0000,0x0000,0x0000,0xE253,0x0000,0x0000,0x89D0,0x92F5,0x959F,
	0x0000,0x0000,0x0000,0x0000,0xFB81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFB83,0x0000,0xE254,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B9A,0xE255,0x0000,0x0000,0xE257,0x0000,0x0000,0x0000,0xE258,0x0000,
	0x9448,0x0000,0x0000,0xE259,0x0000,0x0000,0x0000,0x0000,0x0000,0xE25A,0xE25B,0x0000,0x0000,0x8BD7,0x89D1,0x93C3,
	0x8F47,0x8E84,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE25C,0x0000,0x8F48,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x89C8,0x9562,0x0000,0x0000,0xE25D,0x0000,0x0000,0x94E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9164,
	0x0000,0xE260,0x0000,0xE261,0x9489,0x0000,0x9060,0xE25E,0x0000,0x9281,0x0000,0x0000,0xE25F,0x0000,0x0000,0x0000,
	0x8FCC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x88DA,
};
static const WORD _ucs_to_sjis_7A00_data []={ //7A00 7AFF
	0x8B48,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE262,0x0000,0x0000,0x92F6,0x0000,0xE263,0x90C5,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x96AB,0x0000,0x0000,0x9542,0xE264,0xE265,0x9274,0x0000,0x97C5,0x0000,0x0000,0xE267,
	0xE266,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8EED,0x0000,
	0x0000,0xE269,0x88EE,0x0000,0x0000,0x0000,0x0000,0xE26C,0x0000,0x0000,0x0000,0xE26A,0x89D2,0x8C6D,0xE26B,0x8D65,
	0x8D92,0x0000,0x95E4,0xE26D,0x0000,0x0000,0x9673,0x0000,0x0000,0xE26F,0x0000,0x0000,0x0000,0x90CF,0x896E,0x89B8,
	0x88AA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE26E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE270,0xE271,0x8FF5,0x0000,0x0000,0x0000,0x0000,0x0000,0xE272,0x0000,0x8A6E,0x0000,0x0000,0x0000,0x0000,
	0xE274,0x0000,0x0000,0x0000,0x8C8A,0x0000,0x8B86,0x0000,0x0000,0xE275,0x8BF3,0x0000,0x0000,0xE276,0x0000,0x90FA,
	0x0000,0x93CB,0x0000,0x90DE,0x8DF3,0x0000,0x0000,0x0000,0xE277,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9282,0x918B,0x0000,0xE279,0xE27B,0xE278,0xE27A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C41,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE27C,0x8C45,0x0000,0x0000,0x0000,0x8B87,0x9771,
	0xE27E,0x0000,0x0000,0x0000,0x0000,0x0000,0xE280,0x0000,0x0000,0x0000,0x894D,0x0000,0x0000,0x0000,0x0000,0xE283,
	0x0000,0x0000,0x0000,0x8A96,0xE282,0xE281,0x0000,0xE285,0xE27D,0x0000,0xE286,0x97A7,0x0000,0xE287,0x0000,0xE288,
	0x0000,0xFB84,0x9AF2,0xE28A,0x0000,0xE289,0x0000,0x0000,0x0000,0xE28B,0xE28C,0x0000,0x97B3,0xE28D,0x0000,0xE8ED,
	0x8FCD,0xE28E,0xE28F,0x8F76,0x0000,0x93B6,0xE290,0xFB85,0x0000,0x0000,0x9247,0xFB87,0x0000,0xE291,0x0000,0x925B,
	0xE292,0x0000,0x0000,0x0000,0x0000,0x0000,0x8BA3,0x0000,0x995E,0x927C,0x8EB1,0x0000,0x0000,0x0000,0x0000,0x8AC6,
};
static const WORD _ucs_to_sjis_7B00_data []={ //7B02 7BF7
	              0xE293,0x0000,0xE2A0,0x0000,0xE296,0x0000,0x8B88,0x0000,0xE295,0xE2A2,0x0000,0x0000,0x0000,0xE294,
	0x0000,0x8FCE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE298,0xE299,0x0000,0x934A,0x0000,0x0000,0xE29A,0x0000,
	0x8A7D,0x0000,0x0000,0x0000,0x0000,0x9079,0x9584,0x0000,0xE29C,0x0000,0x0000,0x0000,0x91E6,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE297,0x0000,0xE29B,0xE29D,0x0000,0x0000,0x8DF9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE2A4,0x954D,0x0000,0x94A4,0x9399,0x0000,0x8BD8,0xE2A3,0xE2A1,0x0000,0x94B3,
	0xE29E,0x927D,0x939B,0x0000,0x939A,0x0000,0x8DF4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2B6,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE2A6,0x0000,0xE2A8,0x0000,0x0000,0x0000,0x0000,0xE2AB,0x0000,0xE2AC,0x0000,
	0xE2A9,0xE2AA,0x0000,0x0000,0xE2A7,0xE2A5,0x0000,0x0000,0x0000,0x0000,0xE29F,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x95CD,0x89D3,0x0000,0x0000,0x0000,0xE2B3,0x0000,0xE2B0,0x0000,0xE2B5,
	0x0000,0x0000,0xE2B4,0x0000,0x9493,0x96A5,0x0000,0x8E5A,0xE2AE,0xE2B7,0xE2B2,0x0000,0xE2B1,0xE2AD,0xFB88,0xE2AF,
	0x0000,0x8AC7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x925C,0x0000,0x0000,0x90FB,0x0000,0x0000,
	0x0000,0x94A0,0x0000,0x0000,0xE2BC,0x0000,0x0000,0x0000,0x94A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x90DF,0xE2B9,0x0000,0x0000,0x94CD,0x0000,0xE2BD,0x95D1,0x0000,0x927A,0x0000,0xE2B8,0xE2BA,0x0000,0x0000,0xE2BB,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2BE,0x0000,0x0000,
	0x8EC2,0x0000,0x0000,0x0000,0x93C4,0xE2C3,0xE2C2,0x0000,0x0000,0xE2BF,0x0000,0x0000,0x0000,0x9855,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE2C8,0x0000,0x0000,0xE2CC,0xE2C9,
};
static const WORD _ucs_to_sjis_7C00_data []={ //7C00 7CFE
	0xE2C5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2C6,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2CB,0x0000,0x0000,
	0x0000,0xE2C0,0x99D3,0xE2C7,0xE2C1,0x0000,0x0000,0xE2CA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2D0,
	0x0000,0x8AC8,0x0000,0xE2CD,0x0000,0x0000,0x0000,0xE2CE,0x0000,0x0000,0xE2CF,0xE2D2,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2D1,0x94F4,0x0000,0x0000,0x0000,0x0000,0xE2D3,0x97FA,0x95EB,
	0xE2D8,0x0000,0x0000,0xE2D5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2D4,0x90D0,0x0000,0xE2D7,
	0xE2D9,0x0000,0x0000,0x0000,0xE2D6,0x0000,0xE2DD,0x0000,0xE2DA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2DB,
	0xE2C4,0x0000,0x0000,0x0000,0xE2DC,0xE2DE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2DF,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x95C4,0x0000,0xE2E0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x96E0,0x0000,
	0x0000,0x8BCC,0x8C48,0xE2E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x95B2,0x0000,0x9088,0x0000,0x96AE,0x0000,0x0000,
	0xE2E2,0x0000,0x97B1,0x0000,0x0000,0x9494,0x0000,0x9165,0x9453,0x0000,0x0000,0x8F6C,0x0000,0x0000,0x0000,0x88BE,
	0x0000,0xE2E7,0xE2E5,0x0000,0xE2E3,0x8A9F,0x0000,0x8FCF,0xE2E8,0x0000,0x0000,0xE2E6,0x0000,0xE2E4,0xE2EC,0x0000,
	0x0000,0xE2EB,0xE2EA,0xE2E9,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2ED,0x0000,0x0000,0x0000,0xE2EE,0x90B8,0x0000,
	0xE2EF,0x0000,0xE2F1,0x0000,0x0000,0xE2F0,0x0000,0x0000,0x0000,0x0000,0x8CD0,0x0000,0x0000,0x0000,0x9157,0x0000,
	0x0000,0x0000,0xE2F3,0x0000,0x0000,0x0000,0x939C,0x0000,0xE2F2,0x0000,0x0000,0x0000,0xE2F4,0x0000,0x95B3,0x918C,
	0x8D66,0x0000,0xE2F5,0x0000,0x0000,0x0000,0x0000,0x97C6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2F7,
	0x0000,0x0000,0xE2F8,0x0000,0xE2F9,0x0000,0xE2FA,0x0000,0x8E85,0x0000,0xE2FB,0x8C6E,0x0000,0x0000,0x8B8A,
};
static const WORD _ucs_to_sjis_7D00_data []={ //7D00 7DFB
	0x8B49,0x0000,0xE340,0x0000,0x96F1,0x8D67,0xE2FC,0x0000,0x0000,0x0000,0xE343,0x96E4,0x0000,0x945B,0x0000,0x0000,
	0x9552,0x0000,0x0000,0x0000,0x8F83,0xE342,0x0000,0x8ED1,0x8D68,0x8E86,0x8B89,0x95B4,0xE341,0x0000,0x0000,0x0000,
	0x9166,0x9661,0x8DF5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8E87,0x92DB,0x0000,0xE346,0x97DD,
	0x8DD7,0x0000,0xE347,0x9061,0x0000,0xE349,0x0000,0x0000,0x0000,0x8FD0,0x8DAE,0x0000,0x0000,0x0000,0x0000,0xE348,
	0x0000,0x0000,0x8F49,0x8CBC,0x9167,0xE344,0xE34A,0x0000,0xFB8A,0x0000,0x0000,0xE345,0x8C6F,0x0000,0xE34D,0xE351,
	0x8C8B,0x0000,0x0000,0x0000,0x0000,0x0000,0xE34C,0x0000,0x0000,0x0000,0x0000,0xE355,0xFB8B,0x0000,0x8D69,0x0000,
	0x0000,0x978D,0x88BA,0xE352,0x0000,0x0000,0x8B8B,0x0000,0xE34F,0x0000,0x0000,0x0000,0x0000,0x0000,0xE350,0x0000,
	0x0000,0x939D,0xE34E,0xE34B,0x0000,0x8A47,0x90E2,0x0000,0x0000,0x8CA6,0x0000,0x0000,0x0000,0xE357,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE354,0x0000,0x0000,0x0000,0x0000,0x0000,0xE356,
	0x0000,0x0000,0x0000,0xE353,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C70,0x91B1,0xE358,0x918E,0x0000,0x0000,0xE365,
	0xFB8D,0x0000,0xE361,0xE35B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE35F,0x8EF8,0x88DB,0xE35A,0xE362,
	0xE366,0x8D6A,0x96D4,0x0000,0x92D4,0xE35C,0x0000,0xFB8C,0xE364,0x0000,0xE359,0x925D,0x0000,0xE35E,0x88BB,0x96C8,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE35D,0x0000,0x0000,0x8BD9,0x94EA,0x0000,0x0000,0x0000,0x918D,
	0x0000,0x97CE,0x8F8F,0x0000,0x0000,0xE38E,0xFB8E,0x0000,0xE367,0x0000,0x90FC,0x0000,0xE363,0xE368,0xE36A,0x0000,
	0x92F7,0xE36D,0x0000,0x0000,0xE369,0x0000,0x0000,0x0000,0x95D2,0x8AC9,0x0000,0x0000,0x96C9,0x0000,0x0000,0x88DC,
	0x0000,0x0000,0xE36C,0x0000,0x97FB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE36B,
};
static const WORD _ucs_to_sjis_7E00_data []={ //7E01 7E9C
	       0x898F,0x0000,0x0000,0x93EA,0xE36E,0x0000,0x0000,0x0000,0xE375,0xE36F,0xE376,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE372,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x949B,0x0000,0x0000,0x8EC8,0xE374,
	0x0000,0xE371,0xE377,0xE370,0x0000,0x0000,0x8F63,0x0000,0x0000,0x0000,0x0000,0x9644,0x0000,0x0000,0x8F6B,0x0000,
	0x0000,0xE373,0xE380,0x0000,0x0000,0xE37B,0x0000,0xE37E,0x0000,0xE37C,0xE381,0xE37A,0x0000,0xE360,0x90D1,0x0000,
	0x0000,0x94C9,0x0000,0xE37D,0x0000,0x0000,0xE378,0x0000,0x0000,0x0000,0x9140,0x8C71,0x0000,0x8F4A,0x0000,0x0000,
	0x0000,0x0000,0xFB8F,0x0000,0x9044,0x9155,0xE384,0x0000,0x0000,0xE386,0xE387,0x0000,0x0000,0xE383,0xE385,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE379,0xE382,0x0000,0xE38A,0xE389,0x0000,0x0000,0x969A,0x0000,0x0000,
	0x8C4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE388,0x0000,0xE38C,0xE38B,0xE38F,0x0000,0xE391,
	0x0000,0x0000,0x8E5B,0xE38D,0x0000,0x0000,0x0000,0x0000,0xE392,0xE393,0xFA5C,0x0000,0xE394,0x0000,0xE39A,0x935A,
	0xE396,0x0000,0xE395,0xE397,0xE398,0x0000,0xE399,0x0000,0x0000,0x0000,0x0000,0xE39B,0xE39C,
};
static const WORD _ucs_to_sjis_7F00_data []={ //7F36 7FFC
	                                          0x8ACA,0x0000,0xE39D,0x0000,0xE39E,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE39F,0x0000,0xFB90,0x0000,0x0000,0x0000,0x0000,0xE3A0,0xE3A1,0xE3A2,0x0000,
	0xE3A3,0xE3A4,0x0000,0x0000,0xE3A6,0xE3A5,0x0000,0x0000,0xE3A7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3A8,
	0xE3A9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3AC,0xE3AA,0xE3AB,0x8DDF,0x8C72,0x0000,0x0000,0x9275,0x0000,
	0x94B1,0x0000,0x8F90,0x0000,0x0000,0x946C,0x0000,0x94EB,0xE3AD,0x9CEB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE3AE,0xE3B0,0x0000,0x9785,0xE3AF,0xE3B2,0xE3B1,0x0000,0x9772,0x0000,0xE3B3,0x0000,0x94FC,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE3B4,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3B7,0x0000,0x0000,0xE3B6,0xE3B5,0x0000,
	0x0000,0xFB91,0x0000,0xE3B8,0x8C51,0x0000,0x0000,0x0000,0x9141,0x8B60,0x0000,0x0000,0x0000,0x0000,0xE3BC,0xE3B9,
	0x0000,0x0000,0xE3BA,0x0000,0x0000,0x0000,0xE3BD,0x0000,0xE3BE,0xE3BB,0x0000,0x0000,0x0000,0x8948,0x0000,0x0000,
	0x0000,0x89A5,0x0000,0x0000,0x0000,0xE3C0,0xE3C1,0x0000,0x0000,0x0000,0xE3C2,0x0000,0x9782,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8F4B,0x0000,0xE3C4,0xE3C3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9089,0xE3C5,0x0000,0x0000,0x0000,0x0000,0xE3C6,0x0000,0x0000,0xE3C7,0x0000,0x8AE3,0x0000,0x0000,0x0000,0x0000,
	0x8ACB,0x0000,0x0000,0xE3C8,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3C9,0x0000,0x967C,0x9783,
};
static const WORD _ucs_to_sjis_8000_data []={ //8000 80FD
	0x9773,0x9856,0x0000,0x8D6C,0xE3CC,0x8ED2,0xE3CB,0x0000,0x0000,0x0000,0x0000,0xE3CD,0x8EA7,0x0000,0x0000,0x0000,
	0x91CF,0x0000,0xE3CE,0x0000,0x0000,0x8D6B,0x0000,0x96D5,0xE3CF,0xE3D0,0x0000,0x0000,0xE3D1,0x0000,0x0000,0x0000,
	0x0000,0xE3D2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3D3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x8EA8,0x0000,0x0000,0x96EB,0x0000,0x0000,0x0000,0x0000,0xE3D5,0x0000,0x925E,0x0000,0xE3D4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3D7,0x0000,0x0000,0x0000,0xE3D6,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE3D8,0x0000,0x0000,0x0000,0x90B9,0x0000,0xE3D9,0x0000,0xE3DA,0x0000,0x0000,0x0000,0x95B7,0xE3DB,
	0x0000,0x918F,0xE3DC,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3DD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x97FC,
	0xE3E0,0x0000,0xE3DF,0xE3DE,0x92AE,0x0000,0xE3E1,0x9045,0x0000,0xE3E2,0x0000,0x0000,0x0000,0xE3E3,0x9857,0xE3E4,
	0x0000,0x0000,0x0000,0x0000,0xE3E5,0xE3E7,0xE3E6,0x94A3,0x0000,0x93F7,0x0000,0x985D,0x94A7,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE3E9,0x0000,0x0000,0x8FD1,0x0000,0x9549,0x0000,0xE3EA,0xE3E8,0x0000,0x8ACC,0x0000,0x0000,
	0x0000,0x8CD2,0x8E88,0x0000,0x0000,0x94EC,0x0000,0x0000,0x0000,0x8CA8,0x9662,0x0000,0xE3ED,0xE3EB,0x0000,0x8D6D,
	0x0000,0x8D6E,0x88E7,0x0000,0x8DE6,0x0000,0x0000,0x0000,0x0000,0x0000,0x9478,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x88DD,0xE3F2,0x0000,0x925F,0x0000,0x0000,0x0000,0x0000,0x0000,0x9477,0x0000,0x91D9,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3F4,0x0000,0x0000,0xE3F0,0xE3F3,0xE3EE,0x0000,0xE3F1,0x9645,0x0000,
	0x0000,0x8CD3,0x0000,0x0000,0x88FB,0xE3EF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3F6,
	0x0000,0xE3F7,0x0000,0x0000,0x93B7,0x0000,0x0000,0x0000,0x8BB9,0x0000,0x0000,0x0000,0xE445,0x945C,
};
static const WORD _ucs_to_sjis_8100_data []={ //8102 81FE
	              0x8E89,0x0000,0x0000,0x8BBA,0x90C6,0x9865,0x96AC,0xE3F5,0x90D2,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B72,0xE3F8,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE3FA,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3F9,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3FB,
	0x0000,0x9245,0x0000,0x945D,0x0000,0x0000,0x0000,0x0000,0x0000,0x92AF,0x0000,0x0000,0x0000,0x0000,0xE442,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE441,0x0000,0x0000,0x0000,0x0000,0xE3FC,0x0000,0x0000,0x9074,0x0000,
	0x9585,0xE444,0x0000,0xE443,0x8D6F,0x9872,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE454,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE448,0xE449,0x0000,0x0000,0x0000,0x0000,0x8EEE,0x0000,0x0000,0xE447,0x0000,
	0x8D98,0xE446,0x0000,0x0000,0xE44A,0x0000,0x0000,0x0000,0x92B0,0x95A0,0x9142,0x0000,0x0000,0x0000,0x0000,0x91DA,
	0xE44E,0x0000,0xE44F,0xE44B,0x0000,0x0000,0x0000,0x0000,0xE44C,0x0000,0xE44D,0x0000,0x0000,0x0000,0x0000,0x8D70,
	0x0000,0x0000,0x0000,0xE455,0x0000,0xE451,0x0000,0x0000,0x0000,0x0000,0x9586,0x0000,0x968C,0x9547,0x0000,0x0000,
	0xE450,0x0000,0x0000,0xE453,0xE452,0x0000,0x0000,0x0000,0x9663,0xE456,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE457,0x0000,0x0000,0x9156,0x0000,0xE458,0x0000,0x0000,0xE45A,0x0000,0xE45E,0x0000,0x0000,0xE45B,0xE459,0x945E,
	0xE45C,0x0000,0xE45D,0x0000,0x0000,0x0000,0x89B0,0x0000,0xE464,0xE45F,0x0000,0x0000,0x0000,0xE460,0x0000,0x0000,
	0x0000,0xE461,0x0000,0x919F,0x0000,0x0000,0x0000,0x0000,0xE463,0xE462,0xE465,0x0000,0x0000,0x0000,0x0000,0xE466,
	0xE467,0x0000,0x0000,0x9062,0x0000,0x89E7,0x0000,0xE468,0x97D5,0x0000,0x8EA9,0x0000,0x0000,0x8F4C,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x8E8A,0x9276,0x0000,0x0000,0x0000,0x0000,0x0000,0xE469,0xE46A,0x8950,0x0000,0xE46B,
};
static const WORD _ucs_to_sjis_8200_data []={ //8201 82FB
	       0xE46C,0xE46D,0x0000,0x0000,0xE46E,0x0000,0xE46F,0x8BBB,0x9DA8,0xE470,0x0000,0x90E3,0xE471,0x8EC9,0x0000,
	0xE472,0x0000,0x98AE,0x0000,0x0000,0x0000,0xE473,0x95DC,0x8ADA,0x0000,0x0000,0x9143,0x8F77,0x0000,0x9591,0x8F4D,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE474,0x8D71,0xE475,0x94CA,0x0000,0xE484,0x0000,
	0x0000,0x0000,0x0000,0xE477,0x0000,0x91C7,0x9495,0x8CBD,0xE476,0x9144,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE478,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x92F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE47A,0xE479,0xE47C,0x0000,0x0000,0xE47B,0x0000,0xE47D,
	0x0000,0x0000,0xE480,0x0000,0xE47E,0x0000,0x8ACD,0x0000,0xE481,0x0000,0xE482,0xE483,0x0000,0x0000,0x8DAF,0x97C7,
	0x0000,0xE485,0x9046,0x0000,0x0000,0x0000,0x8990,0xE486,0xE487,0x0000,0x0000,0x0000,0x0000,0x0000,0xE488,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x88F0,0x0000,0xE489,0x0000,0x0000,
	0x0000,0x0000,0xE48A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9587,0x0000,0x0000,0x0000,0x8EC5,0x0000,0xE48C,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x8A48,0x88B0,0x0000,0x0000,0x0000,0x0000,0xE48B,0xE48E,0x946D,0x0000,0x9063,
	0x0000,0x89D4,0x0000,0x9646,0x0000,0x0000,0x0000,0x0000,0x8C7C,0x8BDA,0x0000,0xE48D,0x0000,0x89E8,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x8AA1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x8991,0xE492,0x97E8,0x91DB,0x0000,0x0000,0x9563,0x0000,0xE49E,0x0000,0x89D5,0xE49C,0x0000,0xE49A,0xE491,
	0x0000,0xE48F,0x0000,0xE490,0x0000,0x8EE1,0x8BEA,0x9297,0x0000,0x0000,0x0000,0x93CF,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x8970,0x0000,0xE494,0xE493,0x0000,0x0000,0x0000,0x0000,0xE499,0xE495,0xE498,
};
static const WORD _ucs_to_sjis_8300_data []={ //8301 83FD
	       0xFB93,0x96CE,0xE497,0x89D6,0x8A9D,0xE49B,0x0000,0x0000,0xE49D,0x0000,0x0000,0x0000,0x0000,0x8C73,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4A1,0xE4AA,0xE4AB,0x0000,0x0000,0x0000,0x88A9,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE4B2,0x0000,0x0000,0x0000,0x0000,0x88EF,0x0000,0x0000,0xE4A9,0x0000,0x0000,0x0000,0xE4A8,
	0x0000,0xE4A3,0xE4A2,0x0000,0xE4A0,0xE49F,0x9283,0x0000,0x91F9,0xE4A5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE4A4,0x0000,0x0000,0x0000,0x0000,0xE4A7,0x0000,0x0000,0x0000,0x9190,0x8C74,0x0000,0x0000,0x0000,0x0000,0x8960,
	0xE4A6,0x0000,0x8D72,0x0000,0x0000,0x0000,0x0000,0x0000,0x9191,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xFB94,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE4B8,0x0000,0xE4B9,0x0000,0x89D7,0x0000,0x0000,0x0000,0x89AC,0xE4B6,0x0000,0x0000,0xFB95,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE4AC,0x0000,0xE4B4,0x0000,0xE4BB,0xE4B5,0x0000,0x0000,0x0000,0xE4B3,0x0000,
	0x0000,0x0000,0x0000,0xE496,0x0000,0x0000,0xE4B1,0x0000,0x0000,0x0000,0xE4AD,0x0000,0x0000,0x0000,0x8ACE,0xE4AF,
	0xE4BA,0x0000,0xE4B0,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4BC,0x0000,0xE4AE,0x949C,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9789,0x0000,0x0000,0x0000,0xE4B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4CD,0x0000,0x0000,
	0x0000,0xE4C5,0x0000,0x0000,0x0000,0x909B,0x0000,0xFB96,0x0000,0x0000,0x8B65,0x0000,0x8BDB,0x0000,0xE4C0,0x0000,
	0x0000,0x0000,0x0000,0x89D9,0x0000,0x0000,0x8FD2,0x0000,0xE4C3,0x0000,0x0000,0x0000,0x8DD8,0x0000,0x0000,0x9370,
	0xE4C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x95EC,0x0000,0xE4BF,0x0000,0x0000,0x0000,0x89D8,
	0x8CD4,0x9548,0xE4C9,0x0000,0xE4BD,0x0000,0xFB97,0xE4C6,0x0000,0x0000,0x0000,0xE4D0,0x0000,0xE4C1,
};
static const WORD _ucs_to_sjis_8400_data []={ //8403 84FF
	                     0xE4C2,0x93B8,0x0000,0x0000,0xE4C7,0x0000,0x0000,0x0000,0xE4C4,0x9647,0xE4CA,0x88DE,0x0000,
	0x0000,0x0000,0x0000,0xE4BE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE4CC,0x0000,0xE4CB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x948B,0xE4D2,0x0000,0xE4DD,0x0000,0x0000,0x0000,
	0x0000,0x8A9E,0x0000,0x0000,0x0000,0xE4E0,0x0000,0x0000,0xE4CE,0x0000,0x0000,0x0000,0xE4D3,0x978E,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4DC,0x0000,0xFB98,0x9774,0x0000,0x0000,0x0000,0x0000,0x97A8,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9298,0x0000,0x0000,0x0000,0x8A8B,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x9592,0xE4E2,0x939F,0x0000,0x0000,0x88AF,0x0000,0x0000,0xE4DB,0x0000,0xE4D7,0x9192,0xE4D1,0xE4D9,0xE4DE,
	0x0000,0x944B,0x0000,0x0000,0x0000,0x88A8,0x0000,0xE4D6,0x0000,0xE4DF,0x9598,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE4DA,0x0000,0xE4D5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8FD3,0x0000,0x0000,0x0000,0x0000,
	0x8F4E,0x0000,0x0000,0x0000,0x8EAA,0x0000,0x0000,0x0000,0x0000,0x96D6,0x0000,0x0000,0x9566,0x0000,0x0000,0xE4E5,
	0x0000,0xE4EE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4D8,0x0000,0x0000,
	0x0000,0x0000,0x8A97,0x0000,0xFB99,0x0000,0x0000,0x0000,0x8FF6,0xE4E3,0x0000,0xE4E8,0x9193,0x0000,0x0000,0xE4E4,
	0x0000,0xE4EB,0x0000,0x0000,0x927E,0x0000,0xE4EC,0x0000,0x0000,0x9775,0xE4E1,0x8A57,0x0000,0xE4E7,0x0000,0x0000,
	0xE4EA,0x96AA,0x0000,0x0000,0x0000,0x0000,0xE4ED,0x0000,0x0000,0xE4E6,0xE4E9,0x0000,0xFA60,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9648,0x0000,0x9840,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE4F1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4F8,0x0000,0x0000,0xE4F0,
};
static const WORD _ucs_to_sjis_8500_data []={ //8500 85FE
	0x8EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4CF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x95CC,0x0000,0x96A0,0xE4F7,0xE4F6,0x0000,0xE4F2,0xE4F3,0x0000,0x8955,0x0000,0x0000,0x0000,0x0000,0xE4F5,
	0x0000,0xE4EF,0x0000,0x0000,0x0000,0x0000,0x92D3,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4F4,0x88FC,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x91A0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x95C1,0x0000,0x0000,
	0xE4F9,0xE540,0x0000,0x94D7,0x0000,0x0000,0x0000,0x0000,0xE4FC,0x8FD4,0x8EC7,0xE542,0x0000,0x0000,0x8BBC,0x0000,
	0x0000,0x0000,0x0000,0xFB9A,0x0000,0xE543,0x0000,0x9599,0xE4FB,0xFB9B,0xE4D4,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE4FA,0x0000,0x0000,0x0000,0x0000,0x986E,0x93A0,0x9593,0xFB9C,0x0000,0xE54A,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE550,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE551,0x0000,
	0xE544,0x0000,0x0000,0x0000,0x9496,0x0000,0x0000,0xE54E,0xE546,0x0000,0xE548,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE552,0xE547,0x0000,0x0000,0xE54B,0x0000,0x0000,0x8992,0x0000,0x93E3,0x0000,0xE54C,0xE54F,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE545,0x0000,0x9145,0x0000,0xE549,0x8E46,0x9064,0x8C4F,0x96F2,0x0000,0x96F7,0x8F92,
	0xFB9E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE556,0xE554,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x986D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE553,0x0000,0x0000,0x0000,0x9795,0x0000,0xE555,
	0xE557,0x0000,0x0000,0x0000,0x0000,0xE558,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE55B,0xE559,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x93A1,0xE55A,0x0000,0x0000,0x0000,0x94CB,0xE54D,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8F93,0x0000,0xE55C,0xE561,0x9194,0x0000,0x0000,0xE560,
};
static const WORD _ucs_to_sjis_8600_data []={ //8602 86FE
	              0xE541,0x0000,0x0000,0x0000,0xE562,0x9168,0x0000,0x0000,0xE55D,0xE55F,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE55E,0x0000,0x0000,0x9F50,0x9F41,0x0000,0x0000,0xE564,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE563,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9796,0x0000,0xE1BA,
	0xE565,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE566,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE567,0x8CD5,0x0000,
	0x8B73,0x0000,0x0000,0x0000,0xE569,0x997C,0x0000,0x0000,0x0000,0x0000,0x8B95,0x0000,0x97B8,0x0000,0x8BF1,0xE56A,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE56B,0x0000,0x0000,0x0000,0x928E,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE56C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x93F8,0x0000,0x88B8,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89E1,0xE571,0xE572,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE56D,0x0000,0x8E5C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE56E,0x9461,0x0000,0x0000,0x0000,0x0000,0xE56F,0xE570,0xE57A,0x0000,0x0000,0x0000,0xE574,
	0xE577,0x0000,0x0000,0x0000,0x0000,0x0000,0xE573,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE575,0x0000,0xE576,0x8ED6,0x0000,0xE578,0x0000,0x9260,0x0000,0x8C75,0x8A61,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE57B,0x0000,0x0000,0x0000,0x0000,0x8A5E,0x0000,0xE581,0x0000,0x0000,0xE57C,0xE580,
	0x0000,0x0000,0x0000,0x0000,0x94B8,0x0000,0x0000,0x0000,0x0000,0xE57D,0x0000,0x0000,0xE57E,0x9567,0x94D8,0xE582,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x91FB,0xE58C,0x0000,0xE588,0x0000,0x0000,0x89E9,
};
static const WORD _ucs_to_sjis_8700_data []={ //8700 87FE
	0xE586,0x0000,0x9649,0xE587,0x0000,0x0000,0xE584,0x0000,0xE585,0xE58A,0xE58D,0x0000,0x0000,0xE58B,0x0000,0x0000,
	0x0000,0xE589,0xE583,0x0000,0x0000,0x0000,0x0000,0x0000,0x9277,0x0000,0xE594,0x0000,0x96A8,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE592,0x0000,0x0000,0x0000,0xE593,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE58E,0x0000,0x0000,0xE590,0x0000,0x0000,0x0000,0xE591,0x0000,0x0000,0x0000,0xE58F,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x90E4,0x0000,0x9858,0xE598,0x0000,0xE599,0x0000,
	0x0000,0x0000,0x0000,0xE59F,0x0000,0x9049,0x0000,0xE59B,0x0000,0xE59E,0x0000,0x0000,0x0000,0x0000,0x0000,0xE596,
	0xE595,0x0000,0x0000,0xE5A0,0x0000,0x0000,0x89DA,0x0000,0xE59C,0x0000,0xE5A1,0x0000,0x0000,0x0000,0xE59D,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE59A,0x0000,0x92B1,0x0000,0xE597,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9488,
	0x0000,0x0000,0xE5A5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x975A,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5A4,
	0x0000,0x0000,0xE5A3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5AC,0x0000,0x0000,0x0000,0xE5A6,
	0x0000,0x0000,0x0000,0xE5AE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9786,0xE5B1,0x0000,0xE5A8,0x0000,0x0000,
	0xE5A9,0x0000,0x0000,0x0000,0xE5AD,0x0000,0xE5B0,0xE5AF,0x0000,0x0000,0x0000,0xE5A7,0x0000,0x0000,0x0000,0x0000,
	0xE5AA,0x0000,0xE5BB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE5B4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5B2,
	0x0000,0x0000,0xE5B3,0x0000,0x0000,0x0000,0xE5B8,0xE5B9,0x0000,0x8A49,0x0000,0x8B61,0x0000,0x0000,0xE5B7,
};
static const WORD _ucs_to_sjis_8800_data []={ //8805 88FE
	                                   0xE5A2,0x0000,0xFBA1,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5B6,0xE5BA,0xE5B5,
	0x0000,0xE5BC,0x0000,0x0000,0x0000,0xE5BE,0xE5BD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE5C0,0xE5BF,0xE579,0x0000,0x0000,0x0000,0xE5C4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE5C1,0x0000,0x0000,0x0000,0x0000,0xE5C2,0x0000,0x0000,0xE5C3,0x0000,0xE5C5,0x0000,0x0000,0x0000,0x0000,
	0x8C8C,0x0000,0xE5C7,0x0000,0xE5C6,0x0000,0x8F4F,0x0000,0x0000,0x0000,0x0000,0x0000,0x8D73,0x9FA5,0x0000,0x0000,
	0x0000,0x0000,0xE5C8,0x8F70,0x0000,0x0000,0x0000,0x8A58,0x0000,0xE5C9,0x0000,0x8971,0x0000,0x8FD5,0xE5CA,0x0000,
	0x0000,0x8D74,0xE5CB,0x88DF,0x0000,0x0000,0x0000,0x0000,0x955C,0x0000,0x0000,0xE5CC,0x0000,0x0000,0x0000,0x0000,
	0x908A,0x0000,0xE5D3,0x0000,0x0000,0xE5D0,0x0000,0x928F,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5D1,0xE5CE,0x8BDC,
	0x0000,0xE5CD,0xE5D4,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C55,0x0000,0x0000,0x91DC,0x0000,0xE5DA,0x0000,0x0000,
	0x0000,0x0000,0xE5D6,0x0000,0x0000,0x0000,0x91B3,0xE5D5,0x0000,0xE5D8,0x0000,0x0000,0x0000,0x0000,0xE5CF,0x0000,
	0x0000,0x0000,0xE5D9,0x0000,0xE5DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x94ED,0x0000,0x0000,0xE5D7,0x0000,
	0xE5DC,0xE5DE,0x0000,0x0000,0x8CD1,0xE5D2,0x0000,0x88BF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5DD,
	0x0000,0x8DD9,0x97F4,0xE5DF,0xE5E0,0x9195,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x97A0,
	0x0000,0x0000,0x0000,0x0000,0xE5E1,0x9754,0x0000,0x0000,0xE5E2,0xE5E3,0x0000,0x0000,0x95E2,0xE5E4,0x0000,0x8DBE,
	0x0000,0x97A1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE5EA,0x8FD6,0xE5E8,0xFBA2,0x0000,0x0000,0x9787,0xE5E5,0x0000,0x0000,0xE5E7,0x90BB,0x909E,
};
static const WORD _ucs_to_sjis_8900_data []={ //8902 89F8
	              0xE5E6,0x0000,0xE5EB,0x0000,0x0000,0x95A1,0x0000,0x0000,0xE5ED,0x0000,0xE5EC,0x0000,0x0000,0x0000,
	0x8A8C,0x0000,0x964A,0xE5EE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFA5D,0xE5FA,0xE5F0,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE5F1,0x0000,0x0000,0x0000,0x0000,0xE5F2,0xE5F3,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5F7,0x0000,0xE5F8,0x0000,0x0000,0xE5F6,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE5F4,0x0000,0xE5EF,0xE5F5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5F9,0xE8B5,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x89A6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5FC,0x8BDD,
	0xE5FB,0x0000,0x0000,0x0000,0xE641,0x0000,0xE640,0x0000,0x0000,0x0000,0xE643,0x0000,0x0000,0xE642,0x0000,0xE644,
	0x0000,0x0000,0x8F50,0x0000,0xE645,0x0000,0x0000,0xE646,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE647,0x90BC,
	0x0000,0x9776,0x0000,0xE648,0x0000,0x0000,0x95A2,0x9465,0xE649,0x0000,0xE64A,0x8CA9,0x0000,0x0000,0x0000,0x8B4B,
	0x0000,0x0000,0x0000,0xE64B,0x0000,0x0000,0x8E8B,0x9460,0xE64C,0x0000,0x8A6F,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE64D,0x0000,0x0000,0x0000,0x0000,0xE64F,0x9797,0x0000,0xE64E,0x9065,0x0000,0xE650,0x0000,0x0000,0xE651,
	0x0000,0x0000,0xE652,0x8ACF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE653,0x0000,0x0000,0xE654,0x0000,0xE655,
	0xE656,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x8A70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE657,0x0000,0xE658,0xE659,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x89F0,0x0000,0x0000,0x9047,0xE65A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE65B,0x0000,0x0000,0x0000,0xE65C,
};
static const WORD _ucs_to_sjis_8A00_data []={ //8A00 8AFE
	0x8CBE,0x0000,0x92F9,0xE65D,0x0000,0x0000,0x0000,0x0000,0x8C76,0x0000,0x9075,0x0000,0xE660,0x0000,0x93A2,0x0000,
	0xE65F,0x0000,0xFBA3,0x8C50,0x0000,0x0000,0xE65E,0x91F5,0x8B4C,0x0000,0x0000,0xE661,0x0000,0xE662,0x0000,0x8FD7,
	0x0000,0x0000,0x0000,0x8C8D,0x0000,0xE663,0x0000,0x0000,0x0000,0x0000,0x964B,0x0000,0x0000,0x90DD,0x0000,0x0000,
	0x0000,0x8B96,0x0000,0x96F3,0x9169,0x0000,0xE664,0xFBA4,0x0000,0x0000,0x9066,0x9290,0x8FD8,0x0000,0x0000,0x0000,
	0x0000,0xE665,0x0000,0x0000,0x0000,0x0000,0xE668,0x0000,0xE669,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8DBC,0x91C0,0xE667,0x0000,0x8FD9,0x955D,0x0000,0x0000,0x0000,0x0000,0x0000,0xE666,0x0000,0x0000,0x8E8C,0x0000,
	0x8972,0x0000,0xE66D,0x8C77,0x0000,0x0000,0x8E8E,0x0000,0x0000,0x8E8D,0x0000,0x986C,0xE66C,0xE66B,0x9146,0x0000,
	0x8B6C,0x9862,0x8A59,0x8FDA,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBA5,0x0000,0x0000,0xE66A,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE66F,0x0000,0xE670,0xE66E,0x0000,0x8CD6,0x0000,0x975F,0x0000,0x0000,0x8E8F,0x9446,0x0000,0x0000,
	0x0000,0xE673,0x0000,0x90BE,0x0000,0x9261,0x0000,0x0000,0x9755,0x0000,0xE676,0x0000,0x0000,0x0000,0x8CEA,0x0000,
	0x90BD,0xE672,0x0000,0xE677,0x8CEB,0xE674,0xE675,0xFBA6,0xE671,0x0000,0x0000,0x0000,0x90E0,0x93C7,0x0000,0x0000,
	0x924E,0x0000,0x89DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x94EE,0x0000,0x0000,0x8B62,0x0000,0xFBA7,0x92B2,
	0x0000,0x0000,0xE67A,0x0000,0xE678,0x0000,0x0000,0x926B,0x0000,0x0000,0x0000,0x90BF,0x8AD0,0xE679,0x0000,0x907A,
	0x0000,0x0000,0x97C8,0x0000,0x0000,0x0000,0x985F,0x0000,0x0000,0x0000,0xE67B,0xE687,0x92B3,0x0000,0xE686,0xFBA8,
	0xE683,0xE68B,0xE684,0x0000,0xE680,0x0000,0x92FA,0xE67E,0x0000,0x0000,0x0000,0xE67C,0x0000,0x9740,0x8E90,0x0000,
	0x0000,0xE681,0x0000,0xE67D,0x0000,0x0000,0xFBAA,0xE685,0x8F94,0x0000,0x8CBF,0x0000,0x0000,0x0000,0x91F8,
};
static const WORD _ucs_to_sjis_8B00_data []={ //8B00 8B9A
	0x9664,0x8979,0x88E0,0x0000,0x93A3,0x0000,0x0000,0xE689,0x0000,0x0000,0x0000,0x0000,0xE688,0x0000,0x93E4,0x0000,
	0xE68D,0x0000,0x0000,0x0000,0xE682,0x0000,0xE68C,0xE68E,0x0000,0x8CAA,0xE68A,0x8D75,0x0000,0x8ED3,0x0000,0x0000,
	0xE68F,0x9777,0x0000,0x0000,0x0000,0x0000,0xE692,0x0000,0xE695,0x0000,0x0000,0xE693,0x9554,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE690,0x0000,0x0000,0x0000,0x0000,0x0000,0x8BDE,0x0000,0x0000,0x0000,0x0000,0xE694,0x0000,
	0x0000,0xE696,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE69A,0x0000,0x0000,0xE697,0x0000,0xE699,0xE698,
	0x0000,0x0000,0x0000,0xFBAB,0x0000,0x0000,0xE69B,0x0000,0x8EAF,0x0000,0xE69D,0xE69C,0x9588,0x0000,0x0000,0xE69F,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C78,0x0000,0x0000,0x0000,0x0000,0xE69E,0xE6A0,0x0000,0x0000,0xE6A1,
	0x8B63,0xE3BF,0x8FF7,0x0000,0xE6A2,0x0000,0x0000,0x8CEC,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6A3,0x0000,0xFBAC,
	0xE6A4,0x0000,0x0000,0x8E5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9DCC,0x0000,0xE6A5,0x0000,0xE6A6,0x0000,
	0x8F51,0x0000,0xE6A7,0xE6A8,0x0000,0x0000,0xE6A9,0x0000,0x0000,0xE6AA,0xE6AB,
};
static const WORD _ucs_to_sjis_8C00_data []={ //8C37 8CFD
	                                                 0x924A,0x0000,0x0000,0xE6AC,0x0000,0x0000,0x0000,0x0000,0xE6AE,
	0x0000,0xE6AD,0x0000,0x0000,0x0000,0x0000,0x93A4,0x0000,0xE6AF,0x0000,0x964C,0x0000,0xE6B0,0x0000,0xE6B1,0x0000,
	0xE6B2,0x0000,0x0000,0x0000,0x0000,0xE6B3,0x0000,0x0000,0x0000,0x0000,0x93D8,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x8FDB,0xE6B4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8D8B,0x98AC,0xE6B5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6B6,0x955E,0xE6B7,0x0000,0xE6BF,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE6B8,0x0000,0x0000,0xE6BA,0x0000,0x0000,0x0000,0xE6B9,0xE6BB,0x0000,0x9665,0xE6BC,0xE6BD,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE6BE,0x0000,0x0000,0x0000,0xE6C0,0x0000,0x0000,0x0000,0x0000,0x8A4C,0x92E5,0x0000,
	0x9589,0x8DE0,0x8D76,0x0000,0x0000,0x0000,0x0000,0x956E,0x89DD,0x94CC,0xE6C3,0x8AD1,0x90D3,0xE6C2,0xE6C7,0x9299,
	0x96E1,0x0000,0xE6C5,0xE6C6,0x8B4D,0x0000,0xE6C8,0x9483,0x91DD,0x0000,0x0000,0x94EF,0x935C,0xE6C4,0x0000,0x9666,
	0x89EA,0xE6CA,0x9847,0x92C0,0x9864,0x0000,0x0000,0x8E91,0xE6C9,0x0000,0x91AF,0x0000,0x0000,0xE6DA,0x9147,0x0000,
	0x0000,0x93F6,0x0000,0x956F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6CD,0x8E5E,0x8E92,0x0000,0x8FDC,0x0000,
	0x9485,0x0000,0x8CAB,0xE6CC,0xE6CB,0x0000,0x958A,0x0000,0x0000,0x0000,0x8EBF,0x0000,0x0000,0x9371,0x0000,0x0000,
	0xFBAD,0x0000,0x0000,0x0000,0xFBAE,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6CF,0xE6D0,0x8D77,0xE6CE,
};
static const WORD _ucs_to_sjis_8D00_data []={ //8D04 8DFF
	                            0xE6D1,0xE6D2,0x0000,0xE6D4,0x91A1,0x0000,0xE6D3,0x8AE4,0x0000,0xE6D6,0x0000,0xE6D5,
	0xE6D7,0x0000,0xFBAF,0xE6D9,0xE6DB,0x0000,0xE6DC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x90D4,0x0000,0x8ECD,0xE6DD,0x0000,0x0000,0x0000,0x8A71,0x0000,0xE6DE,0x0000,0x0000,
	0x9196,0xE6DF,0x0000,0xE6E0,0x958B,0x0000,0xFBB0,0x8B4E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE6E1,0x0000,0x0000,0x0000,0x92B4,0x0000,0x0000,0x0000,0x0000,0x897A,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6E2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x8EEF,0x0000,0x0000,0x0000,0x0000,0x9096,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x91AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6E5,0x0000,0x0000,0x0000,0xE6E4,0x0000,
	0x0000,0x0000,0xE6E3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6EB,0xE6E9,0x0000,0x0000,0xE6E6,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6E8,0x0000,0x0000,0x0000,0xE6E7,0xE6EA,0x0000,0x8B97,0x0000,0xE6EE,
	0x0000,0x90D5,0x0000,0xE6EF,0x0000,0x0000,0x0000,0x0000,0x8CD7,0x0000,0xE6EC,0xE6ED,0x0000,0x0000,0x0000,0x9848,
	0x0000,0x0000,0x0000,0x92B5,0x0000,0x9148,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6F0,0x0000,0x0000,0xE6F3,
};
static const WORD _ucs_to_sjis_8E00_data []={ //8E08 8EFE
	                                                        0xE6F1,0xE6F2,0x9778,0x0000,0x0000,0x0000,0x0000,0x93A5,
	0xE6F6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6F4,0xE6F5,0xE6F7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE748,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE6FA,0x0000,0x0000,0x0000,0xE6FB,0xE6F9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE6F8,0x0000,0x92FB,0x0000,0x0000,0xE740,0xE744,0xE741,0xE6FC,0x0000,0xE742,0x0000,0x0000,0x0000,
	0xE743,0x0000,0x0000,0x0000,0x0000,0xE74A,0x0000,0x0000,0x0000,0xE745,0x0000,0x0000,0x0000,0x0000,0x0000,0x90D6,
	0xE747,0x0000,0x0000,0xE749,0xE746,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE74C,0x0000,0x8F52,0x0000,0xE74B,0x0000,0x0000,0x0000,0x0000,0x0000,0xE74D,0x0000,0x0000,0x0000,
	0x0000,0xE74E,0x0000,0x0000,0xE751,0xE750,0x0000,0xE74F,0x0000,0x0000,0xE753,0xE752,0x0000,0x96F4,0x0000,0x0000,
	0x0000,0xE755,0x0000,0xE754,0xE756,0x0000,0x0000,0x0000,0x0000,0xE757,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE759,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE758,0x9067,0xE75A,0x0000,0x0000,0x8BEB,
	0xE75B,0xE75D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE75E,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE75F,0xE75C,0x0000,0xE760,0x0000,0x8ED4,0xE761,0x8B4F,0x8C52,0x0000,0xFBB2,
	0x0000,0x0000,0x8CAC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE762,0x0000,0x0000,0x0000,0x93EE,
	0x0000,0x0000,0x935D,0xE763,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE766,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8EB2,0x0000,0x0000,0xE765,0xE764,0x8C79,0xE767,
};
static const WORD _ucs_to_sjis_8F00_data []={ //8F03 8FFD
	                     0x8A72,0x0000,0xE769,0x0000,0x0000,0x0000,0x8DDA,0xE768,0x0000,0xE771,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE76B,0xE76D,0x95E3,0xE76A,0x0000,0x0000,0x0000,0xE76C,0x0000,0xE770,0xE76E,0x8B50,0x0000,0xE76F,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE772,0x0000,0x0000,0x9479,0x97D6,0x0000,0x0000,0x0000,0x0000,0x8F53,
	0x0000,0x0000,0x0000,0xE773,0x0000,0x0000,0x0000,0x0000,0x9741,0xE775,0x0000,0xE774,0x0000,0x0000,0xE778,0x9760,
	0x0000,0x0000,0xE777,0x0000,0x8A8D,0xE776,0xE77B,0x0000,0x0000,0xE77A,0x0000,0x0000,0xE779,0x9351,0xE77C,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE77D,0x0000,0x0000,0x0000,0x0000,0xE77E,0x0000,0x0000,0x8D8C,
	0x0000,0x8C44,0xE780,0xE781,0xE782,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9068,0xE783,0x0000,0x8EAB,0xE784,
	0x0000,0x0000,0x0000,0xE785,0x0000,0x0000,0x0000,0x999F,0x999E,0x0000,0x0000,0x0000,0x0000,0xE786,0xE390,0xE787,
	0x9243,0x904A,0x945F,0x0000,0x0000,0x0000,0x0000,0xE788,0x0000,0x0000,0x95D3,0x92D2,0x8D9E,0x0000,0x0000,0x9248,
	0x0000,0x0000,0x8949,0x0000,0x9698,0x9076,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C7D,0x0000,
	0x0000,0x8BDF,0x0000,0x0000,0x95D4,0x0000,0x0000,0x0000,0x0000,0x0000,0xE789,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE78B,0x0000,0x0000,0xE78A,0x89DE,0x0000,0x0000,0x93F4,0xE78C,0x9497,0x0000,0x9352,0x0000,0xE78D,
	0x8F71,0x0000,0x0000,0x0000,0xE78F,0x0000,0x0000,0x96C0,0xE79E,0xE791,0xE792,0x0000,0x0000,0x92C7,
};
static const WORD _ucs_to_sjis_9000_data []={ //9000 90FD
	0x91DE,0x9197,0x0000,0x93A6,0x0000,0xE790,0x8B74,0x0000,0x0000,0x0000,0x0000,0xE799,0x0000,0xE796,0xE7A3,0x93A7,
	0x9280,0xE793,0x0000,0x92FC,0x9372,0xE794,0xE798,0x9080,0x0000,0x9487,0x92CA,0x0000,0x0000,0x90C0,0xE797,0x91AC,
	0x91A2,0xE795,0x88A7,0x9841,0x0000,0x0000,0x0000,0xE79A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x91DF,0x0000,
	0x0000,0x8F54,0x9069,0x0000,0x0000,0xE79C,0xE79B,0x0000,0x88ED,0xE79D,0x0000,0x0000,0x954E,0x0000,0xE7A5,0x0000,
	0x0000,0x93D9,0x908B,0x0000,0x0000,0x9278,0x0000,0x8BF6,0x0000,0xE7A4,0x9756,0x895E,0x0000,0x95D5,0x89DF,0xE79F,
	0xE7A0,0xE7A1,0xE7A2,0x93B9,0x9242,0x88E1,0xE7A6,0x0000,0xE7A7,0xEAA1,0x0000,0x0000,0x91BB,0x0000,0xE7A8,0x0000,
	0x8993,0x916B,0x0000,0x8CAD,0x0000,0x9779,0x0000,0xFBB5,0xE7A9,0x934B,0x0000,0x0000,0x0000,0x9198,0x8ED5,0xE7AA,
	0x0000,0x0000,0xE7AD,0x0000,0x0000,0x8F85,0xE7AB,0x914A,0x9149,0x0000,0x88E2,0x0000,0x97C9,0xE7AF,0x0000,0x94F0,
	0xE7B1,0xE7B0,0xE7AE,0xE284,0x8AD2,0x0000,0x0000,0xE78E,0x0000,0xE7B3,0xE7B2,0x0000,0x0000,0x0000,0x0000,0xE7B4,
	0x0000,0x9757,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x93DF,0x0000,0x0000,0x964D,0x0000,0xE7B5,0x0000,0x8ED7,0x0000,0x0000,0x0000,0x0000,0xE7B6,
	0x0000,0xE7B7,0x0000,0x0000,0x0000,0xE7B8,0x0000,0x0000,0x9340,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x88E8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8D78,0x0000,0x0000,0x0000,0x9859,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7BC,0x0000,0x0000,0xFBB6,0x0000,
	0x0000,0x8C53,0xE7B9,0x0000,0xE7BA,0x0000,0x0000,0x0000,0x9594,0x0000,0x0000,0x0000,0x0000,0x8A73,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x9758,0x0000,0x8BBD,0x0000,0x0000,0x0000,0x0000,0x0000,0x9373,
};
static const WORD _ucs_to_sjis_9100_data []={ //9102 91FF
	              0xE7BD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE7BE,0x0000,0x0000,0xFBB8,0x0000,0x0000,0x0000,0xE7BF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x9341,0x0000,0x0000,
	0xE7C1,0x0000,0xE7C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x93D1,0xE7C2,0x8F55,0x8EDE,0x947A,0x9291,0x0000,
	0x0000,0x0000,0x8EF0,0x0000,0x908C,0x0000,0xE7C3,0x0000,0xE7C4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x907C,0xE7C5,0x0000,0xE7C6,0x0000,0x0000,0x0000,0xE7C7,0x978F,0x0000,0x8F56,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE7C9,0xE7C8,0x0000,0x8D79,0x0000,0x8D93,0x8E5F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE7CC,0x0000,0x0000,0x0000,0x0000,0x8F86,0x0000,0xE7CB,0x0000,0xE7CA,0x0000,0x91E7,0x0000,0x0000,
	0x8CED,0x0000,0x90C1,0x0000,0x0000,0x0000,0x0000,0x94AE,0x0000,0x0000,0x0000,0x0000,0x8F58,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE7CD,0x0000,0x8FDD,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7D0,0xE7CE,0x0000,0x0000,0x0000,0xE7CF,
	0x0000,0x0000,0x0000,0x0000,0xE7D2,0xE7D1,0x0000,0x0000,0x8FF8,0x0000,0xE7D3,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE7D4,0xE7D5,0x0000,0x0000,0x0000,0x0000,0x94CE,0x8DD1,0x8EDF,0xE7D6,0x0000,0xE7D7,0x97A2,0x8F64,0x96EC,0x97CA,
	0xE7D8,0x8BE0,0x0000,0x0000,0x0000,0x0000,0xE7D9,0xFBBB,0x9342,0x0000,0xFBBA,0xE7DC,0x8A98,0x906A,0xFBBC,0xE7DA,
	0x0000,0xE7DB,0x0000,0x92DE,0xFBBF,0xFBC0,0x9674,0x8BFA,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBBD,0xFBBE,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE7DE,0xE7DF,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7DD,0x0000,0x0000,0xE7E1,
};
static const WORD _ucs_to_sjis_9200_data []={ //9206 92FF
	                                          0xFBC1,0x0000,0x0000,0x0000,0xFBC3,0x0000,0x0000,0x93DD,0x8A62,0x0000,
	0xFBC2,0xE7E5,0x0000,0x0000,0xE7E2,0xE7E4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7E0,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE86E,0x0000,0x0000,0xE7E3,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x97E9,0x0000,0x0000,0x8CD8,0x0000,0xFBCA,0xFBC4,0x0000,0xFBC6,0x0000,0x0000,0xE7ED,
	0xFBC5,0x0000,0x0000,0x0000,0x9353,0xE7E8,0x0000,0x0000,0xE7EB,0xE7E9,0x0000,0xE7EE,0x0000,0x0000,0xFBC7,0x0000,
	0xE7EF,0xFBC9,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7E7,0x0000,0xFBC8,0xE7F4,0x8994,0x0000,0x0000,0xE7E6,0x0000,
	0x0000,0x0000,0x94AB,0x0000,0xE7EA,0x0000,0x8FDE,0xFBCB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x8D7A,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBCD,0xFBCE,0x0000,0x0000,0x0000,0x0000,0x0000,0x9667,0x0000,
	0x8BE2,0x0000,0x0000,0x8F65,0x0000,0x93BA,0x0000,0x0000,0xFA5F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x914C,0x0000,0xE7F2,0x0000,0xE7EC,0xE7F1,0x0000,0x96C1,0x0000,0x92B6,0xE7F3,0xE7F0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBCC,0x0000,0x0000,0x0000,0x0000,0x0000,0x914B,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7F7,0x0000,0xE7F6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7F5,
	0xFBD2,0x0000,0x964E,0xFBD6,0x0000,0xFBD4,0x0000,0xFBD0,0x0000,0xFBD1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xFBD5,0x0000,0x0000,0x0000,0x8F9B,0x0000,0x0000,0xFBCF,0x0000,0xE7F8,0x95DD,0x0000,0x0000,0x8973,0x0000,0x0000,
	0x0000,0x0000,0x9565,0x9292,0x0000,0x0000,0x0000,0x0000,0x8B98,0xFA65,0xE7FA,0xFBD9,0x8D7C,0x0000,0x0000,0xFBDC,
};
static const WORD _ucs_to_sjis_9300_data []={ //9302 93F8
	              0xFBDE,0x0000,0x0000,0x0000,0x8E4B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7F9,
	0x908D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x908E,0xE840,0xE842,0x0000,0x0000,0xFBDD,0xFBDB,0x0000,
	0x8FF9,0xFBD8,0xE841,0xE843,0x0000,0xFBD7,0x8BD1,0x0000,0x9564,0x0000,0x0000,0x8EE0,0x9842,0x0000,0xE7FC,0x8DF6,
	0x0000,0x0000,0x985E,0x0000,0x0000,0xE845,0x0000,0x0000,0x0000,0x0000,0xE844,0xE846,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE7FB,0x0000,0x0000,0x0000,0xFA5E,0x0000,0x0000,0x93E7,0x0000,0x9374,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x92D5,0x0000,0xE84B,0xFBE0,0x0000,0x0000,0x0000,0x9262,0xE847,0x0000,0x0000,0x0000,
	0xE848,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C4C,0x0000,0xE84A,0x0000,
	0xFBDF,0x0000,0x0000,0x0000,0x0000,0x8CAE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE849,0x0000,0x8FDF,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8A99,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE84F,0x0000,0x8DBD,0x9199,0x0000,0x0000,0x92C8,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xFBE1,0x0000,0x0000,0x8A5A,0x0000,0x0000,0x0000,0x0000,0xE84D,0xE84E,0x92C1,0x0000,
	0xE84C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE850,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE856,0x0000,0x0000,0xFBE2,0x0000,0xE859,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE858,0x934C,0x0000,0x0000,0x0000,0x0000,0xE851,0xE852,0xE855,0x0000,0x0000,0x0000,0x0000,0xE857,0xFBE3,0x0000,
	0x0000,0x8BBE,0x0000,0x0000,0xE85A,0xE854,0x0000,0x0000,0xE853,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBE4,
};
static const WORD _ucs_to_sjis_9400_data []={ //9403 9481
	                     0xE85E,0x0000,0x0000,0x0000,0xE85F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE860,0x0000,0x0000,0xE85D,0xE85C,0x0000,0x0000,0x0000,0x8FE0,0x93A8,0xE85B,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE864,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE862,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xFBE5,0x0000,0x0000,0x0000,0xE863,0xE861,0x0000,0x91F6,0x0000,0xE865,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE866,0x0000,0x0000,0xE868,0xFBE6,0x0000,0x0000,0xFBE7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x8AD3,0xE867,0x96F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE873,0xE869,0x0000,0x0000,0xE86C,0x0000,
	0xE86A,0x0000,0xE86B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE86D,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE86F,0x0000,0x0000,0x0000,0x0000,0xE870,0x0000,0xE871,0x0000,0x0000,0x0000,0x0000,0xE874,0xE872,0xE875,0xE877,
	0x0000,0xE876,
};
static const WORD _ucs_to_sjis_9500_data []={ //9577 95E5
	                                                 0x92B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x96E5,0x0000,0xE878,0x914D,0x0000,0x0000,0x0000,0xE879,0x0000,0x95C2,0xE87A,0x8A4A,0x0000,0x0000,0x0000,0x895B,
	0x0000,0x8AD5,0xFBE8,0x8AD4,0xE87B,0x0000,0xE87C,0x0000,0xE87D,0xE87E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE880,0x0000,0x8AD6,0x8A74,0x8D7D,0x94B4,0x0000,0xE882,0xE881,0x0000,0x0000,0x0000,0x0000,0xE883,0x0000,0x0000,
	0x0000,0x0000,0x897B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE886,0x0000,0xE885,0xE884,0x0000,0xE887,0x0000,
	0x0000,0x0000,0x0000,0xE88A,0x0000,0x0000,0x0000,0x88C5,0x0000,0x0000,0xE888,0x0000,0xE88C,0xE88B,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE88E,0xE88D,0xE88F,0x0000,0x93AC,0x0000,0x0000,0x0000,0xE890,0x0000,0x0000,0x0000,
	0x0000,0xE891,0xE893,0x0000,0x0000,0xE892,
};
static const WORD _ucs_to_sjis_9600_data []={ //961C 96FB
	                                                                                    0x958C,0x0000,0x0000,0x0000,
	0x0000,0xE894,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE895,0x0000,0x8DE3,0x0000,0x0000,0x0000,0xE896,0xE897,
	0x0000,0x0000,0x9668,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x916A,0x0000,0x0000,0x0000,0x88A2,
	0x91C9,0x0000,0xE898,0x0000,0x958D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE89B,0xE899,0x8D7E,0x0000,0xE89A,
	0x8CC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x95C3,0xE89D,0xE89F,0xE89E,0xE8A0,
	0x0000,0x0000,0x8940,0x9077,0x8F9C,0x8AD7,0xE8A1,0x0000,0x0000,0x0000,0x9486,0x0000,0xE8A3,0x0000,0x0000,0x0000,
	0x8941,0x0000,0xE8A2,0x92C2,0x0000,0x97CB,0x93A9,0xE89C,0x97A4,0x0000,0x8CAF,0x0000,0x0000,0x977A,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x8BF7,0x97B2,0x0000,0x8C47,0x0000,0x91E0,0xE440,0x0000,0xE8A4,0x8A4B,0x908F,
	0x0000,0x0000,0x0000,0x0000,0x8A75,0xE8A6,0x0000,0xE8A7,0xE8A5,0x8C84,0x0000,0x8DDB,0x8FE1,0xFBEB,0x0000,0x0000,
	0x8942,0x0000,0x0000,0x97D7,0x0000,0x0000,0x0000,0xE8A9,0xE7AC,0x0000,0xE8A8,0x0000,0x0000,0x0000,0x0000,0xFBEC,
	0xE8AC,0xE8AA,0xE8AB,0x0000,0xE8AD,0x0000,0xE8AE,0x97EA,0xE8AF,0xE8B0,0x0000,0x90C7,0x94B9,0x0000,0x0000,0x0000,
	0x909D,0x8AE5,0x0000,0x0000,0x9759,0x89EB,0x8F57,0x8CD9,0x0000,0xE8B3,0x0000,0xE8B2,0x8E93,0xE8B4,0xE8B1,0x0000,
	0x0000,0x8E47,0x0000,0x0000,0x0000,0xE8B8,0xE5AB,0x0000,0x0000,0x99D4,0x0000,0x9097,0xE8B6,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x97A3,0x93EF,0x0000,0x0000,0x0000,0x0000,0x894A,0x0000,0x90E1,0x8EB4,0x0000,0x0000,0x0000,0x0000,
	0x95B5,0x0000,0x895F,0x0000,0x0000,0x0000,0x97EB,0x978B,0x0000,0xE8B9,0x0000,0x9364,
};
static const WORD _ucs_to_sjis_9700_data []={ //9700 97FF
	0x8EF9,0x0000,0x0000,0x0000,0xE8BA,0x0000,0xE8BB,0x906B,0xE8BC,0x0000,0x97EC,0x0000,0x0000,0xE8B7,0xE8BE,0xE8C0,
	0x0000,0xE8BF,0x0000,0xE8BD,0x0000,0x0000,0xE8C1,0x0000,0x0000,0xE8C2,0x0000,0x0000,0x919A,0x0000,0x89E0,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE8C3,0x0000,0x0000,0x96B6,0x0000,0x0000,0xE8C4,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE8C5,0x0000,0x9849,0xFBED,0x0000,0x0000,0x0000,0x0000,0x9E50,0xE8C6,0x0000,0xFBEE,0x0000,0xE8C7,0xE8C8,0x0000,
	0x0000,0x0000,0xE8CC,0xFBEF,0xE8C9,0x0000,0xE8CA,0x0000,0xE8CB,0xE8CD,0x0000,0x0000,0x0000,0xFBF0,0x0000,0xFBF1,
	0x0000,0xFBF2,0x90C2,0x0000,0x0000,0xFBF3,0x96F5,0x0000,0x0000,0x90C3,0x0000,0x0000,0xE8CE,0x0000,0x94F1,0x0000,
	0xE8CF,0xEA72,0x96CA,0x0000,0xE8D0,0x0000,0xE8D1,0x0000,0xE8D2,0x8A76,0x0000,0xE8D4,0x0000,0x9078,0x0000,0x0000,
	0x0000,0xE8D5,0x0000,0x0000,0x8C43,0x0000,0x0000,0x0000,0x0000,0xE8D6,0xE8DA,0x0000,0xE8D8,0x0000,0x0000,0x0000,
	0x0000,0xE8D9,0x0000,0x0000,0x8A93,0xE8D7,0xE8DB,0x0000,0x0000,0x0000,0x0000,0xE8DC,0x0000,0x88C6,0x0000,0xE8DD,
	0xE8DE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8FE2,0x0000,0x0000,0x0000,0xE8DF,0x0000,0x0000,0x0000,
	0x8B66,0x0000,0x0000,0xE8E2,0x0000,0x0000,0xE8E1,0x0000,0xE8E0,0x0000,0x0000,0xE691,0x0000,0x95DA,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE8E3,0xE8E4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE8E5,0x0000,0x0000,0xE8E6,0x0000,0xE8E7,0x0000,0x0000,0xE8E8,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x8AD8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8E9,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8EA,0x9442,0x0000,
	0x0000,0x0000,0xE8EC,0x89B9,0x0000,0xE8EF,0xE8EE,0x0000,0x0000,0x0000,0x0000,0x8943,0x0000,0x0000,0x0000,0x8BBF,
};
static const WORD _ucs_to_sjis_9800_data []={ //9801 98FE
	       0x95C5,0x92B8,0x8DA0,0x0000,0x8D80,0x8F87,0x0000,0x907B,0x0000,0x0000,0x0000,0xE8F1,0x0000,0x0000,0xE8F0,
	0x9761,0x8AE6,0x94D0,0x93DA,0x0000,0x0000,0x0000,0x909C,0x97CC,0x0000,0x8C7A,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE8F4,0x0000,0x0000,0xE8F3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x966A,0x93AA,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x896F,0x0000,0x0000,0xE8F5,0xE8F2,0x0000,0x0000,0x9570,0x978A,0xE8F6,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8F7,0x0000,0x0000,0x0000,0x0000,0xE8F9,0x91E8,0x8A7A,0x8A7B,0xE8F8,
	0x0000,0x0000,0x0000,0x0000,0x8AE7,0x8CB0,0x0000,0xFBF4,0x8AE8,0x0000,0x0000,0x935E,0x0000,0x0000,0x97DE,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xFBF5,0x0000,0x8CDA,0x0000,0x0000,0x0000,0xE8FA,0x0000,0x0000,0x0000,0xE8FB,
	0xE8FC,0xE940,0x0000,0xE942,0xE941,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9597,0x0000,0xE943,0x0000,0x0000,0x0000,0x0000,0xE944,
	0x0000,0xE945,0x0000,0x0000,0x0000,0x0000,0xE946,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE948,0xE947,0x0000,0xE949,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x94F2,0xE3CA,0x0000,0x0000,0x9048,
	0x0000,0x0000,0x8B51,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE94A,0x0000,0xE94B,0x0000,0x99AA,0x9F5A,0x94D1,
	0x0000,0x0000,0x88F9,0x0000,0x88B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8E94,0x964F,0x8FFC,
};
static const WORD _ucs_to_sjis_9900_data []={ //9903 99FF
	                     0xE94C,0x0000,0x96DD,0x0000,0x0000,0x0000,0xE94D,0x977B,0x0000,0x8961,0x0000,0x0000,0x0000,
	0x8E60,0x0000,0xE94E,0x89EC,0xE94F,0x0000,0x0000,0x0000,0xE950,0x0000,0x0000,0x0000,0x0000,0xE952,0xE953,0x0000,
	0xE955,0xE951,0x0000,0x0000,0xE954,0x0000,0x0000,0xFBF8,0x8AD9,0x0000,0x0000,0x0000,0xE956,0x0000,0xE957,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE958,0xE959,0x0000,
	0x0000,0x0000,0xE95A,0x0000,0x0000,0xE95C,0x0000,0x0000,0x0000,0xE95B,0x0000,0xE95E,0xE961,0x0000,0x0000,0x0000,
	0xE95D,0xE95F,0xE960,0x0000,0x0000,0xE962,0x0000,0x8BC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8EF1,0xE963,0xE964,0x8D81,0x0000,0x0000,0x0000,0x0000,0xFBFA,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE965,0x0000,0x0000,0x8A5D,0x0000,0x0000,0x0000,0x946E,0xE966,0xE967,0x0000,
	0x0000,0x0000,0x0000,0x9279,0x93E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE968,0x0000,0x0000,0x0000,
	0x0000,0x949D,0x0000,0x0000,0x91CA,0x8977,0x8BEC,0x0000,0x8BED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x9293,0xE96D,0x8BEE,0x0000,0x0000,0x89ED,0x0000,0x0000,0xE96C,0x0000,0x0000,0xE96A,0x0000,0xE96B,0x0000,0xE969,
	0x0000,0x0000,0xE977,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE96E,0xE96F,0x0000,
	0x0000,0xE970,0xE971,0x0000,0x0000,0x0000,0x0000,0x0000,0xE973,0x0000,0x0000,0xE972,0x0000,0x0000,0x0000,0x8F78,
};
static const WORD _ucs_to_sjis_9A00_data []={ //9A01 9AFB
	       0xE974,0x0000,0x0000,0x0000,0xE976,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8B52,0xE975,
	0x0000,0x0000,0x919B,0x8CB1,0x0000,0x0000,0x0000,0x0000,0x0000,0xE978,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x91CB,0x0000,0x0000,0xE979,0x0000,0x0000,0x0000,0x0000,
	0x93AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE97A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE980,0x0000,
	0xE97D,0x0000,0xE97C,0xE97E,0x0000,0xE97B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE982,0xFBFB,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE981,0x0000,0xE984,0x0000,0x0000,0x8BC1,0xE983,0x0000,0x0000,0x0000,0xE985,
	0x0000,0x0000,0xE986,0x0000,0xE988,0xE987,0x0000,0x0000,0x0000,0xE989,0xE98B,0xE98A,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8D9C,0x0000,0x0000,0x0000,0x0000,0xE98C,0x0000,0x0000,
	0xE98D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8A5B,0x0000,0x0000,0x0000,0xE98E,0x0000,0x0000,0x0000,
	0xE98F,0x0000,0x0000,0x0000,0x9091,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE990,
	0x0000,0xE991,0x0000,0xE992,0xE993,0x0000,0x0000,0x0000,0x8D82,0xFBFC,0x0000,0x0000,0xFC40,0x0000,0xE994,0xE995,
	0x0000,0x0000,0xE996,0xE997,0x0000,0x0000,0xE998,0x0000,0x0000,0x0000,0x94AF,0xE99A,0x0000,0x9545,0xE99B,0xE999,
	0x0000,0xE99D,0x0000,0x0000,0xE99C,0x0000,0x0000,0xE99E,0x0000,0x0000,0x0000,0xE99F,
};
static const WORD _ucs_to_sjis_9B00_data []={ //9B06 9BF5
	                                          0xE9A0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9A1,0x0000,0xE9A2,0x0000,0x0000,0x0000,0x0000,0xE9A3,
	0x0000,0x0000,0xE9A4,0xE9A5,0x0000,0xE9A6,0x0000,0xE9A7,0xE9A8,0xE9A9,0xE9AA,0x0000,0x0000,0x0000,0xE9AB,0xE9AC,
	0x0000,0x9F54,0xE9AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2F6,0x8B53,0x0000,0x0000,0x0000,
	0x0000,0x8A40,0x8DB0,0xE9AF,0xE9AE,0x96A3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9B1,0xE9B2,0xE9B0,
	0x0000,0xE9B3,0x0000,0x0000,0x9682,0x0000,0x0000,0x0000,0xE9B4,0x0000,0x8B9B,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9844,
	0x0000,0x0000,0xFC42,0x0000,0xE9B5,0xFC41,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE9B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x88BC,0xFC43,
	0x0000,0xE9B8,0x95A9,0xE9B6,0x0000,0x0000,0xE9B9,0xE9BA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9BB,
	0xE9BC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9BD,0x0000,0x968E,0x8E4C,0x0000,0x8DF8,0x914E,0x0000,
	0x0000,0xFC44,0x0000,0x0000,0xE9BE,0x0000,0x0000,0x0000,0x0000,0xE9C1,0x0000,0xFC45,0x0000,0x0000,0x0000,0x0000,
	0xE9BF,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9C2,0x0000,0x0000,0x8CEF,0xE9C0,0x0000,0x0000,0x0000,0x0000,0xE9C3,
	0x0000,0xE9C4,0xE9C5,0x0000,0xE9C9,0x0000,0x8E49,0x0000,0x0000,0x0000,0x0000,0x91E2,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE9CA,0xE9C7,0xE9C6,0xE9C8,0x0000,0x0000,0x0000,0x8C7E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE9CE,0xE9CD,0xE9CC,0x0000,0x0000,0x88B1,
};
static const WORD _ucs_to_sjis_9C00_data []={ //9C00 9CF6
	0xFC46,0x0000,0x0000,0x0000,0xE9D8,0x0000,0xE9D4,0x0000,0xE9D5,0xE9D1,0xE9D7,0x0000,0xE9D3,0x8A82,0x0000,0x0000,
	0x986B,0x0000,0xE9D6,0xE9D2,0xE9D0,0xE9CF,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9DA,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE9DD,0x0000,0x0000,0xE9DC,0xE9DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9568,0xE9D9,0x88F1,
	0xE9DE,0x0000,0xE9E0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8A8F,0xE9CB,0x8956,0x0000,0x0000,0xE9E2,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9E1,0xE9DF,0x924C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x9690,0x0000,0x0000,0x0000,0x0000,0x97D8,0x0000,0x0000,0xE9E3,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE9E4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9E6,0x0000,0xE9E7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x92B9,0x0000,0xE9E8,0x0000,0x94B5,0x0000,0xE9ED,0xE9E9,0x0000,0x0000,0x0000,
	0xE9EA,0x0000,0x0000,0x9650,0x96C2,0x0000,0x93CE,
};
static const WORD _ucs_to_sjis_9D00_data []={ //9D03 9DFD
	                     0xE9EE,0x0000,0x0000,0xE9EF,0x93BC,0xE9EC,0xE9EB,0x0000,0x0000,0x0000,0x0000,0x89A8,0x0000,
	0x0000,0x0000,0xE9F7,0x0000,0x0000,0xE9F6,0x0000,0x0000,0x0000,0x0000,0x0000,0x8995,0x0000,0x0000,0x0000,0xE9F4,
	0x0000,0x0000,0x0000,0xE9F3,0x0000,0x0000,0xE9F1,0x0000,0x8A9B,0x0000,0xE9F0,0x8EB0,0x89A7,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8D83,0x0000,0x0000,0xE9FA,0xE9F9,
	0x0000,0xE9F8,0x0000,0x0000,0xE9F5,0x0000,0xE9FB,0x0000,0xE9FC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xEA44,0xEA43,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA45,0x0000,0x0000,0x894C,0xEA40,0xEA41,0x0000,
	0x8D94,0x96B7,0x0000,0x0000,0xEA42,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFC48,0x9651,0x0000,0x0000,0xEA4A,
	0xFC47,0x0000,0xEA46,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA4B,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA48,0x0000,0xEA47,0x0000,0x0000,0x0000,0x0000,0x0000,0x8C7B,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA4C,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xEA4D,0x0000,0x0000,0x0000,0x0000,0xEA4E,0x0000,0xEA49,0x0000,0x0000,0x0000,0xE9F2,
	0x0000,0x0000,0xEA4F,0x0000,0x92DF,0x0000,0x0000,0x0000,0xEA53,0x0000,0xEA54,0xEA52,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xEA51,0xEA57,0x0000,0xEA50,0x0000,0xEA55,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA56,
	0x0000,0x0000,0x0000,0xEA59,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA58,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA5C,0x0000,0xEA5D,
	0x0000,0x0000,0x9868,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA5A,0x91E9,0x8DEB,0x0000,0x0000,0xEA5E,
};
static const WORD _ucs_to_sjis_9E00_data []={ //9E19 9EFD
	                                                               0xFC4A,0xEA5F,0xEA60,0x0000,0x0000,0xEA61,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xEA62,0x0000,0x0000,0x8CB2,0xEA63,0x0000,0x0000,0x0000,0xEA64,0x0000,0x8EAD,
	0x0000,0xEA65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA66,0x0000,0x0000,0xEA67,0xEA68,0x0000,0x0000,0x0000,
	0x0000,0xEA6B,0xEA69,0x985B,0x0000,0xEA6A,0x0000,0x97ED,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA6C,0x0000,0x97D9,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xEA6D,0x949E,0x0000,0x0000,0xEA6E,0xEA70,0x0000,0x0000,0xEA71,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA6F,0x8D8D,0x96CB,0x9683,0x9BF5,0x0000,0x9F80,0x969B,
	0x0000,0x0000,0x0000,0x0000,0x89A9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA73,0x8B6F,0xEA74,0xEA75,
	0xEA76,0xFC4B,0x8D95,0x0000,0xEA77,0x0000,0x0000,0x0000,0xE0D2,0x96D9,0x0000,0x91E1,0xEA78,0xEA7A,0xEA79,0x0000,
	0xEA7B,0x0000,0x0000,0x0000,0x0000,0xEA7C,0x0000,0x0000,0xEA7D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA7E,
	0x0000,0x0000,0x0000,0x0000,0xEA80,0x0000,0xEA81,0xEA82,0x0000,0xEA83,0x0000,0xEA84,0xEA85,0xEA86,
};
static const WORD _ucs_to_sjis_9F00_data []={ //9F07 9FA0
	                                                 0xEA87,0xEA88,0x0000,0x0000,0x0000,0x0000,0x0000,0x9343,0x0000,
	0x0000,0x0000,0x0000,0x8CDB,0x0000,0xEA8A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x916C,0xEA8B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA8C,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9540,0x0000,0x0000,0xEA8D,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA8E,0xE256,0x0000,0x0000,0xE6D8,0xE8EB,
	0x0000,0x0000,0xEA8F,0x0000,0xEA90,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA92,
	0xEA93,0xEA94,0x97EE,0xEA91,0x0000,0x0000,0xEA95,0xEA96,0x0000,0x0000,0xEA98,0x0000,0xEA97,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEA9A,0x0000,0x0000,0x0000,0xEA9B,0xEA99,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x97B4,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xEA9C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEA9D,0xE273,0x0000,0x0000,
	0xEA9E,
};
static const WORD _ucs_to_sjis_E000_data []={ //E000 E0FF
	0xF040,0xF041,0xF042,0xF043,0xF044,0xF045,0xF046,0xF047,0xF048,0xF049,0xF04A,0xF04B,0xF04C,0xF04D,0xF04E,0xF04F,
	0xF050,0xF051,0xF052,0xF053,0xF054,0xF055,0xF056,0xF057,0xF058,0xF059,0xF05A,0xF05B,0xF05C,0xF05D,0xF05E,0xF05F,
	0xF060,0xF061,0xF062,0xF063,0xF064,0xF065,0xF066,0xF067,0xF068,0xF069,0xF06A,0xF06B,0xF06C,0xF06D,0xF06E,0xF06F,
	0xF070,0xF071,0xF072,0xF073,0xF074,0xF075,0xF076,0xF077,0xF078,0xF079,0xF07A,0xF07B,0xF07C,0xF07D,0xF07E,0xF080,
	0xF081,0xF082,0xF083,0xF084,0xF085,0xF086,0xF087,0xF088,0xF089,0xF08A,0xF08B,0xF08C,0xF08D,0xF08E,0xF08F,0xF090,
	0xF091,0xF092,0xF093,0xF094,0xF095,0xF096,0xF097,0xF098,0xF099,0xF09A,0xF09B,0xF09C,0xF09D,0xF09E,0xF09F,0xF0A0,
	0xF0A1,0xF0A2,0xF0A3,0xF0A4,0xF0A5,0xF0A6,0xF0A7,0xF0A8,0xF0A9,0xF0AA,0xF0AB,0xF0AC,0xF0AD,0xF0AE,0xF0AF,0xF0B0,
	0xF0B1,0xF0B2,0xF0B3,0xF0B4,0xF0B5,0xF0B6,0xF0B7,0xF0B8,0xF0B9,0xF0BA,0xF0BB,0xF0BC,0xF0BD,0xF0BE,0xF0BF,0xF0C0,
	0xF0C1,0xF0C2,0xF0C3,0xF0C4,0xF0C5,0xF0C6,0xF0C7,0xF0C8,0xF0C9,0xF0CA,0xF0CB,0xF0CC,0xF0CD,0xF0CE,0xF0CF,0xF0D0,
	0xF0D1,0xF0D2,0xF0D3,0xF0D4,0xF0D5,0xF0D6,0xF0D7,0xF0D8,0xF0D9,0xF0DA,0xF0DB,0xF0DC,0xF0DD,0xF0DE,0xF0DF,0xF0E0,
	0xF0E1,0xF0E2,0xF0E3,0xF0E4,0xF0E5,0xF0E6,0xF0E7,0xF0E8,0xF0E9,0xF0EA,0xF0EB,0xF0EC,0xF0ED,0xF0EE,0xF0EF,0xF0F0,
	0xF0F1,0xF0F2,0xF0F3,0xF0F4,0xF0F5,0xF0F6,0xF0F7,0xF0F8,0xF0F9,0xF0FA,0xF0FB,0xF0FC,0xF140,0xF141,0xF142,0xF143,
	0xF144,0xF145,0xF146,0xF147,0xF148,0xF149,0xF14A,0xF14B,0xF14C,0xF14D,0xF14E,0xF14F,0xF150,0xF151,0xF152,0xF153,
	0xF154,0xF155,0xF156,0xF157,0xF158,0xF159,0xF15A,0xF15B,0xF15C,0xF15D,0xF15E,0xF15F,0xF160,0xF161,0xF162,0xF163,
	0xF164,0xF165,0xF166,0xF167,0xF168,0xF169,0xF16A,0xF16B,0xF16C,0xF16D,0xF16E,0xF16F,0xF170,0xF171,0xF172,0xF173,
	0xF174,0xF175,0xF176,0xF177,0xF178,0xF179,0xF17A,0xF17B,0xF17C,0xF17D,0xF17E,0xF180,0xF181,0xF182,0xF183,0xF184,
};
static const WORD _ucs_to_sjis_E100_data []={ //E100 E1FF
	0xF185,0xF186,0xF187,0xF188,0xF189,0xF18A,0xF18B,0xF18C,0xF18D,0xF18E,0xF18F,0xF190,0xF191,0xF192,0xF193,0xF194,
	0xF195,0xF196,0xF197,0xF198,0xF199,0xF19A,0xF19B,0xF19C,0xF19D,0xF19E,0xF19F,0xF1A0,0xF1A1,0xF1A2,0xF1A3,0xF1A4,
	0xF1A5,0xF1A6,0xF1A7,0xF1A8,0xF1A9,0xF1AA,0xF1AB,0xF1AC,0xF1AD,0xF1AE,0xF1AF,0xF1B0,0xF1B1,0xF1B2,0xF1B3,0xF1B4,
	0xF1B5,0xF1B6,0xF1B7,0xF1B8,0xF1B9,0xF1BA,0xF1BB,0xF1BC,0xF1BD,0xF1BE,0xF1BF,0xF1C0,0xF1C1,0xF1C2,0xF1C3,0xF1C4,
	0xF1C5,0xF1C6,0xF1C7,0xF1C8,0xF1C9,0xF1CA,0xF1CB,0xF1CC,0xF1CD,0xF1CE,0xF1CF,0xF1D0,0xF1D1,0xF1D2,0xF1D3,0xF1D4,
	0xF1D5,0xF1D6,0xF1D7,0xF1D8,0xF1D9,0xF1DA,0xF1DB,0xF1DC,0xF1DD,0xF1DE,0xF1DF,0xF1E0,0xF1E1,0xF1E2,0xF1E3,0xF1E4,
	0xF1E5,0xF1E6,0xF1E7,0xF1E8,0xF1E9,0xF1EA,0xF1EB,0xF1EC,0xF1ED,0xF1EE,0xF1EF,0xF1F0,0xF1F1,0xF1F2,0xF1F3,0xF1F4,
	0xF1F5,0xF1F6,0xF1F7,0xF1F8,0xF1F9,0xF1FA,0xF1FB,0xF1FC,0xF240,0xF241,0xF242,0xF243,0xF244,0xF245,0xF246,0xF247,
	0xF248,0xF249,0xF24A,0xF24B,0xF24C,0xF24D,0xF24E,0xF24F,0xF250,0xF251,0xF252,0xF253,0xF254,0xF255,0xF256,0xF257,
	0xF258,0xF259,0xF25A,0xF25B,0xF25C,0xF25D,0xF25E,0xF25F,0xF260,0xF261,0xF262,0xF263,0xF264,0xF265,0xF266,0xF267,
	0xF268,0xF269,0xF26A,0xF26B,0xF26C,0xF26D,0xF26E,0xF26F,0xF270,0xF271,0xF272,0xF273,0xF274,0xF275,0xF276,0xF277,
	0xF278,0xF279,0xF27A,0xF27B,0xF27C,0xF27D,0xF27E,0xF280,0xF281,0xF282,0xF283,0xF284,0xF285,0xF286,0xF287,0xF288,
	0xF289,0xF28A,0xF28B,0xF28C,0xF28D,0xF28E,0xF28F,0xF290,0xF291,0xF292,0xF293,0xF294,0xF295,0xF296,0xF297,0xF298,
	0xF299,0xF29A,0xF29B,0xF29C,0xF29D,0xF29E,0xF29F,0xF2A0,0xF2A1,0xF2A2,0xF2A3,0xF2A4,0xF2A5,0xF2A6,0xF2A7,0xF2A8,
	0xF2A9,0xF2AA,0xF2AB,0xF2AC,0xF2AD,0xF2AE,0xF2AF,0xF2B0,0xF2B1,0xF2B2,0xF2B3,0xF2B4,0xF2B5,0xF2B6,0xF2B7,0xF2B8,
	0xF2B9,0xF2BA,0xF2BB,0xF2BC,0xF2BD,0xF2BE,0xF2BF,0xF2C0,0xF2C1,0xF2C2,0xF2C3,0xF2C4,0xF2C5,0xF2C6,0xF2C7,0xF2C8,
};
static const WORD _ucs_to_sjis_E200_data []={ //E200 E2FF
	0xF2C9,0xF2CA,0xF2CB,0xF2CC,0xF2CD,0xF2CE,0xF2CF,0xF2D0,0xF2D1,0xF2D2,0xF2D3,0xF2D4,0xF2D5,0xF2D6,0xF2D7,0xF2D8,
	0xF2D9,0xF2DA,0xF2DB,0xF2DC,0xF2DD,0xF2DE,0xF2DF,0xF2E0,0xF2E1,0xF2E2,0xF2E3,0xF2E4,0xF2E5,0xF2E6,0xF2E7,0xF2E8,
	0xF2E9,0xF2EA,0xF2EB,0xF2EC,0xF2ED,0xF2EE,0xF2EF,0xF2F0,0xF2F1,0xF2F2,0xF2F3,0xF2F4,0xF2F5,0xF2F6,0xF2F7,0xF2F8,
	0xF2F9,0xF2FA,0xF2FB,0xF2FC,0xF340,0xF341,0xF342,0xF343,0xF344,0xF345,0xF346,0xF347,0xF348,0xF349,0xF34A,0xF34B,
	0xF34C,0xF34D,0xF34E,0xF34F,0xF350,0xF351,0xF352,0xF353,0xF354,0xF355,0xF356,0xF357,0xF358,0xF359,0xF35A,0xF35B,
	0xF35C,0xF35D,0xF35E,0xF35F,0xF360,0xF361,0xF362,0xF363,0xF364,0xF365,0xF366,0xF367,0xF368,0xF369,0xF36A,0xF36B,
	0xF36C,0xF36D,0xF36E,0xF36F,0xF370,0xF371,0xF372,0xF373,0xF374,0xF375,0xF376,0xF377,0xF378,0xF379,0xF37A,0xF37B,
	0xF37C,0xF37D,0xF37E,0xF380,0xF381,0xF382,0xF383,0xF384,0xF385,0xF386,0xF387,0xF388,0xF389,0xF38A,0xF38B,0xF38C,
	0xF38D,0xF38E,0xF38F,0xF390,0xF391,0xF392,0xF393,0xF394,0xF395,0xF396,0xF397,0xF398,0xF399,0xF39A,0xF39B,0xF39C,
	0xF39D,0xF39E,0xF39F,0xF3A0,0xF3A1,0xF3A2,0xF3A3,0xF3A4,0xF3A5,0xF3A6,0xF3A7,0xF3A8,0xF3A9,0xF3AA,0xF3AB,0xF3AC,
	0xF3AD,0xF3AE,0xF3AF,0xF3B0,0xF3B1,0xF3B2,0xF3B3,0xF3B4,0xF3B5,0xF3B6,0xF3B7,0xF3B8,0xF3B9,0xF3BA,0xF3BB,0xF3BC,
	0xF3BD,0xF3BE,0xF3BF,0xF3C0,0xF3C1,0xF3C2,0xF3C3,0xF3C4,0xF3C5,0xF3C6,0xF3C7,0xF3C8,0xF3C9,0xF3CA,0xF3CB,0xF3CC,
	0xF3CD,0xF3CE,0xF3CF,0xF3D0,0xF3D1,0xF3D2,0xF3D3,0xF3D4,0xF3D5,0xF3D6,0xF3D7,0xF3D8,0xF3D9,0xF3DA,0xF3DB,0xF3DC,
	0xF3DD,0xF3DE,0xF3DF,0xF3E0,0xF3E1,0xF3E2,0xF3E3,0xF3E4,0xF3E5,0xF3E6,0xF3E7,0xF3E8,0xF3E9,0xF3EA,0xF3EB,0xF3EC,
	0xF3ED,0xF3EE,0xF3EF,0xF3F0,0xF3F1,0xF3F2,0xF3F3,0xF3F4,0xF3F5,0xF3F6,0xF3F7,0xF3F8,0xF3F9,0xF3FA,0xF3FB,0xF3FC,
	0xF440,0xF441,0xF442,0xF443,0xF444,0xF445,0xF446,0xF447,0xF448,0xF449,0xF44A,0xF44B,0xF44C,0xF44D,0xF44E,0xF44F,
};
static const WORD _ucs_to_sjis_E300_data []={ //E300 E3FF
	0xF450,0xF451,0xF452,0xF453,0xF454,0xF455,0xF456,0xF457,0xF458,0xF459,0xF45A,0xF45B,0xF45C,0xF45D,0xF45E,0xF45F,
	0xF460,0xF461,0xF462,0xF463,0xF464,0xF465,0xF466,0xF467,0xF468,0xF469,0xF46A,0xF46B,0xF46C,0xF46D,0xF46E,0xF46F,
	0xF470,0xF471,0xF472,0xF473,0xF474,0xF475,0xF476,0xF477,0xF478,0xF479,0xF47A,0xF47B,0xF47C,0xF47D,0xF47E,0xF480,
	0xF481,0xF482,0xF483,0xF484,0xF485,0xF486,0xF487,0xF488,0xF489,0xF48A,0xF48B,0xF48C,0xF48D,0xF48E,0xF48F,0xF490,
	0xF491,0xF492,0xF493,0xF494,0xF495,0xF496,0xF497,0xF498,0xF499,0xF49A,0xF49B,0xF49C,0xF49D,0xF49E,0xF49F,0xF4A0,
	0xF4A1,0xF4A2,0xF4A3,0xF4A4,0xF4A5,0xF4A6,0xF4A7,0xF4A8,0xF4A9,0xF4AA,0xF4AB,0xF4AC,0xF4AD,0xF4AE,0xF4AF,0xF4B0,
	0xF4B1,0xF4B2,0xF4B3,0xF4B4,0xF4B5,0xF4B6,0xF4B7,0xF4B8,0xF4B9,0xF4BA,0xF4BB,0xF4BC,0xF4BD,0xF4BE,0xF4BF,0xF4C0,
	0xF4C1,0xF4C2,0xF4C3,0xF4C4,0xF4C5,0xF4C6,0xF4C7,0xF4C8,0xF4C9,0xF4CA,0xF4CB,0xF4CC,0xF4CD,0xF4CE,0xF4CF,0xF4D0,
	0xF4D1,0xF4D2,0xF4D3,0xF4D4,0xF4D5,0xF4D6,0xF4D7,0xF4D8,0xF4D9,0xF4DA,0xF4DB,0xF4DC,0xF4DD,0xF4DE,0xF4DF,0xF4E0,
	0xF4E1,0xF4E2,0xF4E3,0xF4E4,0xF4E5,0xF4E6,0xF4E7,0xF4E8,0xF4E9,0xF4EA,0xF4EB,0xF4EC,0xF4ED,0xF4EE,0xF4EF,0xF4F0,
	0xF4F1,0xF4F2,0xF4F3,0xF4F4,0xF4F5,0xF4F6,0xF4F7,0xF4F8,0xF4F9,0xF4FA,0xF4FB,0xF4FC,0xF540,0xF541,0xF542,0xF543,
	0xF544,0xF545,0xF546,0xF547,0xF548,0xF549,0xF54A,0xF54B,0xF54C,0xF54D,0xF54E,0xF54F,0xF550,0xF551,0xF552,0xF553,
	0xF554,0xF555,0xF556,0xF557,0xF558,0xF559,0xF55A,0xF55B,0xF55C,0xF55D,0xF55E,0xF55F,0xF560,0xF561,0xF562,0xF563,
	0xF564,0xF565,0xF566,0xF567,0xF568,0xF569,0xF56A,0xF56B,0xF56C,0xF56D,0xF56E,0xF56F,0xF570,0xF571,0xF572,0xF573,
	0xF574,0xF575,0xF576,0xF577,0xF578,0xF579,0xF57A,0xF57B,0xF57C,0xF57D,0xF57E,0xF580,0xF581,0xF582,0xF583,0xF584,
	0xF585,0xF586,0xF587,0xF588,0xF589,0xF58A,0xF58B,0xF58C,0xF58D,0xF58E,0xF58F,0xF590,0xF591,0xF592,0xF593,0xF594,
};
static const WORD _ucs_to_sjis_E400_data []={ //E400 E4FF
	0xF595,0xF596,0xF597,0xF598,0xF599,0xF59A,0xF59B,0xF59C,0xF59D,0xF59E,0xF59F,0xF5A0,0xF5A1,0xF5A2,0xF5A3,0xF5A4,
	0xF5A5,0xF5A6,0xF5A7,0xF5A8,0xF5A9,0xF5AA,0xF5AB,0xF5AC,0xF5AD,0xF5AE,0xF5AF,0xF5B0,0xF5B1,0xF5B2,0xF5B3,0xF5B4,
	0xF5B5,0xF5B6,0xF5B7,0xF5B8,0xF5B9,0xF5BA,0xF5BB,0xF5BC,0xF5BD,0xF5BE,0xF5BF,0xF5C0,0xF5C1,0xF5C2,0xF5C3,0xF5C4,
	0xF5C5,0xF5C6,0xF5C7,0xF5C8,0xF5C9,0xF5CA,0xF5CB,0xF5CC,0xF5CD,0xF5CE,0xF5CF,0xF5D0,0xF5D1,0xF5D2,0xF5D3,0xF5D4,
	0xF5D5,0xF5D6,0xF5D7,0xF5D8,0xF5D9,0xF5DA,0xF5DB,0xF5DC,0xF5DD,0xF5DE,0xF5DF,0xF5E0,0xF5E1,0xF5E2,0xF5E3,0xF5E4,
	0xF5E5,0xF5E6,0xF5E7,0xF5E8,0xF5E9,0xF5EA,0xF5EB,0xF5EC,0xF5ED,0xF5EE,0xF5EF,0xF5F0,0xF5F1,0xF5F2,0xF5F3,0xF5F4,
	0xF5F5,0xF5F6,0xF5F7,0xF5F8,0xF5F9,0xF5FA,0xF5FB,0xF5FC,0xF640,0xF641,0xF642,0xF643,0xF644,0xF645,0xF646,0xF647,
	0xF648,0xF649,0xF64A,0xF64B,0xF64C,0xF64D,0xF64E,0xF64F,0xF650,0xF651,0xF652,0xF653,0xF654,0xF655,0xF656,0xF657,
	0xF658,0xF659,0xF65A,0xF65B,0xF65C,0xF65D,0xF65E,0xF65F,0xF660,0xF661,0xF662,0xF663,0xF664,0xF665,0xF666,0xF667,
	0xF668,0xF669,0xF66A,0xF66B,0xF66C,0xF66D,0xF66E,0xF66F,0xF670,0xF671,0xF672,0xF673,0xF674,0xF675,0xF676,0xF677,
	0xF678,0xF679,0xF67A,0xF67B,0xF67C,0xF67D,0xF67E,0xF680,0xF681,0xF682,0xF683,0xF684,0xF685,0xF686,0xF687,0xF688,
	0xF689,0xF68A,0xF68B,0xF68C,0xF68D,0xF68E,0xF68F,0xF690,0xF691,0xF692,0xF693,0xF694,0xF695,0xF696,0xF697,0xF698,
	0xF699,0xF69A,0xF69B,0xF69C,0xF69D,0xF69E,0xF69F,0xF6A0,0xF6A1,0xF6A2,0xF6A3,0xF6A4,0xF6A5,0xF6A6,0xF6A7,0xF6A8,
	0xF6A9,0xF6AA,0xF6AB,0xF6AC,0xF6AD,0xF6AE,0xF6AF,0xF6B0,0xF6B1,0xF6B2,0xF6B3,0xF6B4,0xF6B5,0xF6B6,0xF6B7,0xF6B8,
	0xF6B9,0xF6BA,0xF6BB,0xF6BC,0xF6BD,0xF6BE,0xF6BF,0xF6C0,0xF6C1,0xF6C2,0xF6C3,0xF6C4,0xF6C5,0xF6C6,0xF6C7,0xF6C8,
	0xF6C9,0xF6CA,0xF6CB,0xF6CC,0xF6CD,0xF6CE,0xF6CF,0xF6D0,0xF6D1,0xF6D2,0xF6D3,0xF6D4,0xF6D5,0xF6D6,0xF6D7,0xF6D8,
};
static const WORD _ucs_to_sjis_E500_data []={ //E500 E5FF
	0xF6D9,0xF6DA,0xF6DB,0xF6DC,0xF6DD,0xF6DE,0xF6DF,0xF6E0,0xF6E1,0xF6E2,0xF6E3,0xF6E4,0xF6E5,0xF6E6,0xF6E7,0xF6E8,
	0xF6E9,0xF6EA,0xF6EB,0xF6EC,0xF6ED,0xF6EE,0xF6EF,0xF6F0,0xF6F1,0xF6F2,0xF6F3,0xF6F4,0xF6F5,0xF6F6,0xF6F7,0xF6F8,
	0xF6F9,0xF6FA,0xF6FB,0xF6FC,0xF740,0xF741,0xF742,0xF743,0xF744,0xF745,0xF746,0xF747,0xF748,0xF749,0xF74A,0xF74B,
	0xF74C,0xF74D,0xF74E,0xF74F,0xF750,0xF751,0xF752,0xF753,0xF754,0xF755,0xF756,0xF757,0xF758,0xF759,0xF75A,0xF75B,
	0xF75C,0xF75D,0xF75E,0xF75F,0xF760,0xF761,0xF762,0xF763,0xF764,0xF765,0xF766,0xF767,0xF768,0xF769,0xF76A,0xF76B,
	0xF76C,0xF76D,0xF76E,0xF76F,0xF770,0xF771,0xF772,0xF773,0xF774,0xF775,0xF776,0xF777,0xF778,0xF779,0xF77A,0xF77B,
	0xF77C,0xF77D,0xF77E,0xF780,0xF781,0xF782,0xF783,0xF784,0xF785,0xF786,0xF787,0xF788,0xF789,0xF78A,0xF78B,0xF78C,
	0xF78D,0xF78E,0xF78F,0xF790,0xF791,0xF792,0xF793,0xF794,0xF795,0xF796,0xF797,0xF798,0xF799,0xF79A,0xF79B,0xF79C,
	0xF79D,0xF79E,0xF79F,0xF7A0,0xF7A1,0xF7A2,0xF7A3,0xF7A4,0xF7A5,0xF7A6,0xF7A7,0xF7A8,0xF7A9,0xF7AA,0xF7AB,0xF7AC,
	0xF7AD,0xF7AE,0xF7AF,0xF7B0,0xF7B1,0xF7B2,0xF7B3,0xF7B4,0xF7B5,0xF7B6,0xF7B7,0xF7B8,0xF7B9,0xF7BA,0xF7BB,0xF7BC,
	0xF7BD,0xF7BE,0xF7BF,0xF7C0,0xF7C1,0xF7C2,0xF7C3,0xF7C4,0xF7C5,0xF7C6,0xF7C7,0xF7C8,0xF7C9,0xF7CA,0xF7CB,0xF7CC,
	0xF7CD,0xF7CE,0xF7CF,0xF7D0,0xF7D1,0xF7D2,0xF7D3,0xF7D4,0xF7D5,0xF7D6,0xF7D7,0xF7D8,0xF7D9,0xF7DA,0xF7DB,0xF7DC,
	0xF7DD,0xF7DE,0xF7DF,0xF7E0,0xF7E1,0xF7E2,0xF7E3,0xF7E4,0xF7E5,0xF7E6,0xF7E7,0xF7E8,0xF7E9,0xF7EA,0xF7EB,0xF7EC,
	0xF7ED,0xF7EE,0xF7EF,0xF7F0,0xF7F1,0xF7F2,0xF7F3,0xF7F4,0xF7F5,0xF7F6,0xF7F7,0xF7F8,0xF7F9,0xF7FA,0xF7FB,0xF7FC,
	0xF840,0xF841,0xF842,0xF843,0xF844,0xF845,0xF846,0xF847,0xF848,0xF849,0xF84A,0xF84B,0xF84C,0xF84D,0xF84E,0xF84F,
	0xF850,0xF851,0xF852,0xF853,0xF854,0xF855,0xF856,0xF857,0xF858,0xF859,0xF85A,0xF85B,0xF85C,0xF85D,0xF85E,0xF85F,
};
static const WORD _ucs_to_sjis_E600_data []={ //E600 E6FF
	0xF860,0xF861,0xF862,0xF863,0xF864,0xF865,0xF866,0xF867,0xF868,0xF869,0xF86A,0xF86B,0xF86C,0xF86D,0xF86E,0xF86F,
	0xF870,0xF871,0xF872,0xF873,0xF874,0xF875,0xF876,0xF877,0xF878,0xF879,0xF87A,0xF87B,0xF87C,0xF87D,0xF87E,0xF880,
	0xF881,0xF882,0xF883,0xF884,0xF885,0xF886,0xF887,0xF888,0xF889,0xF88A,0xF88B,0xF88C,0xF88D,0xF88E,0xF88F,0xF890,
	0xF891,0xF892,0xF893,0xF894,0xF895,0xF896,0xF897,0xF898,0xF899,0xF89A,0xF89B,0xF89C,0xF89D,0xF89E,0xF89F,0xF8A0,
	0xF8A1,0xF8A2,0xF8A3,0xF8A4,0xF8A5,0xF8A6,0xF8A7,0xF8A8,0xF8A9,0xF8AA,0xF8AB,0xF8AC,0xF8AD,0xF8AE,0xF8AF,0xF8B0,
	0xF8B1,0xF8B2,0xF8B3,0xF8B4,0xF8B5,0xF8B6,0xF8B7,0xF8B8,0xF8B9,0xF8BA,0xF8BB,0xF8BC,0xF8BD,0xF8BE,0xF8BF,0xF8C0,
	0xF8C1,0xF8C2,0xF8C3,0xF8C4,0xF8C5,0xF8C6,0xF8C7,0xF8C8,0xF8C9,0xF8CA,0xF8CB,0xF8CC,0xF8CD,0xF8CE,0xF8CF,0xF8D0,
	0xF8D1,0xF8D2,0xF8D3,0xF8D4,0xF8D5,0xF8D6,0xF8D7,0xF8D8,0xF8D9,0xF8DA,0xF8DB,0xF8DC,0xF8DD,0xF8DE,0xF8DF,0xF8E0,
	0xF8E1,0xF8E2,0xF8E3,0xF8E4,0xF8E5,0xF8E6,0xF8E7,0xF8E8,0xF8E9,0xF8EA,0xF8EB,0xF8EC,0xF8ED,0xF8EE,0xF8EF,0xF8F0,
	0xF8F1,0xF8F2,0xF8F3,0xF8F4,0xF8F5,0xF8F6,0xF8F7,0xF8F8,0xF8F9,0xF8FA,0xF8FB,0xF8FC,0xF940,0xF941,0xF942,0xF943,
	0xF944,0xF945,0xF946,0xF947,0xF948,0xF949,0xF94A,0xF94B,0xF94C,0xF94D,0xF94E,0xF94F,0xF950,0xF951,0xF952,0xF953,
	0xF954,0xF955,0xF956,0xF957,0xF958,0xF959,0xF95A,0xF95B,0xF95C,0xF95D,0xF95E,0xF95F,0xF960,0xF961,0xF962,0xF963,
	0xF964,0xF965,0xF966,0xF967,0xF968,0xF969,0xF96A,0xF96B,0xF96C,0xF96D,0xF96E,0xF96F,0xF970,0xF971,0xF972,0xF973,
	0xF974,0xF975,0xF976,0xF977,0xF978,0xF979,0xF97A,0xF97B,0xF97C,0xF97D,0xF97E,0xF980,0xF981,0xF982,0xF983,0xF984,
	0xF985,0xF986,0xF987,0xF988,0xF989,0xF98A,0xF98B,0xF98C,0xF98D,0xF98E,0xF98F,0xF990,0xF991,0xF992,0xF993,0xF994,
	0xF995,0xF996,0xF997,0xF998,0xF999,0xF99A,0xF99B,0xF99C,0xF99D,0xF99E,0xF99F,0xF9A0,0xF9A1,0xF9A2,0xF9A3,0xF9A4,
};
static const WORD _ucs_to_sjis_E700_data []={ //E700 E757
	0xF9A5,0xF9A6,0xF9A7,0xF9A8,0xF9A9,0xF9AA,0xF9AB,0xF9AC,0xF9AD,0xF9AE,0xF9AF,0xF9B0,0xF9B1,0xF9B2,0xF9B3,0xF9B4,
	0xF9B5,0xF9B6,0xF9B7,0xF9B8,0xF9B9,0xF9BA,0xF9BB,0xF9BC,0xF9BD,0xF9BE,0xF9BF,0xF9C0,0xF9C1,0xF9C2,0xF9C3,0xF9C4,
	0xF9C5,0xF9C6,0xF9C7,0xF9C8,0xF9C9,0xF9CA,0xF9CB,0xF9CC,0xF9CD,0xF9CE,0xF9CF,0xF9D0,0xF9D1,0xF9D2,0xF9D3,0xF9D4,
	0xF9D5,0xF9D6,0xF9D7,0xF9D8,0xF9D9,0xF9DA,0xF9DB,0xF9DC,0xF9DD,0xF9DE,0xF9DF,0xF9E0,0xF9E1,0xF9E2,0xF9E3,0xF9E4,
	0xF9E5,0xF9E6,0xF9E7,0xF9E8,0xF9E9,0xF9EA,0xF9EB,0xF9EC,0xF9ED,0xF9EE,0xF9EF,0xF9F0,0xF9F1,0xF9F2,0xF9F3,0xF9F4,
	0xF9F5,0xF9F6,0xF9F7,0xF9F8,0xF9F9,0xF9FA,0xF9FB,0xF9FC,
};
static const WORD _ucs_to_sjis_F800_data []={ //F8F0 F8F3
	0x00A0,0x00FD,0x00FE,0x00FF,
};
static const WORD _ucs_to_sjis_F900_data []={ //F929 F9DC
	                                                               0xFAE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBE9,
};
static const WORD _ucs_to_sjis_FA00_data []={ //FA0E FA2D
	                                                                                                  0xFA90,0xFA9B,
	0xFA9C,0xFAB1,0xFAD8,0xFAE8,0xFAEA,0xFB58,0xFB5E,0xFB75,0xFB7D,0xFB7E,0xFB80,0xFB82,0xFB86,0xFB89,0xFB92,0xFB9D,
	0xFB9F,0xFBA0,0xFBA9,0xFBB1,0xFBB3,0xFBB4,0xFBB7,0xFBD3,0xFBDA,0xFBEA,0xFBF6,0xFBF7,0xFBF9,0xFC49,
};
static const WORD _ucs_to_sjis_FF00_data []={ //FF01 FFE5
	       0x8149,0xFA57,0x8194,0x8190,0x8193,0x8195,0xFA56,0x8169,0x816A,0x8196,0x817B,0x8143,0x817C,0x8144,0x815E,
	0x824F,0x8250,0x8251,0x8252,0x8253,0x8254,0x8255,0x8256,0x8257,0x8258,0x8146,0x8147,0x8183,0x8181,0x8184,0x8148,
	0x8197,0x8260,0x8261,0x8262,0x8263,0x8264,0x8265,0x8266,0x8267,0x8268,0x8269,0x826A,0x826B,0x826C,0x826D,0x826E,
	0x826F,0x8270,0x8271,0x8272,0x8273,0x8274,0x8275,0x8276,0x8277,0x8278,0x8279,0x816D,0x815F,0x816E,0x814F,0x8151,
	0x814D,0x8281,0x8282,0x8283,0x8284,0x8285,0x8286,0x8287,0x8288,0x8289,0x828A,0x828B,0x828C,0x828D,0x828E,0x828F,
	0x8290,0x8291,0x8292,0x8293,0x8294,0x8295,0x8296,0x8297,0x8298,0x8299,0x829A,0x816F,0x8162,0x8170,0x8160,0x0000,
	0x0000,0x00A1,0x00A2,0x00A3,0x00A4,0x00A5,0x00A6,0x00A7,0x00A8,0x00A9,0x00AA,0x00AB,0x00AC,0x00AD,0x00AE,0x00AF,
	0x00B0,0x00B1,0x00B2,0x00B3,0x00B4,0x00B5,0x00B6,0x00B7,0x00B8,0x00B9,0x00BA,0x00BB,0x00BC,0x00BD,0x00BE,0x00BF,
	0x00C0,0x00C1,0x00C2,0x00C3,0x00C4,0x00C5,0x00C6,0x00C7,0x00C8,0x00C9,0x00CA,0x00CB,0x00CC,0x00CD,0x00CE,0x00CF,
	0x00D0,0x00D1,0x00D2,0x00D3,0x00D4,0x00D5,0x00D6,0x00D7,0x00D8,0x00D9,0x00DA,0x00DB,0x00DC,0x00DD,0x00DE,0x00DF,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x8191,0x8192,0x81CA,0x8150,0xFA55,0x818F,
};
extern const struct _encoding_table_u _ucs_to_sjis_table []={
	{ 0x00FF,0x0001,_ucs_to_sjis_0000_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x03C9,0x0391,_ucs_to_sjis_0300_data },
	{ 0x0451,0x0401,_ucs_to_sjis_0400_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x203B,0x2010,_ucs_to_sjis_2000_data },
	{ 0x21D4,0x2103,_ucs_to_sjis_2100_data },
	{ 0x22BF,0x2200,_ucs_to_sjis_2200_data },
	{ 0x2312,0x2312,_ucs_to_sjis_2300_data },
	{ 0x2473,0x2460,_ucs_to_sjis_2400_data },
	{ 0x25EF,0x2500,_ucs_to_sjis_2500_data },
	{ 0x266F,0x2605,_ucs_to_sjis_2600_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x30FE,0x3000,_ucs_to_sjis_3000_data },
	{0,0xffff,0},
	{ 0x32A8,0x3231,_ucs_to_sjis_3200_data },
	{ 0x33CD,0x3303,_ucs_to_sjis_3300_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x4EFC,0x4E00,_ucs_to_sjis_4E00_data },
	{ 0x4FFF,0x4F00,_ucs_to_sjis_4F00_data },
	{ 0x50FB,0x5005,_ucs_to_sjis_5000_data },
	{ 0x51FE,0x5100,_ucs_to_sjis_5100_data },
	{ 0x52FF,0x5200,_ucs_to_sjis_5200_data },
	{ 0x53FA,0x5300,_ucs_to_sjis_5300_data },
	{ 0x54FF,0x5401,_ucs_to_sjis_5400_data },
	{ 0x55FE,0x5504,_ucs_to_sjis_5500_data },
	{ 0x56FF,0x5606,_ucs_to_sjis_5600_data },
	{ 0x57FC,0x5700,_ucs_to_sjis_5700_data },
	{ 0x58FD,0x5800,_ucs_to_sjis_5800_data },
	{ 0x59FF,0x5902,_ucs_to_sjis_5900_data },
	{ 0x5AFB,0x5A01,_ucs_to_sjis_5A00_data },
	{ 0x5BFF,0x5B09,_ucs_to_sjis_5B00_data },
	{ 0x5CFD,0x5C01,_ucs_to_sjis_5C00_data },
	{ 0x5DFE,0x5D07,_ucs_to_sjis_5D00_data },
	{ 0x5EFF,0x5E02,_ucs_to_sjis_5E00_data },
	{ 0x5FFF,0x5F01,_ucs_to_sjis_5F00_data },
	{ 0x60FB,0x600E,_ucs_to_sjis_6000_data },
	{ 0x61FF,0x6100,_ucs_to_sjis_6100_data },
	{ 0x62FF,0x6200,_ucs_to_sjis_6200_data },
	{ 0x63FA,0x6301,_ucs_to_sjis_6300_data },
	{ 0x64FE,0x6406,_ucs_to_sjis_6400_data },
	{ 0x65FB,0x6500,_ucs_to_sjis_6500_data },
	{ 0x66FF,0x6600,_ucs_to_sjis_6600_data },
	{ 0x67FF,0x6700,_ucs_to_sjis_6700_data },
	{ 0x68FA,0x6801,_ucs_to_sjis_6800_data },
	{ 0x69FF,0x6900,_ucs_to_sjis_6900_data },
	{ 0x6AFB,0x6A02,_ucs_to_sjis_6A00_data },
	{ 0x6BF3,0x6B04,_ucs_to_sjis_6B00_data },
	{ 0x6CF3,0x6C08,_ucs_to_sjis_6C00_data },
	{ 0x6DFC,0x6D04,_ucs_to_sjis_6D00_data },
	{ 0x6EFF,0x6E05,_ucs_to_sjis_6E00_data },
	{ 0x6FFE,0x6F01,_ucs_to_sjis_6F00_data },
	{ 0x70FD,0x7001,_ucs_to_sjis_7000_data },
	{ 0x71FF,0x7104,_ucs_to_sjis_7100_data },
	{ 0x72FD,0x7206,_ucs_to_sjis_7200_data },
	{ 0x73FE,0x730A,_ucs_to_sjis_7300_data },
	{ 0x74F8,0x7403,_ucs_to_sjis_7400_data },
	{ 0x75FF,0x7501,_ucs_to_sjis_7500_data },
	{ 0x76FE,0x7601,_ucs_to_sjis_7600_data },
	{ 0x77FC,0x7701,_ucs_to_sjis_7700_data },
	{ 0x78FD,0x7802,_ucs_to_sjis_7800_data },
	{ 0x79FB,0x7901,_ucs_to_sjis_7900_data },
	{ 0x7AFF,0x7A00,_ucs_to_sjis_7A00_data },
	{ 0x7BF7,0x7B02,_ucs_to_sjis_7B00_data },
	{ 0x7CFE,0x7C00,_ucs_to_sjis_7C00_data },
	{ 0x7DFB,0x7D00,_ucs_to_sjis_7D00_data },
	{ 0x7E9C,0x7E01,_ucs_to_sjis_7E00_data },
	{ 0x7FFC,0x7F36,_ucs_to_sjis_7F00_data },
	{ 0x80FD,0x8000,_ucs_to_sjis_8000_data },
	{ 0x81FE,0x8102,_ucs_to_sjis_8100_data },
	{ 0x82FB,0x8201,_ucs_to_sjis_8200_data },
	{ 0x83FD,0x8301,_ucs_to_sjis_8300_data },
	{ 0x84FF,0x8403,_ucs_to_sjis_8400_data },
	{ 0x85FE,0x8500,_ucs_to_sjis_8500_data },
	{ 0x86FE,0x8602,_ucs_to_sjis_8600_data },
	{ 0x87FE,0x8700,_ucs_to_sjis_8700_data },
	{ 0x88FE,0x8805,_ucs_to_sjis_8800_data },
	{ 0x89F8,0x8902,_ucs_to_sjis_8900_data },
	{ 0x8AFE,0x8A00,_ucs_to_sjis_8A00_data },
	{ 0x8B9A,0x8B00,_ucs_to_sjis_8B00_data },
	{ 0x8CFD,0x8C37,_ucs_to_sjis_8C00_data },
	{ 0x8DFF,0x8D04,_ucs_to_sjis_8D00_data },
	{ 0x8EFE,0x8E08,_ucs_to_sjis_8E00_data },
	{ 0x8FFD,0x8F03,_ucs_to_sjis_8F00_data },
	{ 0x90FD,0x9000,_ucs_to_sjis_9000_data },
	{ 0x91FF,0x9102,_ucs_to_sjis_9100_data },
	{ 0x92FF,0x9206,_ucs_to_sjis_9200_data },
	{ 0x93F8,0x9302,_ucs_to_sjis_9300_data },
	{ 0x9481,0x9403,_ucs_to_sjis_9400_data },
	{ 0x95E5,0x9577,_ucs_to_sjis_9500_data },
	{ 0x96FB,0x961C,_ucs_to_sjis_9600_data },
	{ 0x97FF,0x9700,_ucs_to_sjis_9700_data },
	{ 0x98FE,0x9801,_ucs_to_sjis_9800_data },
	{ 0x99FF,0x9903,_ucs_to_sjis_9900_data },
	{ 0x9AFB,0x9A01,_ucs_to_sjis_9A00_data },
	{ 0x9BF5,0x9B06,_ucs_to_sjis_9B00_data },
	{ 0x9CF6,0x9C00,_ucs_to_sjis_9C00_data },
	{ 0x9DFD,0x9D03,_ucs_to_sjis_9D00_data },
	{ 0x9EFD,0x9E19,_ucs_to_sjis_9E00_data },
	{ 0x9FA0,0x9F07,_ucs_to_sjis_9F00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xE0FF,0xE000,_ucs_to_sjis_E000_data },
	{ 0xE1FF,0xE100,_ucs_to_sjis_E100_data },
	{ 0xE2FF,0xE200,_ucs_to_sjis_E200_data },
	{ 0xE3FF,0xE300,_ucs_to_sjis_E300_data },
	{ 0xE4FF,0xE400,_ucs_to_sjis_E400_data },
	{ 0xE5FF,0xE500,_ucs_to_sjis_E500_data },
	{ 0xE6FF,0xE600,_ucs_to_sjis_E600_data },
	{ 0xE757,0xE700,_ucs_to_sjis_E700_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xF8F3,0xF8F0,_ucs_to_sjis_F800_data },
	{ 0xF9DC,0xF929,_ucs_to_sjis_F900_data },
	{ 0xFA2D,0xFA0E,_ucs_to_sjis_FA00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xFFE5,0xFF01,_ucs_to_sjis_FF00_data },
};
static const WCHAR _eucj_to_ucs_0000_data []={ //0001 00FF
	       0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
	0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,0x0088,0x0089,0x008A,0x008B,0x008C,0x008D,0x008E,0x008F,
	0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,0x0098,0x0099,0x009A,0x009B,0x009C,0x009D,0x009E,0x009F,
	0xF8F0,0x00A1,0x00A2,0x00A3,0x00A4,0x00A5,0x00A6,0x00A7,0x00A8,0x00A9,0x00AA,0x00AB,0x00AC,0x00AD,0x00AE,0x00AF,
	0x00B0,0x00B1,0x00B2,0x00B3,0x00B4,0x00B5,0x00B6,0x00B7,0x00B8,0x00B9,0x00BA,0x00BB,0x00BC,0x00BD,0x00BE,0x00BF,
	0x00C0,0x00C1,0x00C2,0x00C3,0x00C4,0x00C5,0x00C6,0x00C7,0x00C8,0x00C9,0x00CA,0x00CB,0x00CC,0x00CD,0x00CE,0x00CF,
	0x00D0,0x00D1,0x00D2,0x00D3,0x00D4,0x00D5,0x00D6,0x00D7,0x00D8,0x00D9,0x00DA,0x00DB,0x00DC,0x00DD,0x00DE,0x00DF,
	0x00E0,0x00E1,0x00E2,0x00E3,0x00E4,0x00E5,0x00E6,0x00E7,0x00E8,0x00E9,0x00EA,0x00EB,0x00EC,0x00ED,0x00EE,0x00EF,
	0x00F0,0x00F1,0x00F2,0x00F3,0x00F4,0x00F5,0x00F6,0x00F7,0x00F8,0x00F9,0x00FA,0x00FB,0x00FC,0x00FD,0x00FE,0xF8F3,
};
static const WCHAR _eucj_to_ucs_8E00_data []={ //8EA1 8EDF
	       0xFF61,0xFF62,0xFF63,0xFF64,0xFF65,0xFF66,0xFF67,0xFF68,0xFF69,0xFF6A,0xFF6B,0xFF6C,0xFF6D,0xFF6E,0xFF6F,
	0xFF70,0xFF71,0xFF72,0xFF73,0xFF74,0xFF75,0xFF76,0xFF77,0xFF78,0xFF79,0xFF7A,0xFF7B,0xFF7C,0xFF7D,0xFF7E,0xFF7F,
	0xFF80,0xFF81,0xFF82,0xFF83,0xFF84,0xFF85,0xFF86,0xFF87,0xFF88,0xFF89,0xFF8A,0xFF8B,0xFF8C,0xFF8D,0xFF8E,0xFF8F,
	0xFF90,0xFF91,0xFF92,0xFF93,0xFF94,0xFF95,0xFF96,0xFF97,0xFF98,0xFF99,0xFF9A,0xFF9B,0xFF9C,0xFF9D,0xFF9E,0xFF9F,
};
static const WCHAR _eucj_to_ucs_A100_data []={ //A1A1 A1FE
	       0x3000,0x3001,0x3002,0xFF0C,0xFF0E,0x30FB,0xFF1A,0xFF1B,0xFF1F,0xFF01,0x309B,0x309C,0x00B4,0xFF40,0x00A8,
	0xFF3E,0xFFE3,0xFF3F,0x30FD,0x30FE,0x309D,0x309E,0x3003,0x4EDD,0x3005,0x3006,0x3007,0x30FC,0x2015,0x2010,0xFF0F,
	0xFF3C,0xFF5E,0x2225,0xFF5C,0x2026,0x2025,0x2018,0x2019,0x201C,0x201D,0xFF08,0xFF09,0x3014,0x3015,0xFF3B,0xFF3D,
	0xFF5B,0xFF5D,0x3008,0x3009,0x300A,0x300B,0x300C,0x300D,0x300E,0x300F,0x3010,0x3011,0xFF0B,0xFF0D,0x00B1,0x00D7,
	0x00F7,0xFF1D,0x2260,0xFF1C,0xFF1E,0x2266,0x2267,0x221E,0x2234,0x2642,0x2640,0x00B0,0x2032,0x2033,0x2103,0xFFE5,
	0xFF04,0xFFE0,0xFFE1,0xFF05,0xFF03,0xFF06,0xFF0A,0xFF20,0x00A7,0x2606,0x2605,0x25CB,0x25CF,0x25CE,0x25C7,
};
static const WCHAR _eucj_to_ucs_A200_data []={ //A2A1 A2FE
	       0x25C6,0x25A1,0x25A0,0x25B3,0x25B2,0x25BD,0x25BC,0x203B,0x3012,0x2192,0x2190,0x2191,0x2193,0x3013,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2208,0x220B,0x2286,0x2287,0x2282,0x2283,
	0x222A,0x2229,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2227,0x2228,0xFFE2,0x21D2,0x21D4,0x2200,
	0x2203,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2220,0x22A5,0x2312,0x2202,
	0x2207,0x2261,0x2252,0x226A,0x226B,0x221A,0x223D,0x221D,0x2235,0x222B,0x222C,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x212B,0x2030,0x266F,0x266D,0x266A,0x2020,0x2021,0x00B6,0x0000,0x0000,0x0000,0x0000,0x25EF,
};
static const WCHAR _eucj_to_ucs_A300_data []={ //A3B0 A3FA
	0xFF10,0xFF11,0xFF12,0xFF13,0xFF14,0xFF15,0xFF16,0xFF17,0xFF18,0xFF19,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xFF21,0xFF22,0xFF23,0xFF24,0xFF25,0xFF26,0xFF27,0xFF28,0xFF29,0xFF2A,0xFF2B,0xFF2C,0xFF2D,0xFF2E,0xFF2F,
	0xFF30,0xFF31,0xFF32,0xFF33,0xFF34,0xFF35,0xFF36,0xFF37,0xFF38,0xFF39,0xFF3A,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xFF41,0xFF42,0xFF43,0xFF44,0xFF45,0xFF46,0xFF47,0xFF48,0xFF49,0xFF4A,0xFF4B,0xFF4C,0xFF4D,0xFF4E,0xFF4F,
	0xFF50,0xFF51,0xFF52,0xFF53,0xFF54,0xFF55,0xFF56,0xFF57,0xFF58,0xFF59,0xFF5A,
};
static const WCHAR _eucj_to_ucs_A400_data []={ //A4A1 A4F3
	       0x3041,0x3042,0x3043,0x3044,0x3045,0x3046,0x3047,0x3048,0x3049,0x304A,0x304B,0x304C,0x304D,0x304E,0x304F,
	0x3050,0x3051,0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,0x3058,0x3059,0x305A,0x305B,0x305C,0x305D,0x305E,0x305F,
	0x3060,0x3061,0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,0x3068,0x3069,0x306A,0x306B,0x306C,0x306D,0x306E,0x306F,
	0x3070,0x3071,0x3072,0x3073,0x3074,0x3075,0x3076,0x3077,0x3078,0x3079,0x307A,0x307B,0x307C,0x307D,0x307E,0x307F,
	0x3080,0x3081,0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,0x3088,0x3089,0x308A,0x308B,0x308C,0x308D,0x308E,0x308F,
	0x3090,0x3091,0x3092,0x3093,
};
static const WCHAR _eucj_to_ucs_A500_data []={ //A5A1 A5F6
	       0x30A1,0x30A2,0x30A3,0x30A4,0x30A5,0x30A6,0x30A7,0x30A8,0x30A9,0x30AA,0x30AB,0x30AC,0x30AD,0x30AE,0x30AF,
	0x30B0,0x30B1,0x30B2,0x30B3,0x30B4,0x30B5,0x30B6,0x30B7,0x30B8,0x30B9,0x30BA,0x30BB,0x30BC,0x30BD,0x30BE,0x30BF,
	0x30C0,0x30C1,0x30C2,0x30C3,0x30C4,0x30C5,0x30C6,0x30C7,0x30C8,0x30C9,0x30CA,0x30CB,0x30CC,0x30CD,0x30CE,0x30CF,
	0x30D0,0x30D1,0x30D2,0x30D3,0x30D4,0x30D5,0x30D6,0x30D7,0x30D8,0x30D9,0x30DA,0x30DB,0x30DC,0x30DD,0x30DE,0x30DF,
	0x30E0,0x30E1,0x30E2,0x30E3,0x30E4,0x30E5,0x30E6,0x30E7,0x30E8,0x30E9,0x30EA,0x30EB,0x30EC,0x30ED,0x30EE,0x30EF,
	0x30F0,0x30F1,0x30F2,0x30F3,0x30F4,0x30F5,0x30F6,
};
static const WCHAR _eucj_to_ucs_A600_data []={ //A6A1 A6D8
	       0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039A,0x039B,0x039C,0x039D,0x039E,0x039F,
	0x03A0,0x03A1,0x03A3,0x03A4,0x03A5,0x03A6,0x03A7,0x03A8,0x03A9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x03B1,0x03B2,0x03B3,0x03B4,0x03B5,0x03B6,0x03B7,0x03B8,0x03B9,0x03BA,0x03BB,0x03BC,0x03BD,0x03BE,0x03BF,
	0x03C0,0x03C1,0x03C3,0x03C4,0x03C5,0x03C6,0x03C7,0x03C8,0x03C9,
};
static const WCHAR _eucj_to_ucs_A700_data []={ //A7A1 A7F1
	       0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0401,0x0416,0x0417,0x0418,0x0419,0x041A,0x041B,0x041C,0x041D,
	0x041E,0x041F,0x0420,0x0421,0x0422,0x0423,0x0424,0x0425,0x0426,0x0427,0x0428,0x0429,0x042A,0x042B,0x042C,0x042D,
	0x042E,0x042F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0451,0x0436,0x0437,0x0438,0x0439,0x043A,0x043B,0x043C,0x043D,
	0x043E,0x043F,0x0440,0x0441,0x0442,0x0443,0x0444,0x0445,0x0446,0x0447,0x0448,0x0449,0x044A,0x044B,0x044C,0x044D,
	0x044E,0x044F,
};
static const WCHAR _eucj_to_ucs_A800_data []={ //A8A1 A8C0
	       0x2500,0x2502,0x250C,0x2510,0x2518,0x2514,0x251C,0x252C,0x2524,0x2534,0x253C,0x2501,0x2503,0x250F,0x2513,
	0x251B,0x2517,0x2523,0x2533,0x252B,0x253B,0x254B,0x2520,0x252F,0x2528,0x2537,0x253F,0x251D,0x2530,0x2525,0x2538,
	0x2542,
};
static const WCHAR _eucj_to_ucs_AD00_data []={ //ADA1 ADF9
	       0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467,0x2468,0x2469,0x246A,0x246B,0x246C,0x246D,0x246E,
	0x246F,0x2470,0x2471,0x2472,0x2473,0x2160,0x2161,0x2162,0x2163,0x2164,0x2165,0x2166,0x2167,0x2168,0x2169,0x0000,
	0x3349,0x3314,0x3322,0x334D,0x3318,0x3327,0x3303,0x3336,0x3351,0x3357,0x330D,0x3326,0x3323,0x332B,0x334A,0x333B,
	0x339C,0x339D,0x339E,0x338E,0x338F,0x33C4,0x33A1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x337B,
	0x301D,0x301F,0x2116,0x33CD,0x2121,0x32A4,0x32A5,0x32A6,0x32A7,0x32A8,0x3231,0x3232,0x3239,0x337E,0x337D,0x337C,
	0x0000,0x0000,0x0000,0x222E,0x2211,0x0000,0x0000,0x0000,0x221F,0x22BF,
};
static const WCHAR _eucj_to_ucs_B000_data []={ //B0A1 B0FE
	       0x4E9C,0x5516,0x5A03,0x963F,0x54C0,0x611B,0x6328,0x59F6,0x9022,0x8475,0x831C,0x7A50,0x60AA,0x63E1,0x6E25,
	0x65ED,0x8466,0x82A6,0x9BF5,0x6893,0x5727,0x65A1,0x6271,0x5B9B,0x59D0,0x867B,0x98F4,0x7D62,0x7DBE,0x9B8E,0x6216,
	0x7C9F,0x88B7,0x5B89,0x5EB5,0x6309,0x6697,0x6848,0x95C7,0x978D,0x674F,0x4EE5,0x4F0A,0x4F4D,0x4F9D,0x5049,0x56F2,
	0x5937,0x59D4,0x5A01,0x5C09,0x60DF,0x610F,0x6170,0x6613,0x6905,0x70BA,0x754F,0x7570,0x79FB,0x7DAD,0x7DEF,0x80C3,
	0x840E,0x8863,0x8B02,0x9055,0x907A,0x533B,0x4E95,0x4EA5,0x57DF,0x80B2,0x90C1,0x78EF,0x4E00,0x58F1,0x6EA2,0x9038,
	0x7A32,0x8328,0x828B,0x9C2F,0x5141,0x5370,0x54BD,0x54E1,0x56E0,0x59FB,0x5F15,0x98F2,0x6DEB,0x80E4,0x852D,
};
static const WCHAR _eucj_to_ucs_B100_data []={ //B1A1 B1FE
	       0x9662,0x9670,0x96A0,0x97FB,0x540B,0x53F3,0x5B87,0x70CF,0x7FBD,0x8FC2,0x96E8,0x536F,0x9D5C,0x7ABA,0x4E11,
	0x7893,0x81FC,0x6E26,0x5618,0x5504,0x6B1D,0x851A,0x9C3B,0x59E5,0x53A9,0x6D66,0x74DC,0x958F,0x5642,0x4E91,0x904B,
	0x96F2,0x834F,0x990C,0x53E1,0x55B6,0x5B30,0x5F71,0x6620,0x66F3,0x6804,0x6C38,0x6CF3,0x6D29,0x745B,0x76C8,0x7A4E,
	0x9834,0x82F1,0x885B,0x8A60,0x92ED,0x6DB2,0x75AB,0x76CA,0x99C5,0x60A6,0x8B01,0x8D8A,0x95B2,0x698E,0x53AD,0x5186,
	0x5712,0x5830,0x5944,0x5BB4,0x5EF6,0x6028,0x63A9,0x63F4,0x6CBF,0x6F14,0x708E,0x7114,0x7159,0x71D5,0x733F,0x7E01,
	0x8276,0x82D1,0x8597,0x9060,0x925B,0x9D1B,0x5869,0x65BC,0x6C5A,0x7525,0x51F9,0x592E,0x5965,0x5F80,0x5FDC,
};
static const WCHAR _eucj_to_ucs_B200_data []={ //B2A1 B2FE
	       0x62BC,0x65FA,0x6A2A,0x6B27,0x6BB4,0x738B,0x7FC1,0x8956,0x9D2C,0x9D0E,0x9EC4,0x5CA1,0x6C96,0x837B,0x5104,
	0x5C4B,0x61B6,0x81C6,0x6876,0x7261,0x4E59,0x4FFA,0x5378,0x6069,0x6E29,0x7A4F,0x97F3,0x4E0B,0x5316,0x4EEE,0x4F55,
	0x4F3D,0x4FA1,0x4F73,0x52A0,0x53EF,0x5609,0x590F,0x5AC1,0x5BB6,0x5BE1,0x79D1,0x6687,0x679C,0x67B6,0x6B4C,0x6CB3,
	0x706B,0x73C2,0x798D,0x79BE,0x7A3C,0x7B87,0x82B1,0x82DB,0x8304,0x8377,0x83EF,0x83D3,0x8766,0x8AB2,0x5629,0x8CA8,
	0x8FE6,0x904E,0x971E,0x868A,0x4FC4,0x5CE8,0x6211,0x7259,0x753B,0x81E5,0x82BD,0x86FE,0x8CC0,0x96C5,0x9913,0x99D5,
	0x4ECB,0x4F1A,0x89E3,0x56DE,0x584A,0x58CA,0x5EFB,0x5FEB,0x602A,0x6094,0x6062,0x61D0,0x6212,0x62D0,0x6539,
};
static const WCHAR _eucj_to_ucs_B300_data []={ //B3A1 B3FE
	       0x9B41,0x6666,0x68B0,0x6D77,0x7070,0x754C,0x7686,0x7D75,0x82A5,0x87F9,0x958B,0x968E,0x8C9D,0x51F1,0x52BE,
	0x5916,0x54B3,0x5BB3,0x5D16,0x6168,0x6982,0x6DAF,0x788D,0x84CB,0x8857,0x8A72,0x93A7,0x9AB8,0x6D6C,0x99A8,0x86D9,
	0x57A3,0x67FF,0x86CE,0x920E,0x5283,0x5687,0x5404,0x5ED3,0x62E1,0x64B9,0x683C,0x6838,0x6BBB,0x7372,0x78BA,0x7A6B,
	0x899A,0x89D2,0x8D6B,0x8F03,0x90ED,0x95A3,0x9694,0x9769,0x5B66,0x5CB3,0x697D,0x984D,0x984E,0x639B,0x7B20,0x6A2B,
	0x6A7F,0x68B6,0x9C0D,0x6F5F,0x5272,0x559D,0x6070,0x62EC,0x6D3B,0x6E07,0x6ED1,0x845B,0x8910,0x8F44,0x4E14,0x9C39,
	0x53F6,0x691B,0x6A3A,0x9784,0x682A,0x515C,0x7AC3,0x84B2,0x91DC,0x938C,0x565B,0x9D28,0x6822,0x8305,0x8431,
};
static const WCHAR _eucj_to_ucs_B400_data []={ //B4A1 B4FE
	       0x7CA5,0x5208,0x82C5,0x74E6,0x4E7E,0x4F83,0x51A0,0x5BD2,0x520A,0x52D8,0x52E7,0x5DFB,0x559A,0x582A,0x59E6,
	0x5B8C,0x5B98,0x5BDB,0x5E72,0x5E79,0x60A3,0x611F,0x6163,0x61BE,0x63DB,0x6562,0x67D1,0x6853,0x68FA,0x6B3E,0x6B53,
	0x6C57,0x6F22,0x6F97,0x6F45,0x74B0,0x7518,0x76E3,0x770B,0x7AFF,0x7BA1,0x7C21,0x7DE9,0x7F36,0x7FF0,0x809D,0x8266,
	0x839E,0x89B3,0x8ACC,0x8CAB,0x9084,0x9451,0x9593,0x9591,0x95A2,0x9665,0x97D3,0x9928,0x8218,0x4E38,0x542B,0x5CB8,
	0x5DCC,0x73A9,0x764C,0x773C,0x5CA9,0x7FEB,0x8D0B,0x96C1,0x9811,0x9854,0x9858,0x4F01,0x4F0E,0x5371,0x559C,0x5668,
	0x57FA,0x5947,0x5B09,0x5BC4,0x5C90,0x5E0C,0x5E7E,0x5FCC,0x63EE,0x673A,0x65D7,0x65E2,0x671F,0x68CB,0x68C4,
};
static const WCHAR _eucj_to_ucs_B500_data []={ //B5A1 B5FE
	       0x6A5F,0x5E30,0x6BC5,0x6C17,0x6C7D,0x757F,0x7948,0x5B63,0x7A00,0x7D00,0x5FBD,0x898F,0x8A18,0x8CB4,0x8D77,
	0x8ECC,0x8F1D,0x98E2,0x9A0E,0x9B3C,0x4E80,0x507D,0x5100,0x5993,0x5B9C,0x622F,0x6280,0x64EC,0x6B3A,0x72A0,0x7591,
	0x7947,0x7FA9,0x87FB,0x8ABC,0x8B70,0x63AC,0x83CA,0x97A0,0x5409,0x5403,0x55AB,0x6854,0x6A58,0x8A70,0x7827,0x6775,
	0x9ECD,0x5374,0x5BA2,0x811A,0x8650,0x9006,0x4E18,0x4E45,0x4EC7,0x4F11,0x53CA,0x5438,0x5BAE,0x5F13,0x6025,0x6551,
	0x673D,0x6C42,0x6C72,0x6CE3,0x7078,0x7403,0x7A76,0x7AAE,0x7B08,0x7D1A,0x7CFE,0x7D66,0x65E7,0x725B,0x53BB,0x5C45,
	0x5DE8,0x62D2,0x62E0,0x6319,0x6E20,0x865A,0x8A31,0x8DDD,0x92F8,0x6F01,0x79A6,0x9B5A,0x4EA8,0x4EAB,0x4EAC,
};
static const WCHAR _eucj_to_ucs_B600_data []={ //B6A1 B6FE
	       0x4F9B,0x4FA0,0x50D1,0x5147,0x7AF6,0x5171,0x51F6,0x5354,0x5321,0x537F,0x53EB,0x55AC,0x5883,0x5CE1,0x5F37,
	0x5F4A,0x602F,0x6050,0x606D,0x631F,0x6559,0x6A4B,0x6CC1,0x72C2,0x72ED,0x77EF,0x80F8,0x8105,0x8208,0x854E,0x90F7,
	0x93E1,0x97FF,0x9957,0x9A5A,0x4EF0,0x51DD,0x5C2D,0x6681,0x696D,0x5C40,0x66F2,0x6975,0x7389,0x6850,0x7C81,0x50C5,
	0x52E4,0x5747,0x5DFE,0x9326,0x65A4,0x6B23,0x6B3D,0x7434,0x7981,0x79BD,0x7B4B,0x7DCA,0x82B9,0x83CC,0x887F,0x895F,
	0x8B39,0x8FD1,0x91D1,0x541F,0x9280,0x4E5D,0x5036,0x53E5,0x533A,0x72D7,0x7396,0x77E9,0x82E6,0x8EAF,0x99C6,0x99C8,
	0x99D2,0x5177,0x611A,0x865E,0x55B0,0x7A7A,0x5076,0x5BD3,0x9047,0x9685,0x4E32,0x6ADB,0x91E7,0x5C51,0x5C48,
};
static const WCHAR _eucj_to_ucs_B700_data []={ //B7A1 B7FE
	       0x6398,0x7A9F,0x6C93,0x9774,0x8F61,0x7AAA,0x718A,0x9688,0x7C82,0x6817,0x7E70,0x6851,0x936C,0x52F2,0x541B,
	0x85AB,0x8A13,0x7FA4,0x8ECD,0x90E1,0x5366,0x8888,0x7941,0x4FC2,0x50BE,0x5211,0x5144,0x5553,0x572D,0x73EA,0x578B,
	0x5951,0x5F62,0x5F84,0x6075,0x6176,0x6167,0x61A9,0x63B2,0x643A,0x656C,0x666F,0x6842,0x6E13,0x7566,0x7A3D,0x7CFB,
	0x7D4C,0x7D99,0x7E4B,0x7F6B,0x830E,0x834A,0x86CD,0x8A08,0x8A63,0x8B66,0x8EFD,0x981A,0x9D8F,0x82B8,0x8FCE,0x9BE8,
	0x5287,0x621F,0x6483,0x6FC0,0x9699,0x6841,0x5091,0x6B20,0x6C7A,0x6F54,0x7A74,0x7D50,0x8840,0x8A23,0x6708,0x4EF6,
	0x5039,0x5026,0x5065,0x517C,0x5238,0x5263,0x55A7,0x570F,0x5805,0x5ACC,0x5EFA,0x61B2,0x61F8,0x62F3,0x6372,
};
static const WCHAR _eucj_to_ucs_B800_data []={ //B8A1 B8FE
	       0x691C,0x6A29,0x727D,0x72AC,0x732E,0x7814,0x786F,0x7D79,0x770C,0x80A9,0x898B,0x8B19,0x8CE2,0x8ED2,0x9063,
	0x9375,0x967A,0x9855,0x9A13,0x9E78,0x5143,0x539F,0x53B3,0x5E7B,0x5F26,0x6E1B,0x6E90,0x7384,0x73FE,0x7D43,0x8237,
	0x8A00,0x8AFA,0x9650,0x4E4E,0x500B,0x53E4,0x547C,0x56FA,0x59D1,0x5B64,0x5DF1,0x5EAB,0x5F27,0x6238,0x6545,0x67AF,
	0x6E56,0x72D0,0x7CCA,0x88B4,0x80A1,0x80E1,0x83F0,0x864E,0x8A87,0x8DE8,0x9237,0x96C7,0x9867,0x9F13,0x4E94,0x4E92,
	0x4F0D,0x5348,0x5449,0x543E,0x5A2F,0x5F8C,0x5FA1,0x609F,0x68A7,0x6A8E,0x745A,0x7881,0x8A9E,0x8AA4,0x8B77,0x9190,
	0x4E5E,0x9BC9,0x4EA4,0x4F7C,0x4FAF,0x5019,0x5016,0x5149,0x516C,0x529F,0x52B9,0x52FE,0x539A,0x53E3,0x5411,
};
static const WCHAR _eucj_to_ucs_B900_data []={ //B9A1 B9FE
	       0x540E,0x5589,0x5751,0x57A2,0x597D,0x5B54,0x5B5D,0x5B8F,0x5DE5,0x5DE7,0x5DF7,0x5E78,0x5E83,0x5E9A,0x5EB7,
	0x5F18,0x6052,0x614C,0x6297,0x62D8,0x63A7,0x653B,0x6602,0x6643,0x66F4,0x676D,0x6821,0x6897,0x69CB,0x6C5F,0x6D2A,
	0x6D69,0x6E2F,0x6E9D,0x7532,0x7687,0x786C,0x7A3F,0x7CE0,0x7D05,0x7D18,0x7D5E,0x7DB1,0x8015,0x8003,0x80AF,0x80B1,
	0x8154,0x818F,0x822A,0x8352,0x884C,0x8861,0x8B1B,0x8CA2,0x8CFC,0x90CA,0x9175,0x9271,0x783F,0x92FC,0x95A4,0x964D,
	0x9805,0x9999,0x9AD8,0x9D3B,0x525B,0x52AB,0x53F7,0x5408,0x58D5,0x62F7,0x6FE0,0x8C6A,0x8F5F,0x9EB9,0x514B,0x523B,
	0x544A,0x56FD,0x7A40,0x9177,0x9D60,0x9ED2,0x7344,0x6F09,0x8170,0x7511,0x5FFD,0x60DA,0x9AA8,0x72DB,0x8FBC,
};
static const WCHAR _eucj_to_ucs_BA00_data []={ //BAA1 BAFE
	       0x6B64,0x9803,0x4ECA,0x56F0,0x5764,0x58BE,0x5A5A,0x6068,0x61C7,0x660F,0x6606,0x6839,0x68B1,0x6DF7,0x75D5,
	0x7D3A,0x826E,0x9B42,0x4E9B,0x4F50,0x53C9,0x5506,0x5D6F,0x5DE6,0x5DEE,0x67FB,0x6C99,0x7473,0x7802,0x8A50,0x9396,
	0x88DF,0x5750,0x5EA7,0x632B,0x50B5,0x50AC,0x518D,0x6700,0x54C9,0x585E,0x59BB,0x5BB0,0x5F69,0x624D,0x63A1,0x683D,
	0x6B73,0x6E08,0x707D,0x91C7,0x7280,0x7815,0x7826,0x796D,0x658E,0x7D30,0x83DC,0x88C1,0x8F09,0x969B,0x5264,0x5728,
	0x6750,0x7F6A,0x8CA1,0x51B4,0x5742,0x962A,0x583A,0x698A,0x80B4,0x54B2,0x5D0E,0x57FC,0x7895,0x9DFA,0x4F5C,0x524A,
	0x548B,0x643E,0x6628,0x6714,0x67F5,0x7A84,0x7B56,0x7D22,0x932F,0x685C,0x9BAD,0x7B39,0x5319,0x518A,0x5237,
};
static const WCHAR _eucj_to_ucs_BB00_data []={ //BBA1 BBFE
	       0x5BDF,0x62F6,0x64AE,0x64E6,0x672D,0x6BBA,0x85A9,0x96D1,0x7690,0x9BD6,0x634C,0x9306,0x9BAB,0x76BF,0x6652,
	0x4E09,0x5098,0x53C2,0x5C71,0x60E8,0x6492,0x6563,0x685F,0x71E6,0x73CA,0x7523,0x7B97,0x7E82,0x8695,0x8B83,0x8CDB,
	0x9178,0x9910,0x65AC,0x66AB,0x6B8B,0x4ED5,0x4ED4,0x4F3A,0x4F7F,0x523A,0x53F8,0x53F2,0x55E3,0x56DB,0x58EB,0x59CB,
	0x59C9,0x59FF,0x5B50,0x5C4D,0x5E02,0x5E2B,0x5FD7,0x601D,0x6307,0x652F,0x5B5C,0x65AF,0x65BD,0x65E8,0x679D,0x6B62,
	0x6B7B,0x6C0F,0x7345,0x7949,0x79C1,0x7CF8,0x7D19,0x7D2B,0x80A2,0x8102,0x81F3,0x8996,0x8A5E,0x8A69,0x8A66,0x8A8C,
	0x8AEE,0x8CC7,0x8CDC,0x96CC,0x98FC,0x6B6F,0x4E8B,0x4F3C,0x4F8D,0x5150,0x5B57,0x5BFA,0x6148,0x6301,0x6642,
};
static const WCHAR _eucj_to_ucs_BC00_data []={ //BCA1 BCFE
	       0x6B21,0x6ECB,0x6CBB,0x723E,0x74BD,0x75D4,0x78C1,0x793A,0x800C,0x8033,0x81EA,0x8494,0x8F9E,0x6C50,0x9E7F,
	0x5F0F,0x8B58,0x9D2B,0x7AFA,0x8EF8,0x5B8D,0x96EB,0x4E03,0x53F1,0x57F7,0x5931,0x5AC9,0x5BA4,0x6089,0x6E7F,0x6F06,
	0x75BE,0x8CEA,0x5B9F,0x8500,0x7BE0,0x5072,0x67F4,0x829D,0x5C61,0x854A,0x7E1E,0x820E,0x5199,0x5C04,0x6368,0x8D66,
	0x659C,0x716E,0x793E,0x7D17,0x8005,0x8B1D,0x8ECA,0x906E,0x86C7,0x90AA,0x501F,0x52FA,0x5C3A,0x6753,0x707C,0x7235,
	0x914C,0x91C8,0x932B,0x82E5,0x5BC2,0x5F31,0x60F9,0x4E3B,0x53D6,0x5B88,0x624B,0x6731,0x6B8A,0x72E9,0x73E0,0x7A2E,
	0x816B,0x8DA3,0x9152,0x9996,0x5112,0x53D7,0x546A,0x5BFF,0x6388,0x6A39,0x7DAC,0x9700,0x56DA,0x53CE,0x5468,
};
static const WCHAR _eucj_to_ucs_BD00_data []={ //BDA1 BDFE
	       0x5B97,0x5C31,0x5DDE,0x4FEE,0x6101,0x62FE,0x6D32,0x79C0,0x79CB,0x7D42,0x7E4D,0x7FD2,0x81ED,0x821F,0x8490,
	0x8846,0x8972,0x8B90,0x8E74,0x8F2F,0x9031,0x914B,0x916C,0x96C6,0x919C,0x4EC0,0x4F4F,0x5145,0x5341,0x5F93,0x620E,
	0x67D4,0x6C41,0x6E0B,0x7363,0x7E26,0x91CD,0x9283,0x53D4,0x5919,0x5BBF,0x6DD1,0x795D,0x7E2E,0x7C9B,0x587E,0x719F,
	0x51FA,0x8853,0x8FF0,0x4FCA,0x5CFB,0x6625,0x77AC,0x7AE3,0x821C,0x99FF,0x51C6,0x5FAA,0x65EC,0x696F,0x6B89,0x6DF3,
	0x6E96,0x6F64,0x76FE,0x7D14,0x5DE1,0x9075,0x9187,0x9806,0x51E6,0x521D,0x6240,0x6691,0x66D9,0x6E1A,0x5EB6,0x7DD2,
	0x7F72,0x66F8,0x85AF,0x85F7,0x8AF8,0x52A9,0x53D9,0x5973,0x5E8F,0x5F90,0x6055,0x92E4,0x9664,0x50B7,0x511F,
};
static const WCHAR _eucj_to_ucs_BE00_data []={ //BEA1 BEFE
	       0x52DD,0x5320,0x5347,0x53EC,0x54E8,0x5546,0x5531,0x5617,0x5968,0x59BE,0x5A3C,0x5BB5,0x5C06,0x5C0F,0x5C11,
	0x5C1A,0x5E84,0x5E8A,0x5EE0,0x5F70,0x627F,0x6284,0x62DB,0x638C,0x6377,0x6607,0x660C,0x662D,0x6676,0x677E,0x68A2,
	0x6A1F,0x6A35,0x6CBC,0x6D88,0x6E09,0x6E58,0x713C,0x7126,0x7167,0x75C7,0x7701,0x785D,0x7901,0x7965,0x79F0,0x7AE0,
	0x7B11,0x7CA7,0x7D39,0x8096,0x83D6,0x848B,0x8549,0x885D,0x88F3,0x8A1F,0x8A3C,0x8A54,0x8A73,0x8C61,0x8CDE,0x91A4,
	0x9266,0x937E,0x9418,0x969C,0x9798,0x4E0A,0x4E08,0x4E1E,0x4E57,0x5197,0x5270,0x57CE,0x5834,0x58CC,0x5B22,0x5E38,
	0x60C5,0x64FE,0x6761,0x6756,0x6D44,0x72B6,0x7573,0x7A63,0x84B8,0x8B72,0x91B8,0x9320,0x5631,0x57F4,0x98FE,
};
static const WCHAR _eucj_to_ucs_BF00_data []={ //BFA1 BFFE
	       0x62ED,0x690D,0x6B96,0x71ED,0x7E54,0x8077,0x8272,0x89E6,0x98DF,0x8755,0x8FB1,0x5C3B,0x4F38,0x4FE1,0x4FB5,
	0x5507,0x5A20,0x5BDD,0x5BE9,0x5FC3,0x614E,0x632F,0x65B0,0x664B,0x68EE,0x699B,0x6D78,0x6DF1,0x7533,0x75B9,0x771F,
	0x795E,0x79E6,0x7D33,0x81E3,0x82AF,0x85AA,0x89AA,0x8A3A,0x8EAB,0x8F9B,0x9032,0x91DD,0x9707,0x4EBA,0x4EC1,0x5203,
	0x5875,0x58EC,0x5C0B,0x751A,0x5C3D,0x814E,0x8A0A,0x8FC5,0x9663,0x976D,0x7B25,0x8ACF,0x9808,0x9162,0x56F3,0x53A8,
	0x9017,0x5439,0x5782,0x5E25,0x63A8,0x6C34,0x708A,0x7761,0x7C8B,0x7FE0,0x8870,0x9042,0x9154,0x9310,0x9318,0x968F,
	0x745E,0x9AC4,0x5D07,0x5D69,0x6570,0x67A2,0x8DA8,0x96DB,0x636E,0x6749,0x6919,0x83C5,0x9817,0x96C0,0x88FE,
};
static const WCHAR _eucj_to_ucs_C000_data []={ //C0A1 C0FE
	       0x6F84,0x647A,0x5BF8,0x4E16,0x702C,0x755D,0x662F,0x51C4,0x5236,0x52E2,0x59D3,0x5F81,0x6027,0x6210,0x653F,
	0x6574,0x661F,0x6674,0x68F2,0x6816,0x6B63,0x6E05,0x7272,0x751F,0x76DB,0x7CBE,0x8056,0x58F0,0x88FD,0x897F,0x8AA0,
	0x8A93,0x8ACB,0x901D,0x9192,0x9752,0x9759,0x6589,0x7A0E,0x8106,0x96BB,0x5E2D,0x60DC,0x621A,0x65A5,0x6614,0x6790,
	0x77F3,0x7A4D,0x7C4D,0x7E3E,0x810A,0x8CAC,0x8D64,0x8DE1,0x8E5F,0x78A9,0x5207,0x62D9,0x63A5,0x6442,0x6298,0x8A2D,
	0x7A83,0x7BC0,0x8AAC,0x96EA,0x7D76,0x820C,0x8749,0x4ED9,0x5148,0x5343,0x5360,0x5BA3,0x5C02,0x5C16,0x5DDD,0x6226,
	0x6247,0x64B0,0x6813,0x6834,0x6CC9,0x6D45,0x6D17,0x67D3,0x6F5C,0x714E,0x717D,0x65CB,0x7A7F,0x7BAD,0x7DDA,
};
static const WCHAR _eucj_to_ucs_C100_data []={ //C1A1 C1FE
	       0x7E4A,0x7FA8,0x817A,0x821B,0x8239,0x85A6,0x8A6E,0x8CCE,0x8DF5,0x9078,0x9077,0x92AD,0x9291,0x9583,0x9BAE,
	0x524D,0x5584,0x6F38,0x7136,0x5168,0x7985,0x7E55,0x81B3,0x7CCE,0x564C,0x5851,0x5CA8,0x63AA,0x66FE,0x66FD,0x695A,
	0x72D9,0x758F,0x758E,0x790E,0x7956,0x79DF,0x7C97,0x7D20,0x7D44,0x8607,0x8A34,0x963B,0x9061,0x9F20,0x50E7,0x5275,
	0x53CC,0x53E2,0x5009,0x55AA,0x58EE,0x594F,0x723D,0x5B8B,0x5C64,0x531D,0x60E3,0x60F3,0x635C,0x6383,0x633F,0x63BB,
	0x64CD,0x65E9,0x66F9,0x5DE3,0x69CD,0x69FD,0x6F15,0x71E5,0x4E89,0x75E9,0x76F8,0x7A93,0x7CDF,0x7DCF,0x7D9C,0x8061,
	0x8349,0x8358,0x846C,0x84BC,0x85FB,0x88C5,0x8D70,0x9001,0x906D,0x9397,0x971C,0x9A12,0x50CF,0x5897,0x618E,
};
static const WCHAR _eucj_to_ucs_C200_data []={ //C2A1 C2FE
	       0x81D3,0x8535,0x8D08,0x9020,0x4FC3,0x5074,0x5247,0x5373,0x606F,0x6349,0x675F,0x6E2C,0x8DB3,0x901F,0x4FD7,
	0x5C5E,0x8CCA,0x65CF,0x7D9A,0x5352,0x8896,0x5176,0x63C3,0x5B58,0x5B6B,0x5C0A,0x640D,0x6751,0x905C,0x4ED6,0x591A,
	0x592A,0x6C70,0x8A51,0x553E,0x5815,0x59A5,0x60F0,0x6253,0x67C1,0x8235,0x6955,0x9640,0x99C4,0x9A28,0x4F53,0x5806,
	0x5BFE,0x8010,0x5CB1,0x5E2F,0x5F85,0x6020,0x614B,0x6234,0x66FF,0x6CF0,0x6EDE,0x80CE,0x817F,0x82D4,0x888B,0x8CB8,
	0x9000,0x902E,0x968A,0x9EDB,0x9BDB,0x4EE3,0x53F0,0x5927,0x7B2C,0x918D,0x984C,0x9DF9,0x6EDD,0x7027,0x5353,0x5544,
	0x5B85,0x6258,0x629E,0x62D3,0x6CA2,0x6FEF,0x7422,0x8A17,0x9438,0x6FC1,0x8AFE,0x8338,0x51E7,0x86F8,0x53EA,
};
static const WCHAR _eucj_to_ucs_C300_data []={ //C3A1 C3FE
	       0x53E9,0x4F46,0x9054,0x8FB0,0x596A,0x8131,0x5DFD,0x7AEA,0x8FBF,0x68DA,0x8C37,0x72F8,0x9C48,0x6A3D,0x8AB0,
	0x4E39,0x5358,0x5606,0x5766,0x62C5,0x63A2,0x65E6,0x6B4E,0x6DE1,0x6E5B,0x70AD,0x77ED,0x7AEF,0x7BAA,0x7DBB,0x803D,
	0x80C6,0x86CB,0x8A95,0x935B,0x56E3,0x58C7,0x5F3E,0x65AD,0x6696,0x6A80,0x6BB5,0x7537,0x8AC7,0x5024,0x77E5,0x5730,
	0x5F1B,0x6065,0x667A,0x6C60,0x75F4,0x7A1A,0x7F6E,0x81F4,0x8718,0x9045,0x99B3,0x7BC9,0x755C,0x7AF9,0x7B51,0x84C4,
	0x9010,0x79E9,0x7A92,0x8336,0x5AE1,0x7740,0x4E2D,0x4EF2,0x5B99,0x5FE0,0x62BD,0x663C,0x67F1,0x6CE8,0x866B,0x8877,
	0x8A3B,0x914E,0x92F3,0x99D0,0x6A17,0x7026,0x732A,0x82E7,0x8457,0x8CAF,0x4E01,0x5146,0x51CB,0x558B,0x5BF5,
};
static const WCHAR _eucj_to_ucs_C400_data []={ //C4A1 C4FE
	       0x5E16,0x5E33,0x5E81,0x5F14,0x5F35,0x5F6B,0x5FB4,0x61F2,0x6311,0x66A2,0x671D,0x6F6E,0x7252,0x753A,0x773A,
	0x8074,0x8139,0x8178,0x8776,0x8ABF,0x8ADC,0x8D85,0x8DF3,0x929A,0x9577,0x9802,0x9CE5,0x52C5,0x6357,0x76F4,0x6715,
	0x6C88,0x73CD,0x8CC3,0x93AE,0x9673,0x6D25,0x589C,0x690E,0x69CC,0x8FFD,0x939A,0x75DB,0x901A,0x585A,0x6802,0x63B4,
	0x69FB,0x4F43,0x6F2C,0x67D8,0x8FBB,0x8526,0x7DB4,0x9354,0x693F,0x6F70,0x576A,0x58F7,0x5B2C,0x7D2C,0x722A,0x540A,
	0x91E3,0x9DB4,0x4EAD,0x4F4E,0x505C,0x5075,0x5243,0x8C9E,0x5448,0x5824,0x5B9A,0x5E1D,0x5E95,0x5EAD,0x5EF7,0x5F1F,
	0x608C,0x62B5,0x633A,0x63D0,0x68AF,0x6C40,0x7887,0x798E,0x7A0B,0x7DE0,0x8247,0x8A02,0x8AE6,0x8E44,0x9013,
};
static const WCHAR _eucj_to_ucs_C500_data []={ //C5A1 C5FE
	       0x90B8,0x912D,0x91D8,0x9F0E,0x6CE5,0x6458,0x64E2,0x6575,0x6EF4,0x7684,0x7B1B,0x9069,0x93D1,0x6EBA,0x54F2,
	0x5FB9,0x64A4,0x8F4D,0x8FED,0x9244,0x5178,0x586B,0x5929,0x5C55,0x5E97,0x6DFB,0x7E8F,0x751C,0x8CBC,0x8EE2,0x985B,
	0x70B9,0x4F1D,0x6BBF,0x6FB1,0x7530,0x96FB,0x514E,0x5410,0x5835,0x5857,0x59AC,0x5C60,0x5F92,0x6597,0x675C,0x6E21,
	0x767B,0x83DF,0x8CED,0x9014,0x90FD,0x934D,0x7825,0x783A,0x52AA,0x5EA6,0x571F,0x5974,0x6012,0x5012,0x515A,0x51AC,
	0x51CD,0x5200,0x5510,0x5854,0x5858,0x5957,0x5B95,0x5CF6,0x5D8B,0x60BC,0x6295,0x642D,0x6771,0x6843,0x68BC,0x68DF,
	0x76D7,0x6DD8,0x6E6F,0x6D9B,0x706F,0x71C8,0x5F53,0x75D8,0x7977,0x7B49,0x7B54,0x7B52,0x7CD6,0x7D71,0x5230,
};
static const WCHAR _eucj_to_ucs_C600_data []={ //C6A1 C6FE
	       0x8463,0x8569,0x85E4,0x8A0E,0x8B04,0x8C46,0x8E0F,0x9003,0x900F,0x9419,0x9676,0x982D,0x9A30,0x95D8,0x50CD,
	0x52D5,0x540C,0x5802,0x5C0E,0x61A7,0x649E,0x6D1E,0x77B3,0x7AE5,0x80F4,0x8404,0x9053,0x9285,0x5CE0,0x9D07,0x533F,
	0x5F97,0x5FB3,0x6D9C,0x7279,0x7763,0x79BF,0x7BE4,0x6BD2,0x72EC,0x8AAD,0x6803,0x6A61,0x51F8,0x7A81,0x6934,0x5C4A,
	0x9CF6,0x82EB,0x5BC5,0x9149,0x701E,0x5678,0x5C6F,0x60C7,0x6566,0x6C8C,0x8C5A,0x9041,0x9813,0x5451,0x66C7,0x920D,
	0x5948,0x90A3,0x5185,0x4E4D,0x51EA,0x8599,0x8B0E,0x7058,0x637A,0x934B,0x6962,0x99B4,0x7E04,0x7577,0x5357,0x6960,
	0x8EDF,0x96E3,0x6C5D,0x4E8C,0x5C3C,0x5F10,0x8FE9,0x5302,0x8CD1,0x8089,0x8679,0x5EFF,0x65E5,0x4E73,0x5165,
};
static const WCHAR _eucj_to_ucs_C700_data []={ //C7A1 C7FE
	       0x5982,0x5C3F,0x97EE,0x4EFB,0x598A,0x5FCD,0x8A8D,0x6FE1,0x79B0,0x7962,0x5BE7,0x8471,0x732B,0x71B1,0x5E74,
	0x5FF5,0x637B,0x649A,0x71C3,0x7C98,0x4E43,0x5EFC,0x4E4B,0x57DC,0x56A2,0x60A9,0x6FC3,0x7D0D,0x80FD,0x8133,0x81BF,
	0x8FB2,0x8997,0x86A4,0x5DF4,0x628A,0x64AD,0x8987,0x6777,0x6CE2,0x6D3E,0x7436,0x7834,0x5A46,0x7F75,0x82AD,0x99AC,
	0x4FF3,0x5EC3,0x62DD,0x6392,0x6557,0x676F,0x76C3,0x724C,0x80CC,0x80BA,0x8F29,0x914D,0x500D,0x57F9,0x5A92,0x6885,
	0x6973,0x7164,0x72FD,0x8CB7,0x58F2,0x8CE0,0x966A,0x9019,0x877F,0x79E4,0x77E7,0x8429,0x4F2F,0x5265,0x535A,0x62CD,
	0x67CF,0x6CCA,0x767D,0x7B94,0x7C95,0x8236,0x8584,0x8FEB,0x66DD,0x6F20,0x7206,0x7E1B,0x83AB,0x99C1,0x9EA6,
};
static const WCHAR _eucj_to_ucs_C800_data []={ //C8A1 C8FE
	       0x51FD,0x7BB1,0x7872,0x7BB8,0x8087,0x7B48,0x6AE8,0x5E61,0x808C,0x7551,0x7560,0x516B,0x9262,0x6E8C,0x767A,
	0x9197,0x9AEA,0x4F10,0x7F70,0x629C,0x7B4F,0x95A5,0x9CE9,0x567A,0x5859,0x86E4,0x96BC,0x4F34,0x5224,0x534A,0x53CD,
	0x53DB,0x5E06,0x642C,0x6591,0x677F,0x6C3E,0x6C4E,0x7248,0x72AF,0x73ED,0x7554,0x7E41,0x822C,0x85E9,0x8CA9,0x7BC4,
	0x91C6,0x7169,0x9812,0x98EF,0x633D,0x6669,0x756A,0x76E4,0x78D0,0x8543,0x86EE,0x532A,0x5351,0x5426,0x5983,0x5E87,
	0x5F7C,0x60B2,0x6249,0x6279,0x62AB,0x6590,0x6BD4,0x6CCC,0x75B2,0x76AE,0x7891,0x79D8,0x7DCB,0x7F77,0x80A5,0x88AB,
	0x8AB9,0x8CBB,0x907F,0x975E,0x98DB,0x6A0B,0x7C38,0x5099,0x5C3E,0x5FAE,0x6787,0x6BD8,0x7435,0x7709,0x7F8E,
};
static const WCHAR _eucj_to_ucs_C900_data []={ //C9A1 C9FE
	       0x9F3B,0x67CA,0x7A17,0x5339,0x758B,0x9AED,0x5F66,0x819D,0x83F1,0x8098,0x5F3C,0x5FC5,0x7562,0x7B46,0x903C,
	0x6867,0x59EB,0x5A9B,0x7D10,0x767E,0x8B2C,0x4FF5,0x5F6A,0x6A19,0x6C37,0x6F02,0x74E2,0x7968,0x8868,0x8A55,0x8C79,
	0x5EDF,0x63CF,0x75C5,0x79D2,0x82D7,0x9328,0x92F2,0x849C,0x86ED,0x9C2D,0x54C1,0x5F6C,0x658C,0x6D5C,0x7015,0x8CA7,
	0x8CD3,0x983B,0x654F,0x74F6,0x4E0D,0x4ED8,0x57E0,0x592B,0x5A66,0x5BCC,0x51A8,0x5E03,0x5E9C,0x6016,0x6276,0x6577,
	0x65A7,0x666E,0x6D6E,0x7236,0x7B26,0x8150,0x819A,0x8299,0x8B5C,0x8CA0,0x8CE6,0x8D74,0x961C,0x9644,0x4FAE,0x64AB,
	0x6B66,0x821E,0x8461,0x856A,0x90E8,0x5C01,0x6953,0x98A8,0x847A,0x8557,0x4F0F,0x526F,0x5FA9,0x5E45,0x670D,
};
static const WCHAR _eucj_to_ucs_CA00_data []={ //CAA1 CAFE
	       0x798F,0x8179,0x8907,0x8986,0x6DF5,0x5F17,0x6255,0x6CB8,0x4ECF,0x7269,0x9B92,0x5206,0x543B,0x5674,0x58B3,
	0x61A4,0x626E,0x711A,0x596E,0x7C89,0x7CDE,0x7D1B,0x96F0,0x6587,0x805E,0x4E19,0x4F75,0x5175,0x5840,0x5E63,0x5E73,
	0x5F0A,0x67C4,0x4E26,0x853D,0x9589,0x965B,0x7C73,0x9801,0x50FB,0x58C1,0x7656,0x78A7,0x5225,0x77A5,0x8511,0x7B86,
	0x504F,0x5909,0x7247,0x7BC7,0x7DE8,0x8FBA,0x8FD4,0x904D,0x4FBF,0x52C9,0x5A29,0x5F01,0x97AD,0x4FDD,0x8217,0x92EA,
	0x5703,0x6355,0x6B69,0x752B,0x88DC,0x8F14,0x7A42,0x52DF,0x5893,0x6155,0x620A,0x66AE,0x6BCD,0x7C3F,0x83E9,0x5023,
	0x4FF8,0x5305,0x5446,0x5831,0x5949,0x5B9D,0x5CF0,0x5CEF,0x5D29,0x5E96,0x62B1,0x6367,0x653E,0x65B9,0x670B,
};
static const WCHAR _eucj_to_ucs_CB00_data []={ //CBA1 CBFE
	       0x6CD5,0x6CE1,0x70F9,0x7832,0x7E2B,0x80DE,0x82B3,0x840C,0x84EC,0x8702,0x8912,0x8A2A,0x8C4A,0x90A6,0x92D2,
	0x98FD,0x9CF3,0x9D6C,0x4E4F,0x4EA1,0x508D,0x5256,0x574A,0x59A8,0x5E3D,0x5FD8,0x5FD9,0x623F,0x66B4,0x671B,0x67D0,
	0x68D2,0x5192,0x7D21,0x80AA,0x81A8,0x8B00,0x8C8C,0x8CBF,0x927E,0x9632,0x5420,0x982C,0x5317,0x50D5,0x535C,0x58A8,
	0x64B2,0x6734,0x7267,0x7766,0x7A46,0x91E6,0x52C3,0x6CA1,0x6B86,0x5800,0x5E4C,0x5954,0x672C,0x7FFB,0x51E1,0x76C6,
	0x6469,0x78E8,0x9B54,0x9EBB,0x57CB,0x59B9,0x6627,0x679A,0x6BCE,0x54E9,0x69D9,0x5E55,0x819C,0x6795,0x9BAA,0x67FE,
	0x9C52,0x685D,0x4EA6,0x4FE3,0x53C8,0x62B9,0x672B,0x6CAB,0x8FC4,0x4FAD,0x7E6D,0x9EBF,0x4E07,0x6162,0x6E80,
};
static const WCHAR _eucj_to_ucs_CC00_data []={ //CCA1 CCFE
	       0x6F2B,0x8513,0x5473,0x672A,0x9B45,0x5DF3,0x7B95,0x5CAC,0x5BC6,0x871C,0x6E4A,0x84D1,0x7A14,0x8108,0x5999,
	0x7C8D,0x6C11,0x7720,0x52D9,0x5922,0x7121,0x725F,0x77DB,0x9727,0x9D61,0x690B,0x5A7F,0x5A18,0x51A5,0x540D,0x547D,
	0x660E,0x76DF,0x8FF7,0x9298,0x9CF4,0x59EA,0x725D,0x6EC5,0x514D,0x68C9,0x7DBF,0x7DEC,0x9762,0x9EBA,0x6478,0x6A21,
	0x8302,0x5984,0x5B5F,0x6BDB,0x731B,0x76F2,0x7DB2,0x8017,0x8499,0x5132,0x6728,0x9ED9,0x76EE,0x6762,0x52FF,0x9905,
	0x5C24,0x623B,0x7C7E,0x8CB0,0x554F,0x60B6,0x7D0B,0x9580,0x5301,0x4E5F,0x51B6,0x591C,0x723A,0x8036,0x91CE,0x5F25,
	0x77E2,0x5384,0x5F79,0x7D04,0x85AC,0x8A33,0x8E8D,0x9756,0x67F3,0x85AE,0x9453,0x6109,0x6108,0x6CB9,0x7652,
};
static const WCHAR _eucj_to_ucs_CD00_data []={ //CDA1 CDFE
	       0x8AED,0x8F38,0x552F,0x4F51,0x512A,0x52C7,0x53CB,0x5BA5,0x5E7D,0x60A0,0x6182,0x63D6,0x6709,0x67DA,0x6E67,
	0x6D8C,0x7336,0x7337,0x7531,0x7950,0x88D5,0x8A98,0x904A,0x9091,0x90F5,0x96C4,0x878D,0x5915,0x4E88,0x4F59,0x4E0E,
	0x8A89,0x8F3F,0x9810,0x50AD,0x5E7C,0x5996,0x5BB9,0x5EB8,0x63DA,0x63FA,0x64C1,0x66DC,0x694A,0x69D8,0x6D0B,0x6EB6,
	0x7194,0x7528,0x7AAF,0x7F8A,0x8000,0x8449,0x84C9,0x8981,0x8B21,0x8E0A,0x9065,0x967D,0x990A,0x617E,0x6291,0x6B32,
	0x6C83,0x6D74,0x7FCC,0x7FFC,0x6DC0,0x7F85,0x87BA,0x88F8,0x6765,0x83B1,0x983C,0x96F7,0x6D1B,0x7D61,0x843D,0x916A,
	0x4E71,0x5375,0x5D50,0x6B04,0x6FEB,0x85CD,0x862D,0x89A7,0x5229,0x540F,0x5C65,0x674E,0x68A8,0x7406,0x7483,
};
static const WCHAR _eucj_to_ucs_CE00_data []={ //CEA1 CEFE
	       0x75E2,0x88CF,0x88E1,0x91CC,0x96E2,0x9678,0x5F8B,0x7387,0x7ACB,0x844E,0x63A0,0x7565,0x5289,0x6D41,0x6E9C,
	0x7409,0x7559,0x786B,0x7C92,0x9686,0x7ADC,0x9F8D,0x4FB6,0x616E,0x65C5,0x865C,0x4E86,0x4EAE,0x50DA,0x4E21,0x51CC,
	0x5BEE,0x6599,0x6881,0x6DBC,0x731F,0x7642,0x77AD,0x7A1C,0x7CE7,0x826F,0x8AD2,0x907C,0x91CF,0x9675,0x9818,0x529B,
	0x7DD1,0x502B,0x5398,0x6797,0x6DCB,0x71D0,0x7433,0x81E8,0x8F2A,0x96A3,0x9C57,0x9E9F,0x7460,0x5841,0x6D99,0x7D2F,
	0x985E,0x4EE4,0x4F36,0x4F8B,0x51B7,0x52B1,0x5DBA,0x601C,0x73B2,0x793C,0x82D3,0x9234,0x96B7,0x96F6,0x970A,0x9E97,
	0x9F62,0x66A6,0x6B74,0x5217,0x52A3,0x70C8,0x88C2,0x5EC9,0x604B,0x6190,0x6F23,0x7149,0x7C3E,0x7DF4,0x806F,
};
static const WCHAR _eucj_to_ucs_CF00_data []={ //CFA1 CFD3
	       0x84EE,0x9023,0x932C,0x5442,0x9B6F,0x6AD3,0x7089,0x8CC2,0x8DEF,0x9732,0x52B4,0x5A41,0x5ECA,0x5F04,0x6717,
	0x697C,0x6994,0x6D6A,0x6F0F,0x7262,0x72FC,0x7BED,0x8001,0x807E,0x874B,0x90CE,0x516D,0x9E93,0x7984,0x808B,0x9332,
	0x8AD6,0x502D,0x548C,0x8A71,0x6B6A,0x8CC4,0x8107,0x60D1,0x67A0,0x9DF2,0x4E99,0x4E98,0x9C10,0x8A6B,0x85C1,0x8568,
	0x6900,0x6E7E,0x7897,0x8155,
};
static const WCHAR _eucj_to_ucs_D000_data []={ //D0A1 D0FE
	       0x5F0C,0x4E10,0x4E15,0x4E2A,0x4E31,0x4E36,0x4E3C,0x4E3F,0x4E42,0x4E56,0x4E58,0x4E82,0x4E85,0x8C6B,0x4E8A,
	0x8212,0x5F0D,0x4E8E,0x4E9E,0x4E9F,0x4EA0,0x4EA2,0x4EB0,0x4EB3,0x4EB6,0x4ECE,0x4ECD,0x4EC4,0x4EC6,0x4EC2,0x4ED7,
	0x4EDE,0x4EED,0x4EDF,0x4EF7,0x4F09,0x4F5A,0x4F30,0x4F5B,0x4F5D,0x4F57,0x4F47,0x4F76,0x4F88,0x4F8F,0x4F98,0x4F7B,
	0x4F69,0x4F70,0x4F91,0x4F6F,0x4F86,0x4F96,0x5118,0x4FD4,0x4FDF,0x4FCE,0x4FD8,0x4FDB,0x4FD1,0x4FDA,0x4FD0,0x4FE4,
	0x4FE5,0x501A,0x5028,0x5014,0x502A,0x5025,0x5005,0x4F1C,0x4FF6,0x5021,0x5029,0x502C,0x4FFE,0x4FEF,0x5011,0x5006,
	0x5043,0x5047,0x6703,0x5055,0x5050,0x5048,0x505A,0x5056,0x506C,0x5078,0x5080,0x509A,0x5085,0x50B4,0x50B2,
};
static const WCHAR _eucj_to_ucs_D100_data []={ //D1A1 D1FE
	       0x50C9,0x50CA,0x50B3,0x50C2,0x50D6,0x50DE,0x50E5,0x50ED,0x50E3,0x50EE,0x50F9,0x50F5,0x5109,0x5101,0x5102,
	0x5116,0x5115,0x5114,0x511A,0x5121,0x513A,0x5137,0x513C,0x513B,0x513F,0x5140,0x5152,0x514C,0x5154,0x5162,0x7AF8,
	0x5169,0x516A,0x516E,0x5180,0x5182,0x56D8,0x518C,0x5189,0x518F,0x5191,0x5193,0x5195,0x5196,0x51A4,0x51A6,0x51A2,
	0x51A9,0x51AA,0x51AB,0x51B3,0x51B1,0x51B2,0x51B0,0x51B5,0x51BD,0x51C5,0x51C9,0x51DB,0x51E0,0x8655,0x51E9,0x51ED,
	0x51F0,0x51F5,0x51FE,0x5204,0x520B,0x5214,0x520E,0x5227,0x522A,0x522E,0x5233,0x5239,0x524F,0x5244,0x524B,0x524C,
	0x525E,0x5254,0x526A,0x5274,0x5269,0x5273,0x527F,0x527D,0x528D,0x5294,0x5292,0x5271,0x5288,0x5291,0x8FA8,
};
static const WCHAR _eucj_to_ucs_D200_data []={ //D2A1 D2FE
	       0x8FA7,0x52AC,0x52AD,0x52BC,0x52B5,0x52C1,0x52CD,0x52D7,0x52DE,0x52E3,0x52E6,0x98ED,0x52E0,0x52F3,0x52F5,
	0x52F8,0x52F9,0x5306,0x5308,0x7538,0x530D,0x5310,0x530F,0x5315,0x531A,0x5323,0x532F,0x5331,0x5333,0x5338,0x5340,
	0x5346,0x5345,0x4E17,0x5349,0x534D,0x51D6,0x535E,0x5369,0x536E,0x5918,0x537B,0x5377,0x5382,0x5396,0x53A0,0x53A6,
	0x53A5,0x53AE,0x53B0,0x53B6,0x53C3,0x7C12,0x96D9,0x53DF,0x66FC,0x71EE,0x53EE,0x53E8,0x53ED,0x53FA,0x5401,0x543D,
	0x5440,0x542C,0x542D,0x543C,0x542E,0x5436,0x5429,0x541D,0x544E,0x548F,0x5475,0x548E,0x545F,0x5471,0x5477,0x5470,
	0x5492,0x547B,0x5480,0x5476,0x5484,0x5490,0x5486,0x54C7,0x54A2,0x54B8,0x54A5,0x54AC,0x54C4,0x54C8,0x54A8,
};
static const WCHAR _eucj_to_ucs_D300_data []={ //D3A1 D3FE
	       0x54AB,0x54C2,0x54A4,0x54BE,0x54BC,0x54D8,0x54E5,0x54E6,0x550F,0x5514,0x54FD,0x54EE,0x54ED,0x54FA,0x54E2,
	0x5539,0x5540,0x5563,0x554C,0x552E,0x555C,0x5545,0x5556,0x5557,0x5538,0x5533,0x555D,0x5599,0x5580,0x54AF,0x558A,
	0x559F,0x557B,0x557E,0x5598,0x559E,0x55AE,0x557C,0x5583,0x55A9,0x5587,0x55A8,0x55DA,0x55C5,0x55DF,0x55C4,0x55DC,
	0x55E4,0x55D4,0x5614,0x55F7,0x5616,0x55FE,0x55FD,0x561B,0x55F9,0x564E,0x5650,0x71DF,0x5634,0x5636,0x5632,0x5638,
	0x566B,0x5664,0x562F,0x566C,0x566A,0x5686,0x5680,0x568A,0x56A0,0x5694,0x568F,0x56A5,0x56AE,0x56B6,0x56B4,0x56C2,
	0x56BC,0x56C1,0x56C3,0x56C0,0x56C8,0x56CE,0x56D1,0x56D3,0x56D7,0x56EE,0x56F9,0x5700,0x56FF,0x5704,0x5709,
};
static const WCHAR _eucj_to_ucs_D400_data []={ //D4A1 D4FE
	       0x5708,0x570B,0x570D,0x5713,0x5718,0x5716,0x55C7,0x571C,0x5726,0x5737,0x5738,0x574E,0x573B,0x5740,0x574F,
	0x5769,0x57C0,0x5788,0x5761,0x577F,0x5789,0x5793,0x57A0,0x57B3,0x57A4,0x57AA,0x57B0,0x57C3,0x57C6,0x57D4,0x57D2,
	0x57D3,0x580A,0x57D6,0x57E3,0x580B,0x5819,0x581D,0x5872,0x5821,0x5862,0x584B,0x5870,0x6BC0,0x5852,0x583D,0x5879,
	0x5885,0x58B9,0x589F,0x58AB,0x58BA,0x58DE,0x58BB,0x58B8,0x58AE,0x58C5,0x58D3,0x58D1,0x58D7,0x58D9,0x58D8,0x58E5,
	0x58DC,0x58E4,0x58DF,0x58EF,0x58FA,0x58F9,0x58FB,0x58FC,0x58FD,0x5902,0x590A,0x5910,0x591B,0x68A6,0x5925,0x592C,
	0x592D,0x5932,0x5938,0x593E,0x7AD2,0x5955,0x5950,0x594E,0x595A,0x5958,0x5962,0x5960,0x5967,0x596C,0x5969,
};
static const WCHAR _eucj_to_ucs_D500_data []={ //D5A1 D5FE
	       0x5978,0x5981,0x599D,0x4F5E,0x4FAB,0x59A3,0x59B2,0x59C6,0x59E8,0x59DC,0x598D,0x59D9,0x59DA,0x5A25,0x5A1F,
	0x5A11,0x5A1C,0x5A09,0x5A1A,0x5A40,0x5A6C,0x5A49,0x5A35,0x5A36,0x5A62,0x5A6A,0x5A9A,0x5ABC,0x5ABE,0x5ACB,0x5AC2,
	0x5ABD,0x5AE3,0x5AD7,0x5AE6,0x5AE9,0x5AD6,0x5AFA,0x5AFB,0x5B0C,0x5B0B,0x5B16,0x5B32,0x5AD0,0x5B2A,0x5B36,0x5B3E,
	0x5B43,0x5B45,0x5B40,0x5B51,0x5B55,0x5B5A,0x5B5B,0x5B65,0x5B69,0x5B70,0x5B73,0x5B75,0x5B78,0x6588,0x5B7A,0x5B80,
	0x5B83,0x5BA6,0x5BB8,0x5BC3,0x5BC7,0x5BC9,0x5BD4,0x5BD0,0x5BE4,0x5BE6,0x5BE2,0x5BDE,0x5BE5,0x5BEB,0x5BF0,0x5BF6,
	0x5BF3,0x5C05,0x5C07,0x5C08,0x5C0D,0x5C13,0x5C20,0x5C22,0x5C28,0x5C38,0x5C39,0x5C41,0x5C46,0x5C4E,0x5C53,
};
static const WCHAR _eucj_to_ucs_D600_data []={ //D6A1 D6FE
	       0x5C50,0x5C4F,0x5B71,0x5C6C,0x5C6E,0x4E62,0x5C76,0x5C79,0x5C8C,0x5C91,0x5C94,0x599B,0x5CAB,0x5CBB,0x5CB6,
	0x5CBC,0x5CB7,0x5CC5,0x5CBE,0x5CC7,0x5CD9,0x5CE9,0x5CFD,0x5CFA,0x5CED,0x5D8C,0x5CEA,0x5D0B,0x5D15,0x5D17,0x5D5C,
	0x5D1F,0x5D1B,0x5D11,0x5D14,0x5D22,0x5D1A,0x5D19,0x5D18,0x5D4C,0x5D52,0x5D4E,0x5D4B,0x5D6C,0x5D73,0x5D76,0x5D87,
	0x5D84,0x5D82,0x5DA2,0x5D9D,0x5DAC,0x5DAE,0x5DBD,0x5D90,0x5DB7,0x5DBC,0x5DC9,0x5DCD,0x5DD3,0x5DD2,0x5DD6,0x5DDB,
	0x5DEB,0x5DF2,0x5DF5,0x5E0B,0x5E1A,0x5E19,0x5E11,0x5E1B,0x5E36,0x5E37,0x5E44,0x5E43,0x5E40,0x5E4E,0x5E57,0x5E54,
	0x5E5F,0x5E62,0x5E64,0x5E47,0x5E75,0x5E76,0x5E7A,0x9EBC,0x5E7F,0x5EA0,0x5EC1,0x5EC2,0x5EC8,0x5ED0,0x5ECF,
};
static const WCHAR _eucj_to_ucs_D700_data []={ //D7A1 D7FE
	       0x5ED6,0x5EE3,0x5EDD,0x5EDA,0x5EDB,0x5EE2,0x5EE1,0x5EE8,0x5EE9,0x5EEC,0x5EF1,0x5EF3,0x5EF0,0x5EF4,0x5EF8,
	0x5EFE,0x5F03,0x5F09,0x5F5D,0x5F5C,0x5F0B,0x5F11,0x5F16,0x5F29,0x5F2D,0x5F38,0x5F41,0x5F48,0x5F4C,0x5F4E,0x5F2F,
	0x5F51,0x5F56,0x5F57,0x5F59,0x5F61,0x5F6D,0x5F73,0x5F77,0x5F83,0x5F82,0x5F7F,0x5F8A,0x5F88,0x5F91,0x5F87,0x5F9E,
	0x5F99,0x5F98,0x5FA0,0x5FA8,0x5FAD,0x5FBC,0x5FD6,0x5FFB,0x5FE4,0x5FF8,0x5FF1,0x5FDD,0x60B3,0x5FFF,0x6021,0x6060,
	0x6019,0x6010,0x6029,0x600E,0x6031,0x601B,0x6015,0x602B,0x6026,0x600F,0x603A,0x605A,0x6041,0x606A,0x6077,0x605F,
	0x604A,0x6046,0x604D,0x6063,0x6043,0x6064,0x6042,0x606C,0x606B,0x6059,0x6081,0x608D,0x60E7,0x6083,0x609A,
};
static const WCHAR _eucj_to_ucs_D800_data []={ //D8A1 D8FE
	       0x6084,0x609B,0x6096,0x6097,0x6092,0x60A7,0x608B,0x60E1,0x60B8,0x60E0,0x60D3,0x60B4,0x5FF0,0x60BD,0x60C6,
	0x60B5,0x60D8,0x614D,0x6115,0x6106,0x60F6,0x60F7,0x6100,0x60F4,0x60FA,0x6103,0x6121,0x60FB,0x60F1,0x610D,0x610E,
	0x6147,0x613E,0x6128,0x6127,0x614A,0x613F,0x613C,0x612C,0x6134,0x613D,0x6142,0x6144,0x6173,0x6177,0x6158,0x6159,
	0x615A,0x616B,0x6174,0x616F,0x6165,0x6171,0x615F,0x615D,0x6153,0x6175,0x6199,0x6196,0x6187,0x61AC,0x6194,0x619A,
	0x618A,0x6191,0x61AB,0x61AE,0x61CC,0x61CA,0x61C9,0x61F7,0x61C8,0x61C3,0x61C6,0x61BA,0x61CB,0x7F79,0x61CD,0x61E6,
	0x61E3,0x61F6,0x61FA,0x61F4,0x61FF,0x61FD,0x61FC,0x61FE,0x6200,0x6208,0x6209,0x620D,0x620C,0x6214,0x621B,
};
static const WCHAR _eucj_to_ucs_D900_data []={ //D9A1 D9FE
	       0x621E,0x6221,0x622A,0x622E,0x6230,0x6232,0x6233,0x6241,0x624E,0x625E,0x6263,0x625B,0x6260,0x6268,0x627C,
	0x6282,0x6289,0x627E,0x6292,0x6293,0x6296,0x62D4,0x6283,0x6294,0x62D7,0x62D1,0x62BB,0x62CF,0x62FF,0x62C6,0x64D4,
	0x62C8,0x62DC,0x62CC,0x62CA,0x62C2,0x62C7,0x629B,0x62C9,0x630C,0x62EE,0x62F1,0x6327,0x6302,0x6308,0x62EF,0x62F5,
	0x6350,0x633E,0x634D,0x641C,0x634F,0x6396,0x638E,0x6380,0x63AB,0x6376,0x63A3,0x638F,0x6389,0x639F,0x63B5,0x636B,
	0x6369,0x63BE,0x63E9,0x63C0,0x63C6,0x63E3,0x63C9,0x63D2,0x63F6,0x63C4,0x6416,0x6434,0x6406,0x6413,0x6426,0x6436,
	0x651D,0x6417,0x6428,0x640F,0x6467,0x646F,0x6476,0x644E,0x652A,0x6495,0x6493,0x64A5,0x64A9,0x6488,0x64BC,
};
static const WCHAR _eucj_to_ucs_DA00_data []={ //DAA1 DAFE
	       0x64DA,0x64D2,0x64C5,0x64C7,0x64BB,0x64D8,0x64C2,0x64F1,0x64E7,0x8209,0x64E0,0x64E1,0x62AC,0x64E3,0x64EF,
	0x652C,0x64F6,0x64F4,0x64F2,0x64FA,0x6500,0x64FD,0x6518,0x651C,0x6505,0x6524,0x6523,0x652B,0x6534,0x6535,0x6537,
	0x6536,0x6538,0x754B,0x6548,0x6556,0x6555,0x654D,0x6558,0x655E,0x655D,0x6572,0x6578,0x6582,0x6583,0x8B8A,0x659B,
	0x659F,0x65AB,0x65B7,0x65C3,0x65C6,0x65C1,0x65C4,0x65CC,0x65D2,0x65DB,0x65D9,0x65E0,0x65E1,0x65F1,0x6772,0x660A,
	0x6603,0x65FB,0x6773,0x6635,0x6636,0x6634,0x661C,0x664F,0x6644,0x6649,0x6641,0x665E,0x665D,0x6664,0x6667,0x6668,
	0x665F,0x6662,0x6670,0x6683,0x6688,0x668E,0x6689,0x6684,0x6698,0x669D,0x66C1,0x66B9,0x66C9,0x66BE,0x66BC,
};
static const WCHAR _eucj_to_ucs_DB00_data []={ //DBA1 DBFE
	       0x66C4,0x66B8,0x66D6,0x66DA,0x66E0,0x663F,0x66E6,0x66E9,0x66F0,0x66F5,0x66F7,0x670F,0x6716,0x671E,0x6726,
	0x6727,0x9738,0x672E,0x673F,0x6736,0x6741,0x6738,0x6737,0x6746,0x675E,0x6760,0x6759,0x6763,0x6764,0x6789,0x6770,
	0x67A9,0x677C,0x676A,0x678C,0x678B,0x67A6,0x67A1,0x6785,0x67B7,0x67EF,0x67B4,0x67EC,0x67B3,0x67E9,0x67B8,0x67E4,
	0x67DE,0x67DD,0x67E2,0x67EE,0x67B9,0x67CE,0x67C6,0x67E7,0x6A9C,0x681E,0x6846,0x6829,0x6840,0x684D,0x6832,0x684E,
	0x68B3,0x682B,0x6859,0x6863,0x6877,0x687F,0x689F,0x688F,0x68AD,0x6894,0x689D,0x689B,0x6883,0x6AAE,0x68B9,0x6874,
	0x68B5,0x68A0,0x68BA,0x690F,0x688D,0x687E,0x6901,0x68CA,0x6908,0x68D8,0x6922,0x6926,0x68E1,0x690C,0x68CD,
};
static const WCHAR _eucj_to_ucs_DC00_data []={ //DCA1 DCFE
	       0x68D4,0x68E7,0x68D5,0x6936,0x6912,0x6904,0x68D7,0x68E3,0x6925,0x68F9,0x68E0,0x68EF,0x6928,0x692A,0x691A,
	0x6923,0x6921,0x68C6,0x6979,0x6977,0x695C,0x6978,0x696B,0x6954,0x697E,0x696E,0x6939,0x6974,0x693D,0x6959,0x6930,
	0x6961,0x695E,0x695D,0x6981,0x696A,0x69B2,0x69AE,0x69D0,0x69BF,0x69C1,0x69D3,0x69BE,0x69CE,0x5BE8,0x69CA,0x69DD,
	0x69BB,0x69C3,0x69A7,0x6A2E,0x6991,0x69A0,0x699C,0x6995,0x69B4,0x69DE,0x69E8,0x6A02,0x6A1B,0x69FF,0x6B0A,0x69F9,
	0x69F2,0x69E7,0x6A05,0x69B1,0x6A1E,0x69ED,0x6A14,0x69EB,0x6A0A,0x6A12,0x6AC1,0x6A23,0x6A13,0x6A44,0x6A0C,0x6A72,
	0x6A36,0x6A78,0x6A47,0x6A62,0x6A59,0x6A66,0x6A48,0x6A38,0x6A22,0x6A90,0x6A8D,0x6AA0,0x6A84,0x6AA2,0x6AA3,
};
static const WCHAR _eucj_to_ucs_DD00_data []={ //DDA1 DDFE
	       0x6A97,0x8617,0x6ABB,0x6AC3,0x6AC2,0x6AB8,0x6AB3,0x6AAC,0x6ADE,0x6AD1,0x6ADF,0x6AAA,0x6ADA,0x6AEA,0x6AFB,
	0x6B05,0x8616,0x6AFA,0x6B12,0x6B16,0x9B31,0x6B1F,0x6B38,0x6B37,0x76DC,0x6B39,0x98EE,0x6B47,0x6B43,0x6B49,0x6B50,
	0x6B59,0x6B54,0x6B5B,0x6B5F,0x6B61,0x6B78,0x6B79,0x6B7F,0x6B80,0x6B84,0x6B83,0x6B8D,0x6B98,0x6B95,0x6B9E,0x6BA4,
	0x6BAA,0x6BAB,0x6BAF,0x6BB2,0x6BB1,0x6BB3,0x6BB7,0x6BBC,0x6BC6,0x6BCB,0x6BD3,0x6BDF,0x6BEC,0x6BEB,0x6BF3,0x6BEF,
	0x9EBE,0x6C08,0x6C13,0x6C14,0x6C1B,0x6C24,0x6C23,0x6C5E,0x6C55,0x6C62,0x6C6A,0x6C82,0x6C8D,0x6C9A,0x6C81,0x6C9B,
	0x6C7E,0x6C68,0x6C73,0x6C92,0x6C90,0x6CC4,0x6CF1,0x6CD3,0x6CBD,0x6CD7,0x6CC5,0x6CDD,0x6CAE,0x6CB1,0x6CBE,
};
static const WCHAR _eucj_to_ucs_DE00_data []={ //DEA1 DEFE
	       0x6CBA,0x6CDB,0x6CEF,0x6CD9,0x6CEA,0x6D1F,0x884D,0x6D36,0x6D2B,0x6D3D,0x6D38,0x6D19,0x6D35,0x6D33,0x6D12,
	0x6D0C,0x6D63,0x6D93,0x6D64,0x6D5A,0x6D79,0x6D59,0x6D8E,0x6D95,0x6FE4,0x6D85,0x6DF9,0x6E15,0x6E0A,0x6DB5,0x6DC7,
	0x6DE6,0x6DB8,0x6DC6,0x6DEC,0x6DDE,0x6DCC,0x6DE8,0x6DD2,0x6DC5,0x6DFA,0x6DD9,0x6DE4,0x6DD5,0x6DEA,0x6DEE,0x6E2D,
	0x6E6E,0x6E2E,0x6E19,0x6E72,0x6E5F,0x6E3E,0x6E23,0x6E6B,0x6E2B,0x6E76,0x6E4D,0x6E1F,0x6E43,0x6E3A,0x6E4E,0x6E24,
	0x6EFF,0x6E1D,0x6E38,0x6E82,0x6EAA,0x6E98,0x6EC9,0x6EB7,0x6ED3,0x6EBD,0x6EAF,0x6EC4,0x6EB2,0x6ED4,0x6ED5,0x6E8F,
	0x6EA5,0x6EC2,0x6E9F,0x6F41,0x6F11,0x704C,0x6EEC,0x6EF8,0x6EFE,0x6F3F,0x6EF2,0x6F31,0x6EEF,0x6F32,0x6ECC,
};
static const WCHAR _eucj_to_ucs_DF00_data []={ //DFA1 DFFE
	       0x6F3E,0x6F13,0x6EF7,0x6F86,0x6F7A,0x6F78,0x6F81,0x6F80,0x6F6F,0x6F5B,0x6FF3,0x6F6D,0x6F82,0x6F7C,0x6F58,
	0x6F8E,0x6F91,0x6FC2,0x6F66,0x6FB3,0x6FA3,0x6FA1,0x6FA4,0x6FB9,0x6FC6,0x6FAA,0x6FDF,0x6FD5,0x6FEC,0x6FD4,0x6FD8,
	0x6FF1,0x6FEE,0x6FDB,0x7009,0x700B,0x6FFA,0x7011,0x7001,0x700F,0x6FFE,0x701B,0x701A,0x6F74,0x701D,0x7018,0x701F,
	0x7030,0x703E,0x7032,0x7051,0x7063,0x7099,0x7092,0x70AF,0x70F1,0x70AC,0x70B8,0x70B3,0x70AE,0x70DF,0x70CB,0x70DD,
	0x70D9,0x7109,0x70FD,0x711C,0x7119,0x7165,0x7155,0x7188,0x7166,0x7162,0x714C,0x7156,0x716C,0x718F,0x71FB,0x7184,
	0x7195,0x71A8,0x71AC,0x71D7,0x71B9,0x71BE,0x71D2,0x71C9,0x71D4,0x71CE,0x71E0,0x71EC,0x71E7,0x71F5,0x71FC,
};
static const WCHAR _eucj_to_ucs_E000_data []={ //E0A1 E0FE
	       0x71F9,0x71FF,0x720D,0x7210,0x721B,0x7228,0x722D,0x722C,0x7230,0x7232,0x723B,0x723C,0x723F,0x7240,0x7246,
	0x724B,0x7258,0x7274,0x727E,0x7282,0x7281,0x7287,0x7292,0x7296,0x72A2,0x72A7,0x72B9,0x72B2,0x72C3,0x72C6,0x72C4,
	0x72CE,0x72D2,0x72E2,0x72E0,0x72E1,0x72F9,0x72F7,0x500F,0x7317,0x730A,0x731C,0x7316,0x731D,0x7334,0x732F,0x7329,
	0x7325,0x733E,0x734E,0x734F,0x9ED8,0x7357,0x736A,0x7368,0x7370,0x7378,0x7375,0x737B,0x737A,0x73C8,0x73B3,0x73CE,
	0x73BB,0x73C0,0x73E5,0x73EE,0x73DE,0x74A2,0x7405,0x746F,0x7425,0x73F8,0x7432,0x743A,0x7455,0x743F,0x745F,0x7459,
	0x7441,0x745C,0x7469,0x7470,0x7463,0x746A,0x7476,0x747E,0x748B,0x749E,0x74A7,0x74CA,0x74CF,0x74D4,0x73F1,
};
static const WCHAR _eucj_to_ucs_E100_data []={ //E1A1 E1FE
	       0x74E0,0x74E3,0x74E7,0x74E9,0x74EE,0x74F2,0x74F0,0x74F1,0x74F8,0x74F7,0x7504,0x7503,0x7505,0x750C,0x750E,
	0x750D,0x7515,0x7513,0x751E,0x7526,0x752C,0x753C,0x7544,0x754D,0x754A,0x7549,0x755B,0x7546,0x755A,0x7569,0x7564,
	0x7567,0x756B,0x756D,0x7578,0x7576,0x7586,0x7587,0x7574,0x758A,0x7589,0x7582,0x7594,0x759A,0x759D,0x75A5,0x75A3,
	0x75C2,0x75B3,0x75C3,0x75B5,0x75BD,0x75B8,0x75BC,0x75B1,0x75CD,0x75CA,0x75D2,0x75D9,0x75E3,0x75DE,0x75FE,0x75FF,
	0x75FC,0x7601,0x75F0,0x75FA,0x75F2,0x75F3,0x760B,0x760D,0x7609,0x761F,0x7627,0x7620,0x7621,0x7622,0x7624,0x7634,
	0x7630,0x763B,0x7647,0x7648,0x7646,0x765C,0x7658,0x7661,0x7662,0x7668,0x7669,0x766A,0x7667,0x766C,0x7670,
};
static const WCHAR _eucj_to_ucs_E200_data []={ //E2A1 E2FE
	       0x7672,0x7676,0x7678,0x767C,0x7680,0x7683,0x7688,0x768B,0x768E,0x7696,0x7693,0x7699,0x769A,0x76B0,0x76B4,
	0x76B8,0x76B9,0x76BA,0x76C2,0x76CD,0x76D6,0x76D2,0x76DE,0x76E1,0x76E5,0x76E7,0x76EA,0x862F,0x76FB,0x7708,0x7707,
	0x7704,0x7729,0x7724,0x771E,0x7725,0x7726,0x771B,0x7737,0x7738,0x7747,0x775A,0x7768,0x776B,0x775B,0x7765,0x777F,
	0x777E,0x7779,0x778E,0x778B,0x7791,0x77A0,0x779E,0x77B0,0x77B6,0x77B9,0x77BF,0x77BC,0x77BD,0x77BB,0x77C7,0x77CD,
	0x77D7,0x77DA,0x77DC,0x77E3,0x77EE,0x77FC,0x780C,0x7812,0x7926,0x7820,0x792A,0x7845,0x788E,0x7874,0x7886,0x787C,
	0x789A,0x788C,0x78A3,0x78B5,0x78AA,0x78AF,0x78D1,0x78C6,0x78CB,0x78D4,0x78BE,0x78BC,0x78C5,0x78CA,0x78EC,
};
static const WCHAR _eucj_to_ucs_E300_data []={ //E3A1 E3FE
	       0x78E7,0x78DA,0x78FD,0x78F4,0x7907,0x7912,0x7911,0x7919,0x792C,0x792B,0x7940,0x7960,0x7957,0x795F,0x795A,
	0x7955,0x7953,0x797A,0x797F,0x798A,0x799D,0x79A7,0x9F4B,0x79AA,0x79AE,0x79B3,0x79B9,0x79BA,0x79C9,0x79D5,0x79E7,
	0x79EC,0x79E1,0x79E3,0x7A08,0x7A0D,0x7A18,0x7A19,0x7A20,0x7A1F,0x7980,0x7A31,0x7A3B,0x7A3E,0x7A37,0x7A43,0x7A57,
	0x7A49,0x7A61,0x7A62,0x7A69,0x9F9D,0x7A70,0x7A79,0x7A7D,0x7A88,0x7A97,0x7A95,0x7A98,0x7A96,0x7AA9,0x7AC8,0x7AB0,
	0x7AB6,0x7AC5,0x7AC4,0x7ABF,0x9083,0x7AC7,0x7ACA,0x7ACD,0x7ACF,0x7AD5,0x7AD3,0x7AD9,0x7ADA,0x7ADD,0x7AE1,0x7AE2,
	0x7AE6,0x7AED,0x7AF0,0x7B02,0x7B0F,0x7B0A,0x7B06,0x7B33,0x7B18,0x7B19,0x7B1E,0x7B35,0x7B28,0x7B36,0x7B50,
};
static const WCHAR _eucj_to_ucs_E400_data []={ //E4A1 E4FE
	       0x7B7A,0x7B04,0x7B4D,0x7B0B,0x7B4C,0x7B45,0x7B75,0x7B65,0x7B74,0x7B67,0x7B70,0x7B71,0x7B6C,0x7B6E,0x7B9D,
	0x7B98,0x7B9F,0x7B8D,0x7B9C,0x7B9A,0x7B8B,0x7B92,0x7B8F,0x7B5D,0x7B99,0x7BCB,0x7BC1,0x7BCC,0x7BCF,0x7BB4,0x7BC6,
	0x7BDD,0x7BE9,0x7C11,0x7C14,0x7BE6,0x7BE5,0x7C60,0x7C00,0x7C07,0x7C13,0x7BF3,0x7BF7,0x7C17,0x7C0D,0x7BF6,0x7C23,
	0x7C27,0x7C2A,0x7C1F,0x7C37,0x7C2B,0x7C3D,0x7C4C,0x7C43,0x7C54,0x7C4F,0x7C40,0x7C50,0x7C58,0x7C5F,0x7C64,0x7C56,
	0x7C65,0x7C6C,0x7C75,0x7C83,0x7C90,0x7CA4,0x7CAD,0x7CA2,0x7CAB,0x7CA1,0x7CA8,0x7CB3,0x7CB2,0x7CB1,0x7CAE,0x7CB9,
	0x7CBD,0x7CC0,0x7CC5,0x7CC2,0x7CD8,0x7CD2,0x7CDC,0x7CE2,0x9B3B,0x7CEF,0x7CF2,0x7CF4,0x7CF6,0x7CFA,0x7D06,
};
static const WCHAR _eucj_to_ucs_E500_data []={ //E5A1 E5FE
	       0x7D02,0x7D1C,0x7D15,0x7D0A,0x7D45,0x7D4B,0x7D2E,0x7D32,0x7D3F,0x7D35,0x7D46,0x7D73,0x7D56,0x7D4E,0x7D72,
	0x7D68,0x7D6E,0x7D4F,0x7D63,0x7D93,0x7D89,0x7D5B,0x7D8F,0x7D7D,0x7D9B,0x7DBA,0x7DAE,0x7DA3,0x7DB5,0x7DC7,0x7DBD,
	0x7DAB,0x7E3D,0x7DA2,0x7DAF,0x7DDC,0x7DB8,0x7D9F,0x7DB0,0x7DD8,0x7DDD,0x7DE4,0x7DDE,0x7DFB,0x7DF2,0x7DE1,0x7E05,
	0x7E0A,0x7E23,0x7E21,0x7E12,0x7E31,0x7E1F,0x7E09,0x7E0B,0x7E22,0x7E46,0x7E66,0x7E3B,0x7E35,0x7E39,0x7E43,0x7E37,
	0x7E32,0x7E3A,0x7E67,0x7E5D,0x7E56,0x7E5E,0x7E59,0x7E5A,0x7E79,0x7E6A,0x7E69,0x7E7C,0x7E7B,0x7E83,0x7DD5,0x7E7D,
	0x8FAE,0x7E7F,0x7E88,0x7E89,0x7E8C,0x7E92,0x7E90,0x7E93,0x7E94,0x7E96,0x7E8E,0x7E9B,0x7E9C,0x7F38,0x7F3A,
};
static const WCHAR _eucj_to_ucs_E600_data []={ //E6A1 E6FE
	       0x7F45,0x7F4C,0x7F4D,0x7F4E,0x7F50,0x7F51,0x7F55,0x7F54,0x7F58,0x7F5F,0x7F60,0x7F68,0x7F69,0x7F67,0x7F78,
	0x7F82,0x7F86,0x7F83,0x7F88,0x7F87,0x7F8C,0x7F94,0x7F9E,0x7F9D,0x7F9A,0x7FA3,0x7FAF,0x7FB2,0x7FB9,0x7FAE,0x7FB6,
	0x7FB8,0x8B71,0x7FC5,0x7FC6,0x7FCA,0x7FD5,0x7FD4,0x7FE1,0x7FE6,0x7FE9,0x7FF3,0x7FF9,0x98DC,0x8006,0x8004,0x800B,
	0x8012,0x8018,0x8019,0x801C,0x8021,0x8028,0x803F,0x803B,0x804A,0x8046,0x8052,0x8058,0x805A,0x805F,0x8062,0x8068,
	0x8073,0x8072,0x8070,0x8076,0x8079,0x807D,0x807F,0x8084,0x8086,0x8085,0x809B,0x8093,0x809A,0x80AD,0x5190,0x80AC,
	0x80DB,0x80E5,0x80D9,0x80DD,0x80C4,0x80DA,0x80D6,0x8109,0x80EF,0x80F1,0x811B,0x8129,0x8123,0x812F,0x814B,
};
static const WCHAR _eucj_to_ucs_E700_data []={ //E7A1 E7FE
	       0x968B,0x8146,0x813E,0x8153,0x8151,0x80FC,0x8171,0x816E,0x8165,0x8166,0x8174,0x8183,0x8188,0x818A,0x8180,
	0x8182,0x81A0,0x8195,0x81A4,0x81A3,0x815F,0x8193,0x81A9,0x81B0,0x81B5,0x81BE,0x81B8,0x81BD,0x81C0,0x81C2,0x81BA,
	0x81C9,0x81CD,0x81D1,0x81D9,0x81D8,0x81C8,0x81DA,0x81DF,0x81E0,0x81E7,0x81FA,0x81FB,0x81FE,0x8201,0x8202,0x8205,
	0x8207,0x820A,0x820D,0x8210,0x8216,0x8229,0x822B,0x8238,0x8233,0x8240,0x8259,0x8258,0x825D,0x825A,0x825F,0x8264,
	0x8262,0x8268,0x826A,0x826B,0x822E,0x8271,0x8277,0x8278,0x827E,0x828D,0x8292,0x82AB,0x829F,0x82BB,0x82AC,0x82E1,
	0x82E3,0x82DF,0x82D2,0x82F4,0x82F3,0x82FA,0x8393,0x8303,0x82FB,0x82F9,0x82DE,0x8306,0x82DC,0x8309,0x82D9,
};
static const WCHAR _eucj_to_ucs_E800_data []={ //E8A1 E8FE
	       0x8335,0x8334,0x8316,0x8332,0x8331,0x8340,0x8339,0x8350,0x8345,0x832F,0x832B,0x8317,0x8318,0x8385,0x839A,
	0x83AA,0x839F,0x83A2,0x8396,0x8323,0x838E,0x8387,0x838A,0x837C,0x83B5,0x8373,0x8375,0x83A0,0x8389,0x83A8,0x83F4,
	0x8413,0x83EB,0x83CE,0x83FD,0x8403,0x83D8,0x840B,0x83C1,0x83F7,0x8407,0x83E0,0x83F2,0x840D,0x8422,0x8420,0x83BD,
	0x8438,0x8506,0x83FB,0x846D,0x842A,0x843C,0x855A,0x8484,0x8477,0x846B,0x84AD,0x846E,0x8482,0x8469,0x8446,0x842C,
	0x846F,0x8479,0x8435,0x84CA,0x8462,0x84B9,0x84BF,0x849F,0x84D9,0x84CD,0x84BB,0x84DA,0x84D0,0x84C1,0x84C6,0x84D6,
	0x84A1,0x8521,0x84FF,0x84F4,0x8517,0x8518,0x852C,0x851F,0x8515,0x8514,0x84FC,0x8540,0x8563,0x8558,0x8548,
};
static const WCHAR _eucj_to_ucs_E900_data []={ //E9A1 E9FE
	       0x8541,0x8602,0x854B,0x8555,0x8580,0x85A4,0x8588,0x8591,0x858A,0x85A8,0x856D,0x8594,0x859B,0x85EA,0x8587,
	0x859C,0x8577,0x857E,0x8590,0x85C9,0x85BA,0x85CF,0x85B9,0x85D0,0x85D5,0x85DD,0x85E5,0x85DC,0x85F9,0x860A,0x8613,
	0x860B,0x85FE,0x85FA,0x8606,0x8622,0x861A,0x8630,0x863F,0x864D,0x4E55,0x8654,0x865F,0x8667,0x8671,0x8693,0x86A3,
	0x86A9,0x86AA,0x868B,0x868C,0x86B6,0x86AF,0x86C4,0x86C6,0x86B0,0x86C9,0x8823,0x86AB,0x86D4,0x86DE,0x86E9,0x86EC,
	0x86DF,0x86DB,0x86EF,0x8712,0x8706,0x8708,0x8700,0x8703,0x86FB,0x8711,0x8709,0x870D,0x86F9,0x870A,0x8734,0x873F,
	0x8737,0x873B,0x8725,0x8729,0x871A,0x8760,0x875F,0x8778,0x874C,0x874E,0x8774,0x8757,0x8768,0x876E,0x8759,
};
static const WCHAR _eucj_to_ucs_EA00_data []={ //EAA1 EAFE
	       0x8753,0x8763,0x876A,0x8805,0x87A2,0x879F,0x8782,0x87AF,0x87CB,0x87BD,0x87C0,0x87D0,0x96D6,0x87AB,0x87C4,
	0x87B3,0x87C7,0x87C6,0x87BB,0x87EF,0x87F2,0x87E0,0x880F,0x880D,0x87FE,0x87F6,0x87F7,0x880E,0x87D2,0x8811,0x8816,
	0x8815,0x8822,0x8821,0x8831,0x8836,0x8839,0x8827,0x883B,0x8844,0x8842,0x8852,0x8859,0x885E,0x8862,0x886B,0x8881,
	0x887E,0x889E,0x8875,0x887D,0x88B5,0x8872,0x8882,0x8897,0x8892,0x88AE,0x8899,0x88A2,0x888D,0x88A4,0x88B0,0x88BF,
	0x88B1,0x88C3,0x88C4,0x88D4,0x88D8,0x88D9,0x88DD,0x88F9,0x8902,0x88FC,0x88F4,0x88E8,0x88F2,0x8904,0x890C,0x890A,
	0x8913,0x8943,0x891E,0x8925,0x892A,0x892B,0x8941,0x8944,0x893B,0x8936,0x8938,0x894C,0x891D,0x8960,0x895E,
};
static const WCHAR _eucj_to_ucs_EB00_data []={ //EBA1 EBFE
	       0x8966,0x8964,0x896D,0x896A,0x896F,0x8974,0x8977,0x897E,0x8983,0x8988,0x898A,0x8993,0x8998,0x89A1,0x89A9,
	0x89A6,0x89AC,0x89AF,0x89B2,0x89BA,0x89BD,0x89BF,0x89C0,0x89DA,0x89DC,0x89DD,0x89E7,0x89F4,0x89F8,0x8A03,0x8A16,
	0x8A10,0x8A0C,0x8A1B,0x8A1D,0x8A25,0x8A36,0x8A41,0x8A5B,0x8A52,0x8A46,0x8A48,0x8A7C,0x8A6D,0x8A6C,0x8A62,0x8A85,
	0x8A82,0x8A84,0x8AA8,0x8AA1,0x8A91,0x8AA5,0x8AA6,0x8A9A,0x8AA3,0x8AC4,0x8ACD,0x8AC2,0x8ADA,0x8AEB,0x8AF3,0x8AE7,
	0x8AE4,0x8AF1,0x8B14,0x8AE0,0x8AE2,0x8AF7,0x8ADE,0x8ADB,0x8B0C,0x8B07,0x8B1A,0x8AE1,0x8B16,0x8B10,0x8B17,0x8B20,
	0x8B33,0x97AB,0x8B26,0x8B2B,0x8B3E,0x8B28,0x8B41,0x8B4C,0x8B4F,0x8B4E,0x8B49,0x8B56,0x8B5B,0x8B5A,0x8B6B,
};
static const WCHAR _eucj_to_ucs_EC00_data []={ //ECA1 ECFE
	       0x8B5F,0x8B6C,0x8B6F,0x8B74,0x8B7D,0x8B80,0x8B8C,0x8B8E,0x8B92,0x8B93,0x8B96,0x8B99,0x8B9A,0x8C3A,0x8C41,
	0x8C3F,0x8C48,0x8C4C,0x8C4E,0x8C50,0x8C55,0x8C62,0x8C6C,0x8C78,0x8C7A,0x8C82,0x8C89,0x8C85,0x8C8A,0x8C8D,0x8C8E,
	0x8C94,0x8C7C,0x8C98,0x621D,0x8CAD,0x8CAA,0x8CBD,0x8CB2,0x8CB3,0x8CAE,0x8CB6,0x8CC8,0x8CC1,0x8CE4,0x8CE3,0x8CDA,
	0x8CFD,0x8CFA,0x8CFB,0x8D04,0x8D05,0x8D0A,0x8D07,0x8D0F,0x8D0D,0x8D10,0x9F4E,0x8D13,0x8CCD,0x8D14,0x8D16,0x8D67,
	0x8D6D,0x8D71,0x8D73,0x8D81,0x8D99,0x8DC2,0x8DBE,0x8DBA,0x8DCF,0x8DDA,0x8DD6,0x8DCC,0x8DDB,0x8DCB,0x8DEA,0x8DEB,
	0x8DDF,0x8DE3,0x8DFC,0x8E08,0x8E09,0x8DFF,0x8E1D,0x8E1E,0x8E10,0x8E1F,0x8E42,0x8E35,0x8E30,0x8E34,0x8E4A,
};
static const WCHAR _eucj_to_ucs_ED00_data []={ //EDA1 EDFE
	       0x8E47,0x8E49,0x8E4C,0x8E50,0x8E48,0x8E59,0x8E64,0x8E60,0x8E2A,0x8E63,0x8E55,0x8E76,0x8E72,0x8E7C,0x8E81,
	0x8E87,0x8E85,0x8E84,0x8E8B,0x8E8A,0x8E93,0x8E91,0x8E94,0x8E99,0x8EAA,0x8EA1,0x8EAC,0x8EB0,0x8EC6,0x8EB1,0x8EBE,
	0x8EC5,0x8EC8,0x8ECB,0x8EDB,0x8EE3,0x8EFC,0x8EFB,0x8EEB,0x8EFE,0x8F0A,0x8F05,0x8F15,0x8F12,0x8F19,0x8F13,0x8F1C,
	0x8F1F,0x8F1B,0x8F0C,0x8F26,0x8F33,0x8F3B,0x8F39,0x8F45,0x8F42,0x8F3E,0x8F4C,0x8F49,0x8F46,0x8F4E,0x8F57,0x8F5C,
	0x8F62,0x8F63,0x8F64,0x8F9C,0x8F9F,0x8FA3,0x8FAD,0x8FAF,0x8FB7,0x8FDA,0x8FE5,0x8FE2,0x8FEA,0x8FEF,0x9087,0x8FF4,
	0x9005,0x8FF9,0x8FFA,0x9011,0x9015,0x9021,0x900D,0x901E,0x9016,0x900B,0x9027,0x9036,0x9035,0x9039,0x8FF8,
};
static const WCHAR _eucj_to_ucs_EE00_data []={ //EEA1 EEFE
	       0x904F,0x9050,0x9051,0x9052,0x900E,0x9049,0x903E,0x9056,0x9058,0x905E,0x9068,0x906F,0x9076,0x96A8,0x9072,
	0x9082,0x907D,0x9081,0x9080,0x908A,0x9089,0x908F,0x90A8,0x90AF,0x90B1,0x90B5,0x90E2,0x90E4,0x6248,0x90DB,0x9102,
	0x9112,0x9119,0x9132,0x9130,0x914A,0x9156,0x9158,0x9163,0x9165,0x9169,0x9173,0x9172,0x918B,0x9189,0x9182,0x91A2,
	0x91AB,0x91AF,0x91AA,0x91B5,0x91B4,0x91BA,0x91C0,0x91C1,0x91C9,0x91CB,0x91D0,0x91D6,0x91DF,0x91E1,0x91DB,0x91FC,
	0x91F5,0x91F6,0x921E,0x91FF,0x9214,0x922C,0x9215,0x9211,0x925E,0x9257,0x9245,0x9249,0x9264,0x9248,0x9295,0x923F,
	0x924B,0x9250,0x929C,0x9296,0x9293,0x929B,0x925A,0x92CF,0x92B9,0x92B7,0x92E9,0x930F,0x92FA,0x9344,0x932E,
};
static const WCHAR _eucj_to_ucs_EF00_data []={ //EFA1 EFFE
	       0x9319,0x9322,0x931A,0x9323,0x933A,0x9335,0x933B,0x935C,0x9360,0x937C,0x936E,0x9356,0x93B0,0x93AC,0x93AD,
	0x9394,0x93B9,0x93D6,0x93D7,0x93E8,0x93E5,0x93D8,0x93C3,0x93DD,0x93D0,0x93C8,0x93E4,0x941A,0x9414,0x9413,0x9403,
	0x9407,0x9410,0x9436,0x942B,0x9435,0x9421,0x943A,0x9441,0x9452,0x9444,0x945B,0x9460,0x9462,0x945E,0x946A,0x9229,
	0x9470,0x9475,0x9477,0x947D,0x945A,0x947C,0x947E,0x9481,0x947F,0x9582,0x9587,0x958A,0x9594,0x9596,0x9598,0x9599,
	0x95A0,0x95A8,0x95A7,0x95AD,0x95BC,0x95BB,0x95B9,0x95BE,0x95CA,0x6FF6,0x95C3,0x95CD,0x95CC,0x95D5,0x95D4,0x95D6,
	0x95DC,0x95E1,0x95E5,0x95E2,0x9621,0x9628,0x962E,0x962F,0x9642,0x964C,0x964F,0x964B,0x9677,0x965C,0x965E,
};
static const WCHAR _eucj_to_ucs_F000_data []={ //F0A1 F0FE
	       0x965D,0x965F,0x9666,0x9672,0x966C,0x968D,0x9698,0x9695,0x9697,0x96AA,0x96A7,0x96B1,0x96B2,0x96B0,0x96B4,
	0x96B6,0x96B8,0x96B9,0x96CE,0x96CB,0x96C9,0x96CD,0x894D,0x96DC,0x970D,0x96D5,0x96F9,0x9704,0x9706,0x9708,0x9713,
	0x970E,0x9711,0x970F,0x9716,0x9719,0x9724,0x972A,0x9730,0x9739,0x973D,0x973E,0x9744,0x9746,0x9748,0x9742,0x9749,
	0x975C,0x9760,0x9764,0x9766,0x9768,0x52D2,0x976B,0x9771,0x9779,0x9785,0x977C,0x9781,0x977A,0x9786,0x978B,0x978F,
	0x9790,0x979C,0x97A8,0x97A6,0x97A3,0x97B3,0x97B4,0x97C3,0x97C6,0x97C8,0x97CB,0x97DC,0x97ED,0x9F4F,0x97F2,0x7ADF,
	0x97F6,0x97F5,0x980F,0x980C,0x9838,0x9824,0x9821,0x9837,0x983D,0x9846,0x984F,0x984B,0x986B,0x986F,0x9870,
};
static const WCHAR _eucj_to_ucs_F100_data []={ //F1A1 F1FE
	       0x9871,0x9874,0x9873,0x98AA,0x98AF,0x98B1,0x98B6,0x98C4,0x98C3,0x98C6,0x98E9,0x98EB,0x9903,0x9909,0x9912,
	0x9914,0x9918,0x9921,0x991D,0x991E,0x9924,0x9920,0x992C,0x992E,0x993D,0x993E,0x9942,0x9949,0x9945,0x9950,0x994B,
	0x9951,0x9952,0x994C,0x9955,0x9997,0x9998,0x99A5,0x99AD,0x99AE,0x99BC,0x99DF,0x99DB,0x99DD,0x99D8,0x99D1,0x99ED,
	0x99EE,0x99F1,0x99F2,0x99FB,0x99F8,0x9A01,0x9A0F,0x9A05,0x99E2,0x9A19,0x9A2B,0x9A37,0x9A45,0x9A42,0x9A40,0x9A43,
	0x9A3E,0x9A55,0x9A4D,0x9A5B,0x9A57,0x9A5F,0x9A62,0x9A65,0x9A64,0x9A69,0x9A6B,0x9A6A,0x9AAD,0x9AB0,0x9ABC,0x9AC0,
	0x9ACF,0x9AD1,0x9AD3,0x9AD4,0x9ADE,0x9ADF,0x9AE2,0x9AE3,0x9AE6,0x9AEF,0x9AEB,0x9AEE,0x9AF4,0x9AF1,0x9AF7,
};
static const WCHAR _eucj_to_ucs_F200_data []={ //F2A1 F2FE
	       0x9AFB,0x9B06,0x9B18,0x9B1A,0x9B1F,0x9B22,0x9B23,0x9B25,0x9B27,0x9B28,0x9B29,0x9B2A,0x9B2E,0x9B2F,0x9B32,
	0x9B44,0x9B43,0x9B4F,0x9B4D,0x9B4E,0x9B51,0x9B58,0x9B74,0x9B93,0x9B83,0x9B91,0x9B96,0x9B97,0x9B9F,0x9BA0,0x9BA8,
	0x9BB4,0x9BC0,0x9BCA,0x9BB9,0x9BC6,0x9BCF,0x9BD1,0x9BD2,0x9BE3,0x9BE2,0x9BE4,0x9BD4,0x9BE1,0x9C3A,0x9BF2,0x9BF1,
	0x9BF0,0x9C15,0x9C14,0x9C09,0x9C13,0x9C0C,0x9C06,0x9C08,0x9C12,0x9C0A,0x9C04,0x9C2E,0x9C1B,0x9C25,0x9C24,0x9C21,
	0x9C30,0x9C47,0x9C32,0x9C46,0x9C3E,0x9C5A,0x9C60,0x9C67,0x9C76,0x9C78,0x9CE7,0x9CEC,0x9CF0,0x9D09,0x9D08,0x9CEB,
	0x9D03,0x9D06,0x9D2A,0x9D26,0x9DAF,0x9D23,0x9D1F,0x9D44,0x9D15,0x9D12,0x9D41,0x9D3F,0x9D3E,0x9D46,0x9D48,
};
static const WCHAR _eucj_to_ucs_F300_data []={ //F3A1 F3FE
	       0x9D5D,0x9D5E,0x9D64,0x9D51,0x9D50,0x9D59,0x9D72,0x9D89,0x9D87,0x9DAB,0x9D6F,0x9D7A,0x9D9A,0x9DA4,0x9DA9,
	0x9DB2,0x9DC4,0x9DC1,0x9DBB,0x9DB8,0x9DBA,0x9DC6,0x9DCF,0x9DC2,0x9DD9,0x9DD3,0x9DF8,0x9DE6,0x9DED,0x9DEF,0x9DFD,
	0x9E1A,0x9E1B,0x9E1E,0x9E75,0x9E79,0x9E7D,0x9E81,0x9E88,0x9E8B,0x9E8C,0x9E92,0x9E95,0x9E91,0x9E9D,0x9EA5,0x9EA9,
	0x9EB8,0x9EAA,0x9EAD,0x9761,0x9ECC,0x9ECE,0x9ECF,0x9ED0,0x9ED4,0x9EDC,0x9EDE,0x9EDD,0x9EE0,0x9EE5,0x9EE8,0x9EEF,
	0x9EF4,0x9EF6,0x9EF7,0x9EF9,0x9EFB,0x9EFC,0x9EFD,0x9F07,0x9F08,0x76B7,0x9F15,0x9F21,0x9F2C,0x9F3E,0x9F4A,0x9F52,
	0x9F54,0x9F63,0x9F5F,0x9F60,0x9F61,0x9F66,0x9F67,0x9F6C,0x9F6A,0x9F77,0x9F72,0x9F76,0x9F95,0x9F9C,0x9FA0,
};
static const WCHAR _eucj_to_ucs_F400_data []={ //F4A1 F4A6
	       0x582F,0x69C7,0x9059,0x7464,0x51DC,0x7199,
};
static const WCHAR _eucj_to_ucs_F900_data []={ //F9A1 F9FE
	       0x7E8A,0x891C,0x9348,0x9288,0x84DC,0x4FC9,0x70BB,0x6631,0x68C8,0x92F9,0x66FB,0x5F45,0x4E28,0x4EE1,0x4EFC,
	0x4F00,0x4F03,0x4F39,0x4F56,0x4F92,0x4F8A,0x4F9A,0x4F94,0x4FCD,0x5040,0x5022,0x4FFF,0x501E,0x5046,0x5070,0x5042,
	0x5094,0x50F4,0x50D8,0x514A,0x5164,0x519D,0x51BE,0x51EC,0x5215,0x529C,0x52A6,0x52C0,0x52DB,0x5300,0x5307,0x5324,
	0x5372,0x5393,0x53B2,0x53DD,0xFA0E,0x549C,0x548A,0x54A9,0x54FF,0x5586,0x5759,0x5765,0x57AC,0x57C8,0x57C7,0xFA0F,
	0xFA10,0x589E,0x58B2,0x590B,0x5953,0x595B,0x595D,0x5963,0x59A4,0x59BA,0x5B56,0x5BC0,0x752F,0x5BD8,0x5BEC,0x5C1E,
	0x5CA6,0x5CBA,0x5CF5,0x5D27,0x5D53,0xFA11,0x5D42,0x5D6D,0x5DB8,0x5DB9,0x5DD0,0x5F21,0x5F34,0x5F67,0x5FB7,
};
static const WCHAR _eucj_to_ucs_FA00_data []={ //FAA1 FAFE
	       0x5FDE,0x605D,0x6085,0x608A,0x60DE,0x60D5,0x6120,0x60F2,0x6111,0x6137,0x6130,0x6198,0x6213,0x62A6,0x63F5,
	0x6460,0x649D,0x64CE,0x654E,0x6600,0x6615,0x663B,0x6609,0x662E,0x661E,0x6624,0x6665,0x6657,0x6659,0xFA12,0x6673,
	0x6699,0x66A0,0x66B2,0x66BF,0x66FA,0x670E,0xF929,0x6766,0x67BB,0x6852,0x67C0,0x6801,0x6844,0x68CF,0xFA13,0x6968,
	0xFA14,0x6998,0x69E2,0x6A30,0x6A6B,0x6A46,0x6A73,0x6A7E,0x6AE2,0x6AE4,0x6BD6,0x6C3F,0x6C5C,0x6C86,0x6C6F,0x6CDA,
	0x6D04,0x6D87,0x6D6F,0x6D96,0x6DAC,0x6DCF,0x6DF8,0x6DF2,0x6DFC,0x6E39,0x6E5C,0x6E27,0x6E3C,0x6EBF,0x6F88,0x6FB5,
	0x6FF5,0x7005,0x7007,0x7028,0x7085,0x70AB,0x710F,0x7104,0x715C,0x7146,0x7147,0xFA15,0x71C1,0x71FE,0x72B1,
};
static const WCHAR _eucj_to_ucs_FB00_data []={ //FBA1 FBFE
	       0x72BE,0x7324,0xFA16,0x7377,0x73BD,0x73C9,0x73D6,0x73E3,0x73D2,0x7407,0x73F5,0x7426,0x742A,0x7429,0x742E,
	0x7462,0x7489,0x749F,0x7501,0x756F,0x7682,0x769C,0x769E,0x769B,0x76A6,0xFA17,0x7746,0x52AF,0x7821,0x784E,0x7864,
	0x787A,0x7930,0xFA18,0xFA19,0xFA1A,0x7994,0xFA1B,0x799B,0x7AD1,0x7AE7,0xFA1C,0x7AEB,0x7B9E,0xFA1D,0x7D48,0x7D5C,
	0x7DB7,0x7DA0,0x7DD6,0x7E52,0x7F47,0x7FA1,0xFA1E,0x8301,0x8362,0x837F,0x83C7,0x83F6,0x8448,0x84B4,0x8553,0x8559,
	0x856B,0xFA1F,0x85B0,0xFA20,0xFA21,0x8807,0x88F5,0x8A12,0x8A37,0x8A79,0x8AA7,0x8ABE,0x8ADF,0xFA22,0x8AF6,0x8B53,
	0x8B7F,0x8CF0,0x8CF4,0x8D12,0x8D76,0xFA23,0x8ECF,0xFA24,0xFA25,0x9067,0x90DE,0xFA26,0x9115,0x9127,0x91DA,
};
static const WCHAR _eucj_to_ucs_FC00_data []={ //FCA1 FCFE
	       0x91D7,0x91DE,0x91ED,0x91EE,0x91E4,0x91E5,0x9206,0x9210,0x920A,0x923A,0x9240,0x923C,0x924E,0x9259,0x9251,
	0x9239,0x9267,0x92A7,0x9277,0x9278,0x92E7,0x92D7,0x92D9,0x92D0,0xFA27,0x92D5,0x92E0,0x92D3,0x9325,0x9321,0x92FB,
	0xFA28,0x931E,0x92FF,0x931D,0x9302,0x9370,0x9357,0x93A4,0x93C6,0x93DE,0x93F8,0x9431,0x9445,0x9448,0x9592,0xF9DC,
	0xFA29,0x969D,0x96AF,0x9733,0x973B,0x9743,0x974D,0x974F,0x9751,0x9755,0x9857,0x9865,0xFA2A,0xFA2B,0x9927,0xFA2C,
	0x999E,0x9A4E,0x9AD9,0x9ADC,0x9B75,0x9B72,0x9B8F,0x9BB1,0x9BBB,0x9C00,0x9D70,0x9D6B,0xFA2D,0x9E19,0x9ED1,0x0000,
	0x0000,0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176,0x2177,0x2178,0x2179,0x0000,0xFFE4,0xFF07,0xFF02,
};
extern const struct _encoding_table_a _eucj_to_ucs_table []={
	{ 0x00FF,0x0001,_eucj_to_ucs_0000_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x8EDF,0x8EA1,_eucj_to_ucs_8E00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xA1FE,0xA1A1,_eucj_to_ucs_A100_data },
	{ 0xA2FE,0xA2A1,_eucj_to_ucs_A200_data },
	{ 0xA3FA,0xA3B0,_eucj_to_ucs_A300_data },
	{ 0xA4F3,0xA4A1,_eucj_to_ucs_A400_data },
	{ 0xA5F6,0xA5A1,_eucj_to_ucs_A500_data },
	{ 0xA6D8,0xA6A1,_eucj_to_ucs_A600_data },
	{ 0xA7F1,0xA7A1,_eucj_to_ucs_A700_data },
	{ 0xA8C0,0xA8A1,_eucj_to_ucs_A800_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xADF9,0xADA1,_eucj_to_ucs_AD00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xB0FE,0xB0A1,_eucj_to_ucs_B000_data },
	{ 0xB1FE,0xB1A1,_eucj_to_ucs_B100_data },
	{ 0xB2FE,0xB2A1,_eucj_to_ucs_B200_data },
	{ 0xB3FE,0xB3A1,_eucj_to_ucs_B300_data },
	{ 0xB4FE,0xB4A1,_eucj_to_ucs_B400_data },
	{ 0xB5FE,0xB5A1,_eucj_to_ucs_B500_data },
	{ 0xB6FE,0xB6A1,_eucj_to_ucs_B600_data },
	{ 0xB7FE,0xB7A1,_eucj_to_ucs_B700_data },
	{ 0xB8FE,0xB8A1,_eucj_to_ucs_B800_data },
	{ 0xB9FE,0xB9A1,_eucj_to_ucs_B900_data },
	{ 0xBAFE,0xBAA1,_eucj_to_ucs_BA00_data },
	{ 0xBBFE,0xBBA1,_eucj_to_ucs_BB00_data },
	{ 0xBCFE,0xBCA1,_eucj_to_ucs_BC00_data },
	{ 0xBDFE,0xBDA1,_eucj_to_ucs_BD00_data },
	{ 0xBEFE,0xBEA1,_eucj_to_ucs_BE00_data },
	{ 0xBFFE,0xBFA1,_eucj_to_ucs_BF00_data },
	{ 0xC0FE,0xC0A1,_eucj_to_ucs_C000_data },
	{ 0xC1FE,0xC1A1,_eucj_to_ucs_C100_data },
	{ 0xC2FE,0xC2A1,_eucj_to_ucs_C200_data },
	{ 0xC3FE,0xC3A1,_eucj_to_ucs_C300_data },
	{ 0xC4FE,0xC4A1,_eucj_to_ucs_C400_data },
	{ 0xC5FE,0xC5A1,_eucj_to_ucs_C500_data },
	{ 0xC6FE,0xC6A1,_eucj_to_ucs_C600_data },
	{ 0xC7FE,0xC7A1,_eucj_to_ucs_C700_data },
	{ 0xC8FE,0xC8A1,_eucj_to_ucs_C800_data },
	{ 0xC9FE,0xC9A1,_eucj_to_ucs_C900_data },
	{ 0xCAFE,0xCAA1,_eucj_to_ucs_CA00_data },
	{ 0xCBFE,0xCBA1,_eucj_to_ucs_CB00_data },
	{ 0xCCFE,0xCCA1,_eucj_to_ucs_CC00_data },
	{ 0xCDFE,0xCDA1,_eucj_to_ucs_CD00_data },
	{ 0xCEFE,0xCEA1,_eucj_to_ucs_CE00_data },
	{ 0xCFD3,0xCFA1,_eucj_to_ucs_CF00_data },
	{ 0xD0FE,0xD0A1,_eucj_to_ucs_D000_data },
	{ 0xD1FE,0xD1A1,_eucj_to_ucs_D100_data },
	{ 0xD2FE,0xD2A1,_eucj_to_ucs_D200_data },
	{ 0xD3FE,0xD3A1,_eucj_to_ucs_D300_data },
	{ 0xD4FE,0xD4A1,_eucj_to_ucs_D400_data },
	{ 0xD5FE,0xD5A1,_eucj_to_ucs_D500_data },
	{ 0xD6FE,0xD6A1,_eucj_to_ucs_D600_data },
	{ 0xD7FE,0xD7A1,_eucj_to_ucs_D700_data },
	{ 0xD8FE,0xD8A1,_eucj_to_ucs_D800_data },
	{ 0xD9FE,0xD9A1,_eucj_to_ucs_D900_data },
	{ 0xDAFE,0xDAA1,_eucj_to_ucs_DA00_data },
	{ 0xDBFE,0xDBA1,_eucj_to_ucs_DB00_data },
	{ 0xDCFE,0xDCA1,_eucj_to_ucs_DC00_data },
	{ 0xDDFE,0xDDA1,_eucj_to_ucs_DD00_data },
	{ 0xDEFE,0xDEA1,_eucj_to_ucs_DE00_data },
	{ 0xDFFE,0xDFA1,_eucj_to_ucs_DF00_data },
	{ 0xE0FE,0xE0A1,_eucj_to_ucs_E000_data },
	{ 0xE1FE,0xE1A1,_eucj_to_ucs_E100_data },
	{ 0xE2FE,0xE2A1,_eucj_to_ucs_E200_data },
	{ 0xE3FE,0xE3A1,_eucj_to_ucs_E300_data },
	{ 0xE4FE,0xE4A1,_eucj_to_ucs_E400_data },
	{ 0xE5FE,0xE5A1,_eucj_to_ucs_E500_data },
	{ 0xE6FE,0xE6A1,_eucj_to_ucs_E600_data },
	{ 0xE7FE,0xE7A1,_eucj_to_ucs_E700_data },
	{ 0xE8FE,0xE8A1,_eucj_to_ucs_E800_data },
	{ 0xE9FE,0xE9A1,_eucj_to_ucs_E900_data },
	{ 0xEAFE,0xEAA1,_eucj_to_ucs_EA00_data },
	{ 0xEBFE,0xEBA1,_eucj_to_ucs_EB00_data },
	{ 0xECFE,0xECA1,_eucj_to_ucs_EC00_data },
	{ 0xEDFE,0xEDA1,_eucj_to_ucs_ED00_data },
	{ 0xEEFE,0xEEA1,_eucj_to_ucs_EE00_data },
	{ 0xEFFE,0xEFA1,_eucj_to_ucs_EF00_data },
	{ 0xF0FE,0xF0A1,_eucj_to_ucs_F000_data },
	{ 0xF1FE,0xF1A1,_eucj_to_ucs_F100_data },
	{ 0xF2FE,0xF2A1,_eucj_to_ucs_F200_data },
	{ 0xF3FE,0xF3A1,_eucj_to_ucs_F300_data },
	{ 0xF4A6,0xF4A1,_eucj_to_ucs_F400_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xF9FE,0xF9A1,_eucj_to_ucs_F900_data },
	{ 0xFAFE,0xFAA1,_eucj_to_ucs_FA00_data },
	{ 0xFBFE,0xFBA1,_eucj_to_ucs_FB00_data },
	{ 0xFCFE,0xFCA1,_eucj_to_ucs_FC00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
};
static const WORD _ucs_to_eucj_0000_data []={ //0001 00FF
	       0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,0x0018,0x0019,0x001A,0x001B,0x001C,0x001D,0x001E,0x001F,
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003A,0x003B,0x003C,0x003D,0x003E,0x003F,
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x004F,
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006A,0x006B,0x006C,0x006D,0x006E,0x006F,
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,
	0x0080,0x0081,0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,0x0088,0x0089,0x008A,0x008B,0x008C,0x008D,0x008E,0x008F,
	0x0090,0x0091,0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,0x0098,0x0099,0x009A,0x009B,0x009C,0x009D,0x009E,0x009F,
	0x00A0,0x00A1,0x00A2,0x00A3,0x00A4,0x00A5,0x00A6,0xA1F8,0xA1AF,0x00A9,0x00AA,0x00AB,0x00AC,0x00AD,0x00AE,0x00AF,
	0xA1EB,0xA1DE,0x00B2,0x00B3,0xA1AD,0x00B5,0xA2F9,0x00B7,0x00B8,0x00B9,0x00BA,0x00BB,0x00BC,0x00BD,0x00BE,0x00BF,
	0x00C0,0x00C1,0x00C2,0x00C3,0x00C4,0x00C5,0x00C6,0x00C7,0x00C8,0x00C9,0x00CA,0x00CB,0x00CC,0x00CD,0x00CE,0x00CF,
	0x00D0,0x00D1,0x00D2,0x00D3,0x00D4,0x00D5,0x00D6,0xA1DF,0x00D8,0x00D9,0x00DA,0x00DB,0x00DC,0x00DD,0x00DE,0x00DF,
	0x00E0,0x00E1,0x00E2,0x00E3,0x00E4,0x00E5,0x00E6,0x00E7,0x00E8,0x00E9,0x00EA,0x00EB,0x00EC,0x00ED,0x00EE,0x00EF,
	0x00F0,0x00F1,0x00F2,0x00F3,0x00F4,0x00F5,0x00F6,0xA1E0,0x00F8,0x00F9,0x00FA,0x00FB,0x00FC,0x00FD,0x00FE,0x00FF,
};
static const WORD _ucs_to_eucj_0300_data []={ //0391 03C9
	       0xA6A1,0xA6A2,0xA6A3,0xA6A4,0xA6A5,0xA6A6,0xA6A7,0xA6A8,0xA6A9,0xA6AA,0xA6AB,0xA6AC,0xA6AD,0xA6AE,0xA6AF,
	0xA6B0,0xA6B1,0x0000,0xA6B2,0xA6B3,0xA6B4,0xA6B5,0xA6B6,0xA6B7,0xA6B8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xA6C1,0xA6C2,0xA6C3,0xA6C4,0xA6C5,0xA6C6,0xA6C7,0xA6C8,0xA6C9,0xA6CA,0xA6CB,0xA6CC,0xA6CD,0xA6CE,0xA6CF,
	0xA6D0,0xA6D1,0x0000,0xA6D2,0xA6D3,0xA6D4,0xA6D5,0xA6D6,0xA6D7,0xA6D8,
};
static const WORD _ucs_to_eucj_0400_data []={ //0401 0451
	       0xA7A7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xA7A1,0xA7A2,0xA7A3,0xA7A4,0xA7A5,0xA7A6,0xA7A8,0xA7A9,0xA7AA,0xA7AB,0xA7AC,0xA7AD,0xA7AE,0xA7AF,0xA7B0,0xA7B1,
	0xA7B2,0xA7B3,0xA7B4,0xA7B5,0xA7B6,0xA7B7,0xA7B8,0xA7B9,0xA7BA,0xA7BB,0xA7BC,0xA7BD,0xA7BE,0xA7BF,0xA7C0,0xA7C1,
	0xA7D1,0xA7D2,0xA7D3,0xA7D4,0xA7D5,0xA7D6,0xA7D8,0xA7D9,0xA7DA,0xA7DB,0xA7DC,0xA7DD,0xA7DE,0xA7DF,0xA7E0,0xA7E1,
	0xA7E2,0xA7E3,0xA7E4,0xA7E5,0xA7E6,0xA7E7,0xA7E8,0xA7E9,0xA7EA,0xA7EB,0xA7EC,0xA7ED,0xA7EE,0xA7EF,0xA7F0,0xA7F1,
	0x0000,0xA7D7,
};
static const WORD _ucs_to_eucj_2000_data []={ //2010 203B
	0xA1BE,0x0000,0x0000,0x0000,0x0000,0xA1BD,0x0000,0x0000,0xA1C6,0xA1C7,0x0000,0x0000,0xA1C8,0xA1C9,0x0000,0x0000,
	0xA2F7,0xA2F8,0x0000,0x0000,0x0000,0xA1C5,0xA1C4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xA2F3,0x0000,0xA1EC,0xA1ED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA2A8,
};
static const WORD _ucs_to_eucj_2100_data []={ //2103 21D4
	                     0xA1EE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADE2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xADE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA2F2,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xADB5,0xADB6,0xADB7,0xADB8,0xADB9,0xADBA,0xADBB,0xADBC,0xADBD,0xADBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xFCF1,0xFCF2,0xFCF3,0xFCF4,0xFCF5,0xFCF6,0xFCF7,0xFCF8,0xFCF9,0xFCFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xA2AB,0xA2AC,0xA2AA,0xA2AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xA2CD,0x0000,0xA2CE,
};
static const WORD _ucs_to_eucj_2200_data []={ //2200 22BF
	0xA2CF,0x0000,0xA2DF,0xA2D0,0x0000,0x0000,0x0000,0xA2E0,0xA2BA,0x0000,0x0000,0xA2BB,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xADF4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA2E5,0x0000,0x0000,0xA2E7,0xA1E7,0xADF8,
	0xA2DC,0x0000,0x0000,0x0000,0x0000,0xA1C2,0x0000,0xA2CA,0xA2CB,0xA2C1,0xA2C0,0xA2E9,0xA2EA,0x0000,0xADF3,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xA1E8,0xA2E8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA2E6,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xA2E2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xA1E2,0xA2E1,0x0000,0x0000,0x0000,0x0000,0xA1E5,0xA1E6,0x0000,0x0000,0xA2E3,0xA2E4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xA2BE,0xA2BF,0x0000,0x0000,0xA2BC,0xA2BD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xA2DD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADF9,
};
static const WORD _ucs_to_eucj_2300_data []={ //2312 2312
	              0xA2DE,
};
static const WORD _ucs_to_eucj_2400_data []={ //2460 2473
	0xADA1,0xADA2,0xADA3,0xADA4,0xADA5,0xADA6,0xADA7,0xADA8,0xADA9,0xADAA,0xADAB,0xADAC,0xADAD,0xADAE,0xADAF,0xADB0,
	0xADB1,0xADB2,0xADB3,0xADB4,
};
static const WORD _ucs_to_eucj_2500_data []={ //2500 25EF
	0xA8A1,0xA8AC,0xA8A2,0xA8AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA8A3,0x0000,0x0000,0xA8AE,
	0xA8A4,0x0000,0x0000,0xA8AF,0xA8A6,0x0000,0x0000,0xA8B1,0xA8A5,0x0000,0x0000,0xA8B0,0xA8A7,0xA8BC,0x0000,0x0000,
	0xA8B7,0x0000,0x0000,0xA8B2,0xA8A9,0xA8BE,0x0000,0x0000,0xA8B9,0x0000,0x0000,0xA8B4,0xA8A8,0x0000,0x0000,0xA8B8,
	0xA8BD,0x0000,0x0000,0xA8B3,0xA8AA,0x0000,0x0000,0xA8BA,0xA8BF,0x0000,0x0000,0xA8B5,0xA8AB,0x0000,0x0000,0xA8BB,
	0x0000,0x0000,0xA8C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA8B6,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xA2A3,0xA2A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xA2A5,0xA2A4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA2A7,0xA2A6,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA2A1,0xA1FE,0x0000,0x0000,0x0000,0xA1FB,0x0000,0x0000,0xA1FD,0xA1FC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA2FE,
};
static const WORD _ucs_to_eucj_2600_data []={ //2605 266F
	                                   0xA1FA,0xA1F9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xA1EA,0x0000,0xA1E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA2F6,0x0000,0x0000,0xA2F5,0x0000,0xA2F4,
};
static const WORD _ucs_to_eucj_3000_data []={ //3000 30FE
	0xA1A1,0xA1A2,0xA1A3,0xA1B7,0x0000,0xA1B9,0xA1BA,0xA1BB,0xA1D2,0xA1D3,0xA1D4,0xA1D5,0xA1D6,0xA1D7,0xA1D8,0xA1D9,
	0xA1DA,0xA1DB,0xA2A9,0xA2AE,0xA1CC,0xA1CD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADE0,0x0000,0xADE1,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xA4A1,0xA4A2,0xA4A3,0xA4A4,0xA4A5,0xA4A6,0xA4A7,0xA4A8,0xA4A9,0xA4AA,0xA4AB,0xA4AC,0xA4AD,0xA4AE,0xA4AF,
	0xA4B0,0xA4B1,0xA4B2,0xA4B3,0xA4B4,0xA4B5,0xA4B6,0xA4B7,0xA4B8,0xA4B9,0xA4BA,0xA4BB,0xA4BC,0xA4BD,0xA4BE,0xA4BF,
	0xA4C0,0xA4C1,0xA4C2,0xA4C3,0xA4C4,0xA4C5,0xA4C6,0xA4C7,0xA4C8,0xA4C9,0xA4CA,0xA4CB,0xA4CC,0xA4CD,0xA4CE,0xA4CF,
	0xA4D0,0xA4D1,0xA4D2,0xA4D3,0xA4D4,0xA4D5,0xA4D6,0xA4D7,0xA4D8,0xA4D9,0xA4DA,0xA4DB,0xA4DC,0xA4DD,0xA4DE,0xA4DF,
	0xA4E0,0xA4E1,0xA4E2,0xA4E3,0xA4E4,0xA4E5,0xA4E6,0xA4E7,0xA4E8,0xA4E9,0xA4EA,0xA4EB,0xA4EC,0xA4ED,0xA4EE,0xA4EF,
	0xA4F0,0xA4F1,0xA4F2,0xA4F3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xA1AB,0xA1AC,0xA1B5,0xA1B6,0x0000,
	0x0000,0xA5A1,0xA5A2,0xA5A3,0xA5A4,0xA5A5,0xA5A6,0xA5A7,0xA5A8,0xA5A9,0xA5AA,0xA5AB,0xA5AC,0xA5AD,0xA5AE,0xA5AF,
	0xA5B0,0xA5B1,0xA5B2,0xA5B3,0xA5B4,0xA5B5,0xA5B6,0xA5B7,0xA5B8,0xA5B9,0xA5BA,0xA5BB,0xA5BC,0xA5BD,0xA5BE,0xA5BF,
	0xA5C0,0xA5C1,0xA5C2,0xA5C3,0xA5C4,0xA5C5,0xA5C6,0xA5C7,0xA5C8,0xA5C9,0xA5CA,0xA5CB,0xA5CC,0xA5CD,0xA5CE,0xA5CF,
	0xA5D0,0xA5D1,0xA5D2,0xA5D3,0xA5D4,0xA5D5,0xA5D6,0xA5D7,0xA5D8,0xA5D9,0xA5DA,0xA5DB,0xA5DC,0xA5DD,0xA5DE,0xA5DF,
	0xA5E0,0xA5E1,0xA5E2,0xA5E3,0xA5E4,0xA5E5,0xA5E6,0xA5E7,0xA5E8,0xA5E9,0xA5EA,0xA5EB,0xA5EC,0xA5ED,0xA5EE,0xA5EF,
	0xA5F0,0xA5F1,0xA5F2,0xA5F3,0xA5F4,0xA5F5,0xA5F6,0x0000,0x0000,0x0000,0x0000,0xA1A6,0xA1BC,0xA1B3,0xA1B4,
};
static const WORD _ucs_to_eucj_3200_data []={ //3231 32A8
	       0xADEA,0xADEB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADEC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xADE5,0xADE6,0xADE7,0xADE8,0xADE9,
};
static const WORD _ucs_to_eucj_3300_data []={ //3303 33CD
	                     0xADC6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADCA,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xADC1,0x0000,0x0000,0x0000,0xADC4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xADC2,0xADCC,0x0000,0x0000,0xADCB,0xADC5,0x0000,0x0000,0x0000,0xADCD,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADC7,0x0000,0x0000,0x0000,0x0000,0xADCF,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADC0,0xADCE,0x0000,0x0000,0xADC3,0x0000,0x0000,
	0x0000,0xADC8,0x0000,0x0000,0x0000,0x0000,0x0000,0xADC9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADDF,0xADEF,0xADEE,0xADED,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADD3,0xADD4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADD0,0xADD1,0xADD2,0x0000,
	0x0000,0xADD6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xADD5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xADE3,
};
static const WORD _ucs_to_eucj_4E00_data []={ //4E00 4EFC
	0xB0EC,0xC3FA,0x0000,0xBCB7,0x0000,0x0000,0x0000,0xCBFC,0xBEE6,0xBBB0,0xBEE5,0xB2BC,0x0000,0xC9D4,0xCDBF,0x0000,
	0xD0A2,0xB1AF,0x0000,0x0000,0xB3EE,0xD0A3,0xC0A4,0xD2C2,0xB5D6,0xCABA,0x0000,0x0000,0x0000,0x0000,0xBEE7,0x0000,
	0x0000,0xCEBE,0x0000,0x0000,0x0000,0x0000,0xCAC2,0x0000,0xF9AD,0x0000,0xD0A4,0x0000,0x0000,0xC3E6,0x0000,0x0000,
	0x0000,0xD0A5,0xB6FA,0x0000,0x0000,0x0000,0xD0A6,0x0000,0xB4DD,0xC3B0,0x0000,0xBCE7,0xD0A7,0x0000,0x0000,0xD0A8,
	0x0000,0x0000,0xD0A9,0xC7B5,0x0000,0xB5D7,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7B7,0x0000,0xC6E3,0xB8C3,0xCBB3,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE9C9,0xD0AA,0xBEE8,0xD0AB,0xB2B5,0x0000,0x0000,0x0000,0xB6E5,0xB8F0,0xCCE9,
	0x0000,0x0000,0xD6A6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xCDF0,0x0000,0xC6FD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB4A5,0x0000,
	0xB5B5,0x0000,0xD0AC,0x0000,0x0000,0xD0AD,0xCEBB,0x0000,0xCDBD,0xC1E8,0xD0AF,0xBBF6,0xC6F3,0x0000,0xD0B2,0x0000,
	0x0000,0xB1BE,0xB8DF,0x0000,0xB8DE,0xB0E6,0x0000,0x0000,0xCFCB,0xCFCA,0x0000,0xBAB3,0xB0A1,0x0000,0xD0B3,0xD0B4,
	0xD0B5,0xCBB4,0xD0B6,0x0000,0xB8F2,0xB0E7,0xCBF2,0x0000,0xB5FC,0x0000,0x0000,0xB5FD,0xB5FE,0xC4E2,0xCEBC,0x0000,
	0xD0B7,0x0000,0x0000,0xD0B8,0x0000,0x0000,0xD0B9,0x0000,0x0000,0x0000,0xBFCD,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xBDBA,0xBFCE,0xD0BE,0x0000,0xD0BC,0x0000,0xD0BD,0xB5D8,0x0000,0x0000,0xBAA3,0xB2F0,0x0000,0xD0BB,0xD0BA,0xCAA9,
	0x0000,0x0000,0x0000,0x0000,0xBBC6,0xBBC5,0xC2BE,0xD0BF,0xC9D5,0xC0E7,0x0000,0x0000,0x0000,0xA1B8,0xD0C0,0xD0C2,
	0x0000,0xF9AE,0x0000,0xC2E5,0xCEE1,0xB0CA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD0C1,0xB2BE,0x0000,
	0xB6C4,0x0000,0xC3E7,0x0000,0x0000,0x0000,0xB7EF,0xD0C3,0x0000,0x0000,0x0000,0xC7A4,0xF9AF,
};
static const WORD _ucs_to_eucj_4F00_data []={ //4F00 4FFF
	0xF9B0,0xB4EB,0x0000,0xF9B1,0x0000,0x0000,0x0000,0x0000,0x0000,0xD0C4,0xB0CB,0x0000,0x0000,0xB8E0,0xB4EC,0xC9FA,
	0xC8B2,0xB5D9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2F1,0x0000,0xD0E7,0xC5C1,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7EC,
	0xD0C6,0x0000,0x0000,0x0000,0xC8BC,0x0000,0xCEE2,0x0000,0xBFAD,0xF9B2,0xBBC7,0x0000,0xBBF7,0xB2C0,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xC4D1,0x0000,0x0000,0xC3A2,0xD0CA,0x0000,0x0000,0x0000,0x0000,0x0000,0xB0CC,0xC4E3,0xBDBB,
	0xBAB4,0xCDA4,0x0000,0xC2CE,0x0000,0xB2BF,0xF9B3,0xD0C9,0x0000,0xCDBE,0xD0C5,0xD0C7,0xBAEE,0xD0C8,0xD5A4,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD0D0,0x0000,0x0000,0x0000,0x0000,0x0000,0xD0D3,
	0xD0D1,0x0000,0x0000,0xB2C2,0x0000,0xCABB,0xD0CB,0x0000,0x0000,0x0000,0x0000,0xD0CF,0xB8F3,0x0000,0x0000,0xBBC8,
	0x0000,0x0000,0x0000,0xB4A6,0x0000,0x0000,0xD0D4,0x0000,0xD0CC,0x0000,0xF9B5,0xCEE3,0x0000,0xBBF8,0x0000,0xD0CD,
	0x0000,0xD0D2,0xF9B4,0x0000,0xF9B7,0x0000,0xD0D5,0x0000,0xD0CE,0x0000,0xF9B6,0xB6A1,0x0000,0xB0CD,0x0000,0x0000,
	0xB6A2,0xB2C1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5A5,0x0000,0xCBF9,0xC9EE,0xB8F4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xBFAF,0xCEB7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAD8,
	0x0000,0x0000,0xB7B8,0xC2A5,0xB2E4,0x0000,0x0000,0x0000,0x0000,0xF9A6,0xBDD3,0x0000,0x0000,0xF9B8,0xD0D9,0x0000,
	0xD0DE,0xD0DC,0x0000,0x0000,0xD0D7,0x0000,0x0000,0xC2AF,0xD0DA,0x0000,0xD0DD,0xD0DB,0x0000,0xCADD,0x0000,0xD0D8,
	0x0000,0xBFAE,0x0000,0xCBF3,0xD0DF,0xD0E0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBDA4,0xD0ED,
	0x0000,0x0000,0x0000,0xC7D0,0x0000,0xC9B6,0xD0E8,0x0000,0xCAF0,0x0000,0xB2B6,0x0000,0x0000,0x0000,0xD0EC,0xF9BB,
};
static const WORD _ucs_to_eucj_5000_data []={ //5005 50FB
	                                   0xD0E6,0xD0EF,0x0000,0x0000,0xC1D2,0x0000,0xB8C4,0x0000,0xC7DC,0x0000,0xE0C7,
	0x0000,0xD0EE,0xC5DD,0x0000,0xD0E3,0x0000,0xB8F6,0x0000,0x0000,0xB8F5,0xD0E1,0x0000,0x0000,0x0000,0xF9BC,0xBCDA,
	0x0000,0xD0E9,0xF9BA,0xCAEF,0xC3CD,0xD0E5,0xB7F1,0x0000,0xD0E2,0xD0EA,0xD0E4,0xCED1,0xD0EB,0xCFC1,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB6E6,0x0000,0x0000,0xB7F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xF9B9,0x0000,0xF9BF,0xD0F0,0x0000,0x0000,0xF9BD,0xD0F1,0xD0F5,0xB0CE,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAD0,
	0xD0F4,0x0000,0x0000,0x0000,0x0000,0xD0F3,0xD0F7,0x0000,0x0000,0x0000,0xD0F6,0x0000,0xC4E4,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xB7F2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD0F8,0x0000,0x0000,0x0000,
	0xF9BE,0x0000,0xBCC5,0x0000,0xC2A6,0xC4E5,0xB6F6,0x0000,0xD0F9,0x0000,0x0000,0x0000,0x0000,0xB5B6,0x0000,0x0000,
	0xD0FA,0x0000,0x0000,0x0000,0x0000,0xD0FC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCBB5,0x0000,0x0000,
	0x0000,0xB7E6,0x0000,0x0000,0xF9C0,0x0000,0x0000,0x0000,0xBBB1,0xC8F7,0xD0FB,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBAC5,0xCDC3,0x0000,0x0000,
	0x0000,0x0000,0xD0FE,0xD1A3,0xD0FD,0xBAC4,0x0000,0xBDFD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7B9,0x0000,
	0x0000,0x0000,0xD1A4,0x0000,0x0000,0xB6CF,0x0000,0x0000,0x0000,0xD1A1,0xD1A2,0x0000,0x0000,0xC6AF,0x0000,0xC1FC,
	0x0000,0xB6A3,0x0000,0x0000,0x0000,0xCBCD,0xD1A5,0x0000,0xF9C2,0x0000,0xCEBD,0x0000,0x0000,0x0000,0xD1A6,0x0000,
	0x0000,0x0000,0x0000,0xD1A9,0x0000,0xD1A7,0x0000,0xC1CE,0x0000,0x0000,0x0000,0x0000,0x0000,0xD1A8,0xD1AA,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xF9C1,0xD1AC,0x0000,0x0000,0x0000,0xD1AB,0x0000,0xCAC8,
};
static const WORD _ucs_to_eucj_5100_data []={ //5100 51FE
	0xB5B7,0xD1AE,0xD1AF,0x0000,0xB2AF,0x0000,0x0000,0x0000,0x0000,0xD1AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xBCF4,0x0000,0xD1B2,0xD1B1,0xD1B0,0x0000,0xD0D6,0x0000,0xD1B3,0x0000,0x0000,0x0000,0x0000,0xBDFE,
	0x0000,0xD1B4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDA5,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCCD9,0x0000,0x0000,0x0000,0x0000,0xD1B6,0x0000,0x0000,0xD1B5,0xD1B8,0xD1B7,0x0000,0x0000,0xD1B9,
	0xD1BA,0xB0F4,0x0000,0xB8B5,0xB7BB,0xBDBC,0xC3FB,0xB6A4,0xC0E8,0xB8F7,0xF9C3,0xB9EE,0xD1BC,0xCCC8,0xC5C6,0x0000,
	0xBBF9,0x0000,0xD1BB,0x0000,0xD1BD,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5DE,0x0000,0xB3F5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xD1BE,0x0000,0xF9C4,0xC6FE,0x0000,0x0000,0xC1B4,0xD1C0,0xD1C1,0xC8AC,0xB8F8,0xCFBB,0xD1C2,0x0000,
	0x0000,0xB6A6,0x0000,0x0000,0x0000,0xCABC,0xC2B6,0xB6F1,0xC5B5,0x0000,0x0000,0x0000,0xB7F3,0x0000,0x0000,0x0000,
	0xD1C3,0x0000,0xD1C4,0x0000,0x0000,0xC6E2,0xB1DF,0x0000,0x0000,0xD1C7,0xBAFD,0x0000,0xD1C6,0xBAC6,0x0000,0xD1C8,
	0xE6EE,0xD1C9,0xCBC1,0xD1CA,0x0000,0xD1CB,0xD1CC,0xBEE9,0x0000,0xBCCC,0x0000,0x0000,0x0000,0xF9C5,0x0000,0x0000,
	0xB4A7,0x0000,0xD1CF,0x0000,0xD1CD,0xCCBD,0xD1CE,0x0000,0xC9DA,0xD1D0,0xD1D1,0xD1D2,0xC5DF,0x0000,0x0000,0x0000,
	0xD1D6,0xD1D4,0xD1D5,0xD1D3,0xBAE3,0xD1D7,0xCCEA,0xCEE4,0x0000,0x0000,0x0000,0x0000,0x0000,0xD1D8,0xF9C6,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xC0A8,0xD1D9,0xBDDA,0x0000,0x0000,0xD1DA,0x0000,0xC3FC,0xCEBF,0xC5E0,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD2C5,0x0000,0x0000,0x0000,0x0000,0xD1DB,0xF4A5,0xB6C5,0x0000,0x0000,
	0xD1DC,0xCBDE,0x0000,0x0000,0x0000,0x0000,0xBDE8,0xC2FC,0x0000,0xD1DE,0xC6E4,0x0000,0xF9C7,0xD1DF,0x0000,0x0000,
	0xD1E0,0xB3AE,0x0000,0x0000,0x0000,0xD1E1,0xB6A7,0x0000,0xC6CC,0xB1FA,0xBDD0,0x0000,0x0000,0xC8A1,0xD1E2,
};
static const WORD _ucs_to_eucj_5200_data []={ //5200 52FF
	0xC5E1,0x0000,0x0000,0xBFCF,0xD1E3,0x0000,0xCAAC,0xC0DA,0xB4A2,0x0000,0xB4A9,0xD1E4,0x0000,0x0000,0xD1E6,0x0000,
	0x0000,0xB7BA,0x0000,0x0000,0xD1E5,0xF9C8,0x0000,0xCEF3,0x0000,0x0000,0x0000,0x0000,0x0000,0xBDE9,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xC8BD,0xCACC,0x0000,0xD1E7,0x0000,0xCDF8,0xD1E8,0x0000,0x0000,0x0000,0xD1E9,0x0000,
	0xC5FE,0x0000,0x0000,0xD1EA,0x0000,0x0000,0xC0A9,0xBAFE,0xB7F4,0xD1EB,0xBBC9,0xB9EF,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xC4E6,0xD1ED,0x0000,0x0000,0xC2A7,0x0000,0x0000,0xBAEF,0xD1EE,0xD1EF,0xC1B0,0x0000,0xD1EC,
	0x0000,0x0000,0x0000,0x0000,0xD1F1,0x0000,0xCBB6,0x0000,0x0000,0x0000,0x0000,0xB9E4,0x0000,0x0000,0xD1F0,0x0000,
	0x0000,0x0000,0x0000,0xB7F5,0xBADE,0xC7ED,0x0000,0x0000,0x0000,0xD1F4,0xD1F2,0x0000,0x0000,0x0000,0x0000,0xC9FB,
	0xBEEA,0xD1FB,0xB3E4,0xD1F5,0xD1F3,0xC1CF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD1F7,0x0000,0xD1F6,
	0x0000,0x0000,0x0000,0xB3C4,0x0000,0x0000,0x0000,0xB7E0,0xD1FC,0xCEAD,0x0000,0x0000,0x0000,0xD1F8,0x0000,0x0000,
	0x0000,0xD1FD,0xD1FA,0x0000,0xD1F9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCECF,0xF9C9,0x0000,0x0000,0xB8F9,
	0xB2C3,0x0000,0x0000,0xCEF4,0x0000,0x0000,0xF9CA,0x0000,0x0000,0xBDF5,0xC5D8,0xB9E5,0xD2A2,0xD2A3,0x0000,0xFBBC,
	0x0000,0xCEE5,0x0000,0x0000,0xCFAB,0xD2A5,0x0000,0x0000,0x0000,0xB8FA,0x0000,0x0000,0xD2A4,0x0000,0xB3AF,0x0000,
	0xF9CB,0xD2A6,0x0000,0xCBD6,0x0000,0xC4BC,0x0000,0xCDA6,0x0000,0xCAD9,0x0000,0x0000,0x0000,0xD2A7,0x0000,0x0000,
	0x0000,0x0000,0xF0D5,0x0000,0x0000,0xC6B0,0x0000,0xD2A8,0xB4AA,0xCCB3,0x0000,0xF9CC,0x0000,0xBEA1,0xD2A9,0xCAE7,
	0xD2AD,0x0000,0xC0AA,0xD2AA,0xB6D0,0x0000,0xD2AB,0xB4AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xB7AE,0xD2AE,0x0000,0xD2AF,0x0000,0x0000,0xD2B0,0xD2B1,0xBCDB,0x0000,0x0000,0x0000,0xB8FB,0xCCDE,
};
static const WORD _ucs_to_eucj_5300_data []={ //5300 53FA
	0xF9CD,0xCCE8,0xC6F7,0x0000,0x0000,0xCAF1,0xD2B2,0xF9CE,0xD2B3,0x0000,0x0000,0x0000,0x0000,0xD2B5,0x0000,0xD2B7,
	0xD2B6,0x0000,0x0000,0x0000,0x0000,0xD2B8,0xB2BD,0xCBCC,0x0000,0xBAFC,0xD2B9,0x0000,0x0000,0xC1D9,0x0000,0x0000,
	0xBEA2,0xB6A9,0x0000,0xD2BA,0xF9CF,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8DB,0x0000,0x0000,0x0000,0x0000,0xD2BB,
	0x0000,0xD2BC,0x0000,0xD2BD,0x0000,0x0000,0x0000,0x0000,0xD2BE,0xC9A4,0xB6E8,0xB0E5,0x0000,0x0000,0x0000,0xC6BF,
	0xD2BF,0xBDBD,0x0000,0xC0E9,0x0000,0xD2C1,0xD2C0,0xBEA3,0xB8E1,0xD2C3,0xC8BE,0x0000,0x0000,0xD2C4,0x0000,0x0000,
	0x0000,0xC8DC,0xC2B4,0xC2EE,0xB6A8,0x0000,0x0000,0xC6EE,0xC3B1,0x0000,0xC7EE,0x0000,0xCBCE,0x0000,0xD2C6,0x0000,
	0xC0EA,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7B5,0x0000,0x0000,0xD2C7,0x0000,0x0000,0x0000,0x0000,0xD2C8,0xB1AC,
	0xB0F5,0xB4ED,0xF9D0,0xC2A8,0xB5D1,0xCDF1,0x0000,0xD2CB,0xB2B7,0x0000,0x0000,0xD2CA,0x0000,0x0000,0x0000,0xB6AA,
	0x0000,0x0000,0xD2CC,0x0000,0xCCF1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xF9D1,0x0000,0x0000,0xD2CD,0x0000,0xCED2,0x0000,0xB8FC,0x0000,0x0000,0x0000,0x0000,0xB8B6,
	0xD2CE,0x0000,0x0000,0x0000,0x0000,0xD2D0,0xD2CF,0x0000,0xBFDF,0xB1B9,0x0000,0x0000,0x0000,0xB1DE,0xD2D1,0x0000,
	0xD2D2,0x0000,0xF9D2,0xB8B7,0x0000,0x0000,0xD2D3,0x0000,0x0000,0x0000,0x0000,0xB5EE,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xBBB2,0xD2D4,0x0000,0x0000,0x0000,0x0000,0xCBF4,0xBAB5,0xB5DA,0xCDA7,0xC1D0,0xC8BF,0xBCFD,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xBDC7,0x0000,0xBCE8,0xBCF5,0x0000,0xBDF6,0x0000,0xC8C0,0x0000,0xF9D3,0x0000,0xD2D7,
	0x0000,0xB1C3,0xC1D1,0xB8FD,0xB8C5,0xB6E7,0x0000,0x0000,0xD2DB,0xC3A1,0xC2FE,0xB6AB,0xBEA4,0xD2DC,0xD2DA,0xB2C4,
	0xC2E6,0xBCB8,0xBBCB,0xB1A6,0x0000,0x0000,0xB3F0,0xB9E6,0xBBCA,0x0000,0xD2DD,
};
static const WORD _ucs_to_eucj_5400_data []={ //5401 54FF
	       0xD2DE,0x0000,0xB5C9,0xB3C6,0x0000,0x0000,0x0000,0xB9E7,0xB5C8,0xC4DF,0xB1A5,0xC6B1,0xCCBE,0xB9A1,0xCDF9,
	0xC5C7,0xB8FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7AF,0x0000,0xD2E7,0x0000,0xB6E3,
	0xCBCA,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8DD,0x0000,0x0000,0xD2E6,0x0000,0xB4DE,0xD2E1,0xD2E2,0xD2E4,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD2E5,0x0000,0xB5DB,0xBFE1,0x0000,0xCAAD,0xD2E3,0xD2DF,0xB8E3,0x0000,
	0xD2E0,0x0000,0xCFA4,0x0000,0x0000,0x0000,0xCAF2,0x0000,0xC4E8,0xB8E2,0xB9F0,0x0000,0x0000,0x0000,0xD2E8,0x0000,
	0x0000,0xC6DD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD2EC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBCFE,0x0000,0xBCF6,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xD2EF,0xD2ED,0x0000,0xCCA3,0x0000,0xD2EA,0xD2F3,0xD2EE,0x0000,0x0000,0x0000,0xD2F1,0xB8C6,0xCCBF,0x0000,0x0000,
	0xD2F2,0x0000,0x0000,0x0000,0xD2F4,0x0000,0xD2F6,0x0000,0x0000,0x0000,0xF9D6,0xBAF0,0xCFC2,0x0000,0xD2EB,0xD2E9,
	0xD2F5,0x0000,0xD2F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF9D5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xD2F8,0x0000,0xD3A3,0xD2FA,0x0000,0x0000,0xD2FE,0xF9D7,0x0000,0xD3A1,0xD2FB,0x0000,0x0000,0xD3BE,
	0x0000,0x0000,0xBAE9,0xB3B1,0x0000,0x0000,0x0000,0x0000,0xD2F9,0x0000,0x0000,0x0000,0xD3A5,0xB0F6,0xD3A4,0x0000,
	0xB0A5,0xC9CA,0xD3A2,0x0000,0xD2FC,0x0000,0x0000,0xD2F7,0xD2FD,0xBAC8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3A6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB0F7,0xD3AF,0x0000,0x0000,0xD3A7,0xD3A8,0x0000,0xBEA5,0xCBE9,0x0000,0x0000,0x0000,0xD3AD,0xD3AC,0x0000,
	0x0000,0x0000,0xC5AF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3AE,0x0000,0x0000,0xD3AB,0x0000,0xF9D8,
};
static const WORD _ucs_to_eucj_5500_data []={ //5504 55FE
	                            0xB1B4,0x0000,0xBAB6,0xBFB0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3A9,
	0xC5E2,0x0000,0x0000,0x0000,0xD3AA,0x0000,0xB0A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3B4,0xCDA3,
	0x0000,0xBEA7,0x0000,0xD3BA,0x0000,0x0000,0x0000,0x0000,0xD3B9,0xD3B0,0x0000,0x0000,0x0000,0x0000,0xC2C3,0x0000,
	0xD3B1,0x0000,0x0000,0x0000,0xC2EF,0xD3B6,0xBEA6,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3B3,0x0000,0x0000,0xCCE4,
	0x0000,0x0000,0x0000,0xB7BC,0x0000,0x0000,0xD3B7,0xD3B8,0x0000,0x0000,0x0000,0x0000,0xD3B5,0xD3BB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xD3B2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3C1,0xD3C6,0x0000,0xD3C2,0x0000,
	0xD3BD,0x0000,0x0000,0xD3C7,0xC1B1,0x0000,0xF9D9,0xD3C9,0x0000,0xB9A2,0xD3BF,0xC3FD,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3C3,0xD3BC,0xB4AD,0x0000,0xB4EE,0xB3E5,0xD3C4,0xD3C0,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7F6,0xD3CA,0xD3C8,0xC1D3,0xB5CA,0xB6AC,0x0000,0xD3C5,0x0000,
	0xB6F4,0x0000,0x0000,0x0000,0x0000,0x0000,0xB1C4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xD3CE,0xD3CC,0x0000,0xD4A7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xD3D1,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3CB,0x0000,0xD3CF,0x0000,0x0000,0xD3CD,
	0x0000,0x0000,0x0000,0xBBCC,0xD3D0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3D3,0x0000,0xD3D8,0x0000,0x0000,0x0000,0xD3D6,0xD3D5,
};
static const WORD _ucs_to_eucj_5600_data []={ //5606 56FF
	                                          0xC3B2,0x0000,0x0000,0xB2C5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xD3D2,0x0000,0xD3D4,0xBEA8,0xB1B3,0x0000,0x0000,0xD3D7,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2DE,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3E2,
	0x0000,0xBEFC,0xD3DE,0x0000,0xD3DC,0x0000,0xD3DD,0x0000,0xD3DF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xB1BD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1B9,0x0000,0xD3D9,0x0000,
	0xD3DA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB3FA,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xD3E1,0x0000,0x0000,0x0000,0xB4EF,0x0000,0xD3E4,0xD3E0,0xD3E3,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xCAAE,0x0000,0x0000,0x0000,0xC6D5,0x0000,0xC8B8,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xD3E6,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3E5,0xB3C5,0x0000,0x0000,0xD3E7,0x0000,0x0000,0x0000,0x0000,0xD3EA,
	0x0000,0x0000,0x0000,0x0000,0xD3E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xD3E8,0x0000,0xC7B9,0x0000,0x0000,0xD3EB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3EC,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xD3EE,0x0000,0xD3ED,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3F0,0x0000,0x0000,0x0000,
	0xD3F3,0xD3F1,0xD3EF,0xD3F2,0x0000,0x0000,0x0000,0x0000,0xD3F4,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3F5,0x0000,
	0x0000,0xD3F6,0x0000,0xD3F7,0x0000,0x0000,0x0000,0xD3F8,0xD1C5,0x0000,0xBCFC,0xBBCD,0x0000,0x0000,0xB2F3,0x0000,
	0xB0F8,0x0000,0x0000,0xC3C4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3F9,0x0000,
	0xBAA4,0x0000,0xB0CF,0xBFDE,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3FA,0xB8C7,0x0000,0x0000,0xB9F1,0x0000,0xD3FC,
};
static const WORD _ucs_to_eucj_5700_data []={ //5700 57FC
	0xD3FB,0x0000,0x0000,0xCAE0,0xD3FD,0x0000,0x0000,0x0000,0xD4A1,0xD3FE,0x0000,0xD4A2,0x0000,0xD4A3,0x0000,0xB7F7,
	0x0000,0x0000,0xB1E0,0xD4A4,0x0000,0x0000,0xD4A6,0x0000,0xD4A5,0x0000,0x0000,0x0000,0xD4A8,0x0000,0x0000,0xC5DA,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD4A9,0xB0B5,0xBADF,0x0000,0x0000,0x0000,0x0000,0xB7BD,0x0000,0x0000,
	0xC3CF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD4AA,0xD4AB,0x0000,0x0000,0xD4AD,0x0000,0x0000,0x0000,0x0000,
	0xD4AE,0x0000,0xBAE4,0x0000,0x0000,0x0000,0x0000,0xB6D1,0x0000,0x0000,0xCBB7,0x0000,0x0000,0x0000,0xD4AC,0xD4AF,
	0xBAC1,0xB9A3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF9DA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xD4B3,0x0000,0x0000,0xBAA5,0xF9DB,0xC3B3,0x0000,0x0000,0xD4B0,0xC4DA,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD4B4,
	0x0000,0x0000,0xBFE2,0x0000,0x0000,0x0000,0x0000,0x0000,0xD4B2,0xD4B5,0x0000,0xB7BF,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xD4B6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xD4B7,0x0000,0xB9A4,0xB3C0,0xD4B9,0x0000,0x0000,0x0000,0x0000,0x0000,0xD4BA,0x0000,0xF9DC,0x0000,0x0000,0x0000,
	0xD4BB,0x0000,0x0000,0xD4B8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xD4B1,0x0000,0x0000,0xD4BC,0x0000,0x0000,0xD4BD,0xF9DE,0xF9DD,0x0000,0x0000,0xCBE4,0x0000,0x0000,0xBEEB,0x0000,
	0x0000,0x0000,0xD4BF,0xD4C0,0xD4BE,0x0000,0xD4C2,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7B8,0x0000,0x0000,0xB0E8,
	0xC9D6,0x0000,0x0000,0xD4C3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xBEFD,0x0000,0x0000,0xBCB9,0x0000,0xC7DD,0xB4F0,0x0000,0xBAEB,
};
static const WORD _ucs_to_eucj_5800_data []={ //5800 58FD
	0xCBD9,0x0000,0xC6B2,0x0000,0x0000,0xB7F8,0xC2CF,0x0000,0x0000,0x0000,0xD4C1,0xD4C4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xC2C4,0x0000,0x0000,0x0000,0xD4C5,0x0000,0x0000,0x0000,0xD4C6,0x0000,0x0000,
	0x0000,0xD4C8,0x0000,0x0000,0xC4E9,0x0000,0x0000,0x0000,0x0000,0x0000,0xB4AE,0x0000,0x0000,0x0000,0x0000,0xF4A1,
	0xB1E1,0xCAF3,0x0000,0x0000,0xBEEC,0xC5C8,0x0000,0x0000,0x0000,0x0000,0xBAE6,0x0000,0x0000,0xD4CE,0x0000,0x0000,
	0xCABD,0xCEDD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2F4,0xD4CA,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xC1BA,0xD4CD,0x0000,0xC5E3,0x0000,0x0000,0xC5C9,0xC5E4,0xC8B9,0xC4CD,0x0000,0x0000,0x0000,0xBAC9,0x0000,
	0x0000,0x0000,0xD4C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB1F6,0x0000,0xC5B6,0x0000,0x0000,0x0000,0x0000,
	0xD4CB,0x0000,0xD4C7,0x0000,0x0000,0xBFD0,0x0000,0x0000,0x0000,0xD4CF,0x0000,0x0000,0x0000,0x0000,0xBDCE,0x0000,
	0x0000,0x0000,0x0000,0xB6AD,0x0000,0xD4D0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xCAE8,0x0000,0x0000,0x0000,0xC1FD,0x0000,0x0000,0x0000,0x0000,0xC4C6,0x0000,0xF9E1,0xD4D2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCBCF,0x0000,0x0000,0xD4D3,0x0000,0x0000,0xD4D8,0x0000,
	0x0000,0x0000,0xF9E2,0xCAAF,0x0000,0x0000,0x0000,0x0000,0xD4D7,0xD4D1,0xD4D4,0xD4D6,0x0000,0x0000,0xBAA6,0x0000,
	0x0000,0xCAC9,0x0000,0x0000,0x0000,0xD4D9,0x0000,0xC3C5,0x0000,0x0000,0xB2F5,0x0000,0xBEED,0x0000,0x0000,0x0000,
	0x0000,0xD4DB,0x0000,0xD4DA,0x0000,0xB9E8,0x0000,0xD4DC,0xD4DE,0xD4DD,0x0000,0x0000,0xD4E0,0x0000,0xD4D5,0xD4E2,
	0x0000,0x0000,0x0000,0x0000,0xD4E1,0xD4DF,0x0000,0x0000,0x0000,0x0000,0x0000,0xBBCE,0xBFD1,0x0000,0xC1D4,0xD4E3,
	0xC0BC,0xB0ED,0xC7E4,0x0000,0x0000,0x0000,0x0000,0xC4DB,0x0000,0xD4E5,0xD4E4,0xD4E6,0xD4E7,0xD4E8,
};
static const WORD _ucs_to_eucj_5900_data []={ //5902 59FF
	              0xD4E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAD1,0xD4EA,0xF9E3,0x0000,0x0000,0x0000,0xB2C6,
	0xD4EB,0x0000,0x0000,0x0000,0x0000,0xCDBC,0xB3B0,0x0000,0xD2C9,0xBDC8,0xC2BF,0xD4EC,0xCCEB,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCCB4,0x0000,0x0000,0xD4EE,0x0000,0xC2E7,0x0000,0xC5B7,0xC2C0,0xC9D7,0xD4EF,0xD4F0,0xB1FB,0x0000,
	0x0000,0xBCBA,0xD4F1,0x0000,0x0000,0x0000,0x0000,0xB0D0,0xD4F2,0x0000,0x0000,0x0000,0x0000,0x0000,0xD4F3,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xB1E2,0x0000,0x0000,0xB4F1,0xC6E0,0xCAF4,0x0000,0x0000,0x0000,0x0000,0xD4F7,0xC1D5,
	0xD4F6,0xB7C0,0x0000,0xF9E4,0xCBDB,0xD4F5,0x0000,0xC5E5,0xD4F9,0x0000,0xD4F8,0xF9E5,0x0000,0xF9E6,0x0000,0x0000,
	0xD4FB,0x0000,0xD4FA,0xF9E7,0x0000,0xB1FC,0x0000,0xD4FC,0xBEA9,0xD4FE,0xC3A5,0x0000,0xD4FD,0x0000,0xCAB3,0x0000,
	0x0000,0x0000,0x0000,0xBDF7,0xC5DB,0x0000,0x0000,0x0000,0xD5A1,0x0000,0x0000,0x0000,0x0000,0xB9A5,0x0000,0x0000,
	0x0000,0xD5A2,0xC7A1,0xC8DE,0xCCD1,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7A5,0x0000,0x0000,0xD5AB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xB5B8,0x0000,0x0000,0xCDC5,0x0000,0x0000,0xCCAF,0x0000,0xD6AC,0x0000,0xD5A3,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xD5A6,0xF9E8,0xC2C5,0x0000,0x0000,0xCBB8,0x0000,0x0000,0x0000,0xC5CA,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xD5A7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCBE5,0xF9E9,0xBACA,0x0000,0x0000,0xBEAA,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5A8,0x0000,0x0000,0xBBD0,0x0000,0xBBCF,0x0000,0x0000,0x0000,0x0000,
	0xB0B9,0xB8C8,0x0000,0xC0AB,0xB0D1,0x0000,0x0000,0x0000,0x0000,0xD5AC,0xD5AD,0x0000,0xD5AA,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xB1B8,0xB4AF,0x0000,0xD5A9,0x0000,0xCCC5,0xC9B1,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB0A8,0x0000,0x0000,0x0000,0x0000,0xB0F9,0x0000,0x0000,0x0000,0xBBD1,
};
static const WORD _ucs_to_eucj_5A00_data []={ //5A01 5AFB
	       0xB0D2,0x0000,0xB0A3,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5B2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xD5B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCCBC,0x0000,0xD5B3,0x0000,0xD5B1,0x0000,0x0000,0xD5AF,
	0xBFB1,0x0000,0x0000,0x0000,0x0000,0xD5AE,0x0000,0x0000,0x0000,0xCADA,0x0000,0x0000,0x0000,0x0000,0x0000,0xB8E4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xD5B7,0xD5B8,0x0000,0x0000,0x0000,0x0000,0x0000,0xBEAB,0x0000,0x0000,0x0000,
	0xD5B4,0xCFAC,0x0000,0x0000,0x0000,0x0000,0xC7CC,0x0000,0x0000,0xD5B6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBAA7,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xD5B9,0x0000,0x0000,0x0000,0xC9D8,0x0000,0x0000,0x0000,0xD5BA,0x0000,0xD5B5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCCBB,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC7DE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5BB,0xC9B2,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5BC,0xD5C0,0xD5BD,0x0000,
	0x0000,0xB2C7,0xD5BF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBCBB,0x0000,0xD5BE,0xB7F9,0x0000,0x0000,0x0000,
	0xD5CC,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5C5,0xD5C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xC3E4,0x0000,0xD5C1,0x0000,0x0000,0xD5C3,0x0000,0x0000,0xD5C4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5C6,0xD5C7,
};
static const WORD _ucs_to_eucj_5B00_data []={ //5B09 5BFF
	                                                               0xB4F2,0x0000,0xD5C9,0xD5C8,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5CA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xBEEE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5CD,0x0000,0xC4DC,0x0000,0x0000,0x0000,
	0xB1C5,0x0000,0xD5CB,0x0000,0x0000,0x0000,0xD5CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5CF,0x0000,
	0xD5D2,0x0000,0x0000,0xD5D0,0x0000,0xD5D1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xBBD2,0xD5D3,0x0000,0x0000,0xB9A6,0xD5D4,0xF9EA,0xBBFA,0xC2B8,0x0000,0xD5D5,0xD5D6,0xBBDA,0xB9A7,0x0000,0xCCD2,
	0x0000,0x0000,0x0000,0xB5A8,0xB8C9,0xD5D7,0xB3D8,0x0000,0x0000,0xD5D8,0x0000,0xC2B9,0x0000,0x0000,0x0000,0x0000,
	0xD5D9,0xD6A3,0x0000,0xD5DA,0x0000,0xD5DB,0x0000,0x0000,0xD5DC,0x0000,0xD5DE,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xD5DF,0x0000,0x0000,0xD5E0,0x0000,0xC2F0,0x0000,0xB1A7,0xBCE9,0xB0C2,0x0000,0xC1D7,0xB4B0,0xBCB5,0x0000,0xB9A8,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xC5E6,0x0000,0xBDA1,0xB4B1,0xC3E8,0xC4EA,0xB0B8,0xB5B9,0xCAF5,0x0000,0xBCC2,
	0x0000,0x0000,0xB5D2,0xC0EB,0xBCBC,0xCDA8,0xD5E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5DC,0x0000,
	0xBACB,0x0000,0x0000,0xB3B2,0xB1E3,0xBEAC,0xB2C8,0x0000,0xD5E2,0xCDC6,0x0000,0x0000,0x0000,0x0000,0x0000,0xBDC9,
	0xF9EB,0x0000,0xBCE4,0xD5E3,0xB4F3,0xC6D2,0xCCA9,0xD5E4,0x0000,0xD5E5,0x0000,0x0000,0xC9D9,0x0000,0x0000,0x0000,
	0xD5E7,0x0000,0xB4A8,0xB6F7,0xD5E6,0x0000,0x0000,0x0000,0xF9ED,0x0000,0x0000,0xB4B2,0x0000,0xBFB2,0xD5EB,0xBBA1,
	0x0000,0xB2C9,0xD5EA,0x0000,0xD5E8,0xD5EC,0xD5E9,0xC7AB,0xDCCD,0xBFB3,0x0000,0xD5ED,0xF9EE,0x0000,0xCEC0,0x0000,
	0xD5EE,0x0000,0x0000,0xD5F0,0x0000,0xC3FE,0xD5EF,0x0000,0xC0A3,0x0000,0xBBFB,0x0000,0x0000,0x0000,0xC2D0,0xBCF7,
};
static const WORD _ucs_to_eucj_5C00_data []={ //5C01 5CFD
	       0xC9F5,0xC0EC,0x0000,0xBCCD,0xD5F1,0xBEAD,0xD5F2,0xD5F3,0xB0D3,0xC2BA,0xBFD2,0x0000,0xD5F4,0xC6B3,0xBEAE,
	0x0000,0xBEAF,0x0000,0xD5F5,0x0000,0x0000,0xC0ED,0x0000,0x0000,0x0000,0xBEB0,0x0000,0x0000,0x0000,0xF9EF,0x0000,
	0xD5F6,0x0000,0xD5F7,0x0000,0xCCE0,0x0000,0x0000,0x0000,0xD5F8,0x0000,0x0000,0x0000,0x0000,0xB6C6,0x0000,0x0000,
	0x0000,0xBDA2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD5F9,0xD5FA,0xBCDC,0xBFAC,0xC6F4,0xBFD4,0xC8F8,0xC7A2,
	0xB6C9,0xD5FB,0x0000,0x0000,0x0000,0xB5EF,0xD5FC,0x0000,0xB6FE,0x0000,0xC6CF,0xB2B0,0x0000,0xBBD3,0xD5FD,0xD6A2,
	0xD6A1,0xB6FD,0x0000,0xD5FE,0x0000,0xC5B8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC2B0,0x0000,
	0xC5CB,0xBCC8,0x0000,0x0000,0xC1D8,0xCDFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6A4,0x0000,0xD6A5,0xC6D6,
	0x0000,0xBBB3,0x0000,0x0000,0x0000,0x0000,0xD6A7,0x0000,0x0000,0xD6A8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6A9,0x0000,0x0000,0x0000,
	0xB4F4,0xD6AA,0x0000,0x0000,0xD6AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB2AC,0x0000,0x0000,0x0000,0x0000,0xF9F0,0x0000,0xC1BB,0xB4E4,0x0000,0xD6AD,0xCCA8,0x0000,0x0000,0x0000,
	0x0000,0xC2D2,0x0000,0xB3D9,0x0000,0x0000,0xD6AF,0xD6B1,0xB4DF,0x0000,0xF9F1,0xD6AE,0xD6B0,0x0000,0xD6B3,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xD6B2,0x0000,0xD6B4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6B5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xC6BD,0xB6AE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2E5,0xD6B6,0xD6BB,0x0000,0x0000,0xD6B9,0x0000,0xCAF7,
	0xCAF6,0x0000,0x0000,0x0000,0x0000,0xF9F2,0xC5E7,0x0000,0x0000,0x0000,0xD6B8,0xBDD4,0x0000,0xD6B7,
};
static const WORD _ucs_to_eucj_5D00_data []={ //5D07 5DFE
	                                                 0xBFF2,0x0000,0x0000,0x0000,0xD6BC,0x0000,0x0000,0xBAEA,0x0000,
	0x0000,0xD6C2,0x0000,0x0000,0xD6C3,0xD6BD,0xB3B3,0xD6BE,0xD6C7,0xD6C6,0xD6C5,0xD6C1,0x0000,0x0000,0x0000,0xD6C0,
	0x0000,0x0000,0xD6C4,0x0000,0x0000,0x0000,0x0000,0xF9F3,0x0000,0xCAF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xF9F6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6CB,0xD6C8,0x0000,0xD6CA,0x0000,
	0xCDF2,0x0000,0xD6C9,0xF9F4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6BF,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBFF3,0x0000,0x0000,0xD6CC,0xF9F7,0x0000,0xBAB7,
	0x0000,0x0000,0x0000,0xD6CD,0x0000,0x0000,0xD6CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xD6D1,0x0000,0xD6D0,0x0000,0x0000,0xD6CF,0x0000,0x0000,0x0000,0xC5E8,0xD6BA,0x0000,0x0000,0x0000,
	0xD6D7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6D3,0x0000,0x0000,
	0x0000,0x0000,0xD6D2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6D4,0x0000,0xD6D5,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6D8,0xF9F8,0xF9F9,0xCEE6,0x0000,0xD6D9,0xD6D6,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6DA,0x0000,0x0000,0xB4E0,0xD6DB,0x0000,0x0000,
	0xF9FA,0x0000,0xD6DD,0xD6DC,0x0000,0x0000,0xD6DE,0x0000,0x0000,0x0000,0x0000,0xD6DF,0x0000,0xC0EE,0xBDA3,0x0000,
	0x0000,0xBDE4,0x0000,0xC1E3,0x0000,0xB9A9,0xBAB8,0xB9AA,0xB5F0,0x0000,0x0000,0xD6E0,0x0000,0x0000,0xBAB9,0x0000,
	0x0000,0xB8CA,0xD6E1,0xCCA6,0xC7C3,0xD6E2,0x0000,0xB9AB,0x0000,0x0000,0x0000,0xB4AC,0x0000,0xC3A7,0xB6D2,
};
static const WORD _ucs_to_eucj_5E00_data []={ //5E02 5EFF
	              0xBBD4,0xC9DB,0x0000,0x0000,0xC8C1,0x0000,0x0000,0x0000,0x0000,0xD6E3,0xB4F5,0x0000,0x0000,0x0000,
	0x0000,0xD6E6,0x0000,0x0000,0x0000,0x0000,0xC4A1,0x0000,0x0000,0xD6E5,0xD6E4,0xD6E7,0x0000,0xC4EB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xBFE3,0x0000,0x0000,0x0000,0x0000,0x0000,0xBBD5,0x0000,0xC0CA,0x0000,0xC2D3,
	0xB5A2,0x0000,0x0000,0xC4A2,0x0000,0x0000,0xD6E8,0xD6E9,0xBEEF,0x0000,0x0000,0x0000,0x0000,0xCBB9,0x0000,0x0000,
	0xD6EC,0x0000,0x0000,0xD6EB,0xD6EA,0xC9FD,0x0000,0xD6F3,0x0000,0x0000,0x0000,0x0000,0xCBDA,0x0000,0xD6ED,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xD6EF,0xCBEB,0x0000,0xD6EE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD6F0,
	0x0000,0xC8A8,0xD6F1,0xCABE,0xD6F2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xB4B3,0xCABF,0xC7AF,0xD6F4,0xD6F5,0x0000,0xB9AC,0xB4B4,0xD6F6,0xB8B8,0xCDC4,0xCDA9,0xB4F6,0xD6F8,
	0x0000,0xC4A3,0x0000,0xB9AD,0xBEB1,0x0000,0x0000,0xC8DF,0x0000,0x0000,0xBEB2,0x0000,0x0000,0x0000,0x0000,0xBDF8,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xC4EC,0xCAF9,0xC5B9,0x0000,0x0000,0xB9AE,0x0000,0xC9DC,0x0000,0x0000,0x0000,
	0xD6F9,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5D9,0xBAC2,0x0000,0x0000,0x0000,0xB8CB,0x0000,0xC4ED,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xB0C3,0xBDEE,0xB9AF,0xCDC7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xD6FA,0xD6FB,0xC7D1,0x0000,0x0000,0x0000,0x0000,0xD6FC,0xCEF7,0xCFAD,0x0000,0x0000,0x0000,0x0000,0xD6FE,
	0xD6FD,0x0000,0x0000,0xB3C7,0x0000,0x0000,0xD7A1,0x0000,0x0000,0x0000,0xD7A4,0xD7A5,0x0000,0xD7A3,0x0000,0xC9C0,
	0xBEB3,0xD7A7,0xD7A6,0xD7A2,0x0000,0x0000,0x0000,0x0000,0xD7A8,0xD7A9,0x0000,0x0000,0xD7AA,0x0000,0x0000,0x0000,
	0xD7AD,0xD7AB,0x0000,0xD7AC,0xD7AE,0x0000,0xB1E4,0xC4EE,0xD7AF,0x0000,0xB7FA,0xB2F6,0xC7B6,0x0000,0xD7B0,0xC6FB,
};
static const WORD _ucs_to_eucj_5F00_data []={ //5F01 5FFF
	       0xCADB,0x0000,0xD7B1,0xCFAE,0x0000,0x0000,0x0000,0x0000,0xD7B2,0xCAC0,0xD7B5,0xD0A1,0xD0B1,0x0000,0xBCB0,
	0xC6F5,0xD7B6,0x0000,0xB5DD,0xC4A4,0xB0FA,0xD7B7,0xCAA6,0xB9B0,0x0000,0x0000,0xC3D0,0x0000,0x0000,0x0000,0xC4EF,
	0x0000,0xF9FB,0x0000,0x0000,0x0000,0xCCEF,0xB8B9,0xB8CC,0x0000,0xD7B8,0x0000,0x0000,0x0000,0xD7B9,0x0000,0xD7BF,
	0x0000,0xBCE5,0x0000,0x0000,0xF9FC,0xC4A5,0x0000,0xB6AF,0xD7BA,0x0000,0x0000,0x0000,0xC9AB,0x0000,0xC3C6,0x0000,
	0x0000,0xD7BB,0x0000,0x0000,0x0000,0xF9AC,0x0000,0x0000,0xD7BC,0x0000,0xB6B0,0x0000,0xD7BD,0x0000,0xD7BE,0x0000,
	0x0000,0xD7C0,0x0000,0xC5F6,0x0000,0x0000,0xD7C1,0xD7C2,0x0000,0xD7C3,0x0000,0x0000,0xD7B4,0xD7B3,0x0000,0x0000,
	0x0000,0xD7C4,0xB7C1,0x0000,0x0000,0x0000,0xC9A7,0xF9FD,0x0000,0xBACC,0xC9B7,0xC4A6,0xC9CB,0xD7C5,0x0000,0x0000,
	0xBEB4,0xB1C6,0x0000,0xD7C6,0x0000,0x0000,0x0000,0xD7C7,0x0000,0xCCF2,0x0000,0x0000,0xC8E0,0x0000,0x0000,0xD7CA,
	0xB1FD,0xC0AC,0xD7C9,0xD7C8,0xB7C2,0xC2D4,0x0000,0xD7CE,0xD7CC,0x0000,0xD7CB,0xCEA7,0xB8E5,0x0000,0x0000,0x0000,
	0xBDF9,0xD7CD,0xC5CC,0xBDBE,0x0000,0x0000,0x0000,0xC6C0,0xD7D1,0xD7D0,0x0000,0x0000,0x0000,0x0000,0xD7CF,0x0000,
	0xD7D2,0xB8E6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD7D3,0xC9FC,0xBDDB,0x0000,0x0000,0xD7D4,0xC8F9,0x0000,
	0x0000,0x0000,0x0000,0xC6C1,0xC4A7,0x0000,0x0000,0xF9FE,0x0000,0xC5B0,0x0000,0x0000,0xD7D5,0xB5AB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xBFB4,0x0000,0xC9AC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB4F7,0xC7A6,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD7D6,0xBBD6,0xCBBA,0xCBBB,0x0000,0x0000,0xB1FE,0xD7DB,0xFAA1,0x0000,
	0xC3E9,0x0000,0x0000,0x0000,0xD7D8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2F7,0x0000,0x0000,0x0000,0x0000,
	0xD8AD,0xD7DA,0x0000,0x0000,0x0000,0xC7B0,0x0000,0x0000,0xD7D9,0x0000,0x0000,0xD7D7,0x0000,0xB9FA,0x0000,0xD7DD,
};
static const WORD _ucs_to_eucj_6000_data []={ //600E 60FB
	                                                                                                  0xD7E3,0xD7E9,
	0xD7E1,0x0000,0xC5DC,0x0000,0x0000,0xD7E6,0xC9DD,0x0000,0x0000,0xD7E0,0x0000,0xD7E5,0xCEE7,0xBBD7,0x0000,0x0000,
	0xC2D5,0xD7DE,0x0000,0x0000,0x0000,0xB5DE,0xD7E8,0xC0AD,0xB1E5,0xD7E2,0xB2F8,0xD7E7,0x0000,0x0000,0x0000,0xB6B1,
	0x0000,0xD7E4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD7EA,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xD7EC,0xD7F6,0xD7F4,0x0000,0x0000,0xD7F1,0x0000,0x0000,0x0000,0xD7F0,0xCEF8,0x0000,0xD7F2,0x0000,0x0000,
	0xB6B2,0x0000,0xB9B1,0x0000,0x0000,0xBDFA,0x0000,0x0000,0x0000,0xD7F9,0xD7EB,0x0000,0x0000,0xFAA2,0x0000,0xD7EF,
	0xD7DF,0x0000,0xB2FA,0xD7F3,0xD7F5,0xC3D1,0x0000,0x0000,0xBAA8,0xB2B8,0xD7ED,0xD7F8,0xD7F7,0xB6B3,0x0000,0xC2A9,
	0xB3E6,0x0000,0x0000,0x0000,0x0000,0xB7C3,0x0000,0xD7EE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xD7FA,0x0000,0xD7FD,0xD8A1,0xFAA3,0x0000,0x0000,0x0000,0xBCBD,0xFAA4,0xD8A7,0xC4F0,0xD7FB,0x0000,0x0000,
	0x0000,0x0000,0xD8A5,0x0000,0xB2F9,0x0000,0xD8A3,0xD8A4,0x0000,0x0000,0xD7FE,0xD8A2,0x0000,0x0000,0x0000,0xB8E7,
	0xCDAA,0x0000,0x0000,0xB4B5,0x0000,0x0000,0xB1D9,0xD8A6,0x0000,0xC7BA,0xB0AD,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC8E1,0xD7DC,0xD8AC,0xD8B0,0xCCE5,0x0000,0xD8A9,0x0000,0x0000,0x0000,0xC5E9,0xD8AE,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xBEF0,0xD8AF,0xC6D7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xCFC7,0x0000,0xD8AB,0x0000,0xFAA6,0x0000,0x0000,0xD8B1,0x0000,0xB9FB,0x0000,0xC0CB,0x0000,0xFAA5,0xB0D4,
	0xD8AA,0xD8A8,0x0000,0xC1DA,0x0000,0x0000,0x0000,0xD7FC,0xBBB4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xC2C6,0xD8BD,0xFAA8,0xC1DB,0xD8B8,0x0000,0xD8B5,0xD8B6,0x0000,0xBCE6,0xD8B9,0xD8BC,
};
static const WORD _ucs_to_eucj_6100_data []={ //6100 61FF
	0xD8B7,0xBDA5,0x0000,0xD8BA,0x0000,0x0000,0xD8B4,0x0000,0xCCFC,0xCCFB,0x0000,0x0000,0x0000,0xD8BE,0xD8BF,0xB0D5,
	0x0000,0xFAA9,0x0000,0x0000,0x0000,0xD8B3,0x0000,0x0000,0x0000,0x0000,0xB6F2,0xB0A6,0x0000,0x0000,0x0000,0xB4B6,
	0xFAA7,0xD8BB,0x0000,0x0000,0x0000,0x0000,0x0000,0xD8C3,0xD8C2,0x0000,0x0000,0x0000,0xD8C7,0x0000,0x0000,0x0000,
	0xFAAB,0x0000,0x0000,0x0000,0xD8C8,0x0000,0x0000,0xFAAA,0x0000,0x0000,0x0000,0x0000,0xD8C6,0xD8C9,0xD8C1,0xD8C5,
	0x0000,0x0000,0xD8CA,0x0000,0xD8CB,0x0000,0x0000,0xD8C0,0xBBFC,0x0000,0xD8C4,0xC2D6,0xB9B2,0xD8B2,0xBFB5,0x0000,
	0x0000,0x0000,0x0000,0xD8D8,0x0000,0xCAE9,0x0000,0x0000,0xD8CE,0xD8CF,0xD8D0,0x0000,0x0000,0xD8D7,0x0000,0xD8D6,
	0x0000,0x0000,0xCBFD,0xB4B7,0x0000,0xD8D4,0x0000,0xB7C5,0xB3B4,0x0000,0x0000,0xD8D1,0x0000,0x0000,0xCEB8,0xD8D3,
	0xB0D6,0xD8D5,0x0000,0xD8CC,0xD8D2,0xD8D9,0xB7C4,0xD8CD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDDD,0x0000,
	0x0000,0x0000,0xCDAB,0x0000,0x0000,0x0000,0x0000,0xD8DC,0x0000,0x0000,0xD8E0,0x0000,0x0000,0x0000,0xC1FE,0x0000,
	0xCEF9,0xD8E1,0x0000,0x0000,0xD8DE,0x0000,0xD8DB,0x0000,0xFAAC,0xD8DA,0xD8DF,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xCAB0,0x0000,0x0000,0xC6B4,0x0000,0xB7C6,0x0000,0xD8E2,0xD8DD,0x0000,0xD8E3,0x0000,
	0x0000,0x0000,0xB7FB,0x0000,0x0000,0x0000,0xB2B1,0x0000,0x0000,0x0000,0xD8EB,0x0000,0x0000,0x0000,0xB4B8,0x0000,
	0x0000,0x0000,0x0000,0xD8E9,0x0000,0x0000,0xD8EA,0xBAA9,0xD8E8,0xD8E6,0xD8E5,0xD8EC,0xD8E4,0xD8EE,0x0000,0x0000,
	0xB2FB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xD8F0,0x0000,0x0000,0xD8EF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC4A8,0x0000,0xD8F3,0x0000,0xD8F1,0xD8E7,0xB7FC,0x0000,0xD8F2,0x0000,0xD8F6,0xD8F5,0xD8F7,0xD8F4,
};
static const WORD _ucs_to_eucj_6200_data []={ //6200 62FF
	0xD8F8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD8F9,0xD8FA,0xCAEA,0x0000,0xD8FC,0xD8FB,0xBDBF,0x0000,
	0xC0AE,0xB2E6,0xB2FC,0xFAAD,0xD8FD,0x0000,0xB0BF,0x0000,0x0000,0x0000,0xC0CC,0xD8FE,0x0000,0xECC3,0xD9A1,0xB7E1,
	0x0000,0xD9A2,0x0000,0x0000,0x0000,0x0000,0xC0EF,0x0000,0x0000,0x0000,0xD9A3,0x0000,0x0000,0x0000,0xD9A4,0xB5BA,
	0xD9A5,0x0000,0xD9A6,0xD9A7,0xC2D7,0x0000,0x0000,0x0000,0xB8CD,0x0000,0x0000,0xCCE1,0x0000,0x0000,0x0000,0xCBBC,
	0xBDEA,0xD9A8,0x0000,0x0000,0x0000,0x0000,0x0000,0xC0F0,0xEEBD,0xC8E2,0x0000,0xBCEA,0x0000,0xBACD,0xD9A9,0x0000,
	0x0000,0x0000,0x0000,0xC2C7,0x0000,0xCAA7,0x0000,0x0000,0xC2F1,0x0000,0x0000,0xD9AC,0x0000,0x0000,0xD9AA,0x0000,
	0xD9AD,0x0000,0x0000,0xD9AB,0x0000,0x0000,0x0000,0x0000,0xD9AE,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAB1,0x0000,
	0x0000,0xB0B7,0x0000,0x0000,0x0000,0x0000,0xC9DE,0x0000,0x0000,0xC8E3,0x0000,0x0000,0xD9AF,0x0000,0xD9B2,0xBEB5,
	0xB5BB,0x0000,0xD9B0,0xD9B7,0xBEB6,0x0000,0x0000,0x0000,0x0000,0xD9B1,0xC7C4,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xCDDE,0xD9B3,0xD9B4,0xD9B8,0xC5EA,0xD9B5,0xB9B3,0xC0DE,0x0000,0x0000,0xD9C6,0xC8B4,0x0000,0xC2F2,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAAE,0x0000,0x0000,0x0000,0x0000,0xC8E4,0xDAAD,0x0000,0x0000,0x0000,
	0x0000,0xCAFA,0x0000,0x0000,0x0000,0xC4F1,0x0000,0x0000,0x0000,0xCBF5,0x0000,0xD9BB,0xB2A1,0xC3EA,0x0000,0x0000,
	0x0000,0x0000,0xD9C4,0x0000,0x0000,0xC3B4,0xD9BE,0xD9C5,0xD9C0,0xD9C7,0xD9C3,0x0000,0xD9C2,0xC7EF,0x0000,0xD9BC,
	0xB2FD,0xD9BA,0xB5F1,0xC2F3,0xD9B6,0x0000,0x0000,0xD9B9,0xB9B4,0xC0DB,0x0000,0xBEB7,0xD9C1,0xC7D2,0x0000,0x0000,
	0xB5F2,0xB3C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB3E7,0xBFA1,0xD9C9,0xD9CE,
	0x0000,0xD9CA,0x0000,0xB7FD,0x0000,0xD9CF,0xBBA2,0xB9E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBDA6,0xD9BD,
};
static const WORD _ucs_to_eucj_6300_data []={ //6301 63FA
	       0xBBFD,0xD9CC,0x0000,0x0000,0x0000,0x0000,0xBBD8,0xD9CD,0xB0C4,0x0000,0x0000,0xD9C8,0x0000,0x0000,0x0000,
	0x0000,0xC4A9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5F3,0x0000,0x0000,0x0000,0x0000,0x0000,0xB6B4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD9CB,0xB0A7,0x0000,0x0000,0xBAC3,0x0000,0x0000,0x0000,0xBFB6,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC4F2,0x0000,0x0000,0xC8D4,0xD9D1,0xC1DE,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC2AA,0x0000,0x0000,0xBBAB,0xD9D2,0x0000,0xD9D4,
	0xD9D0,0x0000,0x0000,0x0000,0x0000,0xCAE1,0x0000,0xC4BD,0x0000,0x0000,0x0000,0x0000,0xC1DC,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAFB,0xBCCE,0xD9E0,0x0000,0xD9DF,0x0000,0x0000,0xBFF8,0x0000,
	0x0000,0x0000,0xB7FE,0x0000,0x0000,0x0000,0xD9D9,0xBEB9,0x0000,0x0000,0xC6E8,0xC7B1,0x0000,0x0000,0x0000,0x0000,
	0xD9D7,0x0000,0x0000,0xC1DD,0x0000,0x0000,0x0000,0x0000,0xBCF8,0xD9DC,0x0000,0x0000,0xBEB8,0x0000,0xD9D6,0xD9DB,
	0x0000,0x0000,0xC7D3,0x0000,0x0000,0x0000,0xD9D5,0x0000,0xB7A1,0x0000,0x0000,0xB3DD,0x0000,0x0000,0x0000,0xD9DD,
	0xCEAB,0xBACE,0xC3B5,0xD9DA,0x0000,0xC0DC,0x0000,0xB9B5,0xBFE4,0xB1E6,0xC1BC,0xD9D8,0xB5C5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xB7C7,0x0000,0xC4CF,0xD9DE,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1DF,0x0000,0x0000,0xD9E1,0x0000,
	0xD9E3,0x0000,0x0000,0xC2B7,0xD9E9,0x0000,0xD9E4,0x0000,0x0000,0xD9E6,0x0000,0x0000,0x0000,0x0000,0x0000,0xC9C1,
	0xC4F3,0x0000,0xD9E7,0x0000,0x0000,0x0000,0xCDAC,0x0000,0x0000,0x0000,0xCDC8,0xB4B9,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB0AE,0x0000,0xD9E5,0x0000,0x0000,0x0000,0x0000,0x0000,0xD9E2,0x0000,0x0000,0x0000,0x0000,0xB4F8,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xB1E7,0xFAAF,0xD9E8,0x0000,0x0000,0x0000,0xCDC9,
};
static const WORD _ucs_to_eucj_6400_data []={ //6406 64FE
	                                          0xD9EC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC2BB,0x0000,0xD9F3,
	0x0000,0x0000,0x0000,0xD9ED,0x0000,0x0000,0xD9EA,0xD9F1,0x0000,0x0000,0x0000,0x0000,0xD9D3,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD9EE,0x0000,0xD9F2,0x0000,0x0000,0x0000,0xC8C2,0xC5EB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xD9EB,0x0000,0xD9EF,0x0000,0x0000,0x0000,0xB7C8,0x0000,0x0000,0x0000,0xBAF1,0x0000,
	0x0000,0x0000,0xC0DD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD9F7,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5A6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xFAB0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD9F4,0x0000,0xCBE0,0x0000,0x0000,0x0000,0x0000,0x0000,0xD9F5,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD9F6,0x0000,0xCCCE,0x0000,0xC0A2,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xB7E2,0x0000,0x0000,0x0000,0x0000,0xD9FD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xBBB5,0xD9FA,0x0000,0xD9F9,0x0000,0x0000,0x0000,0x0000,0xC7B2,0x0000,0x0000,0xFAB1,0xC6B5,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xC5B1,0xD9FB,0x0000,0x0000,0x0000,0xD9FC,0x0000,0xC9EF,0x0000,0xC7C5,0xBBA3,0x0000,
	0xC0F1,0x0000,0xCBD0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB3C9,0x0000,0xDAA5,0xD9FE,0x0000,0x0000,0x0000,
	0x0000,0xCDCA,0xDAA7,0x0000,0x0000,0xDAA3,0x0000,0xDAA4,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1E0,0xFAB2,0x0000,
	0x0000,0x0000,0xDAA2,0x0000,0xD9BF,0x0000,0x0000,0x0000,0xDAA6,0x0000,0xDAA1,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xDAAB,0xDAAC,0xC5A7,0xDAAE,0x0000,0x0000,0xBBA4,0xDAA9,0x0000,0x0000,0x0000,0x0000,0xB5BC,0x0000,0x0000,0xDAAF,
	0x0000,0xDAA8,0xDAB3,0x0000,0xDAB2,0x0000,0xDAB1,0x0000,0x0000,0x0000,0xDAB4,0x0000,0x0000,0xDAB6,0xBEF1,
};
static const WORD _ucs_to_eucj_6500_data []={ //6500 65FB
	0xDAB5,0x0000,0x0000,0x0000,0x0000,0xDAB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDAB7,0x0000,0x0000,0x0000,0xDAB8,0xD9F0,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xDABB,0xDABA,0x0000,0x0000,0x0000,0x0000,0x0000,0xD9F8,0xDABC,0xDAB0,0x0000,0x0000,0xBBD9,
	0x0000,0x0000,0x0000,0x0000,0xDABD,0xDABE,0xDAC0,0xDABF,0xDAC1,0xB2FE,0x0000,0xB9B6,0x0000,0x0000,0xCAFC,0xC0AF,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xB8CE,0x0000,0x0000,0xDAC3,0x0000,0x0000,0x0000,0x0000,0xDAC6,0xFAB3,0xC9D2,
	0x0000,0xB5DF,0x0000,0x0000,0x0000,0xDAC5,0xDAC4,0xC7D4,0xDAC7,0xB6B5,0x0000,0x0000,0x0000,0xDAC9,0xDAC8,0x0000,
	0x0000,0x0000,0xB4BA,0xBBB6,0x0000,0x0000,0xC6D8,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7C9,0x0000,0x0000,0x0000,
	0xBFF4,0x0000,0xDACA,0x0000,0xC0B0,0xC5A8,0x0000,0xC9DF,0xDACB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xDACC,0xDACD,0x0000,0x0000,0x0000,0xCAB8,0xD5DD,0xC0C6,0x0000,0x0000,0xC9CC,0x0000,0xBAD8,0x0000,
	0xC8E5,0xC8C3,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5CD,0x0000,0xCEC1,0x0000,0xDACF,0xBCD0,0x0000,0x0000,0xDAD0,
	0x0000,0xB0B6,0x0000,0x0000,0xB6D4,0xC0CD,0x0000,0xC9E0,0x0000,0x0000,0x0000,0xDAD1,0xBBC2,0xC3C7,0x0000,0xBBDB,
	0xBFB7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDAD2,0x0000,0xCAFD,0x0000,0x0000,0xB1F7,0xBBDC,0x0000,0x0000,
	0x0000,0xDAD5,0x0000,0xDAD3,0xDAD6,0xCEB9,0xDAD4,0x0000,0x0000,0x0000,0x0000,0xC0FB,0xDAD7,0x0000,0x0000,0xC2B2,
	0x0000,0x0000,0xDAD8,0x0000,0x0000,0x0000,0x0000,0xB4FA,0x0000,0xDADA,0x0000,0xDAD9,0x0000,0x0000,0x0000,0x0000,
	0xDADB,0xDADC,0xB4FB,0x0000,0x0000,0xC6FC,0xC3B6,0xB5EC,0xBBDD,0xC1E1,0x0000,0x0000,0xBDDC,0xB0B0,0x0000,0x0000,
	0x0000,0xDADD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2A2,0xDAE1,
};
static const WORD _ucs_to_eucj_6600_data []={ //6600 66FF
	0xFAB4,0x0000,0xB9B7,0xDAE0,0x0000,0x0000,0xBAAB,0xBEBA,0x0000,0xFAB7,0xDADF,0x0000,0xBEBB,0x0000,0xCCC0,0xBAAA,
	0x0000,0x0000,0x0000,0xB0D7,0xC0CE,0xFAB5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDAE6,0x0000,0xFAB9,0xC0B1,
	0xB1C7,0x0000,0x0000,0x0000,0xFABA,0xBDD5,0x0000,0xCBE6,0xBAF2,0x0000,0x0000,0x0000,0x0000,0xBEBC,0xFAB8,0xC0A7,
	0x0000,0xF9A8,0x0000,0x0000,0xDAE5,0xDAE3,0xDAE4,0x0000,0x0000,0x0000,0x0000,0xFAB6,0xC3EB,0x0000,0x0000,0xDBA6,
	0x0000,0xDAEA,0xBBFE,0xB9B8,0xDAE8,0x0000,0x0000,0x0000,0x0000,0xDAE9,0x0000,0xBFB8,0x0000,0x0000,0x0000,0xDAE7,
	0x0000,0x0000,0xBBAF,0x0000,0x0000,0x0000,0x0000,0xFABC,0x0000,0xFABD,0x0000,0x0000,0x0000,0xDAEC,0xDAEB,0xDAF0,
	0x0000,0x0000,0xDAF1,0x0000,0xDAED,0xFABB,0xB3A2,0xDAEE,0xDAEF,0xC8D5,0x0000,0x0000,0x0000,0x0000,0xC9E1,0xB7CA,
	0xDAF2,0x0000,0x0000,0xFABF,0xC0B2,0x0000,0xBEBD,0x0000,0x0000,0x0000,0xC3D2,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB6C7,0x0000,0xDAF3,0xDAF7,0x0000,0x0000,0xB2CB,0xDAF4,0xDAF6,0x0000,0x0000,0x0000,0x0000,0xDAF5,0x0000,
	0x0000,0xBDEB,0x0000,0x0000,0x0000,0x0000,0xC3C8,0xB0C5,0xDAF8,0xFAC0,0x0000,0x0000,0x0000,0xDAF9,0x0000,0x0000,
	0xFAC1,0x0000,0xC4AA,0x0000,0x0000,0x0000,0xCEF1,0x0000,0x0000,0x0000,0x0000,0xBBC3,0x0000,0x0000,0xCAEB,0x0000,
	0x0000,0x0000,0xFAC2,0x0000,0xCBBD,0x0000,0x0000,0x0000,0xDBA2,0xDAFB,0x0000,0x0000,0xDAFE,0x0000,0xDAFD,0xFAC3,
	0x0000,0xDAFA,0x0000,0x0000,0xDBA1,0x0000,0x0000,0xC6DE,0x0000,0xDAFC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDBA3,0x0000,0x0000,0xBDEC,0xDBA4,0x0000,0xCDCB,0xC7F8,0x0000,0x0000,
	0xDBA5,0x0000,0x0000,0x0000,0x0000,0x0000,0xDBA7,0x0000,0x0000,0xDBA8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xDBA9,0x0000,0xB6CA,0xB1C8,0xB9B9,0xDBAA,0x0000,0xDBAB,0xBDF1,0xC1E2,0xFAC4,0xF9AB,0xD2D8,0xC1BE,0xC1BD,0xC2D8,
};
static const WORD _ucs_to_eucj_6700_data []={ //6700 67FF
	0xBAC7,0x0000,0x0000,0xD0F2,0x0000,0x0000,0x0000,0x0000,0xB7EE,0xCDAD,0x0000,0xCAFE,0x0000,0xC9FE,0xFAC5,0xDBAC,
	0x0000,0x0000,0x0000,0x0000,0xBAF3,0xC4BF,0xDBAD,0xCFAF,0x0000,0x0000,0x0000,0xCBBE,0x0000,0xC4AB,0xDBAE,0xB4FC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDBAF,0xDBB0,0xCCDA,0x0000,0xCCA4,0xCBF6,0xCBDC,0xBBA5,0xDBB2,0x0000,
	0x0000,0xBCEB,0x0000,0x0000,0xCBD1,0x0000,0xDBB4,0xDBB7,0xDBB6,0x0000,0xB4F9,0x0000,0x0000,0xB5E0,0x0000,0xDBB3,
	0x0000,0xDBB5,0x0000,0x0000,0x0000,0x0000,0xDBB8,0x0000,0x0000,0xBFF9,0x0000,0x0000,0x0000,0x0000,0xCDFB,0xB0C9,
	0xBAE0,0xC2BC,0x0000,0xBCDD,0x0000,0x0000,0xBEF3,0x0000,0x0000,0xDBBB,0x0000,0x0000,0xC5CE,0x0000,0xDBB9,0xC2AB,
	0xDBBA,0xBEF2,0xCCDD,0xDBBC,0xDBBD,0xCDE8,0xFAC7,0x0000,0x0000,0x0000,0xDBC2,0x0000,0x0000,0xB9BA,0x0000,0xC7D5,
	0xDBBF,0xC5EC,0xDADE,0xDAE2,0x0000,0xB5CF,0x0000,0xC7C7,0x0000,0x0000,0x0000,0x0000,0xDBC1,0x0000,0xBEBE,0xC8C4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xDBC7,0x0000,0xC8FA,0x0000,0xDBBE,0x0000,0xDBC4,0xDBC3,0x0000,0x0000,0x0000,
	0xC0CF,0x0000,0x0000,0x0000,0x0000,0xCBED,0x0000,0xCED3,0x0000,0x0000,0xCBE7,0x0000,0xB2CC,0xBBDE,0x0000,0x0000,
	0xCFC8,0xDBC6,0xBFF5,0x0000,0x0000,0x0000,0xDBC5,0x0000,0x0000,0xDBC0,0x0000,0x0000,0x0000,0x0000,0x0000,0xB8CF,
	0x0000,0x0000,0x0000,0xDBCC,0xDBCA,0x0000,0xB2CD,0xDBC8,0xDBCE,0xDBD4,0x0000,0xFAC8,0x0000,0x0000,0x0000,0x0000,
	0xFACA,0xC2C8,0x0000,0x0000,0xCAC1,0x0000,0xDBD6,0x0000,0x0000,0x0000,0xC9A2,0x0000,0x0000,0x0000,0xDBD5,0xC7F0,
	0xCBBF,0xB4BB,0x0000,0xC0F7,0xBDC0,0x0000,0x0000,0x0000,0xC4D3,0x0000,0xCDAE,0x0000,0x0000,0xDBD1,0xDBD0,0x0000,
	0x0000,0x0000,0xDBD2,0x0000,0xDBCF,0x0000,0x0000,0xDBD7,0x0000,0xDBCD,0x0000,0x0000,0xDBCB,0x0000,0xDBD3,0xDBC9,
	0x0000,0xC3EC,0x0000,0xCCF8,0xBCC6,0xBAF4,0x0000,0x0000,0x0000,0x0000,0x0000,0xBABA,0x0000,0x0000,0xCBEF,0xB3C1,
};
static const WORD _ucs_to_eucj_6800_data []={ //6801 68FA
	       0xFACB,0xC4CE,0xC6CA,0xB1C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xC0F2,0x0000,0x0000,0xC0B4,0xB7AA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDBD9,0x0000,
	0x0000,0xB9BB,0xB3FC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDBDB,0xB3F4,0xDBE1,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xDBDE,0x0000,0xC0F3,0x0000,0x0000,0x0000,0xB3CB,0xBAAC,0x0000,0x0000,0xB3CA,0xBACF,0x0000,0x0000,
	0xDBDC,0xB7E5,0xB7CB,0xC5ED,0xFACC,0x0000,0xDBDA,0x0000,0xB0C6,0x0000,0x0000,0x0000,0x0000,0xDBDD,0xDBDF,0x0000,
	0xB6CD,0xB7AC,0xFAC9,0xB4BC,0xB5CB,0x0000,0x0000,0x0000,0x0000,0xDBE2,0x0000,0x0000,0xBAF9,0xCBF1,0x0000,0xBBB7,
	0x0000,0x0000,0x0000,0xDBE3,0x0000,0x0000,0x0000,0xC9B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xDBEF,0x0000,0xB2B3,0xDBE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDBF5,0xDBE5,
	0x0000,0xCEC2,0x0000,0xDBEC,0x0000,0xC7DF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDBF4,0x0000,0xDBE7,
	0x0000,0x0000,0x0000,0xB0B4,0xDBE9,0x0000,0x0000,0xB9BC,0x0000,0x0000,0x0000,0xDBEB,0x0000,0xDBEA,0x0000,0xDBE6,
	0xDBF1,0x0000,0xBEBF,0x0000,0x0000,0x0000,0xD4ED,0xB8E8,0xCDFC,0x0000,0x0000,0x0000,0x0000,0xDBE8,0x0000,0xC4F4,
	0xB3A3,0xBAAD,0x0000,0xDBE0,0x0000,0xDBF0,0xB3E1,0x0000,0x0000,0xDBEE,0xDBF2,0x0000,0xC5EE,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xB4FE,0x0000,0xDCB2,0x0000,0xF9A9,0xCCC9,0xDBF7,0xB4FD,0x0000,0xDBFE,0x0000,0xFACD,
	0x0000,0x0000,0xCBC0,0x0000,0xDCA1,0xDCA3,0x0000,0xDCA7,0xDBF9,0x0000,0xC3AA,0x0000,0x0000,0x0000,0x0000,0xC5EF,
	0xDCAB,0xDBFC,0x0000,0xDCA8,0x0000,0x0000,0x0000,0xDCA2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBFB9,0xDCAC,
	0x0000,0x0000,0xC0B3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDCAA,0xB4BD,
};
static const WORD _ucs_to_eucj_6900_data []={ //6900 69FF
	0xCFD0,0xDBF6,0x0000,0x0000,0xDCA6,0xB0D8,0x0000,0x0000,0xDBF8,0x0000,0x0000,0xCCBA,0xDBFD,0xBFA2,0xC4C7,0xDBF3,
	0x0000,0x0000,0xDCA5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBFFA,0xDCAF,0xB3F1,0xB8A1,0x0000,0x0000,0x0000,
	0x0000,0xDCB1,0xDBFA,0xDCB0,0x0000,0xDCA9,0xDBFB,0x0000,0xDCAD,0x0000,0xDCAE,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xDCBF,0x0000,0x0000,0x0000,0xC6CE,0x0000,0xDCA4,0x0000,0x0000,0xDCBB,0x0000,0x0000,0x0000,0xDCBD,0x0000,0xC4D8,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDCC,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xC9F6,0xDCB8,0xC2CA,0x0000,0x0000,0x0000,0xDCBE,0xC1BF,0x0000,0xDCB5,0xDCC2,0xDCC1,0x0000,
	0xC6EF,0xDCC0,0xC6EA,0x0000,0x0000,0x0000,0x0000,0x0000,0xFACF,0x0000,0xDCC4,0xDCB7,0x0000,0xB6C8,0xDCBA,0xBDDD,
	0x0000,0x0000,0x0000,0xC7E0,0xDCBC,0xB6CB,0x0000,0xDCB4,0xDCB6,0xDCB3,0x0000,0x0000,0xCFB0,0xB3DA,0xDCB9,0x0000,
	0x0000,0xDCC3,0xB3B5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBAE7,0x0000,0x0000,0x0000,0xB1DD,0x0000,
	0x0000,0xDCD4,0x0000,0x0000,0xCFB1,0xDCD7,0x0000,0x0000,0xFAD1,0x0000,0x0000,0xBFBA,0xDCD6,0x0000,0x0000,0x0000,
	0xDCD5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDCD2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDCC6,0x0000,
	0x0000,0xDCE3,0xDCC5,0x0000,0xDCD8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDCD0,0x0000,0x0000,0xDCCB,0xDCC8,
	0x0000,0xDCC9,0x0000,0xDCD1,0x0000,0x0000,0x0000,0xF4A2,0x0000,0x0000,0xDCCE,0xB9BD,0xC4C8,0xC1E4,0xDCCC,0x0000,
	0xDCC7,0x0000,0x0000,0xDCCA,0x0000,0x0000,0x0000,0x0000,0xCDCD,0xCBEA,0x0000,0x0000,0x0000,0xDCCF,0xDCD9,0x0000,
	0x0000,0x0000,0xFAD2,0x0000,0x0000,0x0000,0x0000,0xDCE1,0xDCDA,0x0000,0x0000,0xDCE7,0x0000,0xDCE5,0x0000,0x0000,
	0x0000,0x0000,0xDCE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDCDF,0x0000,0xC4D0,0x0000,0xC1E5,0x0000,0xDCDD,
};
static const WORD _ucs_to_eucj_6A00_data []={ //6A02 6AFB
	              0xDCDB,0x0000,0x0000,0xDCE2,0x0000,0x0000,0x0000,0x0000,0xDCE8,0xC8F5,0xDCEE,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xDCE9,0xDCEC,0xDCE6,0x0000,0x0000,0xC3F4,0x0000,0xC9B8,0x0000,0xDCDC,0x0000,0x0000,0xDCE4,0xBEC0,
	0x0000,0xCCCF,0xDCF8,0xDCEB,0x0000,0x0000,0x0000,0x0000,0x0000,0xB8A2,0xB2A3,0xB3DF,0x0000,0x0000,0xDCD3,0x0000,
	0xFAD3,0x0000,0x0000,0x0000,0x0000,0xBEC1,0xDCF0,0x0000,0xDCF7,0xBCF9,0xB3F2,0x0000,0x0000,0xC3AE,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xDCED,0x0000,0xFAD5,0xDCF2,0xDCF6,0x0000,0x0000,0xB6B6,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5CC,0xDCF4,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5A1,
	0x0000,0xC6CB,0xDCF3,0x0000,0x0000,0x0000,0xDCF5,0x0000,0x0000,0x0000,0x0000,0xFAD4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xDCEF,0xFAD6,0x0000,0x0000,0x0000,0x0000,0xDCF1,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAD7,0xB3E0,
	0xC3C9,0x0000,0x0000,0x0000,0xDCFC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDCFA,0xB8E9,0x0000,
	0xDCF9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDDA1,0x0000,0x0000,0x0000,0x0000,0xDBD8,0x0000,0x0000,0x0000,
	0xDCFB,0x0000,0xDCFD,0xDCFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDDAC,0x0000,0xDDA8,0x0000,0xDBED,0x0000,
	0x0000,0x0000,0x0000,0xDDA7,0x0000,0x0000,0x0000,0x0000,0xDDA6,0x0000,0x0000,0xDDA3,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xDCEA,0xDDA5,0xDDA4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xDDAA,0x0000,0xCFA6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDDAD,0xB6FB,0x0000,0x0000,0xDDA9,0xDDAB,
	0x0000,0x0000,0xFAD8,0x0000,0xFAD9,0x0000,0x0000,0x0000,0xC8A7,0x0000,0xDDAE,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDDB2,0xDDAF,
};
static const WORD _ucs_to_eucj_6B00_data []={ //6B04 6BF3
	                            0xCDF3,0xDDB0,0x0000,0x0000,0x0000,0x0000,0xDCDE,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xDDB3,0x0000,0x0000,0x0000,0xDDB4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB1B5,0x0000,0xDDB6,
	0xB7E7,0xBCA1,0x0000,0xB6D5,0x0000,0x0000,0x0000,0xB2A4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCDDF,0x0000,0x0000,0x0000,0x0000,0xDDB8,0xDDB7,0xDDBA,0xB5BD,0x0000,0x0000,0xB6D6,0xB4BE,0x0000,
	0x0000,0x0000,0x0000,0xDDBD,0x0000,0x0000,0x0000,0xDDBC,0x0000,0xDDBE,0x0000,0x0000,0xB2CE,0x0000,0xC3B7,0x0000,
	0xDDBF,0x0000,0x0000,0xB4BF,0xDDC1,0x0000,0x0000,0x0000,0x0000,0xDDC0,0x0000,0xDDC2,0x0000,0x0000,0x0000,0xDDC3,
	0x0000,0xDDC4,0xBBDF,0xC0B5,0xBAA1,0x0000,0xC9F0,0x0000,0x0000,0xCAE2,0xCFC4,0x0000,0x0000,0x0000,0x0000,0xBBF5,
	0x0000,0x0000,0x0000,0xBAD0,0xCEF2,0x0000,0x0000,0x0000,0xDDC5,0xDDC6,0x0000,0xBBE0,0x0000,0x0000,0x0000,0xDDC7,
	0xDDC8,0x0000,0x0000,0xDDCA,0xDDC9,0x0000,0xCBD8,0x0000,0x0000,0xBDDE,0xBCEC,0xBBC4,0x0000,0xDDCB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xDDCD,0xBFA3,0x0000,0xDDCC,0x0000,0x0000,0x0000,0x0000,0x0000,0xDDCE,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xDDCF,0x0000,0x0000,0x0000,0x0000,0x0000,0xDDD0,0xDDD1,0x0000,0x0000,0x0000,0xDDD2,
	0x0000,0xDDD4,0xDDD3,0xDDD5,0xB2A5,0xC3CA,0x0000,0xDDD6,0x0000,0x0000,0xBBA6,0xB3CC,0xDDD7,0x0000,0x0000,0xC5C2,
	0xD4CC,0x0000,0x0000,0x0000,0x0000,0xB5A3,0xDDD8,0x0000,0x0000,0x0000,0x0000,0xDDD9,0x0000,0xCAEC,0xCBE8,0x0000,
	0x0000,0x0000,0xC6C7,0xDDDA,0xC8E6,0x0000,0xFADA,0x0000,0xC8FB,0x0000,0x0000,0xCCD3,0x0000,0x0000,0x0000,0xDDDB,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDDDD,0xDDDC,0x0000,0x0000,0xDDDF,
	0x0000,0x0000,0x0000,0xDDDE,
};
static const WORD _ucs_to_eucj_6C00_data []={ //6C08 6CF3
	                                                        0xDDE1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBBE1,
	0x0000,0xCCB1,0x0000,0xDDE2,0xDDE3,0x0000,0x0000,0xB5A4,0x0000,0x0000,0x0000,0xDDE4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xDDE6,0xDDE5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xBFE5,0x0000,0x0000,0xC9B9,0xB1CA,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8C5,0xFADB,
	0xC4F5,0xBDC1,0xB5E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8C6,0x0000,
	0xBCAE,0x0000,0x0000,0x0000,0x0000,0xDDE8,0x0000,0xB4C0,0x0000,0x0000,0xB1F8,0x0000,0xFADC,0xC6F2,0xDDE7,0xB9BE,
	0xC3D3,0x0000,0xDDE9,0x0000,0x0000,0x0000,0x0000,0x0000,0xDDF1,0x0000,0xDDEA,0x0000,0x0000,0x0000,0x0000,0xFADE,
	0xC2C1,0x0000,0xB5E2,0xDDF2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7E8,0x0000,0x0000,0xB5A5,0xDDF0,0x0000,
	0x0000,0xDDEE,0xDDEB,0xCDE0,0x0000,0x0000,0xFADD,0x0000,0xC4C0,0x0000,0x0000,0x0000,0xC6D9,0xDDEC,0x0000,0x0000,
	0xDDF4,0x0000,0xDDF3,0xB7A3,0x0000,0x0000,0xB2AD,0x0000,0x0000,0xBABB,0xDDED,0xDDEF,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xCBD7,0xC2F4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCBF7,0x0000,0x0000,0xDDFC,0x0000,
	0x0000,0xDDFD,0x0000,0xB2CF,0x0000,0x0000,0x0000,0x0000,0xCAA8,0xCCFD,0xDEA1,0xBCA3,0xBEC2,0xDDF8,0xDDFE,0xB1E8,
	0x0000,0xB6B7,0x0000,0x0000,0xDDF5,0xDDFA,0x0000,0x0000,0x0000,0xC0F4,0xC7F1,0x0000,0xC8E7,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xDDF7,0x0000,0xCBA1,0x0000,0xDDF9,0x0000,0xDEA4,0xFADF,0xDEA2,0x0000,0xDDFB,0x0000,0x0000,
	0x0000,0xCBA2,0xC7C8,0xB5E3,0x0000,0xC5A5,0x0000,0x0000,0xC3ED,0x0000,0xDEA5,0x0000,0x0000,0x0000,0x0000,0xDEA3,
	0xC2D9,0xDDF6,0x0000,0xB1CB,
};
static const WORD _ucs_to_eucj_6D00_data []={ //6D04 6DFC
	                            0xFAE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDCE,0xDEB0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xDEAF,0x0000,0x0000,0x0000,0x0000,0xC0F6,0x0000,0xDEAC,0x0000,0xCDEC,0x0000,0x0000,0xC6B6,0xDEA6,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xC4C5,0x0000,0x0000,0x0000,0xB1CC,0xB9BF,0xDEA9,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xBDA7,0xDEAE,0x0000,0xDEAD,0xDEA8,0x0000,0xDEAB,0x0000,0x0000,0xB3E8,0x0000,0xDEAA,0xC7C9,0x0000,
	0x0000,0xCEAE,0x0000,0x0000,0xBEF4,0xC0F5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDEB6,0xDEB4,0x0000,0xC9CD,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xDEB1,0xDEB3,0x0000,0xB1BA,0x0000,0x0000,0xB9C0,0xCFB2,0x0000,0xB3BD,0x0000,0xC9E2,0xFAE2,
	0x0000,0x0000,0x0000,0x0000,0xCDE1,0x0000,0x0000,0xB3A4,0xBFBB,0xDEB5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xDEBA,0x0000,0xFAE1,0xBEC3,0x0000,0x0000,0x0000,0xCDB0,0x0000,0xDEB7,0x0000,
	0x0000,0x0000,0x0000,0xDEB2,0x0000,0xDEB8,0xFAE3,0x0000,0x0000,0xCEDE,0x0000,0xC5F3,0xC6C2,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAE4,0x0000,0x0000,0xB3B6,
	0x0000,0x0000,0xB1D5,0x0000,0x0000,0xDEBE,0x0000,0x0000,0xDEC1,0x0000,0x0000,0x0000,0xCEC3,0x0000,0x0000,0x0000,
	0xCDE4,0x0000,0x0000,0x0000,0x0000,0xDEC8,0xDEC2,0xDEBF,0x0000,0x0000,0x0000,0xCED4,0xDEC5,0x0000,0x0000,0xFAE5,
	0x0000,0xBDCA,0xDEC7,0x0000,0x0000,0xDECC,0x0000,0x0000,0xC5F1,0xDECA,0x0000,0x0000,0x0000,0x0000,0xDEC4,0x0000,
	0x0000,0xC3B8,0x0000,0x0000,0xDECB,0x0000,0xDEC0,0x0000,0xDEC6,0x0000,0xDECD,0xB0FC,0xDEC3,0x0000,0xDECE,0x0000,
	0x0000,0xBFBC,0xFAE7,0xBDDF,0x0000,0xCAA5,0x0000,0xBAAE,0xFAE6,0xDEBB,0xDEC9,0xC5BA,0xFAE8,
};
static const WORD _ucs_to_eucj_6E00_data []={ //6E05 6EFF
	                                   0xC0B6,0x0000,0xB3E9,0xBAD1,0xBEC4,0xDEBD,0xBDC2,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xB7CC,0x0000,0xDEBC,0x0000,0x0000,0x0000,0xDED2,0xBDED,0xB8BA,0x0000,0xDEE1,0x0000,0xDEDB,
	0xB5F4,0xC5CF,0x0000,0xDED6,0xDEDF,0xB0AF,0xB1B2,0xFAEB,0x0000,0xB2B9,0x0000,0xDED8,0xC2AC,0xDECF,0xDED1,0xB9C1,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDEE2,0xFAE9,0xDEDD,0x0000,0xFAEC,0x0000,0xDED5,0x0000,
	0x0000,0x0000,0x0000,0xDEDC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCCAB,0x0000,0x0000,0xDEDA,0xDEDE,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB8D0,0x0000,0xBEC5,0x0000,0x0000,0xC3B9,0xFAEA,0x0000,0x0000,0xDED4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDAF,0x0000,0x0000,0x0000,0xDED7,0x0000,0x0000,0xDED0,0xC5F2,
	0x0000,0x0000,0xDED3,0x0000,0x0000,0x0000,0xDED9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCFD1,0xBCBE,
	0xCBFE,0x0000,0xDEE3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8AE,0x0000,0x0000,0xDEEF,
	0xB8BB,0x0000,0x0000,0x0000,0x0000,0x0000,0xBDE0,0x0000,0xDEE5,0x0000,0x0000,0x0000,0xCEAF,0xB9C2,0x0000,0xDEF2,
	0x0000,0x0000,0xB0EE,0x0000,0x0000,0xDEF0,0x0000,0x0000,0x0000,0x0000,0xDEE4,0x0000,0x0000,0x0000,0x0000,0xDEEA,
	0x0000,0x0000,0xDEEC,0x0000,0x0000,0x0000,0xCDCF,0xDEE7,0x0000,0x0000,0xC5AE,0x0000,0x0000,0xDEE9,0x0000,0xFAED,
	0x0000,0x0000,0xDEF1,0x0000,0xDEEB,0xCCC7,0x0000,0x0000,0x0000,0xDEE6,0x0000,0xBCA2,0xDEFE,0x0000,0x0000,0x0000,
	0x0000,0xB3EA,0x0000,0xDEE8,0xDEED,0xDEEE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC2EC,0xC2DA,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDEF6,0x0000,0x0000,0xDEFC,
	0x0000,0x0000,0xDEFA,0x0000,0xC5A9,0x0000,0x0000,0xDFA3,0xDEF7,0x0000,0x0000,0x0000,0x0000,0x0000,0xDEF8,0xDEE0,
};
static const WORD _ucs_to_eucj_6F00_data []={ //6F01 6FFE
	       0xB5F9,0xC9BA,0x0000,0x0000,0x0000,0xBCBF,0x0000,0x0000,0xB9F7,0x0000,0x0000,0x0000,0x0000,0x0000,0xCFB3,
	0x0000,0xDEF4,0x0000,0xDFA2,0xB1E9,0xC1E6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xC7F9,0x0000,0xB4C1,0xCEFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCCA1,0xC4D2,0x0000,0x0000,0x0000,
	0x0000,0xDEFB,0xDEFD,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1B2,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFA1,0xDEF9,
	0x0000,0xDEF3,0x0000,0x0000,0x0000,0xB4C3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xB7E9,0x0000,0x0000,0x0000,0xDFAF,0x0000,0x0000,0xDFAA,0xC0F8,0x0000,0x0000,0xB3E3,
	0x0000,0x0000,0x0000,0x0000,0xBDE1,0x0000,0xDFB3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFAC,0xC4AC,0xDFA9,
	0xC4D9,0x0000,0x0000,0x0000,0xDFCC,0x0000,0x0000,0x0000,0xDFA6,0x0000,0xDFA5,0x0000,0xDFAE,0x0000,0x0000,0x0000,
	0xDFA8,0xDFA7,0xDFAD,0x0000,0xC0A1,0x0000,0xDFA4,0x0000,0xFAEE,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFB0,0x0000,
	0x0000,0xDFB1,0x0000,0x0000,0x0000,0x0000,0x0000,0xB4C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xDFB6,0x0000,0xDFB5,0xDFB7,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFBA,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xC5C3,0x0000,0xDFB4,0x0000,0xFAEF,0x0000,0x0000,0x0000,0xDFB8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xB7E3,0xC2F9,0xDFB2,0xC7BB,0x0000,0x0000,0xDFB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xDFBE,0xDFBC,0x0000,0x0000,0xDFBF,0x0000,0x0000,0xDFC2,0x0000,0x0000,0x0000,0xDFBB,
	0xB9EA,0xC7A8,0x0000,0x0000,0xDEB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDF4,0xDFBD,0x0000,0xDFC1,0xC2F5,
	0x0000,0xDFC0,0x0000,0xDFAB,0x0000,0xFAF0,0xEFE9,0x0000,0x0000,0x0000,0xDFC5,0x0000,0x0000,0x0000,0xDFC9,
};
static const WORD _ucs_to_eucj_7000_data []={ //7001 70FD
	       0xDFC7,0x0000,0x0000,0x0000,0xFAF1,0x0000,0xFAF2,0x0000,0xDFC3,0x0000,0xDFC4,0x0000,0x0000,0x0000,0xDFC8,
	0x0000,0xDFC6,0x0000,0x0000,0x0000,0xC9CE,0x0000,0x0000,0xDFCE,0x0000,0xDFCB,0xDFCA,0x0000,0xDFCD,0xC6D4,0xDFCF,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC3F5,0xC2ED,0xFAF3,0x0000,0x0000,0x0000,0xC0A5,0x0000,0x0000,0x0000,
	0xDFD0,0x0000,0xDFD2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFD1,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDEF5,0x0000,0x0000,0x0000,
	0x0000,0xDFD3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC6E7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xDFD4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2D0,0x0000,0x0000,0x0000,0xC5F4,
	0xB3A5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5E4,0x0000,0x0000,0x0000,0xBCDE,0xBAD2,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xFAF4,0x0000,0x0000,0x0000,0xCFA7,0xBFE6,0x0000,0x0000,0x0000,0xB1EA,0x0000,
	0x0000,0x0000,0xDFD6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFD5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAF5,0xDFD9,0xC3BA,0xDFDC,0xDFD7,
	0x0000,0x0000,0x0000,0xDFDB,0x0000,0x0000,0x0000,0x0000,0xDFDA,0xC5C0,0xB0D9,0xF9A7,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCEF5,0x0000,0x0000,0xDFDE,0x0000,0x0000,0x0000,0xB1A8,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFE0,0x0000,0x0000,0x0000,0xDFDF,0x0000,0xDFDD,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xDFD8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCBA3,0x0000,0x0000,0x0000,0xDFE2,
};
static const WORD _ucs_to_eucj_7100_data []={ //7104 71FF
	                            0xFAF7,0x0000,0x0000,0x0000,0x0000,0xDFE1,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAF6,
	0x0000,0x0000,0x0000,0x0000,0xB1EB,0x0000,0x0000,0x0000,0x0000,0xDFE4,0xCAB2,0x0000,0xDFE3,0x0000,0x0000,0x0000,
	0x0000,0xCCB5,0x0000,0x0000,0x0000,0x0000,0xBEC7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1B3,0x0000,0x0000,0x0000,0x0000,0x0000,0xBEC6,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFAF9,0xFAFA,0x0000,0xCEFB,0x0000,0x0000,0xDFEA,0x0000,0xC0F9,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xDFE6,0xDFEB,0x0000,0x0000,0xB1EC,0x0000,0x0000,0xFAF8,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xDFE9,0x0000,0xC7E1,0xDFE5,0xDFE8,0xBEC8,0x0000,0xC8D1,0x0000,0x0000,0xDFEC,0x0000,0xBCD1,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC0FA,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xDFEF,0x0000,0x0000,0x0000,0xDFE7,0x0000,0xB7A7,0x0000,0x0000,0x0000,0x0000,0xDFED,
	0x0000,0x0000,0x0000,0x0000,0xCDD0,0xDFF0,0x0000,0x0000,0x0000,0xF4A6,0x0000,0x0000,0x0000,0x0000,0x0000,0xBDCF,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFF1,0x0000,0x0000,0x0000,0xDFF2,0x0000,0x0000,0x0000,
	0x0000,0xC7AE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDFF4,0x0000,0x0000,0x0000,0x0000,0xDFF5,0x0000,
	0x0000,0xFAFC,0x0000,0xC7B3,0x0000,0x0000,0x0000,0x0000,0xC5F5,0xDFF7,0x0000,0x0000,0x0000,0x0000,0xDFF9,0x0000,
	0xCED5,0x0000,0xDFF6,0x0000,0xDFF8,0xB1ED,0x0000,0xDFF3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xD3DB,
	0xDFFA,0x0000,0x0000,0x0000,0x0000,0xC1E7,0xBBB8,0xDFFC,0x0000,0x0000,0x0000,0x0000,0xDFFB,0xBFA4,0xD2D9,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xDFFD,0x0000,0x0000,0x0000,0xE0A1,0x0000,0xDFEE,0xDFFE,0x0000,0xFAFD,0xE0A2,
};
static const WORD _ucs_to_eucj_7200_data []={ //7206 72FD
	                                          0xC7FA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0A3,0x0000,0x0000,
	0xE0A4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0A5,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0A6,0x0000,0xC4DE,0x0000,0xE0A8,0xE0A7,0x0000,0x0000,
	0xE0A9,0x0000,0xE0AA,0x0000,0x0000,0xBCDF,0xC9E3,0x0000,0x0000,0x0000,0xCCEC,0xE0AB,0xE0AC,0xC1D6,0xBCA4,0xE0AD,
	0xE0AE,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0AF,0xCAD2,0xC8C7,0x0000,0x0000,0xE0B0,0xC7D7,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC4AD,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0B1,0xB2E7,0x0000,0xB5ED,0x0000,0xCCC6,0x0000,0xCCB6,
	0x0000,0xB2B4,0xCFB4,0x0000,0x0000,0x0000,0x0000,0xCBD2,0x0000,0xCAAA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC0B7,0x0000,0xE0B2,0x0000,0x0000,0x0000,0x0000,0xC6C3,0x0000,0x0000,0x0000,0xB8A3,0xE0B3,0x0000,
	0xBAD4,0xE0B5,0xE0B4,0x0000,0x0000,0x0000,0x0000,0xE0B6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE0B7,0x0000,0x0000,0x0000,0xE0B8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xB5BE,0x0000,0xE0B9,0x0000,0x0000,0x0000,0x0000,0xE0BA,0x0000,0x0000,0x0000,0x0000,0xB8A4,0x0000,0x0000,0xC8C8,
	0x0000,0xFAFE,0xE0BC,0x0000,0x0000,0x0000,0xBEF5,0x0000,0x0000,0xE0BB,0x0000,0x0000,0x0000,0x0000,0xFBA1,0x0000,
	0x0000,0x0000,0xB6B8,0xE0BD,0xE0BF,0x0000,0xE0BE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0C0,0x0000,
	0xB8D1,0x0000,0xE0C1,0x0000,0x0000,0x0000,0x0000,0xB6E9,0x0000,0xC1C0,0x0000,0xB9FD,0x0000,0x0000,0x0000,0x0000,
	0xE0C3,0xE0C4,0xE0C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBCED,0x0000,0x0000,0xC6C8,0xB6B9,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0C6,0xC3AC,0xE0C5,0x0000,0x0000,0xCFB5,0xC7E2,
};
static const WORD _ucs_to_eucj_7300_data []={ //730A 73FE
	                                                                      0xE0C9,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0CB,0xE0C8,0x0000,0x0000,0x0000,0xCCD4,0xE0CA,0xE0CC,0x0000,0xCEC4,
	0x0000,0x0000,0x0000,0x0000,0xFBA2,0xE0D0,0x0000,0x0000,0x0000,0xE0CF,0xC3F6,0xC7AD,0x0000,0x0000,0xB8A5,0xE0CE,
	0x0000,0x0000,0x0000,0x0000,0xE0CD,0x0000,0xCDB1,0xCDB2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0D1,0xB1EE,
	0x0000,0x0000,0x0000,0x0000,0xB9F6,0xBBE2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0D2,0xE0D3,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0D5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xBDC3,0x0000,0x0000,0x0000,0x0000,0xE0D7,0x0000,0xE0D6,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE0D8,0x0000,0xB3CD,0x0000,0x0000,0xE0DA,0x0000,0xFBA4,0xE0D9,0x0000,0xE0DC,0xE0DB,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xB8BC,0x0000,0x0000,0xCEA8,0x0000,0xB6CC,0x0000,0xB2A6,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB6EA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB4E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCEE8,0xE0DE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0E0,0x0000,0xFBA5,0x0000,0x0000,
	0xE0E1,0x0000,0xB2D1,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0DD,0xFBA6,0xBBB9,0x0000,0x0000,0xC4C1,0xE0DF,0x0000,
	0x0000,0x0000,0xFBA9,0x0000,0x0000,0x0000,0xFBA7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0E4,0x0000,
	0xBCEE,0x0000,0x0000,0xFBA8,0x0000,0xE0E2,0x0000,0x0000,0x0000,0x0000,0xB7BE,0x0000,0x0000,0xC8C9,0xE0E3,0x0000,
	0x0000,0xE0FE,0x0000,0x0000,0x0000,0xFBAB,0x0000,0x0000,0xE0E9,0x0000,0x0000,0x0000,0x0000,0x0000,0xB8BD,
};
static const WORD _ucs_to_eucj_7400_data []={ //7403 74F8
	                     0xB5E5,0x0000,0xE0E6,0xCDFD,0xFBAA,0x0000,0xCEB0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC2F6,0x0000,0x0000,0xE0E8,0xFBAC,0x0000,0x0000,0xFBAE,0xFBAD,0x0000,0x0000,0x0000,0xFBAF,0x0000,
	0x0000,0x0000,0xE0EA,0xCED6,0xB6D7,0xC8FC,0xC7CA,0x0000,0x0000,0x0000,0xE0EB,0x0000,0x0000,0x0000,0x0000,0xE0ED,
	0x0000,0xE0F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE0EC,0x0000,0x0000,0x0000,0xE0EF,0xB8EA,0xB1CD,0xE0F1,0x0000,0xBFF0,0xE0EE,
	0xCEDC,0x0000,0xFBB0,0xE0F4,0xF4A4,0x0000,0x0000,0x0000,0x0000,0xE0F2,0xE0F5,0x0000,0x0000,0x0000,0x0000,0xE0E7,
	0xE0F3,0x0000,0x0000,0xBABC,0x0000,0x0000,0xE0F6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0F7,0x0000,
	0x0000,0x0000,0x0000,0xCDFE,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBB1,0x0000,0xE0F8,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0F9,0xFBB2,
	0x0000,0x0000,0xE0E5,0x0000,0x0000,0x0000,0x0000,0xE0FA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xB4C4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBCA5,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE0FB,0x0000,0x0000,0x0000,0x0000,0xE0FC,
	0x0000,0x0000,0x0000,0x0000,0xE0FD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB1BB,0x0000,0x0000,0x0000,
	0xE1A1,0x0000,0xC9BB,0xE1A2,0x0000,0x0000,0xB4A4,0xE1A3,0x0000,0xE1A4,0x0000,0x0000,0x0000,0x0000,0xE1A5,0x0000,
	0xE1A7,0xE1A8,0xE1A6,0x0000,0x0000,0x0000,0xC9D3,0xE1AA,0xE1A9,
};
static const WORD _ucs_to_eucj_7500_data []={ //7501 75FF
	       0xFBB3,0x0000,0xE1AC,0xE1AB,0xE1AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1AE,0xE1B0,0xE1AF,0x0000,
	0x0000,0xB9F9,0x0000,0xE1B2,0x0000,0xE1B1,0x0000,0x0000,0xB4C5,0x0000,0xBFD3,0x0000,0xC5BC,0x0000,0xE1B3,0xC0B8,
	0x0000,0x0000,0x0000,0xBBBA,0x0000,0xB1F9,0xE1B4,0x0000,0xCDD1,0x0000,0x0000,0xCAE3,0xE1B5,0x0000,0x0000,0xF9EC,
	0xC5C4,0xCDB3,0xB9C3,0xBFBD,0x0000,0x0000,0x0000,0xC3CB,0xD2B4,0x0000,0xC4AE,0xB2E8,0xE1B6,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE1B7,0x0000,0xE1BC,0x0000,0x0000,0xE1BA,0xE1B9,0xDAC2,0xB3A6,0xE1B8,0x0000,0xB0DA,
	0x0000,0xC8AA,0x0000,0x0000,0xC8CA,0x0000,0x0000,0x0000,0x0000,0xCEB1,0xE1BD,0xE1BB,0xC3DC,0xC0A6,0x0000,0x0000,
	0xC8AB,0x0000,0xC9AD,0x0000,0xE1BF,0xCEAC,0xB7CD,0xE1C0,0x0000,0xE1BE,0xC8D6,0xE1C1,0x0000,0xE1C2,0x0000,0xFBB4,
	0xB0DB,0x0000,0x0000,0xBEF6,0xE1C7,0x0000,0xE1C4,0xC6ED,0xE1C3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5A6,
	0x0000,0x0000,0xE1CA,0x0000,0x0000,0x0000,0xE1C5,0xE1C6,0x0000,0xE1C9,0xE1C8,0xC9A5,0x0000,0x0000,0xC1C2,0xC1C1,
	0x0000,0xB5BF,0x0000,0x0000,0xE1CB,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1CC,0x0000,0x0000,0xE1CD,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE1CF,0x0000,0xE1CE,0x0000,0x0000,0x0000,0x0000,0x0000,0xB1D6,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE1D7,0xC8E8,0xE1D1,0x0000,0xE1D3,0x0000,0x0000,0xE1D5,0xBFBE,0x0000,0x0000,0xE1D6,0xE1D4,0xBCC0,0x0000,
	0x0000,0x0000,0xE1D0,0xE1D2,0x0000,0xC9C2,0x0000,0xBEC9,0x0000,0x0000,0xE1D9,0x0000,0x0000,0xE1D8,0x0000,0x0000,
	0x0000,0x0000,0xE1DA,0x0000,0xBCA6,0xBAAF,0x0000,0x0000,0xC5F7,0xE1DB,0x0000,0xC4CB,0x0000,0x0000,0xE1DD,0x0000,
	0x0000,0x0000,0xCEA1,0xE1DC,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE1E2,0x0000,0xE1E4,0xE1E5,0xC3D4,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1E3,0x0000,0xE1E0,0x0000,0xE1DE,0xE1DF,
};
static const WORD _ucs_to_eucj_7600_data []={ //7601 76FE
	       0xE1E1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1E8,0x0000,0xE1E6,0x0000,0xE1E7,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1E9,
	0xE1EB,0xE1EC,0xE1ED,0x0000,0xE1EE,0x0000,0x0000,0xE1EA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE1F0,0x0000,0x0000,0x0000,0xE1EF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE1F1,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCEC5,0x0000,0x0000,0x0000,0xE1F4,0xE1F2,0xE1F3,0x0000,0x0000,0x0000,0xB4E2,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCCFE,0x0000,0x0000,0x0000,0xCACA,0x0000,0xE1F6,0x0000,0x0000,0x0000,0xE1F5,0x0000,0x0000,0x0000,
	0x0000,0xE1F7,0xE1F8,0x0000,0x0000,0x0000,0x0000,0xE1FC,0xE1F9,0xE1FA,0xE1FB,0x0000,0xE1FD,0x0000,0x0000,0x0000,
	0xE1FE,0x0000,0xE2A1,0x0000,0x0000,0x0000,0xE2A2,0x0000,0xE2A3,0x0000,0xC8AF,0xC5D0,0xE2A4,0xC7F2,0xC9B4,0x0000,
	0xE2A5,0x0000,0xFBB5,0xE2A6,0xC5AA,0x0000,0xB3A7,0xB9C4,0xE2A7,0x0000,0x0000,0xE2A8,0x0000,0x0000,0xE2A9,0x0000,
	0xBBA9,0x0000,0x0000,0xE2AB,0x0000,0x0000,0xE2AA,0x0000,0x0000,0xE2AC,0xE2AD,0xFBB8,0xFBB6,0x0000,0xFBB7,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8E9,0x0000,
	0xE2AE,0x0000,0x0000,0x0000,0xE2AF,0x0000,0x0000,0xF3E9,0xE2B0,0xE2B1,0xE2B2,0x0000,0x0000,0x0000,0x0000,0xBBAE,
	0x0000,0x0000,0xE2B3,0xC7D6,0x0000,0x0000,0xCBDF,0x0000,0xB1CE,0x0000,0xB1D7,0x0000,0x0000,0xE2B4,0x0000,0x0000,
	0x0000,0x0000,0xE2B6,0x0000,0x0000,0x0000,0xE2B5,0xC5F0,0x0000,0x0000,0x0000,0xC0B9,0xDDB9,0x0000,0xE2B7,0xCCC1,
	0x0000,0xE2B8,0x0000,0xB4C6,0xC8D7,0xE2B9,0x0000,0xE2BA,0x0000,0x0000,0xE2BB,0x0000,0x0000,0x0000,0xCCDC,0x0000,
	0x0000,0x0000,0xCCD5,0x0000,0xC4BE,0x0000,0x0000,0x0000,0xC1EA,0x0000,0x0000,0xE2BD,0x0000,0x0000,0xBDE2,
};
static const WORD _ucs_to_eucj_7700_data []={ //7701 77FC
	       0xBECA,0x0000,0x0000,0xE2C0,0x0000,0x0000,0xE2BF,0xE2BE,0xC8FD,0x0000,0xB4C7,0xB8A9,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2C6,0x0000,0x0000,0xE2C3,0xBFBF,
	0xCCB2,0x0000,0x0000,0x0000,0xE2C2,0xE2C4,0xE2C5,0x0000,0x0000,0xE2C1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2C7,0xE2C8,0x0000,0xC4AF,0x0000,0xB4E3,0x0000,0x0000,0x0000,
	0xC3E5,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBBB,0xE2C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2CA,0xE2CD,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xBFE7,0x0000,0xC6C4,0x0000,0xE2CE,0xCBD3,0x0000,0xE2CB,0x0000,0x0000,0xE2CC,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2D1,0x0000,0x0000,0x0000,0x0000,0xE2D0,0xE2CF,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2D3,0x0000,0x0000,0xE2D2,0x0000,
	0x0000,0xE2D4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2D6,0x0000,
	0xE2D5,0x0000,0x0000,0x0000,0x0000,0xCACD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBDD6,0xCEC6,0x0000,0x0000,
	0xE2D7,0x0000,0x0000,0xC6B7,0x0000,0x0000,0xE2D8,0x0000,0x0000,0xE2D9,0x0000,0xE2DD,0xE2DB,0xE2DC,0x0000,0xE2DA,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2DE,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2DF,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2E0,0x0000,0x0000,0xE2E1,0xCCB7,0xE2E2,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCCF0,0xE2E3,0x0000,0xC3CE,0x0000,0xC7EA,0x0000,0xB6EB,0x0000,0x0000,0x0000,0xC3BB,0xE2E4,0xB6BA,
	0x0000,0x0000,0x0000,0xC0D0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2E5,
};
static const WORD _ucs_to_eucj_7800_data []={ //7802 78FD
	              0xBABD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2E6,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE2E7,0x0000,0xB8A6,0xBAD5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE2E9,0xFBBD,0x0000,0x0000,0x0000,0xC5D6,0xBAD6,0xB5CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCBA4,0x0000,0xC7CB,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5D7,0x0000,0x0000,0x0000,0x0000,0xB9DC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE2EB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBBE,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBECB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xFBBF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCEB2,0xB9C5,0x0000,0x0000,0xB8A7,
	0x0000,0x0000,0xC8A3,0x0000,0xE2ED,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBC0,0x0000,0xE2EF,0x0000,0x0000,0x0000,
	0x0000,0xB8EB,0x0000,0x0000,0x0000,0x0000,0xE2EE,0xC4F6,0x0000,0x0000,0x0000,0x0000,0xE2F1,0xB3B7,0xE2EC,0x0000,
	0x0000,0xC8EA,0x0000,0xB1B0,0x0000,0xBAEC,0x0000,0xCFD2,0x0000,0x0000,0xE2F0,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE2F2,0x0000,0x0000,0x0000,0xCACB,0x0000,0xC0D9,0xE2F4,0x0000,0x0000,0x0000,0x0000,0xE2F5,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE2F3,0x0000,0x0000,0x0000,0x0000,0xB3CE,0x0000,0xE2FB,0x0000,0xE2FA,0x0000,
	0x0000,0xBCA7,0x0000,0x0000,0x0000,0xE2FC,0xE2F7,0x0000,0x0000,0x0000,0xE2FD,0xE2F8,0x0000,0x0000,0x0000,0x0000,
	0xC8D8,0xE2F6,0x0000,0x0000,0xE2F9,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3A2,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3A1,0xCBE1,0x0000,0x0000,0x0000,0xE2FE,0x0000,0x0000,0xB0EB,
	0x0000,0x0000,0x0000,0x0000,0xE3A4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3A3,
};
static const WORD _ucs_to_eucj_7900_data []={ //7901 79FB
	       0xBECC,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3A5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1C3,0x0000,
	0x0000,0xE3A7,0xE3A6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3A8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE2E8,0x0000,0x0000,0x0000,0xE2EA,0xE3AA,0xE3A9,0x0000,0x0000,0x0000,
	0xFBC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBCA8,0x0000,0xCEE9,0x0000,0xBCD2,0x0000,
	0xE3AB,0xB7B7,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5C0,0xB5A7,0xBBE3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xCDB4,0x0000,0x0000,0xE3B1,0x0000,0xE3B0,0xC1C4,0xE3AD,0x0000,0x0000,0xE3AF,0x0000,0x0000,0xBDCB,0xBFC0,0xE3AE,
	0xE3AC,0x0000,0xC7AA,0x0000,0x0000,0xBECD,0x0000,0x0000,0xC9BC,0x0000,0x0000,0x0000,0x0000,0xBAD7,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5F8,0x0000,0x0000,0xE3B2,0x0000,0x0000,0x0000,0x0000,0xE3B3,
	0xE3C9,0xB6D8,0x0000,0x0000,0xCFBD,0xC1B5,0x0000,0x0000,0x0000,0x0000,0xE3B4,0x0000,0x0000,0xB2D2,0xC4F7,0xCAA1,
	0x0000,0x0000,0x0000,0x0000,0xFBC5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBC7,0x0000,0xE3B5,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5FA,0xE3B6,0x0000,0x0000,0xE3B8,0x0000,0x0000,0x0000,0xE3B9,0x0000,
	0xC7A9,0x0000,0x0000,0xE3BA,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3BB,0xE3BC,0x0000,0x0000,0xB6D9,0xB2D3,0xC6C5,
	0xBDA8,0xBBE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3BD,0x0000,0xBDA9,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB2CA,0xC9C3,0x0000,0x0000,0xE3BE,0x0000,0x0000,0xC8EB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1C5,
	0x0000,0xE3C1,0x0000,0xE3C2,0xC7E9,0x0000,0xBFC1,0xE3BF,0x0000,0xC3E1,0x0000,0x0000,0xE3C0,0x0000,0x0000,0x0000,
	0xBECE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB0DC,
};
static const WORD _ucs_to_eucj_7A00_data []={ //7A00 7AFF
	0xB5A9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3C3,0x0000,0x0000,0xC4F8,0x0000,0xE3C4,0xC0C7,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xCCAD,0x0000,0x0000,0xC9A3,0xE3C5,0xE3C6,0xC3D5,0x0000,0xCEC7,0x0000,0x0000,0xE3C8,
	0xE3C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBCEF,0x0000,
	0x0000,0xE3CA,0xB0F0,0x0000,0x0000,0x0000,0x0000,0xE3CD,0x0000,0x0000,0x0000,0xE3CB,0xB2D4,0xB7CE,0xE3CC,0xB9C6,
	0xB9F2,0x0000,0xCAE6,0xE3CE,0x0000,0x0000,0xCBD4,0x0000,0x0000,0xE3D0,0x0000,0x0000,0x0000,0xC0D1,0xB1CF,0xB2BA,
	0xB0AC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3CF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE3D1,0xE3D2,0xBEF7,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3D3,0x0000,0xB3CF,0x0000,0x0000,0x0000,0x0000,
	0xE3D5,0x0000,0x0000,0x0000,0xB7EA,0x0000,0xB5E6,0x0000,0x0000,0xE3D6,0xB6F5,0x0000,0x0000,0xE3D7,0x0000,0xC0FC,
	0x0000,0xC6CD,0x0000,0xC0E0,0xBAF5,0x0000,0x0000,0x0000,0xE3D8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC3E2,0xC1EB,0x0000,0xE3DA,0xE3DC,0xE3D9,0xE3DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7A2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3DD,0xB7A6,0x0000,0x0000,0x0000,0xB5E7,0xCDD2,
	0xE3DF,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3E0,0x0000,0x0000,0x0000,0xB1AE,0x0000,0x0000,0x0000,0x0000,0xE3E3,
	0x0000,0x0000,0x0000,0xB3F6,0xE3E2,0xE3E1,0x0000,0xE3E5,0xE3DE,0x0000,0xE3E6,0xCEA9,0x0000,0xE3E7,0x0000,0xE3E8,
	0x0000,0xFBC8,0xD4F4,0xE3EA,0x0000,0xE3E9,0x0000,0x0000,0x0000,0xE3EB,0xE3EC,0x0000,0xCEB5,0xE3ED,0x0000,0xF0EF,
	0xBECF,0xE3EE,0xE3EF,0xBDD7,0x0000,0xC6B8,0xE3F0,0xFBC9,0x0000,0x0000,0xC3A8,0xFBCB,0x0000,0xE3F1,0x0000,0xC3BC,
	0xE3F2,0x0000,0x0000,0x0000,0x0000,0x0000,0xB6A5,0x0000,0xD1BF,0xC3DD,0xBCB3,0x0000,0x0000,0x0000,0x0000,0xB4C8,
};
static const WORD _ucs_to_eucj_7B00_data []={ //7B02 7BF7
	              0xE3F3,0x0000,0xE4A2,0x0000,0xE3F6,0x0000,0xB5E8,0x0000,0xE3F5,0xE4A4,0x0000,0x0000,0x0000,0xE3F4,
	0x0000,0xBED0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE3F8,0xE3F9,0x0000,0xC5AB,0x0000,0x0000,0xE3FA,0x0000,
	0xB3DE,0x0000,0x0000,0x0000,0x0000,0xBFDA,0xC9E4,0x0000,0xE3FC,0x0000,0x0000,0x0000,0xC2E8,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE3F7,0x0000,0xE3FB,0xE3FD,0x0000,0x0000,0xBAFB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE4A6,0xC9AE,0x0000,0xC8A6,0xC5F9,0x0000,0xB6DA,0xE4A5,0xE4A3,0x0000,0xC8B5,
	0xE3FE,0xC3DE,0xC5FB,0x0000,0xC5FA,0x0000,0xBAF6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4B8,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE4A8,0x0000,0xE4AA,0x0000,0x0000,0x0000,0x0000,0xE4AD,0x0000,0xE4AE,0x0000,
	0xE4AB,0xE4AC,0x0000,0x0000,0xE4A9,0xE4A7,0x0000,0x0000,0x0000,0x0000,0xE4A1,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCACF,0xB2D5,0x0000,0x0000,0x0000,0xE4B5,0x0000,0xE4B2,0x0000,0xE4B7,
	0x0000,0x0000,0xE4B6,0x0000,0xC7F3,0xCCA7,0x0000,0xBBBB,0xE4B0,0xE4B9,0xE4B4,0x0000,0xE4B3,0xE4AF,0xFBCC,0xE4B1,
	0x0000,0xB4C9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC3BD,0x0000,0x0000,0xC0FD,0x0000,0x0000,
	0x0000,0xC8A2,0x0000,0x0000,0xE4BE,0x0000,0x0000,0x0000,0xC8A4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xC0E1,0xE4BB,0x0000,0x0000,0xC8CF,0x0000,0xE4BF,0xCAD3,0x0000,0xC3DB,0x0000,0xE4BA,0xE4BC,0x0000,0x0000,0xE4BD,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4C0,0x0000,0x0000,
	0xBCC4,0x0000,0x0000,0x0000,0xC6C6,0xE4C5,0xE4C4,0x0000,0x0000,0xE4C1,0x0000,0x0000,0x0000,0xCFB6,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE4CA,0x0000,0x0000,0xE4CE,0xE4CB,
};
static const WORD _ucs_to_eucj_7C00_data []={ //7C00 7CFE
	0xE4C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4C8,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4CD,0x0000,0x0000,
	0x0000,0xE4C2,0xD2D5,0xE4C9,0xE4C3,0x0000,0x0000,0xE4CC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4D2,
	0x0000,0xB4CA,0x0000,0xE4CF,0x0000,0x0000,0x0000,0xE4D0,0x0000,0x0000,0xE4D1,0xE4D4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4D3,0xC8F6,0x0000,0x0000,0x0000,0x0000,0xE4D5,0xCEFC,0xCAED,
	0xE4DA,0x0000,0x0000,0xE4D7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4D6,0xC0D2,0x0000,0xE4D9,
	0xE4DB,0x0000,0x0000,0x0000,0xE4D8,0x0000,0xE4DF,0x0000,0xE4DC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4DD,
	0xE4C6,0x0000,0x0000,0x0000,0xE4DE,0xE4E0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4E1,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xCAC6,0x0000,0xE4E2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCCE2,0x0000,
	0x0000,0xB6CE,0xB7A9,0xE4E3,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAB4,0x0000,0xBFE8,0x0000,0xCCB0,0x0000,0x0000,
	0xE4E4,0x0000,0xCEB3,0x0000,0x0000,0xC7F4,0x0000,0xC1C6,0xC7B4,0x0000,0x0000,0xBDCD,0x0000,0x0000,0x0000,0xB0C0,
	0x0000,0xE4E9,0xE4E7,0x0000,0xE4E5,0xB4A1,0x0000,0xBED1,0xE4EA,0x0000,0x0000,0xE4E8,0x0000,0xE4E6,0xE4EE,0x0000,
	0x0000,0xE4ED,0xE4EC,0xE4EB,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4EF,0x0000,0x0000,0x0000,0xE4F0,0xC0BA,0x0000,
	0xE4F1,0x0000,0xE4F3,0x0000,0x0000,0xE4F2,0x0000,0x0000,0x0000,0x0000,0xB8D2,0x0000,0x0000,0x0000,0xC1B8,0x0000,
	0x0000,0x0000,0xE4F5,0x0000,0x0000,0x0000,0xC5FC,0x0000,0xE4F4,0x0000,0x0000,0x0000,0xE4F6,0x0000,0xCAB5,0xC1EC,
	0xB9C7,0x0000,0xE4F7,0x0000,0x0000,0x0000,0x0000,0xCEC8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4F9,
	0x0000,0x0000,0xE4FA,0x0000,0xE4FB,0x0000,0xE4FC,0x0000,0xBBE5,0x0000,0xE4FD,0xB7CF,0x0000,0x0000,0xB5EA,
};
static const WORD _ucs_to_eucj_7D00_data []={ //7D00 7DFB
	0xB5AA,0x0000,0xE5A1,0x0000,0xCCF3,0xB9C8,0xE4FE,0x0000,0x0000,0x0000,0xE5A4,0xCCE6,0x0000,0xC7BC,0x0000,0x0000,
	0xC9B3,0x0000,0x0000,0x0000,0xBDE3,0xE5A3,0x0000,0xBCD3,0xB9C9,0xBBE6,0xB5E9,0xCAB6,0xE5A2,0x0000,0x0000,0x0000,
	0xC1C7,0xCBC2,0xBAF7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBBE7,0xC4DD,0x0000,0xE5A7,0xCEDF,
	0xBAD9,0x0000,0xE5A8,0xBFC2,0x0000,0xE5AA,0x0000,0x0000,0x0000,0xBED2,0xBAB0,0x0000,0x0000,0x0000,0x0000,0xE5A9,
	0x0000,0x0000,0xBDAA,0xB8BE,0xC1C8,0xE5A5,0xE5AB,0x0000,0xFBCE,0x0000,0x0000,0xE5A6,0xB7D0,0x0000,0xE5AE,0xE5B2,
	0xB7EB,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5AD,0x0000,0x0000,0x0000,0x0000,0xE5B6,0xFBCF,0x0000,0xB9CA,0x0000,
	0x0000,0xCDED,0xB0BC,0xE5B3,0x0000,0x0000,0xB5EB,0x0000,0xE5B0,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5B1,0x0000,
	0x0000,0xC5FD,0xE5AF,0xE5AC,0x0000,0xB3A8,0xC0E4,0x0000,0x0000,0xB8A8,0x0000,0x0000,0x0000,0xE5B8,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5B5,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5B7,
	0x0000,0x0000,0x0000,0xE5B4,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7D1,0xC2B3,0xE5B9,0xC1EE,0x0000,0x0000,0xE5C6,
	0xFBD1,0x0000,0xE5C2,0xE5BC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5C0,0xBCFA,0xB0DD,0xE5BB,0xE5C3,
	0xE5C7,0xB9CB,0xCCD6,0x0000,0xC4D6,0xE5BD,0x0000,0xFBD0,0xE5C5,0x0000,0xE5BA,0xC3BE,0x0000,0xE5BF,0xB0BD,0xCCCA,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5BE,0x0000,0x0000,0xB6DB,0xC8EC,0x0000,0x0000,0x0000,0xC1ED,
	0x0000,0xCED0,0xBDEF,0x0000,0x0000,0xE5EE,0xFBD2,0x0000,0xE5C8,0x0000,0xC0FE,0x0000,0xE5C4,0xE5C9,0xE5CB,0x0000,
	0xC4F9,0xE5CE,0x0000,0x0000,0xE5CA,0x0000,0x0000,0x0000,0xCAD4,0xB4CB,0x0000,0x0000,0xCCCB,0x0000,0x0000,0xB0DE,
	0x0000,0x0000,0xE5CD,0x0000,0xCEFD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5CC,
};
static const WORD _ucs_to_eucj_7E00_data []={ //7E01 7E9C
	       0xB1EF,0x0000,0x0000,0xC6EC,0xE5CF,0x0000,0x0000,0x0000,0xE5D6,0xE5D0,0xE5D7,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE5D3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7FB,0x0000,0x0000,0xBCCA,0xE5D5,
	0x0000,0xE5D2,0xE5D8,0xE5D1,0x0000,0x0000,0xBDC4,0x0000,0x0000,0x0000,0x0000,0xCBA5,0x0000,0x0000,0xBDCC,0x0000,
	0x0000,0xE5D4,0xE5E0,0x0000,0x0000,0xE5DC,0x0000,0xE5DF,0x0000,0xE5DD,0xE5E1,0xE5DB,0x0000,0xE5C1,0xC0D3,0x0000,
	0x0000,0xC8CB,0x0000,0xE5DE,0x0000,0x0000,0xE5D9,0x0000,0x0000,0x0000,0xC1A1,0xB7D2,0x0000,0xBDAB,0x0000,0x0000,
	0x0000,0x0000,0xFBD3,0x0000,0xBFA5,0xC1B6,0xE5E4,0x0000,0x0000,0xE5E6,0xE5E7,0x0000,0x0000,0xE5E3,0xE5E5,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5DA,0xE5E2,0x0000,0xE5EA,0xE5E9,0x0000,0x0000,0xCBFA,0x0000,0x0000,
	0xB7AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE5E8,0x0000,0xE5EC,0xE5EB,0xE5EF,0x0000,0xE5F1,
	0x0000,0x0000,0xBBBC,0xE5ED,0x0000,0x0000,0x0000,0x0000,0xE5F2,0xE5F3,0xF9A1,0x0000,0xE5F4,0x0000,0xE5FA,0xC5BB,
	0xE5F6,0x0000,0xE5F5,0xE5F7,0xE5F8,0x0000,0xE5F9,0x0000,0x0000,0x0000,0x0000,0xE5FB,0xE5FC,
};
static const WORD _ucs_to_eucj_7F00_data []={ //7F36 7FFC
	                                          0xB4CC,0x0000,0xE5FD,0x0000,0xE5FE,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE6A1,0x0000,0xFBD4,0x0000,0x0000,0x0000,0x0000,0xE6A2,0xE6A3,0xE6A4,0x0000,
	0xE6A5,0xE6A6,0x0000,0x0000,0xE6A8,0xE6A7,0x0000,0x0000,0xE6A9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6AA,
	0xE6AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6AE,0xE6AC,0xE6AD,0xBAE1,0xB7D3,0x0000,0x0000,0xC3D6,0x0000,
	0xC8B3,0x0000,0xBDF0,0x0000,0x0000,0xC7CD,0x0000,0xC8ED,0xE6AF,0xD8ED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE6B0,0xE6B2,0x0000,0xCDE5,0xE6B1,0xE6B4,0xE6B3,0x0000,0xCDD3,0x0000,0xE6B5,0x0000,0xC8FE,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE6B6,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6B9,0x0000,0x0000,0xE6B8,0xE6B7,0x0000,
	0x0000,0xFBD5,0x0000,0xE6BA,0xB7B2,0x0000,0x0000,0x0000,0xC1A2,0xB5C1,0x0000,0x0000,0x0000,0x0000,0xE6BE,0xE6BB,
	0x0000,0x0000,0xE6BC,0x0000,0x0000,0x0000,0xE6BF,0x0000,0xE6C0,0xE6BD,0x0000,0x0000,0x0000,0xB1A9,0x0000,0x0000,
	0x0000,0xB2A7,0x0000,0x0000,0x0000,0xE6C2,0xE6C3,0x0000,0x0000,0x0000,0xE6C4,0x0000,0xCDE2,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xBDAC,0x0000,0xE6C6,0xE6C5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xBFE9,0xE6C7,0x0000,0x0000,0x0000,0x0000,0xE6C8,0x0000,0x0000,0xE6C9,0x0000,0xB4E5,0x0000,0x0000,0x0000,0x0000,
	0xB4CD,0x0000,0x0000,0xE6CA,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6CB,0x0000,0xCBDD,0xCDE3,
};
static const WORD _ucs_to_eucj_8000_data []={ //8000 80FD
	0xCDD4,0xCFB7,0x0000,0xB9CD,0xE6CE,0xBCD4,0xE6CD,0x0000,0x0000,0x0000,0x0000,0xE6CF,0xBCA9,0x0000,0x0000,0x0000,
	0xC2D1,0x0000,0xE6D0,0x0000,0x0000,0xB9CC,0x0000,0xCCD7,0xE6D1,0xE6D2,0x0000,0x0000,0xE6D3,0x0000,0x0000,0x0000,
	0x0000,0xE6D4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6D5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xBCAA,0x0000,0x0000,0xCCED,0x0000,0x0000,0x0000,0x0000,0xE6D7,0x0000,0xC3BF,0x0000,0xE6D6,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6D9,0x0000,0x0000,0x0000,0xE6D8,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE6DA,0x0000,0x0000,0x0000,0xC0BB,0x0000,0xE6DB,0x0000,0xE6DC,0x0000,0x0000,0x0000,0xCAB9,0xE6DD,
	0x0000,0xC1EF,0xE6DE,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6DF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCEFE,
	0xE6E2,0x0000,0xE6E1,0xE6E0,0xC4B0,0x0000,0xE6E3,0xBFA6,0x0000,0xE6E4,0x0000,0x0000,0x0000,0xE6E5,0xCFB8,0xE6E6,
	0x0000,0x0000,0x0000,0x0000,0xE6E7,0xE6E9,0xE6E8,0xC8A5,0x0000,0xC6F9,0x0000,0xCFBE,0xC8A9,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE6EB,0x0000,0x0000,0xBED3,0x0000,0xC9AA,0x0000,0xE6EC,0xE6EA,0x0000,0xB4CE,0x0000,0x0000,
	0x0000,0xB8D4,0xBBE8,0x0000,0x0000,0xC8EE,0x0000,0x0000,0x0000,0xB8AA,0xCBC3,0x0000,0xE6EF,0xE6ED,0x0000,0xB9CE,
	0x0000,0xB9CF,0xB0E9,0x0000,0xBAE8,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7D9,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xB0DF,0xE6F4,0x0000,0xC3C0,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7D8,0x0000,0xC2DB,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6F6,0x0000,0x0000,0xE6F2,0xE6F5,0xE6F0,0x0000,0xE6F3,0xCBA6,0x0000,
	0x0000,0xB8D5,0x0000,0x0000,0xB0FD,0xE6F1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6F8,
	0x0000,0xE6F9,0x0000,0x0000,0xC6B9,0x0000,0x0000,0x0000,0xB6BB,0x0000,0x0000,0x0000,0xE7A6,0xC7BD,
};
static const WORD _ucs_to_eucj_8100_data []={ //8102 81FE
	              0xBBE9,0x0000,0x0000,0xB6BC,0xC0C8,0xCFC6,0xCCAE,0xE6F7,0xC0D4,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5D3,0xE6FA,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE6FC,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6FB,0x0000,0x0000,0x0000,0x0000,0x0000,0xE6FD,
	0x0000,0xC3A6,0x0000,0xC7BE,0x0000,0x0000,0x0000,0x0000,0x0000,0xC4B1,0x0000,0x0000,0x0000,0x0000,0xE7A3,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7A2,0x0000,0x0000,0x0000,0x0000,0xE6FE,0x0000,0x0000,0xBFD5,0x0000,
	0xC9E5,0xE7A5,0x0000,0xE7A4,0xB9D0,0xCFD3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7B5,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE7A9,0xE7AA,0x0000,0x0000,0x0000,0x0000,0xBCF0,0x0000,0x0000,0xE7A8,0x0000,
	0xB9F8,0xE7A7,0x0000,0x0000,0xE7AB,0x0000,0x0000,0x0000,0xC4B2,0xCAA2,0xC1A3,0x0000,0x0000,0x0000,0x0000,0xC2DC,
	0xE7AF,0x0000,0xE7B0,0xE7AC,0x0000,0x0000,0x0000,0x0000,0xE7AD,0x0000,0xE7AE,0x0000,0x0000,0x0000,0x0000,0xB9D1,
	0x0000,0x0000,0x0000,0xE7B6,0x0000,0xE7B2,0x0000,0x0000,0x0000,0x0000,0xC9E6,0x0000,0xCBEC,0xC9A8,0x0000,0x0000,
	0xE7B1,0x0000,0x0000,0xE7B4,0xE7B3,0x0000,0x0000,0x0000,0xCBC4,0xE7B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE7B8,0x0000,0x0000,0xC1B7,0x0000,0xE7B9,0x0000,0x0000,0xE7BB,0x0000,0xE7BF,0x0000,0x0000,0xE7BC,0xE7BA,0xC7BF,
	0xE7BD,0x0000,0xE7BE,0x0000,0x0000,0x0000,0xB2B2,0x0000,0xE7C5,0xE7C0,0x0000,0x0000,0x0000,0xE7C1,0x0000,0x0000,
	0x0000,0xE7C2,0x0000,0xC2A1,0x0000,0x0000,0x0000,0x0000,0xE7C4,0xE7C3,0xE7C6,0x0000,0x0000,0x0000,0x0000,0xE7C7,
	0xE7C8,0x0000,0x0000,0xBFC3,0x0000,0xB2E9,0x0000,0xE7C9,0xCED7,0x0000,0xBCAB,0x0000,0x0000,0xBDAD,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xBBEA,0xC3D7,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7CA,0xE7CB,0xB1B1,0x0000,0xE7CC,
};
static const WORD _ucs_to_eucj_8200_data []={ //8201 82FB
	       0xE7CD,0xE7CE,0x0000,0x0000,0xE7CF,0x0000,0xE7D0,0xB6BD,0xDAAA,0xE7D1,0x0000,0xC0E5,0xE7D2,0xBCCB,0x0000,
	0xE7D3,0x0000,0xD0B0,0x0000,0x0000,0x0000,0xE7D4,0xCADE,0xB4DC,0x0000,0x0000,0xC1A4,0xBDD8,0x0000,0xC9F1,0xBDAE,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7D5,0xB9D2,0xE7D6,0xC8CC,0x0000,0xE7E4,0x0000,
	0x0000,0x0000,0x0000,0xE7D8,0x0000,0xC2C9,0xC7F5,0xB8BF,0xE7D7,0xC1A5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE7D9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC4FA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7DB,0xE7DA,0xE7DD,0x0000,0x0000,0xE7DC,0x0000,0xE7DE,
	0x0000,0x0000,0xE7E0,0x0000,0xE7DF,0x0000,0xB4CF,0x0000,0xE7E1,0x0000,0xE7E2,0xE7E3,0x0000,0x0000,0xBAB1,0xCEC9,
	0x0000,0xE7E5,0xBFA7,0x0000,0x0000,0x0000,0xB1F0,0xE7E6,0xE7E7,0x0000,0x0000,0x0000,0x0000,0x0000,0xE7E8,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB0F2,0x0000,0xE7E9,0x0000,0x0000,
	0x0000,0x0000,0xE7EA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC9E7,0x0000,0x0000,0x0000,0xBCC7,0x0000,0xE7EC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xB3A9,0xB0B2,0x0000,0x0000,0x0000,0x0000,0xE7EB,0xE7EE,0xC7CE,0x0000,0xBFC4,
	0x0000,0xB2D6,0x0000,0xCBA7,0x0000,0x0000,0x0000,0x0000,0xB7DD,0xB6DC,0x0000,0xE7ED,0x0000,0xB2EA,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xB4A3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB1F1,0xE7F2,0xCEEA,0xC2DD,0x0000,0x0000,0xC9C4,0x0000,0xE7FE,0x0000,0xB2D7,0xE7FC,0x0000,0xE7FA,0xE7F1,
	0x0000,0xE7EF,0x0000,0xE7F0,0x0000,0xBCE3,0xB6EC,0xC3F7,0x0000,0x0000,0x0000,0xC6D1,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB1D1,0x0000,0xE7F4,0xE7F3,0x0000,0x0000,0x0000,0x0000,0xE7F9,0xE7F5,0xE7F8,
};
static const WORD _ucs_to_eucj_8300_data []={ //8301 83FD
	       0xFBD7,0xCCD0,0xE7F7,0xB2D8,0xB3FD,0xE7FB,0x0000,0x0000,0xE7FD,0x0000,0x0000,0x0000,0x0000,0xB7D4,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8A3,0xE8AC,0xE8AD,0x0000,0x0000,0x0000,0xB0AB,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE8B4,0x0000,0x0000,0x0000,0x0000,0xB0F1,0x0000,0x0000,0xE8AB,0x0000,0x0000,0x0000,0xE8AA,
	0x0000,0xE8A5,0xE8A4,0x0000,0xE8A2,0xE8A1,0xC3E3,0x0000,0xC2FB,0xE8A7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE8A6,0x0000,0x0000,0x0000,0x0000,0xE8A9,0x0000,0x0000,0x0000,0xC1F0,0xB7D5,0x0000,0x0000,0x0000,0x0000,0xB1C1,
	0xE8A8,0x0000,0xB9D3,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1F1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xFBD8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE8BA,0x0000,0xE8BB,0x0000,0xB2D9,0x0000,0x0000,0x0000,0xB2AE,0xE8B8,0x0000,0x0000,0xFBD9,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE8AE,0x0000,0xE8B6,0x0000,0xE8BD,0xE8B7,0x0000,0x0000,0x0000,0xE8B5,0x0000,
	0x0000,0x0000,0x0000,0xE7F6,0x0000,0x0000,0xE8B3,0x0000,0x0000,0x0000,0xE8AF,0x0000,0x0000,0x0000,0xB4D0,0xE8B1,
	0xE8BC,0x0000,0xE8B2,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8BE,0x0000,0xE8B0,0xC7FC,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xCDE9,0x0000,0x0000,0x0000,0xE8B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8CF,0x0000,0x0000,
	0x0000,0xE8C7,0x0000,0x0000,0x0000,0xBFFB,0x0000,0xFBDA,0x0000,0x0000,0xB5C6,0x0000,0xB6DD,0x0000,0xE8C2,0x0000,
	0x0000,0x0000,0x0000,0xB2DB,0x0000,0x0000,0xBED4,0x0000,0xE8C5,0x0000,0x0000,0x0000,0xBADA,0x0000,0x0000,0xC5D1,
	0xE8CA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAEE,0x0000,0xE8C1,0x0000,0x0000,0x0000,0xB2DA,
	0xB8D6,0xC9A9,0xE8CB,0x0000,0xE8BF,0x0000,0xFBDB,0xE8C8,0x0000,0x0000,0x0000,0xE8D2,0x0000,0xE8C3,
};
static const WORD _ucs_to_eucj_8400_data []={ //8403 84FF
	                     0xE8C4,0xC6BA,0x0000,0x0000,0xE8C9,0x0000,0x0000,0x0000,0xE8C6,0xCBA8,0xE8CC,0xB0E0,0x0000,
	0x0000,0x0000,0x0000,0xE8C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE8CE,0x0000,0xE8CD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7EB,0xE8D4,0x0000,0xE8DF,0x0000,0x0000,0x0000,
	0x0000,0xB3FE,0x0000,0x0000,0x0000,0xE8E2,0x0000,0x0000,0xE8D0,0x0000,0x0000,0x0000,0xE8D5,0xCDEE,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8DE,0x0000,0xFBDC,0xCDD5,0x0000,0x0000,0x0000,0x0000,0xCEAA,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC3F8,0x0000,0x0000,0x0000,0xB3EB,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xC9F2,0xE8E4,0xC6A1,0x0000,0x0000,0xB0B1,0x0000,0x0000,0xE8DD,0x0000,0xE8D9,0xC1F2,0xE8D3,0xE8DB,0xE8E0,
	0x0000,0xC7AC,0x0000,0x0000,0x0000,0xB0AA,0x0000,0xE8D8,0x0000,0xE8E1,0xC9F8,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE8DC,0x0000,0xE8D7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBED5,0x0000,0x0000,0x0000,0x0000,
	0xBDAF,0x0000,0x0000,0x0000,0xBCAC,0x0000,0x0000,0x0000,0x0000,0xCCD8,0x0000,0x0000,0xC9C7,0x0000,0x0000,0xE8E7,
	0x0000,0xE8F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8DA,0x0000,0x0000,
	0x0000,0x0000,0xB3F7,0x0000,0xFBDD,0x0000,0x0000,0x0000,0xBEF8,0xE8E5,0x0000,0xE8EA,0xC1F3,0x0000,0x0000,0xE8E6,
	0x0000,0xE8ED,0x0000,0x0000,0xC3DF,0x0000,0xE8EE,0x0000,0x0000,0xCDD6,0xE8E3,0xB3B8,0x0000,0xE8E9,0x0000,0x0000,
	0xE8EC,0xCCAC,0x0000,0x0000,0x0000,0x0000,0xE8EF,0x0000,0x0000,0xE8E8,0xE8EB,0x0000,0xF9A5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCBA9,0x0000,0xCFA1,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE8F3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8FA,0x0000,0x0000,0xE8F2,
};
static const WORD _ucs_to_eucj_8500_data []={ //8500 85FE
	0xBCC3,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8D1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xCACE,0x0000,0xCCA2,0xE8F9,0xE8F8,0x0000,0xE8F4,0xE8F5,0x0000,0xB1B6,0x0000,0x0000,0x0000,0x0000,0xE8F7,
	0x0000,0xE8F1,0x0000,0x0000,0x0000,0x0000,0xC4D5,0x0000,0x0000,0x0000,0x0000,0x0000,0xE8F6,0xB0FE,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xC2A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAC3,0x0000,0x0000,
	0xE8FB,0xE9A1,0x0000,0xC8D9,0x0000,0x0000,0x0000,0x0000,0xE8FE,0xBED6,0xBCC9,0xE9A3,0x0000,0x0000,0xB6BE,0x0000,
	0x0000,0x0000,0x0000,0xFBDE,0x0000,0xE9A4,0x0000,0xC9F9,0xE8FD,0xFBDF,0xE8D6,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE8FC,0x0000,0x0000,0x0000,0x0000,0xCFCF,0xC6A2,0xC9F3,0xFBE0,0x0000,0xE9AB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9B1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9B2,0x0000,
	0xE9A5,0x0000,0x0000,0x0000,0xC7F6,0x0000,0x0000,0xE9AF,0xE9A7,0x0000,0xE9A9,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xE9B3,0xE9A8,0x0000,0x0000,0xE9AC,0x0000,0x0000,0xB1F2,0x0000,0xC6E5,0x0000,0xE9AD,0xE9B0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE9A6,0x0000,0xC1A6,0x0000,0xE9AA,0xBBA7,0xBFC5,0xB7B0,0xCCF4,0x0000,0xCCF9,0xBDF2,
	0xFBE2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9B7,0xE9B5,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xCFCE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9B4,0x0000,0x0000,0x0000,0xCDF5,0x0000,0xE9B6,
	0xE9B8,0x0000,0x0000,0x0000,0x0000,0xE9B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9BC,0xE9BA,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xC6A3,0xE9BB,0x0000,0x0000,0x0000,0xC8CD,0xE9AE,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBDF3,0x0000,0xE9BD,0xE9C2,0xC1F4,0x0000,0x0000,0xE9C1,
};
static const WORD _ucs_to_eucj_8600_data []={ //8602 86FE
	              0xE9A2,0x0000,0x0000,0x0000,0xE9C3,0xC1C9,0x0000,0x0000,0xE9BE,0xE9C0,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE9BF,0x0000,0x0000,0xDDB1,0xDDA2,0x0000,0x0000,0xE9C5,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xE9C4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDF6,0x0000,0xE2BC,
	0xE9C6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9C7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9C8,0xB8D7,0x0000,
	0xB5D4,0x0000,0x0000,0x0000,0xE9CA,0xD1DD,0x0000,0x0000,0x0000,0x0000,0xB5F5,0x0000,0xCEBA,0x0000,0xB6F3,0xE9CB,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9CC,0x0000,0x0000,0x0000,0xC3EE,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xE9CD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC6FA,0x0000,0xB0BA,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2E3,0xE9D2,0xE9D3,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE9CE,0x0000,0xBBBD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xE9CF,0xC7C2,0x0000,0x0000,0x0000,0x0000,0xE9D0,0xE9D1,0xE9DB,0x0000,0x0000,0x0000,0xE9D5,
	0xE9D8,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9D4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE9D6,0x0000,0xE9D7,0xBCD8,0x0000,0xE9D9,0x0000,0xC3C1,0x0000,0xB7D6,0xB3C2,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE9DC,0x0000,0x0000,0x0000,0x0000,0xB3BF,0x0000,0xE9E1,0x0000,0x0000,0xE9DD,0xE9E0,
	0x0000,0x0000,0x0000,0x0000,0xC8BA,0x0000,0x0000,0x0000,0x0000,0xE9DE,0x0000,0x0000,0xE9DF,0xC9C8,0xC8DA,0xE9E2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC2FD,0xE9EC,0x0000,0xE9E8,0x0000,0x0000,0xB2EB,
};
static const WORD _ucs_to_eucj_8700_data []={ //8700 87FE
	0xE9E6,0x0000,0xCBAA,0xE9E7,0x0000,0x0000,0xE9E4,0x0000,0xE9E5,0xE9EA,0xE9ED,0x0000,0x0000,0xE9EB,0x0000,0x0000,
	0x0000,0xE9E9,0xE9E3,0x0000,0x0000,0x0000,0x0000,0x0000,0xC3D8,0x0000,0xE9F4,0x0000,0xCCAA,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE9F2,0x0000,0x0000,0x0000,0xE9F3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE9EE,0x0000,0x0000,0xE9F0,0x0000,0x0000,0x0000,0xE9F1,0x0000,0x0000,0x0000,0xE9EF,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC0E6,0x0000,0xCFB9,0xE9F8,0x0000,0xE9F9,0x0000,
	0x0000,0x0000,0x0000,0xEAA1,0x0000,0xBFAA,0x0000,0xE9FB,0x0000,0xE9FE,0x0000,0x0000,0x0000,0x0000,0x0000,0xE9F6,
	0xE9F5,0x0000,0x0000,0xEAA2,0x0000,0x0000,0xB2DC,0x0000,0xE9FC,0x0000,0xEAA3,0x0000,0x0000,0x0000,0xE9FD,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xE9FA,0x0000,0xC4B3,0x0000,0xE9F7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC7E8,
	0x0000,0x0000,0xEAA7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDBB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAA6,
	0x0000,0x0000,0xEAA5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAAE,0x0000,0x0000,0x0000,0xEAA8,
	0x0000,0x0000,0x0000,0xEAB0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCDE6,0xEAB3,0x0000,0xEAAA,0x0000,0x0000,
	0xEAAB,0x0000,0x0000,0x0000,0xEAAF,0x0000,0xEAB2,0xEAB1,0x0000,0x0000,0x0000,0xEAA9,0x0000,0x0000,0x0000,0x0000,
	0xEAAC,0x0000,0xEABD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xEAB6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAB4,
	0x0000,0x0000,0xEAB5,0x0000,0x0000,0x0000,0xEABA,0xEABB,0x0000,0xB3AA,0x0000,0xB5C2,0x0000,0x0000,0xEAB9,
};
static const WORD _ucs_to_eucj_8800_data []={ //8805 88FE
	                                   0xEAA4,0x0000,0xFBE5,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAB8,0xEABC,0xEAB7,
	0x0000,0xEABE,0x0000,0x0000,0x0000,0xEAC0,0xEABF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xEAC2,0xEAC1,0xE9DA,0x0000,0x0000,0x0000,0xEAC6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xEAC3,0x0000,0x0000,0x0000,0x0000,0xEAC4,0x0000,0x0000,0xEAC5,0x0000,0xEAC7,0x0000,0x0000,0x0000,0x0000,
	0xB7EC,0x0000,0xEAC9,0x0000,0xEAC8,0x0000,0xBDB0,0x0000,0x0000,0x0000,0x0000,0x0000,0xB9D4,0xDEA7,0x0000,0x0000,
	0x0000,0x0000,0xEACA,0xBDD1,0x0000,0x0000,0x0000,0xB3B9,0x0000,0xEACB,0x0000,0xB1D2,0x0000,0xBED7,0xEACC,0x0000,
	0x0000,0xB9D5,0xEACD,0xB0E1,0x0000,0x0000,0x0000,0x0000,0xC9BD,0x0000,0x0000,0xEACE,0x0000,0x0000,0x0000,0x0000,
	0xBFEA,0x0000,0xEAD5,0x0000,0x0000,0xEAD2,0x0000,0xC3EF,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAD3,0xEAD0,0xB6DE,
	0x0000,0xEACF,0xEAD6,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7B6,0x0000,0x0000,0xC2DE,0x0000,0xEADC,0x0000,0x0000,
	0x0000,0x0000,0xEAD8,0x0000,0x0000,0x0000,0xC2B5,0xEAD7,0x0000,0xEADA,0x0000,0x0000,0x0000,0x0000,0xEAD1,0x0000,
	0x0000,0x0000,0xEADB,0x0000,0xEADD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8EF,0x0000,0x0000,0xEAD9,0x0000,
	0xEADE,0xEAE0,0x0000,0x0000,0xB8D3,0xEAD4,0x0000,0xB0C1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEADF,
	0x0000,0xBADB,0xCEF6,0xEAE1,0xEAE2,0xC1F5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCEA2,
	0x0000,0x0000,0x0000,0x0000,0xEAE3,0xCDB5,0x0000,0x0000,0xEAE4,0xEAE5,0x0000,0x0000,0xCAE4,0xEAE6,0x0000,0xBAC0,
	0x0000,0xCEA3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAEB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEAEC,0xBED8,0xEAEA,0xFBE6,0x0000,0x0000,0xCDE7,0xEAE7,0x0000,0x0000,0xEAE9,0xC0BD,0xBFFE,
};
static const WORD _ucs_to_eucj_8900_data []={ //8902 89F8
	              0xEAE8,0x0000,0xEAED,0x0000,0x0000,0xCAA3,0x0000,0x0000,0xEAEF,0x0000,0xEAEE,0x0000,0x0000,0x0000,
	0xB3EC,0x0000,0xCBAB,0xEAF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF9A2,0xEAFC,0xEAF2,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xEAF3,0x0000,0x0000,0x0000,0x0000,0xEAF4,0xEAF5,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAF9,0x0000,0xEAFA,0x0000,0x0000,0xEAF8,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xEAF6,0x0000,0xEAF1,0xEAF7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAFB,0xF0B7,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB2A8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEAFE,0xB6DF,
	0xEAFD,0x0000,0x0000,0x0000,0xEBA2,0x0000,0xEBA1,0x0000,0x0000,0x0000,0xEBA4,0x0000,0x0000,0xEBA3,0x0000,0xEBA5,
	0x0000,0x0000,0xBDB1,0x0000,0xEBA6,0x0000,0x0000,0xEBA7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEBA8,0xC0BE,
	0x0000,0xCDD7,0x0000,0xEBA9,0x0000,0x0000,0xCAA4,0xC7C6,0xEBAA,0x0000,0xEBAB,0xB8AB,0x0000,0x0000,0x0000,0xB5AC,
	0x0000,0x0000,0x0000,0xEBAC,0x0000,0x0000,0xBBEB,0xC7C1,0xEBAD,0x0000,0xB3D0,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xEBAE,0x0000,0x0000,0x0000,0x0000,0xEBB0,0xCDF7,0x0000,0xEBAF,0xBFC6,0x0000,0xEBB1,0x0000,0x0000,0xEBB2,
	0x0000,0x0000,0xEBB3,0xB4D1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEBB4,0x0000,0x0000,0xEBB5,0x0000,0xEBB6,
	0xEBB7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xB3D1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEBB8,0x0000,0xEBB9,0xEBBA,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xB2F2,0x0000,0x0000,0xBFA8,0xEBBB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xEBBC,0x0000,0x0000,0x0000,0xEBBD,
};
static const WORD _ucs_to_eucj_8A00_data []={ //8A00 8AFE
	0xB8C0,0x0000,0xC4FB,0xEBBE,0x0000,0x0000,0x0000,0x0000,0xB7D7,0x0000,0xBFD6,0x0000,0xEBC1,0x0000,0xC6A4,0x0000,
	0xEBC0,0x0000,0xFBE7,0xB7B1,0x0000,0x0000,0xEBBF,0xC2F7,0xB5AD,0x0000,0x0000,0xEBC2,0x0000,0xEBC3,0x0000,0xBED9,
	0x0000,0x0000,0x0000,0xB7ED,0x0000,0xEBC4,0x0000,0x0000,0x0000,0x0000,0xCBAC,0x0000,0x0000,0xC0DF,0x0000,0x0000,
	0x0000,0xB5F6,0x0000,0xCCF5,0xC1CA,0x0000,0xEBC5,0xFBE8,0x0000,0x0000,0xBFC7,0xC3F0,0xBEDA,0x0000,0x0000,0x0000,
	0x0000,0xEBC6,0x0000,0x0000,0x0000,0x0000,0xEBC9,0x0000,0xEBCA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xBABE,0xC2C2,0xEBC8,0x0000,0xBEDB,0xC9BE,0x0000,0x0000,0x0000,0x0000,0x0000,0xEBC7,0x0000,0x0000,0xBBEC,0x0000,
	0xB1D3,0x0000,0xEBCE,0xB7D8,0x0000,0x0000,0xBBEE,0x0000,0x0000,0xBBED,0x0000,0xCFCD,0xEBCD,0xEBCC,0xC1A7,0x0000,
	0xB5CD,0xCFC3,0xB3BA,0xBEDC,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBE9,0x0000,0x0000,0xEBCB,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEBD0,0x0000,0xEBD1,0xEBCF,0x0000,0xB8D8,0x0000,0xCDC0,0x0000,0x0000,0xBBEF,0xC7A7,0x0000,0x0000,
	0x0000,0xEBD4,0x0000,0xC0C0,0x0000,0xC3C2,0x0000,0x0000,0xCDB6,0x0000,0xEBD7,0x0000,0x0000,0x0000,0xB8EC,0x0000,
	0xC0BF,0xEBD3,0x0000,0xEBD8,0xB8ED,0xEBD5,0xEBD6,0xFBEA,0xEBD2,0x0000,0x0000,0x0000,0xC0E2,0xC6C9,0x0000,0x0000,
	0xC3AF,0x0000,0xB2DD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8F0,0x0000,0x0000,0xB5C3,0x0000,0xFBEB,0xC4B4,
	0x0000,0x0000,0xEBDB,0x0000,0xEBD9,0x0000,0x0000,0xC3CC,0x0000,0x0000,0x0000,0xC0C1,0xB4D2,0xEBDA,0x0000,0xBFDB,
	0x0000,0x0000,0xCECA,0x0000,0x0000,0x0000,0xCFC0,0x0000,0x0000,0x0000,0xEBDC,0xEBE7,0xC4B5,0x0000,0xEBE6,0xFBEC,
	0xEBE3,0xEBEB,0xEBE4,0x0000,0xEBE0,0x0000,0xC4FC,0xEBDF,0x0000,0x0000,0x0000,0xEBDD,0x0000,0xCDA1,0xBBF0,0x0000,
	0x0000,0xEBE1,0x0000,0xEBDE,0x0000,0x0000,0xFBEE,0xEBE5,0xBDF4,0x0000,0xB8C1,0x0000,0x0000,0x0000,0xC2FA,
};
static const WORD _ucs_to_eucj_8B00_data []={ //8B00 8B9A
	0xCBC5,0xB1DA,0xB0E2,0x0000,0xC6A5,0x0000,0x0000,0xEBE9,0x0000,0x0000,0x0000,0x0000,0xEBE8,0x0000,0xC6E6,0x0000,
	0xEBED,0x0000,0x0000,0x0000,0xEBE2,0x0000,0xEBEC,0xEBEE,0x0000,0xB8AC,0xEBEA,0xB9D6,0x0000,0xBCD5,0x0000,0x0000,
	0xEBEF,0xCDD8,0x0000,0x0000,0x0000,0x0000,0xEBF2,0x0000,0xEBF5,0x0000,0x0000,0xEBF3,0xC9B5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xEBF0,0x0000,0x0000,0x0000,0x0000,0x0000,0xB6E0,0x0000,0x0000,0x0000,0x0000,0xEBF4,0x0000,
	0x0000,0xEBF6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEBFA,0x0000,0x0000,0xEBF7,0x0000,0xEBF9,0xEBF8,
	0x0000,0x0000,0x0000,0xFBEF,0x0000,0x0000,0xEBFB,0x0000,0xBCB1,0x0000,0xEBFD,0xEBFC,0xC9E8,0x0000,0x0000,0xECA1,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7D9,0x0000,0x0000,0x0000,0x0000,0xEBFE,0xECA2,0x0000,0x0000,0xECA3,
	0xB5C4,0xE6C1,0xBEF9,0x0000,0xECA4,0x0000,0x0000,0xB8EE,0x0000,0x0000,0x0000,0x0000,0x0000,0xECA5,0x0000,0xFBF0,
	0xECA6,0x0000,0x0000,0xBBBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xDACE,0x0000,0xECA7,0x0000,0xECA8,0x0000,
	0xBDB2,0x0000,0xECA9,0xECAA,0x0000,0x0000,0xECAB,0x0000,0x0000,0xECAC,0xECAD,
};
static const WORD _ucs_to_eucj_8C00_data []={ //8C37 8CFD
	                                                 0xC3AB,0x0000,0x0000,0xECAE,0x0000,0x0000,0x0000,0x0000,0xECB0,
	0x0000,0xECAF,0x0000,0x0000,0x0000,0x0000,0xC6A6,0x0000,0xECB1,0x0000,0xCBAD,0x0000,0xECB2,0x0000,0xECB3,0x0000,
	0xECB4,0x0000,0x0000,0x0000,0x0000,0xECB5,0x0000,0x0000,0x0000,0x0000,0xC6DA,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xBEDD,0xECB6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB9EB,0xD0AE,0xECB7,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xECB8,0xC9BF,0xECB9,0x0000,0xECC1,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xECBA,0x0000,0x0000,0xECBC,0x0000,0x0000,0x0000,0xECBB,0xECBD,0x0000,0xCBC6,0xECBE,0xECBF,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xECC0,0x0000,0x0000,0x0000,0xECC2,0x0000,0x0000,0x0000,0x0000,0xB3AD,0xC4E7,0x0000,
	0xC9E9,0xBAE2,0xB9D7,0x0000,0x0000,0x0000,0x0000,0xC9CF,0xB2DF,0xC8CE,0xECC5,0xB4D3,0xC0D5,0xECC4,0xECC9,0xC3F9,
	0xCCE3,0x0000,0xECC7,0xECC8,0xB5AE,0x0000,0xECCA,0xC7E3,0xC2DF,0x0000,0x0000,0xC8F1,0xC5BD,0xECC6,0x0000,0xCBC7,
	0xB2EC,0xECCC,0xCFA8,0xC4C2,0xCFC5,0x0000,0x0000,0xBBF1,0xECCB,0x0000,0xC2B1,0x0000,0x0000,0xECDC,0xC1A8,0x0000,
	0x0000,0xC6F8,0x0000,0xC9D0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xECCF,0xBBBF,0xBBF2,0x0000,0xBEDE,0x0000,
	0xC7E5,0x0000,0xB8AD,0xECCE,0xECCD,0x0000,0xC9EA,0x0000,0x0000,0x0000,0xBCC1,0x0000,0x0000,0xC5D2,0x0000,0x0000,
	0xFBF1,0x0000,0x0000,0x0000,0xFBF2,0x0000,0x0000,0x0000,0x0000,0x0000,0xECD1,0xECD2,0xB9D8,0xECD0,
};
static const WORD _ucs_to_eucj_8D00_data []={ //8D04 8DFF
	                            0xECD3,0xECD4,0x0000,0xECD6,0xC2A3,0x0000,0xECD5,0xB4E6,0x0000,0xECD8,0x0000,0xECD7,
	0xECD9,0x0000,0xFBF3,0xECDB,0xECDD,0x0000,0xECDE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xC0D6,0x0000,0xBCCF,0xECDF,0x0000,0x0000,0x0000,0xB3D2,0x0000,0xECE0,0x0000,0x0000,
	0xC1F6,0xECE1,0x0000,0xECE2,0xC9EB,0x0000,0xFBF4,0xB5AF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xECE3,0x0000,0x0000,0x0000,0xC4B6,0x0000,0x0000,0x0000,0x0000,0xB1DB,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xECE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xBCF1,0x0000,0x0000,0x0000,0x0000,0xBFF6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xC2AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xECE7,0x0000,0x0000,0x0000,0xECE6,0x0000,
	0x0000,0x0000,0xECE5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xECED,0xECEB,0x0000,0x0000,0xECE8,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xECEA,0x0000,0x0000,0x0000,0xECE9,0xECEC,0x0000,0xB5F7,0x0000,0xECF0,
	0x0000,0xC0D7,0x0000,0xECF1,0x0000,0x0000,0x0000,0x0000,0xB8D9,0x0000,0xECEE,0xECEF,0x0000,0x0000,0x0000,0xCFA9,
	0x0000,0x0000,0x0000,0xC4B7,0x0000,0xC1A9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xECF2,0x0000,0x0000,0xECF5,
};
static const WORD _ucs_to_eucj_8E00_data []={ //8E08 8EFE
	                                                        0xECF3,0xECF4,0xCDD9,0x0000,0x0000,0x0000,0x0000,0xC6A7,
	0xECF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xECF6,0xECF7,0xECF9,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDA9,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xECFC,0x0000,0x0000,0x0000,0xECFD,0xECFB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xECFA,0x0000,0xC4FD,0x0000,0x0000,0xEDA1,0xEDA5,0xEDA2,0xECFE,0x0000,0xEDA3,0x0000,0x0000,0x0000,
	0xEDA4,0x0000,0x0000,0x0000,0x0000,0xEDAB,0x0000,0x0000,0x0000,0xEDA6,0x0000,0x0000,0x0000,0x0000,0x0000,0xC0D8,
	0xEDA8,0x0000,0x0000,0xEDAA,0xEDA7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEDAD,0x0000,0xBDB3,0x0000,0xEDAC,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDAE,0x0000,0x0000,0x0000,
	0x0000,0xEDAF,0x0000,0x0000,0xEDB2,0xEDB1,0x0000,0xEDB0,0x0000,0x0000,0xEDB4,0xEDB3,0x0000,0xCCF6,0x0000,0x0000,
	0x0000,0xEDB6,0x0000,0xEDB5,0xEDB7,0x0000,0x0000,0x0000,0x0000,0xEDB8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xEDBA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDB9,0xBFC8,0xEDBB,0x0000,0x0000,0xB6ED,
	0xEDBC,0xEDBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDBF,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xEDC0,0xEDBD,0x0000,0xEDC1,0x0000,0xBCD6,0xEDC2,0xB5B0,0xB7B3,0x0000,0xFBF6,
	0x0000,0x0000,0xB8AE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDC3,0x0000,0x0000,0x0000,0xC6F0,
	0x0000,0x0000,0xC5BE,0xEDC4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDC7,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBCB4,0x0000,0x0000,0xEDC6,0xEDC5,0xB7DA,0xEDC8,
};
static const WORD _ucs_to_eucj_8F00_data []={ //8F03 8FFD
	                     0xB3D3,0x0000,0xEDCA,0x0000,0x0000,0x0000,0xBADC,0xEDC9,0x0000,0xEDD2,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEDCC,0xEDCE,0xCAE5,0xEDCB,0x0000,0x0000,0x0000,0xEDCD,0x0000,0xEDD1,0xEDCF,0xB5B1,0x0000,0xEDD0,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDD3,0x0000,0x0000,0xC7DA,0xCED8,0x0000,0x0000,0x0000,0x0000,0xBDB4,
	0x0000,0x0000,0x0000,0xEDD4,0x0000,0x0000,0x0000,0x0000,0xCDA2,0xEDD6,0x0000,0xEDD5,0x0000,0x0000,0xEDD9,0xCDC1,
	0x0000,0x0000,0xEDD8,0x0000,0xB3ED,0xEDD7,0xEDDC,0x0000,0x0000,0xEDDB,0x0000,0x0000,0xEDDA,0xC5B2,0xEDDD,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDDE,0x0000,0x0000,0x0000,0x0000,0xEDDF,0x0000,0x0000,0xB9EC,
	0x0000,0xB7A5,0xEDE0,0xEDE1,0xEDE2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBFC9,0xEDE3,0x0000,0xBCAD,0xEDE4,
	0x0000,0x0000,0x0000,0xEDE5,0x0000,0x0000,0x0000,0xD2A1,0xD1FE,0x0000,0x0000,0x0000,0x0000,0xEDE6,0xE5F0,0xEDE7,
	0xC3A4,0xBFAB,0xC7C0,0x0000,0x0000,0x0000,0x0000,0xEDE8,0x0000,0x0000,0xCAD5,0xC4D4,0xB9FE,0x0000,0x0000,0xC3A9,
	0x0000,0x0000,0xB1AA,0x0000,0xCBF8,0xBFD7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7DE,0x0000,
	0x0000,0xB6E1,0x0000,0x0000,0xCAD6,0x0000,0x0000,0x0000,0x0000,0x0000,0xEDE9,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEDEB,0x0000,0x0000,0xEDEA,0xB2E0,0x0000,0x0000,0xC6F6,0xEDEC,0xC7F7,0x0000,0xC5B3,0x0000,0xEDED,
	0xBDD2,0x0000,0x0000,0x0000,0xEDEF,0x0000,0x0000,0xCCC2,0xEDFE,0xEDF1,0xEDF2,0x0000,0x0000,0xC4C9,
};
static const WORD _ucs_to_eucj_9000_data []={ //9000 90FD
	0xC2E0,0xC1F7,0x0000,0xC6A8,0x0000,0xEDF0,0xB5D5,0x0000,0x0000,0x0000,0x0000,0xEDF9,0x0000,0xEDF6,0xEEA5,0xC6A9,
	0xC3E0,0xEDF3,0x0000,0xC4FE,0xC5D3,0xEDF4,0xEDF8,0xBFE0,0x0000,0xC7E7,0xC4CC,0x0000,0x0000,0xC0C2,0xEDF7,0xC2AE,
	0xC2A4,0xEDF5,0xB0A9,0xCFA2,0x0000,0x0000,0x0000,0xEDFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC2E1,0x0000,
	0x0000,0xBDB5,0xBFCA,0x0000,0x0000,0xEDFC,0xEDFB,0x0000,0xB0EF,0xEDFD,0x0000,0x0000,0xC9AF,0x0000,0xEEA7,0x0000,
	0x0000,0xC6DB,0xBFEB,0x0000,0x0000,0xC3D9,0x0000,0xB6F8,0x0000,0xEEA6,0xCDB7,0xB1BF,0x0000,0xCAD7,0xB2E1,0xEEA1,
	0xEEA2,0xEEA3,0xEEA4,0xC6BB,0xC3A3,0xB0E3,0xEEA8,0x0000,0xEEA9,0xF4A3,0x0000,0x0000,0xC2BD,0x0000,0xEEAA,0x0000,
	0xB1F3,0xC1CC,0x0000,0xB8AF,0x0000,0xCDDA,0x0000,0xFBF9,0xEEAB,0xC5AC,0x0000,0x0000,0x0000,0xC1F8,0xBCD7,0xEEAC,
	0x0000,0x0000,0xEEAF,0x0000,0x0000,0xBDE5,0xEEAD,0xC1AB,0xC1AA,0x0000,0xB0E4,0x0000,0xCECB,0xEEB1,0x0000,0xC8F2,
	0xEEB3,0xEEB2,0xEEB0,0xE3E4,0xB4D4,0x0000,0x0000,0xEDEE,0x0000,0xEEB5,0xEEB4,0x0000,0x0000,0x0000,0x0000,0xEEB6,
	0x0000,0xCDB8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xC6E1,0x0000,0x0000,0xCBAE,0x0000,0xEEB7,0x0000,0xBCD9,0x0000,0x0000,0x0000,0x0000,0xEEB8,
	0x0000,0xEEB9,0x0000,0x0000,0x0000,0xEEBA,0x0000,0x0000,0xC5A1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB0EA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB9D9,0x0000,0x0000,0x0000,0xCFBA,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEEBE,0x0000,0x0000,0xFBFA,0x0000,
	0x0000,0xB7B4,0xEEBB,0x0000,0xEEBC,0x0000,0x0000,0x0000,0xC9F4,0x0000,0x0000,0x0000,0x0000,0xB3D4,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xCDB9,0x0000,0xB6BF,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5D4,
};
static const WORD _ucs_to_eucj_9100_data []={ //9102 91FF
	              0xEEBF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEEC0,0x0000,0x0000,0xFBFC,0x0000,0x0000,0x0000,0xEEC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFBFD,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5A2,0x0000,0x0000,
	0xEEC3,0x0000,0xEEC2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC6D3,0xEEC4,0xBDB6,0xBCE0,0xC7DB,0xC3F1,0x0000,
	0x0000,0x0000,0xBCF2,0x0000,0xBFEC,0x0000,0xEEC5,0x0000,0xEEC6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xBFDD,0xEEC7,0x0000,0xEEC8,0x0000,0x0000,0x0000,0xEEC9,0xCDEF,0x0000,0xBDB7,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEECB,0xEECA,0x0000,0xB9DA,0x0000,0xB9F3,0xBBC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEECE,0x0000,0x0000,0x0000,0x0000,0xBDE6,0x0000,0xEECD,0x0000,0xEECC,0x0000,0xC2E9,0x0000,0x0000,
	0xB8EF,0x0000,0xC0C3,0x0000,0x0000,0x0000,0x0000,0xC8B0,0x0000,0x0000,0x0000,0x0000,0xBDB9,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xEECF,0x0000,0xBEDF,0x0000,0x0000,0x0000,0x0000,0x0000,0xEED2,0xEED0,0x0000,0x0000,0x0000,0xEED1,
	0x0000,0x0000,0x0000,0x0000,0xEED4,0xEED3,0x0000,0x0000,0xBEFA,0x0000,0xEED5,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xEED6,0xEED7,0x0000,0x0000,0x0000,0x0000,0xC8D0,0xBAD3,0xBCE1,0xEED8,0x0000,0xEED9,0xCEA4,0xBDC5,0xCCEE,0xCECC,
	0xEEDA,0xB6E2,0x0000,0x0000,0x0000,0x0000,0xEEDB,0xFCA1,0xC5A3,0x0000,0xFBFE,0xEEDE,0xB3F8,0xBFCB,0xFCA2,0xEEDC,
	0x0000,0xEEDD,0x0000,0xC4E0,0xFCA5,0xFCA6,0xCBD5,0xB6FC,0x0000,0x0000,0x0000,0x0000,0x0000,0xFCA3,0xFCA4,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xEEE0,0xEEE1,0x0000,0x0000,0x0000,0x0000,0x0000,0xEEDF,0x0000,0x0000,0xEEE3,
};
static const WORD _ucs_to_eucj_9200_data []={ //9206 92FF
	                                          0xFCA7,0x0000,0x0000,0x0000,0xFCA9,0x0000,0x0000,0xC6DF,0xB3C3,0x0000,
	0xFCA8,0xEEE7,0x0000,0x0000,0xEEE4,0xEEE6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEEE2,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFCF,0x0000,0x0000,0xEEE5,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xCEEB,0x0000,0x0000,0xB8DA,0x0000,0xFCB0,0xFCAA,0x0000,0xFCAC,0x0000,0x0000,0xEEEF,
	0xFCAB,0x0000,0x0000,0x0000,0xC5B4,0xEEEA,0x0000,0x0000,0xEEED,0xEEEB,0x0000,0xEEF0,0x0000,0x0000,0xFCAD,0x0000,
	0xEEF1,0xFCAF,0x0000,0x0000,0x0000,0x0000,0x0000,0xEEE9,0x0000,0xFCAE,0xEEF6,0xB1F4,0x0000,0x0000,0xEEE8,0x0000,
	0x0000,0x0000,0xC8AD,0x0000,0xEEEC,0x0000,0xBEE0,0xFCB1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB9DB,0x0000,0x0000,0x0000,0x0000,0x0000,0xFCB3,0xFCB4,0x0000,0x0000,0x0000,0x0000,0x0000,0xCBC8,0x0000,
	0xB6E4,0x0000,0x0000,0xBDC6,0x0000,0xC6BC,0x0000,0x0000,0xF9A4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xC1AD,0x0000,0xEEF4,0x0000,0xEEEE,0xEEF3,0x0000,0xCCC3,0x0000,0xC4B8,0xEEF5,0xEEF2,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFCB2,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1AC,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEEF9,0x0000,0xEEF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEEF7,
	0xFCB8,0x0000,0xCBAF,0xFCBC,0x0000,0xFCBA,0x0000,0xFCB6,0x0000,0xFCB7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xFCBB,0x0000,0x0000,0x0000,0xBDFB,0x0000,0x0000,0xFCB5,0x0000,0xEEFA,0xCADF,0x0000,0x0000,0xB1D4,0x0000,0x0000,
	0x0000,0x0000,0xC9C6,0xC3F2,0x0000,0x0000,0x0000,0x0000,0xB5F8,0xF9AA,0xEEFC,0xFCBF,0xB9DD,0x0000,0x0000,0xFCC2,
};
static const WORD _ucs_to_eucj_9300_data []={ //9302 93F8
	              0xFCC4,0x0000,0x0000,0x0000,0xBBAC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEEFB,
	0xBFED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBFEE,0xEFA1,0xEFA3,0x0000,0x0000,0xFCC3,0xFCC1,0x0000,
	0xBEFB,0xFCBE,0xEFA2,0xEFA4,0x0000,0xFCBD,0xB6D3,0x0000,0xC9C5,0x0000,0x0000,0xBCE2,0xCFA3,0x0000,0xEEFE,0xBAF8,
	0x0000,0x0000,0xCFBF,0x0000,0x0000,0xEFA6,0x0000,0x0000,0x0000,0x0000,0xEFA5,0xEFA7,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xEEFD,0x0000,0x0000,0x0000,0xF9A3,0x0000,0x0000,0xC6E9,0x0000,0xC5D5,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xC4D7,0x0000,0xEFAC,0xFCC6,0x0000,0x0000,0x0000,0xC3C3,0xEFA8,0x0000,0x0000,0x0000,
	0xEFA9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7AD,0x0000,0xEFAB,0x0000,
	0xFCC5,0x0000,0x0000,0x0000,0x0000,0xB8B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFAA,0x0000,0xBEE1,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB3F9,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xEFB0,0x0000,0xBABF,0xC1F9,0x0000,0x0000,0xC4CA,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xFCC7,0x0000,0x0000,0xB3BB,0x0000,0x0000,0x0000,0x0000,0xEFAE,0xEFAF,0xC4C3,0x0000,
	0xEFAD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFB1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xEFB7,0x0000,0x0000,0xFCC8,0x0000,0xEFBA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xEFB9,0xC5AD,0x0000,0x0000,0x0000,0x0000,0xEFB2,0xEFB3,0xEFB6,0x0000,0x0000,0x0000,0x0000,0xEFB8,0xFCC9,0x0000,
	0x0000,0xB6C0,0x0000,0x0000,0xEFBB,0xEFB5,0x0000,0x0000,0xEFB4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFCCA,
};
static const WORD _ucs_to_eucj_9400_data []={ //9403 9481
	                     0xEFBF,0x0000,0x0000,0x0000,0xEFC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xEFC1,0x0000,0x0000,0xEFBE,0xEFBD,0x0000,0x0000,0x0000,0xBEE2,0xC6AA,0xEFBC,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xEFC5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFC3,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xFCCB,0x0000,0x0000,0x0000,0xEFC4,0xEFC2,0x0000,0xC2F8,0x0000,0xEFC6,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xEFC7,0x0000,0x0000,0xEFC9,0xFCCC,0x0000,0x0000,0xFCCD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xB4D5,0xEFC8,0xCCFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFD4,0xEFCA,0x0000,0x0000,0xEFCD,0x0000,
	0xEFCB,0x0000,0xEFCC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFCE,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xEFD0,0x0000,0x0000,0x0000,0x0000,0xEFD1,0x0000,0xEFD2,0x0000,0x0000,0x0000,0x0000,0xEFD5,0xEFD3,0xEFD6,0xEFD8,
	0x0000,0xEFD7,
};
static const WORD _ucs_to_eucj_9500_data []={ //9577 95E5
	                                                 0xC4B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xCCE7,0x0000,0xEFD9,0xC1AE,0x0000,0x0000,0x0000,0xEFDA,0x0000,0xCAC4,0xEFDB,0xB3AB,0x0000,0x0000,0x0000,0xB1BC,
	0x0000,0xB4D7,0xFCCE,0xB4D6,0xEFDC,0x0000,0xEFDD,0x0000,0xEFDE,0xEFDF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xEFE0,0x0000,0xB4D8,0xB3D5,0xB9DE,0xC8B6,0x0000,0xEFE2,0xEFE1,0x0000,0x0000,0x0000,0x0000,0xEFE3,0x0000,0x0000,
	0x0000,0x0000,0xB1DC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFE6,0x0000,0xEFE5,0xEFE4,0x0000,0xEFE7,0x0000,
	0x0000,0x0000,0x0000,0xEFEA,0x0000,0x0000,0x0000,0xB0C7,0x0000,0x0000,0xEFE8,0x0000,0xEFEC,0xEFEB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xEFEE,0xEFED,0xEFEF,0x0000,0xC6AE,0x0000,0x0000,0x0000,0xEFF0,0x0000,0x0000,0x0000,
	0x0000,0xEFF1,0xEFF3,0x0000,0x0000,0xEFF2,
};
static const WORD _ucs_to_eucj_9600_data []={ //961C 96FB
	                                                                                    0xC9EC,0x0000,0x0000,0x0000,
	0x0000,0xEFF4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFF5,0x0000,0xBAE5,0x0000,0x0000,0x0000,0xEFF6,0xEFF7,
	0x0000,0x0000,0xCBC9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC1CB,0x0000,0x0000,0x0000,0xB0A4,
	0xC2CB,0x0000,0xEFF8,0x0000,0xC9ED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xEFFB,0xEFF9,0xB9DF,0x0000,0xEFFA,
	0xB8C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCAC5,0xEFFD,0xF0A1,0xEFFE,0xF0A2,
	0x0000,0x0000,0xB1A1,0xBFD8,0xBDFC,0xB4D9,0xF0A3,0x0000,0x0000,0x0000,0xC7E6,0x0000,0xF0A5,0x0000,0x0000,0x0000,
	0xB1A2,0x0000,0xF0A4,0xC4C4,0x0000,0xCECD,0xC6AB,0xEFFC,0xCEA6,0x0000,0xB8B1,0x0000,0x0000,0xCDDB,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xB6F9,0xCEB4,0x0000,0xB7A8,0x0000,0xC2E2,0xE7A1,0x0000,0xF0A6,0xB3AC,0xBFEF,
	0x0000,0x0000,0x0000,0x0000,0xB3D6,0xF0A8,0x0000,0xF0A9,0xF0A7,0xB7E4,0x0000,0xBADD,0xBEE3,0xFCD1,0x0000,0x0000,
	0xB1A3,0x0000,0x0000,0xCED9,0x0000,0x0000,0x0000,0xF0AB,0xEEAE,0x0000,0xF0AA,0x0000,0x0000,0x0000,0x0000,0xFCD2,
	0xF0AE,0xF0AC,0xF0AD,0x0000,0xF0AF,0x0000,0xF0B0,0xCEEC,0xF0B1,0xF0B2,0x0000,0xC0C9,0xC8BB,0x0000,0x0000,0x0000,
	0xBFFD,0xB4E7,0x0000,0x0000,0xCDBA,0xB2ED,0xBDB8,0xB8DB,0x0000,0xF0B5,0x0000,0xF0B4,0xBBF3,0xF0B6,0xF0B3,0x0000,
	0x0000,0xBBA8,0x0000,0x0000,0x0000,0xF0BA,0xEAAD,0x0000,0x0000,0xD2D6,0x0000,0xBFF7,0xF0B8,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCEA5,0xC6F1,0x0000,0x0000,0x0000,0x0000,0xB1AB,0x0000,0xC0E3,0xBCB6,0x0000,0x0000,0x0000,0x0000,
	0xCAB7,0x0000,0xB1C0,0x0000,0x0000,0x0000,0xCEED,0xCDEB,0x0000,0xF0BB,0x0000,0xC5C5,
};
static const WORD _ucs_to_eucj_9700_data []={ //9700 97FF
	0xBCFB,0x0000,0x0000,0x0000,0xF0BC,0x0000,0xF0BD,0xBFCC,0xF0BE,0x0000,0xCEEE,0x0000,0x0000,0xF0B9,0xF0C0,0xF0C2,
	0x0000,0xF0C1,0x0000,0xF0BF,0x0000,0x0000,0xF0C3,0x0000,0x0000,0xF0C4,0x0000,0x0000,0xC1FA,0x0000,0xB2E2,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xF0C5,0x0000,0x0000,0xCCB8,0x0000,0x0000,0xF0C6,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xF0C7,0x0000,0xCFAA,0xFCD3,0x0000,0x0000,0x0000,0x0000,0xDBB1,0xF0C8,0x0000,0xFCD4,0x0000,0xF0C9,0xF0CA,0x0000,
	0x0000,0x0000,0xF0CE,0xFCD5,0xF0CB,0x0000,0xF0CC,0x0000,0xF0CD,0xF0CF,0x0000,0x0000,0x0000,0xFCD6,0x0000,0xFCD7,
	0x0000,0xFCD8,0xC0C4,0x0000,0x0000,0xFCD9,0xCCF7,0x0000,0x0000,0xC0C5,0x0000,0x0000,0xF0D0,0x0000,0xC8F3,0x0000,
	0xF0D1,0xF3D3,0xCCCC,0x0000,0xF0D2,0x0000,0xF0D3,0x0000,0xF0D4,0xB3D7,0x0000,0xF0D6,0x0000,0xBFD9,0x0000,0x0000,
	0x0000,0xF0D7,0x0000,0x0000,0xB7A4,0x0000,0x0000,0x0000,0x0000,0xF0D8,0xF0DC,0x0000,0xF0DA,0x0000,0x0000,0x0000,
	0x0000,0xF0DB,0x0000,0x0000,0xB3F3,0xF0D9,0xF0DD,0x0000,0x0000,0x0000,0x0000,0xF0DE,0x0000,0xB0C8,0x0000,0xF0DF,
	0xF0E0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBEE4,0x0000,0x0000,0x0000,0xF0E1,0x0000,0x0000,0x0000,
	0xB5C7,0x0000,0x0000,0xF0E4,0x0000,0x0000,0xF0E3,0x0000,0xF0E2,0x0000,0x0000,0xEBF1,0x0000,0xCADC,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xF0E5,0xF0E6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xF0E7,0x0000,0x0000,0xF0E8,0x0000,0xF0E9,0x0000,0x0000,0xF0EA,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xB4DA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF0EB,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF0EC,0xC7A3,0x0000,
	0x0000,0x0000,0xF0EE,0xB2BB,0x0000,0xF0F1,0xF0F0,0x0000,0x0000,0x0000,0x0000,0xB1A4,0x0000,0x0000,0x0000,0xB6C1,
};
static const WORD _ucs_to_eucj_9800_data []={ //9801 98FE
	       0xCAC7,0xC4BA,0xBAA2,0x0000,0xB9E0,0xBDE7,0x0000,0xBFDC,0x0000,0x0000,0x0000,0xF0F3,0x0000,0x0000,0xF0F2,
	0xCDC2,0xB4E8,0xC8D2,0xC6DC,0x0000,0x0000,0x0000,0xBFFC,0xCECE,0x0000,0xB7DB,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xF0F6,0x0000,0x0000,0xF0F5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCBCB,0xC6AC,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xB1D0,0x0000,0x0000,0xF0F7,0xF0F4,0x0000,0x0000,0xC9D1,0xCDEA,0xF0F8,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF0F9,0x0000,0x0000,0x0000,0x0000,0xF0FB,0xC2EA,0xB3DB,0xB3DC,0xF0FA,
	0x0000,0x0000,0x0000,0x0000,0xB4E9,0xB8B2,0x0000,0xFCDA,0xB4EA,0x0000,0x0000,0xC5BF,0x0000,0x0000,0xCEE0,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xFCDB,0x0000,0xB8DC,0x0000,0x0000,0x0000,0xF0FC,0x0000,0x0000,0x0000,0xF0FD,
	0xF0FE,0xF1A1,0x0000,0xF1A3,0xF1A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC9F7,0x0000,0xF1A4,0x0000,0x0000,0x0000,0x0000,0xF1A5,
	0x0000,0xF1A6,0x0000,0x0000,0x0000,0x0000,0xF1A7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xF1A9,0xF1A8,0x0000,0xF1AA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC8F4,0xE6CC,0x0000,0x0000,0xBFA9,
	0x0000,0x0000,0xB5B2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1AB,0x0000,0xF1AC,0x0000,0xD2AC,0xDDBB,0xC8D3,
	0x0000,0x0000,0xB0FB,0x0000,0xB0BB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBBF4,0xCBB0,0xBEFE,
};
static const WORD _ucs_to_eucj_9900_data []={ //9903 99FF
	                     0xF1AD,0x0000,0xCCDF,0x0000,0x0000,0x0000,0xF1AE,0xCDDC,0x0000,0xB1C2,0x0000,0x0000,0x0000,
	0xBBC1,0x0000,0xF1AF,0xB2EE,0xF1B0,0x0000,0x0000,0x0000,0xF1B1,0x0000,0x0000,0x0000,0x0000,0xF1B3,0xF1B4,0x0000,
	0xF1B6,0xF1B2,0x0000,0x0000,0xF1B5,0x0000,0x0000,0xFCDE,0xB4DB,0x0000,0x0000,0x0000,0xF1B7,0x0000,0xF1B8,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1B9,0xF1BA,0x0000,
	0x0000,0x0000,0xF1BB,0x0000,0x0000,0xF1BD,0x0000,0x0000,0x0000,0xF1BC,0x0000,0xF1BF,0xF1C2,0x0000,0x0000,0x0000,
	0xF1BE,0xF1C0,0xF1C1,0x0000,0x0000,0xF1C3,0x0000,0xB6C2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xBCF3,0xF1C4,0xF1C5,0xB9E1,0x0000,0x0000,0x0000,0x0000,0xFCE0,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xF1C6,0x0000,0x0000,0xB3BE,0x0000,0x0000,0x0000,0xC7CF,0xF1C7,0xF1C8,0x0000,
	0x0000,0x0000,0x0000,0xC3DA,0xC6EB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1C9,0x0000,0x0000,0x0000,
	0x0000,0xC7FD,0x0000,0x0000,0xC2CC,0xB1D8,0xB6EE,0x0000,0xB6EF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xC3F3,0xF1CE,0xB6F0,0x0000,0x0000,0xB2EF,0x0000,0x0000,0xF1CD,0x0000,0x0000,0xF1CB,0x0000,0xF1CC,0x0000,0xF1CA,
	0x0000,0x0000,0xF1D8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1CF,0xF1D0,0x0000,
	0x0000,0xF1D1,0xF1D2,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1D4,0x0000,0x0000,0xF1D3,0x0000,0x0000,0x0000,0xBDD9,
};
static const WORD _ucs_to_eucj_9A00_data []={ //9A01 9AFB
	       0xF1D5,0x0000,0x0000,0x0000,0xF1D7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB5B3,0xF1D6,
	0x0000,0x0000,0xC1FB,0xB8B3,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1D9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC2CD,0x0000,0x0000,0xF1DA,0x0000,0x0000,0x0000,0x0000,
	0xC6AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1E0,0x0000,
	0xF1DE,0x0000,0xF1DD,0xF1DF,0x0000,0xF1DC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1E2,0xFCE1,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xF1E1,0x0000,0xF1E4,0x0000,0x0000,0xB6C3,0xF1E3,0x0000,0x0000,0x0000,0xF1E5,
	0x0000,0x0000,0xF1E6,0x0000,0xF1E8,0xF1E7,0x0000,0x0000,0x0000,0xF1E9,0xF1EB,0xF1EA,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB9FC,0x0000,0x0000,0x0000,0x0000,0xF1EC,0x0000,0x0000,
	0xF1ED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB3BC,0x0000,0x0000,0x0000,0xF1EE,0x0000,0x0000,0x0000,
	0xF1EF,0x0000,0x0000,0x0000,0xBFF1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF1F0,
	0x0000,0xF1F1,0x0000,0xF1F2,0xF1F3,0x0000,0x0000,0x0000,0xB9E2,0xFCE2,0x0000,0x0000,0xFCE3,0x0000,0xF1F4,0xF1F5,
	0x0000,0x0000,0xF1F6,0xF1F7,0x0000,0x0000,0xF1F8,0x0000,0x0000,0x0000,0xC8B1,0xF1FA,0x0000,0xC9A6,0xF1FB,0xF1F9,
	0x0000,0xF1FD,0x0000,0x0000,0xF1FC,0x0000,0x0000,0xF1FE,0x0000,0x0000,0x0000,0xF2A1,
};
static const WORD _ucs_to_eucj_9B00_data []={ //9B06 9BF5
	                                          0xF2A2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2A3,0x0000,0xF2A4,0x0000,0x0000,0x0000,0x0000,0xF2A5,
	0x0000,0x0000,0xF2A6,0xF2A7,0x0000,0xF2A8,0x0000,0xF2A9,0xF2AA,0xF2AB,0xF2AC,0x0000,0x0000,0x0000,0xF2AD,0xF2AE,
	0x0000,0xDDB5,0xF2AF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE4F8,0xB5B4,0x0000,0x0000,0x0000,
	0x0000,0xB3A1,0xBAB2,0xF2B1,0xF2B0,0xCCA5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2B3,0xF2B4,0xF2B2,
	0x0000,0xF2B5,0x0000,0x0000,0xCBE2,0x0000,0x0000,0x0000,0xF2B6,0x0000,0xB5FB,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCFA5,
	0x0000,0x0000,0xFCE5,0x0000,0xF2B7,0xFCE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0xF2B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB0BE,0xFCE6,
	0x0000,0xF2BA,0xCAAB,0xF2B8,0x0000,0x0000,0xF2BB,0xF2BC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2BD,
	0xF2BE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2BF,0x0000,0xCBEE,0xBBAD,0x0000,0xBAFA,0xC1AF,0x0000,
	0x0000,0xFCE7,0x0000,0x0000,0xF2C0,0x0000,0x0000,0x0000,0x0000,0xF2C3,0x0000,0xFCE8,0x0000,0x0000,0x0000,0x0000,
	0xF2C1,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2C4,0x0000,0x0000,0xB8F1,0xF2C2,0x0000,0x0000,0x0000,0x0000,0xF2C5,
	0x0000,0xF2C6,0xF2C7,0x0000,0xF2CB,0x0000,0xBBAA,0x0000,0x0000,0x0000,0x0000,0xC2E4,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xF2CC,0xF2C9,0xF2C8,0xF2CA,0x0000,0x0000,0x0000,0xB7DF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xF2D0,0xF2CF,0xF2CE,0x0000,0x0000,0xB0B3,
};
static const WORD _ucs_to_eucj_9C00_data []={ //9C00 9CF6
	0xFCE9,0x0000,0x0000,0x0000,0xF2DA,0x0000,0xF2D6,0x0000,0xF2D7,0xF2D3,0xF2D9,0x0000,0xF2D5,0xB3E2,0x0000,0x0000,
	0xCFCC,0x0000,0xF2D8,0xF2D4,0xF2D2,0xF2D1,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2DC,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xF2DF,0x0000,0x0000,0xF2DE,0xF2DD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC9C9,0xF2DB,0xB0F3,
	0xF2E0,0x0000,0xF2E2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB3EF,0xF2CD,0xB1B7,0x0000,0x0000,0xF2E4,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2E3,0xF2E1,0xC3AD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xCBF0,0x0000,0x0000,0x0000,0x0000,0xCEDA,0x0000,0x0000,0xF2E5,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xF2E6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2E7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF2E8,0x0000,0xF2E9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xC4BB,0x0000,0xF2EA,0x0000,0xC8B7,0x0000,0xF2EF,0xF2EB,0x0000,0x0000,0x0000,
	0xF2EC,0x0000,0x0000,0xCBB1,0xCCC4,0x0000,0xC6D0,
};
static const WORD _ucs_to_eucj_9D00_data []={ //9D03 9DFD
	                     0xF2F0,0x0000,0x0000,0xF2F1,0xC6BE,0xF2EE,0xF2ED,0x0000,0x0000,0x0000,0x0000,0xB2AA,0x0000,
	0x0000,0x0000,0xF2F9,0x0000,0x0000,0xF2F8,0x0000,0x0000,0x0000,0x0000,0x0000,0xB1F5,0x0000,0x0000,0x0000,0xF2F6,
	0x0000,0x0000,0x0000,0xF2F5,0x0000,0x0000,0xF2F3,0x0000,0xB3FB,0x0000,0xF2F2,0xBCB2,0xB2A9,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xB9E3,0x0000,0x0000,0xF2FC,0xF2FB,
	0x0000,0xF2FA,0x0000,0x0000,0xF2F7,0x0000,0xF2FD,0x0000,0xF2FE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xF3A5,0xF3A4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3A6,0x0000,0x0000,0xB1AD,0xF3A1,0xF3A2,0x0000,
	0xB9F4,0xCCB9,0x0000,0x0000,0xF3A3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFCEB,0xCBB2,0x0000,0x0000,0xF3AB,
	0xFCEA,0x0000,0xF3A7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3AC,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3A9,0x0000,0xF3A8,0x0000,0x0000,0x0000,0x0000,0x0000,0xB7DC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3AD,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0xF3AE,0x0000,0x0000,0x0000,0x0000,0xF3AF,0x0000,0xF3AA,0x0000,0x0000,0x0000,0xF2F4,
	0x0000,0x0000,0xF3B0,0x0000,0xC4E1,0x0000,0x0000,0x0000,0xF3B4,0x0000,0xF3B5,0xF3B3,0x0000,0x0000,0x0000,0x0000,
	0x0000,0xF3B2,0xF3B8,0x0000,0xF3B1,0x0000,0xF3B6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3B7,
	0x0000,0x0000,0x0000,0xF3BA,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3BC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3BD,0x0000,0xF3BE,
	0x0000,0x0000,0xCFC9,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3BB,0xC2EB,0xBAED,0x0000,0x0000,0xF3BF,
};
static const WORD _ucs_to_eucj_9E00_data []={ //9E19 9EFD
	                                                               0xFCED,0xF3C0,0xF3C1,0x0000,0x0000,0xF3C2,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xF3C3,0x0000,0x0000,0xB8B4,0xF3C4,0x0000,0x0000,0x0000,0xF3C5,0x0000,0xBCAF,
	0x0000,0xF3C6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3C7,0x0000,0x0000,0xF3C8,0xF3C9,0x0000,0x0000,0x0000,
	0x0000,0xF3CC,0xF3CA,0xCFBC,0x0000,0xF3CB,0x0000,0xCEEF,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3CD,0x0000,0xCEDB,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xF3CE,0xC7FE,0x0000,0x0000,0xF3CF,0xF3D1,0x0000,0x0000,0xF3D2,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3D0,0xB9ED,0xCCCD,0xCBE3,0xD6F7,0x0000,0xDDE0,0xCBFB,
	0x0000,0x0000,0x0000,0x0000,0xB2AB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3D4,0xB5D0,0xF3D5,0xF3D6,
	0xF3D7,0xFCEE,0xB9F5,0x0000,0xF3D8,0x0000,0x0000,0x0000,0xE0D4,0xCCDB,0x0000,0xC2E3,0xF3D9,0xF3DB,0xF3DA,0x0000,
	0xF3DC,0x0000,0x0000,0x0000,0x0000,0xF3DD,0x0000,0x0000,0xF3DE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3DF,
	0x0000,0x0000,0x0000,0x0000,0xF3E0,0x0000,0xF3E1,0xF3E2,0x0000,0xF3E3,0x0000,0xF3E4,0xF3E5,0xF3E6,
};
static const WORD _ucs_to_eucj_9F00_data []={ //9F07 9FA0
	                                                 0xF3E7,0xF3E8,0x0000,0x0000,0x0000,0x0000,0x0000,0xC5A4,0x0000,
	0x0000,0x0000,0x0000,0xB8DD,0x0000,0xF3EA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xC1CD,0xF3EB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3EC,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC9A1,0x0000,0x0000,0xF3ED,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3EE,0xE3B7,0x0000,0x0000,0xECDA,0xF0ED,
	0x0000,0x0000,0xF3EF,0x0000,0xF3F0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3F2,
	0xF3F3,0xF3F4,0xCEF0,0xF3F1,0x0000,0x0000,0xF3F5,0xF3F6,0x0000,0x0000,0xF3F8,0x0000,0xF3F7,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xF3FA,0x0000,0x0000,0x0000,0xF3FB,0xF3F9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xCEB6,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xF3FC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF3FD,0xE3D4,0x0000,0x0000,
	0xF3FE,
};
static const WORD _ucs_to_eucj_F800_data []={ //F8F0 F8F3
	0x00A0,0x0000,0x0000,0x00FF,
};
static const WORD _ucs_to_eucj_F900_data []={ //F929 F9DC
	                                                               0xFAC6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFCCF,
};
static const WORD _ucs_to_eucj_FA00_data []={ //FA0E FA2D
	                                                                                                  0xF9D4,0xF9DF,
	0xF9E0,0xF9F5,0xFABE,0xFACE,0xFAD0,0xFAFB,0xFBA3,0xFBBA,0xFBC2,0xFBC3,0xFBC4,0xFBC6,0xFBCA,0xFBCD,0xFBD6,0xFBE1,
	0xFBE3,0xFBE4,0xFBED,0xFBF5,0xFBF7,0xFBF8,0xFBFB,0xFCB9,0xFCC0,0xFCD0,0xFCDC,0xFCDD,0xFCDF,0xFCEC,
};
static const WORD _ucs_to_eucj_FF00_data []={ //FF01 FFE5
	       0xA1AA,0xFCFE,0xA1F4,0xA1F0,0xA1F3,0xA1F5,0xFCFD,0xA1CA,0xA1CB,0xA1F6,0xA1DC,0xA1A4,0xA1DD,0xA1A5,0xA1BF,
	0xA3B0,0xA3B1,0xA3B2,0xA3B3,0xA3B4,0xA3B5,0xA3B6,0xA3B7,0xA3B8,0xA3B9,0xA1A7,0xA1A8,0xA1E3,0xA1E1,0xA1E4,0xA1A9,
	0xA1F7,0xA3C1,0xA3C2,0xA3C3,0xA3C4,0xA3C5,0xA3C6,0xA3C7,0xA3C8,0xA3C9,0xA3CA,0xA3CB,0xA3CC,0xA3CD,0xA3CE,0xA3CF,
	0xA3D0,0xA3D1,0xA3D2,0xA3D3,0xA3D4,0xA3D5,0xA3D6,0xA3D7,0xA3D8,0xA3D9,0xA3DA,0xA1CE,0xA1C0,0xA1CF,0xA1B0,0xA1B2,
	0xA1AE,0xA3E1,0xA3E2,0xA3E3,0xA3E4,0xA3E5,0xA3E6,0xA3E7,0xA3E8,0xA3E9,0xA3EA,0xA3EB,0xA3EC,0xA3ED,0xA3EE,0xA3EF,
	0xA3F0,0xA3F1,0xA3F2,0xA3F3,0xA3F4,0xA3F5,0xA3F6,0xA3F7,0xA3F8,0xA3F9,0xA3FA,0xA1D0,0xA1C3,0xA1D1,0xA1C1,0x0000,
	0x0000,0x8EA1,0x8EA2,0x8EA3,0x8EA4,0x8EA5,0x8EA6,0x8EA7,0x8EA8,0x8EA9,0x8EAA,0x8EAB,0x8EAC,0x8EAD,0x8EAE,0x8EAF,
	0x8EB0,0x8EB1,0x8EB2,0x8EB3,0x8EB4,0x8EB5,0x8EB6,0x8EB7,0x8EB8,0x8EB9,0x8EBA,0x8EBB,0x8EBC,0x8EBD,0x8EBE,0x8EBF,
	0x8EC0,0x8EC1,0x8EC2,0x8EC3,0x8EC4,0x8EC5,0x8EC6,0x8EC7,0x8EC8,0x8EC9,0x8ECA,0x8ECB,0x8ECC,0x8ECD,0x8ECE,0x8ECF,
	0x8ED0,0x8ED1,0x8ED2,0x8ED3,0x8ED4,0x8ED5,0x8ED6,0x8ED7,0x8ED8,0x8ED9,0x8EDA,0x8EDB,0x8EDC,0x8EDD,0x8EDE,0x8EDF,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0xA1F1,0xA1F2,0xA2CC,0xA1B1,0xFCFC,0xA1EF,
};
extern const struct _encoding_table_u _ucs_to_eucj_table []={
	{ 0x00FF,0x0001,_ucs_to_eucj_0000_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x03C9,0x0391,_ucs_to_eucj_0300_data },
	{ 0x0451,0x0401,_ucs_to_eucj_0400_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x203B,0x2010,_ucs_to_eucj_2000_data },
	{ 0x21D4,0x2103,_ucs_to_eucj_2100_data },
	{ 0x22BF,0x2200,_ucs_to_eucj_2200_data },
	{ 0x2312,0x2312,_ucs_to_eucj_2300_data },
	{ 0x2473,0x2460,_ucs_to_eucj_2400_data },
	{ 0x25EF,0x2500,_ucs_to_eucj_2500_data },
	{ 0x266F,0x2605,_ucs_to_eucj_2600_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x30FE,0x3000,_ucs_to_eucj_3000_data },
	{0,0xffff,0},
	{ 0x32A8,0x3231,_ucs_to_eucj_3200_data },
	{ 0x33CD,0x3303,_ucs_to_eucj_3300_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0x4EFC,0x4E00,_ucs_to_eucj_4E00_data },
	{ 0x4FFF,0x4F00,_ucs_to_eucj_4F00_data },
	{ 0x50FB,0x5005,_ucs_to_eucj_5000_data },
	{ 0x51FE,0x5100,_ucs_to_eucj_5100_data },
	{ 0x52FF,0x5200,_ucs_to_eucj_5200_data },
	{ 0x53FA,0x5300,_ucs_to_eucj_5300_data },
	{ 0x54FF,0x5401,_ucs_to_eucj_5400_data },
	{ 0x55FE,0x5504,_ucs_to_eucj_5500_data },
	{ 0x56FF,0x5606,_ucs_to_eucj_5600_data },
	{ 0x57FC,0x5700,_ucs_to_eucj_5700_data },
	{ 0x58FD,0x5800,_ucs_to_eucj_5800_data },
	{ 0x59FF,0x5902,_ucs_to_eucj_5900_data },
	{ 0x5AFB,0x5A01,_ucs_to_eucj_5A00_data },
	{ 0x5BFF,0x5B09,_ucs_to_eucj_5B00_data },
	{ 0x5CFD,0x5C01,_ucs_to_eucj_5C00_data },
	{ 0x5DFE,0x5D07,_ucs_to_eucj_5D00_data },
	{ 0x5EFF,0x5E02,_ucs_to_eucj_5E00_data },
	{ 0x5FFF,0x5F01,_ucs_to_eucj_5F00_data },
	{ 0x60FB,0x600E,_ucs_to_eucj_6000_data },
	{ 0x61FF,0x6100,_ucs_to_eucj_6100_data },
	{ 0x62FF,0x6200,_ucs_to_eucj_6200_data },
	{ 0x63FA,0x6301,_ucs_to_eucj_6300_data },
	{ 0x64FE,0x6406,_ucs_to_eucj_6400_data },
	{ 0x65FB,0x6500,_ucs_to_eucj_6500_data },
	{ 0x66FF,0x6600,_ucs_to_eucj_6600_data },
	{ 0x67FF,0x6700,_ucs_to_eucj_6700_data },
	{ 0x68FA,0x6801,_ucs_to_eucj_6800_data },
	{ 0x69FF,0x6900,_ucs_to_eucj_6900_data },
	{ 0x6AFB,0x6A02,_ucs_to_eucj_6A00_data },
	{ 0x6BF3,0x6B04,_ucs_to_eucj_6B00_data },
	{ 0x6CF3,0x6C08,_ucs_to_eucj_6C00_data },
	{ 0x6DFC,0x6D04,_ucs_to_eucj_6D00_data },
	{ 0x6EFF,0x6E05,_ucs_to_eucj_6E00_data },
	{ 0x6FFE,0x6F01,_ucs_to_eucj_6F00_data },
	{ 0x70FD,0x7001,_ucs_to_eucj_7000_data },
	{ 0x71FF,0x7104,_ucs_to_eucj_7100_data },
	{ 0x72FD,0x7206,_ucs_to_eucj_7200_data },
	{ 0x73FE,0x730A,_ucs_to_eucj_7300_data },
	{ 0x74F8,0x7403,_ucs_to_eucj_7400_data },
	{ 0x75FF,0x7501,_ucs_to_eucj_7500_data },
	{ 0x76FE,0x7601,_ucs_to_eucj_7600_data },
	{ 0x77FC,0x7701,_ucs_to_eucj_7700_data },
	{ 0x78FD,0x7802,_ucs_to_eucj_7800_data },
	{ 0x79FB,0x7901,_ucs_to_eucj_7900_data },
	{ 0x7AFF,0x7A00,_ucs_to_eucj_7A00_data },
	{ 0x7BF7,0x7B02,_ucs_to_eucj_7B00_data },
	{ 0x7CFE,0x7C00,_ucs_to_eucj_7C00_data },
	{ 0x7DFB,0x7D00,_ucs_to_eucj_7D00_data },
	{ 0x7E9C,0x7E01,_ucs_to_eucj_7E00_data },
	{ 0x7FFC,0x7F36,_ucs_to_eucj_7F00_data },
	{ 0x80FD,0x8000,_ucs_to_eucj_8000_data },
	{ 0x81FE,0x8102,_ucs_to_eucj_8100_data },
	{ 0x82FB,0x8201,_ucs_to_eucj_8200_data },
	{ 0x83FD,0x8301,_ucs_to_eucj_8300_data },
	{ 0x84FF,0x8403,_ucs_to_eucj_8400_data },
	{ 0x85FE,0x8500,_ucs_to_eucj_8500_data },
	{ 0x86FE,0x8602,_ucs_to_eucj_8600_data },
	{ 0x87FE,0x8700,_ucs_to_eucj_8700_data },
	{ 0x88FE,0x8805,_ucs_to_eucj_8800_data },
	{ 0x89F8,0x8902,_ucs_to_eucj_8900_data },
	{ 0x8AFE,0x8A00,_ucs_to_eucj_8A00_data },
	{ 0x8B9A,0x8B00,_ucs_to_eucj_8B00_data },
	{ 0x8CFD,0x8C37,_ucs_to_eucj_8C00_data },
	{ 0x8DFF,0x8D04,_ucs_to_eucj_8D00_data },
	{ 0x8EFE,0x8E08,_ucs_to_eucj_8E00_data },
	{ 0x8FFD,0x8F03,_ucs_to_eucj_8F00_data },
	{ 0x90FD,0x9000,_ucs_to_eucj_9000_data },
	{ 0x91FF,0x9102,_ucs_to_eucj_9100_data },
	{ 0x92FF,0x9206,_ucs_to_eucj_9200_data },
	{ 0x93F8,0x9302,_ucs_to_eucj_9300_data },
	{ 0x9481,0x9403,_ucs_to_eucj_9400_data },
	{ 0x95E5,0x9577,_ucs_to_eucj_9500_data },
	{ 0x96FB,0x961C,_ucs_to_eucj_9600_data },
	{ 0x97FF,0x9700,_ucs_to_eucj_9700_data },
	{ 0x98FE,0x9801,_ucs_to_eucj_9800_data },
	{ 0x99FF,0x9903,_ucs_to_eucj_9900_data },
	{ 0x9AFB,0x9A01,_ucs_to_eucj_9A00_data },
	{ 0x9BF5,0x9B06,_ucs_to_eucj_9B00_data },
	{ 0x9CF6,0x9C00,_ucs_to_eucj_9C00_data },
	{ 0x9DFD,0x9D03,_ucs_to_eucj_9D00_data },
	{ 0x9EFD,0x9E19,_ucs_to_eucj_9E00_data },
	{ 0x9FA0,0x9F07,_ucs_to_eucj_9F00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xF8F3,0xF8F0,_ucs_to_eucj_F800_data },
	{ 0xF9DC,0xF929,_ucs_to_eucj_F900_data },
	{ 0xFA2D,0xFA0E,_ucs_to_eucj_FA00_data },
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{0,0xffff,0},
	{ 0xFFE5,0xFF01,_ucs_to_eucj_FF00_data },
};

}//namespace Enc
}//namespace Ck
//EOF
