/* UART 9600 8bit no-parity 1stop serial interface to bmp085 barometer gadget
developed by takefuji on dec. 12,2009. command h t p*/
#include <stdio.h>   /* Standard input/output definitions */
#include <string.h>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <termios.h> /* POSIX terminal control definitions */

static struct termios gOriginalTTYAttrs;

static int OpenSerialPort()
{
    int        fileDescriptor = -1;
    int        handshake;
    struct termios  options;
    
    fileDescriptor = open("/dev/tty.iap", O_RDWR | O_NOCTTY | O_NONBLOCK);
    if (fileDescriptor == -1)
    {
        printf("Error opening serial port %s - %s(%d).\n",
               "/dev/tty.iap", strerror(errno), errno);
        goto error;
    }

    if (ioctl(fileDescriptor, TIOCEXCL) == -1)
    {
        printf("Error setting TIOCEXCL on %s - %s(%d).\n",
            "/dev/tty.iap", strerror(errno), errno);
        goto error;
    }
    
    
    if (fcntl(fileDescriptor, F_SETFL, 0) == -1)
    {
        printf("Error clearing O_NONBLOCK %s - %s(%d).\n",
            "/dev/tty.iap", strerror(errno), errno);
        goto error;
    }
    
    if (tcgetattr(fileDescriptor, &gOriginalTTYAttrs) == -1)
    {
        printf("Error getting tty attributes %s - %s(%d).\n",
            "/dev/tty.iap", strerror(errno), errno);
        goto error;
    }

    options = gOriginalTTYAttrs;
    
    printf("Current input baud rate is %d\n", (int) cfgetispeed(&options));
    printf("Current output baud rate is %d\n", (int) cfgetospeed(&options));
    
    cfmakeraw(&options);
    options.c_cc[VMIN] = 1;
    options.c_cc[VTIME] = 10;
        
    cfsetspeed(&options, B9600);    // Set 19200 baud    
    options.c_cflag |= (CS8);  // RTS flow control of input
      
    printf("Input baud rate changed to %d\n", (int) cfgetispeed(&options));
    printf("Output baud rate changed to %d\n", (int) cfgetospeed(&options));
    
    if (tcsetattr(fileDescriptor, TCSANOW, &options) == -1)
    {
        printf("Error setting tty attributes %s - %s(%d).\n",
            "/dev/tty.iap", strerror(errno), errno);
        goto error;
    }    
    return fileDescriptor;
    
error:
    if (fileDescriptor != -1)
    {
        close(fileDescriptor);
    }
    
    return -1;
}

int main(int argc, char *argv[])
{
	int fd;
	unsigned char i;
	char somechar[20];
	fd=OpenSerialPort(); 
	if(fd>-1)
	{
printf("start...\n");
if(argc<2){printf("serial 1,0,t,p,or r\n");
		exit(1);}
	i=argv[1][0];
write(fd,&i,1);
read(fd,somechar,sizeof(somechar));
printf("your request: %s\n",somechar);
	}
	return 0;
}
