// O(log_2 M) Self-Organizing Map Algorithm without Learning of Neighborhood Vectors
// by Hiroki Kusumoto and Yoshiyasu Takefuji, Keio Univ.
// kusu@sfc.keio.ac.jp, hiroki.kusumoto@gmail.com, takefuji@sfc.keio.ac.jp
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

int ***k_som(int **D, int data_num, int dimension, int map_size, int iteration, int seed){
  int d_n, dim, map_size_now, search_space_size, ite, interval, x,y,xx,yy,***W;
  int distance_min_x,distance_min_y,distance_min,distance;
  for( d_n = 0; d_n < data_num; d_n++){
    for( dim = 0; dim < dimension; dim++){
    }
  }
  srand(seed);
  W = (int ***)malloc(map_size * sizeof(int **));
  for(x = 0; x < map_size; x++){
    W[x] = (int **)malloc(map_size * sizeof(int *));
    for(y = 0; y < map_size; y++){
      W[x][y]= (int *)malloc (dimension * sizeof(int));
    }
  }
  for(dim=0;dim<dimension;dim++){
    for(x=0;x<map_size;x++){
      for(y=0;y<map_size;y++){
        W[x][y][dim]=0;
      }
    }
    W[0][0][dim]=rand()%10000-5000;
    W[0][map_size-1][dim]=rand()%10000-5000;
    W[map_size-1][0][dim]=rand()%10000-5000;
    W[map_size-1][map_size-1][dim]=rand()%10000-5000;
  }
  map_size_now=2;
  xx=0;yy=0; //(xx,yy) is the bottom left of search space
  while(map_size>=map_size_now){
    for(ite=0;ite<iteration;ite++){
      d_n=rand()%data_num;
      search_space_size=map_size_now;
      interval=map_size-1;
      xx=0;yy=0;
      while(1){
        distance_min_x=xx;  distance_min_y=yy;  distance_min=0;
        for(dim=0;dim<dimension;dim++){
          distance_min+=pow(W[xx][yy][dim]-D[d_n][dim],2);
        }
        for(x=xx;x<=xx+interval;x+=interval){
          for(y=yy;y<=yy+interval;y+=interval){
            if(x!=xx||y!=yy){
              distance=0;
              for(dim=0;dim<dimension;dim++){
                distance+=pow(W[x][y][dim]-D[d_n][dim],2);
              }
              if(distance<distance_min){
                distance_min=distance; distance_min_x=x; distance_min_y=y;
              }
            }
          }
        }
        if(search_space_size==2){break;}
        search_space_size=(search_space_size+1)/2;
        interval=interval/2;
        if(xx!=distance_min_x){xx+=interval;}
        if(yy!=distance_min_y){yy+=interval;}
      }//while(1)
      //learning
      for(dim=0;dim<dimension;dim++){
        W[distance_min_x][distance_min_y][dim]+=(D[d_n][dim]-W[distance_min_x][distance_min_y][dim])/200;
      }
    }//for(ite)
    //iteration*=1.5; you can increase the number of learning times when the map is subdivided
    if(map_size_now>=map_size){break;}
    map_size_now=map_size_now*2-1;
    //Assign average values to new emerging weight vectors
          //1. centers of sides
    for(x=0;x<map_size;x+=interval){
      for(y=0;y<map_size-interval;y+=interval){
        for(dim=0;dim<dimension;dim++){
          W[x][y+interval/2][dim]=(W[x][y][dim]+W[x][y+interval][dim])/2;
          W[y+interval/2][x][dim]=(W[y][x][dim]+W[y+interval][x][dim])/2;
        }
      }
    }
          //2. centers of planes
    for(x=0;x<map_size-interval;x+=interval){
      for(y=0;y<map_size-interval;y+=interval){
        for(dim=0;dim<dimension;dim++){
          W[x+interval/2][y+interval/2][dim]=(W[x+interval/2][y][dim]+W[x+interval/2][y+interval][dim])/2;
        }
      }
    }
  }
  return(W);
}

int **k_mapping(int ***W, int **D, int data_num, int dimension, int map_size){
  int d_n, dim, map_size_now, search_space_size, ite, interval, x,y,xx,yy,**R;
  int distance_min_x,distance_min_y,distance_min,distance;

  R = (int **)malloc(data_num * sizeof(int *));
  for(d_n = 0; d_n < data_num; d_n++){
    R[d_n] = (int *)malloc(2 * sizeof(int ));
  }

  for(d_n=0;d_n<data_num;d_n++){
    search_space_size=map_size;
    interval=map_size-1;
    xx=0;yy=0;
    while(1){
      distance_min_x=xx;  distance_min_y=yy;  distance_min=0;
      for(dim=0;dim<dimension;dim++){
        distance_min+=pow(W[xx][yy][dim]-D[d_n][dim],2);
      }
      for(x=xx;x<=xx+interval;x+=interval){
        for(y=yy;y<=yy+interval;y+=interval){
          if(x!=xx||y!=yy){
            distance=0;
            for(dim=0;dim<dimension;dim++){
              distance+=pow(W[x][y][dim]-D[d_n][dim],2);
            }
            if(distance<distance_min){
              distance_min=distance; distance_min_x=x; distance_min_y=y;
            }
          }
        }
      }
      if(search_space_size==2){break;}
      search_space_size=(search_space_size+1)/2;
      interval=interval/2;
      if(xx!=distance_min_x){xx+=interval;}
      if(yy!=distance_min_y){yy+=interval;}
    }//while(1)
    R[d_n][0]=distance_min_x; R[d_n][1]=distance_min_y;
  }
  return (R);
}

int main(int argc, char* argv[]){
  int seed, map_size, data_num, d_n, dimension, dim, iteration, x,y,i;
  int **Int_Data, ***WeightVector, **Result; //data array [d_n][dim],  weight vectors [x][y][dim] (x,y) is a coordinate of the map
  int LINEMAX=10000; // max number of characters of lines of your input data file
  char s[LINEMAX+1], fname[100], *ptok;
  FILE *fp;
  ///////////////read file/////////////////
  map_size=0;seed=0;
  if( argv[2] == NULL ){
    map_size=17;
  }else{
    if((map_size = atoi(argv[2]))==0){
      printf("Error! The second argv is not an integer. (pls enter map size)\n");
      exit(1);
    }
  }
  if(argv[3]==NULL){
    seed=1;
  }else{
    if((seed = atoi(argv[3]))==0){
      printf("Error! The third argv is not an integer. (pls enter seed of random number)\n");
      exit(1);
    }
  }
  strcpy(fname, argv[1]);
  //Open File
  if ((fp = fopen(fname,"r")) == NULL) {
    printf("file open error\n");
    exit(1);
  }
  fgets(s, LINEMAX, fp);
  //Count the number of dimensions
  dim = 0;
  for( i = 0; s[i] != '\n'; i++ ){
    if( s[i] == ',' ){
      dim++;
    }
  }
  dimension=dim+1;
  //Count the number of data
  d_n=1;
  while (fgets(s, LINEMAX, fp) != NULL) {
    d_n++;
  }
  data_num=d_n;
  fclose(fp);
  Int_Data = (int **)malloc(data_num * sizeof(int *));
  for(d_n = 0; d_n < data_num; d_n++){
    Int_Data[d_n] = (int *)malloc(dimension * sizeof(int));
  }
  // Store the data
  fp = fopen(fname,"r");
  for( d_n = 0; d_n < data_num; d_n++){
    fgets(s, LINEMAX, fp);
    ptok = strtok(s ,",");
    for( dim = 0; dim < dimension; dim++){
      Int_Data[d_n][dim] = atof(ptok);
      ptok = strtok(NULL,",");
    }
  }
  fclose(fp);   //Close file
  /////////////////read file  End///////////////////
  iteration=25000; //the number of learnin times at each map size
  WeightVector=k_som(Int_Data, data_num, dimension, map_size, iteration, seed);// learning
  Result=k_mapping(WeightVector, Int_Data, data_num, dimension, map_size);// mapping
  if ((fp = fopen("ksom_result.txt","w")) == NULL) {
    printf("file open error for output\n");
    exit(-1);
  }
  for(d_n=0;d_n<data_num;d_n++){
    fprintf(fp,"%d,%d\n",Result[d_n][0],Result[d_n][1]);
  }
  fclose(fp);
  
  if ((fp = fopen("ksom_map.txt","w")) == NULL) {
    printf("file open error for output\n");
    exit(-1);
  }
  for(dim=0;dim<dimension;dim++){
    for(x=0;x<map_size;x++){
      fprintf(fp,"%d",WeightVector[x][0][dim]);
      for(y=1;y<map_size;y++){
        fprintf(fp,",%d",WeightVector[x][y][dim]);
      }
      fprintf(fp,"\n");
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
  return (0);
}

