/*date:May 9, 2007 by takefuji
analog tiny2313 via usb for tragi
*/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/wdt.h>
#include "usbdrv.h"

void delay(unsigned int p)
{
  unsigned char i;  
  unsigned char j;	 //one loop is 3.8us with 12MHz
  for(i=0;i<p;i++)
    for(j=0;j<10;j++);
}

uchar usbFunctionSetup(uchar data[8])
{
static uchar count;
static uchar replybuf[1];						
    usbMsgPtr = replybuf;
    if(data[1] == 0){		
	count=0;
	PORTB=0;			// Vc=0
	delay(9);
	DDRB=0xfc;			//PB0 and PB1 are set as inputs.
	while ((ACSR&0x20) == 0) {count++;}
	replybuf[0] = count;
	DDRB=0xfd;
	return 1;		}
    else if(data[1]==1){
	PORTD = data[2];	
	return 0;	}
    
	return 0;
}


int main(void)
{
  PORTD = 0;
  PORTB = 0;		/* no pullups on USB and ISP pins */
  DDRD = 0xFA;		/* all outputs except PD2 = INT0 and PD0*/
  DDRB = 0xFD;      /* all output except PB1*/
  ACSR= 0x00;		//analog comparator enabled
  
  usbInit();
  sei();
  for(;;){	        /* main event loop */
    	usbPoll();
	  }
  return 0;
}
