//-----------------------------------------------------------------------------
//  Attiny85 by http://maple.ces.kyutech.ac.jp/~jkoba/index.php?USART%20(ATmega168)
//  Internal 8 MH RC Osc. (1/8M = 125 ns) 
//  barometer bmp085 by jh3iyo
//-----------------------------------------------------------------------------
#define F_CPU   16500000
#define FOSC   16500000
#include <avr/io.h>
#include <avr/wdt.h>
#include <avr/eeprom.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include <util/twi.h>
#include <avr/interrupt.h>
#include <i2cmaster.h>
#include <avr/iotn85.h>
#define sensor_address 0xee
#define BAUD    9600
#define UBRR    FOSC/16/BAUD-1


#include "usbdrv.h"
#include "oddebug.h"

static void timerInit(void)
{
    TCCR1 = 0x0b;           /* select clock: 16.5M/1k -> overflow rate = 16.5M/256k = 62.94 Hz */
}

PROGMEM char usbHidReportDescriptor[USB_CFG_HID_REPORT_DESCRIPTOR_LENGTH] = { /* USB report descriptor */
    0x05, 0x01,                    // USAGE_PAGE (Generic Desktop)
    0x09, 0x06,                    // USAGE (Keyboard)
    0xa1, 0x01,                    // COLLECTION (Application)
    0x05, 0x07,                    //   USAGE_PAGE (Keyboard)
    0x19, 0xe0,                    //   USAGE_MINIMUM (Keyboard LeftControl)
    0x29, 0xe7,                    //   USAGE_MAXIMUM (Keyboard Right GUI)
    0x15, 0x00,                    //   LOGICAL_MINIMUM (0)
    0x25, 0x01,                    //   LOGICAL_MAXIMUM (1)
    0x75, 0x01,                    //   REPORT_SIZE (1)
    0x95, 0x08,                    //   REPORT_COUNT (8)
    0x81, 0x02,                    //   INPUT (Data,Var,Abs)
    0x95, 0x01,                    //   REPORT_COUNT (1)
    0x75, 0x08,                    //   REPORT_SIZE (8)
    0x25, 0x65,                    //   LOGICAL_MAXIMUM (101)
    0x19, 0x00,                    //   USAGE_MINIMUM (Reserved (no event indicated))
    0x29, 0x65,                    //   USAGE_MAXIMUM (Keyboard Application)
    0x81, 0x00,                    //   INPUT (Data,Ary,Abs)
    0xc0                           // END_COLLECTION
};

signed int ac1,ac2,ac3,b1,b2,mb,mc,md;
unsigned int ac4,ac5,ac6;

signed long t, p, ut, up, x1, x2, x3, b3, b5, b6;
	unsigned long b4,b7;

unsigned int two_byte_read( unsigned char eeprom, unsigned char address)
{
unsigned int i;
i2c_start_wait(eeprom+I2C_WRITE);
_delay_us(1);
i2c_write(address);
_delay_us(1);
i2c_rep_start(eeprom+I2C_READ);
_delay_us(1);
i=i2c_readAck()<<8;
_delay_us(1);
i |=i2c_readNak();
_delay_us(1);
i2c_stop();
return i;
}

char one_byte_write(unsigned char eeprom, unsigned char address, unsigned char data)
{
i2c_start(eeprom+I2C_WRITE);
_delay_us(1);
i2c_write(address);
_delay_us(1);
i2c_write(data);
_delay_us(1);
i2c_stop();
return 0;
}

unsigned long three_byte_read(unsigned char eeprom, unsigned char address)
{
unsigned long i;
i2c_start_wait(eeprom+I2C_WRITE);
_delay_us(1);
i2c_write(address);
_delay_us(1);
i2c_rep_start(eeprom+I2C_READ);
_delay_us(1);
i =(unsigned long)i2c_readAck()<<16;
_delay_us(1);
i |=i2c_readAck()<<8;
_delay_us(1);
i |=i2c_readNak();
i2c_stop();
return i;
}


//*********************************************************
// CZT[ BMP085 (I2C)
//*********************************************************

// BMP085 
void init_bmp085 () {
	i2c_init();

	// Lu[Vf[^Ǎ
	ac1 = two_byte_read(sensor_address, 0xaa);
	ac2 = two_byte_read(sensor_address, 0xac);
	ac3 = two_byte_read(sensor_address, 0xae);
	ac4 = two_byte_read(sensor_address, 0xb0);
	ac5 = two_byte_read(sensor_address, 0xb2);
	ac6 = two_byte_read(sensor_address, 0xb4);
	b1 = two_byte_read(sensor_address, 0xb6);
	b2 = two_byte_read(sensor_address, 0xb8);
	mb = two_byte_read(sensor_address, 0xba);
	mc = two_byte_read(sensor_address, 0xbc);
	md = two_byte_read(sensor_address, 0xbe);
}

void getp_bmp085 () {
	i2c_init();
	// xǍ
	one_byte_write(sensor_address, 0xf4, 0x2e);
	_delay_ms(5);
	ut = two_byte_read(sensor_address, 0xf6);
_delay_ms(1);

	// CǍ
	one_byte_write(sensor_address, 0xf4, 0xf4 );
	_delay_ms(10);
	_delay_ms(10);
	_delay_ms(10);
	up = three_byte_read(sensor_address, 0xf6)>>8;

	// x␳ (temp in 0.1C)
	x1 = (ut - ac6) * ac5 >>15;
	x2 = ((int32_t)mc << 11) / (x1 + md);
	b5 = x1 + x2;
	t = (b5 + 8) >>4;

	// C␳ (press in Pa)
	b6 = b5 - 4000;
	x1 = (b2 * (b6 * b6 >>12)) >>11;
	x2 = ac2 * b6 >>11;
	x3 = x1 + x2;
	b3 = ((int32_t) ac1 * 4 + x3 + 2) >> 2;
	x1 = ac3 * b6 >>13;
	x2 = (b1 * (b6 * b6 >>12)) >>16;
	x3 = ((x1 + x2) + 2) >>2;
	b4 = (ac4 * (uint32_t)(x3 + 32768)) >>15;
	b7 = ((uint32_t)up - b3) * 50000;
	if (b7 < 0x80000000) {
		p = (b7 * 2) / b4;
	} else {
		p = (b7 / b4) * 2;
	}
	x1 = (p >>8) * (p >>8);
	x1 = (x1 * 3038) >>16;
	x2 = (-7357 * p) >>16;
	p = p + ((x1 + x2 + 3791) >>4);
}

uchar usbFunctionSetup(uchar data[8])
{
static uchar replybuf[20];	
usbMsgPtr = replybuf;
unsigned char c=data[1];
unsigned char temp[8];
unsigned char press[12];

if(c=='p'){
sprintf(replybuf,"%s%ld%s","p=",p,"  ");
	return 10;}
else if(c=='t'){
sprintf(replybuf,"%s%ld%s","t=",t,"  ");
	return 7;}
else if(c=='h'){
sprintf(replybuf,"%s"," hello ");
softuart_init();
softuart_puts(replybuf);
	return 7;}
else if(c=='r'){
init_bmp085();
getp_bmp085();
sprintf(temp,"%s%ld%s","t=",t," ");
sprintf(press,"%s%ld%s","p=",p," ");
sprintf(replybuf,"%s%s",temp,press);
	return 17;}
else {
sprintf(temp,"%s%ld%s","t=",t," ");
sprintf(press,"%s%ld%s","p=",p," ");
sprintf(replybuf,"%s%s",temp,press);
softuart_init();
softuart_puts(replybuf);
return 17;}
}

static void calibrateOscillator(void)
{
uchar       step = 128;
uchar       trialValue = 0, optimumValue;
int         x, optimumDev, targetValue = (unsigned)(1499 * (double)F_CPU / 10.5e6 + 0.5);

    /* do a binary search: */
    do{
        OSCCAL = trialValue + step;
        x = usbMeasureFrameLength();    /* proportional to current real frequency */
        if(x < targetValue)             /* frequency still too low */
            trialValue += step;
        step >>= 1;
    }while(step > 0);
    /* We have a precision of +/- 1 for optimum OSCCAL here */
    /* now do a neighborhood search for optimum value */
    optimumValue = trialValue;
    optimumDev = x; /* this is certainly far away from optimum */
    for(OSCCAL = trialValue - 1; OSCCAL <= trialValue + 1; OSCCAL++){
        x = usbMeasureFrameLength() - targetValue;
        if(x < 0)
            x = -x;
        if(x < optimumDev){
            optimumDev = x;
            optimumValue = OSCCAL;
        }
    }
    OSCCAL = optimumValue;
}
/*
Note: This calibration algorithm may try OSCCAL values of up to 192 even if
the optimum value is far below 192. It may therefore exceed the allowed clock
frequency of the CPU in low voltage designs!
You may replace this search algorithm with any other algorithm you like if
you have additional constraints such as a maximum CPU clock.
For version 5.x RC oscillators (those with a split range of 2x128 steps, e.g.
ATTiny25, ATTiny45, ATTiny85), it may be useful to search for the optimum in
both regions.
*/

void    usbEventResetReady(void)
{
    calibrateOscillator();
    eeprom_write_byte(0, OSCCAL);   /* store the calibrated value in EEPROM */
}


int main()
{
uchar i;
uchar   calibrationValue;

 calibrationValue = eeprom_read_byte(0); /* calibration value from last time */
    if(calibrationValue != 0xff){
        OSCCAL = calibrationValue;
    }
    odDebugInit();
    usbDeviceDisconnect();
    for(i=0;i<20;i++){  /* 300 ms disconnect */
        _delay_ms(15);
    }
    usbDeviceConnect();
	init_bmp085();
	getp_bmp085();

    timerInit();
    usbInit();
    sei();
    for(;;){    /* main event loop */
        usbPoll();
        }
    return 0;

}
