/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil;

import gameCanvasUtil.saveDataUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;

public class imageManager {
    public static final int NUMBER_AUTO_CULC = -1;
    public static final int READ_LIST_FROM_TEXT = -2;
    private static final int IMAGE_MAX_NUM = 1024;
    private Image[] img;
    private String imageFile;
    private byte[] image_buffer = new byte[512000];

    public imageManager(String string, int n) {
        this.imageFile = string;
        if (n == -1) {
            this.img = new Image[1024];
            this.loadNumberingImage(false);
        } else if (n == -2) {
            String[] stringArray = saveDataUtil.readResourceStrings(string);
            this.img = new Image[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.img[i] = this.loadImage(stringArray[i]);
            }
        } else {
            this.img = new Image[n];
            this.loadNumberingImage(true);
        }
    }

    private void loadNumberingImage(boolean bl) {
        String[] stringArray = new String[]{".gif", ".GIF", ".png", ".PNG", ".jpg", ".JPG"};
        System.out.println("load Numbered image");
        for (int i = 0; i < this.img.length; ++i) {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                this.img[i] = this.loadImage(this.imageFile + i + stringArray[n]);
                if (this.img[i] != null) break;
            }
            if (n != stringArray.length || bl) continue;
            System.out.println("image file " + i);
            break;
        }
    }

    private Image loadImage(String string) {
        try {
            Image image = null;
            int n = 0;
            int n2 = 0;
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            if (inputStream == null) {
                return null;
            }
            while ((n2 = inputStream.read(this.image_buffer, n, this.image_buffer.length - n)) > 0) {
                n += n2;
            }
            inputStream.close();
            byte[] byArray = new byte[n];
            System.arraycopy(this.image_buffer, 0, byArray, 0, n);
            image = Toolkit.getDefaultToolkit().createImage(byArray, 0, n);
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getPicXsize(int n) {
        try {
            return this.img[n].getWidth(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getPicYsize(int n) {
        try {
            return this.img[n].getHeight(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public Image getImage(int n) {
        return this.img[n];
    }
}

