/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

class tokenManager {
    static final int TOKEN_NUMBER = 0;
    static final int TOKEN_IDENTIFY = 1;
    static final int TOKEN_CHAR = 2;
    static final int TOKEN_STRING = 3;
    static final int TOKEN_MARK = 4;
    static final int TOKEN_UNKNOWN = 5;
    private ArrayList tokens = new ArrayList();
    private String[] ch_list = new String[]{">>>", ">>", "<<", "++", "--", "+=", "-=", "*=", "/=", "%=", "&&", "||", "==", "!=", "<=", ">=", "<", ">", "!", "&", "|", "^", "~", "?", ":", "=", ".", ",", ";", "+", "-", "*", "/", "%", "(", ")", "[", "]", "{", "}"};
    private String[][] comment = new String[][]{{"//", "\n"}, {"/*", "*/"}};

    public tokenManager(String string) {
        this.analysis(string);
    }

    private void analysis(String string) {
        int n = string.length();
        int n2 = 32;
        int n3 = 0;
        block0: while (n3 < n) {
            int n4;
            int n5 = n3;
            if ((n3 = this.comment_space_skip(string, n3)) != n5) continue;
            int n6 = this.ch_check(string, n3);
            if (n6 != -1) {
                n3 += this.ch_list[n6].length();
                this.addToken(this.ch_list[n6]);
                continue;
            }
            if (n3 != n5) continue;
            if (string.charAt(n3) == '\"') {
                for (n4 = n3 + 1; n4 < n; ++n4) {
                    if (string.charAt(n4) != '\"') continue;
                    this.addToken(string.substring(n3, n4 + 1));
                    n3 = n4 + 1;
                    continue block0;
                }
                continue;
            }
            if (string.charAt(n3) == '\'') {
                for (n4 = n3 + 1; n4 < n; ++n4) {
                    if (string.charAt(n4) != '\'') continue;
                    this.addToken(string.substring(n3, n4 + 1));
                    n3 = n4 + 1;
                    continue block0;
                }
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                n3 = this.getNumberEnd(string, n3);
                this.addToken(string.substring(n5, n3));
                continue;
            }
            if (!this.isIdentifyStart(string.charAt(n3))) break;
            n3 = this.getIdentifyEnd(string, n3);
            this.addToken(string.substring(n5, n3));
        }
    }

    private boolean isIdentifyStart(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return c == '_';
    }

    private int getNumberEnd(String string, int n) {
        while ('0' <= string.charAt(n) && string.charAt(n) <= '9' || 'a' <= string.charAt(n) && string.charAt(n) <= 'f' || 'A' <= string.charAt(n) && string.charAt(n) <= 'F' || string.charAt(n) == 'X' || string.charAt(n) == 'x' || string.charAt(n) == '.') {
            ++n;
        }
        return n;
    }

    private int getIdentifyEnd(String string, int n) {
        while ('0' <= string.charAt(n) && string.charAt(n) <= '9' || 'a' <= string.charAt(n) && string.charAt(n) <= 'z' || 'A' <= string.charAt(n) && string.charAt(n) <= 'Z' || '_' == string.charAt(n)) {
            ++n;
        }
        return n;
    }

    private int ch_check(String string, int n) {
        int n2 = this.ch_list.length;
        string = string.substring(n, string.length());
        for (int i = 0; i < n2; ++i) {
            if (string.indexOf(this.ch_list[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    private int comment_space_skip(String string, int n) {
        boolean bl = true;
        int n2 = string.length();
        while (bl) {
            int n3;
            bl = false;
            while (n < n2 && (string.charAt(n) == ' ' || string.charAt(n) == '\t' || string.charAt(n) == '\n' || string.charAt(n) == '\r')) {
                bl = true;
                ++n;
            }
            int n4 = -1;
            String string2 = string.substring(n, string.length());
            for (n3 = 0; n3 < this.comment.length; ++n3) {
                if (string2.indexOf(this.comment[n3][0]) != 0) continue;
                n4 = n3;
                break;
            }
            if (n4 < 0) continue;
            bl = true;
            n3 = string.length();
            for (int i = 1; i < this.comment[n4].length; ++i) {
                n3 = string.indexOf(this.comment[n4][i], n) + this.comment[n4][i].length();
                if (n3 <= n) continue;
                n = n3;
            }
        }
        return n;
    }

    private void addToken(String string) {
        this.tokens.add(string);
        System.out.println("" + (this.getTokenNum() - 1) + "\t:" + string);
    }

    public String getToken(int n) {
        if (n < this.getTokenNum()) {
            return (String)this.tokens.get(n);
        }
        return null;
    }

    public int getTokenNum() {
        return this.tokens.size();
    }

    public int getTokenType(int n) {
        String string = this.getToken(n);
        if (string.charAt(0) == '\'') {
            return 2;
        }
        if (string.charAt(0) == '\"') {
            return 3;
        }
        if (this.isIdentifyStart(string.charAt(0))) {
            return 1;
        }
        if (this.ch_check(string, 0) >= 0) {
            return 4;
        }
        if (string.charAt(0) <= '0' && string.charAt(0) <= '9') {
            return 0;
        }
        return 5;
    }
}

