package taskSystem;

public class taskManager {
	
	static taskManager _this;
	
	/** シングルトン
	 * @return タスクマネージャークラスへのインスタンスを返します
	 */
	static taskManager getInstance(){
		if(_this==null)
			_this = new taskManager();
		return _this;
	}

	/** シングルトンなので、プライベートコンストラクタ
	 */
	private taskManager(){
	}

	///タスクグループです
	private taskGroup taskgroups[];
	
	/** タスクのグループをセットします 
	 * @param n タスクグループの数をセットします
	 */
	public void setTaskGroupNum(int n){
		this.taskgroups = new taskGroup[n];
		for(int i=0;i<n;i++){
			taskgroups[i] = new taskGroup();
		}
	}
	
	/** 全てのタスクを更新します 
	 */
	public void update(){
		for(int i=0;i<taskgroups.length;i++){
			taskgroups[i].update();
		}
	}
	
	/** 全てのタスクを描画します
	 */
	public void draw(){
		for(int i=0;i<taskgroups.length;i++){
			taskgroups[i].draw();
		}
	}
	
	/** タスクグループ間の衝突判定を行います
	 * 
	 * 引数srcに指定したタスクグループのcollisionが呼び出されます
	 * @param src Collisionを呼び出すタスク
	 * @param target Collisionの引数となるタスク
	 */
	public void collision(taskGroup src,taskGroup target){
		src.collision(target);
	}
	
	/** 指定したタスクグループにタスクを追加する
	 * 
	 * @param group_id タスクを追加するグループのIDを指定する
	 * @param t タスクを指定する
	 */
	public void addTask(int group_id,taskBase t){
		this.taskgroups[group_id].addTask(t);
	}
	
	/** あるグループのタスクをクリアする(各タスクは終了処理を行わない)
	 * @param gid グループのIDを指定
	 */
	public void clearGroupTask(int gid){
		this.taskgroups[gid].clearTask();
	}
	
	/** あるグループのタスクを全て殺す(各タスクは終了処理を行う)
	 * @param gid グループのIDを指定
	 */
	public void killGroupTask(int gid){
		this.taskgroups[gid].killTask();
	}
	
}
