package taskSystem;


/**
 * 
 * @author Administrator
 *
 */
public abstract class taskBase {

	/** タスクが生成されたときに呼び出されます 
	 */
	public abstract void initTask();
	
	/** タスクの更新処理を書いてください
	 */
	public abstract void updateTask();
	
	/** タスクの描画処理を書いてください
	 */
	public abstract void drawTask();

	/** タスクが消滅するときに呼び出されます
	 */
	public abstract void finelTask();

	/** 衝突のチェックをかけたときに呼び出されます。
	 * @param t 比べる対象のタスクです。
	 */
	public abstract void collision(taskBase t);

	
	/// リンクリスト。次のタスクへの参照。
	public taskBase next_task;
	
	/// タスクの位置
	private double posx,posy;
	/// 重力の力のベクトル
	private double gravity_x,gravity_y;
	/// 加速度のベクトル
	private double vx,vy;
	
	/** 重力のベクトルを設定する
	 * @param gx Xへの重力
	 * @param gy Yへの重力
	 */
	public void setGravity(double gx,double gy){
		gravity_x = gx;
		gravity_y = gy;
	}
	
	/** Xの加速度を指定する
	 * 
	 * @param vx Xの加速度
	 */
	public void setVx(double vx){
		this.vx = vx;
	}
	
	/** Xの加速度をゲットする
	 * 
	 * @return Xの加速度
	 */
	public double getVx(){
		return this.vx;
	}
	
	/** Yの加速度をセットする
	 * 
	 * @param vy Yの加速度
	 */
	public void setVy(double vy){
		this.vy = vy;
	}
	
	/** Yの加速度を得る
	 * 
	 * @return Yの加速度
	 */
	public double getVy(){
		return this.vy;
	}
	
	/** 加速度を指定する
	 * 
	 * @param vx Xの加速度
	 * @param vy Yの加速度
	 */
	public void setV(double vx,double vy){
		this.vx = vx;
		this.vy = vy;
	}

	
	/** 加速度や重力を元に位置情報を更新
	 */
	public void culc(){
		this.vx += this.gravity_x;
		this.vy += this.gravity_y;
		this.posx += this.vx;
		this.posy += this.vy;
	}
	
	/** Xの位置を得る
	 * 
	 * @return Xの位置
	 */
	public double getPosX(){
		return this.posx;
	}
	
	/** Yの位置を得る
	 * 
	 * @return Yの位置
	 */
	public double getPosY(){
		return this.posy;
	}
	
	/** Xの位置を指定する
	 * 
	 * @param x Xの位置
	 */
	public void setPosX(double x){
		this.posx = x;
	}
	
	/** Yの位置を指定する
	 * 
	 * @param y Yの位置
	 */
	public void setPosY(double y){
		this.posy = y;
	}
	
	/** X,Yの位置を指定する
	 * 
	 * @param x Xの位置
	 * @param y Yの位置
	 */
	public void setPos(double x,double y){
		this.posx = x;
		this.posy = y;
	}
	
	
	/// タスクの生存フラグ
	private boolean isAlive = true;

	/** taskGroup関数で呼び出されます
	 * 
	 * @return taskが消滅したかを返します
	 */
	public boolean isDead(){
		return !isAlive;
	}
	
	
	/** タスクを殺します。
	 */
	public void taskDie(){
		this.isAlive = false;
	}
	
	
}
