import gameCanvasUtil.inputManager;
import gameCanvasUtil.gameCanvas;

import java.awt.*;
import java.awt.event.*;

/** Canvas(描画を管理するクラス)
 *
 * @author kuro@ shift>>sega
 *
 * 内部にスクリーンバッファを持っていて、ダブルバッファリングとかをするクラス。<br />
 * あと、更新処理をgameCanvasにたらいまわしする
 */
public class appCanvas extends Canvas implements MouseMotionListener,MouseListener,KeyListener{

	/// serialVersionUID
	private static final long serialVersionUID = 1L;
	/// オフスクリーン用のImageオブジェクト
	private Image offImage;
	/// オフスクリーンバッファ
	private Graphics offScreen;
	/// キー入力とかのクラス
	private inputManager input = inputManager.getInstance();

	/** コンストラクタ
	 * イベントハンドラの登録とか・・・
	 */
	public appCanvas(){
		super();

		addKeyListener(this);
		addMouseListener(this);
		addMouseMotionListener(this);
		this.setSize(gameCanvas.WIDTH,gameCanvas.HEIGHT);
	}

	/** 更新処理をすべき時に呼び出されます
	 */
	public void updateMessage(){
		gameCanvas.getInstance().updateMessage();
		input.updateKeyData();
	}

	/** 描画処理をすべき時に呼び出されます。
	 */
	public void drawMessage(){
		gameCanvas.getInstance().drawMessage();
		repaint();
	}

	/** repaint呼び出したら　これが呼び出されるはずです・・・
	 * @param g 描画対象
	 */
	public void update(Graphics g){
		this.paint(g);
	}

	/** 描画が必要になったら呼び出されます
	 * @param g 描画対象
	 */
	public void paint(Graphics g) {
		if(offImage==null){
			offImage = createImage(gameCanvas.WIDTH,gameCanvas.HEIGHT);
			offScreen = offImage.getGraphics();
			gameCanvas.getInstance().setGraphics( offScreen , offImage );
			this.requestFocusInWindow();
		}
		g.drawImage(offImage,0,0,null);
	}



	/** キーが押されたときに呼び出されます
	 * @param e キーイベント情報
	 */
	public synchronized void keyPressed(KeyEvent e) {
		int key = e.getKeyCode();
		if( key == KeyEvent.VK_ESCAPE ){ //ESCでリセット
			if( gameCanvas.getInstance().showYesNoDialog("ゲームをリセットしますか？") ){
				gameCanvas.getInstance().resetGame();
			}
		}

		input.keyPressed(e);
	}
	/** キーが離されたときに呼び出されます
	 * @param e キーイベント情報
	 */
	public synchronized void keyReleased(KeyEvent e) {
		input.keyReleased(e);
	}
	/** キーがタイプされたときに呼び出されます
	 * @param e キーイベント情報
	 */
	public void keyTyped(KeyEvent e) {
	}

	/** マウスが画面に入ったときに呼び出される？
	 * @param e マウスイベント
	 */
	public void mouseEntered(MouseEvent e) {
		this.input.mouseEntered(e);
	}
	/** マウスが画面から出たときに呼び出される？
	 * @param e マウスイベント
	 */
	public void mouseExited(MouseEvent e) {
		this.input.mouseExited(e);
	}
	/** マウスがクリックときに呼び出される？
	 * @param e マウスイベント
	 */
	public void mouseClicked(MouseEvent e) {
		this.input.mouseClicked(e);
	}
	/** マウスのボタンが押されたとき呼び出される
	 * @param e マウスイベント
	 */
	public void mousePressed(MouseEvent e) {
		this.input.mousePressed(e);
	}
	/** マウスのボタンが離されたとき呼び出される
	 * @param e マウスイベント
	 */
	public void mouseReleased(MouseEvent e) {
		this.input.mouseReleased(e);
	}
	/** マウスドラッグされたとき呼び出される
	 * @param e マウスイベント
	 */
	public void mouseDragged( MouseEvent e ) {
		this.input.mouseDragged(e);
	}
	/** マウスが動いたとき呼び出される
	 * @param e マウスイベント
	 */
	public void mouseMoved( MouseEvent e ) {
		this.input.mouseMoved(e);
	}

}
