/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;

public class generateDebugCode {
    public String generate(tokenManager tokenManager2, varInfoManager varInfoManager2, boolean bl) {
        String string = "package debugGames;\n";
        String string2 = this.generateDebugInit(varInfoManager2, bl);
        String string3 = this.generateDebugUpdate(varInfoManager2);
        String string4 = "debugWindow.getInstance().removeObject(this);";
        int n = 0;
        for (int i = 0; i < tokenManager2.getTokenNum(); ++i) {
            if (n == 2 && this.isMethodEnd(tokenManager2, i, "finalGame")) {
                string = string + string4;
            }
            if (n == 2 && this.isMethodEnd(tokenManager2, i, "initGame")) {
                string = string + string2;
            }
            string = string + tokenManager2.getToken(i);
            string = this.isEndLine(tokenManager2, i) ? string + "\n" : string + " ";
            if (n == 1 && this.isUpdateStart(tokenManager2, i)) {
                string = string + string3;
            }
            if (tokenManager2.getToken(i).equals("{")) {
                ++n;
            }
            if (!tokenManager2.getToken(i).equals("}")) continue;
            --n;
        }
        return string;
    }

    private boolean isMethodEnd(tokenManager tokenManager2, int n, String string) {
        if (tokenManager2.getTokenNum() <= n) {
            return false;
        }
        if (!tokenManager2.getToken(n).equals("}")) {
            return false;
        }
        int n2 = 0;
        for (int i = n - 1; i > 0; --i) {
            if (tokenManager2.getToken(i) == "{") {
                ++n2;
            } else if (tokenManager2.getToken(i) == "}") {
                --n2;
            }
            if (n2 != 1) continue;
            while (i > 0 && tokenManager2.getTokenType(i) != 1) {
                --i;
            }
            System.out.println(tokenManager2.getToken(i));
            return tokenManager2.getToken(i).equals(string);
        }
        return false;
    }

    private boolean isEndLine(tokenManager tokenManager2, int n) {
        return tokenManager2.getToken(n).equals("{") || tokenManager2.getToken(n).equals("}") || tokenManager2.getToken(n).equals(";");
    }

    private boolean isUpdateStart(tokenManager tokenManager2, int n) {
        if (n < 4) {
            return false;
        }
        return tokenManager2.getToken(n - 3).equals("updateGame") && tokenManager2.getToken(n - 2).equals("(") && tokenManager2.getToken(n - 1).equals(")") && tokenManager2.getToken(n).equals("{");
    }

    private String generateDebugInit(varInfoManager varInfoManager2, boolean bl) {
        String string = "debugWindow.getInstance().setObject(\"game\",this);\n";
        for (int i = 0; i < varInfoManager2.getVarNum(); ++i) {
            string = string + this.generateDebugVarInit(varInfoManager2.getVarInfo(i)) + "\n";
        }
        if (bl) {
            string = string + "debugWindow.getInstance().setRunningFlag(true);\n";
        }
        return string;
    }

    private String generateDebugUpdate(varInfoManager varInfoManager2) {
        int n;
        String string = "debugWindow.getInstance().setCurrent(this);\n";
        string = string + "if(!debugWindow.getInstance().getRunningFlag()){\n";
        string = string + "debugWindow.getInstance().iterateVarStart();\n";
        for (n = 0; n < varInfoManager2.getVarNum(); ++n) {
            string = string + this.generateDebugVarCommit(varInfoManager2.getVarInfo(n)) + "\n";
        }
        string = string + "return;\n";
        string = string + "}\n";
        string = string + "debugWindow.getInstance().iterateVarStart();";
        for (n = 0; n < varInfoManager2.getVarNum(); ++n) {
            string = string + this.generateDebugVarUpdate(varInfoManager2.getVarInfo(n)) + "\n";
        }
        return string;
    }

    private String generateDebugVarInit(varInfo varInfo2) {
        String string = "debugWindow.getInstance().addVar(";
        String string2 = ");";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "\"" + varInfo2.getName() + "\"";
        string3 = this.getInitDeclarateType(varInfo2);
        string4 = this.getDebugVarVal(varInfo2);
        string5 = "" + this.getArrayDimension(varInfo2);
        return string + string6 + "," + string3 + "," + string4 + "," + string5 + string2;
    }

    private String generateDebugVarCommit(varInfo varInfo2) {
        String string = "debugWindow.getInstance().";
        String string2 = "";
        String string3 = "";
        String string4 = varInfo2.getName();
        string2 = this.getCommitMethod(varInfo2);
        string3 = "(" + varInfo2.getType() + ")";
        return string4 + " = " + string3 + string + string2;
    }

    private String generateDebugVarUpdate(varInfo varInfo2) {
        String string = "debugWindow.getInstance().updateVar(";
        String string2 = ");";
        String string3 = "";
        string3 = this.getDebugVarVal(varInfo2);
        return string + string3 + string2;
    }

    private int getArrayDimension(varInfo varInfo2) {
        String string = varInfo2.getType();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '[') continue;
            ++n;
        }
        return n;
    }

    private String encodeType(varInfo varInfo2) {
        String[] stringArray = new String[]{"int", "double", "char", "String", "byte", "float", "boolean"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!varInfo2.getType().startsWith(stringArray[i])) continue;
            return stringArray[i];
        }
        return "Object";
    }

    private String getDebugVarVal(varInfo varInfo2) {
        String string = this.encodeType(varInfo2);
        int n = this.getArrayDimension(varInfo2);
        if (n > 0 || string.equals("Object") || string.equals("String")) {
            return varInfo2.getName();
        }
        if (string.equals("int")) {
            return "new Integer(" + varInfo2.getName() + ")";
        }
        if (string.equals("double")) {
            return "new Double(" + varInfo2.getName() + ")";
        }
        if (string.equals("char")) {
            return "new Character(" + varInfo2.getName() + ")";
        }
        if (string.equals("byte")) {
            return "new Byte(" + varInfo2.getName() + ")";
        }
        if (string.equals("float")) {
            return "new Float(" + varInfo2.getName() + ")";
        }
        if (string.equals("boolean")) {
            return "new Boolean(" + varInfo2.getName() + ")";
        }
        return "null";
    }

    private String getCommitMethod(varInfo varInfo2) {
        String string = this.encodeType(varInfo2);
        int n = this.getArrayDimension(varInfo2);
        if (n > 0 || string.equals("Object")) {
            return "getVarAsObject();";
        }
        if (string.equals("int")) {
            return "getVarAsInt();";
        }
        if (string.equals("double")) {
            return "getVarAsDouble();";
        }
        if (string.equals("char")) {
            return "getVarAsChar();";
        }
        if (string.equals("byte")) {
            return "getVarAsByte();";
        }
        if (string.equals("float")) {
            return "getVarAsFloat();";
        }
        if (string.equals("boolean")) {
            return "getVarAsBoolean();";
        }
        if (string.equals("String")) {
            return "getVarAsString();";
        }
        return "";
    }

    private String getInitDeclarateType(varInfo varInfo2) {
        String string = this.encodeType(varInfo2);
        if (string.equals("int")) {
            return "debugVar.TYPE_INT";
        }
        if (string.equals("double")) {
            return "debugVar.TYPE_DOUBLE";
        }
        if (string.equals("char")) {
            return "debugVar.TYPE_CHAR";
        }
        if (string.equals("byte")) {
            return "debugVar.TYPE_BYTE";
        }
        if (string.equals("float")) {
            return "debugVar.TYPE_FLOAT";
        }
        if (string.equals("boolean")) {
            return "debugVar.TYPE_BOOLEAN";
        }
        if (string.equals("String")) {
            return "debugVar.TYPE_STRING";
        }
        if (string.equals("Object")) {
            return "debugVar.TYPE_OBJECT";
        }
        return "";
    }

    public void saveFile(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

