/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil;

import gameCanvasUtil.classLoad.FileClassLoader;
import gameCanvasUtil.collision;
import gameCanvasUtil.gameInterface;
import gameCanvasUtil.imageManager;
import gameCanvasUtil.inputManager;
import gameCanvasUtil.midiManager;
import gameCanvasUtil.saveDataUtil;
import gameCanvasUtil.soundManager;
import gameCanvasUtil.soundManagerInterface;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class gameCanvas {
    public static final int WIDTH = 640;
    public static final int HEIGHT = 480;
    public static final int CONFIG_FPS = 30;
    private static final int SAVE_DATA_SIZE = 1024;
    public static final int KEY_UP = 0;
    public static final int KEY_DOWN = 1;
    public static final int KEY_LEFT = 2;
    public static final int KEY_RIGHT = 3;
    public static final int KEY_Z = 4;
    public static final int KEY_X = 5;
    public static final int KEY_C = 6;
    public static final int KEY_V = 7;
    public static final int KEY_ENTER = 8;
    public static final int KEY_SPACE = 11;
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_GRAY = 0x808080;
    public static final int COLOR_RED = 0xFF0000;
    public static final int COLOR_BLUE = 255;
    public static final int COLOR_GREEN = 65280;
    public static final int COLOR_YELLOW = 0xFFFF00;
    public static final int COLOR_PURPLE = 0xFF00FF;
    public static final int COLOR_CYAN = 65535;
    public static final int COLOR_AQUA = 0x7F7FFF;
    private imageManager images;
    private soundManagerInterface sound_effect;
    private soundManagerInterface bgm;
    private inputManager input;
    private gameInterface game;
    private Random rand = new Random();
    private int FontSize = 10;
    private int bk_snd;
    private Graphics g;
    private Image offImage;
    private JFrame frame;
    private static gameCanvas _gc;
    private gameInterface default_game;
    private Font myFont;
    private AffineTransform tr = new AffineTransform();
    private int offset_x;
    private int offset_y;
    private int cur_bgm = -1;
    private int[] saveData;
    private boolean save_flag = false;

    public static gameCanvas getInstance() {
        if (_gc == null) {
            _gc = new gameCanvas();
        }
        return _gc;
    }

    private gameCanvas() {
    }

    public void init(JFrame jFrame) {
        this.frame = jFrame;
        this.bk_snd = -1;
        this.setImageManager(new imageManager("res/img", -1));
        this.setSeManager(new soundManager("res/snd", -1));
        this.setBgmManager(new midiManager("res/bgm", -1));
        this.changeBgmVolume(60);
        this.changeSeVolume(100);
        this.input = inputManager.getInstance();
        this.readRecord();
    }

    public void finalize() {
        if (this.game != null) {
            this.game.finalGame();
        }
        if (this.save_flag) {
            this.writeRecord();
            this.save_flag = false;
        }
    }

    public void setGraphics(Graphics graphics, Image image) {
        this.g = graphics;
        this.offImage = image;
        this.setFont("", 0, 25);
    }

    public boolean writeScreenImage(String string) {
        BufferedImage bufferedImage = new BufferedImage(640, 480, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(this.offImage, 0, 0, null);
        try {
            return ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string + ".png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void setWindowTitle(String string) {
        this.frame.setTitle(string);
    }

    public void drawString(String string, int n, int n2) {
        this.g.drawString(string, n, n2 + this.g.getFont().getSize());
    }

    public void drawCenterString(String string, int n, int n2) {
        this.drawString(string, n - this.getStringWidth(string) / 2, n2);
    }

    public void drawRightString(String string, int n, int n2) {
        this.drawString(string, n - this.getStringWidth(string), n2);
    }

    public void setFont(String string, int n, int n2) {
        this.myFont = new Font(string, n, n2);
        this.g.setFont(this.myFont);
        this.FontSize = n2;
    }

    public void setFontSize(int n) {
        this.setFont("", 0, n);
    }

    public int getStringWidth(String string) {
        FontMetrics fontMetrics = this.g.getFontMetrics();
        return fontMetrics.stringWidth(string);
    }

    public void setColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        this.setColor(n2, n3, n4);
    }

    public void setColor(int n, int n2, int n3) {
        this.g.setColor(new Color(n, n2, n3));
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.g.drawRect(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    public void drawCircle(int n, int n2, int n3) {
        this.g.drawArc(n - n3, n2 - n3, n3 * 2, n3 * 2, 0, 360);
    }

    public void fillCircle(int n, int n2, int n3) {
        this.g.fillArc(n - n3, n2 - n3, n3 * 2, n3 * 2, 0, 360);
    }

    public void drawImage(int n, int n2, int n3) {
        try {
            this.g.drawImage(this.images.getImage(n), n2, n3, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawClipImage(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            this.g.drawImage(this.images.getImage(n), n2, n3, n2 + n6, n3 + n7, n4, n5, n6 + n4, n5 + n7, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawScaledRotateImage(int n, int n2, int n3, int n4, int n5, double d) {
        double d2 = (double)this.getImageWidth(n) / 2.0;
        double d3 = (double)this.getImageHeight(n) / 2.0;
        this.drawScaledRotateImage(n, n2, n3, n4, n5, d, d2, d3);
    }

    public void drawScaledRotateImage(int n, int n2, int n3, int n4, int n5, double d, double d2, double d3) {
        Image image = this.images.getImage(n);
        if (image == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.g;
        this.tr.setToIdentity();
        this.tr.translate(n2, n3);
        this.tr.rotate(d * Math.PI / 360.0);
        this.tr.translate(-(d2 *= (double)n4 / 100.0), -(d3 *= (double)n5 / 100.0));
        this.tr.scale((double)n4 / 100.0, (double)n5 / 100.0);
        graphics2D.drawImage(image, this.tr, null);
    }

    public int getImageWidth(int n) {
        return this.images.getPicXsize(n);
    }

    public int getImageHeight(int n) {
        return this.images.getPicYsize(n);
    }

    public void setSeed(int n) {
        this.rand.setSeed(n);
    }

    public int rand(int n, int n2) {
        int n3 = this.rand.nextInt();
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n < n2) {
            n2 = n2 - n + 1;
            return n3 % n2 + n;
        }
        n = n - n2 + 1;
        return n3 % n + n2;
    }

    public void changeGameState(gameInterface gameInterface2, boolean bl) {
        if (this.game != null && bl) {
            this.game.finalGame();
        }
        if (gameInterface2 != null && bl) {
            gameInterface2.initGame();
        }
        this.game = gameInterface2;
    }

    public void changeGameState(gameInterface gameInterface2) {
        this.changeGameState(gameInterface2, true);
    }

    public boolean loadGameState(String string, boolean bl) {
        try {
            Class clazz = new FileClassLoader().loadClassFile(new File(string));
            if (clazz == null) {
                return false;
            }
            this.changeGameState((gameInterface)clazz.newInstance(), bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void resetGame() {
        this.changeGameState(null);
        this.stopBgm();
        this.stopSe();
        this.translate(0, 0);
    }

    public void setDefaultGameState(gameInterface gameInterface2) {
        this.default_game = gameInterface2;
    }

    public void updateMessage() {
        if (this.game != null) {
            this.game.updateGame();
            if (this.save_flag) {
                this.writeRecord();
                this.save_flag = false;
            }
        } else {
            try {
                this.changeGameState((gameInterface)this.default_game.getClass().newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bgm.update();
    }

    public void drawMessage() {
        if (this.game != null && this.g != null) {
            this.game.drawGame();
        }
    }

    public void clearScreen() {
        this.setColor(255, 255, 255);
        this.fillRect(0, 0, 640, 480);
    }

    public void translate(int n, int n2) {
        this.g.translate(n - this.offset_x, n2 - this.offset_y);
        this.offset_x = n;
        this.offset_y = n2;
    }

    public void exitApp() {
        try {
            this.game.finalGame();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public boolean showYesNoDialog(String string) {
        return 0 == JOptionPane.showConfirmDialog(null, string, null, 0);
    }

    public String showInputDialog(String string, String string2) {
        return JOptionPane.showInputDialog(null, string, string2);
    }

    public void playBgm(int n) {
        this.playBgm(n, true);
    }

    public void playBgm(int n, boolean bl) {
        if (this.cur_bgm != n) {
            this.bgm.stopSound();
            this.bgm.playSound(n, bl);
        }
        this.cur_bgm = n;
    }

    public void changeBgmVolume(int n) {
        this.bgm.changeVolume(n);
    }

    public void stopBgm() {
        if (this.bgm != null) {
            this.bgm.stopSound();
        }
        this.cur_bgm = -1;
    }

    public void pauseBgm() {
        this.bgm.pauseSound();
        this.cur_bgm = -1;
    }

    public void playSe(int n) {
        this.playSe(n, false);
    }

    public void playSe(int n, boolean bl) {
        this.sound_effect.playSound(n, bl);
    }

    public void changeSeVolume(int n) {
        this.sound_effect.changeVolume(n);
    }

    public void stopSe() {
        this.sound_effect.stopSound();
    }

    public void pauseSe() {
        this.sound_effect.pauseSound();
    }

    public int getKeyPressLength(int n) {
        return this.input.getKeyPressLength(n);
    }

    public boolean isKeyPress(int n) {
        return this.input.isKeyPressed(n);
    }

    public boolean isKeyPushed(int n) {
        return this.input.isKeyPushed(n);
    }

    public boolean isKeyReleased(int n) {
        return this.input.isKeyReleased(n);
    }

    public int getMouseX() {
        return this.input.getMouseX();
    }

    public int getMouseY() {
        return this.input.getMouseY();
    }

    public int getMouseClickLength() {
        return this.input.getMouseClickLength();
    }

    public boolean isMousePushed() {
        return this.input.isMousePushed();
    }

    public boolean isMouseReleased() {
        return this.input.isMouseReleased();
    }

    public boolean isMousePress() {
        return this.input.isMousePress();
    }

    private void writeRecord() {
        byte[] byArray = saveDataUtil.intarr2bytearr(this.saveData);
        saveDataUtil.writeByteArray("savedata.dat", byArray);
    }

    private void readRecord() {
        byte[] byArray = saveDataUtil.readByteArray("savedata.dat");
        if (byArray == null) {
            this.saveData = new int[1024];
            this.writeRecord();
        } else {
            this.saveData = saveDataUtil.bytearr2intarr(byArray);
        }
    }

    public int load(int n) {
        return this.saveData[n];
    }

    public void save(int n, int n2) {
        this.saveData[n] = n2;
        this.save_flag = true;
    }

    public boolean checkHitRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return collision.checkHitRect(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public boolean checkHitImage(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.checkHitRect(n2, n3, this.getImageWidth(n), this.getImageHeight(n), n5, n6, this.getImageWidth(n4), this.getImageHeight(n4));
    }

    public boolean checkHitCircle(int n, int n2, int n3, int n4, int n5, int n6) {
        return collision.checkHitCircle(n, n2, n3, n4, n5, n6);
    }

    public double sqrt(double d) {
        return Math.sqrt(d);
    }

    public double cos(double d) {
        return Math.cos(d * Math.PI / 180.0);
    }

    public double sin(double d) {
        return Math.sin(d * Math.PI / 180.0);
    }

    public double atan2(double d, double d2) {
        return Math.atan2(d, d2) * 180.0 / Math.PI;
    }

    public void setImageManager(imageManager imageManager2) {
        this.images = imageManager2;
    }

    public void setSeManager(soundManagerInterface soundManagerInterface2) {
        if (this.sound_effect != null) {
            this.sound_effect.stopSound();
        }
        this.sound_effect = soundManagerInterface2;
    }

    public void setBgmManager(soundManagerInterface soundManagerInterface2) {
        this.stopBgm();
        this.bgm = soundManagerInterface2;
    }

    public imageManager getImageManager() {
        return this.images;
    }

    public soundManagerInterface getSeManager() {
        return this.sound_effect;
    }

    public soundManagerInterface getBgmManager() {
        return this.bgm;
    }
}

