/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil;

import gameCanvasUtil.saveDataUtil;
import gameCanvasUtil.soundManagerInterface;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class streamSound
implements soundManagerInterface {
    public static final int NUMBER_AUTO_CULC = -1;
    public static final int READ_LIST_FROM_TEXT = -2;
    private static final int MAX_SOUND_NUM = 128;
    private AudioInputStream[] audioInputStream;
    private SourceDataLine[] line;
    private boolean[] loopFlag;
    private int[] bind;
    private static final int EXTERNAL_BUFFER_SIZE = 4266;
    private static final int LINE_BUFFER_NUM = 1;
    private int[] volume;
    private byte[] abData = new byte[4266];
    private String fileName;
    private String[] fileNameList;

    public streamSound(String string, int n) {
        try {
            int n2;
            this.fileName = string;
            if (n == -1) {
                this.fileNameList = new String[128];
                for (n2 = 0; n2 < this.fileNameList.length; ++n2) {
                    this.fileNameList[n2] = string + n2 + ".wav";
                }
            } else if (n == -2) {
                this.fileNameList = saveDataUtil.readResourceStrings(string);
            } else {
                this.fileNameList = new String[n];
                for (n2 = 0; n2 < this.fileNameList.length; ++n2) {
                    this.fileNameList[n2] = string + n2 + ".wav";
                }
            }
            this.audioInputStream = new AudioInputStream[1];
            this.line = new SourceDataLine[1];
            this.loopFlag = new boolean[1];
            this.bind = new int[1];
            this.volume = new int[1];
            for (n2 = 0; n2 < 1; ++n2) {
                this.bind[n2] = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadAndPlaySound(int n, int n2) {
        try {
            this.audioInputStream[n] = AudioSystem.getAudioInputStream(this.getClass().getResourceAsStream("/" + this.fileNameList[n2]));
            AudioFormat audioFormat = this.audioInputStream[n].getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            this.line[n] = (SourceDataLine)AudioSystem.getLine(info);
            this.line[n].open(audioFormat);
            this.line[n].start();
            this.setVolume(n, this.volume[n]);
            this.bind[n] = n2;
        }
        catch (Exception exception) {
            System.out.println("soundStream play Error " + exception);
        }
    }

    public void update() {
        int n = 0;
        try {
            for (int i = 0; i < 1; ++i) {
                if (this.line[i] == null || !this.line[i].isOpen()) continue;
                n = this.audioInputStream[i].read(this.abData, 0, this.abData.length);
                if (n >= 0) {
                    this.line[i].write(this.abData, 0, n);
                    continue;
                }
                if (this.loopFlag[i]) {
                    this.loadAndPlaySound(i, this.bind[i]);
                    continue;
                }
                this.stopSound(i);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private int getFreeLineBuf() {
        for (int i = 0; i < 1; ++i) {
            if (this.line[i] != null && this.line[i].isOpen()) continue;
            return i;
        }
        return -1;
    }

    private void playSound(int n, int n2, boolean bl) {
        this.loopFlag[n] = bl;
        if (this.line[n] != null && this.line[n].isOpen()) {
            this.line[n].start();
        } else {
            this.loadAndPlaySound(n, n2);
        }
    }

    public void playSound(int n, boolean bl) {
        int n2 = this.getFreeLineBuf();
        if (n2 >= 0) {
            this.playSound(n2, n, bl);
        } else {
            for (int i = 0; i < this.line.length; ++i) {
                if (this.bind[i] != n) continue;
                this.playSound(i, n, bl);
            }
        }
    }

    public void stopSound() {
        for (int i = 0; i < 1; ++i) {
            this.stopSound(i);
        }
    }

    public void stopSound(int n) {
        try {
            this.line[n].drain();
            this.line[n].close();
            this.line[n] = null;
            this.bind[n] = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseSound(int n) {
        try {
            this.line[n].stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changeVolume(int n, int n2) {
        this.volume[n] = n2;
        this.setVolume(n, n2);
    }

    private void setVolume(int n, int n2) {
        try {
            FloatControl floatControl = (FloatControl)this.line[n].getControl(FloatControl.Type.MASTER_GAIN);
            float f = floatControl.getMaximum() - floatControl.getMinimum();
            floatControl.setValue(f * (float)Math.sqrt((float)n2 / 100.0f) + floatControl.getMinimum());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pauseSound() {
        for (int i = 0; i < 1; ++i) {
            this.pauseSound(i);
        }
    }

    public void changeVolume(int n) {
        for (int i = 0; i < 1; ++i) {
            this.changeVolume(i, n);
        }
    }
}

