/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil;

import gameCanvasUtil.saveDataUtil;
import gameCanvasUtil.soundManagerInterface;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;

public class soundManager
implements soundManagerInterface {
    private Clip[] audio;
    private String fileName;
    public static final int NUMBER_AUTO_CULC = -1;
    public static final int READ_LIST_FROM_TEXT = -2;
    private static final int SOUND_MAX_NUM = 124;

    public soundManager(String string, int n) {
        this.fileName = string;
        if (n == -1) {
            this.audio = new Clip[124];
            this.loadNumberingSound(false);
        } else if (n == -2) {
            String[] stringArray = saveDataUtil.readResourceStrings(string);
            this.audio = new Clip[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.audio[i] = this.loadSound(stringArray[i]);
            }
        } else {
            this.audio = new Clip[n];
            this.loadNumberingSound(true);
        }
    }

    private void loadNumberingSound(boolean bl) {
        for (int i = 0; i < this.audio.length; ++i) {
            this.audio[i] = this.loadSound(this.fileName + i + ".wav");
            if (this.audio[i] == null && !bl) break;
        }
    }

    private Clip loadSound(String string) {
        Clip clip = null;
        try {
            AudioInputStream audioInputStream = null;
            audioInputStream = AudioSystem.getAudioInputStream(this.getClass().getResourceAsStream("/" + string));
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            audioInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("loadSound Error " + string + "::" + exception);
            return null;
        }
        return clip;
    }

    public void playSound(int n, boolean bl) {
        try {
            if (this.audio[n].isActive()) {
                this.stopSound(n);
            } else if (this.audio[n].getFrameLength() == this.audio[n].getFramePosition()) {
                this.audio[n].setFramePosition(0);
            }
            if (bl) {
                this.audio[n].loop(-1);
            } else {
                this.audio[n].start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopSound(int n) {
        try {
            this.audio[n].stop();
            this.audio[n].setFramePosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseSound(int n) {
        try {
            this.audio[n].stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseSound() {
        for (int i = 0; i < this.audio.length; ++i) {
            this.pauseSound(i);
        }
    }

    public void stopSound() {
        for (int i = 0; i < this.audio.length; ++i) {
            this.stopSound(i);
        }
    }

    public void changeVolume(int n) {
        for (int i = 0; i < this.audio.length; ++i) {
            this.changeVolume(i, n);
        }
    }

    public void changeVolume(int n, int n2) {
        if (this.audio[n] == null) {
            return;
        }
        try {
            FloatControl floatControl = (FloatControl)this.audio[n].getControl(FloatControl.Type.MASTER_GAIN);
            float f = floatControl.getMaximum() - floatControl.getMinimum();
            floatControl.setValue(f * (float)Math.sqrt((float)n2 / 100.0f) + floatControl.getMinimum());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void update() {
    }
}

