
import gameCanvasUtil.*;

import java.awt.*;
import java.awt.event.*;

import javax.swing.JFrame;

import debugger.debugWindow;

/** アプリケーションのメイン部分(全てはここから始まる)
 *
 * スレッド、Event処理とかを一手に引き受けるクラス
 * といいつつ、やることは基本他にたらいまわし。
 *
 * あと、ウインドウそのもののクラス
 */

public class gameDebugApp extends JFrame implements WindowListener,Runnable{
	/// serialVersionUID
	private static final long serialVersionUID = 1L;

	/// 時間管理を行うオブジェクト
	private timerWaitManager timer;

	/// 画面そのもののオブジェクト
	private appCanvas canvas;

	/// スレッド
	private Thread th;

	//スレッドをぶん回すかのフラグ
	private boolean th_flag = true;

	/** ゲームモード
	 * @param args 引数
	 */
	public static void main(String[] args) {
		// TODO 自動生成されたメソッド・スタブ
		new gameDebugApp();
	}

	/** コンストラクタ
	 * ウインドウの大きさ設定などを行ってます。
	 */
	private gameDebugApp(){
		super("FrameTest");
		timer = timerWaitManager.getInstance();
		timer.init(gameCanvas.CONFIG_FPS);
		setVisible(true);
		setSize(gameCanvas.WIDTH + getMinimumSize().width, gameCanvas.HEIGHT + getMinimumSize().height);
		setResizable(false);
		addWindowListener(this);
		canvas = new appCanvas();
		add(this.canvas, BorderLayout.CENTER);


		debugWindow.getInstance().init();


		gameCanvas.getInstance().setDefaultGameState(new debugGames.game());
		gameCanvas.getInstance().init(this);
		
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		th =  new Thread(this);
		th.start();

	}


	/** Windowが出現したとき呼び出される
	 * @param evt ウインドウのイベント
	 */
	public void windowOpened(WindowEvent evt) {
	}

	/** Windowの×ボタンが押されたとき呼び出される
	 * @param evt ウインドウのイベント
	 */
	public void windowClosing(WindowEvent evt) {
		gameCanvas.getInstance().finalize();
		th_flag = false;
	}
	/** Windowが閉じるとき呼び出される
	 * @param evt ウインドウのイベント
	 */
	public void windowClosed(WindowEvent evt) {
	}

	/** Windowが最小化されたときに呼び出される
	 * @param evt ウインドウのイベント
	 */
	public void windowIconified(WindowEvent evt) {
	}

	/** Windowが最小化された状態から戻ったときに呼び出される
	 * @param evt ウインドウのイベント
	 */
	public void windowDeiconified(WindowEvent evt) {
	}

	/** Windowがアクティブになったとき呼び出される。
	 * @param evt ウインドウのイベント
	 */
	public void windowActivated(WindowEvent evt) {
	}

	/** Windowがアクティブじゃなくなったときに呼び出される。
	 * @param evt ウインドウのイベント
	 */
	public void windowDeactivated(WindowEvent evt) {
	}


	/** メインのスレッド
	 */
	public void run(){
		while (th_flag){
			debugWindow.getInstance().draw();
			this.canvas.updateMessage();
			this.canvas.drawMessage();
			timer.Wait();
		}
	}



}
