//インポート
import gameCanvasUtil.*;
import debugger.*;

/** ゲームクラス。
 *
 * 学生が編集すべきソースコードです。
 */
public class game extends gameBase
{
    /********* 変数定義はこちらに *********/
    // 型 変数名;　の順に書いて定義する
    // ボールのX座標
    int[] ball_x = new int[3];
    // ボールのY座標
    int[] ball_y = new int[3];
    // ボールのX方向の速度
    int[] ball_speed_x = new int[3];
    // ボールのY方向の速度
    int[] ball_speed_y = new int[3];

    /********* 初期化の手順はこちらに *********/
    public void initGame()
    {
        // ボールの座標を初期化する
        ball_x[0] = 0;
        ball_y[0] = 100;
        ball_x[1] = 100;
        ball_y[1] = 100;
        ball_x[2] = 200;
        ball_y[2] = 100;

        // ボールの速度を初期化する
        ball_speed_x[0] = 5;
        ball_speed_y[0] = 5;
        ball_speed_x[1] = 5;
        ball_speed_y[1] = 5;
        ball_speed_x[2] = 5;
        ball_speed_y[2] = 5;
    }

    /********* 物体の移動等の更新処理はこちらに *********/
    public void updateGame()
    {
        // Y方向に ball_speed_y ずつ進める
        ball_y[0] = ball_y[0] + ball_speed_y[0];
        ball_y[1] = ball_y[1] + ball_speed_y[1];
        ball_y[2] = ball_y[2] + ball_speed_y[2];

        // X方向に ball_speed_x ずつ進める
        ball_x[0] = ball_x[0] + ball_speed_x[0];
        ball_x[1] = ball_x[1] + ball_speed_x[1];
        ball_x[2] = ball_x[2] + ball_speed_x[2];

        // ボールが画面の上を越えるか、画面の下を越えた場合
        if(ball_y[0] < 0 || ball_y[0] > 456)
        {
            // ボールのY方向の速度を反転させる
            ball_speed_y[0] = -ball_speed_y[0];
        }
        if(ball_y[1] < 0 || ball_y[1] > 456)
        {
            // ボールのY方向の速度を反転させる
            ball_speed_y[1] = -ball_speed_y[1];
        }
        if(ball_y[2] < 0 || ball_y[2] > 456)
        {
            // ボールのY方向の速度を反転させる
            ball_speed_y[2] = -ball_speed_y[2];
        }
        
        // ボールが画面の右を越えるか、画面の左を越えた場合
        if(ball_x[0] > 616 || ball_x[0] < 0)
        {
            // ボールのX方向の速度を反転させる
            ball_speed_x[0] = -ball_speed_x[0];
        }
        if(ball_x[1] > 616 || ball_x[1] < 0)
        {
            // ボールのX方向の速度を反転させる
            ball_speed_x[1] = -ball_speed_x[1];
        }
        if(ball_x[2] > 616 || ball_x[2] < 0)
        {
            // ボールのX方向の速度を反転させる
            ball_speed_x[2] = -ball_speed_x[2];
        }
    }

    /********* 画像の描画はこちらに *********/
    public void drawGame()
    {
        // 画面を白で塗りつぶします
        gc.clearScreen();

        // img0.png を描画します
        gc.drawImage(0, ball_x[0], ball_y[0]);
        gc.drawImage(0, ball_x[1], ball_y[1]);
        gc.drawImage(0, ball_x[2], ball_y[2]);
    }

    /********* 終了時の処理はこちらに *********/
    public void finalGame() {}
}
