package gameCanvasUtil.classLoad;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * クラスファイルを読み込むクラスローダー 
 * @author NAT
 * from http://d.hatena.ne.jp/NAT_programming/20060729/1154193932
 */
public class FileClassLoader extends ClassLoader{
	private static final int BUF_SIZE = 1024;

	/** クラスファイル読み込み
	 * @param classFile クラスファイル名
	 */
	public Class loadClassFile(File classFile) throws IOException {
		FileInputStream in = new FileInputStream(classFile);
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		byte[] buf = new byte[BUF_SIZE];
		int len = in.read(buf);
		while(len != -1) {
			out.write(buf, 0, len);
			len = in.read(buf);
		}
		byte[] loadedData = out.toByteArray();
		Class loadedCLass = defineClass(null, loadedData, 0, loadedData.length);
		return loadedCLass;
	}
}
