package debugger;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Scrollbar;
import java.util.Hashtable;


/** デバッグのオブジェクト
 * 
 * @author Administrator
 *
 */
public class debugObject {
	private debugVar var_list = null;//変数リストトップ
	private debugVar tail = null;//変数リストボトム　次はココから追加
	private debugVar current_var;//現在　更新/取得中の変数
	
	
	private String name;//オブジェクト名
	private Object object;//オブジェクトの実体
	private Container comp;//コンテナ
	
	private Scrollbar sb1;//スクロールバー

	
	/** コンストラクタ
	 * @param _name オブジェクト名
	 * @param obj オブジェクトの実態
	 */
	debugObject(String _name,Object obj,Container _comp){
		this.name = _name;
		this.object = obj;
		this.comp = _comp;
		
		
		sb1 = new Scrollbar(Scrollbar.VERTICAL);
		this.comp.add(sb1, BorderLayout.EAST);
	}
	
	/** 変数を追加する
	 * 
	 * @param tmp 追加する変数オブジェクト
	 */
	public void addVar(debugVar tmp){
		tmp.init(comp);
		tmp.killChilds();
		tmp.killChilds();
		tmp.killChilds();
		
		
		if(var_list==null){
			var_list = tmp;
		}else{
			tail.next_var = tmp;
		}
		tail =  tmp;
	}
	
	/** カレント変数をトップにする
	 * 変数のアップデート/取得は追加した順にお願いします。
	 */
	public void iterateVarStart(){
		this.current_var = var_list;
	}
	
	/** 変数のアップデートを行い次の変数へ移動する
	 * 
	 * @param obj 変数にセットする値
	 */
	public void updateVar(Object obj){
		this.current_var.setValue(obj);
		this.current_var = this.current_var.next_var;
	}

	/** 変数を返し、次の変数へ移動する
	 * @return 変数ＯＢＪ
	 */
	public debugVar getVar(){
		debugVar tmp = this.current_var;
		this.current_var = this.current_var.next_var;		
		return tmp;
	}
	
	/** 変数をINT型とみなし、中身の値を取り出し、次の変数へ移動する
	 * @return 変数のint型の値
	 */
	public int getVarAsInt(){
		int val = ((Integer)this.current_var.getValue()).intValue();
		this.current_var = this.current_var.next_var;		
		return val;
	}

	/** 変数をDOUBLE型とみなし、中身の値を取り出し、次の変数へ移動する
	 * @return 変数のdouble型の値
	 */
	public double getVarAsDouble(){
		double val = ((Double)this.current_var.getValue()).doubleValue();
		this.current_var = this.current_var.next_var;		
		return val;
	}

	/** 変数をfloat型とみなし、中身の値を取り出し、次の変数へ移動する
	 * @return 変数のfloat型の値
	 */
	public float getVarAsFloat(){
		float val = ((Float)this.current_var.getValue()).floatValue();
		this.current_var = this.current_var.next_var;		
		return val;
	}
	
	/** 変数をString型とみなし、中身の値を取り出し、次の変数へ移動する
	 * @return 変数のString型の値
	 */
	public String getVarAsString(){
		String val = ((String)this.current_var.getValue());
		this.current_var = this.current_var.next_var;		
		return val;
	}

	
	/** 変数をchar型とみなし、中身の値を取り出し、次の変数へ移動する
	 * @return 変数のchar型の値
	 */
	public char getVarAsChar(){
		char val = ((Character)this.current_var.getValue()).charValue();;
		this.current_var = this.current_var.next_var;		
		return val;
	}
	
	/** 変数をバイト型とみなし、中身の値を取り出し、次の変数へ移動する
	 * @return 変数のbyte型の値
	 */
	public byte getVarAsByte(){
		byte val = ((Byte)this.current_var.getValue()).byteValue();;
		this.current_var = this.current_var.next_var;		
		return val;
	}
	
	/** 変数をObject型とみなし、中身の値を取り出し、次の変数へ移動する
	 * @return 変数のObject型の値
	 */
	public Object getVarAsObject(){
		Object val = this.current_var.getValue();
		this.current_var = this.current_var.next_var;		
		return val;
	}

	/** 変数をObject型とみなし、中身の値を取り出し、次の変数へ移動する
	 * @return 変数のObject型の値
	 */
	public boolean getVarAsBoolean(){
		boolean val = ( (Boolean)this.current_var.getValue() ).booleanValue();
		this.current_var = this.current_var.next_var;		
		return val;
	}
	
	
	
	/** 変数一覧を描画します
	 * @param update_var 変数のアップデートを行うかどうかのフラグをセットします。(falseならフォームの値が書き換えられない)
	 */
	public void draw(boolean update_var){
		if(sb1!=null){
			int bar_max = 0;
			int num = 0;
			int y = -this.sb1.getValue()*5;
			for(debugVar tmp = this.var_list; tmp != null; tmp = tmp.next_var){
				int varnum = tmp.draw(y,update_var);
				y += varnum * debugVar.VAR_HEIGHT;
				num += varnum;
			}
			bar_max = ( num * debugVar.VAR_HEIGHT - this.comp.getHeight() )/ 5 + 11;
			if(bar_max < 0 )
				bar_max = 0;
			if(bar_max != sb1.getMaximum()){
				sb1.setMaximum(bar_max);
			}
		}
	}
	
	/** 実行中かどうかの変更
	 * @param flag 実行中ならtrue,停止ならfalse
	 */
	public void setRunningFlag(boolean flag){
		for(debugVar tmp=this.var_list;tmp!=null;tmp=tmp.next_var){
			tmp.setRunningFlag(flag);
		}
	}
}
