package taskSystem;

public class taskGroup {

	taskBase tasklist;
	
	/** このグループにあるタスクの更新を行います
	 * 
	 * 死亡しているタスクを削除します
	 */
	public void update(){
		taskBase tmp = this.tasklist;
		for(taskBase t=this.tasklist;t!=null;t=t.next_task){
			t.updateTask();
			if( t.isDead() ){
				if(t==tasklist){
					tmp = tasklist = t.next_task;
				}else{
					tmp.next_task = t.next_task;
				}
				t.finelTask();
			}
		}
		
	}
	
	/** グループ内のタスクを全て描画します
	 */
	public void draw(){
		for(taskBase t=this.tasklist;t!=null;t=t.next_task){
			t.drawTask();
		}
	}
	
	/** タスクを書きます 
	 * @param t 追加するタスクを書きます
	 */
	public void addTask(taskBase t){
		t.next_task = tasklist;
		t = tasklist;
		t.initTask();
	}
	
	/** 他のグループと衝突判定を行います
	 * @param g 衝突判定を行う対象のグループ
	 */
	public void collision(taskGroup g){
		for(taskBase src=this.tasklist;src!=null;src=src.next_task){
			for(taskBase target=g.tasklist;target!=null;target=target.next_task){
				src.collision(target);
			}
		}
	}
	
	/** 全てのタスクを殺す。こちらだと死んだときの処理を行う
	 */
	public void killTask(){
		for(taskBase t=this.tasklist;t!=null;t=t.next_task){
			t.taskDie();
		}
	}
	
	/** 全てのタスクを消滅させる。死亡時の処理(final)を行わない
	 */
	public void clearTask(){
		this.tasklist = null;
	}

}
