package gameCanvasUtil;

import gameCanvasUtil.gameInterface;
import gameCanvasUtil.gameCanvas;


/** gameInterfaceを継承したクラス。内部にgameCanvasオブジェクトを持つ 
 */
public abstract class gameBase implements gameInterface{
	/** gameCanvasへの参照 */
	protected gameCanvas gc;
	
	/** コンストラクタ。ただ単に、gameCanvasオブジェクトへの参照をもらうだけ。
	 */
	public gameBase(){
		gc = gameCanvas.getInstance();
	}
	/** 終了処理。
	 */
	public abstract void finalGame();
	/** 初期化処理。
	 */
	public abstract void initGame();
	/** 更新処理。
	 */
	public abstract void updateGame();
	/** 描画処理。
	 */	
	public abstract void drawGame();
}
