//インポート
import gameCanvasUtil.*;
import debugger.*;

/** ゲームクラス。
 *
 * 学生が編集すべきソースコードです。
 */
public class game extends gameBase
{
    /********* 変数定義はこちらに *********/
    // 型 変数名;　の順に書いて定義する
    // ボールのX座標
    int ball_x;
    // ボールのY座標
    int ball_y;
    // ボールのX方向の速度
    int ball_speed_x;
    // ボールのY方向の速度
    int ball_speed_y;
    // ラケットのX座標
    int racket_x;
    // ラケットのY座標
    int racket_y;
    // ラケットの幅
    int racket_w;
    // ラケットの高さ
    int racket_h;

    // 点数
    int score;
    // ハイスコア
    int high_score;

    /********* 初期化の手順はこちらに *********/
    public void initGame()
    {
        // ボールの座標を初期化する
        ball_x = 0;
        ball_y = 100;

        // ボールの速度を初期化する
        ball_speed_x = 5;
        ball_speed_y = 5;

        // ラケットの座標を初期化する
        racket_x = 270;
        racket_y = 450;

        // ラケットの幅・高さを初期化する
        racket_w = 50;
        racket_h = 10;

        // 点数を初期化
        score = 0;
        // ハイスコアを初期化
        high_score = 0;
    }

    /********* 物体の移動等の更新処理はこちらに *********/
    public void updateGame()
    {
        // 左キーが押され続けている場合に真
        if(gc.isKeyPress(gc.KEY_LEFT))
        {
            // ラケットを左に動かす
            racket_x = racket_x - 5;
        }
        // 右キーが押され続けている場合に真
        if(gc.isKeyPress(gc.KEY_RIGHT))
        {
            // ラケットを右に動かす
            racket_x = racket_x + 5;
        }

        // Y方向に ball_speed_y ずつ進める
        ball_y = ball_y + ball_speed_y;

        // X方向に ball_speed_x ずつ進める
        ball_x = ball_x + ball_speed_x;

        // ボールが画面の上を越えた場合
        if(ball_y < 0)
        {
            // ボールのY方向の速度を反転させる
            ball_speed_y = -ball_speed_y;
        }

        // ボールが画面の右を越えるか、画面の左を越えた場合
        if(ball_x > 616 || ball_x < 0)
        {
            // ボールのX方向の速度を反転させる
            ball_speed_x = -ball_speed_x;
        }

        // ボールが画面の下を越えた場合
        if(ball_y > 480)
        {
            // 最初の状態に戻す
            // ボールの座標を初期化する
            ball_x = 0;
            ball_y = 100;

            // ラケットの座標を初期化する
            racket_x = 270;
            racket_y = 450;

            // 点数を初期化する
            score = 0;
        }

        // ボールと、ラケットが当たった場合に真
        if(gc.checkHitRect(racket_x, racket_y, racket_w, racket_h, ball_x, ball_y, 24, 24))
        {
            // ボールのY方向の速度を反転させる
            ball_speed_y = -ball_speed_y;

            // 点数を10点加算する
            score = score + 10;

            // 点数がハイスコアを上回っていたら
            if(score > high_score)
            {
                // ハイスコアを更新
                high_score = score;
            }
        }
    }

    /********* 画像の描画はこちらに *********/
    public void drawGame()
    {
        // 画面を白で塗りつぶします
        gc.clearScreen();

        // img0.png を(ball_x, ball_y)に描画します
        gc.drawImage(0, ball_x, ball_y);

        // 色を青にセットします
        gc.setColor(0, 0, 255);
        // (racket_x, racket_y)の位置に、幅racket_w, 高さracket_h の長方形を描画します
        gc.fillRect(racket_x, racket_y, racket_w, racket_h);

        // 点数を描画します
        gc.drawString("Score " + score, 0, 0);
        gc.drawString("HighScore " + high_score, 200, 0);
    }

    /********* 終了時の処理はこちらに *********/
    public void finalGame() {}
}
