package gameCanvasUtil;


import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;

import javax.imageio.ImageIO;



/** 画像の管理を行うクラス
 *
 * 実際の描画は gameCanvasにImageオブジェクト返してやるから　やってくれー<br />
 * 画像は連番で読み込みます
 */
public class imageManager {
	
	
	/** 画像枚数などよきに計らえ **/
	public static final int NUMBER_AUTO_CULC = -1;
	/** 画像リストをテキストから読み込みやがれ */
	public static final int READ_LIST_FROM_TEXT = -2;
	
	//画像の枚数
	private static final int IMAGE_MAX_NUM=1024;
	//画像
	private Image img[];
	
	//一応ファイル名を保持しておく
	private String imageFile;


	private byte image_buffer[] = new byte[500* 1024];
	
	/** コンストラクタ
	 * 
	 * 連番のgifファイルを読み込みます。ファイル数が何個あるかなどは自動で判別します。
	 * @param imageFileName 連番ファイルの名前。たとえば、"img"を指定した場合。img.gif , img1.gif といった感じで連番で読み込む
	 * @param number 画像枚数の指定。
	 * 何枚になるかわからない場合は"NUMBER_AUTO_CULC"を指定するとよきに計らいます。<br />
	 * また READ_LIST_FROM_TEXT を指定すると連番ファイル読み込みではなく、引数"imageFileName"を<br />
	 * 画像のリストが書いてあるテキストファイルとして読み込み、そのリストに従って画像を読み込みます。<br />
	 * (リストは一行に1ファイルずつ書いていく感じです。)
	 */	
	public imageManager(String imageFileName,int number){
		this.imageFile = imageFileName;
		if(number==NUMBER_AUTO_CULC){
			img = new Image[IMAGE_MAX_NUM];
			this.loadNumberingImage(false);
		}else if(number==READ_LIST_FROM_TEXT){
			String list[] = saveDataUtil.readResourceStrings(imageFileName);
			img = new Image[list.length];
			for(int i=0;i<list.length;i++){
				this.img[i] = this.loadImage(list[i]);
			}
		}else{
			img = new Image[number];
			this.loadNumberingImage(true);
		}
	}
	
	/** 連番の画像ファイルをロードする
	 * @param skip 読み込めなかった場合スキップするか？
	 * これがfalseだと、読み込めないと、そこで終了する。
	 */
	private void loadNumberingImage(boolean skip){
		String ex_list[] = {
			".gif",".GIF",".png",".PNG",".jpg",".JPG"
		};
		
		System.out.println("load Numbered image");
		
		int i,j;
		for(i=0;i<img.length;i++){
			for(j=0;j<ex_list.length;j++){
				this.img[i] = loadImage( this.imageFile+i+ex_list[j] );
				if( this.img[i]!=null ){
					break;
				}
			}
			if(j==ex_list.length && !skip){
				System.out.println("image file "+i);
				break;
			}
		}
	}
	/** 画像ファイルを読み込む。読み込めたらオブジェクトを返す
	 * @param file ファイル名
	 * @return 読み込んだImageオブジェクトを返す
	 */
	private Image loadImage(String file){
		try{
			Image obj = null;
			int read = 0,tmp=0;
			InputStream is = this.getClass().getResourceAsStream("/"+file );
			if(is == null){
				return null;
			}
			while((tmp = is.read(image_buffer,read, image_buffer.length-read) ) > 0 )
				read += tmp;
			is.close();
			byte img_dat[] = new byte[read];
			System.arraycopy(image_buffer, 0, img_dat, 0, read );
			obj = Toolkit.getDefaultToolkit().createImage( img_dat , 0 ,  read );
			return obj;
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
	/** 画像の幅を返す
	 *
	 * @param id 画像ＩＤ
	 * @return  指定された画像の幅
	 */
	public int getPicXsize(int id){
		try{
			return img[id].getWidth(null);
		}catch(Exception e){
			e.printStackTrace();
			return -1;
		}
	}
	
	/** 画像の高さを返す
	 *
	 * @param id 画像ＩＤ
	 * @return  指定された画像の高さ
	 */
	public int getPicYsize(int id){
		try{
			return img[id].getHeight(null);
		}catch(Exception e){
			e.printStackTrace();
			return -1;
		}
	}
	
	/** ImageManager内で管理している画像を返します
	 * @param id 画像のID
	 * @return 画像オブジェクト
	 */
	public Image getImage(int id){
		return img[id];
	}
	
}
