package debugger;

import javax.swing.*;
import java.util.*;

class debugObjectManager{

	private ArrayList debugObjects = new ArrayList();
	private ArrayList objects = new ArrayList();

	/** 既に登録済みか調べる
	 * @param obj 調べるオブジェクト
	 * @return オブジェクトに対応した debugObjectを返す
	 */
	public debugObject isMember(Object obj){
		int tmp = objects.size();
		for(int i=0;i<tmp;i++){
			if(objects.get(i)==obj){
				return (debugObject)debugObjects.get(i);
			}
		}
		return null;
	}


	/** リストに追加する
	 * @param dobj 追加するデバッグオブジェクト
	 * @param obj デバッグオブジェクトの値
	 */
	public void add(debugObject dobj,Object obj){
		debugObjects.add(dobj);
		objects.add(obj);
	}

	/** リストから削除する
	 * @param obj デバッグオブジェの削除
	 */
	public void remove(JTabbedPane tab,Object obj){
		int tmp = objects.size();
		int del = -1;
		for(int i=0;i<tmp;i++){
			if(objects.get(i)==obj){
				del = i;
				break;
			}
		}
		if(del >= 0 ){
			tab.remove(del);
			objects.remove(del);
			debugObjects.remove(del);
		}
	}

	/** 現在タブで選択中のデバッグオブジェクトを返します
		* @param tab タブコンポーネントを渡します
		* @return 現在選択中のオブジェクト
		*/
	public debugObject getSelected(JTabbedPane tab){
		int index = tab.getSelectedIndex();
		return (debugObject)debugObjects.get(index);
	}
}


