package gameCanvasUtil;
import java.io.*;
import java.util.ArrayList;
import java.util.jar.JarFile;


/** ファイル書き込み・読み込み等を楽にするクラス。
 *  
 *  配列をファイルに書き出したり、byte -> int の変換を行ったりするクラス
 */
public class saveDataUtil {

	/** 引数dataをファイルに書き込みます
	 * 
	 * @param file ファイル名の指定
	 * @param data データの指定
	 * @return ファイル書き込みに成功したかどうか
	 */
	static public boolean writeByteArray( String file,byte data[] ){
		FileOutputStream out = null;
		try{
			out = new FileOutputStream(file);
			out.write(data);
			out.close();
		}catch(Exception e){
			try{
				out.close();
			}catch(Exception e2){
                return false;
			}
		}
		return true;
	}

	/** バイトのデータを読み込んでバイト配列にして返します
	 * 
	 * @param file ファイル名の指定
	 * @return 読み込んだデータを返す。(newして)
	 */
	static public byte[] readByteArray(String file){
		byte[] data = null;;
		File fp = new File(file);
		long size = fp.length();
		data = new byte[(int)size];
		FileInputStream in = null;
		try{
			in = new FileInputStream(file);
			in.read(data);
			in.close();
		}catch(Exception e){
			try{
				in.close();
			}catch(Exception e2){
                return null;
			}
		}
		return data;
	}

	/** ファイルの中身を引数dataに格納していく
	 * 
	 * @param file ファイルの指定
	 * @param data データの格納先
	 * @return ファイル読み込み成功したかどうか？
	 */
	static public boolean readByteArray(String file,byte data[]){
		FileInputStream in = null;
		try{
			in = new FileInputStream(file);
			in.read(data);
			in.close();
		}catch(Exception e){
			try{
				in.close();
			}
            catch(Exception e2){
                return false;
			}
		}
		return true;
	}


	/**  intをバイト配列に突っ込む
	 * 
	 * @param dest 配列を突っ込む先
	 * @param offset 配列を突っ込むオフセット
	 * @param src 突っ込む値
	 */
	public static void int2byte(byte dest[],int offset,int src){
		dest[offset+0] = (byte)((src>>0)&0xff);
		dest[offset+1] = (byte)((src>>8)&0xff);
		dest[offset+2] = (byte)((src>>16)&0xff);
		dest[offset+3] = (byte)((src>>24)&0xff);
	}

	/** バイト配列からintをぶっこ抜く
	 * 
	 * @param src 抜き出しもとの配列
	 * @param offset 抜き出すオフセット
	 * @return ぶっこ抜いたINT列
	 */
	public static int byte2int(byte src[],int offset){
		return ((src[offset+0]&0xff)<<0)+
		((src[offset+1]&0xff)<<8)+
		((src[offset+2]&0xff)<<16)+
		((src[offset+3]&0xff)<<24);
	}

	/** intの配列からbyteの配列へ変換します
	 * @param src byte配列に変換したいintの配列
	 * @return 引数srcから変換したbyte配列
	 */
	public static byte[] intarr2bytearr(int src[]){
		byte val[] = new byte[src.length * 4];
		for(int i=0;i<src.length;i++){
			int2byte(val,i*4,src[i]);
		}
		return val;
	}

	/** byteの配列からintの配列へ変換します
	 * @param src int配列に変換したいbyteの配列
	 * @return 引数byteから変換したint配列
	 */
	public static int[] bytearr2intarr(byte src[]){
		int val[] = new int[src.length / 4];
		for(int i=0;i<val.length;i++){
			val[i] = byte2int(src,i*4);
		}
		return val;
	}

	/** ファイルから文字列を読み込んで、一行ごとに分割します 
	 * @param file テキストファイルの名前を指定
	 * @return 一行ごとに分割された文字列
	 */
	public static String[] readStringList(String file){
		try{
			//行数を調べる
			String str[];
			FileInputStream 	fi = new FileInputStream(file);
			InputStreamReader 	ir	= new InputStreamReader(fi);
			BufferedReader 		br	= new BufferedReader(ir);
			int line_num;
			ArrayList arr = new ArrayList();

			for(line_num=0;;line_num++){
				String line;
				if( (line = br.readLine()) == null){
					break;
				}
				arr.add(line);
			}
			fi.close();
			ir.close();
			br.close();

			//実際に読み込む
			str = new String[line_num];
			for(int i=0;i<line_num;i++){
				str[i] = (String)arr.get(i);
			}
			return str;
		}catch(Exception e){
			return null;
		}
	}

	/** ファイルにStringの配列を一行ずつ書き込んでいきます
	 * @param file 書き込むファイル名の指定
	 * @param data 書き込む文字配列の指定
	 * @return 書き込みに成功したかどうかを返します
	 */
	public static boolean writeStringList(String file,String[]data){
		try{
			String str="";
			for(int i=0;i<data.length;i++){
				str += data[i];
				if(i!=data.length-1)
					str += "\n";
			}
			FileOutputStream fo = new FileOutputStream(file);
			fo.write(str.getBytes());
			fo.close();
		}catch(Exception e){
			return false;
		}		
		return true;
	}

	/** Resource用のバイナリファイルを読み込みます
	 * 
	 * @param binaryName jarファイル内の名前を指定
	 * @return 読み込んだファイルの中のバイナリ
	 */
	public static byte[] readResourceBinary(String binaryName){
		byte val[] = null;
		try{
			ArrayList arr = new ArrayList();
			byte tmp[],wbuf[];
			InputStream is = (new Object()).getClass().getResourceAsStream("/"+binaryName);

			//実際の読み込み
			int fsize = 0;
			tmp = new byte[1024];
			while(true){
				int tmpfsize = is.read(tmp,0,tmp.length);
				if(tmpfsize<0){
					break;
				}
				wbuf = new byte[tmpfsize];
				System.arraycopy( tmp , 0, wbuf, 0, tmpfsize );
				fsize += tmpfsize;
				arr.add(wbuf);
			}
			is.close();

			//読み込んだ値をvalに格納
			val = new byte[fsize];
			
			fsize = 0;
			for(int i=0;i<arr.size();i++){
				tmp = (byte[])arr.get(i);
				for(int j=0;j <tmp.length && fsize+j < val.length;j++){
					val[j+fsize] = tmp[j];
				}
				fsize += tmp.length;
			}

		}catch(Exception e){
			return null;
		}
		return val;
	}


	/** Resource用の文字列ファイルを読み込みます
	 * 
	 * @param binaryName jarファイル内の名前を指定
	 * @return 読み込んだファイルの中の文字列
	 */
	public static String[] readResourceStrings(String strName){		
		String str[] = null;
		try{
			//バイナリとして読み込んで、文字列化
			byte tmp[] = readResourceBinary(strName);
			if(tmp==null){
				return null;
			}
			String tmpstr = new String(tmp);
			

			//文字列行数を数える
			int strcnt=1;
			for(int i=0;i<tmpstr.length();i++){
				if(tmpstr.charAt(i)=='\n'){
					strcnt++;
				}
			}
			//テーブルの初期化
			str = new String[strcnt];
			for(int i=0;i<str.length;i++){
				str[i]="";
			}
			//テーブルに突っ込む
			strcnt = 0;
			for(int i=0;i<tmpstr.length();i++){
				if(tmpstr.charAt(i)=='\n'){
					strcnt++;
				}else if(tmpstr.charAt(i)!='\r'){
					str[strcnt] += tmpstr.charAt(i);				
				}
			}

		}catch(Exception e){
			return null;
		}		
		return str;
	}

	/** 拡張子とディレクトリを指定して、それ以下にあるファイルを返します。
	 * @param dir 探し出すディレクトリ
	 * @param ext 拡張子。"*"を入れると全ファイルを返します。"."を入れると、全ディレクトリを返します。
	 */
	public static String []lsCommand(String dir,String ext){
		File f = new File(dir);
		
		String list[] = f.list();
		String ret []= null;
		boolean flag[] = new boolean[list.length];
		int cnt = 0;
		//
		for(int i=0;i<list.length;i++){
			list[i] = dir + "/"+list[i];
			if( ext.equals(".") ){
				if( new File(list[i]).isDirectory() ){
					flag[i] = true;
					cnt++;
				}
			}else{
				if( ( ext.equals("*") || list[i].endsWith(ext) )
					&& new File(list[i]).isFile() ){
					flag[i] = true;
					cnt++;
				}
			}
		}
		//
		ret = new String[cnt];
		cnt = 0;
		for(int i=0;i<list.length;i++){
			if(flag[i]){
				ret[cnt] = list[i];
				cnt ++;
			}
		}

		return ret;
	}
}
