//インポート
import gameCanvasUtil.*;

/** ゲームクラス。
 *
 * 学生が編集すべきソースコードです。
 */
public class Game extends GameBase
{
    /********* 変数定義はこちらに *********/
    // 型 変数名;　の順に書いて定義する
    // プレイヤーのX座標
    int player_x;
    // プレイヤーのY座標
    int player_y;
    // プレイヤーの幅
    int player_w;
    // プレイヤーの高さ
    int player_h;

    // 敵のX座標
    int enemy_x;
    // 敵のY座標
    int enemy_y;
    // 敵の幅
    int enemy_w;
    // 敵の高さ
    int enemy_h;
    // 敵の速度
    int enemy_speed;
    // 敵が生きているかどうかのフラグ
    boolean enemy_alive_flag;

    // ショットのX座標
    int[] shot_x = new int[10];
    // ショットのY座標
    int[] shot_y = new int[10];
    // ショットが生きているか、死んでいるかのフラグ
    boolean[] shot_alive_flag = new boolean[10];
    // ショットのY方向の速度
    int shot_speed_y;
    // ショットのサイズ
    int shot_size;

    // 次に有効にするショット番号
    int next_alive_shot_num;

    /********* 初期化の手順はこちらに *********/
    public void initGame()
    {
        // プレイヤーの座標を初期化する
        player_x = 270;
        player_y = 450;
        // プレイヤーの幅・高さを初期化する
        player_w = 50;
        player_h = 20;

        // 敵の座標を初期化する
        enemy_x = 0;
        enemy_y = 0;
        // 敵の幅・高さを初期化する
        enemy_w = 100;
        enemy_h = 20;
        // 敵の速度を初期化
        enemy_speed = 10;
        // 敵が生きているかどうかのフラグを初期化
        enemy_alive_flag = true;

        // ショットの初期化処理
        for(int i=0; i<10; i=i+1)
        {
            // ショットの座標を初期化する
            shot_x[i] = 0;
            shot_y[i] = 0;
            // ショットのフラグを初期化する
            shot_alive_flag[i] = false;
        }

        // ショットの速度を初期化する
        shot_speed_y = -20;

        // ショットのサイズを初期化する
        shot_size = 24;

        // 次に有効にするショット番号を初期化
        next_alive_shot_num = 0;
    }

    /********* 物体の移動等の更新処理はこちらに *********/
    public void updateGame()
    {
        // 左キーが押され続けている場合に真
        if(gc.isKeyPress(gc.KEY_LEFT))
        {
            // プレイヤーを左に動かす
            player_x = player_x - 5;
        }
        // 右キーが押され続けている場合に真
        if(gc.isKeyPress(gc.KEY_RIGHT))
        {
            // プレイヤーを右に動かす
            player_x = player_x + 5;
        }

        // 敵を移動させる
        enemy_x = enemy_x + enemy_speed;
        // 敵が画面の右を越えるか、画面の左を越えた場合
        if(enemy_x > 640 - enemy_w || enemy_x < 0)
        {
            enemy_speed = -enemy_speed;
        }

        // Zキーを押すと、ショットを発射する
        if(gc.isKeyPushed(gc.KEY_Z))
        {
            // ショットを有効に
            shot_alive_flag[next_alive_shot_num] = true;

            // ショットの初期座標をプレイヤーの中央位置にセット
            shot_x[next_alive_shot_num] = player_x + player_w/2 - shot_size/2;
            shot_y[next_alive_shot_num] = player_y + player_h/2 - shot_size/2;
            
            // 次のショットの番号へ。
            next_alive_shot_num = next_alive_shot_num + 1;

            // ショットは10個までなので、それを超えたら0に戻る(使い回す)
            if(next_alive_shot_num >= 10)
            {
                // 次のショットの番号を先頭の 0 へ
                next_alive_shot_num = 0;
            }
        }

        // ショット更新用のfor文
        for(int i=0; i<10; i=i+1)
        {
            // 有効(true)なショットのみ実行
            if(shot_alive_flag[i])
            {
                // Y方向に shot_speed_y ずつ進める
                shot_y[i] = shot_y[i] + shot_speed_y;

                // ショットが画面の上を越えた場合
                if(shot_y[i] < -shot_size)
                {
                    // ショットのフラグを false に
                    shot_alive_flag[i] = false;
                }

                // もし敵がまだ生きていれば
                if(enemy_alive_flag)
                {
                    // 敵と、有効なショットの当たり判定を行う
                    if( gc.checkHitRect(enemy_x, enemy_y, enemy_w, enemy_h, shot_x[i], shot_y[i], shot_size, shot_size) )
                    {
                        // ぶつかった敵のフラグを false に
                        enemy_alive_flag = false;

                        // ショットのフラグも false に
                        shot_alive_flag[i] = false;
                    }
                }
            }
        }
    }

    /********* 画像の描画はこちらに *********/
    public void drawGame()
    {
        // 画面を白で塗りつぶします
        gc.clearScreen();

        // img0.png を描画します
        for(int i=0; i<10; i=i+1)
        {
            // 有効(true)なショットのみ描画
            if(shot_alive_flag[i])
            {
                // ショットを描画
                gc.drawImage(0, shot_x[i], shot_y[i]);
            }
        }

        // 色を赤にセットします
        gc.setColor(255, 0, 0);
        // もし敵が生きていれば
        if(enemy_alive_flag)
        {
            // 敵を描画します
            gc.fillRect(enemy_x, enemy_y, enemy_w, enemy_h);
        }

        // 色を青にセットします
        gc.setColor(0, 0, 255);
        // プレイヤーを描画します
        gc.fillRect(player_x, player_y, player_w, player_h);
    }

    /********* 終了時の処理はこちらに *********/
    public void finalGame() {}
}
