//インポート
import gameCanvasUtil.*;

/** ゲームクラス。
 *
 * 学生が編集すべきソースコードです。
 */
public class Game extends GameBase
{
    /********* 変数定義はこちらに *********/
    // 型 変数名;　の順に書いて定義する
    // プレイヤーのX座標
    int player_x;
    // プレイヤーのY座標
    int player_y;
    // プレイヤーの幅
    int player_w;
    // プレイヤーの高さ
    int player_h;

    // ショットのX座標
    int[] shot_x = new int[10];
    // ショットのY座標
    int[] shot_y = new int[10];
    // ショットが生きているか、死んでいるかのフラグ
    boolean[] shot_alive_flag = new boolean[10];
    // ショットのY方向の速度
    int shot_speed_y;
    // ショットのサイズ
    int shot_size;

    // 次に有効にするショット番号
    int next_alive_shot_num;

    // 敵のX座標
    int[] enemy_x = new int[10];
    // 敵のY座標
    int[] enemy_y = new int[10];
    // 敵の幅
    int enemy_w;
    // 敵の高さ
    int enemy_h;
    // 敵の速度
    int enemy_speed_y;
    // 敵が生きているかどうかのフラグ
    boolean[] enemy_alive_flag  = new boolean[10];;

    // 次に有効にする敵の番号
    int next_alive_enemy_num;

    // 時間を表す変数
    int time;

    /********* 初期化の手順はこちらに *********/
    public void initGame()
    {
        // プレイヤーの座標を初期化する
        player_x = 270;
        player_y = 450;
        // プレイヤーの幅・高さを初期化する
        player_w = 50;
        player_h = 20;

        // ショットの初期化処理
        for(int i=0; i<10; i=i+1)
        {
            // ショットの座標を初期化する
            shot_x[i] = 0;
            shot_y[i] = 0;
            // ショットのフラグを初期化する
            shot_alive_flag[i] = false;
        }

        // ショットの速度を初期化する
        shot_speed_y = -20;

        // ショットのサイズを初期化する
        shot_size = 24;

        // 次に有効にするショット番号を初期化
        next_alive_shot_num = 0;

        // 敵の初期化処理
        for(int i=0; i<10; i=i+1)
        {
            // 敵の座標を初期化する
            enemy_x[i] = 0;
            enemy_y[i] = 0;
            // 敵が生きているかどうかのフラグを初期化
            enemy_alive_flag[i] = false;
        }
        
        // 敵の幅・高さを初期化する
        enemy_w = 100;
        enemy_h = 20;
        // 敵の速度を初期化
        enemy_speed_y = 5;

        // 次に有効にする敵の番号を初期化
        next_alive_enemy_num = 0;

        // 時間を表す変数を初期化
        time = 0;
    }

    /********* 物体の移動等の更新処理はこちらに *********/
    public void updateGame()
    {
        // 左キーが押され続けている場合に真
        if(gc.isKeyPress(gc.KEY_LEFT))
        {
            // プレイヤーを左に動かす
            player_x = player_x - 5;
        }
        // 右キーが押され続けている場合に真
        if(gc.isKeyPress(gc.KEY_RIGHT))
        {
            // プレイヤーを右に動かす
            player_x = player_x + 5;
        }

        // 1秒(30フレーム)毎に敵を生成する
        if(time % 30 == 0)
        {
            // 敵を有効に
            enemy_alive_flag[next_alive_enemy_num] = true;

            // 敵の初期座標をランダムにセット
            enemy_x[next_alive_enemy_num] = gc.rand(0, 640-enemy_w);
            enemy_y[next_alive_enemy_num] = 0;
            
            // 次の敵の番号へ。
            next_alive_enemy_num = next_alive_enemy_num + 1;

            // 敵は10個までなので、それを超えたら0に戻る(使い回す)
            if(next_alive_enemy_num >= 10)
            {
                // 次の敵の番号を先頭の 0 へ
                next_alive_enemy_num = 0;
            }
        }

        // 敵更新用のfor文
        for(int i=0; i<10; i=i+1)
        {
            // 有効(true)な敵のみ実行
            if(enemy_alive_flag[i])
            {
                // Y方向に enemy_speed_y ずつ進める
                enemy_y[i] = enemy_y[i] + enemy_speed_y;

                // 敵が画面の下を越えた場合
                if(enemy_y[i] > 480)
                {
                    // 敵のフラグを false に
                    enemy_alive_flag[i] = false;
                }
            }
        }

        // Zキーを押すと、ショットを発射する
        if(gc.isKeyPushed(gc.KEY_Z))
        {
            // ショットを有効に
            shot_alive_flag[next_alive_shot_num] = true;

            // ショットの初期座標をプレイヤーの中央位置にセット
            shot_x[next_alive_shot_num] = player_x + player_w/2 - shot_size/2;
            shot_y[next_alive_shot_num] = player_y + player_h/2 - shot_size/2;
            
            // 次のショットの番号へ。
            next_alive_shot_num = next_alive_shot_num + 1;

            // ショットは10個までなので、それを超えたら0に戻る(使い回す)
            if(next_alive_shot_num >= 10)
            {
                // 次のショットの番号を先頭の 0 へ
                next_alive_shot_num = 0;
            }
        }

        // ショット更新用のfor文
        for(int i=0; i<10; i=i+1)
        {
            // 有効(true)なショットのみ実行
            if(shot_alive_flag[i])
            {
                // Y方向に shot_speed_y ずつ進める
                shot_y[i] = shot_y[i] + shot_speed_y;

                // ショットが画面の上を越えた場合
                if(shot_y[i] < -shot_size)
                {
                    // ショットのフラグを false に
                    shot_alive_flag[i] = false;
                }

                // 全ての敵に対してショットとの当たり判定を行う
                for(int j=0; j<10; j=j+1)
                {
                    // 敵のフラグがtrueなら
                    if(enemy_alive_flag[j])
                    {
                        // 敵と、有効なショットの当たり判定を行う
                        if( gc.checkHitRect(enemy_x[j], enemy_y[j], enemy_w, enemy_h, shot_x[i], shot_y[i], shot_size, shot_size) )
                        {
                            // ぶつかった敵のフラグを false に
                            enemy_alive_flag[j] = false;

                            // ショットのフラグも false に
                            shot_alive_flag[i] = false;

                            // ショットが消えたので、敵との当たり判定を行うfor文から抜ける
                            break;
                        }
                    }
                }
            }
        }

        // 時間を加算する
        time = time + 1;
    }

    /********* 画像の描画はこちらに *********/
    public void drawGame()
    {
        // 画面を白で塗りつぶします
        gc.clearScreen();

        // img0.png を描画します
        for(int i=0; i<10; i=i+1)
        {
            // 有効(true)なショットのみ描画
            if(shot_alive_flag[i])
            {
                // ショットを描画
                gc.drawImage(0, shot_x[i], shot_y[i]);
            }
        }

        // 色を赤にセットします
        gc.setColor(255, 0, 0);
        // 敵を描画するfor文
        for(int i=0; i<10; i=i+1)
        {
            // 有効(true)なショットのみ描画
            if(enemy_alive_flag[i])
            {
                // 敵を描画します
                gc.fillRect(enemy_x[i], enemy_y[i], enemy_w, enemy_h);
            }
        }

        // 色を青にセットします
        gc.setColor(0, 0, 255);
        // プレイヤーを描画します
        gc.fillRect(player_x, player_y, player_w, player_h);
    }

    /********* 終了時の処理はこちらに *********/
    public void finalGame() {}
}
