/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class SavedataManager {
    private static final int SAVE_DATA_SIZE = 1024;
    private int[] savedata = null;
    private boolean savedataChanged = false;
    private static SavedataManager instance = null;

    private void SavedataManager() {
        this.savedataChanged = false;
    }

    public static SavedataManager getInstance() {
        if (instance == null) {
            instance = new SavedataManager();
        }
        return instance;
    }

    public void writeRecord() {
        if (this.savedataChanged) {
            byte[] byArray = this.intarr2bytearr(this.savedata);
            this.writeByteArray("savedata.dat", byArray);
            this.savedataChanged = false;
        }
    }

    public void readRecord() {
        byte[] byArray = this.readByteArray("savedata.dat");
        if (byArray == null) {
            this.savedata = new int[1024];
            this.writeRecord();
        } else {
            this.savedata = this.bytearr2intarr(byArray);
        }
    }

    public int load(int n) {
        return this.savedata[n];
    }

    public void save(int n, int n2) {
        this.savedata[n] = n2;
        this.savedataChanged = true;
    }

    public boolean writeByteArray(String string, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception2) {
                return false;
            }
        }
        return true;
    }

    private byte[] readByteArray(String string) {
        byte[] byArray = null;
        File file = new File(string);
        long l = file.length();
        byArray = new byte[(int)l];
        if (this.readByteArray(string, byArray)) {
            return byArray;
        }
        return null;
    }

    private boolean readByteArray(String string, byte[] byArray) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (Exception exception) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception2) {
                return false;
            }
        }
        return true;
    }

    private void int2byte(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >> 0 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    private int byte2int(byte[] byArray, int n) {
        return ((byArray[n + 0] & 0xFF) << 0) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
    }

    private byte[] intarr2bytearr(int[] nArray) {
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            this.int2byte(byArray, i * 4, nArray[i]);
        }
        return byArray;
    }

    private int[] bytearr2intarr(byte[] byArray) {
        int[] nArray = new int[byArray.length / 4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.byte2int(byArray, i * 4);
        }
        return nArray;
    }
}

