/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil;

public class FPSManager {
    private long prevTime = 0L;
    private int fps;
    private int fpsTemp;
    private int waitTime;
    private int confFps = 60;
    private static FPSManager instance = null;

    private void FPSManager() {
    }

    public static FPSManager getInstance() {
        if (instance == null) {
            instance = new FPSManager();
        }
        return instance;
    }

    public void init(int n) {
        this.confFps = n;
        this.waitTime = 1000 / n;
    }

    public int Wait() {
        long l = System.currentTimeMillis();
        ++this.fpsTemp;
        if (this.prevTime / 1000L != l / 1000L) {
            this.fps = this.fpsTemp;
            this.fpsTemp = 0;
            if (this.fps > this.confFps + 1) {
                ++this.waitTime;
            } else if (this.fps < this.confFps - 1) {
                --this.waitTime;
            }
            if (this.fps > this.confFps + this.confFps / 3) {
                this.waitTime = (this.fps - this.waitTime) / 3 + this.waitTime;
            }
        }
        long l2 = l - this.prevTime;
        this.prevTime = l;
        if (l2 == 0L) {
            l2 = 1L;
        }
        this.sleep();
        return this.fps;
    }

    private void sleep() {
        try {
            if (this.waitTime > 0) {
                Thread.sleep(this.waitTime);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public int getFps() {
        return this.fps;
    }
}

