/*
 * Decompiled with CFR 0.152.
 */
import gameCanvasUtil.GameCanvas;
import gameCanvasUtil.Resource.InputManager;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class AppCanvas
extends Canvas
implements MouseMotionListener,
MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private Image offImage = null;
    private Graphics offScreen = null;
    private InputManager inputManager = InputManager.getInstance();
    private GameCanvas gameCanvas = GameCanvas.getInstance();

    public AppCanvas() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setSize(640, 480);
    }

    public void updateMessage() {
        this.gameCanvas.updateMessage();
        this.inputManager.updateKeyData();
    }

    public void drawMessage() {
        this.gameCanvas.drawMessage();
        this.repaint();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.offImage == null) {
            this.offImage = this.createImage(640, 480);
            this.offScreen = this.offImage.getGraphics();
            this.gameCanvas.setGraphics(this.offScreen, this.offImage);
            this.requestFocusInWindow();
        }
        graphics.drawImage(this.offImage, 0, 0, null);
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27 && this.gameCanvas.showYesNoDialog("\u30b2\u30fc\u30e0\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059\u304b\uff1f")) {
            this.gameCanvas.resetGame();
            this.gameCanvas.resetGameInstance(new Game());
        }
        this.inputManager.keyPressed(keyEvent);
    }

    @Override
    public synchronized void keyReleased(KeyEvent keyEvent) {
        this.inputManager.keyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.inputManager.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.inputManager.mouseExited(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.inputManager.mouseClicked(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.inputManager.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.inputManager.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.inputManager.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.inputManager.mouseMoved(mouseEvent);
    }
}

