/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil.Resource;

import gameCanvasUtil.Resource.ResourceUtil;
import gameCanvasUtil.Resource.SoundManagerInterface;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;

public class SoundManager
implements SoundManagerInterface {
    private int resourceNum;
    private Clip[] audio = null;
    private static SoundManager instance = null;

    private void SoundManager() {
        this.resourceNum = 0;
    }

    public static SoundManager getInstance() {
        if (instance == null) {
            instance = new SoundManager();
        }
        return instance;
    }

    @Override
    public void init(String string) {
        this.loadNumberingSound(string);
    }

    private void loadNumberingSound(String string) {
        String[] stringArray = new String[]{".wav"};
        this.resourceNum = ResourceUtil.getResourceLastID(string, stringArray);
        if (this.resourceNum <= 0) {
            return;
        }
        this.audio = new Clip[this.resourceNum];
        for (int i = 0; i < this.resourceNum; ++i) {
            this.audio[i] = this.loadSound(string + i + ".wav");
            if (this.audio[i] == null) break;
        }
    }

    private Clip loadSound(String string) {
        Clip clip = null;
        try {
            AudioInputStream audioInputStream = null;
            audioInputStream = AudioSystem.getAudioInputStream(this.getClass().getResourceAsStream("/" + string));
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            audioInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("loadSound Exception " + string + "::" + exception);
            return null;
        }
        return clip;
    }

    @Override
    public void playSound(int n, boolean bl) {
        try {
            this.stopSound(n);
            this.audio[n].setFramePosition(0);
            if (bl) {
                this.audio[n].loop(-1);
            } else {
                this.audio[n].start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void stopSound(int n) {
        try {
            this.audio[n].stop();
            this.audio[n].setFramePosition(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void pauseSound(int n) {
        try {
            this.audio[n].stop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void pauseSound() {
        for (int i = 0; i < this.resourceNum; ++i) {
            this.pauseSound(i);
        }
    }

    @Override
    public void stopSound() {
        for (int i = 0; i < this.resourceNum; ++i) {
            this.stopSound(i);
        }
    }

    @Override
    public void changeVolume(int n) {
        for (int i = 0; i < this.resourceNum; ++i) {
            this.changeVolume(i, n);
        }
    }

    @Override
    public void changeVolume(int n, int n2) {
        try {
            FloatControl floatControl = (FloatControl)this.audio[n].getControl(FloatControl.Type.MASTER_GAIN);
            float f = floatControl.getMaximum() - floatControl.getMinimum();
            floatControl.setValue(f * (float)Math.sqrt((float)n2 / 100.0f) + floatControl.getMinimum());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void update() {
    }
}

