/*
 * Decompiled with CFR 0.152.
 */
import gameCanvasUtil.GameBase;

public class Game
extends GameBase {
    int ball_x;
    int ball_y;
    int ball_speed_x;
    int ball_speed_y;
    int racket_x;
    int racket_y;
    int racket_w;
    int racket_h;
    int gameState;
    int ball_dead_num;
    int ball_hit_num;

    @Override
    public void initGame() {
        this.ball_x = 0;
        this.ball_y = 100;
        this.ball_speed_x = 5;
        this.ball_speed_y = 5;
        this.racket_x = 270;
        this.racket_y = 450;
        this.racket_w = 50;
        this.racket_h = 10;
        this.gameState = 0;
        this.ball_dead_num = 0;
        this.ball_hit_num = 0;
    }

    @Override
    public void updateGame() {
        if (this.gameState == 0) {
            if (this.gc.isKeyPushed(8)) {
                this.gameState = 1;
                this.gc.playBGM(0);
            }
        } else if (this.gameState == 1) {
            if (this.gc.isKeyPushed(8)) {
                this.gameState = 2;
                this.gc.stopBGM();
            }
            if (this.gc.isKeyPress(2)) {
                this.racket_x -= 5;
            }
            if (this.gc.isKeyPress(3)) {
                this.racket_x += 5;
            }
            this.ball_y += this.ball_speed_y;
            this.ball_x += this.ball_speed_x;
            if (this.ball_y < 0) {
                this.ball_speed_y = -this.ball_speed_y;
            }
            if (this.ball_x > 616 || this.ball_x < 0) {
                this.ball_speed_x = -this.ball_speed_x;
            }
            if (this.ball_y > 480) {
                ++this.ball_dead_num;
                if (this.ball_dead_num >= 3) {
                    this.gameState = 3;
                    this.gc.stopBGM();
                } else {
                    this.ball_x = 0;
                    this.ball_y = 100;
                    this.racket_x = 270;
                    this.racket_y = 450;
                    this.gameState = 1;
                    this.ball_hit_num = 0;
                }
            }
            if (this.gc.checkHitRect(this.racket_x, this.racket_y, this.racket_w, this.racket_h, this.ball_x, this.ball_y, 24, 24)) {
                this.ball_speed_y = -this.ball_speed_y;
                this.gc.playSE(0);
                ++this.ball_hit_num;
                if (this.ball_hit_num >= 5) {
                    this.gameState = 4;
                    this.gc.stopBGM();
                }
            }
        } else if (this.gameState == 2) {
            if (this.gc.isKeyPushed(8)) {
                this.gameState = 1;
                this.gc.playBGM(0);
            }
        } else if (this.gameState == 3 || this.gameState == 4) {
            // empty if block
        }
    }

    @Override
    public void drawGame() {
        this.gc.clearScreen();
        if (this.gameState == 0) {
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("\u30c6\u30cb\u30b9\u30b2\u30fc\u30e0", 250, 150);
            this.gc.drawString("Push Enter", 260, 250);
        } else if (this.gameState == 1) {
            this.gc.drawImage(0, this.ball_x, this.ball_y);
            this.gc.setColor(0, 0, 255);
            this.gc.fillRect(this.racket_x, this.racket_y, this.racket_w, this.racket_h);
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("Hit:" + this.ball_hit_num, 0, 0);
            this.gc.drawString("Miss:" + this.ball_dead_num, 0, 32);
        } else if (this.gameState == 2) {
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("PAUSE", 280, 200);
        } else if (this.gameState == 3) {
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("GAME OVER", 230, 200);
        } else if (this.gameState == 4) {
            this.gc.setColor(0, 0, 0);
            this.gc.drawString("CLEAR", 280, 200);
        }
    }

    @Override
    public void finalGame() {
    }
}

