//インポート
import gameCanvasUtil.*;

/** ゲームクラス。
 *
 * 学生が編集すべきソースコードです。
 */
public class Game extends GameBase
{
    /********* 変数定義はこちらに *********/
    // 型 変数名;　の順に書いて定義する

    // ボールのX座標
    int ball_x;
    // ボールのY座標
    int ball_y;
    // ボールのX方向の速度
    int ball_speed_x;
    // ボールのY方向の速度
    int ball_speed_y;
    // ボールのサイズ
    int ball_size;

    // ブロックの幅
    int block_width;
    // ブロック高さ
    int block_height;
    // ブロックの X, Y 座標
    int block_x[] = new int[10];
    int block_y[] = new int[10];
    // ブロックが生きているかどうか
    boolean block_alive_flag[] = new boolean[10];

    /********* 初期化の手順はこちらに *********/
    public void initGame()
    {
        // ボールの座標を初期化する
        ball_x = 0;
        ball_y = 100;

        // ボールの速度を初期化する
        ball_speed_x = 5;
        ball_speed_y = 5;

        // ボールの大きさを初期化
        ball_size = 24;

        // ブロックの幅を64で初期化
        block_width = 64;
        // ブロックの高さ30で初期化
        block_height = 30;

        // ブロックの座標を初期化する
        for(int i=0; i<10; i=i+1)
        {
            block_x[i] = 64 * i;
            block_y[i] = 0;
            // 生存フラグを有効に
            block_alive_flag[i] = true;
        }
    }

    /********* 物体の移動等の更新処理はこちらに *********/
    public void updateGame()
    {
        // Y方向に ball_speed_y ずつ進める
        ball_y = ball_y + ball_speed_y;

        // X方向に ball_speed_x ずつ進める
        ball_x = ball_x + ball_speed_x;

        // ボールが画面の上を越えるか、画面の下を超えた場合
        if(ball_y < 0 || ball_y > 480 - ball_size)
        {
            // ボールのY方向の速度を反転させる
            ball_speed_y = -ball_speed_y;
        }

        // ボールが画面の右を越えるか、画面の左を越えた場合
        if(ball_x > 640 - ball_size || ball_x < 0)
        {
            // ボールのX方向の速度を反転させる
            ball_speed_x = -ball_speed_x;
        }

        // ボールとブロックの当たり判定
        for(int i=0; i<10; i=i+1)
        {
            // ブロックが生きていれば(trueなら)判定を実行
            if(block_alive_flag[i])
            {
                // ブロックと、ボールとの当たり判定
                if( gc.checkHitRect(block_x[i], block_y[i], block_width, block_height, ball_x, ball_y, ball_size, ball_size) )
                {
                    // ぶつかったブロックを非表示にするために、falseをセットする
                    block_alive_flag[i] = false;
                }
            }
        }
    }

    /********* 画像の描画はこちらに *********/
    public void drawGame()
    {
        // 画面を白で塗りつぶします
        gc.clearScreen();

        // img0.png を(ball_x, ball_y)に描画します
        gc.drawImage(0, ball_x, ball_y);

        // 色を赤にセット
        gc.setColor(255, 0, 0);
        // ブロックを描画します
        for(int i=0; i<10; i=i+1)
        {
            // ブロックが生きていれば(trueなら)描画する
            if(block_alive_flag[i])
            {
                gc.fillRect(block_x[i], block_y[i], block_width, block_height);
            }
        }
    }

    /********* 終了時の処理はこちらに *********/
    public void finalGame() {}
}
