//インポート
import gameCanvasUtil.*;

/** ゲームクラス。
 *
 * 学生が編集すべきソースコードです。
 */
public class Game extends GameBase
{
    /********* 変数定義はこちらに *********/
    // 型 変数名;　の順に書いて定義する
    // ボールのX座標
    int ball_x;
    // ボールのY座標
    int ball_y;
    // ボールのX方向の速度
    int ball_speed_x;
    // ボールのY方向の速度
    int ball_speed_y;
    // ボールの大きさ
    int ball_size;
    // ボールが表示されているかどうか
    boolean ball_alive_flag;

    /********* 初期化の手順はこちらに *********/
    public void initGame()
    {
        // ボールの座標を初期化する
        ball_x = 0;
        ball_y = 0;

        // ボールの速度を初期化する
        ball_speed_x = 3;
        ball_speed_y = 3;

        // ボールのサイズを初期化する
        ball_size = 24;

        // ボールが表示されているかどうか
        ball_alive_flag = true;
    }

    /********* 物体の移動等の更新処理はこちらに *********/
    public void updateGame()
    {
        // ボールが表示されていれば移動処理を行う
        if(ball_alive_flag)
        {
            // Y方向に ball_speed_y ずつ進める
            ball_y = ball_y + ball_speed_y;

            // X方向に ball_speed_x ずつ進める
            ball_x = ball_x + ball_speed_x;

            // ボールが画面の下を越えるか、画面の上を越えた場合
            if(ball_y > 480 - ball_size || ball_y < 0)
            {
                // ボールのY方向の速度を反転させる
                ball_speed_y = -ball_speed_y;
            }

            // ボールが画面の右を越えるか、画面の左を越えた場合
            if(ball_x > 640 - ball_size || ball_x < 0)
            {
                // ボールのX方向の速度を反転させる
                ball_speed_x = -ball_speed_x;
            }

            // マウスがクリックされた瞬間なら、
            if(gc.isMousePushed())
            {
                // ボールと、マウスクリック座標との当たり判定を行う
                if( gc.checkHitRect(ball_x, ball_y, ball_size, ball_size, gc.getMouseX(), gc.getMouseY(), 1, 1) )
                {
                    // ボールをクリックしていれば、ボールを非表示状態に
                    ball_alive_flag = false;
                }
            }
        }
    }

    /********* 画像の描画はこちらに *********/
    public void drawGame()
    {
        // 画面を白で塗りつぶします
        gc.clearScreen();

        // ボールが表示状態なら
        if(ball_alive_flag)
        {
            // img0.png を(ball_x, ball_y)に描画します
            gc.drawImage(0, ball_x, ball_y);
        }
    }

    /********* 終了時の処理はこちらに *********/
    public void finalGame() {}
}
