/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil;

import gameCanvasUtil.Collision.Collision;
import gameCanvasUtil.GameInterface;
import gameCanvasUtil.Resource.ImageManager;
import gameCanvasUtil.Resource.InputManager;
import gameCanvasUtil.Resource.MidiManager;
import gameCanvasUtil.Resource.SoundManager;
import gameCanvasUtil.Resource.SoundManagerInterface;
import gameCanvasUtil.SavedataManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GameCanvas {
    public static final int WIDTH = 640;
    public static final int HEIGHT = 480;
    public static final int CONFIG_FPS = 30;
    public static final int KEY_UP = 0;
    public static final int KEY_DOWN = 1;
    public static final int KEY_LEFT = 2;
    public static final int KEY_RIGHT = 3;
    public static final int KEY_Z = 4;
    public static final int KEY_X = 5;
    public static final int KEY_C = 6;
    public static final int KEY_V = 7;
    public static final int KEY_ENTER = 8;
    public static final int KEY_SPACE = 11;
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_GRAY = 0x808080;
    public static final int COLOR_RED = 0xFF0000;
    public static final int COLOR_BLUE = 255;
    public static final int COLOR_GREEN = 65280;
    public static final int COLOR_YELLOW = 0xFFFF00;
    public static final int COLOR_PURPLE = 0xFF00FF;
    public static final int COLOR_CYAN = 65535;
    public static final int COLOR_AQUA = 0x7F7FFF;
    private ImageManager imageManager;
    private SoundManagerInterface seManager;
    private SoundManagerInterface bgmManager;
    private InputManager inputManager;
    private GameInterface game;
    private SavedataManager savedataManager;
    private Random rand = new Random();
    private Graphics graphics;
    private Image offImage;
    private JFrame frame;
    private static GameCanvas _gc;
    private Font myFont;
    private int FontSize;
    private AffineTransform tr = new AffineTransform();
    private int cur_bgm = -1;

    public static GameCanvas getInstance() {
        if (_gc == null) {
            _gc = new GameCanvas();
        }
        return _gc;
    }

    private GameCanvas() {
    }

    public void init(JFrame jFrame, GameInterface gameInterface) {
        this.frame = jFrame;
        this.setImageManager(ImageManager.getInstance());
        this.imageManager.init("res/img");
        this.setSEManager(SoundManager.getInstance());
        this.seManager.init("res/snd");
        this.changeSEVolume(100);
        this.setBGMManager(MidiManager.getInstance());
        this.bgmManager.init("res/bgm");
        this.changeBGMVolume(60);
        this.inputManager = InputManager.getInstance();
        this.savedataManager = SavedataManager.getInstance();
        this.readRecord();
        this.game = gameInterface;
        this.game.initGame();
    }

    public void finalize() {
        if (this.game != null) {
            this.game.finalGame();
        }
        this.writeRecord();
    }

    public void setGraphics(Graphics graphics, Image image) {
        this.graphics = graphics;
        this.offImage = image;
        this.setFont("", 0, 25);
    }

    public boolean writeScreenImage(String string) {
        BufferedImage bufferedImage = new BufferedImage(640, 480, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(this.offImage, 0, 0, null);
        try {
            return ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string + ".png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void setWindowTitle(String string) {
        this.frame.setTitle(string);
    }

    public void drawString(String string, int n, int n2) {
        this.graphics.drawString(string, n, n2 + this.graphics.getFont().getSize());
    }

    public void drawCenterString(String string, int n, int n2) {
        this.drawString(string, n - this.getStringWidth(string) / 2, n2);
    }

    public void drawRightString(String string, int n, int n2) {
        this.drawString(string, n - this.getStringWidth(string), n2);
    }

    public void setFont(String string, int n, int n2) {
        this.myFont = new Font(string, n, n2);
        this.graphics.setFont(this.myFont);
        this.FontSize = n2;
    }

    public void setFontSize(int n) {
        this.setFont("", 0, n);
    }

    public int getStringWidth(String string) {
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        return fontMetrics.stringWidth(string);
    }

    public void setColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        this.setColor(n2, n3, n4);
    }

    public void setColor(int n, int n2, int n3) {
        this.graphics.setColor(new Color(n, n2, n3));
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.graphics.drawLine(n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.graphics.drawRect(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public void drawCircle(int n, int n2, int n3) {
        this.graphics.drawArc(n - n3, n2 - n3, n3 * 2, n3 * 2, 0, 360);
    }

    public void fillCircle(int n, int n2, int n3) {
        this.graphics.fillArc(n - n3, n2 - n3, n3 * 2, n3 * 2, 0, 360);
    }

    public void drawImage(int n, int n2, int n3) {
        try {
            this.graphics.drawImage(this.imageManager.getImage(n), n2, n3, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void drawClipImage(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            this.graphics.drawImage(this.imageManager.getImage(n), n2, n3, n2 + n6, n3 + n7, n4, n5, n6 + n4, n5 + n7, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void drawScaledRotateImage(int n, int n2, int n3, int n4, int n5, double d) {
        double d2 = (double)this.getImageWidth(n) / 2.0;
        double d3 = (double)this.getImageHeight(n) / 2.0;
        this.drawScaledRotateImage(n, n2, n3, n4, n5, d, d2, d3);
    }

    public void drawScaledRotateImage(int n, int n2, int n3, int n4, int n5, double d, double d2, double d3) {
        Image image = this.imageManager.getImage(n);
        if (image == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.graphics;
        this.tr.setToIdentity();
        this.tr.translate(n2, n3);
        this.tr.rotate(d * Math.PI / 360.0);
        this.tr.translate(-(d2 *= (double)n4 / 100.0), -(d3 *= (double)n5 / 100.0));
        this.tr.scale((double)n4 / 100.0, (double)n5 / 100.0);
        graphics2D.drawImage(image, this.tr, null);
    }

    public int getImageWidth(int n) {
        return this.imageManager.getPicXsize(n);
    }

    public int getImageHeight(int n) {
        return this.imageManager.getPicYsize(n);
    }

    public void setSeed(int n) {
        this.rand.setSeed(n);
    }

    public int rand(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return -1;
        }
        int n3 = this.rand.nextInt();
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n < n2) {
            n2 = n2 - n + 1;
            return n3 % n2 + n;
        }
        n = n - n2 + 1;
        return n3 % n + n2;
    }

    public void resetGame() {
        this.stopBGM();
        this.stopSE();
        this.graphics.translate(0, 0);
    }

    public void resetGameInstance(GameInterface gameInterface) {
        if (this.game != null) {
            this.game.finalGame();
        }
        if (gameInterface != null) {
            gameInterface.initGame();
        }
        this.game = gameInterface;
    }

    public void updateMessage() {
        if (this.game != null) {
            this.game.updateGame();
            this.writeRecord();
        }
        this.bgmManager.update();
    }

    public void drawMessage() {
        if (this.game != null && this.graphics != null) {
            this.game.drawGame();
        }
    }

    public void clearScreen() {
        this.setColor(255, 255, 255);
        this.fillRect(0, 0, 640, 480);
    }

    public void exitApp() {
        this.game.finalGame();
        System.exit(0);
    }

    public boolean showYesNoDialog(String string) {
        return 0 == JOptionPane.showConfirmDialog(null, string, null, 0);
    }

    public String showInputDialog(String string, String string2) {
        return JOptionPane.showInputDialog(null, string, string2);
    }

    public void playBGM(int n) {
        this.playBGM(n, true);
    }

    public void playBGM(int n, boolean bl) {
        if (this.cur_bgm != n) {
            this.bgmManager.stopSound();
            this.bgmManager.playSound(n, bl);
        }
        this.cur_bgm = n;
    }

    public void changeBGMVolume(int n) {
        this.bgmManager.changeVolume(n);
    }

    public void stopBGM() {
        if (this.bgmManager != null) {
            this.bgmManager.stopSound();
        }
        this.cur_bgm = -1;
    }

    public void pauseBGM() {
        this.bgmManager.pauseSound();
        this.cur_bgm = -1;
    }

    public void playSE(int n) {
        this.playSE(n, false);
    }

    public void playSE(int n, boolean bl) {
        this.seManager.playSound(n, bl);
    }

    public void changeSEVolume(int n) {
        this.seManager.changeVolume(n);
    }

    public void stopSE() {
        this.seManager.stopSound();
    }

    public void pauseSE() {
        this.seManager.pauseSound();
    }

    public int getKeyPressLength(int n) {
        return this.inputManager.getKeyPressLength(n);
    }

    public boolean isKeyPress(int n) {
        return this.inputManager.isKeyPressed(n);
    }

    public boolean isKeyPushed(int n) {
        return this.inputManager.isKeyPushed(n);
    }

    public boolean isKeyReleased(int n) {
        return this.inputManager.isKeyReleased(n);
    }

    public int getMouseX() {
        return this.inputManager.getMouseX();
    }

    public int getMouseY() {
        return this.inputManager.getMouseY();
    }

    public int getMouseClickLength() {
        return this.inputManager.getMouseClickLength();
    }

    public boolean isMousePushed() {
        return this.inputManager.isMousePushed();
    }

    public boolean isMouseReleased() {
        return this.inputManager.isMouseReleased();
    }

    public boolean isMousePress() {
        return this.inputManager.isMousePress();
    }

    private void writeRecord() {
        this.savedataManager.writeRecord();
    }

    private void readRecord() {
        this.savedataManager.readRecord();
    }

    public int load(int n) {
        return this.savedataManager.load(n);
    }

    public void save(int n, int n2) {
        this.savedataManager.save(n, n2);
    }

    public boolean checkHitRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return Collision.checkHitRect(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public boolean checkHitImage(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.checkHitRect(n2, n3, this.getImageWidth(n), this.getImageHeight(n), n5, n6, this.getImageWidth(n4), this.getImageHeight(n4));
    }

    public boolean checkHitCircle(int n, int n2, int n3, int n4, int n5, int n6) {
        return Collision.checkHitCircle(n, n2, n3, n4, n5, n6);
    }

    public double sqrt(double d) {
        return Math.sqrt(d);
    }

    public double cos(double d) {
        return Math.cos(d * Math.PI / 180.0);
    }

    public double sin(double d) {
        return Math.sin(d * Math.PI / 180.0);
    }

    public double atan2(double d, double d2) {
        return Math.atan2(d, d2) * 180.0 / Math.PI;
    }

    private void setImageManager(ImageManager imageManager) {
        this.imageManager = imageManager;
    }

    private void setSEManager(SoundManagerInterface soundManagerInterface) {
        if (this.seManager != null) {
            this.seManager.stopSound();
        }
        this.seManager = soundManagerInterface;
    }

    private void setBGMManager(SoundManagerInterface soundManagerInterface) {
        this.stopBGM();
        this.bgmManager = soundManagerInterface;
    }
}

