/*
 * Decompiled with CFR 0.152.
 */
import com.j_phone.amuse.Phrase;
import com.j_phone.amuse.PhrasePlayer;
import com.j_phone.amuse.PhraseTrack;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Game
extends MIDlet
implements CommandListener,
Runnable {
    public static final int MSECS_PER_TICK = 20;
    public static Game instance;
    public GameCanvas canvas;
    public Vector objects = new Vector();
    public Player player;
    public Background background;
    public Image ball_img;
    public int n_players;
    public int score;
    public int high_score = 0;
    public boolean game_break;
    private Command resetCommand = new Command("Reset", 1, 2);
    private Command exitCommand = new Command("Exit", 1, 1);
    private Vector removing_objects = new Vector();
    public PhraseTrack[] sound = new PhraseTrack[4];
    Coroutine main_coroutine;

    public Game() {
        instance = this;
        try {
            this.ball_img = Image.createImage((String)"/ball.png");
        }
        catch (IOException iOException) {
            System.out.println("Cannnot read png");
        }
        try {
            PhrasePlayer phrasePlayer = PhrasePlayer.getPlayer();
            Phrase phrase = new Phrase("resource:bgm.spf");
            this.sound[0] = phrasePlayer.getTrack();
            this.sound[0].setPhrase(phrase);
            Phrase phrase2 = new Phrase("resource:Gun3.spf");
            this.sound[1] = phrasePlayer.getTrack();
            this.sound[1].setPhrase(phrase2);
            Phrase phrase3 = new Phrase("resource:Click10.spf");
            this.sound[2] = phrasePlayer.getTrack();
            this.sound[2].setPhrase(phrase3);
            Phrase phrase4 = new Phrase("resource:Hit4.spf");
            this.sound[3] = phrasePlayer.getTrack();
            this.sound[3].setPhrase(phrase4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.canvas = new GameCanvas(this);
        this.canvas.addCommand(this.exitCommand);
        this.canvas.addCommand(this.resetCommand);
        this.canvas.setCommandListener(this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
    }

    public void startApp() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.resetCommand) {
            this.initGame();
        } else if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        this.initGame();
        try {
            while (true) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.updateGame();
                this.canvas.repaint();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void initGame() {
        this.n_players = 5;
        this.score = 0;
        this.loadHighScore();
        this.game_break = false;
        this.objects.removeAllElements();
        this.removing_objects.removeAllElements();
        this.background = new Background();
        this.player = new Player();
        this.add_object(new Title());
        this.sound[0].stop();
        this.sound[0].play(0);
    }

    public synchronized void updateGame() {
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            ((GameObject)enumeration.nextElement()).update();
            if (this.game_break) break;
        }
        this.game_break = false;
        Enumeration enumeration2 = this.removing_objects.elements();
        while (enumeration2.hasMoreElements()) {
            GameObject gameObject = (GameObject)enumeration2.nextElement();
            this.objects.removeElement(gameObject);
            gameObject.on_removed();
        }
        this.removing_objects.removeAllElements();
    }

    public void gameover(String string) {
        this.game_break = true;
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            this.remove_object((GameObject)enumeration.nextElement());
        }
        if (this.score > this.high_score) {
            this.high_score = this.score;
            this.saveHighScore();
        }
        this.add_object(new GameOver(string));
    }

    public void saveHighScore() {
        if (this.high_score > 999999) {
            this.high_score = 999999;
        }
        if (this.high_score < 0) {
            this.high_score = 0;
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"hs", (boolean)true);
            byte[] byArray = new byte[200];
            byArray[0] = (byte)(this.high_score % 100);
            byArray[1] = (byte)(this.high_score / 100 % 100);
            byArray[2] = (byte)(this.high_score / 10000 % 100);
            recordStore.setRecord(1, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public void loadHighScore() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"hs", (boolean)true);
            byte[] byArray = new byte[200];
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                byArray = recordStore.getRecord(1);
                this.high_score = byArray[0] + byArray[1] * 100 + byArray[2] * 10000;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public void add_object(GameObject gameObject) {
        this.objects.addElement(gameObject);
    }

    public void remove_object(GameObject gameObject) {
        this.removing_objects.addElement(gameObject);
    }
}

