/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player
extends GameObject {
    private Image img;
    public int r;
    public int x;
    public int y;
    private int min_x;
    private int max_x;
    private int min_y;
    private int max_y;
    private int fire_wait = 3;
    private int muteki_jikan = 0;

    public Player() {
        this.img = Game.instance.ball_img;
        this.r = this.img.getWidth() / 2;
        this.min_x = 0 + this.r;
        this.min_y = 0 + this.r;
        this.max_x = this.canvas.getWidth() - this.r;
        this.max_y = this.canvas.getHeight() - this.r;
        this.x = (this.min_x + this.max_x) / 2;
        this.y = this.max_y;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
        if (this.x < this.min_x) {
            this.x = this.min_x;
        } else if (this.x > this.max_x) {
            this.x = this.max_x;
        }
        if (this.y < this.min_y) {
            this.y = this.min_y;
        } else if (this.y > this.max_y) {
            this.y = this.max_y;
        }
    }

    public void update() {
        GameObject gameObject;
        this.move(this.canvas.dx(), this.canvas.dy());
        --this.fire_wait;
        if (this.fire_wait <= 0) {
            int n = -90 + MyMath.rand(-15, 15);
            gameObject = new SimpleBullet(this.x, this.y, n);
            this.game.objects.addElement(gameObject);
            this.fire_wait = 3;
        }
        Enumeration enumeration = this.game.objects.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            int n3;
            GameObject gameObject2;
            gameObject = (GameObject)enumeration.nextElement();
            if (gameObject instanceof Bullet) {
                gameObject2 = (Bullet)gameObject;
                n3 = this.r / 2;
                if (!gameObject2.is_enemy_bullet) continue;
                n2 = gameObject2.x - this.x;
                n = gameObject2.y - this.y;
                int n4 = gameObject2.r + n3;
                if ((n2 *= n2) + (n *= n) < (n4 *= n4)) {
                    this.game.remove_object(gameObject2);
                    this.hit();
                }
            }
            if (!(gameObject instanceof ScoreItem)) continue;
            gameObject2 = (ScoreItem)gameObject;
            n3 = ((ScoreItem)gameObject2).x - this.x;
            n2 = ((ScoreItem)gameObject2).y - this.y;
            n = ((ScoreItem)gameObject2).r + this.r;
            if ((n3 *= n3) + (n2 *= n2) >= (n *= n)) continue;
            this.game.remove_object(gameObject2);
            this.game.score += ((ScoreItem)gameObject2).score;
            this.game.sound[2].play(1);
        }
        if (this.muteki_jikan > 0) {
            --this.muteki_jikan;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.muteki_jikan > 0) {
            n = this.r + 2;
            graphics.setColor(65535);
            graphics.fillArc(this.x - n, this.y - n, n * 2, n * 2, 0, 360);
        }
        graphics.drawImage(this.img, this.x, this.y, 1 | 2);
        n = 0;
        while (n < this.game.n_players) {
            graphics.drawImage(this.img, 2 + n * (this.img.getWidth() + 2), 2, 4 | 0x10);
            ++n;
        }
        graphics.setColor(0);
        graphics.drawString("Score:" + this.game.score, 2, this.img.getHeight() + 4, 0x10 | 4);
    }

    private void hit() {
        if (this.muteki_jikan <= 0) {
            this.game.add_object(new Explosion(this.x, this.y));
            this.game.sound[3].play(1);
            if (this.game.n_players == 0) {
                this.game.gameover("GAME OVER");
            } else {
                --this.game.n_players;
                this.muteki_jikan = 100;
            }
        }
    }
}

