/*
 * Decompiled with CFR 0.152.
 */
package gameCanvasUtil;

import gameCanvasUtil.saveDataUtil;
import gameCanvasUtil.soundManagerInterface;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;

public class midiManager
implements soundManagerInterface {
    private String fileName;
    private Sequencer[] sequencer;
    private Synthesizer synthesizer = null;
    private boolean[] loop_flag;
    private int[] volume;
    private static final int MIDI_MAX_NUM = 64;
    private static final int CHANGE_VOLUME = 7;
    public static final int NUMBER_AUTO_CULC = -1;
    public static final int READ_LIST_FROM_TEXT = -2;

    public midiManager(String string, int n) {
        this.fileName = string;
        if (n == -1) {
            this.sequencer = new Sequencer[64];
            this.loop_flag = new boolean[64];
            this.volume = new int[64];
            this.loadNumberingMidi(false);
        } else if (n == -2) {
            String[] stringArray = saveDataUtil.readResourceStrings(string);
            this.sequencer = new Sequencer[stringArray.length];
            this.loop_flag = new boolean[stringArray.length];
            this.volume = new int[n];
            for (int i = 0; i < stringArray.length; ++i) {
                this.sequencer[i] = this.loadMidi(stringArray[i]);
            }
        } else {
            this.sequencer = new Sequencer[n];
            this.loop_flag = new boolean[n];
            this.volume = new int[n];
            this.loadNumberingMidi(true);
        }
        this.initSynthesizer();
    }

    private void loadNumberingMidi(boolean bl) {
        for (int i = 0; i < 64; ++i) {
            this.sequencer[i] = this.loadMidi(this.fileName + i + ".mid");
            if (this.sequencer[i] == null && !bl) break;
        }
    }

    private Sequencer loadMidi(String string) {
        try {
            Sequencer sequencer = MidiSystem.getSequencer();
            sequencer.open();
            InputStream inputStream = null;
            inputStream = this.getClass().getResourceAsStream("/" + string);
            Sequence sequence = MidiSystem.getSequence(inputStream);
            sequencer.setSequence(sequence);
            inputStream.close();
            return sequencer;
        }
        catch (Exception exception) {
            System.out.println("loadMidi " + string + " " + exception);
            return null;
        }
    }

    public void playSound(int n, boolean bl) {
        try {
            this.loop_flag[n] = bl;
            this.sequencer[n].start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pauseSound(int n) {
        try {
            if (this.sequencer[n] != null) {
                this.sequencer[n].stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopSound(int n) {
        try {
            if (this.sequencer[n] != null) {
                this.sequencer[n].stop();
                this.sequencer[n].setTickPosition(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changeVolume(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 127) {
            n2 = 127;
        }
        this.volume[n] = n2 * 127 / 100;
    }

    private void setVolume(int n, int n2) {
        block9: {
            if (this.sequencer[n] == null) {
                return;
            }
            int n3 = n2;
            try {
                if (this.synthesizer.getDefaultSoundbank() == null) {
                    try {
                        ShortMessage shortMessage = new ShortMessage();
                        for (int i = 0; i < 16; ++i) {
                            shortMessage.setMessage(176, i, 7, n3);
                            MidiSystem.getReceiver().send(shortMessage, -1L);
                        }
                        break block9;
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                        System.err.println("Invalid MIDI data.");
                        return;
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        System.err.println("MIDI unavailable.");
                        return;
                    }
                }
                MidiChannel[] midiChannelArray = this.synthesizer.getChannels();
                for (int i = 0; midiChannelArray != null && i < midiChannelArray.length; ++i) {
                    midiChannelArray[i].controlChange(7, n3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void update() {
        for (int i = 0; i < this.sequencer.length; ++i) {
            try {
                this.setVolume(i, this.volume[i]);
                if (this.sequencer[i] == null || this.sequencer[i].getTickLength() > this.sequencer[i].getTickPosition()) continue;
                this.sequencer[i].stop();
                this.sequencer[i].setTickPosition(0L);
                this.sequencer[i].start();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void pauseSound() {
        for (int i = 0; i < this.sequencer.length; ++i) {
            this.pauseSound(i);
        }
    }

    public void stopSound() {
        for (int i = 0; i < this.sequencer.length; ++i) {
            this.stopSound(i);
        }
    }

    public void changeVolume(int n) {
        for (int i = 0; i < this.sequencer.length; ++i) {
            this.changeVolume(i, n);
        }
    }

    private void initSynthesizer() {
        try {
            if (!(this.sequencer[0] instanceof Synthesizer)) {
                this.synthesizer = MidiSystem.getSynthesizer();
                this.synthesizer.open();
                if (this.synthesizer.getDefaultSoundbank() == null) {
                    for (int i = 0; i < this.sequencer.length; ++i) {
                        this.sequencer[i].getTransmitter().setReceiver(MidiSystem.getReceiver());
                    }
                } else {
                    for (int i = 0; i < this.sequencer.length; ++i) {
                        this.sequencer[i].getTransmitter().setReceiver(this.synthesizer.getReceiver());
                    }
                }
            } else {
                this.synthesizer = (Synthesizer)((Object)this.sequencer[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

