//インポート
import gameCanvasUtil.*;
import debugger.*;

/** ゲームクラス。
 *
 * 学生が編集すべきソースコードです。
 */
public class game extends gameBase
{
    /********* 変数定義はこちらに *********/
    // 型 変数名;　の順に書いて定義する
    // ボールのX座標
    int[] ball_x = new int[3];
    // ボールのY座標
    int[] ball_y = new int[3];
    // ボールのX方向の速度
    int[] ball_speed_x = new int[3];
    // ボールのY方向の速度
    int[] ball_speed_y = new int[3];

    /********* 初期化の手順はこちらに *********/
    public void initGame()
    {
        for(int i=0; i<3; i=i+1)
        {
            // ボールの座標を初期化する
            ball_x[i] = 100 * i;
            ball_y[i] = 100;
            // ボールの速度を初期化する
            ball_speed_x[i] = 5;
            ball_speed_y[i] = 5;
        }
    }

    /********* 物体の移動等の更新処理はこちらに *********/
    public void updateGame()
    {
        for(int i=0; i<3; i=i+1)
        {
            // Y方向に ball_speed_y ずつ進める
            ball_y[i] = ball_y[i] + ball_speed_y[i];

            // X方向に ball_speed_x ずつ進める
            ball_x[i] = ball_x[i] + ball_speed_x[i];

            // ボールが画面の上を越えるか、画面の下を越えた場合
            if(ball_y[i] < 0 || ball_y[i] > 456)
            {
                // ボールのY方向の速度を反転させる
                ball_speed_y[i] = -ball_speed_y[i];
            }

            // ボールが画面の右を越えるか、画面の左を越えた場合
            if(ball_x[i] > 616 || ball_x[i] < 0)
            {
                // ボールのX方向の速度を反転させる
                ball_speed_x[i] = -ball_speed_x[i];
            }
        }
    }

    /********* 画像の描画はこちらに *********/
    public void drawGame()
    {
        // 画面を白で塗りつぶします
        gc.clearScreen();

        // img0.png を描画します
        for(int i=0; i<3; i=i+1)
        {
            gc.drawImage(0, ball_x[i], ball_y[i]);
        }
    }

    /********* 終了時の処理はこちらに *********/
    public void finalGame() {}
}
